﻿// Copyright Dirk Lemstra https://github.com/dlemstra/Magick.NET.
// Licensed under the Apache License, Version 2.0.

namespace ImageMagick;

/// <summary>
/// Specifies the evaluate operator.
/// </summary>
public enum EvaluateOperator
{
    /// <summary>
    /// Undefined.
    /// </summary>
    Undefined,

    /// <summary>
    /// Abs.
    /// </summary>
    Abs,

    /// <summary>
    /// Add.
    /// </summary>
    Add,

    /// <summary>
    /// Add modulus.
    /// </summary>
    AddModulus,

    /// <summary>
    /// And.
    /// </summary>
    And,

    /// <summary>
    /// Cosine.
    /// </summary>
    Cosine,

    /// <summary>
    /// Divide.
    /// </summary>
    Divide,

    /// <summary>
    /// Exponential.
    /// </summary>
    Exponential,

    /// <summary>
    /// Gaussian noise.
    /// </summary>
    GaussianNoise,

    /// <summary>
    /// Impulse noise.
    /// </summary>
    ImpulseNoise,

    /// <summary>
    /// Laplacian noise.
    /// </summary>
    LaplacianNoise,

    /// <summary>
    /// Left shift.
    /// </summary>
    LeftShift,

    /// <summary>
    /// Log.
    /// </summary>
    Log,

    /// <summary>
    /// Max.
    /// </summary>
    Max,

    /// <summary>
    /// Mean.
    /// </summary>
    Mean,

    /// <summary>
    /// Median.
    /// </summary>
    Median,

    /// <summary>
    /// Min.
    /// </summary>
    Min,

    /// <summary>
    /// Multiplicative noise.
    /// </summary>
    MultiplicativeNoise,

    /// <summary>
    /// Multiply.
    /// </summary>
    Multiply,

    /// <summary>
    /// Or.
    /// </summary>
    Or,

    /// <summary>
    /// Poisson noise.
    /// </summary>
    PoissonNoise,

    /// <summary>
    /// Pow.
    /// </summary>
    Pow,

    /// <summary>
    /// Right shift.
    /// </summary>
    RightShift,

    /// <summary>
    /// Root mean square.
    /// </summary>
    RootMeanSquare,

    /// <summary>
    /// Set.
    /// </summary>
    Set,

    /// <summary>
    /// Sine.
    /// </summary>
    Sine,

    /// <summary>
    /// Subtract.
    /// </summary>
    Subtract,

    /// <summary>
    /// Sum.
    /// </summary>
    Sum,

    /// <summary>
    /// Threshold black.
    /// </summary>
    ThresholdBlack,

    /// <summary>
    /// Threshold.
    /// </summary>
    Threshold,

    /// <summary>
    /// Threshold white.
    /// </summary>
    ThresholdWhite,

    /// <summary>
    /// Uniform noise.
    /// </summary>
    UniformNoise,

    /// <summary>
    /// Xor.
    /// </summary>
    Xor,

    /// <summary>
    /// Inverse log.
    /// </summary>
    InverseLog,
}
