﻿// Copyright Dirk Lemstra https://github.com/dlemstra/Magick.NET.
// Licensed under the Apache License, Version 2.0.

namespace ImageMagick;

/// <summary>
/// Specifies compression methods.
/// </summary>
public enum CompressionMethod
{
    /// <summary>
    /// Undefined.
    /// </summary>
    Undefined,

    /// <summary>
    /// B44A.
    /// </summary>
    B44A,

    /// <summary>
    /// B44.
    /// </summary>
    B44,

    /// <summary>
    /// BZip.
    /// </summary>
    BZip,

    /// <summary>
    /// DXT1.
    /// </summary>
    DXT1,

    /// <summary>
    /// DXT3.
    /// </summary>
    DXT3,

    /// <summary>
    /// DXT5.
    /// </summary>
    DXT5,

    /// <summary>
    /// Fax.
    /// </summary>
    Fax,

    /// <summary>
    /// Group4.
    /// </summary>
    Group4,

    /// <summary>
    /// JBIG1.
    /// </summary>
    JBIG1,

    /// <summary>
    /// JBIG2.
    /// </summary>
    JBIG2,

    /// <summary>
    /// JPEG2000.
    /// </summary>
    JPEG2000,

    /// <summary>
    /// JPEG.
    /// </summary>
    JPEG,

    /// <summary>
    /// Lossless JPEG.
    /// </summary>
    LosslessJPEG,

    /// <summary>
    /// LZMA.
    /// </summary>
    LZMA,

    /// <summary>
    /// LZW.
    /// </summary>
    LZW,

    /// <summary>
    /// No compression.
    /// </summary>
    NoCompression,

    /// <summary>
    /// Piz.
    /// </summary>
    Piz,

    /// <summary>
    /// Pxr24.
    /// </summary>
    Pxr24,

    /// <summary>
    /// RLE.
    /// </summary>
    RLE,

    /// <summary>
    /// Zip.
    /// </summary>
    Zip,

    /// <summary>
    /// ZipS.
    /// </summary>
    ZipS,

    /// <summary>
    /// Zstd.
    /// </summary>
    Zstd,

    /// <summary>
    /// WebP.
    /// </summary>
    WebP,

    /// <summary>
    /// DWAA.
    /// </summary>
    DWAA,

    /// <summary>
    /// DWAB.
    /// </summary>
    DWAB,

    /// <summary>
    /// BC7.
    /// </summary>
    BC7,

    /// <summary>
    /// BC5.
    /// </summary>
    BC5,

    /// <summary>
    /// LERC.
    /// </summary>
    LERC,
}
