unit Ntapi.WinError;

{
  This file defines commonly encountered Win32 error codes and HRESULT values.
}

interface

{$MINENUMSIZE 4}

uses
  Ntapi.WinNt, Ntapi.ntstatus;

const
  HRESULT_SEVERITY_MASK = $80000000;
  FACILITY_NT_BIT =       $10000000;
  FACILITY_MASK =         $07FF0000;
  WIN32_CODE_MASK =       $0000FFFF;

  FACILITY_SHIFT = 16;
  FACILITY_WIN32 = 7;
  FACILITY_WIN32_BITS = FACILITY_WIN32 shl FACILITY_SHIFT;
  WIN32_HRESULT_BITS = HRESULT_SEVERITY_MASK or FACILITY_WIN32_BITS;

  FACILITY_WIM = $142;

  ERROR_SUCCESS = 0;
  ERROR_PATH_NOT_FOUND = 3;
  ERROR_ACCESS_DENIED = 5;
  ERROR_NOT_ENOUGH_MEMORY = 8;
  ERROR_BAD_LENGTH = 24;
  ERROR_INVALID_PARAMETER = 87;
  ERROR_CALL_NOT_IMPLEMENTED = 120;
  ERROR_INSUFFICIENT_BUFFER = 122;
  ERROR_ALREADY_EXISTS = 183;
  ERROR_BAD_EXE_FORMAT = 193;
  ERROR_MORE_DATA = 234;
  ERROR_NO_MORE_ITEMS = 259;
  ERROR_MR_MID_NOT_FOUND = 317;
  ERROR_CANT_ENABLE_DENY_ONLY = 629;
  ERROR_NO_TOKEN = 1008;
  ERROR_CANCELLED = 1223;
  ERROR_IMPLEMENTATION_LIMIT = 1292;
  ERROR_NOT_ALL_ASSIGNED = 1300;
  ERROR_INVALID_OWNER = 1307;
  ERROR_INVALID_PRIMARY_GROUP = 1308;
  ERROR_CANT_DISABLE_MANDATORY = 1310;
  ERROR_PRIVILEGE_NOT_HELD = 1314;
  ERROR_BAD_IMPERSONATION_LEVEL = 1346;
  ERROR_TIMEOUT = 1460;
  APPMODEL_ERROR_PACKAGE_IDENTITY_CORRUPT = 15702;
  APPMODEL_ERROR_NO_APPLICATION = 15703;

  WAIT_TIMEOUT = STATUS_TIMEOUT;
  WAIT_IO_COMPLETION = STATUS_USER_APC;
  STILL_ACTIVE = STATUS_PENDING;
  WAIT_FAILED  = $FFFFFFFF;

  S_OK    = $00000000;
  S_FALSE = $00000001;
  S_FALSE_AS_ERROR = $C0000001;
  E_NOTIMPL = HResult($80004001);
  E_NOINTERFACE = HResult($80004002);
  E_INVALIDARG = HResult($80070057);
  E_UNEXPECTED = HResult($8000FFFF);

  RPC_E_CHANGED_MODE = HResult($80010106);
  DISP_E_EXCEPTION = HResult($80020009);

implementation

{$BOOLEVAL OFF}
{$IFOPT R+}{$DEFINE R+}{$ENDIF}
{$IFOPT Q+}{$DEFINE Q+}{$ENDIF}

end.
