
#include "test_cursor.h"
// #include "config.h"

/**
 * @addtogroup cursor_test
 * @{
 * @addtogroup cursor_type_set
 * @{
 * Cursor
 * <TABLE>
 * @}
 */

/**
 * @addtogroup cursor_type_set
 * @{
 * <tr>
 * <td>cursor_type_set</td>
 * <td>cursor_type_set_test_p</td>
 * <td>
 * @precondition
 * @step 1 initialize elementary library
 * @step 2 create a new Evas_Object.
 *
 * @procedure
 * @step 1 call cursor_type_set
 * </td>
 * <td>(Evas_Object *)obj, CURSOR_FLUER</td>
 * <td>EINA_TRUE</td>
 * </tr>
 * @}
 */
EFL_START_TEST(cursor_type_set_test_p)
{
   Evas_Object *obj;

   // elm_init(0,0);
   obj = elm_win_add(NULL, "test", ELM_WIN_BASIC);

   ck_assert_msg(cursor_type_set(obj, CURSOR_FLEUR),
                 "Can not set the cursor to given object");

   evas_object_del(obj);
   // elm_shutdown();
}
EFL_END_TEST

/**
 * @addtogroup cursor_type_set
 * @{
 * </TABLE>
 * @}
 * @}
 */

void cursor_type_set_test(TCase *tc)
{
   tcase_add_test(tc, cursor_type_set_test_p);
}
