# DesignHeaven :angel:

Stunning **free** design resources for designers and developer! Stop hitting your head down on a desk anymore :ok_hand:

<a href="https://mixkit.co/@supriyabhonsle/">
  <p align="center">
    <img src="assets/exhausted-man.png" width="100%">
  </p>
</a>

## Table of Contents

1. [Stock Images](#stock-images)
2. [Stock Videos](#stock-videos)
3. [Icons](#icons)
4. [Animated Icons](#animated-icons)
5. [Fonts](#fonts)
6. [Illustrations](#illustrations)
7. [Design Systems](#design-systems)
8. [Design Inspiration](#design-inspiration)
9. [Colors](#colors)
10. [Gradients](#gradients)
11. [Design Tools](#design-tools)
12. [Prototyping Tools](#prototyping-tools)
13. [Presentation Tools](#presentation-tools)
14. [Animation Tools](#animation-tools)
15. [Mockup Tools](#mockup-tools)
16. [Web Accessibility](#web-accessibility)
17. [UI kits](#ui-kits)
18. [User Flow Tools](#user-flow-tools)
19. [Creative Tools](#creative-tools)
20. [AI Tools](#ai-tools)

---

## Design Resources

### Stock Images

- **[Burst by Shopify](https://burst.shopify.com/)** - Download free, high-resolution images.
- **[Gratisography](https://gratisography.com/)** - The world's quirkiest collection of free high-resolution pictures you can use on your personal and commercial projects.
- **[Life of Pix](https://www.lifeofpix.com/)** - Free high resolution photography.
- **[Moose](https://photos.icons8.com/)** - A collection of stock photography in a single style. Good for collages. Free for commercial use.
- **[New Old Stock](http://nos.twnsnd.co/)** - Vintage photos from the public archives.
- **[Pexels](https://www.pexels.com)** - Free stock photos you can use everywhere.
- **[Pixabay](https://pixabay.com/)** - Over 1.6 million royalty free stock photos and videos shared by our generous community.
- **[reshot](https://www.reshot.com/)** - Handpicked, non-stocky images. Yours to use as you wish.
- **[StockSnap](https://stocksnap.io/)** - High quality and high resolution stock images free from all copyright restrictions(CC0).
- **[Unsplash](https://unsplash.com/)** - Beautiful, free images and photos that you can download and use for any project.

### Stock Videos

- **[Coverr](https://coverr.co/)** - Download royalty free (for personal and commercial use), unique and beautiful video footage for your website or any project.
- **[Life of Vids](https://www.lifeofvids.com/)** - Free videos for personal & commercial uses. New videos added weekly.
- **[Mixkit](https://mixkit.co/)** - Extraordinary HD videos for you to use, completely free of charge.
- **[Pexels Videos](https://www.pexels.com/videos/)** - The best free videos shared by the Pexels community.
- **[Videvo](https://www.videvo.net/)** - Free HD stock footage & motion graphics for any project.

### Icons

- **[Eva Icons](https://akveo.github.io/eva-icons/#/)** - Eva Icons is a pack of more than 480 beautifully crafted Open Source icons for common actions and items.
- **[Evericons](http://www.evericons.com)** - Evericons is a collection of 460+ well-crafted icons for your next project.
- **[Feather icons](https://feathericons.com/)** - Feather is a collection of simply beautiful open source icons. Each icon is designed on a 24x24 grid with an emphasis on simplicity, consistency and readability.
- **[Flaticon](https://www.flaticon.com)** - The largest database of free icons available in PNG, SVG, EPS, PSD and BASE 64 formats.
- **[Font Awesome](https://fontawesome.com/)** - Get vector icons and social logos on your website with Font Awesome, the web's most popular icon set and toolkit.
- **[Grommet Icons](https://icons.grommet.io/)** - Iconography for Grommet and React.js
- **[IconBros](https://www.iconbros.com/)** - 1227+ free icons grouped in 38 collections.
- **[iconmonstr](https://iconmonstr.com/)** - Discover 4432+ free icons in 307 collections
- **[Icons8](https://icons8.com/icons)** - Get free icons designed to combine perfectly and fit into the style of your design.
- **[Ionicons](https://ionicons.com/)** - Premium designed icons for use in web, iOS, Android, and desktop apps. Support for SVG and web font. Completely open source, MIT licensed and built by the Ionic Framework team.
- **[Ikonate](https://www.ikonate.com/)** - Fully customisable & accessible vector icons
- **[Material Design icons](https://materialdesignicons.com/)** - Material Design Icons' growing icon collection allows designers and developers targeting various platforms to download icons in the format, color and size they need for any project.
- **[Milk Icons](https://milkicons.com)** - 1,000 free icons for startups.
- **[Myicons](https://myicons.co/)** - 1800 Premium high quality line icons for professional website & apps.
- **[Nucleo app](https://nucleoapp.com/)** - Nucleo is a beautiful library of 26831 icons, and a powerful application to collect, customize and export all your icons.
- **[Οutlane](https://outlane.co/graphics/animated-svg-icons-pack/)** - The pack includes 100 hand-crafted animated vector icons that you can use on any website or app.
- **[Potlab Icons](http://www.potlabicons.com)** - Animated SVG icons for web projects.
- **[Remix Icons](https://remixicon.com/)** - Remix Icon is a set of open-source neutral-style system symbols elaborately crafted for designers and developers.
- **[Slice](https://slice.design/glyphs)** - Various Perfectly Shaped Glyphs.
- **[Streamline 3.0](https://streamlineicons.com)** - Over 10.500 in three different weight.
- **[The Noun Project](https://thenounproject.com/)** - Over 2 Million curated icons, created by a global community.
- **[Tilda Icons](https://tilda.cc/free-icons/)** - Free icons for landing pages
- **[Unicons](https://iconscout.com/unicons)** - 1000+ Pixel-perfect vector icons and Iconfont for your next project.
- **[Zwicon](https://www.zwicon.com)** - Handcrafted iconset for your next project.

### Animated Icons

- **[Animated Icons by Icon8](https://icons8.com/animated-icons)** - A free pack of 166 animated icons in JSON (Lottie), GIF, and After Effects formats.
- **[Animaticons](http://animaticons.co/)** - Beautiful, customizable animated GIF icons.
- **[useAnimations](https://useanimations.com)** - Animated icons in Lottie Framework and After Effects for immediate implementation to your apps or websites.

### Fonts

- **[1001FreeFonts](https://www.1001freefonts.com/)** - Download 41882 fonts in 21841 families for Windows, Mac and Linux. 1001 Free Fonts offers a huge selection of free fonts. New fonts are added daily.
- **[Aleo](https://www.behance.net/gallery/8018673/ALEO-Free-Font-Family)** - Free contemporary slab serif typeface.
- **[Archetype](https://archetypeapp.com/)** - Archetype makes beautiful web typography designs quick and easy to create.
- **[Behance](https://www.behance.net/search?content=projects&sort=appreciations&time=week&search=free%20font)** - Behance is a network of sites and services specializing in self-promotion, including consulting, online portfolio sites and many free font resources. All you have to do is to add some clever search filters, such as 'free font'.
- **[Clear Sans](https://01.org/clear-SANS)** - Clear Sans has been recognized as a versatile OpenType font for screen, print, and Web.
- **[Cooper Hewitt](https://www.cooperhewitt.org/open-source-at-cooper-hewitt/cooper-hewitt-the-typeface-by-chester-jenkins/)** - The Typeface created by Chester Jenkins.
- **[Dafont](https://www.dafont.com/)** - Archive of freely downloadable fonts. Browse by alphabetical listing, by style, by author or by popularity.
- **[FontPair](https://fontpair.co/)** - Font Pair helps designers pair Google Fonts together. Beautiful Google Font combinations and pairs.
- **[FontSpark](https://fontspark.app/)** - Helping designers discover the perfect font for their next design project.
- **[FontSquirrel](https://www.fontsquirrel.com/)** - Font Squirrel scours the internet for high quality, legitimately free fonts.
- **[Inter Font Family](https://rsms.me/inter/)** - Inter is a typeface specially designed for user interfaces.
- **[Google Fonts](https://fonts.google.com/)** - Google Fonts is a library of 900 libre licensed fonts, an interactive web directory for browsing the library, and APIs for conveniently using the fonts via CSS and Android.
- **[Google Noto Font](https://www.google.com/get/noto/)** - Beautiful and free fonts for all languages.
- **[Leon Sans](https://leon-kim.com/)** - Leon Sans is a geometric sans-serif typeface made with code in 2019 by Jongmin Kim.
- **[Optician Sans](https://optician-sans.com)** - A free font based on the historical eye charts and optotypes used by opticians world wide.
- **[Picas](https://picas.now.sh/)** - Generate Project Logo with Google Fonts
- **[Type-Scale](https://type-scale.com/)** - Preview and choose the right type scale for your project.
- **[Typewolf](https://www.typewolf.com/)** - Typewolf helps designers choose the perfect font combination for their next design project
- **[Variable Fonts](https://colordesigner.io/)** - A simple resource for finding and trying variable fonts.

### Illustrations

- **[Absurb](https://absurd.design/)** - What about surrealist illustrations for landing pages? Take every user on an individual journey through their own imagination.
- **[Avataaars](https://getavataaars.com/)** - Mix and match avatar illustrations. Combine clothes, hair, emotions, accessories, and colors.
- **[Blobmaker](https://www.blobmaker.app/)** - Create organic svg shapes in just a few seconds.
- **[Charco](https://www.karthiksrinivas.in/charco)** - A set of 16 handcrafted illustrations for your web & app projects by Karthik Srinivas.
- **[Delesign](https://delesign.com/free-designs/graphics/)** - Use our royalty-free designs for your website, social media, blog, email newsletters, and more.
- **[DrawKit](https://www.drawkit.io/)** - DrawKit is a collection of free, beautiful, customisable MIT licensed SVG illustrations in two styles
- **[FreePik](https://www.freepik.com/)** - More than 3 millions free vectors, PSD, photos and free icons.
- **[Fresh Folk](http://fresh-folk.com/)** - An illustration library of people and objects
- **[Freellustrations](https://freellustrations.com/)** - Download Free illustrations and vector images for website backgrounds and landing pages.
- **[IRA Design](https://iradesign.io/)** - With IRA Design, you can create amazing illustrations, using hand-drawn sketch components, a cool selection of 5 gradients and ai., svg. or png. formats.
- **[Isometric](https://isometric.online/)** - Free isometric illustrations for designers, startups and companies
- **[Isometric Love](https://www.isometriclove.com/)** - Cute isometric objects for your design.
- **[Humaaans](https://www.humaaans.com/)** - Mix-&-match illustrations of people with a design library.
- **[Glaze Illustrations](https://www.glazestock.com)** - Free illustrations, for everything
- **[Lukasz Adam](https://lukaszadam.com/illustrations)** - Free vector art illustrations and icons. Available for personal and commercial use.
- **[ManyPixels](https://gallery.manypixels.co/)** - Each week, discover royalty-free illustrations to power up your projects.
- **[Mixkit](https://mixkit.co/)** - Mixkit is a curated gallery of high-quality videos and art, made by some of the world’s most talented creators, with all content licensed for free.
- **[Open Doodles](https://www.opendoodles.com/)** - Free sketchy illustrations by Pablo Stanley.
- **[Ouch](https://icons8.com/ouch)** - Free illustrations to class up your project.
- **[Scribbbles](https://www.scribbbles.design/)** - 100+ vectorized scribbbles to spice up your design projects.
- **[Stubborn Generator](https://stubborn.fun/)** - Stubborn Generator is a collection of 25 incredibly cool characters.
- **[Undraw](http://undraw.co/)** - Open-source illustrations for every project you can imagine and create.
- **[Wireframer](https://wireframer.art/)** - Flawless SVG content blocks for your wireframes.
- **[404 Illustrations](https://www.kapwing.com/404-illustrations)** - Trendy, ready to use images for your 404 page

### Design Systems

- **[Ant Design](https://ant.design/)** by [Alibaba](https://www.alibaba.com/) - An enterprise-class UI design language and React implementation.
- **[Atlaskit](https://atlaskit.atlassian.com/)** by [Atlassian](https://atlassian.com/) - Atlassian's official UI library, built according to the Atlassian Design Guidelines.
- **[Audi Design](https://www.audi.com/ci/en/guides/user-interface/introduction.html)** by [Audi](https://www.audi.com/en.html) - Audi user interfaces are as varied as their uses – ranging from inspiring websites to applications for a particular service.
- **[Backpack](https://backpack.github.io/)** by [Skyscanner](https://www.skyscanner.net/) - Backpack is a collection of design resources, reusable components and guidelines for creating Skyscanner products.
- **[Grommet](https://v2.grommet.io/)** by [HP Enterprise](https://www.hpe.com/emea_europe/en/home.html) - Build responsive and accessible mobile-first projects for the web with an easy to use component library.
- **[IBM Carbon](https://www.carbondesignsystem.com/)** by [IBM Cloud products](https://www.ibm.com/cloud/products) - The Carbon Design System is IBM’s open-source design system for products and experiences.
- **[Lightning](https://www.lightningdesignsystem.com/)** by [SalesForce](https://www.salesforce.com/eu/) - Create the world’s best enterprise app experiences.
- **[Mailchimp Patterns](https://ux.mailchimp.com/patterns)** by [Mailchimp](https://mailchimp.com/) - UX patterns by the Mailchimp design team.
- **[Material UI](https://material-ui.com/)** by [Google](https://www.google.com/) - React components that implement Google's Material Design.
- **[Nachos](https://design.trello.com/)** by [Trello](https://trello.com/) - Nachos is Trello's design system (and also our favorite snack).
- **[Plasma](http://plasma.guide/)** by [WeWork](https://www.wework.com/) - Plasma is a design system for creating sensible, modern interfaces.
- **[Pluralsight](https://design-system.pluralsight.com/)** by [Pluralsight](https://www.pluralsight.com/) - The UI building blocks for creating a cohesive design across Pluralsight products
- **[Polaris](https://polaris.shopify.com/)** by [Shopify](https://www.shopify.com/) - Our design system helps us work together to build a great experience for all of Shopify’s merchants.
- **[Primer](https://primer.style/)** by [Github](https://github.com/) - Resources, tooling, and design guidelines for building interfaces with GitHub’s design system.

For more, [click here](http://repository.design/) or [hit this](https://designsystemsrepo.com/).

### Design Inspiration

- **[Abduzeedo](https://abduzeedo.com/tags/daily-inspiration)** - The most interesting designs/artworks/concepts curated by Abduzeedo's team to utterly inspire your day.
- **[awwwards.](https://www.awwwards.com/)** - Awwwards are the Website Awards that recognize and promote the talent and effort of the best developers, designers and web agencies in the world.
- **[Behance](https://www.behance.net/)** - Showcase and discover the latest work from top online portfolios by creative professionals across industries.
- **[CallToIdea](https://www.calltoidea.com/)** - Calltoidea is the unique place where you can find inspiration. A great tool created by a designer for web professionals.
- **[CSS Design Awards](https://www.cssdesignawards.com)** - A web design & development award platform for digital folk, UI/UX peeps and inspiring leaders of the web.
- **[DesignMunk](https://designmunk.com/)** - The ultimate hand picked landing page inspirations from around the web.
- **[Deviant Art](https://www.deviantart.com)** - DeviantArt is the world's largest online social community for artists and art enthusiasts, allowing people to connect through the creation and sharing of art.
- **[Dribbble](https://dribbble.com/)** - Dribbble is the leading destination to find & showcase creative work and home to the world's best design professionals.
- **[h69](https://www.h69.design/)** - Landing page colletions & Free resources for designers.
- **[Httpster](https://httpster.net)** - Httpster is an inspiration resource showcasing totally rocking websites made by people from all over the world.
- **[Hyperpixel](https://hyperpixel.io/)** - Discover the latest designs for your own inspiration from our curated list of landing pages.
- **[Inspirationde](https://www.inspirationde.com/)** - Inspirationde is an online source of design inspiration, photography, interior, web design, UI and UX, digital art, illustration, graphic design and much more.
- **[Land-Book](https://land-book.com/)** - We collect awesome websites to help creatives find inspiration & motivation to do rad stuff.
- **[Lapa Ninja](https://www.lapa.ninja/)** - The best landing page design inspiration from around the web.
- **[Muzli](https://muz.li/)** - Muzli is a new-tab Chrome extension that instantly delivers relevant design stories and inspiration.
- **[OnePageLove](https://onepagelove.com/)** - One Page Love is a One Page website design gallery showcasing the best Single Page websites, templates and resources.
- **[Pttrns](https://pttrns.com/)** - Pttrns is the finest collection of mobile design patterns, resources and inspiration.
- **[The FWA](https://thefwa.com/)** - Showcasing innovation every day since 2000.
- **[UI Garage](https://uigarage.net)** - Daily handpicked UI inspiration & patterns.
- **[UI Movement](https://uimovement.com/)** - The best UI design inspiration, every day.
- **[Webframe](https://webframe.xyz/)** - Discover and be inspired by beautiful webapp designs

### Colors

- **[Accessible Color Matrix](https://toolness.github.io/accessible-color-matrix/)** - A tool to help designers build color palettes with combinations that conform with accessibility standards.
- **[Color.review](https://color.review/)** - A modern tool for exploring and finding accessible colors.
- **[Colorable](https://colors.muz.li/)** - Color combination contrast tester.
- **[Colorbook](https://www.colorbook.io/)** - Your hex color information and conversion source. We at colorbook have one mission: we want to give each color its place. Think of it as of a facebook of colors.
- **[ColorBox](https://www.colorbox.io/)** - Colorbox is a color tool to produce color sets.
- **[Color-hex](https://www.color-hex.com/color-palettes/)** - Color-hex gives information about colors including color models (RGB,HSL,HSV and CMYK).
- **[Color Designer](https://colordesigner.io/)** - Just pick a color, and the app does the rest.
- **[Color Hunt](https://colorhunt.co/)** - Color Hunt is a free and open platform for color inspiration with thousands of trendy hand-picked color palettes.
- **[Colorinspire](https://colorinspire.webflow.io/)** - Curated color inspiration. Free to use for your next project.
- **[Color Lisa](http://www.colorlisa.com/)** - Color palette masterpieces from the world's greatest artists.
- **[Color Quote](https://www.felixjoy.co/colorquote#color-hero)** - Daily dose of color combination and inspirational quote cards for designers and developers.
- **[Color Safe](http://colorsafe.co/)** - Empowering designers with beautiful and accessible color palettes based on WCAG Guidelines of text and background contrast ratios.
- **[Color Space](https://mycolor.space/)** - Build beautiful color palettes by entering just one color.
- **[Color Tool](https://material.io/tools/color/)** - Create, share, and apply color palettes to your UI, as well as measure the accessibility level of any color combination.
- **[Colors by Eva Design System](https://colors.eva.design/)** - Generate color pallets using deep learning powered algorithm.
- **[Colors by Klart](https://klart.io/colors/)** - Colors is a 100% data-driven collection of color palettes.
- **[CopyPalette](https://copypalette.netlify.com)** - Hassle-free export your palette to SVG format
- **[Culrs](https://culrs.com/)** - Colors that work together are curated and fashioned into quality palettes that you can incorporate.
- **[Flat UI Colors](https://flatuicolors.com/)** - 280 handpicked colors ready for COPY & PASTE.
- **[HappyHues](https://www.happyhues.co/)** - Curated colors in context.
- **[HueSnap](https://www.huesnap.com/)** - Create beautiful color palettes to share and inspire others.
- **[Khroma](http://khroma.co/)** - Discover, search, and save color combinations you'll love.
- **[Leonardo](https://leonardocolor.io/)** - An open source contrast-based color generator by Adobe.
- **[Muzli Colors](https://colors.muz.li/)** - Create Beautiful Color Schemes that works.
- **[Open Color](https://yeun.github.io/open-color/)** - Open color is an open-source color scheme.
- **[Palettee app](https://palettte.app/)** - The definite palette editing and remapping tool.
- **[Palx](https://palx.jxnblk.com/)** - Provide a single color value and Palx returns a full-spectrum color palette
- **[Picular](https://picular.co/)** - A rocket fast primary color generator using Google's image search.
- **[Tints and Shades generator](https://maketintsandshades.com/)** - Easily make tints and shades in 10% increments

### Gradients

- **[CSS Gradient](https://cssgradient.io/)** - Create a colorful gradient background for your website, blog, or social media profile.
- **[Eggradients](https://www.eggradients.com/)** - A gradient color palette containing +200 gradient background color.
- **[Grabient](https://www.grabient.com/)** - Beautiful and simple UI for generating web gradients.
- **[Gradient Backgrounds](https://cssgradient.io/gradient-backgrounds/)** - A curated list of the best gradient websites across the internet.
- **[Gradient Cards](https://gradients.cssgears.com)** - A simple and beautiful list of editable gradients.
- **[GradientsList](https://www.gradientslist.com)** - Gradients List is the biggest collection of gradients on the web.
- **[uiGradients](https://uigradients.com/#IbizaSunset)** - A handpicked collection of beautiful color gradients for designers and developers.
- **[WebGradients](https://webgradients.com/)** - WebGradients is a free collection of 180 linear gradients that you can use as content backdrops in any part of your website.

### Design Tools

- **[Affinity](https://affinity.serif.com/en-gb/)** - Affinity - the fastest, smoothest, most precise professional creative software.
- **[Photopea](https://www.photopea.com/)** - A perfect alternative to Photoshop or Gimp.
- **[Photoshop](https://www.adobe.com/products/photoshop.html)** - The industry standard in digital imaging and used by professionals worldwide for design, photography, video editing & more.
- **[Procreate](https://procreate.art/)** - Procreate is the most powerful and intuitive digital illustration app available for iPad.
- **[Lunacy](https://icons8.com/lunacy)** - Free graphic design software with built-in design resources.

### Prototyping Tools

- **[Adobe XD CC](https://www.adobe.com/gr_en/products/xd.html)** - Design, prototype, and share engaging user experiences across platforms, screens, and devices with Adobe XD CC.
- **[Figma](https://www.figma.com/)** - A better way to design. Design, prototype, and gather feedback all in one place with Figma.
- **[Framerx](https://framer.com/x/)** - Create responsive layouts, design realistic prototypes, and bring everything closer to production—all in one place.
- **[InVision Studio](https://www.invisionapp.com/studio)** - A new platform inspired by the world’s best design teams. Design, prototype, and animate—all in one place.
- **[Sketch App](https://www.sketchapp.com/)** - Sketch is a design toolkit built to help you create your best work — from your earliest ideas, through to final artwork.
- **[UXPin](https://www.uxpin.com/)** - Design tool like no other. Prototypes that feel real, with powers of code components, logic, states and design systems.

### Presentation Tools

- **[Beautiful.ai](https://www.beautiful.ai)** - A.I. Powered Presentation Software
- **[DeckRobot](https://deckrobot.com/)** - Make consistent corporate slide decks in one click
- **[Google Slides](https://www.google.com/slides/about/)** - Create a new presentation and edit it with others at the same time — from your computer, phone or tablet.
- **[Keynote](https://www.apple.com/keynote/)** - Keynote is the most powerful presentation app ever designed for a mobile device.
- **[Microsoft PowerPoint](https://products.office.com/en/powerpoint)** - Microsoft PowerPoint is the best presentation software for meetings, industry talks and business proposals.
- **[Prezi](https://prezi.com/)** - The presentation software that uses motion, zoom, and spatial relationships to bring your ideas to life and make you a great presenter.
- **[Slides](https://slides.com/)** - Slides is a place for creating, presenting and sharing presentations. The Slides editor is available right in your browser.

### Animation Tools

- **[Adobe After Effects](https://www.adobe.com/gr_en/products/aftereffects.html)** - With After Effects CC, the industry-standard motion graphics and visual effects software, you can take any idea and make it move.
- **[Animator by Haiku](https://www.haikuforteams.com/)** - Haiku Animator is the premier solution for creating cross-platform UI animations.
- **[Anime.js](https://animejs.com/)** - Anime.js is a lightweight Javascript animation library designed to help you make complex animations with ease.
- **[Animista](http://animista.net/)** - Animista is a place where you can play with a collection of ready to use CSS animations, tweak them and download only those you will actually use.
- **[CSSFX](https://cssfx.netlify.com/)** - Beautifully simple click-to-copy CSS effects
- **[Drawer](https://drawer.design)** - A high-quality collection of Lottie animations and SVG Illustrations.
- **[Easings](https://easings.net/)** - Easing functions specify the rate of change of a parameter over time.
- **[Flinto](https://www.flinto.com/)** - Flinto is a Mac app used by top designers around the world to create interactive and animated prototypes of their app designs.
- **[Keyframes](https://keyframes.app/)** - An insanely simple way to create CSS animations.
- **[LightBox](https://uselightbox.com/)** - LightBox is a 2D, Hand-Drawn animation package.
- **[Principle](https://principleformac.com/)** - Principle makes it easy to design animated and interactive user interfaces.
- **[Lottie](https://airbnb.design/lottie/)** - Lottie is an iOS, Android, and React Native library that renders After Effects animations in real time.
- **[Spirit](https://spiritapp.io)** - The ultimate tool to create high-quality animations directly in the browser.
- **[SVG Artista](https://svgartista.net/)** - Little tool that helps you create SVG animations.
- **[Zdog](https://zzz.dog/)** - Round, flat, designer-friendly pseudo-3D engine for canvas & SVG.

### Mockup Tools

- **[Clean Mockups](https://cleanmock.com/)** - Create stunning mockups that make your design standout
- **[Facebook Design](https://facebook.design/toolsandresources/)** - A collection of free resources made by designers at Facebook
- **[Frrames](https://frrames.com/)** - Your perfect design in perfect mockup frame.
- **[LS Graphics](https://www.ls.graphics/free)** - Branding mockups, devices mockups, scene creators and UI kits for free
- **[Mockup World](https://www.mockupworld.co/all-mockups/)** - The best free Mockups from the Web
- **[Mockuuups Studio](http://mockuuups.studio/)** - Drag-and-drop tool for creating beautiful app previews and marketing materials.
- **[UX Planet list](https://uxplanet.org/free-macbook-mockups-psd-sketch-369d20b5638b)** - A great list of free MacBook Mockups
- **[Screely](https://www.screely.com/)** - Instantly turn your screenshot into a beautiful mockup.
- **[Shotsnapp](https://shotsnapp.com/)** - Create beautiful device mockup images for your app or website design.
- **[Threed.io](http://threed.io)** - Generate 3D Mockups right in your Browser.
- **[Qurb](https://qurb.rishimohan.me/)** - Web-based free mockup generator

### Web Accessibility

- **[Contraste](https://contrasteapp.com/)** - Contraste is a simple app for checking the accessibility of text against the Web Content Accessibility Guidelines (WCAG).
- **[Color Safe](http://colorsafe.co/)** - Empowering designers with beautiful and accessible color palettes based on WCAG Guidelines of text and background contrast ratios.
- **[Hex Naw](https://hexnaw.com)** - A color accessibility tool for designers and developers.
- **[Stark](https://www.getstark.co/)** - The plugin to help you design and build products that are accessible, ethical, and inclusive.
- **[The A11Y Project](https://a11yproject.com)** - A community-driven effort to make web accessibility easier.

### UI Kits

- **[Eva](https://eva.design/)** - Customizable Design System easily adaptable to your Brand. Available for Sketch with Mobile and Web component libraries.
- **[UI Store](https://www.uistore.design/)** - 252 Free Handpicked UI Kits for your real life projects.
- **[Velocity UI Kit](https://www.invisionapp.com/inside-design/design-resources/design-system-dashboard-ui-kit/)** - A dashboard UI kit with a robust design system.
- **[Semantic UI kit for XD](https://theblog.adobe.com/semantic-ui-kit-xd-icons-templates-design-system/)** - Build your own custom design system with a free XD UI kit inspired by Semantic UI. Created by Ole Fredrik.
- **[Square Dashboard UI kit](https://iconspace.co/product/square-dashboard-ui-kit/)** - Stylish dashboard UI kit for arious need

### User Flow Tools

- **[Draw.io](https://www.draw.io/)** - A cross-platform simple vector drawing tool. It’ll help you to create all these flowcharts, process diagrams, org charts, UML, ER, and network diagrams just in several minutes.
- **[Lucidchart](https://www.lucidchart.com/pages/)** - A web-based tool for creating diagrams, flow charts, sitemaps.
- **[Miro](https://miro.com/)** - Scalable, secure, cross-device and enterprise-ready team collaboration whiteboard for distributed teams.
- **[Overflow](https://overflow.io/)** - A user flow diagramming tool tailored for designers.

### Creative Tools

- **[Poolside FM](https://poolside.fm/)** - FM is an online radio station, playing an infinity pool of summer sounds.
- **[React-spring-visualizer](https://react-spring-visualizer.com/)** - Visualize your spring config for react-spring.
- **[Spring Editor](https://springs.pomb.us/)** - Stiffness? Damping? Mass? Spring Editor.
- **[Tinkersynth](https://tinkersynth.com/)** - Tinkersynth is an experimental art project. Create unique designs by manipulating whimsical machines and making serendipitous discoveries.
- **[Waveforms By Josh Comeau](https://pudding.cool/2018/02/waveforms/)** - An interactive guide that introduces and explores waveforms.

### AI Tools

- **[Compress.Studio](https://compress.studio/)** - A serverless image compression tool with a decentralized private storage.
- **[Generated Photos](https://generated.photos/)** - 100,000 Faces Generated by AI.
- **[Generative Photos](https://www.generative.photos)** - 25k diverse & customizable free stock photos generated by AI.
- **[Remove.bg](https://www.remove.bg/)** - Remove image background 100% automatically and free.
- **[Trace by Sticker Mule](https://www.stickermule.com/trace)** - Remove the background from any image for free.
- **[VisualEyes](https://www.visualeyes.design)** - Your virtual AI design assistant.
- **[Upscale Pics](https://upscalepics.com/)** - Enhance your images using AI.

---

## License

[MIT](https://en.wikipedia.org/wiki/MIT_License)

&nbsp;

<p align="center">
<sub>
  <sup>
    Made with 🤘 by 
    <a href="https://twitter.com/d__raptis">@d__raptis</a>
  </sup>
</sub>
</p>
