import builtins from 'builtin-modules';
import esbuild from 'esbuild';
import fs from 'fs';
import process from 'process';
import dirnamePlugin from '../dirname.mjs';
const banner = `/*
THIS IS A GENERATED/BUNDLED FILE BY ESBUILD
if you want to view the source, please visit the github repository of this plugin
*/
`;

const prod = process.argv[2] === 'production';
const manifestStr = fs.readFileSync('manifest.json', 'utf-8');
const manifest = JSON.parse(manifestStr);
const version = manifest.version;
console.log('version', version);

esbuild
  .build({
    banner: {
      js: banner,
    },
    entryPoints: ['src/main.tsx'],
    bundle: true,
    external: [
      'obsidian',
      'electron',
      '@codemirror/autocomplete',
      '@codemirror/closebrackets',
      '@codemirror/collab',
      '@codemirror/commands',
      '@codemirror/comment',
      '@codemirror/fold',
      '@codemirror/gutter',
      '@codemirror/highlight',
      '@codemirror/history',
      '@codemirror/language',
      '@codemirror/lint',
      '@codemirror/matchbrackets',
      '@codemirror/panel',
      '@codemirror/rangeset',
      '@codemirror/rectangular-selection',
      '@codemirror/search',
      '@codemirror/state',
      '@codemirror/stream-parser',
      '@codemirror/text',
      '@codemirror/tooltip',
      '@codemirror/view',
      ...builtins,
    ],
    format: 'cjs',
    watch: !prod,
    target: 'es2019',
    logLevel: 'info',
    sourcemap: prod ? false : 'inline',
    treeShaking: true,
    outfile: 'main.js',
    minify: prod,
    plugins: [dirnamePlugin],
    define: {
      'process.env.NODE_ENV': prod ? '"production"' : '"development"',
      'process.env.AVA_VERSION': `"${version}"`,
    },
  })
  .catch(() => process.exit(1));
