<p align="center">
  <img src="https://your-logo-url-here" alt="Python Test Automation" width="300" />
</p>

<h1 align="center">Python Test Automation</h1>

<p align="center">
  A comprehensive curated list of Python test automation frameworks, tools, libraries, and software. 
  <br/>Sponsored by <a href="http://sdclabs.com">SDC Labs</a> 🚀
</p>

<p align="center">
  Have questions, issues, or ideas? Join the conversation at <a href="https://gitter.im/atinfo/awesome-test-automation">Gitter Chat</a> 💬
</p>

## Table of Contents

- [xUnit frameworks](#xunit-frameworks)
- [TDD \ ATDD \ BDD](#tdd--atdd--bdd)
- [Test Data manipulation](#test-data-manipulation)
- [Code Analysis](#code-analysis)
- [Web UI test automation](#web-ui-test-automation)
- [Mobile test automation](#mobile-test-automation)
- [Windows UI test automation](#windows-ui-test-automation)
- [Unix \ Linux UI test automation](#unix--linux-ui-test-automation)
- [MacOS UI test automation](#macos-ui-test-automation)
- [REST API Testing](#rest-api-testing)
- [Virtual environments](#virtual-environments)
- [Performance & stress & load](#performance--stress--load)
- [Security checking](#security-checking)
- [Continuous Integration](#continuous-integration)
- [Reporting](#reporting)
- [Documentation generation](#documentation-generation)
- [Editors, IDE and consoles](#editors-ide-and-consoles)
- [Useful libs](#useful-libs)
- [Resources](#resources)

## xUnit frameworks

### frameworks
- **unittest**: Distributed unit testing in Python.
- **unittest2**: Backport of unittest features for Python 2.7+.
- **pytest**: Mature Python testing tool with comprehensive features.
  - **plugincompat**: Test execution and compatibility checks for pytest plugins.
- **test-junkie**: Highly configurable modern testing framework.
- **nosetests**: Improved testing for Python.
- **slash**: Python-based testing framework.
- **lemoncheesecake**: Functional testing framework with rich reporting.

### extensions
- **proboscis**: Extends Python’s unittest with TestNG features.
- **grail**: Library for test script creation based on steps.
- **testify**: Enhanced test fixture setup, split test suites, fancy color test runner.
- **trial**: Extension of unittest for asynchronous tests.
- **subunit**: Support for running unittest test cases/suites in a separate process.
- **testresources**: Manages 'resources' needed by multiple tests.
- **testtools**: Useful unittest extensions derived from custom extensions.
- **Sancho**: Test runner providing output for failing tests.
- **zope.testing**: Powerful test runner with post-mortem debugging.
- **pythoscope**: Tool to generate unit tests for legacy Python systems.
- **testlib**: More power to standard unittest with extra methods and features.
- **dutest**: Object-oriented interface for unittest test cases from doctests.
- **green**: Clean, colorful test runner for Python unit tests.
- **ddt**: Data-driven tests with unittest.
- **pytractor**: Extension to Selenium for testing Angular.js applications.
- **stestr**: Parallel Python test runner built around subunit.
- **pytest-django**: Test Django projects with pytest.
- **pytest-asyncio**: Test asyncio code with pytest.

## TDD \ ATDD \ BDD

### BDD
- **behave**: BDD tool.
- **lettuce**: BDD tool.
  - **lettuce-tools**: Tools extending lettuce's features.
- **contexts**: Descriptive testing for Python.
- **mamba**: Testing tool for Behavior Driven Development.
- **pyvows**: Asynchronous behavior-driven development for Python.
- **pytest-bdd**: BDD library for py.test.
- **pytest-play**: ATDD plugin automating actions, assertions, and test metrics via YAML files.
- **robotframework**: Generic test automation framework.
  - **awesome-robotframework**: Curated resources and libraries for Robot Framework.
- **radish-bdd**: BDD testing tool with supplements.

### Assertions
- **pyshould**: Should style asserts based on pyhamcrest.
- **pyhamcrest**: Hamcrest matchers for Python.
- **sure**: Flexible assertions for Python.
- **assertpy**: Simple assertions library for unit testing in Python.
  <!-- and so on... -->
