# Security Policy

## Supported Versions

Use this section to inform users about which versions of your project are currently supported with security updates. Users should be aware of which versions are safe to use and which ones may be vulnerable.

| Version | Supported          |
| ------- | ------------------ |
| 5.1.x   | :white_check_mark: |
| 5.0.x   | :x:                |
| 4.0.x   | :white_check_mark: |
| < 4.0   | :x:                |

- **5.1.x**: This version is actively supported and receives security updates. Users are encouraged to upgrade to this version.
- **5.0.x**: This version is not supported with security updates. Users are strongly recommended to upgrade to a supported version.
- **4.0.x**: This version is still supported and receives security updates. Users can continue to use it safely.

## Reporting a Vulnerability

To maintain the security and integrity of our project, we appreciate responsible disclosure of security vulnerabilities. If you discover a security issue, please report it to us promptly. Here's how to report a vulnerability:

1. Send an email to [fagun.devxhub@gmail.com](mailto:fagun.devxhub@.com) with a detailed description of the vulnerability.
2. Provide steps to reproduce the vulnerability if possible.
3. Include any relevant information about your environment (versions, configurations, etc.).
4. If you wish to encrypt your communication, you can use our PGP key. Contact us for the PGP key.

### Response Time

We take security vulnerabilities seriously and will make every effort to respond to your report promptly. After receiving your report, we will acknowledge it within 48 hours. Our security team will investigate the issue, and we will keep you informed about the progress and any actions taken.

### Fix and Disclosure

Once a vulnerability is confirmed and fixed, we will provide you with details about the fix and coordinate with you on disclosure. We follow responsible disclosure practices and will give credit to the reporter if requested.

### Security Concerns

If you have any general security concerns or questions about the security of our project, please don't hesitate to reach out to[fagun.devxhub@gmail.com](mailto:fagun.devxhub@.com).

We appreciate your assistance in making our project more secure and protecting our user community. Thank you for helping us maintain a safe and reliable application.
