"use strict";
/* The directive looks like a string: "use strict" or 'use strict'. When it is located at the top of a script, the whole script works the “modern” way.
*/

console.log("We are using use strict")
/* Ensure that “use strict” is at the top, Please make sure that "use strict" is at the top of your scripts, otherwise strict mode may not be enabled.

----

There is no directive like "no use strict" that reverts the engine to old behavior.

Once we enter strict mode, there’s no going back.
*/


/*
Modern JavaScript supports “classes” and “modules” – advanced language structures (we’ll surely get to them), that enable use strict automatically. So we don’t need to add the "use strict" directive, if we use them.
*/




