﻿// Copyright 2022-2024 Antonello Provenzano
// 
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// 
//     http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Non-nullable field must contain a non-null value when exiting constructor. Consider declaring as nullable.
#pragma warning disable CS8618

namespace Deveel.Webhooks.Twilio {
	/// <summary>
	/// Represents the reference to a media element in a Twilio webhook.
	/// </summary>
	public sealed class MediaElement {
		/// <summary>
		/// Gets the URL of the media element.
		/// </summary>
        public string? Url { get; internal set; }

		/// <summary>
		/// Gets the content type of the media element.
		/// </summary>
		public string? ContentType { get; internal set; }

		/// <summary>
		/// Gets the size of the media element.
		/// </summary>
		public long? ContentLength { get; internal set; }
	}
}
