# Security Policy

## Reporting a Vulnerability

If you discover a security vulnerability in this repository, please send an email to security@deveel.com with details on how to reproduce the issue. We will respond to you as soon as possible and work with you to address the vulnerability.

## Supported Versions

This repository is actively maintained with security patches applied to the latest release. It is recommended that users always use the latest version of the software.

| Version   | Supported          |
| --------- | ------------------ |
| 2.0.x     | :white_check_mark: |
| 1.1.7     | :white_check_mark: |
| < 1.1.x   | :x:                |

## Vulnerability Disclosure

We take security vulnerabilities seriously and aim to disclose them to our users as soon as possible. Once we have confirmed and addressed the vulnerability, we will make a public disclosure and provide a timeline for when the issue was fixed.

## Security Measures

This repository implements a number of security measures to help protect against common attacks, including:

- Regular code reviews and security assessments
- Implementation of secure coding practices
- Use of password managers and multi-factor authentication for all contributors
- Limited access to production environments and sensitive data
- Regular backups and disaster recovery planning

If you have any questions or concerns about the security of this repository, please contact us at security@deveel.com.
