<!--
 Copyright 2022 Deveel
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
     http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

# How to Contribute

One of the easiest ways to contribute is to participate in discussions on GitHub issues. At this point in the project we welcome anyone's feedback on where tye help you to succeed or caused you trouble.

You can also contribute by submitting Pull Requests (PRs) with code changes to address an open issue or improve documentation.

## General Feedback and Discussions

It is possible for you to share your point of views on how we could do better on this project, by creating a new [feedback issue](https://github.com/deveel/deveel.webhooks/issues/new?template=feedback.md).

We will try to follow up on all the feedbacks received, but when we think we have identified any duplication or similar issue, we'll probably close yours and link it to some other issues that we're tracking. Getting feedback in the form of issues is helpful to the team, regardless of whether its negative or positive. :)

---

Or if there's a top if you want to discuss, create a [discussion issue](https://github.com/deveel/deveel.webhooks/new?template=discussion.md).

Feel free to create discussion issues if there's something you want to ask about. We may close your issue if there's an easy answer, or we may leave it open so that others are encouraged to comment and share their point of view.

## Bugs and Feature Requests

For non-security related bugs, log a new [bug report](https://github.com/deveel/deveel.webhooks/issues/new?template=bug_report.md).

We care for every report you might want to signal to us, since it helps improving the quality and stability of the framework. Anyway, we cannot promise that we will be able to resolve them quickly, given our limited availability and resources: if you can, try to help us providing a solution through a PR (_see the section below_).

---

For feature requests, log a new [feature request](https://github.com/deveel/deveel.webhooks/issues/new?template=feature_request.md).

Please, be aware that this project belongs in a specific domain and not all the ideas might be received and inserted in a roadmap for implementation and release.

## Contributing Code and Content

We accept fixes and features! Here are some resources to help you get started on how to contribute code or new content.

* Look at the [Developer documentation](/docs/developer_guide.md) to get started on building the source code on your own.
* ["Help wanted" issues](https://github.com/deveel/deveel.webhooks/labels/help%20wanted) - these issues are up for grabs. Comment on an issue if you want to create a fix.
* ["Good first issue" issues](https://github.com/deveel/deveel.webhooks/labels/good%20first%20issue) - we think these are a good for newcomers.

### Before Sending a Pull Request (PR)

We prefer to have a discussion via an issues before reviewing a PR especially if the changes are extensive or if the PR adds a feature that we haven't agreed to add.

If you are sending a PR for an existing issue, please comment on the issue so that others can see that someone is working on it. It may not be a bad idea to comment before you start work, because the team might have suggestions.

We don't expect an issue for minor improvements like:

* Correcting grammar or spelling
* Correcting documentation mistakes

### Submitting a pull request

If you don't know what a pull request is, read [this article](https://help.github.com/articles/using-pull-requests).
Please, make sure the repository can build the changes and all tests pass.

Familiarize yourself with the [developer guide](/docs/developer_guide.md) for information about how to work with the repository.

### Tests

We don't currently have many tests as part of the repository and expect to increase the test coverage over time. For right now, try to understand if the area you're working in is already covered by tests, and expand them if possible.