import React from 'react';

import useUI, { Mode } from 'components/ThemeProvider';

import css from './ThemeToggle.module.scss';

interface Props {
  iconOnly?: boolean;
}

interface ThemeOption {
  className: Mode;
  displayName: string;
  next: Mode;
}

export const ThemeOptions: Record<Mode, ThemeOption> = {
  [Mode.Light]: {
    className: Mode.Light,
    displayName: 'Day Theme',
    next: Mode.Dark,
  },
  [Mode.Dark]: {
    className: Mode.Dark,
    displayName: 'Night Theme',
    next: Mode.System,
  },
  [Mode.System]: {
    className: Mode.System,
    displayName: 'System Theme',
    next: Mode.Light,
  },
};

const ThemeToggle: React.FC<Props> = ({ iconOnly = false }) => {
  const {
    ui: { mode: uiMode },
    actions: { setMode },
  } = useUI();

  const classes = [css.base];
  if (iconOnly) classes.push(css.iconOnly);

  const togglerClasses = [css.toggler];
  const currentThemeOption = ThemeOptions[uiMode];
  togglerClasses.push(css[currentThemeOption.className]);

  const newThemeMode = (e: React.MouseEvent) => {
    e.stopPropagation();
    e.preventDefault();
    setMode(currentThemeOption.next);
  };

  return (
    <div className={classes.join(' ')} onClick={newThemeMode}>
      <div className={css.container}>
        <div className={togglerClasses.join(' ')} />
        <div className={css.mode}>{currentThemeOption.displayName}</div>
      </div>
    </div>
  );
};

export default ThemeToggle;
