// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// source: determined/webhook/v1/webhook.proto

package webhookv1

import (
	logv1 "github.com/determined-ai/determined/proto/pkg/logv1"
	_struct "github.com/golang/protobuf/ptypes/struct"
	_ "github.com/grpc-ecosystem/grpc-gateway/protoc-gen-swagger/options"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enum values for expected webhook types.
type WebhookType int32

const (
	// Default value
	WebhookType_WEBHOOK_TYPE_UNSPECIFIED WebhookType = 0
	// For a default webhook
	WebhookType_WEBHOOK_TYPE_DEFAULT WebhookType = 1
	// For a slack webhook.
	WebhookType_WEBHOOK_TYPE_SLACK WebhookType = 2
)

// Enum value maps for WebhookType.
var (
	WebhookType_name = map[int32]string{
		0: "WEBHOOK_TYPE_UNSPECIFIED",
		1: "WEBHOOK_TYPE_DEFAULT",
		2: "WEBHOOK_TYPE_SLACK",
	}
	WebhookType_value = map[string]int32{
		"WEBHOOK_TYPE_UNSPECIFIED": 0,
		"WEBHOOK_TYPE_DEFAULT":     1,
		"WEBHOOK_TYPE_SLACK":       2,
	}
)

func (x WebhookType) Enum() *WebhookType {
	p := new(WebhookType)
	*p = x
	return p
}

func (x WebhookType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WebhookType) Descriptor() protoreflect.EnumDescriptor {
	return file_determined_webhook_v1_webhook_proto_enumTypes[0].Descriptor()
}

func (WebhookType) Type() protoreflect.EnumType {
	return &file_determined_webhook_v1_webhook_proto_enumTypes[0]
}

func (x WebhookType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WebhookType.Descriptor instead.
func (WebhookType) EnumDescriptor() ([]byte, []int) {
	return file_determined_webhook_v1_webhook_proto_rawDescGZIP(), []int{0}
}

// Enum values for webhook mode.
type WebhookMode int32

const (
	// Default value
	WebhookMode_WEBHOOK_MODE_UNSPECIFIED WebhookMode = 0
	// Webhook will be triggered by all experiment in the workspace
	WebhookMode_WEBHOOK_MODE_WORKSPACE WebhookMode = 1
	// Webhook will only be triggered by experiment with matching configuration in
	// the same workspace as the web hook
	WebhookMode_WEBHOOK_MODE_SPECIFIC WebhookMode = 2
)

// Enum value maps for WebhookMode.
var (
	WebhookMode_name = map[int32]string{
		0: "WEBHOOK_MODE_UNSPECIFIED",
		1: "WEBHOOK_MODE_WORKSPACE",
		2: "WEBHOOK_MODE_SPECIFIC",
	}
	WebhookMode_value = map[string]int32{
		"WEBHOOK_MODE_UNSPECIFIED": 0,
		"WEBHOOK_MODE_WORKSPACE":   1,
		"WEBHOOK_MODE_SPECIFIC":    2,
	}
)

func (x WebhookMode) Enum() *WebhookMode {
	p := new(WebhookMode)
	*p = x
	return p
}

func (x WebhookMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WebhookMode) Descriptor() protoreflect.EnumDescriptor {
	return file_determined_webhook_v1_webhook_proto_enumTypes[1].Descriptor()
}

func (WebhookMode) Type() protoreflect.EnumType {
	return &file_determined_webhook_v1_webhook_proto_enumTypes[1]
}

func (x WebhookMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WebhookMode.Descriptor instead.
func (WebhookMode) EnumDescriptor() ([]byte, []int) {
	return file_determined_webhook_v1_webhook_proto_rawDescGZIP(), []int{1}
}

// Enum values for expected trigger types.
type TriggerType int32

const (
	// Default value
	TriggerType_TRIGGER_TYPE_UNSPECIFIED TriggerType = 0
	// For an experiment changing state
	TriggerType_TRIGGER_TYPE_EXPERIMENT_STATE_CHANGE TriggerType = 1
	// For metrics emitted during training.
	TriggerType_TRIGGER_TYPE_METRIC_THRESHOLD_EXCEEDED TriggerType = 2
	// For task logs.
	TriggerType_TRIGGER_TYPE_TASK_LOG TriggerType = 3
	// For custom alert.
	TriggerType_TRIGGER_TYPE_CUSTOM TriggerType = 4
)

// Enum value maps for TriggerType.
var (
	TriggerType_name = map[int32]string{
		0: "TRIGGER_TYPE_UNSPECIFIED",
		1: "TRIGGER_TYPE_EXPERIMENT_STATE_CHANGE",
		2: "TRIGGER_TYPE_METRIC_THRESHOLD_EXCEEDED",
		3: "TRIGGER_TYPE_TASK_LOG",
		4: "TRIGGER_TYPE_CUSTOM",
	}
	TriggerType_value = map[string]int32{
		"TRIGGER_TYPE_UNSPECIFIED":               0,
		"TRIGGER_TYPE_EXPERIMENT_STATE_CHANGE":   1,
		"TRIGGER_TYPE_METRIC_THRESHOLD_EXCEEDED": 2,
		"TRIGGER_TYPE_TASK_LOG":                  3,
		"TRIGGER_TYPE_CUSTOM":                    4,
	}
)

func (x TriggerType) Enum() *TriggerType {
	p := new(TriggerType)
	*p = x
	return p
}

func (x TriggerType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TriggerType) Descriptor() protoreflect.EnumDescriptor {
	return file_determined_webhook_v1_webhook_proto_enumTypes[2].Descriptor()
}

func (TriggerType) Type() protoreflect.EnumType {
	return &file_determined_webhook_v1_webhook_proto_enumTypes[2]
}

func (x TriggerType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TriggerType.Descriptor instead.
func (TriggerType) EnumDescriptor() ([]byte, []int) {
	return file_determined_webhook_v1_webhook_proto_rawDescGZIP(), []int{2}
}

// Event data for custom trigger.
type CustomWebhookEventData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The level at which the event data is logged.
	Level logv1.LogLevel `protobuf:"varint,1,opt,name=level,proto3,enum=determined.log.v1.LogLevel" json:"level,omitempty"`
	// The title for the event data.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// The description for the event data.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *CustomWebhookEventData) Reset() {
	*x = CustomWebhookEventData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_webhook_v1_webhook_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomWebhookEventData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomWebhookEventData) ProtoMessage() {}

func (x *CustomWebhookEventData) ProtoReflect() protoreflect.Message {
	mi := &file_determined_webhook_v1_webhook_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomWebhookEventData.ProtoReflect.Descriptor instead.
func (*CustomWebhookEventData) Descriptor() ([]byte, []int) {
	return file_determined_webhook_v1_webhook_proto_rawDescGZIP(), []int{0}
}

func (x *CustomWebhookEventData) GetLevel() logv1.LogLevel {
	if x != nil {
		return x.Level
	}
	return logv1.LogLevel_LOG_LEVEL_UNSPECIFIED
}

func (x *CustomWebhookEventData) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *CustomWebhookEventData) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// Representation of a Webhook
type Webhook struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the webhook.
	Id int32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// The url of the webhook.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// The triggers of the webhook.
	Triggers []*Trigger `protobuf:"bytes,3,rep,name=triggers,proto3" json:"triggers,omitempty"`
	// The type of the webhook.
	WebhookType WebhookType `protobuf:"varint,4,opt,name=webhook_type,json=webhookType,proto3,enum=determined.webhook.v1.WebhookType" json:"webhook_type,omitempty"`
	// The name of the webhook.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	// The workspace of the webhook.
	WorkspaceId int32 `protobuf:"varint,6,opt,name=workspace_id,json=workspaceId,proto3" json:"workspace_id,omitempty"`
	// The mode of the webhook.
	Mode WebhookMode `protobuf:"varint,7,opt,name=mode,proto3,enum=determined.webhook.v1.WebhookMode" json:"mode,omitempty"`
}

func (x *Webhook) Reset() {
	*x = Webhook{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_webhook_v1_webhook_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Webhook) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Webhook) ProtoMessage() {}

func (x *Webhook) ProtoReflect() protoreflect.Message {
	mi := &file_determined_webhook_v1_webhook_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Webhook.ProtoReflect.Descriptor instead.
func (*Webhook) Descriptor() ([]byte, []int) {
	return file_determined_webhook_v1_webhook_proto_rawDescGZIP(), []int{1}
}

func (x *Webhook) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Webhook) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *Webhook) GetTriggers() []*Trigger {
	if x != nil {
		return x.Triggers
	}
	return nil
}

func (x *Webhook) GetWebhookType() WebhookType {
	if x != nil {
		return x.WebhookType
	}
	return WebhookType_WEBHOOK_TYPE_UNSPECIFIED
}

func (x *Webhook) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Webhook) GetWorkspaceId() int32 {
	if x != nil {
		return x.WorkspaceId
	}
	return 0
}

func (x *Webhook) GetMode() WebhookMode {
	if x != nil {
		return x.Mode
	}
	return WebhookMode_WEBHOOK_MODE_UNSPECIFIED
}

// Representation for a Trigger for a Webhook
type Trigger struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the trigger.
	Id int32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// The type of the trigger.
	TriggerType TriggerType `protobuf:"varint,2,opt,name=trigger_type,json=triggerType,proto3,enum=determined.webhook.v1.TriggerType" json:"trigger_type,omitempty"`
	// The trigger condition.
	// For TRIGGER_TYPE_TASK_LOG needs {"regex": "abcd"}
	Condition *_struct.Struct `protobuf:"bytes,3,opt,name=condition,proto3" json:"condition,omitempty"`
	// The parent webhook of the trigger.
	WebhookId int32 `protobuf:"varint,4,opt,name=webhook_id,json=webhookId,proto3" json:"webhook_id,omitempty"`
}

func (x *Trigger) Reset() {
	*x = Trigger{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_webhook_v1_webhook_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Trigger) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Trigger) ProtoMessage() {}

func (x *Trigger) ProtoReflect() protoreflect.Message {
	mi := &file_determined_webhook_v1_webhook_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Trigger.ProtoReflect.Descriptor instead.
func (*Trigger) Descriptor() ([]byte, []int) {
	return file_determined_webhook_v1_webhook_proto_rawDescGZIP(), []int{2}
}

func (x *Trigger) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Trigger) GetTriggerType() TriggerType {
	if x != nil {
		return x.TriggerType
	}
	return TriggerType_TRIGGER_TYPE_UNSPECIFIED
}

func (x *Trigger) GetCondition() *_struct.Struct {
	if x != nil {
		return x.Condition
	}
	return nil
}

func (x *Trigger) GetWebhookId() int32 {
	if x != nil {
		return x.WebhookId
	}
	return 0
}

// PatchWebhook is a partial update to a webhook
type PatchWebhook struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The new url of the webhook.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
}

func (x *PatchWebhook) Reset() {
	*x = PatchWebhook{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_webhook_v1_webhook_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchWebhook) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchWebhook) ProtoMessage() {}

func (x *PatchWebhook) ProtoReflect() protoreflect.Message {
	mi := &file_determined_webhook_v1_webhook_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchWebhook.ProtoReflect.Descriptor instead.
func (*PatchWebhook) Descriptor() ([]byte, []int) {
	return file_determined_webhook_v1_webhook_proto_rawDescGZIP(), []int{3}
}

func (x *PatchWebhook) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

var File_determined_webhook_v1_webhook_proto protoreflect.FileDescriptor

var file_determined_webhook_v1_webhook_proto_rawDesc = []byte{
	0x0a, 0x23, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x77, 0x65, 0x62,
	0x68, 0x6f, 0x6f, 0x6b, 0x2f, 0x76, 0x31, 0x2f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x15, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65,
	0x64, 0x2e, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x2e, 0x76, 0x31, 0x1a, 0x2c, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x73, 0x77, 0x61, 0x67, 0x67, 0x65, 0x72,
	0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d,
	0x69, 0x6e, 0x65, 0x64, 0x2f, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x6f, 0x67, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x83, 0x01, 0x0a, 0x16, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x12, 0x31, 0x0a, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x1b, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x6c, 0x6f, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x05, 0x6c, 0x65,
	0x76, 0x65, 0x6c, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc7, 0x02, 0x0a, 0x07,
	0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x02, 0x69, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x3a, 0x0a, 0x08, 0x74, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x64, 0x65,
	0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x08, 0x74, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x73, 0x12, 0x45, 0x0a, 0x0c, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x64, 0x65,
	0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b,
	0x2e, 0x76, 0x31, 0x2e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x0b, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x21, 0x0a, 0x0c, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x49, 0x64, 0x12, 0x36, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x22, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x77,
	0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f,
	0x6b, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x3a, 0x28, 0x92, 0x41, 0x25,
	0x0a, 0x23, 0xd2, 0x01, 0x03, 0x75, 0x72, 0x6c, 0xd2, 0x01, 0x0c, 0x77, 0x65, 0x62, 0x68, 0x6f,
	0x6f, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0xd2, 0x01, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xd2, 0x01,
	0x04, 0x6d, 0x6f, 0x64, 0x65, 0x22, 0xd5, 0x01, 0x0a, 0x07, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65,
	0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x45, 0x0a, 0x0c, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d,
	0x69, 0x6e, 0x65, 0x64, 0x2e, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x74, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x35, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1d, 0x0a, 0x0a, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x09, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x49, 0x64, 0x3a, 0x1d,
	0x92, 0x41, 0x1a, 0x0a, 0x18, 0xd2, 0x01, 0x15, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x2d, 0x0a,
	0x0c, 0x50, 0x61, 0x74, 0x63, 0x68, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x12, 0x10, 0x0a,
	0x03, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x3a,
	0x0b, 0x92, 0x41, 0x08, 0x0a, 0x06, 0xd2, 0x01, 0x03, 0x75, 0x72, 0x6c, 0x2a, 0x5d, 0x0a, 0x0b,
	0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x57,
	0x45, 0x42, 0x48, 0x4f, 0x4f, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x57, 0x45, 0x42,
	0x48, 0x4f, 0x4f, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c,
	0x54, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x57, 0x45, 0x42, 0x48, 0x4f, 0x4f, 0x4b, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x53, 0x4c, 0x41, 0x43, 0x4b, 0x10, 0x02, 0x2a, 0x62, 0x0a, 0x0b, 0x57,
	0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x57, 0x45,
	0x42, 0x48, 0x4f, 0x4f, 0x4b, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x57, 0x45, 0x42, 0x48,
	0x4f, 0x4f, 0x4b, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x57, 0x4f, 0x52, 0x4b, 0x53, 0x50, 0x41,
	0x43, 0x45, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x57, 0x45, 0x42, 0x48, 0x4f, 0x4f, 0x4b, 0x5f,
	0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x43, 0x10, 0x02, 0x2a,
	0xb5, 0x01, 0x0a, 0x0b, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1c, 0x0a, 0x18, 0x54, 0x52, 0x49, 0x47, 0x47, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x28, 0x0a,
	0x24, 0x54, 0x52, 0x49, 0x47, 0x47, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x45, 0x58,
	0x50, 0x45, 0x52, 0x49, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x43,
	0x48, 0x41, 0x4e, 0x47, 0x45, 0x10, 0x01, 0x12, 0x2a, 0x0a, 0x26, 0x54, 0x52, 0x49, 0x47, 0x47,
	0x45, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4d, 0x45, 0x54, 0x52, 0x49, 0x43, 0x5f, 0x54,
	0x48, 0x52, 0x45, 0x53, 0x48, 0x4f, 0x4c, 0x44, 0x5f, 0x45, 0x58, 0x43, 0x45, 0x45, 0x44, 0x45,
	0x44, 0x10, 0x02, 0x12, 0x19, 0x0a, 0x15, 0x54, 0x52, 0x49, 0x47, 0x47, 0x45, 0x52, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x54, 0x41, 0x53, 0x4b, 0x5f, 0x4c, 0x4f, 0x47, 0x10, 0x03, 0x12, 0x17,
	0x0a, 0x13, 0x54, 0x52, 0x49, 0x47, 0x47, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43,
	0x55, 0x53, 0x54, 0x4f, 0x4d, 0x10, 0x04, 0x42, 0x39, 0x5a, 0x37, 0x67, 0x69, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64,
	0x2d, 0x61, 0x69, 0x2f, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b,
	0x76, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_determined_webhook_v1_webhook_proto_rawDescOnce sync.Once
	file_determined_webhook_v1_webhook_proto_rawDescData = file_determined_webhook_v1_webhook_proto_rawDesc
)

func file_determined_webhook_v1_webhook_proto_rawDescGZIP() []byte {
	file_determined_webhook_v1_webhook_proto_rawDescOnce.Do(func() {
		file_determined_webhook_v1_webhook_proto_rawDescData = protoimpl.X.CompressGZIP(file_determined_webhook_v1_webhook_proto_rawDescData)
	})
	return file_determined_webhook_v1_webhook_proto_rawDescData
}

var file_determined_webhook_v1_webhook_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_determined_webhook_v1_webhook_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_determined_webhook_v1_webhook_proto_goTypes = []interface{}{
	(WebhookType)(0),               // 0: determined.webhook.v1.WebhookType
	(WebhookMode)(0),               // 1: determined.webhook.v1.WebhookMode
	(TriggerType)(0),               // 2: determined.webhook.v1.TriggerType
	(*CustomWebhookEventData)(nil), // 3: determined.webhook.v1.CustomWebhookEventData
	(*Webhook)(nil),                // 4: determined.webhook.v1.Webhook
	(*Trigger)(nil),                // 5: determined.webhook.v1.Trigger
	(*PatchWebhook)(nil),           // 6: determined.webhook.v1.PatchWebhook
	(logv1.LogLevel)(0),            // 7: determined.log.v1.LogLevel
	(*_struct.Struct)(nil),         // 8: google.protobuf.Struct
}
var file_determined_webhook_v1_webhook_proto_depIdxs = []int32{
	7, // 0: determined.webhook.v1.CustomWebhookEventData.level:type_name -> determined.log.v1.LogLevel
	5, // 1: determined.webhook.v1.Webhook.triggers:type_name -> determined.webhook.v1.Trigger
	0, // 2: determined.webhook.v1.Webhook.webhook_type:type_name -> determined.webhook.v1.WebhookType
	1, // 3: determined.webhook.v1.Webhook.mode:type_name -> determined.webhook.v1.WebhookMode
	2, // 4: determined.webhook.v1.Trigger.trigger_type:type_name -> determined.webhook.v1.TriggerType
	8, // 5: determined.webhook.v1.Trigger.condition:type_name -> google.protobuf.Struct
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_determined_webhook_v1_webhook_proto_init() }
func file_determined_webhook_v1_webhook_proto_init() {
	if File_determined_webhook_v1_webhook_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_determined_webhook_v1_webhook_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomWebhookEventData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_webhook_v1_webhook_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Webhook); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_webhook_v1_webhook_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Trigger); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_webhook_v1_webhook_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchWebhook); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_determined_webhook_v1_webhook_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_determined_webhook_v1_webhook_proto_goTypes,
		DependencyIndexes: file_determined_webhook_v1_webhook_proto_depIdxs,
		EnumInfos:         file_determined_webhook_v1_webhook_proto_enumTypes,
		MessageInfos:      file_determined_webhook_v1_webhook_proto_msgTypes,
	}.Build()
	File_determined_webhook_v1_webhook_proto = out.File
	file_determined_webhook_v1_webhook_proto_rawDesc = nil
	file_determined_webhook_v1_webhook_proto_goTypes = nil
	file_determined_webhook_v1_webhook_proto_depIdxs = nil
}
