// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// source: determined/trial/v1/trial.proto

package trialv1

import (
	checkpointv1 "github.com/determined-ai/determined/proto/pkg/checkpointv1"
	commonv1 "github.com/determined-ai/determined/proto/pkg/commonv1"
	_struct "github.com/golang/protobuf/ptypes/struct"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "github.com/grpc-ecosystem/grpc-gateway/protoc-gen-swagger/options"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The current state of the trial. see \dT+ trial_state in db
type State int32

const (
	// The trial is in an unspecified state.
	State_STATE_UNSPECIFIED State = 0
	// The trial is in an active state.
	State_STATE_ACTIVE State = 1
	// The trial is in a paused state
	State_STATE_PAUSED State = 2
	// The trial is canceled and is shutting down.
	State_STATE_STOPPING_CANCELED State = 3
	// The trial is killed and is shutting down.
	State_STATE_STOPPING_KILLED State = 4
	// The trial is completed and is shutting down.
	State_STATE_STOPPING_COMPLETED State = 5
	// The trial is errored and is shutting down.
	State_STATE_STOPPING_ERROR State = 6
	// The trial is canceled and is shut down.
	State_STATE_CANCELED State = 7
	// The trial is completed and is shut down.
	State_STATE_COMPLETED State = 8
	// The trial is errored and is shut down.
	State_STATE_ERROR State = 9
	// The trial is queued (waiting to be run, or job state is still queued).
	// Queued is a substate of the Active state.
	State_STATE_QUEUED State = 10
	// The trial is pulling the image. Pulling is a substate of the Active
	// state.
	State_STATE_PULLING State = 11
	// The trial is preparing the environment after finishing pulling the
	// image. Starting is a substate of the Active state.
	State_STATE_STARTING State = 12
	// The trial's allocation is actively running.
	// Running is a substate of the Active state.
	State_STATE_RUNNING State = 13
)

// Enum value maps for State.
var (
	State_name = map[int32]string{
		0:  "STATE_UNSPECIFIED",
		1:  "STATE_ACTIVE",
		2:  "STATE_PAUSED",
		3:  "STATE_STOPPING_CANCELED",
		4:  "STATE_STOPPING_KILLED",
		5:  "STATE_STOPPING_COMPLETED",
		6:  "STATE_STOPPING_ERROR",
		7:  "STATE_CANCELED",
		8:  "STATE_COMPLETED",
		9:  "STATE_ERROR",
		10: "STATE_QUEUED",
		11: "STATE_PULLING",
		12: "STATE_STARTING",
		13: "STATE_RUNNING",
	}
	State_value = map[string]int32{
		"STATE_UNSPECIFIED":        0,
		"STATE_ACTIVE":             1,
		"STATE_PAUSED":             2,
		"STATE_STOPPING_CANCELED":  3,
		"STATE_STOPPING_KILLED":    4,
		"STATE_STOPPING_COMPLETED": 5,
		"STATE_STOPPING_ERROR":     6,
		"STATE_CANCELED":           7,
		"STATE_COMPLETED":          8,
		"STATE_ERROR":              9,
		"STATE_QUEUED":             10,
		"STATE_PULLING":            11,
		"STATE_STARTING":           12,
		"STATE_RUNNING":            13,
	}
)

func (x State) Enum() *State {
	p := new(State)
	*p = x
	return p
}

func (x State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (State) Descriptor() protoreflect.EnumDescriptor {
	return file_determined_trial_v1_trial_proto_enumTypes[0].Descriptor()
}

func (State) Type() protoreflect.EnumType {
	return &file_determined_trial_v1_trial_proto_enumTypes[0]
}

func (x State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use State.Descriptor instead.
func (State) EnumDescriptor() ([]byte, []int) {
	return file_determined_trial_v1_trial_proto_rawDescGZIP(), []int{0}
}

// TrialSourceInfoType is the type of the TrialSourceInfo, which serves as a
// link between a trial and a checkpoint or model version
type TrialSourceInfoType int32

const (
	// The type is unspecified
	TrialSourceInfoType_TRIAL_SOURCE_INFO_TYPE_UNSPECIFIED TrialSourceInfoType = 0
	// "Inference" Trial Source Info Type, used for batch inference
	TrialSourceInfoType_TRIAL_SOURCE_INFO_TYPE_INFERENCE TrialSourceInfoType = 1
	// "Fine Tuning" Trial Source Info Type, used in model hub
	TrialSourceInfoType_TRIAL_SOURCE_INFO_TYPE_FINE_TUNING TrialSourceInfoType = 2
)

// Enum value maps for TrialSourceInfoType.
var (
	TrialSourceInfoType_name = map[int32]string{
		0: "TRIAL_SOURCE_INFO_TYPE_UNSPECIFIED",
		1: "TRIAL_SOURCE_INFO_TYPE_INFERENCE",
		2: "TRIAL_SOURCE_INFO_TYPE_FINE_TUNING",
	}
	TrialSourceInfoType_value = map[string]int32{
		"TRIAL_SOURCE_INFO_TYPE_UNSPECIFIED": 0,
		"TRIAL_SOURCE_INFO_TYPE_INFERENCE":   1,
		"TRIAL_SOURCE_INFO_TYPE_FINE_TUNING": 2,
	}
)

func (x TrialSourceInfoType) Enum() *TrialSourceInfoType {
	p := new(TrialSourceInfoType)
	*p = x
	return p
}

func (x TrialSourceInfoType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TrialSourceInfoType) Descriptor() protoreflect.EnumDescriptor {
	return file_determined_trial_v1_trial_proto_enumTypes[1].Descriptor()
}

func (TrialSourceInfoType) Type() protoreflect.EnumType {
	return &file_determined_trial_v1_trial_proto_enumTypes[1]
}

func (x TrialSourceInfoType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TrialSourceInfoType.Descriptor instead.
func (TrialSourceInfoType) EnumDescriptor() ([]byte, []int) {
	return file_determined_trial_v1_trial_proto_rawDescGZIP(), []int{1}
}

// To distinguish the 2 different categories of metrics.
type TrialProfilerMetricLabels_ProfilerMetricType int32

const (
	// Zero-value (not allowed).
	TrialProfilerMetricLabels_PROFILER_METRIC_TYPE_UNSPECIFIED TrialProfilerMetricLabels_ProfilerMetricType = 0
	// For systems metrics, like GPU utilization or memory.
	TrialProfilerMetricLabels_PROFILER_METRIC_TYPE_SYSTEM TrialProfilerMetricLabels_ProfilerMetricType = 1
	// For timing metrics, like how long a backwards pass or getting a batch
	// from the dataloader took.
	TrialProfilerMetricLabels_PROFILER_METRIC_TYPE_TIMING TrialProfilerMetricLabels_ProfilerMetricType = 2
	// For other miscellaneous metrics.
	TrialProfilerMetricLabels_PROFILER_METRIC_TYPE_MISC TrialProfilerMetricLabels_ProfilerMetricType = 3
)

// Enum value maps for TrialProfilerMetricLabels_ProfilerMetricType.
var (
	TrialProfilerMetricLabels_ProfilerMetricType_name = map[int32]string{
		0: "PROFILER_METRIC_TYPE_UNSPECIFIED",
		1: "PROFILER_METRIC_TYPE_SYSTEM",
		2: "PROFILER_METRIC_TYPE_TIMING",
		3: "PROFILER_METRIC_TYPE_MISC",
	}
	TrialProfilerMetricLabels_ProfilerMetricType_value = map[string]int32{
		"PROFILER_METRIC_TYPE_UNSPECIFIED": 0,
		"PROFILER_METRIC_TYPE_SYSTEM":      1,
		"PROFILER_METRIC_TYPE_TIMING":      2,
		"PROFILER_METRIC_TYPE_MISC":        3,
	}
)

func (x TrialProfilerMetricLabels_ProfilerMetricType) Enum() *TrialProfilerMetricLabels_ProfilerMetricType {
	p := new(TrialProfilerMetricLabels_ProfilerMetricType)
	*p = x
	return p
}

func (x TrialProfilerMetricLabels_ProfilerMetricType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TrialProfilerMetricLabels_ProfilerMetricType) Descriptor() protoreflect.EnumDescriptor {
	return file_determined_trial_v1_trial_proto_enumTypes[2].Descriptor()
}

func (TrialProfilerMetricLabels_ProfilerMetricType) Type() protoreflect.EnumType {
	return &file_determined_trial_v1_trial_proto_enumTypes[2]
}

func (x TrialProfilerMetricLabels_ProfilerMetricType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TrialProfilerMetricLabels_ProfilerMetricType.Descriptor instead.
func (TrialProfilerMetricLabels_ProfilerMetricType) EnumDescriptor() ([]byte, []int) {
	return file_determined_trial_v1_trial_proto_rawDescGZIP(), []int{3, 0}
}

// The reason for an early exit.
type TrialEarlyExit_ExitedReason int32

const (
	// Zero-value (not allowed).
	TrialEarlyExit_EXITED_REASON_UNSPECIFIED TrialEarlyExit_ExitedReason = 0
	// Indicates the trial exited due to an invalid hyperparameter.
	TrialEarlyExit_EXITED_REASON_INVALID_HP TrialEarlyExit_ExitedReason = 1
	// Indicates the trial exited due to an invalid hyperparameter
	// in the trial init.
	TrialEarlyExit_EXITED_REASON_INIT_INVALID_HP TrialEarlyExit_ExitedReason = 3
)

// Enum value maps for TrialEarlyExit_ExitedReason.
var (
	TrialEarlyExit_ExitedReason_name = map[int32]string{
		0: "EXITED_REASON_UNSPECIFIED",
		1: "EXITED_REASON_INVALID_HP",
		3: "EXITED_REASON_INIT_INVALID_HP",
	}
	TrialEarlyExit_ExitedReason_value = map[string]int32{
		"EXITED_REASON_UNSPECIFIED":     0,
		"EXITED_REASON_INVALID_HP":      1,
		"EXITED_REASON_INIT_INVALID_HP": 3,
	}
)

func (x TrialEarlyExit_ExitedReason) Enum() *TrialEarlyExit_ExitedReason {
	p := new(TrialEarlyExit_ExitedReason)
	*p = x
	return p
}

func (x TrialEarlyExit_ExitedReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TrialEarlyExit_ExitedReason) Descriptor() protoreflect.EnumDescriptor {
	return file_determined_trial_v1_trial_proto_enumTypes[3].Descriptor()
}

func (TrialEarlyExit_ExitedReason) Type() protoreflect.EnumType {
	return &file_determined_trial_v1_trial_proto_enumTypes[3]
}

func (x TrialEarlyExit_ExitedReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TrialEarlyExit_ExitedReason.Descriptor instead.
func (TrialEarlyExit_ExitedReason) EnumDescriptor() ([]byte, []int) {
	return file_determined_trial_v1_trial_proto_rawDescGZIP(), []int{5, 0}
}

// CheckpointWorkload is an artifact created by a trial during training.
type CheckpointWorkload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// UUID of the checkpoint.
	Uuid string `protobuf:"bytes,1,opt,name=uuid,proto3" json:"uuid,omitempty"`
	// The time the workload finished or was stopped.
	EndTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The state of the checkpoint.
	State checkpointv1.State `protobuf:"varint,4,opt,name=state,proto3,enum=determined.checkpoint.v1.State" json:"state,omitempty"`
	// Dictionary of file paths to file sizes in bytes of all files in the
	// checkpoint.
	Resources map[string]int64 `protobuf:"bytes,5,rep,name=resources,proto3" json:"resources,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// Total number of batches as of this workload's completion.
	TotalBatches int32 `protobuf:"varint,8,opt,name=total_batches,json=totalBatches,proto3" json:"total_batches,omitempty"`
	// User defined metadata associated with the checkpoint.
	Metadata *_struct.Struct `protobuf:"bytes,9,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *CheckpointWorkload) Reset() {
	*x = CheckpointWorkload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_trial_v1_trial_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckpointWorkload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckpointWorkload) ProtoMessage() {}

func (x *CheckpointWorkload) ProtoReflect() protoreflect.Message {
	mi := &file_determined_trial_v1_trial_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckpointWorkload.ProtoReflect.Descriptor instead.
func (*CheckpointWorkload) Descriptor() ([]byte, []int) {
	return file_determined_trial_v1_trial_proto_rawDescGZIP(), []int{0}
}

func (x *CheckpointWorkload) GetUuid() string {
	if x != nil {
		return x.Uuid
	}
	return ""
}

func (x *CheckpointWorkload) GetEndTime() *timestamp.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *CheckpointWorkload) GetState() checkpointv1.State {
	if x != nil {
		return x.State
	}
	return checkpointv1.State_STATE_UNSPECIFIED
}

func (x *CheckpointWorkload) GetResources() map[string]int64 {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *CheckpointWorkload) GetTotalBatches() int32 {
	if x != nil {
		return x.TotalBatches
	}
	return 0
}

func (x *CheckpointWorkload) GetMetadata() *_struct.Struct {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// MetricsWorkload is a workload generating metrics.
type MetricsWorkload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time the workload finished or was stopped.
	EndTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Metrics.
	Metrics *commonv1.Metrics `protobuf:"bytes,40,opt,name=metrics,proto3" json:"metrics,omitempty"`
	// Number of inputs processed.
	//
	// Deprecated: Do not use.
	NumInputs int32 `protobuf:"varint,5,opt,name=num_inputs,json=numInputs,proto3" json:"num_inputs,omitempty"`
	// Total number of batches as of this workload's completion.
	TotalBatches int32 `protobuf:"varint,8,opt,name=total_batches,json=totalBatches,proto3" json:"total_batches,omitempty"`
}

func (x *MetricsWorkload) Reset() {
	*x = MetricsWorkload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_trial_v1_trial_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetricsWorkload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricsWorkload) ProtoMessage() {}

func (x *MetricsWorkload) ProtoReflect() protoreflect.Message {
	mi := &file_determined_trial_v1_trial_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricsWorkload.ProtoReflect.Descriptor instead.
func (*MetricsWorkload) Descriptor() ([]byte, []int) {
	return file_determined_trial_v1_trial_proto_rawDescGZIP(), []int{1}
}

func (x *MetricsWorkload) GetEndTime() *timestamp.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *MetricsWorkload) GetMetrics() *commonv1.Metrics {
	if x != nil {
		return x.Metrics
	}
	return nil
}

// Deprecated: Do not use.
func (x *MetricsWorkload) GetNumInputs() int32 {
	if x != nil {
		return x.NumInputs
	}
	return 0
}

func (x *MetricsWorkload) GetTotalBatches() int32 {
	if x != nil {
		return x.TotalBatches
	}
	return 0
}

// Trial is a set of workloads and are exploring a determined set of
// hyperparameters.
type Trial struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the trial.
	Id int32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// The id of the parent experiment.
	ExperimentId int32 `protobuf:"varint,2,opt,name=experiment_id,json=experimentId,proto3" json:"experiment_id,omitempty"`
	// The time the trial was started.
	StartTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time the trial ended if the trial is stopped.
	EndTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The current state of the trial.
	State State `protobuf:"varint,5,opt,name=state,proto3,enum=determined.trial.v1.State" json:"state,omitempty"`
	// Number times the trial restarted.
	Restarts int32 `protobuf:"varint,17,opt,name=restarts,proto3" json:"restarts,omitempty"`
	// Trial hyperparameters.
	Hparams *_struct.Struct `protobuf:"bytes,6,opt,name=hparams,proto3" json:"hparams,omitempty"`
	// The current processed batches.
	TotalBatchesProcessed int32 `protobuf:"varint,7,opt,name=total_batches_processed,json=totalBatchesProcessed,proto3" json:"total_batches_processed,omitempty"`
	// Best validation.
	BestValidation *MetricsWorkload `protobuf:"bytes,8,opt,name=best_validation,json=bestValidation,proto3" json:"best_validation,omitempty"`
	// Latest validation.
	LatestValidation *MetricsWorkload `protobuf:"bytes,9,opt,name=latest_validation,json=latestValidation,proto3" json:"latest_validation,omitempty"`
	// Best checkpoint.
	BestCheckpoint *CheckpointWorkload `protobuf:"bytes,10,opt,name=best_checkpoint,json=bestCheckpoint,proto3" json:"best_checkpoint,omitempty"`
	// The last reported state of the trial runner (harness code).
	RunnerState string `protobuf:"bytes,11,opt,name=runner_state,json=runnerState,proto3" json:"runner_state,omitempty"`
	// The wall clock time is all active time of the cluster for the trial,
	// inclusive of everything (restarts, initiailization, etc), in seconds.
	WallClockTime float64 `protobuf:"fixed64,12,opt,name=wall_clock_time,json=wallClockTime,proto3" json:"wall_clock_time,omitempty"`
	// UUID of checkpoint that this trial started from.
	WarmStartCheckpointUuid string `protobuf:"bytes,13,opt,name=warm_start_checkpoint_uuid,json=warmStartCheckpointUuid,proto3" json:"warm_start_checkpoint_uuid,omitempty"`
	// Id of the first task associated with this trial.
	// This field is deprecated since trials can have multiple tasks.
	//
	// Deprecated: Do not use.
	TaskId string `protobuf:"bytes,14,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	// The sum of sizes of all resources in all checkpoints for the trial.
	TotalCheckpointSize uint64 `protobuf:"varint,15,opt,name=total_checkpoint_size,json=totalCheckpointSize,proto3" json:"total_checkpoint_size,omitempty"`
	// The count of checkpoints.
	CheckpointCount int32 `protobuf:"varint,18,opt,name=checkpoint_count,json=checkpointCount,proto3" json:"checkpoint_count,omitempty"`
	// summary metrics
	SummaryMetrics *_struct.Struct `protobuf:"bytes,19,opt,name=summary_metrics,json=summaryMetrics,proto3" json:"summary_metrics,omitempty"`
	// Task IDs of tasks associated with this trial.
	// Length of task_ids will always be greater or equal to one when TaskID is
	// sent. For example CompareTrial we will send a reduced Trial object, without
	// TaskID or TaskIDs fileld in. The first element of task_ids will be the same
	// as task_id. task_ids is sorted ascending by task_run_id.
	TaskIds []string `protobuf:"bytes,20,rep,name=task_ids,json=taskIds,proto3" json:"task_ids,omitempty"`
	// Signed searcher metrics value.
	SearcherMetricValue float64 `protobuf:"fixed64,21,opt,name=searcher_metric_value,json=searcherMetricValue,proto3" json:"searcher_metric_value,omitempty"`
	// Number of days to retain logs for.
	LogRetentionDays *int32 `protobuf:"varint,22,opt,name=log_retention_days,json=logRetentionDays,proto3,oneof" json:"log_retention_days,omitempty"`
	// metadata associated with the trial (based off the metadata stored in the
	// run).
	Metadata *_struct.Struct `protobuf:"bytes,23,opt,name=metadata,proto3,oneof" json:"metadata,omitempty"`
	// Log Policy Matched.
	LogPolicyMatched *string `protobuf:"bytes,24,opt,name=log_policy_matched,json=logPolicyMatched,proto3,oneof" json:"log_policy_matched,omitempty"`
}

func (x *Trial) Reset() {
	*x = Trial{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_trial_v1_trial_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Trial) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Trial) ProtoMessage() {}

func (x *Trial) ProtoReflect() protoreflect.Message {
	mi := &file_determined_trial_v1_trial_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Trial.ProtoReflect.Descriptor instead.
func (*Trial) Descriptor() ([]byte, []int) {
	return file_determined_trial_v1_trial_proto_rawDescGZIP(), []int{2}
}

func (x *Trial) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Trial) GetExperimentId() int32 {
	if x != nil {
		return x.ExperimentId
	}
	return 0
}

func (x *Trial) GetStartTime() *timestamp.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Trial) GetEndTime() *timestamp.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Trial) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STATE_UNSPECIFIED
}

func (x *Trial) GetRestarts() int32 {
	if x != nil {
		return x.Restarts
	}
	return 0
}

func (x *Trial) GetHparams() *_struct.Struct {
	if x != nil {
		return x.Hparams
	}
	return nil
}

func (x *Trial) GetTotalBatchesProcessed() int32 {
	if x != nil {
		return x.TotalBatchesProcessed
	}
	return 0
}

func (x *Trial) GetBestValidation() *MetricsWorkload {
	if x != nil {
		return x.BestValidation
	}
	return nil
}

func (x *Trial) GetLatestValidation() *MetricsWorkload {
	if x != nil {
		return x.LatestValidation
	}
	return nil
}

func (x *Trial) GetBestCheckpoint() *CheckpointWorkload {
	if x != nil {
		return x.BestCheckpoint
	}
	return nil
}

func (x *Trial) GetRunnerState() string {
	if x != nil {
		return x.RunnerState
	}
	return ""
}

func (x *Trial) GetWallClockTime() float64 {
	if x != nil {
		return x.WallClockTime
	}
	return 0
}

func (x *Trial) GetWarmStartCheckpointUuid() string {
	if x != nil {
		return x.WarmStartCheckpointUuid
	}
	return ""
}

// Deprecated: Do not use.
func (x *Trial) GetTaskId() string {
	if x != nil {
		return x.TaskId
	}
	return ""
}

func (x *Trial) GetTotalCheckpointSize() uint64 {
	if x != nil {
		return x.TotalCheckpointSize
	}
	return 0
}

func (x *Trial) GetCheckpointCount() int32 {
	if x != nil {
		return x.CheckpointCount
	}
	return 0
}

func (x *Trial) GetSummaryMetrics() *_struct.Struct {
	if x != nil {
		return x.SummaryMetrics
	}
	return nil
}

func (x *Trial) GetTaskIds() []string {
	if x != nil {
		return x.TaskIds
	}
	return nil
}

func (x *Trial) GetSearcherMetricValue() float64 {
	if x != nil {
		return x.SearcherMetricValue
	}
	return 0
}

func (x *Trial) GetLogRetentionDays() int32 {
	if x != nil && x.LogRetentionDays != nil {
		return *x.LogRetentionDays
	}
	return 0
}

func (x *Trial) GetMetadata() *_struct.Struct {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Trial) GetLogPolicyMatched() string {
	if x != nil && x.LogPolicyMatched != nil {
		return *x.LogPolicyMatched
	}
	return ""
}

// TrialProfilerMetricLabels are the labels for a single series, where a series
// is a defined as all metrics sharing a distinct set of labels
type TrialProfilerMetricLabels struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the trial.
	TrialId int32 `protobuf:"varint,1,opt,name=trial_id,json=trialId,proto3" json:"trial_id,omitempty"`
	// The name of the metric.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The agent ID associated with the metric.
	AgentId string `protobuf:"bytes,3,opt,name=agent_id,json=agentId,proto3" json:"agent_id,omitempty"`
	// The GPU UUID associated with the metric.
	GpuUuid string `protobuf:"bytes,4,opt,name=gpu_uuid,json=gpuUuid,proto3" json:"gpu_uuid,omitempty"`
	// The type of the metric.
	MetricType TrialProfilerMetricLabels_ProfilerMetricType `protobuf:"varint,5,opt,name=metric_type,json=metricType,proto3,enum=determined.trial.v1.TrialProfilerMetricLabels_ProfilerMetricType" json:"metric_type,omitempty"`
}

func (x *TrialProfilerMetricLabels) Reset() {
	*x = TrialProfilerMetricLabels{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_trial_v1_trial_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrialProfilerMetricLabels) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrialProfilerMetricLabels) ProtoMessage() {}

func (x *TrialProfilerMetricLabels) ProtoReflect() protoreflect.Message {
	mi := &file_determined_trial_v1_trial_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrialProfilerMetricLabels.ProtoReflect.Descriptor instead.
func (*TrialProfilerMetricLabels) Descriptor() ([]byte, []int) {
	return file_determined_trial_v1_trial_proto_rawDescGZIP(), []int{3}
}

func (x *TrialProfilerMetricLabels) GetTrialId() int32 {
	if x != nil {
		return x.TrialId
	}
	return 0
}

func (x *TrialProfilerMetricLabels) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TrialProfilerMetricLabels) GetAgentId() string {
	if x != nil {
		return x.AgentId
	}
	return ""
}

func (x *TrialProfilerMetricLabels) GetGpuUuid() string {
	if x != nil {
		return x.GpuUuid
	}
	return ""
}

func (x *TrialProfilerMetricLabels) GetMetricType() TrialProfilerMetricLabels_ProfilerMetricType {
	if x != nil {
		return x.MetricType
	}
	return TrialProfilerMetricLabels_PROFILER_METRIC_TYPE_UNSPECIFIED
}

// TrialProfilerMetricsBatch is a batch of trial profiler metrics. A batch will
// contain metrics pertaining to a single series. The fields values, batches and
// timestamps will be equal length arrays with each index corresponding to a
// reading.
type TrialProfilerMetricsBatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The measurement for a reading, repeated for the batch of metrics.
	Values []float32 `protobuf:"fixed32,1,rep,packed,name=values,proto3" json:"values,omitempty"`
	// The batch at which a reading occurred, repeated for the batch of metrics.
	Batches []int32 `protobuf:"varint,2,rep,packed,name=batches,proto3" json:"batches,omitempty"`
	// The timestamp at which a reading occurred, repeated for the batch of
	// metrics.
	Timestamps []*timestamp.Timestamp `protobuf:"bytes,3,rep,name=timestamps,proto3" json:"timestamps,omitempty"`
	// The labels for this series.
	Labels *TrialProfilerMetricLabels `protobuf:"bytes,4,opt,name=labels,proto3" json:"labels,omitempty"`
}

func (x *TrialProfilerMetricsBatch) Reset() {
	*x = TrialProfilerMetricsBatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_trial_v1_trial_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrialProfilerMetricsBatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrialProfilerMetricsBatch) ProtoMessage() {}

func (x *TrialProfilerMetricsBatch) ProtoReflect() protoreflect.Message {
	mi := &file_determined_trial_v1_trial_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrialProfilerMetricsBatch.ProtoReflect.Descriptor instead.
func (*TrialProfilerMetricsBatch) Descriptor() ([]byte, []int) {
	return file_determined_trial_v1_trial_proto_rawDescGZIP(), []int{4}
}

func (x *TrialProfilerMetricsBatch) GetValues() []float32 {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *TrialProfilerMetricsBatch) GetBatches() []int32 {
	if x != nil {
		return x.Batches
	}
	return nil
}

func (x *TrialProfilerMetricsBatch) GetTimestamps() []*timestamp.Timestamp {
	if x != nil {
		return x.Timestamps
	}
	return nil
}

func (x *TrialProfilerMetricsBatch) GetLabels() *TrialProfilerMetricLabels {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Signals to the experiment the trial early exited.
type TrialEarlyExit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The reason for the exit.
	Reason TrialEarlyExit_ExitedReason `protobuf:"varint,1,opt,name=reason,proto3,enum=determined.trial.v1.TrialEarlyExit_ExitedReason" json:"reason,omitempty"`
}

func (x *TrialEarlyExit) Reset() {
	*x = TrialEarlyExit{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_trial_v1_trial_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrialEarlyExit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrialEarlyExit) ProtoMessage() {}

func (x *TrialEarlyExit) ProtoReflect() protoreflect.Message {
	mi := &file_determined_trial_v1_trial_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrialEarlyExit.ProtoReflect.Descriptor instead.
func (*TrialEarlyExit) Descriptor() ([]byte, []int) {
	return file_determined_trial_v1_trial_proto_rawDescGZIP(), []int{5}
}

func (x *TrialEarlyExit) GetReason() TrialEarlyExit_ExitedReason {
	if x != nil {
		return x.Reason
	}
	return TrialEarlyExit_EXITED_REASON_UNSPECIFIED
}

// The rendezvous info for the trial to rendezvous with sibling containers.
type RendezvousInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The rendezvous addresses of the other containers.
	Addresses []string `protobuf:"bytes,1,rep,name=addresses,proto3" json:"addresses,omitempty"`
	// The container rank.
	Rank int32 `protobuf:"varint,2,opt,name=rank,proto3" json:"rank,omitempty"`
	// The slots for each address, respectively.
	Slots []int32 `protobuf:"varint,3,rep,packed,name=slots,proto3" json:"slots,omitempty"`
}

func (x *RendezvousInfo) Reset() {
	*x = RendezvousInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_trial_v1_trial_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RendezvousInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RendezvousInfo) ProtoMessage() {}

func (x *RendezvousInfo) ProtoReflect() protoreflect.Message {
	mi := &file_determined_trial_v1_trial_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RendezvousInfo.ProtoReflect.Descriptor instead.
func (*RendezvousInfo) Descriptor() ([]byte, []int) {
	return file_determined_trial_v1_trial_proto_rawDescGZIP(), []int{6}
}

func (x *RendezvousInfo) GetAddresses() []string {
	if x != nil {
		return x.Addresses
	}
	return nil
}

func (x *RendezvousInfo) GetRank() int32 {
	if x != nil {
		return x.Rank
	}
	return 0
}

func (x *RendezvousInfo) GetSlots() []int32 {
	if x != nil {
		return x.Slots
	}
	return nil
}

// The metadata pertaining to the current running task for a trial.
type TrialRunnerMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The state of the trial runner.
	State string `protobuf:"bytes,1,opt,name=state,proto3" json:"state,omitempty"`
}

func (x *TrialRunnerMetadata) Reset() {
	*x = TrialRunnerMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_trial_v1_trial_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrialRunnerMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrialRunnerMetadata) ProtoMessage() {}

func (x *TrialRunnerMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_determined_trial_v1_trial_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrialRunnerMetadata.ProtoReflect.Descriptor instead.
func (*TrialRunnerMetadata) Descriptor() ([]byte, []int) {
	return file_determined_trial_v1_trial_proto_rawDescGZIP(), []int{7}
}

func (x *TrialRunnerMetadata) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

// Metrics from the trial some duration of training.
type TrialMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The trial associated with these metrics.
	TrialId int32 `protobuf:"varint,1,opt,name=trial_id,json=trialId,proto3" json:"trial_id,omitempty"`
	// The trial run associated with these metrics.
	TrialRunId int32 `protobuf:"varint,2,opt,name=trial_run_id,json=trialRunId,proto3" json:"trial_run_id,omitempty"`
	// The number of batches trained on when these metrics were reported.
	StepsCompleted *int32 `protobuf:"varint,3,opt,name=steps_completed,json=stepsCompleted,proto3,oneof" json:"steps_completed,omitempty"`
	// The client-reported time associated with these metrics.
	ReportTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=report_time,json=reportTime,proto3,oneof" json:"report_time,omitempty"`
	// The metrics for this bit of training, including:
	// - avg_metrics: metrics reduced over the reporting period).
	// - batch_metrics: (optional) per-batch metrics.
	Metrics *commonv1.Metrics `protobuf:"bytes,9,opt,name=metrics,proto3" json:"metrics,omitempty"`
}

func (x *TrialMetrics) Reset() {
	*x = TrialMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_trial_v1_trial_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrialMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrialMetrics) ProtoMessage() {}

func (x *TrialMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_determined_trial_v1_trial_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrialMetrics.ProtoReflect.Descriptor instead.
func (*TrialMetrics) Descriptor() ([]byte, []int) {
	return file_determined_trial_v1_trial_proto_rawDescGZIP(), []int{8}
}

func (x *TrialMetrics) GetTrialId() int32 {
	if x != nil {
		return x.TrialId
	}
	return 0
}

func (x *TrialMetrics) GetTrialRunId() int32 {
	if x != nil {
		return x.TrialRunId
	}
	return 0
}

func (x *TrialMetrics) GetStepsCompleted() int32 {
	if x != nil && x.StepsCompleted != nil {
		return *x.StepsCompleted
	}
	return 0
}

func (x *TrialMetrics) GetReportTime() *timestamp.Timestamp {
	if x != nil {
		return x.ReportTime
	}
	return nil
}

func (x *TrialMetrics) GetMetrics() *commonv1.Metrics {
	if x != nil {
		return x.Metrics
	}
	return nil
}

// Metrics report.
type MetricsReport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the trial.
	TrialId int32 `protobuf:"varint,1,opt,name=trial_id,json=trialId,proto3" json:"trial_id,omitempty"`
	// End time of when metric was reported.
	EndTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Struct of the reported metrics.
	Metrics *_struct.Struct `protobuf:"bytes,3,opt,name=metrics,proto3" json:"metrics,omitempty"`
	// batches completed in the report.
	TotalBatches int32 `protobuf:"varint,4,opt,name=total_batches,json=totalBatches,proto3" json:"total_batches,omitempty"`
	// If metric is archived.
	Archived bool `protobuf:"varint,5,opt,name=archived,proto3" json:"archived,omitempty"`
	// ID of metric in table.
	Id int32 `protobuf:"varint,6,opt,name=id,proto3" json:"id,omitempty"`
	// Run ID of trial when metric was reported.
	TrialRunId int32 `protobuf:"varint,7,opt,name=trial_run_id,json=trialRunId,proto3" json:"trial_run_id,omitempty"`
	// Name of the Metric Group ("training", "validation", anything else)
	Group string `protobuf:"bytes,8,opt,name=group,proto3" json:"group,omitempty"`
}

func (x *MetricsReport) Reset() {
	*x = MetricsReport{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_trial_v1_trial_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetricsReport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricsReport) ProtoMessage() {}

func (x *MetricsReport) ProtoReflect() protoreflect.Message {
	mi := &file_determined_trial_v1_trial_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricsReport.ProtoReflect.Descriptor instead.
func (*MetricsReport) Descriptor() ([]byte, []int) {
	return file_determined_trial_v1_trial_proto_rawDescGZIP(), []int{9}
}

func (x *MetricsReport) GetTrialId() int32 {
	if x != nil {
		return x.TrialId
	}
	return 0
}

func (x *MetricsReport) GetEndTime() *timestamp.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *MetricsReport) GetMetrics() *_struct.Struct {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *MetricsReport) GetTotalBatches() int32 {
	if x != nil {
		return x.TotalBatches
	}
	return 0
}

func (x *MetricsReport) GetArchived() bool {
	if x != nil {
		return x.Archived
	}
	return false
}

func (x *MetricsReport) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *MetricsReport) GetTrialRunId() int32 {
	if x != nil {
		return x.TrialRunId
	}
	return 0
}

func (x *MetricsReport) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

// Denotes a connection between a given trial and a
// checkpoint or model_version
type TrialSourceInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the trial.
	TrialId int32 `protobuf:"varint,1,opt,name=trial_id,json=trialId,proto3" json:"trial_id,omitempty"`
	// UUID of the checkpoint.
	CheckpointUuid string `protobuf:"bytes,2,opt,name=checkpoint_uuid,json=checkpointUuid,proto3" json:"checkpoint_uuid,omitempty"`
	// Source `id“ for the model which generated the checkpoint (if applicable)
	ModelId *int32 `protobuf:"varint,3,opt,name=model_id,json=modelId,proto3,oneof" json:"model_id,omitempty"`
	// Source `version` in the model_version version field which generated the
	// checkpoint (if applicable)
	ModelVersion *int32 `protobuf:"varint,4,opt,name=model_version,json=modelVersion,proto3,oneof" json:"model_version,omitempty"`
	// Type for this trial_source_info
	TrialSourceInfoType TrialSourceInfoType `protobuf:"varint,5,opt,name=trial_source_info_type,json=trialSourceInfoType,proto3,enum=determined.trial.v1.TrialSourceInfoType" json:"trial_source_info_type,omitempty"`
}

func (x *TrialSourceInfo) Reset() {
	*x = TrialSourceInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_trial_v1_trial_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrialSourceInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrialSourceInfo) ProtoMessage() {}

func (x *TrialSourceInfo) ProtoReflect() protoreflect.Message {
	mi := &file_determined_trial_v1_trial_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrialSourceInfo.ProtoReflect.Descriptor instead.
func (*TrialSourceInfo) Descriptor() ([]byte, []int) {
	return file_determined_trial_v1_trial_proto_rawDescGZIP(), []int{10}
}

func (x *TrialSourceInfo) GetTrialId() int32 {
	if x != nil {
		return x.TrialId
	}
	return 0
}

func (x *TrialSourceInfo) GetCheckpointUuid() string {
	if x != nil {
		return x.CheckpointUuid
	}
	return ""
}

func (x *TrialSourceInfo) GetModelId() int32 {
	if x != nil && x.ModelId != nil {
		return *x.ModelId
	}
	return 0
}

func (x *TrialSourceInfo) GetModelVersion() int32 {
	if x != nil && x.ModelVersion != nil {
		return *x.ModelVersion
	}
	return 0
}

func (x *TrialSourceInfo) GetTrialSourceInfoType() TrialSourceInfoType {
	if x != nil {
		return x.TrialSourceInfoType
	}
	return TrialSourceInfoType_TRIAL_SOURCE_INFO_TYPE_UNSPECIFIED
}

var File_determined_trial_v1_trial_proto protoreflect.FileDescriptor

var file_determined_trial_v1_trial_proto_rawDesc = []byte{
	0x0a, 0x1f, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x74, 0x72, 0x69,
	0x61, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x13, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72,
	0x69, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64,
	0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69,
	0x6e, 0x65, 0x64, 0x2f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2f, 0x76,
	0x31, 0x2f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d,
	0x73, 0x77, 0x61, 0x67, 0x67, 0x65, 0x72, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xa3, 0x03, 0x0a, 0x12, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x75, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x75, 0x75, 0x69, 0x64, 0x12, 0x35, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e,
	0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x54, 0x0a, 0x09, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72, 0x69, 0x61, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x57, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x12, 0x23, 0x0a, 0x0d, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x65,
	0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x73, 0x12, 0x33, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x3c, 0x0a, 0x0e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x1d, 0x92, 0x41, 0x1a, 0x0a, 0x18, 0xd2,
	0x01, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0xd2, 0x01, 0x0d, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f,
	0x62, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x22, 0xff, 0x01, 0x0a, 0x0f, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x35, 0x0a, 0x08, 0x65,
	0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x37, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x28, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x21, 0x0a, 0x0a, 0x6e,
	0x75, 0x6d, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x09, 0x6e, 0x75, 0x6d, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x23,
	0x0a, 0x0d, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x73, 0x3a, 0x34, 0x92, 0x41, 0x31, 0x0a, 0x2f, 0xd2, 0x01, 0x07, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0xd2, 0x01, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0xd2, 0x01, 0x0a, 0x6e,
	0x75, 0x6d, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0xd2, 0x01, 0x0d, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x22, 0xa7, 0x0a, 0x0a, 0x05, 0x54, 0x72,
	0x69, 0x61, 0x6c, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x02, 0x69, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x65, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x30, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x64, 0x65, 0x74, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1a, 0x0a, 0x08,
	0x72, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x72, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x73, 0x12, 0x31, 0x0a, 0x07, 0x68, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x52, 0x07, 0x68, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x36, 0x0a, 0x17, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x5f, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x15, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x65, 0x64, 0x12, 0x4d, 0x0a, 0x0f, 0x62, 0x65, 0x73, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x64,
	0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x52, 0x0e, 0x62, 0x65, 0x73, 0x74, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x11, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72, 0x69, 0x61, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x57, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x52, 0x10, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x0f, 0x62, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x68,
	0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72, 0x69, 0x61,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x57,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x0e, 0x62, 0x65, 0x73, 0x74, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x75, 0x6e, 0x6e, 0x65,
	0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72,
	0x75, 0x6e, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x77, 0x61,
	0x6c, 0x6c, 0x5f, 0x63, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x01, 0x52, 0x0d, 0x77, 0x61, 0x6c, 0x6c, 0x43, 0x6c, 0x6f, 0x63, 0x6b, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x1a, 0x77, 0x61, 0x72, 0x6d, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x75, 0x75, 0x69, 0x64,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x17, 0x77, 0x61, 0x72, 0x6d, 0x53, 0x74, 0x61, 0x72,
	0x74, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x55, 0x75, 0x69, 0x64, 0x12,
	0x1b, 0x0a, 0x07, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x06, 0x74, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x12, 0x32, 0x0a, 0x15,
	0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x04, 0x52, 0x13, 0x74, 0x6f, 0x74,
	0x61, 0x6c, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x29, 0x0a, 0x10, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x12, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x63, 0x68, 0x65, 0x63,
	0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0f, 0x73,
	0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x13,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0e, 0x73,
	0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x19, 0x0a,
	0x08, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x14, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x07, 0x74, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x65, 0x72, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x15, 0x20, 0x01, 0x28, 0x01, 0x52, 0x13, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65,
	0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x31, 0x0a, 0x12,
	0x6c, 0x6f, 0x67, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61,
	0x79, 0x73, 0x18, 0x16, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x10, 0x6c, 0x6f, 0x67, 0x52,
	0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x79, 0x73, 0x88, 0x01, 0x01, 0x12,
	0x38, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x17, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x48, 0x01, 0x52, 0x08, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x88, 0x01, 0x01, 0x12, 0x31, 0x0a, 0x12, 0x6c, 0x6f, 0x67,
	0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x18,
	0x18, 0x20, 0x01, 0x28, 0x09, 0x48, 0x02, 0x52, 0x10, 0x6c, 0x6f, 0x67, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x88, 0x01, 0x01, 0x3a, 0x5a, 0x92, 0x41,
	0x57, 0x0a, 0x55, 0xd2, 0x01, 0x02, 0x69, 0x64, 0xd2, 0x01, 0x0c, 0x65, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0xd2, 0x01, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0xd2, 0x01, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0xd2, 0x01, 0x08, 0x72, 0x65,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x73, 0xd2, 0x01, 0x07, 0x68, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0xd2, 0x01, 0x15, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x6c, 0x6f, 0x67,
	0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x42,
	0x0b, 0x0a, 0x09, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x15, 0x0a, 0x13,
	0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x6d, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x64, 0x22, 0x9b, 0x03, 0x0a, 0x19, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x07, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x19, 0x0a, 0x08, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x67,
	0x70, 0x75, 0x5f, 0x75, 0x75, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67,
	0x70, 0x75, 0x55, 0x75, 0x69, 0x64, 0x12, 0x62, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x64, 0x65,
	0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x72, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x22, 0x9b, 0x01, 0x0a, 0x12, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x24, 0x0a, 0x20, 0x50, 0x52, 0x4f, 0x46, 0x49, 0x4c, 0x45, 0x52, 0x5f, 0x4d, 0x45,
	0x54, 0x52, 0x49, 0x43, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1f, 0x0a, 0x1b, 0x50, 0x52, 0x4f, 0x46, 0x49,
	0x4c, 0x45, 0x52, 0x5f, 0x4d, 0x45, 0x54, 0x52, 0x49, 0x43, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x53, 0x59, 0x53, 0x54, 0x45, 0x4d, 0x10, 0x01, 0x12, 0x1f, 0x0a, 0x1b, 0x50, 0x52, 0x4f, 0x46,
	0x49, 0x4c, 0x45, 0x52, 0x5f, 0x4d, 0x45, 0x54, 0x52, 0x49, 0x43, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x54, 0x49, 0x4d, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x1d, 0x0a, 0x19, 0x50, 0x52, 0x4f,
	0x46, 0x49, 0x4c, 0x45, 0x52, 0x5f, 0x4d, 0x45, 0x54, 0x52, 0x49, 0x43, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x4d, 0x49, 0x53, 0x43, 0x10, 0x03, 0x3a, 0x17, 0x92, 0x41, 0x14, 0x0a, 0x12, 0xd2,
	0x01, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x81, 0x02, 0x0a, 0x19, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x42, 0x61, 0x74, 0x63, 0x68, 0x12,
	0x16, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x02, 0x52,
	0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x62, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x05, 0x52, 0x07, 0x62, 0x61, 0x74, 0x63, 0x68, 0x65,
	0x73, 0x12, 0x3a, 0x0a, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x73, 0x12, 0x46, 0x0a,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72, 0x69, 0x61, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x3a, 0x2e, 0x92, 0x41, 0x2b, 0x0a, 0x29, 0xd2, 0x01, 0x06, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0xd2, 0x01, 0x07, 0x62, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0xd2,
	0x01, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x73, 0xd2, 0x01, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x22, 0xda, 0x01, 0x0a, 0x0e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x45,
	0x61, 0x72, 0x6c, 0x79, 0x45, 0x78, 0x69, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72,
	0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x72, 0x69, 0x61, 0x6c, 0x45, 0x61, 0x72, 0x6c, 0x79, 0x45, 0x78, 0x69, 0x74, 0x2e, 0x45, 0x78,
	0x69, 0x74, 0x65, 0x64, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x22, 0x6e, 0x0a, 0x0c, 0x45, 0x78, 0x69, 0x74, 0x65, 0x64, 0x52, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x19, 0x45, 0x58, 0x49, 0x54, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x41,
	0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x1c, 0x0a, 0x18, 0x45, 0x58, 0x49, 0x54, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x41, 0x53,
	0x4f, 0x4e, 0x5f, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x48, 0x50, 0x10, 0x01, 0x12,
	0x21, 0x0a, 0x1d, 0x45, 0x58, 0x49, 0x54, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e,
	0x5f, 0x49, 0x4e, 0x49, 0x54, 0x5f, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x48, 0x50,
	0x10, 0x03, 0x3a, 0x0e, 0x92, 0x41, 0x0b, 0x0a, 0x09, 0xd2, 0x01, 0x06, 0x72, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x22, 0x7a, 0x0a, 0x0e, 0x52, 0x65, 0x6e, 0x64, 0x65, 0x7a, 0x76, 0x6f, 0x75, 0x73,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1c, 0x0a, 0x09, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x61, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x04, 0x72, 0x61, 0x6e, 0x6b, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x6c, 0x6f, 0x74, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x05, 0x52, 0x05, 0x73, 0x6c, 0x6f, 0x74, 0x73, 0x3a, 0x20, 0x92, 0x41,
	0x1d, 0x0a, 0x1b, 0xd2, 0x01, 0x09, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0xd2,
	0x01, 0x04, 0x72, 0x61, 0x6e, 0x6b, 0xd2, 0x01, 0x05, 0x73, 0x6c, 0x6f, 0x74, 0x73, 0x22, 0x3a,
	0x0a, 0x13, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x75, 0x6e, 0x6e, 0x65, 0x72, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x3a, 0x0d, 0x92, 0x41, 0x0a,
	0x0a, 0x08, 0xd2, 0x01, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0xc3, 0x02, 0x0a, 0x0c, 0x54,
	0x72, 0x69, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x74,
	0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x74,
	0x72, 0x69, 0x61, 0x6c, 0x49, 0x64, 0x12, 0x20, 0x0a, 0x0c, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f,
	0x72, 0x75, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x74, 0x72,
	0x69, 0x61, 0x6c, 0x52, 0x75, 0x6e, 0x49, 0x64, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x74, 0x65, 0x70,
	0x73, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x05, 0x48, 0x00, 0x52, 0x0e, 0x73, 0x74, 0x65, 0x70, 0x73, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
	0x74, 0x65, 0x64, 0x88, 0x01, 0x01, 0x12, 0x40, 0x0a, 0x0b, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x01, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x37, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x65, 0x74, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x3a, 0x29, 0x92, 0x41, 0x26, 0x0a, 0x24, 0xd2, 0x01, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c,
	0x5f, 0x69, 0x64, 0xd2, 0x01, 0x0c, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x72, 0x75, 0x6e, 0x5f,
	0x69, 0x64, 0xd2, 0x01, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x42, 0x12, 0x0a, 0x10,
	0x5f, 0x73, 0x74, 0x65, 0x70, 0x73, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64,
	0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x22, 0xfb, 0x02, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x49, 0x64, 0x12, 0x35, 0x0a,
	0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x31, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x07,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x74, 0x6f, 0x74, 0x61, 0x6c,
	0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c,
	0x74, 0x6f, 0x74, 0x61, 0x6c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x12, 0x1a, 0x0a, 0x08,
	0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08,
	0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x64, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x02, 0x69, 0x64, 0x12, 0x20, 0x0a, 0x0c, 0x74, 0x72, 0x69, 0x61,
	0x6c, 0x5f, 0x72, 0x75, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a,
	0x74, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x75, 0x6e, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x3a, 0x5c, 0x92, 0x41, 0x59, 0x0a, 0x57, 0xd2, 0x01, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f,
	0x69, 0x64, 0xd2, 0x01, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0xd2, 0x01, 0x07,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0xd2, 0x01, 0x0d, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f,
	0x62, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0xd2, 0x01, 0x08, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76,
	0x65, 0x64, 0xd2, 0x01, 0x02, 0x69, 0x64, 0xd2, 0x01, 0x0c, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f,
	0x72, 0x75, 0x6e, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x22, 0xda,
	0x02, 0x0a, 0x0f, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x49, 0x64, 0x12, 0x27, 0x0a,
	0x0f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x75, 0x75, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x55, 0x75, 0x69, 0x64, 0x12, 0x1e, 0x0a, 0x08, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x07, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x48, 0x01, 0x52,
	0x0c, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01,
	0x12, 0x5d, 0x0a, 0x16, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x28, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72,
	0x69, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x52, 0x13, 0x74, 0x72, 0x69, 0x61,
	0x6c, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x3a,
	0x3b, 0x92, 0x41, 0x38, 0x0a, 0x36, 0xd2, 0x01, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69,
	0x64, 0xd2, 0x01, 0x0f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x75,
	0x75, 0x69, 0x64, 0xd2, 0x01, 0x16, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x0b, 0x0a, 0x09,
	0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2a, 0xb8, 0x02, 0x0a, 0x05,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x10,
	0x0a, 0x0c, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x50, 0x41, 0x55, 0x53, 0x45, 0x44, 0x10, 0x02,
	0x12, 0x1b, 0x0a, 0x17, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x49,
	0x4e, 0x47, 0x5f, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x19, 0x0a,
	0x15, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x5f,
	0x4b, 0x49, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x1c, 0x0a, 0x18, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x4c,
	0x45, 0x54, 0x45, 0x44, 0x10, 0x05, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x53, 0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x06,
	0x12, 0x12, 0x0a, 0x0e, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c,
	0x45, 0x44, 0x10, 0x07, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x43, 0x4f,
	0x4d, 0x50, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x08, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x09, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x51, 0x55, 0x45, 0x55, 0x45, 0x44, 0x10, 0x0a, 0x12, 0x11, 0x0a, 0x0d,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x50, 0x55, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x0b, 0x12,
	0x12, 0x0a, 0x0e, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x0c, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x52, 0x55, 0x4e,
	0x4e, 0x49, 0x4e, 0x47, 0x10, 0x0d, 0x2a, 0x8b, 0x01, 0x0a, 0x13, 0x54, 0x72, 0x69, 0x61, 0x6c,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x12, 0x26,
	0x0a, 0x22, 0x54, 0x52, 0x49, 0x41, 0x4c, 0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x49,
	0x4e, 0x46, 0x4f, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x24, 0x0a, 0x20, 0x54, 0x52, 0x49, 0x41, 0x4c, 0x5f,
	0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x49, 0x4e, 0x46, 0x4f, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x49, 0x4e, 0x46, 0x45, 0x52, 0x45, 0x4e, 0x43, 0x45, 0x10, 0x01, 0x12, 0x26, 0x0a, 0x22,
	0x54, 0x52, 0x49, 0x41, 0x4c, 0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x49, 0x4e, 0x46,
	0x4f, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x46, 0x49, 0x4e, 0x45, 0x5f, 0x54, 0x55, 0x4e, 0x49,
	0x4e, 0x47, 0x10, 0x02, 0x42, 0x37, 0x5a, 0x35, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2d, 0x61, 0x69,
	0x2f, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x76, 0x31, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_determined_trial_v1_trial_proto_rawDescOnce sync.Once
	file_determined_trial_v1_trial_proto_rawDescData = file_determined_trial_v1_trial_proto_rawDesc
)

func file_determined_trial_v1_trial_proto_rawDescGZIP() []byte {
	file_determined_trial_v1_trial_proto_rawDescOnce.Do(func() {
		file_determined_trial_v1_trial_proto_rawDescData = protoimpl.X.CompressGZIP(file_determined_trial_v1_trial_proto_rawDescData)
	})
	return file_determined_trial_v1_trial_proto_rawDescData
}

var file_determined_trial_v1_trial_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_determined_trial_v1_trial_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_determined_trial_v1_trial_proto_goTypes = []interface{}{
	(State)(0),               // 0: determined.trial.v1.State
	(TrialSourceInfoType)(0), // 1: determined.trial.v1.TrialSourceInfoType
	(TrialProfilerMetricLabels_ProfilerMetricType)(0), // 2: determined.trial.v1.TrialProfilerMetricLabels.ProfilerMetricType
	(TrialEarlyExit_ExitedReason)(0),                  // 3: determined.trial.v1.TrialEarlyExit.ExitedReason
	(*CheckpointWorkload)(nil),                        // 4: determined.trial.v1.CheckpointWorkload
	(*MetricsWorkload)(nil),                           // 5: determined.trial.v1.MetricsWorkload
	(*Trial)(nil),                                     // 6: determined.trial.v1.Trial
	(*TrialProfilerMetricLabels)(nil),                 // 7: determined.trial.v1.TrialProfilerMetricLabels
	(*TrialProfilerMetricsBatch)(nil),                 // 8: determined.trial.v1.TrialProfilerMetricsBatch
	(*TrialEarlyExit)(nil),                            // 9: determined.trial.v1.TrialEarlyExit
	(*RendezvousInfo)(nil),                            // 10: determined.trial.v1.RendezvousInfo
	(*TrialRunnerMetadata)(nil),                       // 11: determined.trial.v1.TrialRunnerMetadata
	(*TrialMetrics)(nil),                              // 12: determined.trial.v1.TrialMetrics
	(*MetricsReport)(nil),                             // 13: determined.trial.v1.MetricsReport
	(*TrialSourceInfo)(nil),                           // 14: determined.trial.v1.TrialSourceInfo
	nil,                                               // 15: determined.trial.v1.CheckpointWorkload.ResourcesEntry
	(*timestamp.Timestamp)(nil),                       // 16: google.protobuf.Timestamp
	(checkpointv1.State)(0),                           // 17: determined.checkpoint.v1.State
	(*_struct.Struct)(nil),                            // 18: google.protobuf.Struct
	(*commonv1.Metrics)(nil),                          // 19: determined.common.v1.Metrics
}
var file_determined_trial_v1_trial_proto_depIdxs = []int32{
	16, // 0: determined.trial.v1.CheckpointWorkload.end_time:type_name -> google.protobuf.Timestamp
	17, // 1: determined.trial.v1.CheckpointWorkload.state:type_name -> determined.checkpoint.v1.State
	15, // 2: determined.trial.v1.CheckpointWorkload.resources:type_name -> determined.trial.v1.CheckpointWorkload.ResourcesEntry
	18, // 3: determined.trial.v1.CheckpointWorkload.metadata:type_name -> google.protobuf.Struct
	16, // 4: determined.trial.v1.MetricsWorkload.end_time:type_name -> google.protobuf.Timestamp
	19, // 5: determined.trial.v1.MetricsWorkload.metrics:type_name -> determined.common.v1.Metrics
	16, // 6: determined.trial.v1.Trial.start_time:type_name -> google.protobuf.Timestamp
	16, // 7: determined.trial.v1.Trial.end_time:type_name -> google.protobuf.Timestamp
	0,  // 8: determined.trial.v1.Trial.state:type_name -> determined.trial.v1.State
	18, // 9: determined.trial.v1.Trial.hparams:type_name -> google.protobuf.Struct
	5,  // 10: determined.trial.v1.Trial.best_validation:type_name -> determined.trial.v1.MetricsWorkload
	5,  // 11: determined.trial.v1.Trial.latest_validation:type_name -> determined.trial.v1.MetricsWorkload
	4,  // 12: determined.trial.v1.Trial.best_checkpoint:type_name -> determined.trial.v1.CheckpointWorkload
	18, // 13: determined.trial.v1.Trial.summary_metrics:type_name -> google.protobuf.Struct
	18, // 14: determined.trial.v1.Trial.metadata:type_name -> google.protobuf.Struct
	2,  // 15: determined.trial.v1.TrialProfilerMetricLabels.metric_type:type_name -> determined.trial.v1.TrialProfilerMetricLabels.ProfilerMetricType
	16, // 16: determined.trial.v1.TrialProfilerMetricsBatch.timestamps:type_name -> google.protobuf.Timestamp
	7,  // 17: determined.trial.v1.TrialProfilerMetricsBatch.labels:type_name -> determined.trial.v1.TrialProfilerMetricLabels
	3,  // 18: determined.trial.v1.TrialEarlyExit.reason:type_name -> determined.trial.v1.TrialEarlyExit.ExitedReason
	16, // 19: determined.trial.v1.TrialMetrics.report_time:type_name -> google.protobuf.Timestamp
	19, // 20: determined.trial.v1.TrialMetrics.metrics:type_name -> determined.common.v1.Metrics
	16, // 21: determined.trial.v1.MetricsReport.end_time:type_name -> google.protobuf.Timestamp
	18, // 22: determined.trial.v1.MetricsReport.metrics:type_name -> google.protobuf.Struct
	1,  // 23: determined.trial.v1.TrialSourceInfo.trial_source_info_type:type_name -> determined.trial.v1.TrialSourceInfoType
	24, // [24:24] is the sub-list for method output_type
	24, // [24:24] is the sub-list for method input_type
	24, // [24:24] is the sub-list for extension type_name
	24, // [24:24] is the sub-list for extension extendee
	0,  // [0:24] is the sub-list for field type_name
}

func init() { file_determined_trial_v1_trial_proto_init() }
func file_determined_trial_v1_trial_proto_init() {
	if File_determined_trial_v1_trial_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_determined_trial_v1_trial_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckpointWorkload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_trial_v1_trial_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetricsWorkload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_trial_v1_trial_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Trial); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_trial_v1_trial_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrialProfilerMetricLabels); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_trial_v1_trial_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrialProfilerMetricsBatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_trial_v1_trial_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrialEarlyExit); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_trial_v1_trial_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RendezvousInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_trial_v1_trial_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrialRunnerMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_trial_v1_trial_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrialMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_trial_v1_trial_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetricsReport); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_trial_v1_trial_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrialSourceInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_determined_trial_v1_trial_proto_msgTypes[2].OneofWrappers = []interface{}{}
	file_determined_trial_v1_trial_proto_msgTypes[8].OneofWrappers = []interface{}{}
	file_determined_trial_v1_trial_proto_msgTypes[10].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_determined_trial_v1_trial_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_determined_trial_v1_trial_proto_goTypes,
		DependencyIndexes: file_determined_trial_v1_trial_proto_depIdxs,
		EnumInfos:         file_determined_trial_v1_trial_proto_enumTypes,
		MessageInfos:      file_determined_trial_v1_trial_proto_msgTypes,
	}.Build()
	File_determined_trial_v1_trial_proto = out.File
	file_determined_trial_v1_trial_proto_rawDesc = nil
	file_determined_trial_v1_trial_proto_goTypes = nil
	file_determined_trial_v1_trial_proto_depIdxs = nil
}
