// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// source: determined/task/v1/task.proto

package taskv1

import (
	devicev1 "github.com/determined-ai/determined/proto/pkg/devicev1"
	logv1 "github.com/determined-ai/determined/proto/pkg/logv1"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "github.com/grpc-ecosystem/grpc-gateway/protoc-gen-swagger/options"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The current state of the task.
type State int32

const (
	// The task state is unknown.
	State_STATE_UNSPECIFIED State = 0
	// The task's base image is being pulled from the Docker registry.
	State_STATE_PULLING State = 3
	// The image has been pulled and the task is being started, but the task is
	// not ready yet.
	State_STATE_STARTING State = 4
	// The service in the task is running.
	State_STATE_RUNNING State = 5
	// The task has exited or has been aborted.
	State_STATE_TERMINATED State = 6
	// The task has begun to exit.
	State_STATE_TERMINATING State = 7
	// The task is waiting on something to complete.
	State_STATE_WAITING State = 9
	// Additional state to cover queueing operations.
	State_STATE_QUEUED State = 8
)

// Enum value maps for State.
var (
	State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		3: "STATE_PULLING",
		4: "STATE_STARTING",
		5: "STATE_RUNNING",
		6: "STATE_TERMINATED",
		7: "STATE_TERMINATING",
		9: "STATE_WAITING",
		8: "STATE_QUEUED",
	}
	State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"STATE_PULLING":     3,
		"STATE_STARTING":    4,
		"STATE_RUNNING":     5,
		"STATE_TERMINATED":  6,
		"STATE_TERMINATING": 7,
		"STATE_WAITING":     9,
		"STATE_QUEUED":      8,
	}
)

func (x State) Enum() *State {
	p := new(State)
	*p = x
	return p
}

func (x State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (State) Descriptor() protoreflect.EnumDescriptor {
	return file_determined_task_v1_task_proto_enumTypes[0].Descriptor()
}

func (State) Type() protoreflect.EnumType {
	return &file_determined_task_v1_task_proto_enumTypes[0]
}

func (x State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use State.Descriptor instead.
func (State) EnumDescriptor() ([]byte, []int) {
	return file_determined_task_v1_task_proto_rawDescGZIP(), []int{0}
}

// Type of the task
type TaskType int32

const (
	// The task type is unknown
	TaskType_TASK_TYPE_UNSPECIFIED TaskType = 0
	// "TRIAL" task type for the enum public.task_type in Postgres.
	TaskType_TASK_TYPE_TRIAL TaskType = 1
	// "NOTEBOOK" task type for the enum public.task_type in Postgres.
	TaskType_TASK_TYPE_NOTEBOOK TaskType = 2
	// "SHELL" task type for the enum public.task_type in Postgres.
	TaskType_TASK_TYPE_SHELL TaskType = 3
	// "COMMAND" task type for the enum public.task_type in Postgres.
	TaskType_TASK_TYPE_COMMAND TaskType = 4
	// "TENSORBOARD" task type for the enum public.task_type in Postgres.
	TaskType_TASK_TYPE_TENSORBOARD TaskType = 5
	// "CHECKPOINT_GC" task type for the enum public.task_type in Postgres.
	TaskType_TASK_TYPE_CHECKPOINT_GC TaskType = 6
	// "GENERIC" task type for the enum public.task_type in Postgres.
	TaskType_TASK_TYPE_GENERIC TaskType = 7
)

// Enum value maps for TaskType.
var (
	TaskType_name = map[int32]string{
		0: "TASK_TYPE_UNSPECIFIED",
		1: "TASK_TYPE_TRIAL",
		2: "TASK_TYPE_NOTEBOOK",
		3: "TASK_TYPE_SHELL",
		4: "TASK_TYPE_COMMAND",
		5: "TASK_TYPE_TENSORBOARD",
		6: "TASK_TYPE_CHECKPOINT_GC",
		7: "TASK_TYPE_GENERIC",
	}
	TaskType_value = map[string]int32{
		"TASK_TYPE_UNSPECIFIED":   0,
		"TASK_TYPE_TRIAL":         1,
		"TASK_TYPE_NOTEBOOK":      2,
		"TASK_TYPE_SHELL":         3,
		"TASK_TYPE_COMMAND":       4,
		"TASK_TYPE_TENSORBOARD":   5,
		"TASK_TYPE_CHECKPOINT_GC": 6,
		"TASK_TYPE_GENERIC":       7,
	}
)

func (x TaskType) Enum() *TaskType {
	p := new(TaskType)
	*p = x
	return p
}

func (x TaskType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TaskType) Descriptor() protoreflect.EnumDescriptor {
	return file_determined_task_v1_task_proto_enumTypes[1].Descriptor()
}

func (TaskType) Type() protoreflect.EnumType {
	return &file_determined_task_v1_task_proto_enumTypes[1]
}

func (x TaskType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TaskType.Descriptor instead.
func (TaskType) EnumDescriptor() ([]byte, []int) {
	return file_determined_task_v1_task_proto_rawDescGZIP(), []int{1}
}

// State of a Generic task
type GenericTaskState int32

const (
	// The task state unknown
	GenericTaskState_GENERIC_TASK_STATE_UNSPECIFIED GenericTaskState = 0
	// The task state unknown
	GenericTaskState_GENERIC_TASK_STATE_ACTIVE GenericTaskState = 1
	// The task state unknown
	GenericTaskState_GENERIC_TASK_STATE_CANCELED GenericTaskState = 2
	// The task state unknown
	GenericTaskState_GENERIC_TASK_STATE_COMPLETED GenericTaskState = 3
	// The task state unknown
	GenericTaskState_GENERIC_TASK_STATE_ERROR GenericTaskState = 4
	// The task state unknown
	GenericTaskState_GENERIC_TASK_STATE_PAUSED GenericTaskState = 5
	// The task state unknown
	GenericTaskState_GENERIC_TASK_STATE_STOPPING_PAUSED GenericTaskState = 6
	// The task state unknown
	GenericTaskState_GENERIC_TASK_STATE_STOPPING_CANCELED GenericTaskState = 7
	// The task state unknown
	GenericTaskState_GENERIC_TASK_STATE_STOPPING_COMPLETED GenericTaskState = 8
	// The task state unknown
	GenericTaskState_GENERIC_TASK_STATE_STOPPING_ERROR GenericTaskState = 9
)

// Enum value maps for GenericTaskState.
var (
	GenericTaskState_name = map[int32]string{
		0: "GENERIC_TASK_STATE_UNSPECIFIED",
		1: "GENERIC_TASK_STATE_ACTIVE",
		2: "GENERIC_TASK_STATE_CANCELED",
		3: "GENERIC_TASK_STATE_COMPLETED",
		4: "GENERIC_TASK_STATE_ERROR",
		5: "GENERIC_TASK_STATE_PAUSED",
		6: "GENERIC_TASK_STATE_STOPPING_PAUSED",
		7: "GENERIC_TASK_STATE_STOPPING_CANCELED",
		8: "GENERIC_TASK_STATE_STOPPING_COMPLETED",
		9: "GENERIC_TASK_STATE_STOPPING_ERROR",
	}
	GenericTaskState_value = map[string]int32{
		"GENERIC_TASK_STATE_UNSPECIFIED":        0,
		"GENERIC_TASK_STATE_ACTIVE":             1,
		"GENERIC_TASK_STATE_CANCELED":           2,
		"GENERIC_TASK_STATE_COMPLETED":          3,
		"GENERIC_TASK_STATE_ERROR":              4,
		"GENERIC_TASK_STATE_PAUSED":             5,
		"GENERIC_TASK_STATE_STOPPING_PAUSED":    6,
		"GENERIC_TASK_STATE_STOPPING_CANCELED":  7,
		"GENERIC_TASK_STATE_STOPPING_COMPLETED": 8,
		"GENERIC_TASK_STATE_STOPPING_ERROR":     9,
	}
)

func (x GenericTaskState) Enum() *GenericTaskState {
	p := new(GenericTaskState)
	*p = x
	return p
}

func (x GenericTaskState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GenericTaskState) Descriptor() protoreflect.EnumDescriptor {
	return file_determined_task_v1_task_proto_enumTypes[2].Descriptor()
}

func (GenericTaskState) Type() protoreflect.EnumType {
	return &file_determined_task_v1_task_proto_enumTypes[2]
}

func (x GenericTaskState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GenericTaskState.Descriptor instead.
func (GenericTaskState) EnumDescriptor() ([]byte, []int) {
	return file_determined_task_v1_task_proto_rawDescGZIP(), []int{2}
}

// The failure type of a resource.
type FailureType int32

const (
	// UNSPECIFIED denotes an error that is not defined below.
	FailureType_FAILURE_TYPE_UNSPECIFIED FailureType = 0
	// ResourcesFailed denotes that the container ran but failed with a non-zero
	// exit code.
	FailureType_FAILURE_TYPE_RESOURCES_FAILED FailureType = 1
	// ResourcesAborted denotes the container was canceled before it was started.
	FailureType_FAILURE_TYPE_RESOURCES_ABORTED FailureType = 2
	// ResourcesMissing denotes the resources were missing when the master asked
	// about it.
	FailureType_FAILURE_TYPE_RESOURCES_MISSING FailureType = 3
	// TaskAborted denotes that the task was canceled before it was started.
	FailureType_FAILURE_TYPE_TASK_ABORTED FailureType = 4
	// TaskError denotes that the task failed without an associated exit code.
	FailureType_FAILURE_TYPE_TASK_ERROR FailureType = 5
	// AgentFailed denotes that the agent failed while the container was running.
	FailureType_FAILURE_TYPE_AGENT_FAILED FailureType = 6
	// AgentError denotes that the agent failed to launch the container.
	FailureType_FAILURE_TYPE_AGENT_ERROR FailureType = 7
	// RestoreError denotes a failure to restore a running allocation on master
	// blip.
	FailureType_FAILURE_TYPE_RESTORE_ERROR FailureType = 8
	// UnknownError denotes an internal error that did not map to a know failure
	// type.
	FailureType_FAILURE_TYPE_UNKNOWN_ERROR FailureType = 9
)

// Enum value maps for FailureType.
var (
	FailureType_name = map[int32]string{
		0: "FAILURE_TYPE_UNSPECIFIED",
		1: "FAILURE_TYPE_RESOURCES_FAILED",
		2: "FAILURE_TYPE_RESOURCES_ABORTED",
		3: "FAILURE_TYPE_RESOURCES_MISSING",
		4: "FAILURE_TYPE_TASK_ABORTED",
		5: "FAILURE_TYPE_TASK_ERROR",
		6: "FAILURE_TYPE_AGENT_FAILED",
		7: "FAILURE_TYPE_AGENT_ERROR",
		8: "FAILURE_TYPE_RESTORE_ERROR",
		9: "FAILURE_TYPE_UNKNOWN_ERROR",
	}
	FailureType_value = map[string]int32{
		"FAILURE_TYPE_UNSPECIFIED":       0,
		"FAILURE_TYPE_RESOURCES_FAILED":  1,
		"FAILURE_TYPE_RESOURCES_ABORTED": 2,
		"FAILURE_TYPE_RESOURCES_MISSING": 3,
		"FAILURE_TYPE_TASK_ABORTED":      4,
		"FAILURE_TYPE_TASK_ERROR":        5,
		"FAILURE_TYPE_AGENT_FAILED":      6,
		"FAILURE_TYPE_AGENT_ERROR":       7,
		"FAILURE_TYPE_RESTORE_ERROR":     8,
		"FAILURE_TYPE_UNKNOWN_ERROR":     9,
	}
)

func (x FailureType) Enum() *FailureType {
	p := new(FailureType)
	*p = x
	return p
}

func (x FailureType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FailureType) Descriptor() protoreflect.EnumDescriptor {
	return file_determined_task_v1_task_proto_enumTypes[3].Descriptor()
}

func (FailureType) Type() protoreflect.EnumType {
	return &file_determined_task_v1_task_proto_enumTypes[3]
}

func (x FailureType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FailureType.Descriptor instead.
func (FailureType) EnumDescriptor() ([]byte, []int) {
	return file_determined_task_v1_task_proto_rawDescGZIP(), []int{3}
}

// Allocation tracks a specific instance of a Task.
type Allocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique ID of task associated with the allocation.
	TaskId string `protobuf:"bytes,1,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	// The current state of the allocation.
	State State `protobuf:"varint,2,opt,name=state,proto3,enum=determined.task.v1.State" json:"state,omitempty"`
	// Whether the allocation is ready to access.
	IsReady *bool `protobuf:"varint,3,opt,name=is_ready,json=isReady,proto3,oneof" json:"is_ready,omitempty"`
	// Start timestamp.
	StartTime *string `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3,oneof" json:"start_time,omitempty"`
	// End timestamp if completed.
	EndTime *string `protobuf:"bytes,5,opt,name=end_time,json=endTime,proto3,oneof" json:"end_time,omitempty"`
	// Unique ID of the allocation.
	AllocationId string `protobuf:"bytes,6,opt,name=allocation_id,json=allocationId,proto3" json:"allocation_id,omitempty"`
	// The number of slots associated with the allocation.
	Slots int32 `protobuf:"varint,7,opt,name=slots,proto3" json:"slots,omitempty"`
	// The exit reason for the allocation.
	ExitReason *string `protobuf:"bytes,8,opt,name=exit_reason,json=exitReason,proto3,oneof" json:"exit_reason,omitempty"`
	// The status code the allocation exits with.
	StatusCode *int32 `protobuf:"varint,9,opt,name=status_code,json=statusCode,proto3,oneof" json:"status_code,omitempty"`
}

func (x *Allocation) Reset() {
	*x = Allocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_task_v1_task_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Allocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Allocation) ProtoMessage() {}

func (x *Allocation) ProtoReflect() protoreflect.Message {
	mi := &file_determined_task_v1_task_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Allocation.ProtoReflect.Descriptor instead.
func (*Allocation) Descriptor() ([]byte, []int) {
	return file_determined_task_v1_task_proto_rawDescGZIP(), []int{0}
}

func (x *Allocation) GetTaskId() string {
	if x != nil {
		return x.TaskId
	}
	return ""
}

func (x *Allocation) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STATE_UNSPECIFIED
}

func (x *Allocation) GetIsReady() bool {
	if x != nil && x.IsReady != nil {
		return *x.IsReady
	}
	return false
}

func (x *Allocation) GetStartTime() string {
	if x != nil && x.StartTime != nil {
		return *x.StartTime
	}
	return ""
}

func (x *Allocation) GetEndTime() string {
	if x != nil && x.EndTime != nil {
		return *x.EndTime
	}
	return ""
}

func (x *Allocation) GetAllocationId() string {
	if x != nil {
		return x.AllocationId
	}
	return ""
}

func (x *Allocation) GetSlots() int32 {
	if x != nil {
		return x.Slots
	}
	return 0
}

func (x *Allocation) GetExitReason() string {
	if x != nil && x.ExitReason != nil {
		return *x.ExitReason
	}
	return ""
}

func (x *Allocation) GetStatusCode() int32 {
	if x != nil && x.StatusCode != nil {
		return *x.StatusCode
	}
	return 0
}

// Task is the model for a task in the database.
type Task struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique ID of task.
	TaskId string `protobuf:"bytes,1,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	// Type of Task.
	TaskType TaskType `protobuf:"varint,2,opt,name=task_type,json=taskType,proto3,enum=determined.task.v1.TaskType" json:"task_type,omitempty"`
	// List of Allocations.
	Allocations []*Allocation `protobuf:"bytes,4,rep,name=allocations,proto3" json:"allocations,omitempty"`
	// Start timestamp.
	StartTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End timestamp if completed.
	EndTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=end_time,json=endTime,proto3,oneof" json:"end_time,omitempty"`
	// The configuration of the task.
	Config *string `protobuf:"bytes,7,opt,name=config,proto3,oneof" json:"config,omitempty"`
	// ID of parent task (empty if root task).
	ParentId *string `protobuf:"bytes,8,opt,name=parent_id,json=parentId,proto3,oneof" json:"parent_id,omitempty"`
	// State of task execution.
	TaskState *GenericTaskState `protobuf:"varint,9,opt,name=task_state,json=taskState,proto3,enum=determined.task.v1.GenericTaskState,oneof" json:"task_state,omitempty"`
	// ID of task this is forked from (If task is a forked task)
	ForkedFrom *string `protobuf:"bytes,10,opt,name=forked_from,json=forkedFrom,proto3,oneof" json:"forked_from,omitempty"`
	// Flag for whether task can be paused or not.
	NoPause *bool `protobuf:"varint,11,opt,name=no_pause,json=noPause,proto3,oneof" json:"no_pause,omitempty"`
}

func (x *Task) Reset() {
	*x = Task{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_task_v1_task_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Task) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Task) ProtoMessage() {}

func (x *Task) ProtoReflect() protoreflect.Message {
	mi := &file_determined_task_v1_task_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Task.ProtoReflect.Descriptor instead.
func (*Task) Descriptor() ([]byte, []int) {
	return file_determined_task_v1_task_proto_rawDescGZIP(), []int{1}
}

func (x *Task) GetTaskId() string {
	if x != nil {
		return x.TaskId
	}
	return ""
}

func (x *Task) GetTaskType() TaskType {
	if x != nil {
		return x.TaskType
	}
	return TaskType_TASK_TYPE_UNSPECIFIED
}

func (x *Task) GetAllocations() []*Allocation {
	if x != nil {
		return x.Allocations
	}
	return nil
}

func (x *Task) GetStartTime() *timestamp.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Task) GetEndTime() *timestamp.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Task) GetConfig() string {
	if x != nil && x.Config != nil {
		return *x.Config
	}
	return ""
}

func (x *Task) GetParentId() string {
	if x != nil && x.ParentId != nil {
		return *x.ParentId
	}
	return ""
}

func (x *Task) GetTaskState() GenericTaskState {
	if x != nil && x.TaskState != nil {
		return *x.TaskState
	}
	return GenericTaskState_GENERIC_TASK_STATE_UNSPECIFIED
}

func (x *Task) GetForkedFrom() string {
	if x != nil && x.ForkedFrom != nil {
		return *x.ForkedFrom
	}
	return ""
}

func (x *Task) GetNoPause() bool {
	if x != nil && x.NoPause != nil {
		return *x.NoPause
	}
	return false
}

// Address represents an exposed port on a container.
type Address struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ContainerIP is the IP address from inside the container.
	ContainerIp string `protobuf:"bytes,1,opt,name=container_ip,json=containerIp,proto3" json:"container_ip,omitempty"`
	// ContainerPort is the port from inside the container.
	ContainerPort int32 `protobuf:"varint,2,opt,name=container_port,json=containerPort,proto3" json:"container_port,omitempty"`
	// HostIP is the IP address from outside the container. This can be
	// different than the ContainerIP because of network forwarding on the host
	// machine.
	HostIp string `protobuf:"bytes,3,opt,name=host_ip,json=hostIp,proto3" json:"host_ip,omitempty"`
	// HostPort is the IP port from outside the container. This can be different
	// than the ContainerPort because of network forwarding on the host machine.
	HostPort int32 `protobuf:"varint,4,opt,name=host_port,json=hostPort,proto3" json:"host_port,omitempty"`
}

func (x *Address) Reset() {
	*x = Address{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_task_v1_task_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Address) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Address) ProtoMessage() {}

func (x *Address) ProtoReflect() protoreflect.Message {
	mi := &file_determined_task_v1_task_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Address.ProtoReflect.Descriptor instead.
func (*Address) Descriptor() ([]byte, []int) {
	return file_determined_task_v1_task_proto_rawDescGZIP(), []int{2}
}

func (x *Address) GetContainerIp() string {
	if x != nil {
		return x.ContainerIp
	}
	return ""
}

func (x *Address) GetContainerPort() int32 {
	if x != nil {
		return x.ContainerPort
	}
	return 0
}

func (x *Address) GetHostIp() string {
	if x != nil {
		return x.HostIp
	}
	return ""
}

func (x *Address) GetHostPort() int32 {
	if x != nil {
		return x.HostPort
	}
	return 0
}

// ResourcesStarted contains the information needed by tasks from container
// started.
type ResourcesStarted struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Addresses represents the exposed ports on a container.
	Addresses []*Address `protobuf:"bytes,1,rep,name=addresses,proto3" json:"addresses,omitempty"`
	// NativeResourcesID is the native Docker hex container ID of the Determined
	// container.
	NativeResourcesId string `protobuf:"bytes,2,opt,name=native_resources_id,json=nativeResourcesId,proto3" json:"native_resources_id,omitempty"`
}

func (x *ResourcesStarted) Reset() {
	*x = ResourcesStarted{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_task_v1_task_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourcesStarted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourcesStarted) ProtoMessage() {}

func (x *ResourcesStarted) ProtoReflect() protoreflect.Message {
	mi := &file_determined_task_v1_task_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourcesStarted.ProtoReflect.Descriptor instead.
func (*ResourcesStarted) Descriptor() ([]byte, []int) {
	return file_determined_task_v1_task_proto_rawDescGZIP(), []int{3}
}

func (x *ResourcesStarted) GetAddresses() []*Address {
	if x != nil {
		return x.Addresses
	}
	return nil
}

func (x *ResourcesStarted) GetNativeResourcesId() string {
	if x != nil {
		return x.NativeResourcesId
	}
	return ""
}

// ResourcesFailure contains information about restored resources' failure.
type ResourcesFailure struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// FailureType denotes the type of failure that resulted in the container
	// stopping.
	FailureType FailureType `protobuf:"varint,1,opt,name=failure_type,json=failureType,proto3,enum=determined.task.v1.FailureType" json:"failure_type,omitempty"`
	// The error message of the failure.
	ErrMsg string `protobuf:"bytes,2,opt,name=err_msg,json=errMsg,proto3" json:"err_msg,omitempty"`
	// The exit code of the failure.
	ExitCode *int32 `protobuf:"varint,3,opt,name=exit_code,json=exitCode,proto3,oneof" json:"exit_code,omitempty"`
}

func (x *ResourcesFailure) Reset() {
	*x = ResourcesFailure{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_task_v1_task_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourcesFailure) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourcesFailure) ProtoMessage() {}

func (x *ResourcesFailure) ProtoReflect() protoreflect.Message {
	mi := &file_determined_task_v1_task_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourcesFailure.ProtoReflect.Descriptor instead.
func (*ResourcesFailure) Descriptor() ([]byte, []int) {
	return file_determined_task_v1_task_proto_rawDescGZIP(), []int{4}
}

func (x *ResourcesFailure) GetFailureType() FailureType {
	if x != nil {
		return x.FailureType
	}
	return FailureType_FAILURE_TYPE_UNSPECIFIED
}

func (x *ResourcesFailure) GetErrMsg() string {
	if x != nil {
		return x.ErrMsg
	}
	return ""
}

func (x *ResourcesFailure) GetExitCode() int32 {
	if x != nil && x.ExitCode != nil {
		return *x.ExitCode
	}
	return 0
}

// ResourcesStopped contains the information needed by tasks from container
// stopped.
type ResourcesStopped struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ResourcesFailure contains information about restored resources' failure.
	Failure *ResourcesFailure `protobuf:"bytes,1,opt,name=failure,proto3" json:"failure,omitempty"`
}

func (x *ResourcesStopped) Reset() {
	*x = ResourcesStopped{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_task_v1_task_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourcesStopped) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourcesStopped) ProtoMessage() {}

func (x *ResourcesStopped) ProtoReflect() protoreflect.Message {
	mi := &file_determined_task_v1_task_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourcesStopped.ProtoReflect.Descriptor instead.
func (*ResourcesStopped) Descriptor() ([]byte, []int) {
	return file_determined_task_v1_task_proto_rawDescGZIP(), []int{5}
}

func (x *ResourcesStopped) GetFailure() *ResourcesFailure {
	if x != nil {
		return x.Failure
	}
	return nil
}

// ResourcesSummary provides a summary of the resources comprising what we know
// at the time the allocation is granted, but for k8s it is granted before being
// scheduled so it isn't really much and `agent_devices` are missing for k8s.
type ResourcesSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ResourcesID is the ID of some set of resources.
	ResourcesId string `protobuf:"bytes,1,opt,name=resources_id,json=resourcesId,proto3" json:"resources_id,omitempty"`
	// ResourcesType is the type of some set of resources. This should be purely
	// informational.
	ResourcesType string `protobuf:"bytes,2,opt,name=resources_type,json=resourcesType,proto3" json:"resources_type,omitempty"`
	// AllocationID is the ID of an allocation of a task.
	AllocationId string `protobuf:"bytes,3,opt,name=allocation_id,json=allocationId,proto3" json:"allocation_id,omitempty"`
	// ID, an identifier for an agent, maps to the associated devices.
	AgentDevices map[string]*ResourcesSummary_Devices `protobuf:"bytes,4,rep,name=agent_devices,json=agentDevices,proto3" json:"agent_devices,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Available if the RM can give information on the container level.
	ContainerId *string `protobuf:"bytes,5,opt,name=container_id,json=containerId,proto3,oneof" json:"container_id,omitempty"`
	// Available if the RM knows the resource is already started / exited.
	Started *ResourcesStarted `protobuf:"bytes,6,opt,name=started,proto3,oneof" json:"started,omitempty"`
	// ResourcesStopped contains the information needed by tasks from container
	// stopped.
	Exited *ResourcesStopped `protobuf:"bytes,7,opt,name=exited,proto3,oneof" json:"exited,omitempty"`
}

func (x *ResourcesSummary) Reset() {
	*x = ResourcesSummary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_task_v1_task_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourcesSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourcesSummary) ProtoMessage() {}

func (x *ResourcesSummary) ProtoReflect() protoreflect.Message {
	mi := &file_determined_task_v1_task_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourcesSummary.ProtoReflect.Descriptor instead.
func (*ResourcesSummary) Descriptor() ([]byte, []int) {
	return file_determined_task_v1_task_proto_rawDescGZIP(), []int{6}
}

func (x *ResourcesSummary) GetResourcesId() string {
	if x != nil {
		return x.ResourcesId
	}
	return ""
}

func (x *ResourcesSummary) GetResourcesType() string {
	if x != nil {
		return x.ResourcesType
	}
	return ""
}

func (x *ResourcesSummary) GetAllocationId() string {
	if x != nil {
		return x.AllocationId
	}
	return ""
}

func (x *ResourcesSummary) GetAgentDevices() map[string]*ResourcesSummary_Devices {
	if x != nil {
		return x.AgentDevices
	}
	return nil
}

func (x *ResourcesSummary) GetContainerId() string {
	if x != nil && x.ContainerId != nil {
		return *x.ContainerId
	}
	return ""
}

func (x *ResourcesSummary) GetStarted() *ResourcesStarted {
	if x != nil {
		return x.Started
	}
	return nil
}

func (x *ResourcesSummary) GetExited() *ResourcesStopped {
	if x != nil {
		return x.Exited
	}
	return nil
}

// ProxyPortConfig configures a proxy the allocation should start.
type ProxyPortConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The service ID of the proxy port config.
	ServiceId string `protobuf:"bytes,1,opt,name=service_id,json=serviceId,proto3" json:"service_id,omitempty"`
	// The port of the proxy port config.
	Port int32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// True if proxy uses TCP.
	ProxyTcp bool `protobuf:"varint,3,opt,name=proxy_tcp,json=proxyTcp,proto3" json:"proxy_tcp,omitempty"`
	// True if the proxy is unauthenticated.
	Unauthenticated bool `protobuf:"varint,4,opt,name=unauthenticated,proto3" json:"unauthenticated,omitempty"`
}

func (x *ProxyPortConfig) Reset() {
	*x = ProxyPortConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_task_v1_task_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProxyPortConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProxyPortConfig) ProtoMessage() {}

func (x *ProxyPortConfig) ProtoReflect() protoreflect.Message {
	mi := &file_determined_task_v1_task_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProxyPortConfig.ProtoReflect.Descriptor instead.
func (*ProxyPortConfig) Descriptor() ([]byte, []int) {
	return file_determined_task_v1_task_proto_rawDescGZIP(), []int{7}
}

func (x *ProxyPortConfig) GetServiceId() string {
	if x != nil {
		return x.ServiceId
	}
	return ""
}

func (x *ProxyPortConfig) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *ProxyPortConfig) GetProxyTcp() bool {
	if x != nil {
		return x.ProxyTcp
	}
	return false
}

func (x *ProxyPortConfig) GetUnauthenticated() bool {
	if x != nil {
		return x.Unauthenticated
	}
	return false
}

// AllocationSummary contains information about a task for external display.
type AllocationSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// TaskID is the unique ID of a task among all tasks.
	TaskId string `protobuf:"bytes,1,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	// AllocationID is the ID of an allocation of a task. It is usually of the
	// form TaskID.allocation_number, maybe with some other metadata if different
	// types of allocations run.
	AllocationId string `protobuf:"bytes,2,opt,name=allocation_id,json=allocationId,proto3" json:"allocation_id,omitempty"`
	// The name of the task.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// The registered time of the task.
	RegisteredTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=registered_time,json=registeredTime,proto3" json:"registered_time,omitempty"`
	// The name of the resource pool.
	ResourcePool string `protobuf:"bytes,5,opt,name=resource_pool,json=resourcePool,proto3" json:"resource_pool,omitempty"`
	// The number of slots that are needed.
	SlotsNeeded int32 `protobuf:"varint,6,opt,name=slots_needed,json=slotsNeeded,proto3" json:"slots_needed,omitempty"`
	// ResourcesSummary provides a summary of the resources comprising what we
	// know at the time the allocation is granted.
	Resources []*ResourcesSummary `protobuf:"bytes,7,rep,name=resources,proto3" json:"resources,omitempty"`
	// The type of the scheduler. Either 'FAIR_SHARE', 'PRIORITY', or
	// 'ROUND_ROBIN'.
	SchedulerType string `protobuf:"bytes,8,opt,name=scheduler_type,json=schedulerType,proto3" json:"scheduler_type,omitempty"`
	// THe priority of the task.
	Priority *int32 `protobuf:"varint,9,opt,name=priority,proto3,oneof" json:"priority,omitempty"`
	// ProxyPortConfig configures a proxy the allocation should start.
	ProxyPorts []*ProxyPortConfig `protobuf:"bytes,10,rep,name=proxy_ports,json=proxyPorts,proto3" json:"proxy_ports,omitempty"`
}

func (x *AllocationSummary) Reset() {
	*x = AllocationSummary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_task_v1_task_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationSummary) ProtoMessage() {}

func (x *AllocationSummary) ProtoReflect() protoreflect.Message {
	mi := &file_determined_task_v1_task_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationSummary.ProtoReflect.Descriptor instead.
func (*AllocationSummary) Descriptor() ([]byte, []int) {
	return file_determined_task_v1_task_proto_rawDescGZIP(), []int{8}
}

func (x *AllocationSummary) GetTaskId() string {
	if x != nil {
		return x.TaskId
	}
	return ""
}

func (x *AllocationSummary) GetAllocationId() string {
	if x != nil {
		return x.AllocationId
	}
	return ""
}

func (x *AllocationSummary) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AllocationSummary) GetRegisteredTime() *timestamp.Timestamp {
	if x != nil {
		return x.RegisteredTime
	}
	return nil
}

func (x *AllocationSummary) GetResourcePool() string {
	if x != nil {
		return x.ResourcePool
	}
	return ""
}

func (x *AllocationSummary) GetSlotsNeeded() int32 {
	if x != nil {
		return x.SlotsNeeded
	}
	return 0
}

func (x *AllocationSummary) GetResources() []*ResourcesSummary {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *AllocationSummary) GetSchedulerType() string {
	if x != nil {
		return x.SchedulerType
	}
	return ""
}

func (x *AllocationSummary) GetPriority() int32 {
	if x != nil && x.Priority != nil {
		return *x.Priority
	}
	return 0
}

func (x *AllocationSummary) GetProxyPorts() []*ProxyPortConfig {
	if x != nil {
		return x.ProxyPorts
	}
	return nil
}

// TaskLog is the model for a task log in the database
type TaskLog struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the log.
	Id *int32 `protobuf:"varint,1,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// The ID of the task.
	TaskId string `protobuf:"bytes,2,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	// The ID of the allocation.
	AllocationId *string `protobuf:"bytes,3,opt,name=allocation_id,json=allocationId,proto3,oneof" json:"allocation_id,omitempty"`
	// The agent the logs came from.
	AgentId *string `protobuf:"bytes,4,opt,name=agent_id,json=agentId,proto3,oneof" json:"agent_id,omitempty"`
	// The ID of the container or, in the case of k8s, the pod name.
	ContainerId *string `protobuf:"bytes,5,opt,name=container_id,json=containerId,proto3,oneof" json:"container_id,omitempty"`
	// The rank ID.
	RankId *int32 `protobuf:"varint,6,opt,name=rank_id,json=rankId,proto3,oneof" json:"rank_id,omitempty"`
	// The timestamp of the log.
	Timestamp *timestamp.Timestamp `protobuf:"bytes,7,opt,name=timestamp,proto3,oneof" json:"timestamp,omitempty"`
	// The level of this log.
	Level *logv1.LogLevel `protobuf:"varint,8,opt,name=level,proto3,enum=determined.log.v1.LogLevel,oneof" json:"level,omitempty"`
	// The text of the log entry.
	Log string `protobuf:"bytes,9,opt,name=log,proto3" json:"log,omitempty"`
	// The source of the log entry.
	Source *string `protobuf:"bytes,10,opt,name=source,proto3,oneof" json:"source,omitempty"`
	// The output stream (e.g. stdout, stderr).
	Stdtype *string `protobuf:"bytes,11,opt,name=stdtype,proto3,oneof" json:"stdtype,omitempty"`
}

func (x *TaskLog) Reset() {
	*x = TaskLog{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_task_v1_task_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TaskLog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TaskLog) ProtoMessage() {}

func (x *TaskLog) ProtoReflect() protoreflect.Message {
	mi := &file_determined_task_v1_task_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TaskLog.ProtoReflect.Descriptor instead.
func (*TaskLog) Descriptor() ([]byte, []int) {
	return file_determined_task_v1_task_proto_rawDescGZIP(), []int{9}
}

func (x *TaskLog) GetId() int32 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *TaskLog) GetTaskId() string {
	if x != nil {
		return x.TaskId
	}
	return ""
}

func (x *TaskLog) GetAllocationId() string {
	if x != nil && x.AllocationId != nil {
		return *x.AllocationId
	}
	return ""
}

func (x *TaskLog) GetAgentId() string {
	if x != nil && x.AgentId != nil {
		return *x.AgentId
	}
	return ""
}

func (x *TaskLog) GetContainerId() string {
	if x != nil && x.ContainerId != nil {
		return *x.ContainerId
	}
	return ""
}

func (x *TaskLog) GetRankId() int32 {
	if x != nil && x.RankId != nil {
		return *x.RankId
	}
	return 0
}

func (x *TaskLog) GetTimestamp() *timestamp.Timestamp {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

func (x *TaskLog) GetLevel() logv1.LogLevel {
	if x != nil && x.Level != nil {
		return *x.Level
	}
	return logv1.LogLevel_LOG_LEVEL_UNSPECIFIED
}

func (x *TaskLog) GetLog() string {
	if x != nil {
		return x.Log
	}
	return ""
}

func (x *TaskLog) GetSource() string {
	if x != nil && x.Source != nil {
		return *x.Source
	}
	return ""
}

func (x *TaskLog) GetStdtype() string {
	if x != nil && x.Stdtype != nil {
		return *x.Stdtype
	}
	return ""
}

// A wrapper message of a list of devices.
type ResourcesSummary_Devices struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The devices on an agent.
	Devices []*devicev1.Device `protobuf:"bytes,1,rep,name=devices,proto3" json:"devices,omitempty"`
}

func (x *ResourcesSummary_Devices) Reset() {
	*x = ResourcesSummary_Devices{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_task_v1_task_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourcesSummary_Devices) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourcesSummary_Devices) ProtoMessage() {}

func (x *ResourcesSummary_Devices) ProtoReflect() protoreflect.Message {
	mi := &file_determined_task_v1_task_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourcesSummary_Devices.ProtoReflect.Descriptor instead.
func (*ResourcesSummary_Devices) Descriptor() ([]byte, []int) {
	return file_determined_task_v1_task_proto_rawDescGZIP(), []int{6, 0}
}

func (x *ResourcesSummary_Devices) GetDevices() []*devicev1.Device {
	if x != nil {
		return x.Devices
	}
	return nil
}

var File_determined_task_v1_task_proto protoreflect.FileDescriptor

var file_determined_task_v1_task_proto_rawDesc = []byte{
	0x0a, 0x1d, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x74, 0x61, 0x73,
	0x6b, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x12, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b,
	0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e,
	0x2d, 0x73, 0x77, 0x61, 0x67, 0x67, 0x65, 0x72, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x21, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65,
	0x64, 0x2f, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x6f, 0x67, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xbb, 0x03, 0x0a, 0x0a, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x17, 0x0a, 0x07, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x74, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x12, 0x2f, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x64, 0x65, 0x74, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1e, 0x0a, 0x08, 0x69,
	0x73, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52,
	0x07, 0x69, 0x73, 0x52, 0x65, 0x61, 0x64, 0x79, 0x88, 0x01, 0x01, 0x12, 0x22, 0x0a, 0x0a, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x01, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x1e, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x02, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x6c, 0x6f, 0x74, 0x73, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x05, 0x73, 0x6c, 0x6f, 0x74, 0x73, 0x12, 0x24, 0x0a, 0x0b, 0x65, 0x78,
	0x69, 0x74, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x03, 0x52, 0x0a, 0x65, 0x78, 0x69, 0x74, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x88, 0x01, 0x01,
	0x12, 0x24, 0x0a, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x05, 0x48, 0x04, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x43,
	0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x3a, 0x2f, 0x92, 0x41, 0x2c, 0x0a, 0x2a, 0xd2, 0x01, 0x07,
	0x74, 0x61, 0x73, 0x6b, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0xd2,
	0x01, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0xd2,
	0x01, 0x05, 0x73, 0x6c, 0x6f, 0x74, 0x73, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x69, 0x73, 0x5f, 0x72,
	0x65, 0x61, 0x64, 0x79, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x65, 0x78, 0x69, 0x74, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x63, 0x6f, 0x64, 0x65,
	0x22, 0xec, 0x04, 0x0a, 0x04, 0x54, 0x61, 0x73, 0x6b, 0x12, 0x17, 0x0a, 0x07, 0x74, 0x61, 0x73,
	0x6b, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x61, 0x73, 0x6b,
	0x49, 0x64, 0x12, 0x39, 0x0a, 0x09, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1c, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e,
	0x65, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x08, 0x74, 0x61, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e,
	0x74, 0x61, 0x73, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x00, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1b, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x88, 0x01, 0x01, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x48, 0x02, 0x52, 0x08, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x48, 0x0a, 0x0a, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x64, 0x65, 0x74, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x54, 0x61, 0x73, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x48,
	0x03, 0x52, 0x09, 0x74, 0x61, 0x73, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x24, 0x0a, 0x0b, 0x66, 0x6f, 0x72, 0x6b, 0x65, 0x64, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x04, 0x52, 0x0a, 0x66, 0x6f, 0x72, 0x6b, 0x65, 0x64, 0x46, 0x72,
	0x6f, 0x6d, 0x88, 0x01, 0x01, 0x12, 0x1e, 0x0a, 0x08, 0x6e, 0x6f, 0x5f, 0x70, 0x61, 0x75, 0x73,
	0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x48, 0x05, 0x52, 0x07, 0x6e, 0x6f, 0x50, 0x61, 0x75,
	0x73, 0x65, 0x88, 0x01, 0x01, 0x3a, 0x36, 0x92, 0x41, 0x33, 0x0a, 0x31, 0xd2, 0x01, 0x07, 0x74,
	0x61, 0x73, 0x6b, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x09, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0xd2, 0x01, 0x0b, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0xd2, 0x01, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x0b, 0x0a,
	0x09, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x5f, 0x69, 0x64, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x66, 0x6f, 0x72, 0x6b, 0x65, 0x64, 0x5f, 0x66, 0x72,
	0x6f, 0x6d, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x6e, 0x6f, 0x5f, 0x70, 0x61, 0x75, 0x73, 0x65, 0x22,
	0x89, 0x01, 0x0a, 0x07, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x70, 0x12, 0x25,
	0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x72, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x17, 0x0a, 0x07, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x69, 0x70,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x68, 0x6f, 0x73, 0x74, 0x49, 0x70, 0x12, 0x1b,
	0x0a, 0x09, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x50, 0x6f, 0x72, 0x74, 0x22, 0x7d, 0x0a, 0x10, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x53, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x12,
	0x39, 0x0a, 0x09, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e,
	0x74, 0x61, 0x73, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x52,
	0x09, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x6e, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x49, 0x64, 0x22, 0x9f, 0x01, 0x0a, 0x10, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x12,
	0x42, 0x0a, 0x0c, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e,
	0x65, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x75,
	0x72, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x65, 0x72, 0x72, 0x5f, 0x6d, 0x73, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x65, 0x72, 0x72, 0x4d, 0x73, 0x67, 0x12, 0x20, 0x0a, 0x09,
	0x65, 0x78, 0x69, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x48,
	0x00, 0x52, 0x08, 0x65, 0x78, 0x69, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0c,
	0x0a, 0x0a, 0x5f, 0x65, 0x78, 0x69, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x22, 0x52, 0x0a, 0x10,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x53, 0x74, 0x6f, 0x70, 0x70, 0x65, 0x64,
	0x12, 0x3e, 0x0a, 0x07, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74,
	0x61, 0x73, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x07, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65,
	0x22, 0xe8, 0x04, 0x0a, 0x10, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x53, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x12, 0x5b, 0x0a, 0x0d, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x64, 0x65,
	0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x0c, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x12, 0x26, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x43, 0x0a, 0x07, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x64, 0x65, 0x74,
	0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x53, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64,
	0x48, 0x01, 0x52, 0x07, 0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x88, 0x01, 0x01, 0x12, 0x41,
	0x0a, 0x06, 0x65, 0x78, 0x69, 0x74, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x53, 0x74, 0x6f,
	0x70, 0x70, 0x65, 0x64, 0x48, 0x02, 0x52, 0x06, 0x65, 0x78, 0x69, 0x74, 0x65, 0x64, 0x88, 0x01,
	0x01, 0x1a, 0x41, 0x0a, 0x07, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x36, 0x0a, 0x07,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x07, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x1a, 0x6d, 0x0a, 0x11, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x42, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x64, 0x65, 0x74,
	0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79,
	0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64,
	0x42, 0x09, 0x0a, 0x07, 0x5f, 0x65, 0x78, 0x69, 0x74, 0x65, 0x64, 0x22, 0x8b, 0x01, 0x0a, 0x0f,
	0x50, 0x72, 0x6f, 0x78, 0x79, 0x50, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x1d, 0x0a, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x12, 0x12,
	0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x70, 0x6f,
	0x72, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x5f, 0x74, 0x63, 0x70, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x54, 0x63, 0x70, 0x12,
	0x28, 0x0a, 0x0f, 0x75, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x75, 0x6e, 0x61, 0x75, 0x74, 0x68,
	0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x22, 0xd1, 0x03, 0x0a, 0x11, 0x41, 0x6c,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12,
	0x17, 0x0a, 0x07, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x74, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x43, 0x0a, 0x0f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x65, 0x64, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72,
	0x65, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x21, 0x0a, 0x0c, 0x73,
	0x6c, 0x6f, 0x74, 0x73, 0x5f, 0x6e, 0x65, 0x65, 0x64, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0b, 0x73, 0x6c, 0x6f, 0x74, 0x73, 0x4e, 0x65, 0x65, 0x64, 0x65, 0x64, 0x12, 0x42,
	0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74,
	0x61, 0x73, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x70, 0x72, 0x69,
	0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x08, 0x70,
	0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x88, 0x01, 0x01, 0x12, 0x44, 0x0a, 0x0b, 0x70, 0x72,
	0x6f, 0x78, 0x79, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x61, 0x73,
	0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x50, 0x6f, 0x72, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x50, 0x6f, 0x72, 0x74, 0x73,
	0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x22, 0x95, 0x04,
	0x0a, 0x07, 0x54, 0x61, 0x73, 0x6b, 0x4c, 0x6f, 0x67, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x02, 0x69, 0x64, 0x88, 0x01, 0x01, 0x12, 0x17,
	0x0a, 0x07, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x74, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01,
	0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x88, 0x01,
	0x01, 0x12, 0x1e, 0x0a, 0x08, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x02, 0x52, 0x07, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x88, 0x01,
	0x01, 0x12, 0x26, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x03, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x1c, 0x0a, 0x07, 0x72, 0x61, 0x6e,
	0x6b, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x48, 0x04, 0x52, 0x06, 0x72, 0x61,
	0x6e, 0x6b, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x3d, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x05, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x88, 0x01, 0x01, 0x12, 0x36, 0x0a, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1b, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e,
	0x65, 0x64, 0x2e, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76,
	0x65, 0x6c, 0x48, 0x06, 0x52, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x10,
	0x0a, 0x03, 0x6c, 0x6f, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6c, 0x6f, 0x67,
	0x12, 0x1b, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x07, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a,
	0x07, 0x73, 0x74, 0x64, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x48, 0x08,
	0x52, 0x07, 0x73, 0x74, 0x64, 0x74, 0x79, 0x70, 0x65, 0x88, 0x01, 0x01, 0x3a, 0x15, 0x92, 0x41,
	0x12, 0x0a, 0x10, 0xd2, 0x01, 0x07, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x03,
	0x6c, 0x6f, 0x67, 0x42, 0x05, 0x0a, 0x03, 0x5f, 0x69, 0x64, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x61,
	0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x42, 0x0b, 0x0a, 0x09,
	0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x72,
	0x61, 0x6e, 0x6b, 0x5f, 0x69, 0x64, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x42, 0x09,
	0x0a, 0x07, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x73, 0x74,
	0x64, 0x74, 0x79, 0x70, 0x65, 0x2a, 0xaa, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x50, 0x55, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x11, 0x0a,
	0x0d, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x05,
	0x12, 0x14, 0x0a, 0x10, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x45, 0x52, 0x4d, 0x49, 0x4e,
	0x41, 0x54, 0x45, 0x44, 0x10, 0x06, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x54, 0x45, 0x52, 0x4d, 0x49, 0x4e, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x12, 0x11, 0x0a,
	0x0d, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x57, 0x41, 0x49, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x09,
	0x12, 0x10, 0x0a, 0x0c, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x51, 0x55, 0x45, 0x55, 0x45, 0x44,
	0x10, 0x08, 0x2a, 0xcd, 0x01, 0x0a, 0x08, 0x54, 0x61, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x19, 0x0a, 0x15, 0x54, 0x41, 0x53, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x54, 0x41,
	0x53, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x54, 0x52, 0x49, 0x41, 0x4c, 0x10, 0x01, 0x12,
	0x16, 0x0a, 0x12, 0x54, 0x41, 0x53, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4e, 0x4f, 0x54,
	0x45, 0x42, 0x4f, 0x4f, 0x4b, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x54, 0x41, 0x53, 0x4b, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x48, 0x45, 0x4c, 0x4c, 0x10, 0x03, 0x12, 0x15, 0x0a, 0x11,
	0x54, 0x41, 0x53, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x4f, 0x4d, 0x4d, 0x41, 0x4e,
	0x44, 0x10, 0x04, 0x12, 0x19, 0x0a, 0x15, 0x54, 0x41, 0x53, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x54, 0x45, 0x4e, 0x53, 0x4f, 0x52, 0x42, 0x4f, 0x41, 0x52, 0x44, 0x10, 0x05, 0x12, 0x1b,
	0x0a, 0x17, 0x54, 0x41, 0x53, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x48, 0x45, 0x43,
	0x4b, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x5f, 0x47, 0x43, 0x10, 0x06, 0x12, 0x15, 0x0a, 0x11, 0x54,
	0x41, 0x53, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x47, 0x45, 0x4e, 0x45, 0x52, 0x49, 0x43,
	0x10, 0x07, 0x2a, 0xf9, 0x02, 0x0a, 0x10, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x54, 0x61,
	0x73, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x22, 0x0a, 0x1e, 0x47, 0x45, 0x4e, 0x45, 0x52,
	0x49, 0x43, 0x5f, 0x54, 0x41, 0x53, 0x4b, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1d, 0x0a, 0x19, 0x47,
	0x45, 0x4e, 0x45, 0x52, 0x49, 0x43, 0x5f, 0x54, 0x41, 0x53, 0x4b, 0x5f, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x1f, 0x0a, 0x1b, 0x47, 0x45,
	0x4e, 0x45, 0x52, 0x49, 0x43, 0x5f, 0x54, 0x41, 0x53, 0x4b, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x20, 0x0a, 0x1c, 0x47,
	0x45, 0x4e, 0x45, 0x52, 0x49, 0x43, 0x5f, 0x54, 0x41, 0x53, 0x4b, 0x5f, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x03, 0x12, 0x1c, 0x0a,
	0x18, 0x47, 0x45, 0x4e, 0x45, 0x52, 0x49, 0x43, 0x5f, 0x54, 0x41, 0x53, 0x4b, 0x5f, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x04, 0x12, 0x1d, 0x0a, 0x19, 0x47,
	0x45, 0x4e, 0x45, 0x52, 0x49, 0x43, 0x5f, 0x54, 0x41, 0x53, 0x4b, 0x5f, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x50, 0x41, 0x55, 0x53, 0x45, 0x44, 0x10, 0x05, 0x12, 0x26, 0x0a, 0x22, 0x47, 0x45,
	0x4e, 0x45, 0x52, 0x49, 0x43, 0x5f, 0x54, 0x41, 0x53, 0x4b, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x5f, 0x50, 0x41, 0x55, 0x53, 0x45, 0x44,
	0x10, 0x06, 0x12, 0x28, 0x0a, 0x24, 0x47, 0x45, 0x4e, 0x45, 0x52, 0x49, 0x43, 0x5f, 0x54, 0x41,
	0x53, 0x4b, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e,
	0x47, 0x5f, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x45, 0x44, 0x10, 0x07, 0x12, 0x29, 0x0a, 0x25,
	0x47, 0x45, 0x4e, 0x45, 0x52, 0x49, 0x43, 0x5f, 0x54, 0x41, 0x53, 0x4b, 0x5f, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x5f, 0x43, 0x4f, 0x4d, 0x50,
	0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x08, 0x12, 0x25, 0x0a, 0x21, 0x47, 0x45, 0x4e, 0x45, 0x52,
	0x49, 0x43, 0x5f, 0x54, 0x41, 0x53, 0x4b, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x54,
	0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x09, 0x2a, 0xcf,
	0x02, 0x0a, 0x0b, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c,
	0x0a, 0x18, 0x46, 0x41, 0x49, 0x4c, 0x55, 0x52, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x21, 0x0a, 0x1d,
	0x46, 0x41, 0x49, 0x4c, 0x55, 0x52, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x53,
	0x4f, 0x55, 0x52, 0x43, 0x45, 0x53, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12,
	0x22, 0x0a, 0x1e, 0x46, 0x41, 0x49, 0x4c, 0x55, 0x52, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x53, 0x5f, 0x41, 0x42, 0x4f, 0x52, 0x54, 0x45,
	0x44, 0x10, 0x02, 0x12, 0x22, 0x0a, 0x1e, 0x46, 0x41, 0x49, 0x4c, 0x55, 0x52, 0x45, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x53, 0x5f, 0x4d, 0x49,
	0x53, 0x53, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x1d, 0x0a, 0x19, 0x46, 0x41, 0x49, 0x4c, 0x55,
	0x52, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x54, 0x41, 0x53, 0x4b, 0x5f, 0x41, 0x42, 0x4f,
	0x52, 0x54, 0x45, 0x44, 0x10, 0x04, 0x12, 0x1b, 0x0a, 0x17, 0x46, 0x41, 0x49, 0x4c, 0x55, 0x52,
	0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x54, 0x41, 0x53, 0x4b, 0x5f, 0x45, 0x52, 0x52, 0x4f,
	0x52, 0x10, 0x05, 0x12, 0x1d, 0x0a, 0x19, 0x46, 0x41, 0x49, 0x4c, 0x55, 0x52, 0x45, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44,
	0x10, 0x06, 0x12, 0x1c, 0x0a, 0x18, 0x46, 0x41, 0x49, 0x4c, 0x55, 0x52, 0x45, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x07,
	0x12, 0x1e, 0x0a, 0x1a, 0x46, 0x41, 0x49, 0x4c, 0x55, 0x52, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x52, 0x45, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x08,
	0x12, 0x1e, 0x0a, 0x1a, 0x46, 0x41, 0x49, 0x4c, 0x55, 0x52, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x09,
	0x42, 0x36, 0x5a, 0x34, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x64,
	0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2d, 0x61, 0x69, 0x2f, 0x64, 0x65, 0x74,
	0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x70, 0x6b,
	0x67, 0x2f, 0x74, 0x61, 0x73, 0x6b, 0x76, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_determined_task_v1_task_proto_rawDescOnce sync.Once
	file_determined_task_v1_task_proto_rawDescData = file_determined_task_v1_task_proto_rawDesc
)

func file_determined_task_v1_task_proto_rawDescGZIP() []byte {
	file_determined_task_v1_task_proto_rawDescOnce.Do(func() {
		file_determined_task_v1_task_proto_rawDescData = protoimpl.X.CompressGZIP(file_determined_task_v1_task_proto_rawDescData)
	})
	return file_determined_task_v1_task_proto_rawDescData
}

var file_determined_task_v1_task_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_determined_task_v1_task_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_determined_task_v1_task_proto_goTypes = []interface{}{
	(State)(0),                       // 0: determined.task.v1.State
	(TaskType)(0),                    // 1: determined.task.v1.TaskType
	(GenericTaskState)(0),            // 2: determined.task.v1.GenericTaskState
	(FailureType)(0),                 // 3: determined.task.v1.FailureType
	(*Allocation)(nil),               // 4: determined.task.v1.Allocation
	(*Task)(nil),                     // 5: determined.task.v1.Task
	(*Address)(nil),                  // 6: determined.task.v1.Address
	(*ResourcesStarted)(nil),         // 7: determined.task.v1.ResourcesStarted
	(*ResourcesFailure)(nil),         // 8: determined.task.v1.ResourcesFailure
	(*ResourcesStopped)(nil),         // 9: determined.task.v1.ResourcesStopped
	(*ResourcesSummary)(nil),         // 10: determined.task.v1.ResourcesSummary
	(*ProxyPortConfig)(nil),          // 11: determined.task.v1.ProxyPortConfig
	(*AllocationSummary)(nil),        // 12: determined.task.v1.AllocationSummary
	(*TaskLog)(nil),                  // 13: determined.task.v1.TaskLog
	(*ResourcesSummary_Devices)(nil), // 14: determined.task.v1.ResourcesSummary.Devices
	nil,                              // 15: determined.task.v1.ResourcesSummary.AgentDevicesEntry
	(*timestamp.Timestamp)(nil),      // 16: google.protobuf.Timestamp
	(logv1.LogLevel)(0),              // 17: determined.log.v1.LogLevel
	(*devicev1.Device)(nil),          // 18: determined.device.v1.Device
}
var file_determined_task_v1_task_proto_depIdxs = []int32{
	0,  // 0: determined.task.v1.Allocation.state:type_name -> determined.task.v1.State
	1,  // 1: determined.task.v1.Task.task_type:type_name -> determined.task.v1.TaskType
	4,  // 2: determined.task.v1.Task.allocations:type_name -> determined.task.v1.Allocation
	16, // 3: determined.task.v1.Task.start_time:type_name -> google.protobuf.Timestamp
	16, // 4: determined.task.v1.Task.end_time:type_name -> google.protobuf.Timestamp
	2,  // 5: determined.task.v1.Task.task_state:type_name -> determined.task.v1.GenericTaskState
	6,  // 6: determined.task.v1.ResourcesStarted.addresses:type_name -> determined.task.v1.Address
	3,  // 7: determined.task.v1.ResourcesFailure.failure_type:type_name -> determined.task.v1.FailureType
	8,  // 8: determined.task.v1.ResourcesStopped.failure:type_name -> determined.task.v1.ResourcesFailure
	15, // 9: determined.task.v1.ResourcesSummary.agent_devices:type_name -> determined.task.v1.ResourcesSummary.AgentDevicesEntry
	7,  // 10: determined.task.v1.ResourcesSummary.started:type_name -> determined.task.v1.ResourcesStarted
	9,  // 11: determined.task.v1.ResourcesSummary.exited:type_name -> determined.task.v1.ResourcesStopped
	16, // 12: determined.task.v1.AllocationSummary.registered_time:type_name -> google.protobuf.Timestamp
	10, // 13: determined.task.v1.AllocationSummary.resources:type_name -> determined.task.v1.ResourcesSummary
	11, // 14: determined.task.v1.AllocationSummary.proxy_ports:type_name -> determined.task.v1.ProxyPortConfig
	16, // 15: determined.task.v1.TaskLog.timestamp:type_name -> google.protobuf.Timestamp
	17, // 16: determined.task.v1.TaskLog.level:type_name -> determined.log.v1.LogLevel
	18, // 17: determined.task.v1.ResourcesSummary.Devices.devices:type_name -> determined.device.v1.Device
	14, // 18: determined.task.v1.ResourcesSummary.AgentDevicesEntry.value:type_name -> determined.task.v1.ResourcesSummary.Devices
	19, // [19:19] is the sub-list for method output_type
	19, // [19:19] is the sub-list for method input_type
	19, // [19:19] is the sub-list for extension type_name
	19, // [19:19] is the sub-list for extension extendee
	0,  // [0:19] is the sub-list for field type_name
}

func init() { file_determined_task_v1_task_proto_init() }
func file_determined_task_v1_task_proto_init() {
	if File_determined_task_v1_task_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_determined_task_v1_task_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Allocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_task_v1_task_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Task); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_task_v1_task_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Address); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_task_v1_task_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourcesStarted); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_task_v1_task_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourcesFailure); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_task_v1_task_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourcesStopped); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_task_v1_task_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourcesSummary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_task_v1_task_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProxyPortConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_task_v1_task_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationSummary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_task_v1_task_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TaskLog); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_task_v1_task_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourcesSummary_Devices); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_determined_task_v1_task_proto_msgTypes[0].OneofWrappers = []interface{}{}
	file_determined_task_v1_task_proto_msgTypes[1].OneofWrappers = []interface{}{}
	file_determined_task_v1_task_proto_msgTypes[4].OneofWrappers = []interface{}{}
	file_determined_task_v1_task_proto_msgTypes[6].OneofWrappers = []interface{}{}
	file_determined_task_v1_task_proto_msgTypes[8].OneofWrappers = []interface{}{}
	file_determined_task_v1_task_proto_msgTypes[9].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_determined_task_v1_task_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_determined_task_v1_task_proto_goTypes,
		DependencyIndexes: file_determined_task_v1_task_proto_depIdxs,
		EnumInfos:         file_determined_task_v1_task_proto_enumTypes,
		MessageInfos:      file_determined_task_v1_task_proto_msgTypes,
	}.Build()
	File_determined_task_v1_task_proto = out.File
	file_determined_task_v1_task_proto_rawDesc = nil
	file_determined_task_v1_task_proto_goTypes = nil
	file_determined_task_v1_task_proto_depIdxs = nil
}
