// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// source: determined/resourcepool/v1/resourcepool.proto

package resourcepoolv1

import (
	devicev1 "github.com/determined-ai/determined/proto/pkg/devicev1"
	jobv1 "github.com/determined-ai/determined/proto/pkg/jobv1"
	_ "github.com/grpc-ecosystem/grpc-gateway/protoc-gen-swagger/options"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of the ResourcePool.
type ResourcePoolType int32

const (
	// Unspecified. This value will never actually be returned by the API, it is
	// just an artifact of using protobuf.
	ResourcePoolType_RESOURCE_POOL_TYPE_UNSPECIFIED ResourcePoolType = 0
	// An AWS resource pool.
	ResourcePoolType_RESOURCE_POOL_TYPE_AWS ResourcePoolType = 1
	// A GCP resource pool.
	ResourcePoolType_RESOURCE_POOL_TYPE_GCP ResourcePoolType = 2
	// A static resource pool.
	ResourcePoolType_RESOURCE_POOL_TYPE_STATIC ResourcePoolType = 3
	// The kubernetes resource pool.
	ResourcePoolType_RESOURCE_POOL_TYPE_K8S ResourcePoolType = 4
)

// Enum value maps for ResourcePoolType.
var (
	ResourcePoolType_name = map[int32]string{
		0: "RESOURCE_POOL_TYPE_UNSPECIFIED",
		1: "RESOURCE_POOL_TYPE_AWS",
		2: "RESOURCE_POOL_TYPE_GCP",
		3: "RESOURCE_POOL_TYPE_STATIC",
		4: "RESOURCE_POOL_TYPE_K8S",
	}
	ResourcePoolType_value = map[string]int32{
		"RESOURCE_POOL_TYPE_UNSPECIFIED": 0,
		"RESOURCE_POOL_TYPE_AWS":         1,
		"RESOURCE_POOL_TYPE_GCP":         2,
		"RESOURCE_POOL_TYPE_STATIC":      3,
		"RESOURCE_POOL_TYPE_K8S":         4,
	}
)

func (x ResourcePoolType) Enum() *ResourcePoolType {
	p := new(ResourcePoolType)
	*p = x
	return p
}

func (x ResourcePoolType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourcePoolType) Descriptor() protoreflect.EnumDescriptor {
	return file_determined_resourcepool_v1_resourcepool_proto_enumTypes[0].Descriptor()
}

func (ResourcePoolType) Type() protoreflect.EnumType {
	return &file_determined_resourcepool_v1_resourcepool_proto_enumTypes[0]
}

func (x ResourcePoolType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourcePoolType.Descriptor instead.
func (ResourcePoolType) EnumDescriptor() ([]byte, []int) {
	return file_determined_resourcepool_v1_resourcepool_proto_rawDescGZIP(), []int{0}
}

// The type of the Scheduler.
type SchedulerType int32

const (
	// Unspecified. This value will never actually be returned by the API, it is
	// just an artifact of using protobuf.
	SchedulerType_SCHEDULER_TYPE_UNSPECIFIED SchedulerType = 0
	// The priority scheduler.
	SchedulerType_SCHEDULER_TYPE_PRIORITY SchedulerType = 1
	// The fair share scheduler.
	SchedulerType_SCHEDULER_TYPE_FAIR_SHARE SchedulerType = 2
	// The round robin scheduler
	SchedulerType_SCHEDULER_TYPE_ROUND_ROBIN SchedulerType = 3
	// The kubernetes scheduler.
	SchedulerType_SCHEDULER_TYPE_KUBERNETES SchedulerType = 4
	// A slurm placeholder. When running on slurm, all scheduling behavior is
	// delegated.
	SchedulerType_SCHEDULER_TYPE_SLURM SchedulerType = 5
	// A PBS placeholder. When running on PBS, all scheduling behavior is
	// delegated.
	SchedulerType_SCHEDULER_TYPE_PBS SchedulerType = 6
)

// Enum value maps for SchedulerType.
var (
	SchedulerType_name = map[int32]string{
		0: "SCHEDULER_TYPE_UNSPECIFIED",
		1: "SCHEDULER_TYPE_PRIORITY",
		2: "SCHEDULER_TYPE_FAIR_SHARE",
		3: "SCHEDULER_TYPE_ROUND_ROBIN",
		4: "SCHEDULER_TYPE_KUBERNETES",
		5: "SCHEDULER_TYPE_SLURM",
		6: "SCHEDULER_TYPE_PBS",
	}
	SchedulerType_value = map[string]int32{
		"SCHEDULER_TYPE_UNSPECIFIED": 0,
		"SCHEDULER_TYPE_PRIORITY":    1,
		"SCHEDULER_TYPE_FAIR_SHARE":  2,
		"SCHEDULER_TYPE_ROUND_ROBIN": 3,
		"SCHEDULER_TYPE_KUBERNETES":  4,
		"SCHEDULER_TYPE_SLURM":       5,
		"SCHEDULER_TYPE_PBS":         6,
	}
)

func (x SchedulerType) Enum() *SchedulerType {
	p := new(SchedulerType)
	*p = x
	return p
}

func (x SchedulerType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SchedulerType) Descriptor() protoreflect.EnumDescriptor {
	return file_determined_resourcepool_v1_resourcepool_proto_enumTypes[1].Descriptor()
}

func (SchedulerType) Type() protoreflect.EnumType {
	return &file_determined_resourcepool_v1_resourcepool_proto_enumTypes[1]
}

func (x SchedulerType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SchedulerType.Descriptor instead.
func (SchedulerType) EnumDescriptor() ([]byte, []int) {
	return file_determined_resourcepool_v1_resourcepool_proto_rawDescGZIP(), []int{1}
}

// The fitting policy of the scheduler.
type FittingPolicy int32

const (
	// Unspecified. This value will never actually be returned by the API, it is
	// just an artifact of using protobuf.
	FittingPolicy_FITTING_POLICY_UNSPECIFIED FittingPolicy = 0
	// Best fit. Tasks are preferentially “packed” together on the smallest number
	// of agents
	FittingPolicy_FITTING_POLICY_BEST FittingPolicy = 1
	// Worst fit. Tasks are placed on under-utilized agents, spreading out the
	// tasks.
	FittingPolicy_FITTING_POLICY_WORST FittingPolicy = 2
	// A kubernetes placeholder. In k8s, the task placement is delegated to the
	// k8s scheduler so the fitting policy is not relevant.
	FittingPolicy_FITTING_POLICY_KUBERNETES FittingPolicy = 3
	// A slurm placeholder. When running on slurm, task placement is delegated.
	FittingPolicy_FITTING_POLICY_SLURM FittingPolicy = 4
	// A PBS placeholder. When running on PBS, task placement is delegated.
	FittingPolicy_FITTING_POLICY_PBS FittingPolicy = 5
)

// Enum value maps for FittingPolicy.
var (
	FittingPolicy_name = map[int32]string{
		0: "FITTING_POLICY_UNSPECIFIED",
		1: "FITTING_POLICY_BEST",
		2: "FITTING_POLICY_WORST",
		3: "FITTING_POLICY_KUBERNETES",
		4: "FITTING_POLICY_SLURM",
		5: "FITTING_POLICY_PBS",
	}
	FittingPolicy_value = map[string]int32{
		"FITTING_POLICY_UNSPECIFIED": 0,
		"FITTING_POLICY_BEST":        1,
		"FITTING_POLICY_WORST":       2,
		"FITTING_POLICY_KUBERNETES":  3,
		"FITTING_POLICY_SLURM":       4,
		"FITTING_POLICY_PBS":         5,
	}
)

func (x FittingPolicy) Enum() *FittingPolicy {
	p := new(FittingPolicy)
	*p = x
	return p
}

func (x FittingPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FittingPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_determined_resourcepool_v1_resourcepool_proto_enumTypes[2].Descriptor()
}

func (FittingPolicy) Type() protoreflect.EnumType {
	return &file_determined_resourcepool_v1_resourcepool_proto_enumTypes[2]
}

func (x FittingPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FittingPolicy.Descriptor instead.
func (FittingPolicy) EnumDescriptor() ([]byte, []int) {
	return file_determined_resourcepool_v1_resourcepool_proto_rawDescGZIP(), []int{2}
}

// A Resource Pool is a pool of resources where containers are run.
type ResourcePool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique name of the resource pool.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The description of the resource pool
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The type of the resource pool (AWS/GCP/STATIC)
	Type ResourcePoolType `protobuf:"varint,3,opt,name=type,proto3,enum=determined.resourcepool.v1.ResourcePoolType" json:"type,omitempty"`
	// The number of agents running in the resource pool
	NumAgents int32 `protobuf:"varint,4,opt,name=num_agents,json=numAgents,proto3" json:"num_agents,omitempty"`
	// The total number of slots that exist in the resource pool
	SlotsAvailable int32 `protobuf:"varint,5,opt,name=slots_available,json=slotsAvailable,proto3" json:"slots_available,omitempty"`
	// The number of slots that are actively running workloads
	SlotsUsed int32 `protobuf:"varint,6,opt,name=slots_used,json=slotsUsed,proto3" json:"slots_used,omitempty"`
	// Slot device type: cpu, gpu, ...
	SlotType devicev1.Type `protobuf:"varint,32,opt,name=slot_type,json=slotType,proto3,enum=determined.device.v1.Type" json:"slot_type,omitempty"`
	// The max number of aux containers that can run in this resource pool
	AuxContainerCapacity int32 `protobuf:"varint,7,opt,name=aux_container_capacity,json=auxContainerCapacity,proto3" json:"aux_container_capacity,omitempty"`
	// The current number of aux containers running in this resource pool
	AuxContainersRunning int32 `protobuf:"varint,8,opt,name=aux_containers_running,json=auxContainersRunning,proto3" json:"aux_containers_running,omitempty"`
	// Is this resource pool the default compute pool?
	DefaultComputePool bool `protobuf:"varint,9,opt,name=default_compute_pool,json=defaultComputePool,proto3" json:"default_compute_pool,omitempty"`
	// Is this resource pool the default auxiliary pool?
	DefaultAuxPool bool `protobuf:"varint,10,opt,name=default_aux_pool,json=defaultAuxPool,proto3" json:"default_aux_pool,omitempty"`
	// Is this resource pool using preemptible/spot instances? Only meaningful in
	// an AWS or GCP resource pool.
	Preemptible bool `protobuf:"varint,11,opt,name=preemptible,proto3" json:"preemptible,omitempty"`
	// When using dynamic agents, the minimum number of agents that can exist in
	// the resource pool.
	MinAgents int32 `protobuf:"varint,12,opt,name=min_agents,json=minAgents,proto3" json:"min_agents,omitempty"`
	// When using dynamic agents, the maximum number of agents that can exist in
	// the resource pool.
	MaxAgents int32 `protobuf:"varint,13,opt,name=max_agents,json=maxAgents,proto3" json:"max_agents,omitempty"`
	// The number of slots that exists on an dynamic agent.
	SlotsPerAgent int32 `protobuf:"varint,14,opt,name=slots_per_agent,json=slotsPerAgent,proto3" json:"slots_per_agent,omitempty"`
	// The maximum number of auxiliary containers that can run on an individual
	// agent
	AuxContainerCapacityPerAgent int32 `protobuf:"varint,15,opt,name=aux_container_capacity_per_agent,json=auxContainerCapacityPerAgent,proto3" json:"aux_container_capacity_per_agent,omitempty"`
	// The type of the scheduler. Either 'FAIR_SHARE', 'PRIORITY', or
	// 'ROUND_ROBIN'
	SchedulerType SchedulerType `protobuf:"varint,16,opt,name=scheduler_type,json=schedulerType,proto3,enum=determined.resourcepool.v1.SchedulerType" json:"scheduler_type,omitempty"`
	// The fitting policy of the scheduler.
	SchedulerFittingPolicy FittingPolicy `protobuf:"varint,17,opt,name=scheduler_fitting_policy,json=schedulerFittingPolicy,proto3,enum=determined.resourcepool.v1.FittingPolicy" json:"scheduler_fitting_policy,omitempty"`
	// The location of the resource pool. For AWS this returns the region and for
	// GCP this return the zone.
	Location string `protobuf:"bytes,18,opt,name=location,proto3" json:"location,omitempty"`
	// The VM image used for the agents when using dynamic agents.
	ImageId string `protobuf:"bytes,19,opt,name=image_id,json=imageId,proto3" json:"image_id,omitempty"`
	// The instance type of the agents when using dynamic agents. For AWS this is
	// the Instance Type. For GCP this is the machine type combined with the
	// number and types of GPUs. To work with this data programattically, we
	// recommend working with the ResourcePool.details.aws.instanceType and
	// ResourcePool.details.gcp.machineType/gpuType/gpuNum.
	InstanceType string `protobuf:"bytes,20,opt,name=instance_type,json=instanceType,proto3" json:"instance_type,omitempty"`
	// The url of the Determined master
	MasterUrl string `protobuf:"bytes,21,opt,name=master_url,json=masterUrl,proto3" json:"master_url,omitempty"`
	// A hostname for which the master’s TLS certificate is valid, if the host
	// specified by the master_url option is an IP address or is not contained in
	// the certificate
	MasterCertName string `protobuf:"bytes,22,opt,name=master_cert_name,json=masterCertName,proto3" json:"master_cert_name,omitempty"`
	// The startup script for the agent. This runs on the node the agent runs on.
	StartupScript string `protobuf:"bytes,23,opt,name=startup_script,json=startupScript,proto3" json:"startup_script,omitempty"`
	// The startup script for the agent's container. This runs in the container
	// determined-agent runs in.
	ContainerStartupScript string `protobuf:"bytes,24,opt,name=container_startup_script,json=containerStartupScript,proto3" json:"container_startup_script,omitempty"`
	// The Docker network to use for the agent when using dynamic agents.
	AgentDockerNetwork string `protobuf:"bytes,25,opt,name=agent_docker_network,json=agentDockerNetwork,proto3" json:"agent_docker_network,omitempty"`
	// The docker runtime to use for the agent when using dynamic agents
	AgentDockerRuntime string `protobuf:"bytes,26,opt,name=agent_docker_runtime,json=agentDockerRuntime,proto3" json:"agent_docker_runtime,omitempty"`
	// The docker image to use for the agent when using dynamic agents
	AgentDockerImage string `protobuf:"bytes,27,opt,name=agent_docker_image,json=agentDockerImage,proto3" json:"agent_docker_image,omitempty"`
	// the Fluent docker image to use
	//
	// Deprecated: Do not use.
	AgentFluentImage string `protobuf:"bytes,28,opt,name=agent_fluent_image,json=agentFluentImage,proto3" json:"agent_fluent_image,omitempty"`
	// The maximum idle period of agents in seconds. The master waits for this
	// period of time before shutting down idle agents.
	MaxIdleAgentPeriod float32 `protobuf:"fixed32,29,opt,name=max_idle_agent_period,json=maxIdleAgentPeriod,proto3" json:"max_idle_agent_period,omitempty"`
	// The maximum starting period of agents in seconds. The master waits for this
	// period of time for starting agents before retrying.
	MaxAgentStartingPeriod float32 `protobuf:"fixed32,30,opt,name=max_agent_starting_period,json=maxAgentStartingPeriod,proto3" json:"max_agent_starting_period,omitempty"`
	// GCP, AWS and Priority Scheduler details
	Details *ResourcePoolDetail `protobuf:"bytes,31,opt,name=details,proto3" json:"details,omitempty"`
	// GCP, AWS accelerator information
	Accelerator string `protobuf:"bytes,33,opt,name=accelerator,proto3" json:"accelerator,omitempty"`
	// Job queue stats
	Stats *jobv1.QueueStats `protobuf:"bytes,34,opt,name=stats,proto3" json:"stats,omitempty"`
	// Resource manager's metadata.
	ResourceManagerMetadata map[string]string `protobuf:"bytes,35,rep,name=resource_manager_metadata,json=resourceManagerMetadata,proto3" json:"resource_manager_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Resource manager's associated cluster name.
	ClusterName string `protobuf:"bytes,36,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
}

func (x *ResourcePool) Reset() {
	*x = ResourcePool{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_resourcepool_v1_resourcepool_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourcePool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourcePool) ProtoMessage() {}

func (x *ResourcePool) ProtoReflect() protoreflect.Message {
	mi := &file_determined_resourcepool_v1_resourcepool_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourcePool.ProtoReflect.Descriptor instead.
func (*ResourcePool) Descriptor() ([]byte, []int) {
	return file_determined_resourcepool_v1_resourcepool_proto_rawDescGZIP(), []int{0}
}

func (x *ResourcePool) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ResourcePool) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ResourcePool) GetType() ResourcePoolType {
	if x != nil {
		return x.Type
	}
	return ResourcePoolType_RESOURCE_POOL_TYPE_UNSPECIFIED
}

func (x *ResourcePool) GetNumAgents() int32 {
	if x != nil {
		return x.NumAgents
	}
	return 0
}

func (x *ResourcePool) GetSlotsAvailable() int32 {
	if x != nil {
		return x.SlotsAvailable
	}
	return 0
}

func (x *ResourcePool) GetSlotsUsed() int32 {
	if x != nil {
		return x.SlotsUsed
	}
	return 0
}

func (x *ResourcePool) GetSlotType() devicev1.Type {
	if x != nil {
		return x.SlotType
	}
	return devicev1.Type_TYPE_UNSPECIFIED
}

func (x *ResourcePool) GetAuxContainerCapacity() int32 {
	if x != nil {
		return x.AuxContainerCapacity
	}
	return 0
}

func (x *ResourcePool) GetAuxContainersRunning() int32 {
	if x != nil {
		return x.AuxContainersRunning
	}
	return 0
}

func (x *ResourcePool) GetDefaultComputePool() bool {
	if x != nil {
		return x.DefaultComputePool
	}
	return false
}

func (x *ResourcePool) GetDefaultAuxPool() bool {
	if x != nil {
		return x.DefaultAuxPool
	}
	return false
}

func (x *ResourcePool) GetPreemptible() bool {
	if x != nil {
		return x.Preemptible
	}
	return false
}

func (x *ResourcePool) GetMinAgents() int32 {
	if x != nil {
		return x.MinAgents
	}
	return 0
}

func (x *ResourcePool) GetMaxAgents() int32 {
	if x != nil {
		return x.MaxAgents
	}
	return 0
}

func (x *ResourcePool) GetSlotsPerAgent() int32 {
	if x != nil {
		return x.SlotsPerAgent
	}
	return 0
}

func (x *ResourcePool) GetAuxContainerCapacityPerAgent() int32 {
	if x != nil {
		return x.AuxContainerCapacityPerAgent
	}
	return 0
}

func (x *ResourcePool) GetSchedulerType() SchedulerType {
	if x != nil {
		return x.SchedulerType
	}
	return SchedulerType_SCHEDULER_TYPE_UNSPECIFIED
}

func (x *ResourcePool) GetSchedulerFittingPolicy() FittingPolicy {
	if x != nil {
		return x.SchedulerFittingPolicy
	}
	return FittingPolicy_FITTING_POLICY_UNSPECIFIED
}

func (x *ResourcePool) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *ResourcePool) GetImageId() string {
	if x != nil {
		return x.ImageId
	}
	return ""
}

func (x *ResourcePool) GetInstanceType() string {
	if x != nil {
		return x.InstanceType
	}
	return ""
}

func (x *ResourcePool) GetMasterUrl() string {
	if x != nil {
		return x.MasterUrl
	}
	return ""
}

func (x *ResourcePool) GetMasterCertName() string {
	if x != nil {
		return x.MasterCertName
	}
	return ""
}

func (x *ResourcePool) GetStartupScript() string {
	if x != nil {
		return x.StartupScript
	}
	return ""
}

func (x *ResourcePool) GetContainerStartupScript() string {
	if x != nil {
		return x.ContainerStartupScript
	}
	return ""
}

func (x *ResourcePool) GetAgentDockerNetwork() string {
	if x != nil {
		return x.AgentDockerNetwork
	}
	return ""
}

func (x *ResourcePool) GetAgentDockerRuntime() string {
	if x != nil {
		return x.AgentDockerRuntime
	}
	return ""
}

func (x *ResourcePool) GetAgentDockerImage() string {
	if x != nil {
		return x.AgentDockerImage
	}
	return ""
}

// Deprecated: Do not use.
func (x *ResourcePool) GetAgentFluentImage() string {
	if x != nil {
		return x.AgentFluentImage
	}
	return ""
}

func (x *ResourcePool) GetMaxIdleAgentPeriod() float32 {
	if x != nil {
		return x.MaxIdleAgentPeriod
	}
	return 0
}

func (x *ResourcePool) GetMaxAgentStartingPeriod() float32 {
	if x != nil {
		return x.MaxAgentStartingPeriod
	}
	return 0
}

func (x *ResourcePool) GetDetails() *ResourcePoolDetail {
	if x != nil {
		return x.Details
	}
	return nil
}

func (x *ResourcePool) GetAccelerator() string {
	if x != nil {
		return x.Accelerator
	}
	return ""
}

func (x *ResourcePool) GetStats() *jobv1.QueueStats {
	if x != nil {
		return x.Stats
	}
	return nil
}

func (x *ResourcePool) GetResourceManagerMetadata() map[string]string {
	if x != nil {
		return x.ResourceManagerMetadata
	}
	return nil
}

func (x *ResourcePool) GetClusterName() string {
	if x != nil {
		return x.ClusterName
	}
	return ""
}

// Detailed information about the resource pool
type ResourcePoolDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// AWS-specific details
	Aws *ResourcePoolAwsDetail `protobuf:"bytes,1,opt,name=aws,proto3" json:"aws,omitempty"`
	// GCP-specific details
	Gcp *ResourcePoolGcpDetail `protobuf:"bytes,2,opt,name=gcp,proto3" json:"gcp,omitempty"`
	// Priority scheduler-specific details
	PriorityScheduler *ResourcePoolPrioritySchedulerDetail `protobuf:"bytes,3,opt,name=priority_scheduler,json=priorityScheduler,proto3" json:"priority_scheduler,omitempty"`
}

func (x *ResourcePoolDetail) Reset() {
	*x = ResourcePoolDetail{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_resourcepool_v1_resourcepool_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourcePoolDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourcePoolDetail) ProtoMessage() {}

func (x *ResourcePoolDetail) ProtoReflect() protoreflect.Message {
	mi := &file_determined_resourcepool_v1_resourcepool_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourcePoolDetail.ProtoReflect.Descriptor instead.
func (*ResourcePoolDetail) Descriptor() ([]byte, []int) {
	return file_determined_resourcepool_v1_resourcepool_proto_rawDescGZIP(), []int{1}
}

func (x *ResourcePoolDetail) GetAws() *ResourcePoolAwsDetail {
	if x != nil {
		return x.Aws
	}
	return nil
}

func (x *ResourcePoolDetail) GetGcp() *ResourcePoolGcpDetail {
	if x != nil {
		return x.Gcp
	}
	return nil
}

func (x *ResourcePoolDetail) GetPriorityScheduler() *ResourcePoolPrioritySchedulerDetail {
	if x != nil {
		return x.PriorityScheduler
	}
	return nil
}

// List of arbitrary user-defined tags that are added to the Determined agent
// instances
type AwsCustomTag struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key of the custom tag
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The value of the custom tag
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *AwsCustomTag) Reset() {
	*x = AwsCustomTag{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_resourcepool_v1_resourcepool_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsCustomTag) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsCustomTag) ProtoMessage() {}

func (x *AwsCustomTag) ProtoReflect() protoreflect.Message {
	mi := &file_determined_resourcepool_v1_resourcepool_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsCustomTag.ProtoReflect.Descriptor instead.
func (*AwsCustomTag) Descriptor() ([]byte, []int) {
	return file_determined_resourcepool_v1_resourcepool_proto_rawDescGZIP(), []int{2}
}

func (x *AwsCustomTag) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *AwsCustomTag) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// AWS-specific details about the resource pool
type ResourcePoolAwsDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The region the resource pool exists in
	Region string `protobuf:"bytes,1,opt,name=region,proto3" json:"region,omitempty"`
	// Size of the root volume of the Determined agent in GB
	RootVolumeSize int32 `protobuf:"varint,2,opt,name=root_volume_size,json=rootVolumeSize,proto3" json:"root_volume_size,omitempty"`
	// The AMI ID of the Determined agent
	ImageId string `protobuf:"bytes,3,opt,name=image_id,json=imageId,proto3" json:"image_id,omitempty"`
	// Key for tagging the Determined agent instances
	TagKey string `protobuf:"bytes,4,opt,name=tag_key,json=tagKey,proto3" json:"tag_key,omitempty"`
	// Value for tagging the Determined agent instances
	TagValue string `protobuf:"bytes,5,opt,name=tag_value,json=tagValue,proto3" json:"tag_value,omitempty"`
	// Name to set for the Determined agent instances
	InstanceName string `protobuf:"bytes,6,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	// The name of the SSH key registered with AWS for SSH key access to the agent
	// instances
	SshKeyName string `protobuf:"bytes,7,opt,name=ssh_key_name,json=sshKeyName,proto3" json:"ssh_key_name,omitempty"`
	// Whether to use public IP addresses for the Determined agent
	PublicIp bool `protobuf:"varint,8,opt,name=public_ip,json=publicIp,proto3" json:"public_ip,omitempty"`
	// The ID of the subnet to run the Determined agents in
	SubnetId string `protobuf:"bytes,9,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// The ID of the security group to run the Determined agents as
	SecurityGroupId string `protobuf:"bytes,10,opt,name=security_group_id,json=securityGroupId,proto3" json:"security_group_id,omitempty"`
	// The Amazon Resource Name (ARN) of the IAM instance profile to attach to the
	// agent instances.
	IamInstanceProfileArn string `protobuf:"bytes,11,opt,name=iam_instance_profile_arn,json=iamInstanceProfileArn,proto3" json:"iam_instance_profile_arn,omitempty"`
	// AWS instance type to use for dynamic agents
	InstanceType string `protobuf:"bytes,12,opt,name=instance_type,json=instanceType,proto3" json:"instance_type,omitempty"`
	// The log group
	LogGroup string `protobuf:"bytes,13,opt,name=log_group,json=logGroup,proto3" json:"log_group,omitempty"`
	// The log stream
	LogStream string `protobuf:"bytes,14,opt,name=log_stream,json=logStream,proto3" json:"log_stream,omitempty"`
	// Whether to use spot instances
	SpotEnabled bool `protobuf:"varint,15,opt,name=spot_enabled,json=spotEnabled,proto3" json:"spot_enabled,omitempty"`
	// The maximum price per hour to pay for a spot instance
	SpotMaxPrice string `protobuf:"bytes,16,opt,name=spot_max_price,json=spotMaxPrice,proto3" json:"spot_max_price,omitempty"`
	// List of arbitrary user-defined tags that are added to the Determined agent
	// instances
	CustomTags []*AwsCustomTag `protobuf:"bytes,17,rep,name=custom_tags,json=customTags,proto3" json:"custom_tags,omitempty"`
}

func (x *ResourcePoolAwsDetail) Reset() {
	*x = ResourcePoolAwsDetail{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_resourcepool_v1_resourcepool_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourcePoolAwsDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourcePoolAwsDetail) ProtoMessage() {}

func (x *ResourcePoolAwsDetail) ProtoReflect() protoreflect.Message {
	mi := &file_determined_resourcepool_v1_resourcepool_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourcePoolAwsDetail.ProtoReflect.Descriptor instead.
func (*ResourcePoolAwsDetail) Descriptor() ([]byte, []int) {
	return file_determined_resourcepool_v1_resourcepool_proto_rawDescGZIP(), []int{3}
}

func (x *ResourcePoolAwsDetail) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *ResourcePoolAwsDetail) GetRootVolumeSize() int32 {
	if x != nil {
		return x.RootVolumeSize
	}
	return 0
}

func (x *ResourcePoolAwsDetail) GetImageId() string {
	if x != nil {
		return x.ImageId
	}
	return ""
}

func (x *ResourcePoolAwsDetail) GetTagKey() string {
	if x != nil {
		return x.TagKey
	}
	return ""
}

func (x *ResourcePoolAwsDetail) GetTagValue() string {
	if x != nil {
		return x.TagValue
	}
	return ""
}

func (x *ResourcePoolAwsDetail) GetInstanceName() string {
	if x != nil {
		return x.InstanceName
	}
	return ""
}

func (x *ResourcePoolAwsDetail) GetSshKeyName() string {
	if x != nil {
		return x.SshKeyName
	}
	return ""
}

func (x *ResourcePoolAwsDetail) GetPublicIp() bool {
	if x != nil {
		return x.PublicIp
	}
	return false
}

func (x *ResourcePoolAwsDetail) GetSubnetId() string {
	if x != nil {
		return x.SubnetId
	}
	return ""
}

func (x *ResourcePoolAwsDetail) GetSecurityGroupId() string {
	if x != nil {
		return x.SecurityGroupId
	}
	return ""
}

func (x *ResourcePoolAwsDetail) GetIamInstanceProfileArn() string {
	if x != nil {
		return x.IamInstanceProfileArn
	}
	return ""
}

func (x *ResourcePoolAwsDetail) GetInstanceType() string {
	if x != nil {
		return x.InstanceType
	}
	return ""
}

func (x *ResourcePoolAwsDetail) GetLogGroup() string {
	if x != nil {
		return x.LogGroup
	}
	return ""
}

func (x *ResourcePoolAwsDetail) GetLogStream() string {
	if x != nil {
		return x.LogStream
	}
	return ""
}

func (x *ResourcePoolAwsDetail) GetSpotEnabled() bool {
	if x != nil {
		return x.SpotEnabled
	}
	return false
}

func (x *ResourcePoolAwsDetail) GetSpotMaxPrice() string {
	if x != nil {
		return x.SpotMaxPrice
	}
	return ""
}

func (x *ResourcePoolAwsDetail) GetCustomTags() []*AwsCustomTag {
	if x != nil {
		return x.CustomTags
	}
	return nil
}

// GCP-specific details about the resource pool
type ResourcePoolGcpDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The project ID of the GCP resources used by Determined
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// The zone of the GCP resources used by Determined
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Size of the root volume of the Determined agent in GB
	BootDiskSize int32 `protobuf:"varint,3,opt,name=boot_disk_size,json=bootDiskSize,proto3" json:"boot_disk_size,omitempty"`
	// The boot disk source image of the Determined agent
	BootDiskSourceImage string `protobuf:"bytes,4,opt,name=boot_disk_source_image,json=bootDiskSourceImage,proto3" json:"boot_disk_source_image,omitempty"`
	// Key for labeling the Determined agent instances.
	LabelKey string `protobuf:"bytes,5,opt,name=label_key,json=labelKey,proto3" json:"label_key,omitempty"`
	// Value for labeling the Determined agent instances
	LabelValue string `protobuf:"bytes,6,opt,name=label_value,json=labelValue,proto3" json:"label_value,omitempty"`
	// Name prefix to set for the Determined agent instances
	NamePrefix string `protobuf:"bytes,7,opt,name=name_prefix,json=namePrefix,proto3" json:"name_prefix,omitempty"`
	// Network resource for the Determined agent instances
	Network string `protobuf:"bytes,8,opt,name=network,proto3" json:"network,omitempty"`
	// Subnetwork resource for the Determined agent instances
	Subnetwork string `protobuf:"bytes,9,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
	// Whether to use external IP addresses for the Determined agent instances
	ExternalIp bool `protobuf:"varint,10,opt,name=external_ip,json=externalIp,proto3" json:"external_ip,omitempty"`
	// The network tags to set firewalls for the Determined agent instances
	NetworkTags []string `protobuf:"bytes,11,rep,name=network_tags,json=networkTags,proto3" json:"network_tags,omitempty"`
	// Email of the service account for the Determined agent instances.
	ServiceAccountEmail string `protobuf:"bytes,12,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
	// List of scopes authorized for the Determined agent instances
	ServiceAccountScopes []string `protobuf:"bytes,13,rep,name=service_account_scopes,json=serviceAccountScopes,proto3" json:"service_account_scopes,omitempty"`
	// Type of machine for the Determined agents
	MachineType string `protobuf:"bytes,14,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// Type of GPU for the Determined agents
	GpuType string `protobuf:"bytes,15,opt,name=gpu_type,json=gpuType,proto3" json:"gpu_type,omitempty"`
	// Number of GPUs for the Determined agents
	GpuNum int32 `protobuf:"varint,16,opt,name=gpu_num,json=gpuNum,proto3" json:"gpu_num,omitempty"`
	// Whether to use preemptible instances
	Preemptible bool `protobuf:"varint,17,opt,name=preemptible,proto3" json:"preemptible,omitempty"`
	// The timeout period for tracking a GCP operation in seconds
	OperationTimeoutPeriod float32 `protobuf:"fixed32,18,opt,name=operation_timeout_period,json=operationTimeoutPeriod,proto3" json:"operation_timeout_period,omitempty"`
}

func (x *ResourcePoolGcpDetail) Reset() {
	*x = ResourcePoolGcpDetail{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_resourcepool_v1_resourcepool_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourcePoolGcpDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourcePoolGcpDetail) ProtoMessage() {}

func (x *ResourcePoolGcpDetail) ProtoReflect() protoreflect.Message {
	mi := &file_determined_resourcepool_v1_resourcepool_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourcePoolGcpDetail.ProtoReflect.Descriptor instead.
func (*ResourcePoolGcpDetail) Descriptor() ([]byte, []int) {
	return file_determined_resourcepool_v1_resourcepool_proto_rawDescGZIP(), []int{4}
}

func (x *ResourcePoolGcpDetail) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *ResourcePoolGcpDetail) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *ResourcePoolGcpDetail) GetBootDiskSize() int32 {
	if x != nil {
		return x.BootDiskSize
	}
	return 0
}

func (x *ResourcePoolGcpDetail) GetBootDiskSourceImage() string {
	if x != nil {
		return x.BootDiskSourceImage
	}
	return ""
}

func (x *ResourcePoolGcpDetail) GetLabelKey() string {
	if x != nil {
		return x.LabelKey
	}
	return ""
}

func (x *ResourcePoolGcpDetail) GetLabelValue() string {
	if x != nil {
		return x.LabelValue
	}
	return ""
}

func (x *ResourcePoolGcpDetail) GetNamePrefix() string {
	if x != nil {
		return x.NamePrefix
	}
	return ""
}

func (x *ResourcePoolGcpDetail) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *ResourcePoolGcpDetail) GetSubnetwork() string {
	if x != nil {
		return x.Subnetwork
	}
	return ""
}

func (x *ResourcePoolGcpDetail) GetExternalIp() bool {
	if x != nil {
		return x.ExternalIp
	}
	return false
}

func (x *ResourcePoolGcpDetail) GetNetworkTags() []string {
	if x != nil {
		return x.NetworkTags
	}
	return nil
}

func (x *ResourcePoolGcpDetail) GetServiceAccountEmail() string {
	if x != nil {
		return x.ServiceAccountEmail
	}
	return ""
}

func (x *ResourcePoolGcpDetail) GetServiceAccountScopes() []string {
	if x != nil {
		return x.ServiceAccountScopes
	}
	return nil
}

func (x *ResourcePoolGcpDetail) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *ResourcePoolGcpDetail) GetGpuType() string {
	if x != nil {
		return x.GpuType
	}
	return ""
}

func (x *ResourcePoolGcpDetail) GetGpuNum() int32 {
	if x != nil {
		return x.GpuNum
	}
	return 0
}

func (x *ResourcePoolGcpDetail) GetPreemptible() bool {
	if x != nil {
		return x.Preemptible
	}
	return false
}

func (x *ResourcePoolGcpDetail) GetOperationTimeoutPeriod() float32 {
	if x != nil {
		return x.OperationTimeoutPeriod
	}
	return 0
}

// A kubernetes priority class
type K8PriorityClass struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Priority class name.
	PriorityClass string `protobuf:"bytes,1,opt,name=priority_class,json=priorityClass,proto3" json:"priority_class,omitempty"`
	// Priority class value.
	PriorityValue int32 `protobuf:"varint,2,opt,name=priority_value,json=priorityValue,proto3" json:"priority_value,omitempty"`
}

func (x *K8PriorityClass) Reset() {
	*x = K8PriorityClass{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_resourcepool_v1_resourcepool_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *K8PriorityClass) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*K8PriorityClass) ProtoMessage() {}

func (x *K8PriorityClass) ProtoReflect() protoreflect.Message {
	mi := &file_determined_resourcepool_v1_resourcepool_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use K8PriorityClass.ProtoReflect.Descriptor instead.
func (*K8PriorityClass) Descriptor() ([]byte, []int) {
	return file_determined_resourcepool_v1_resourcepool_proto_rawDescGZIP(), []int{5}
}

func (x *K8PriorityClass) GetPriorityClass() string {
	if x != nil {
		return x.PriorityClass
	}
	return ""
}

func (x *K8PriorityClass) GetPriorityValue() int32 {
	if x != nil {
		return x.PriorityValue
	}
	return 0
}

// Details related to the priority scheduler. This will only be present if the
// schedulerType=priority
type ResourcePoolPrioritySchedulerDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether lower priority tasks should be preempted to schedule higher
	// priority tasks
	Preemption bool `protobuf:"varint,1,opt,name=preemption,proto3" json:"preemption,omitempty"`
	// The priority that is assigned to tasks that do not explicitly specify a
	// priority.
	DefaultPriority int32 `protobuf:"varint,2,opt,name=default_priority,json=defaultPriority,proto3" json:"default_priority,omitempty"`
	// List of available priorities for K8 (if applicable).
	K8Priorities []*K8PriorityClass `protobuf:"bytes,3,rep,name=k8_priorities,json=k8Priorities,proto3" json:"k8_priorities,omitempty"`
}

func (x *ResourcePoolPrioritySchedulerDetail) Reset() {
	*x = ResourcePoolPrioritySchedulerDetail{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_resourcepool_v1_resourcepool_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourcePoolPrioritySchedulerDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourcePoolPrioritySchedulerDetail) ProtoMessage() {}

func (x *ResourcePoolPrioritySchedulerDetail) ProtoReflect() protoreflect.Message {
	mi := &file_determined_resourcepool_v1_resourcepool_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourcePoolPrioritySchedulerDetail.ProtoReflect.Descriptor instead.
func (*ResourcePoolPrioritySchedulerDetail) Descriptor() ([]byte, []int) {
	return file_determined_resourcepool_v1_resourcepool_proto_rawDescGZIP(), []int{6}
}

func (x *ResourcePoolPrioritySchedulerDetail) GetPreemption() bool {
	if x != nil {
		return x.Preemption
	}
	return false
}

func (x *ResourcePoolPrioritySchedulerDetail) GetDefaultPriority() int32 {
	if x != nil {
		return x.DefaultPriority
	}
	return 0
}

func (x *ResourcePoolPrioritySchedulerDetail) GetK8Priorities() []*K8PriorityClass {
	if x != nil {
		return x.K8Priorities
	}
	return nil
}

var File_determined_resourcepool_v1_resourcepool_proto protoreflect.FileDescriptor

var file_determined_resourcepool_v1_resourcepool_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x70, 0x6f, 0x6f, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x70, 0x6f, 0x6f, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1a, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x70, 0x6f, 0x6f, 0x6c, 0x2e, 0x76, 0x31, 0x1a, 0x2c, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x73, 0x77, 0x61, 0x67, 0x67, 0x65, 0x72, 0x2f,
	0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x64, 0x65, 0x74, 0x65, 0x72,
	0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2f, 0x76, 0x31, 0x2f,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x64, 0x65,
	0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x6a, 0x6f, 0x62, 0x2f, 0x76, 0x31, 0x2f,
	0x6a, 0x6f, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa5, 0x13, 0x0a, 0x0c, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x40, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c,
	0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x70, 0x6f, 0x6f, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x75, 0x6d, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x6e, 0x75, 0x6d, 0x41, 0x67, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x6c, 0x6f, 0x74, 0x73, 0x5f, 0x61, 0x76, 0x61, 0x69, 0x6c,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x73, 0x6c, 0x6f, 0x74,
	0x73, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x6c,
	0x6f, 0x74, 0x73, 0x5f, 0x75, 0x73, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09,
	0x73, 0x6c, 0x6f, 0x74, 0x73, 0x55, 0x73, 0x65, 0x64, 0x12, 0x37, 0x0a, 0x09, 0x73, 0x6c, 0x6f,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x20, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x64,
	0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x73, 0x6c, 0x6f, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x34, 0x0a, 0x16, 0x61, 0x75, 0x78, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x14, 0x61, 0x75, 0x78, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x12, 0x34, 0x0a, 0x16, 0x61, 0x75, 0x78, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x5f, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x14, 0x61, 0x75, 0x78, 0x43, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x52, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x30,
	0x0a, 0x14, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x64, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x50, 0x6f, 0x6f, 0x6c,
	0x12, 0x28, 0x0a, 0x10, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x61, 0x75, 0x78, 0x5f,
	0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x41, 0x75, 0x78, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x20, 0x0a, 0x0b, 0x70, 0x72,
	0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0b, 0x70, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x6d, 0x69, 0x6e, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x09, 0x6d, 0x69, 0x6e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x6d,
	0x61, 0x78, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x09, 0x6d, 0x61, 0x78, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x73, 0x6c,
	0x6f, 0x74, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0d, 0x73, 0x6c, 0x6f, 0x74, 0x73, 0x50, 0x65, 0x72, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x12, 0x46, 0x0a, 0x20, 0x61, 0x75, 0x78, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x65, 0x72,
	0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x05, 0x52, 0x1c, 0x61, 0x75,
	0x78, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69,
	0x74, 0x79, 0x50, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x50, 0x0a, 0x0e, 0x73, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x10, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x29, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x70, 0x6f, 0x6f, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0d, 0x73,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x63, 0x0a, 0x18,
	0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29,
	0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x70, 0x6f, 0x6f, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x16, 0x73, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x72, 0x46, 0x69, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x12, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a,
	0x08, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x15, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x55, 0x72, 0x6c, 0x12, 0x28, 0x0a, 0x10,
	0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x43, 0x65,
	0x72, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x72, 0x74, 0x75,
	0x70, 0x5f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x17, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x75, 0x70, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x38, 0x0a,
	0x18, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x75, 0x70, 0x5f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x18, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x16, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x72, 0x74, 0x75,
	0x70, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x30, 0x0a, 0x14, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x5f, 0x64, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18,
	0x19, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x44, 0x6f, 0x63, 0x6b,
	0x65, 0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x30, 0x0a, 0x14, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x5f, 0x64, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x5f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x44, 0x6f,
	0x63, 0x6b, 0x65, 0x72, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x5f, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x44, 0x6f,
	0x63, 0x6b, 0x65, 0x72, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x30, 0x0a, 0x12, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x5f, 0x66, 0x6c, 0x75, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18,
	0x1c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x10, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x46, 0x6c, 0x75, 0x65, 0x6e, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x31, 0x0a, 0x15, 0x6d,
	0x61, 0x78, 0x5f, 0x69, 0x64, 0x6c, 0x65, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x65,
	0x72, 0x69, 0x6f, 0x64, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x02, 0x52, 0x12, 0x6d, 0x61, 0x78, 0x49,
	0x64, 0x6c, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x39,
	0x0a, 0x19, 0x6d, 0x61, 0x78, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x1e, 0x20, 0x01, 0x28,
	0x02, 0x52, 0x16, 0x6d, 0x61, 0x78, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x72, 0x74,
	0x69, 0x6e, 0x67, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x48, 0x0a, 0x07, 0x64, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x64, 0x65, 0x74,
	0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x70, 0x6f, 0x6f, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x50, 0x6f, 0x6f, 0x6c, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x18, 0x21, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x33, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x22,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65,
	0x64, 0x2e, 0x6a, 0x6f, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x75, 0x65, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x12, 0x81, 0x01, 0x0a, 0x19, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x5f,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x23, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x45,
	0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x70, 0x6f, 0x6f, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x17, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x21,
	0x0a, 0x0c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x24,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d,
	0x65, 0x1a, 0x4a, 0x0a, 0x1c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0xe1, 0x04,
	0x92, 0x41, 0xdd, 0x04, 0x0a, 0xda, 0x04, 0xd2, 0x01, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xd2, 0x01,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0xd2, 0x01, 0x04, 0x74,
	0x79, 0x70, 0x65, 0xd2, 0x01, 0x0a, 0x6e, 0x75, 0x6d, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73,
	0xd2, 0x01, 0x0f, 0x73, 0x6c, 0x6f, 0x74, 0x73, 0x5f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62,
	0x6c, 0x65, 0xd2, 0x01, 0x0a, 0x73, 0x6c, 0x6f, 0x74, 0x73, 0x5f, 0x75, 0x73, 0x65, 0x64, 0xd2,
	0x01, 0x09, 0x73, 0x6c, 0x6f, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0xd2, 0x01, 0x16, 0x61, 0x75,
	0x78, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x70, 0x61,
	0x63, 0x69, 0x74, 0x79, 0xd2, 0x01, 0x16, 0x61, 0x75, 0x78, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x73, 0x5f, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0xd2, 0x01, 0x14,
	0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f,
	0x70, 0x6f, 0x6f, 0x6c, 0xd2, 0x01, 0x10, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x61,
	0x75, 0x78, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0xd2, 0x01, 0x0b, 0x70, 0x72, 0x65, 0x65, 0x6d, 0x70,
	0x74, 0x69, 0x62, 0x6c, 0x65, 0xd2, 0x01, 0x0a, 0x6d, 0x69, 0x6e, 0x5f, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x73, 0xd2, 0x01, 0x0a, 0x6d, 0x61, 0x78, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0xd2,
	0x01, 0x20, 0x61, 0x75, 0x78, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f,
	0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0xd2, 0x01, 0x0e, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0xd2, 0x01, 0x18, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x5f,
	0x66, 0x69, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0xd2, 0x01,
	0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0xd2, 0x01, 0x08, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0xd2, 0x01, 0x0a, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x75, 0x72,
	0x6c, 0xd2, 0x01, 0x10, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0xd2, 0x01, 0x0e, 0x73, 0x74, 0x61, 0x72, 0x74, 0x75, 0x70, 0x5f, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0xd2, 0x01, 0x18, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x75, 0x70, 0x5f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0xd2, 0x01, 0x14, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x5f,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0xd2, 0x01, 0x14, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f,
	0x64, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x5f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0xd2, 0x01,
	0x12, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x5f, 0x69, 0x6d,
	0x61, 0x67, 0x65, 0xd2, 0x01, 0x12, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x6c, 0x75, 0x65,
	0x6e, 0x74, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0xd2, 0x01, 0x15, 0x6d, 0x61, 0x78, 0x5f, 0x69,
	0x64, 0x6c, 0x65, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64,
	0xd2, 0x01, 0x19, 0x6d, 0x61, 0x78, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0xd2, 0x01, 0x07, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0xd2, 0x01, 0x19, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xd2, 0x01, 0x0c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x8e, 0x02, 0x0a, 0x12, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x6f,
	0x6f, 0x6c, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x43, 0x0a, 0x03, 0x61, 0x77, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e,
	0x65, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x70, 0x6f, 0x6f, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x41,
	0x77, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x03, 0x61, 0x77, 0x73, 0x12, 0x43, 0x0a,
	0x03, 0x67, 0x63, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x64, 0x65, 0x74,
	0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x70, 0x6f, 0x6f, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x50, 0x6f, 0x6f, 0x6c, 0x47, 0x63, 0x70, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x03, 0x67,
	0x63, 0x70, 0x12, 0x6e, 0x0a, 0x12, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x73,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f,
	0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x70, 0x6f, 0x6f, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79,
	0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52,
	0x11, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x72, 0x22, 0x4b, 0x0a, 0x0c, 0x41, 0x77, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54,
	0x61, 0x67, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x13, 0x92, 0x41, 0x10, 0x0a,
	0x0e, 0xd2, 0x01, 0x03, 0x6b, 0x65, 0x79, 0xd2, 0x01, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22,
	0xb5, 0x06, 0x0a, 0x15, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x6f, 0x6f, 0x6c,
	0x41, 0x77, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f,
	0x6e, 0x12, 0x28, 0x0a, 0x10, 0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x72, 0x6f, 0x6f,
	0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x74, 0x61, 0x67, 0x5f, 0x6b, 0x65,
	0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x12,
	0x1b, 0x0a, 0x09, 0x74, 0x61, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x74, 0x61, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a, 0x0d,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x20, 0x0a, 0x0c, 0x73, 0x73, 0x68, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x73, 0x68, 0x4b, 0x65, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x69, 0x70,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x49, 0x70,
	0x12, 0x1b, 0x0a, 0x09, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x49, 0x64, 0x12, 0x2a, 0x0a,
	0x11, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f,
	0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x12, 0x37, 0x0a, 0x18, 0x69, 0x61, 0x6d,
	0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x5f, 0x61, 0x72, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x69, 0x61, 0x6d,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x41,
	0x72, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x6c, 0x6f, 0x67, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x67, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x1d, 0x0a, 0x0a, 0x6c, 0x6f, 0x67, 0x5f, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6c, 0x6f, 0x67, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x70, 0x6f, 0x74, 0x5f, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x73, 0x70, 0x6f, 0x74, 0x45,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x24, 0x0a, 0x0e, 0x73, 0x70, 0x6f, 0x74, 0x5f, 0x6d,
	0x61, 0x78, 0x5f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x73, 0x70, 0x6f, 0x74, 0x4d, 0x61, 0x78, 0x50, 0x72, 0x69, 0x63, 0x65, 0x12, 0x49, 0x0a, 0x0b,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x70, 0x6f, 0x6f, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x77, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x67, 0x52, 0x0a, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x54, 0x61, 0x67, 0x73, 0x3a, 0xad, 0x01, 0x92, 0x41, 0xa9, 0x01, 0x0a, 0xa6,
	0x01, 0xd2, 0x01, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0xd2, 0x01, 0x10, 0x72, 0x6f, 0x6f,
	0x74, 0x5f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0xd2, 0x01, 0x08,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x07, 0x74, 0x61, 0x67, 0x5f, 0x6b,
	0x65, 0x79, 0xd2, 0x01, 0x09, 0x74, 0x61, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0xd2, 0x01,
	0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0xd2, 0x01,
	0x0c, 0x73, 0x73, 0x68, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0xd2, 0x01, 0x09,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x69, 0x70, 0xd2, 0x01, 0x11, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x18,
	0x69, 0x61, 0x6d, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x5f, 0x61, 0x72, 0x6e, 0xd2, 0x01, 0x0c, 0x73, 0x70, 0x6f, 0x74, 0x5f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x9d, 0x07, 0x0a, 0x15, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x47, 0x63, 0x70, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x7a,
	0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12,
	0x24, 0x0a, 0x0e, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x62, 0x6f, 0x6f, 0x74, 0x44, 0x69, 0x73,
	0x6b, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x33, 0x0a, 0x16, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69,
	0x73, 0x6b, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x62, 0x6f, 0x6f, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x4b, 0x65, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x6e, 0x61, 0x6d, 0x65,
	0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6e,
	0x61, 0x6d, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x18, 0x0a, 0x07, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f,
	0x69, 0x70, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x49, 0x70, 0x12, 0x21, 0x0a, 0x0c, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f,
	0x74, 0x61, 0x67, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x54, 0x61, 0x67, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x34, 0x0a, 0x16, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x73,
	0x63, 0x6f, 0x70, 0x65, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x53, 0x63, 0x6f, 0x70, 0x65,
	0x73, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x67, 0x70, 0x75, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x70, 0x75, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x17, 0x0a, 0x07, 0x67, 0x70, 0x75, 0x5f, 0x6e, 0x75, 0x6d, 0x18, 0x10, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x06, 0x67, 0x70, 0x75, 0x4e, 0x75, 0x6d, 0x12, 0x20, 0x0a, 0x0b, 0x70, 0x72, 0x65, 0x65,
	0x6d, 0x70, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x70,
	0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x12, 0x38, 0x0a, 0x18, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f,
	0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x12, 0x20, 0x01, 0x28, 0x02, 0x52, 0x16, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x50, 0x65,
	0x72, 0x69, 0x6f, 0x64, 0x3a, 0x80, 0x02, 0x92, 0x41, 0xfc, 0x01, 0x0a, 0xf9, 0x01, 0xd2, 0x01,
	0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0xd2, 0x01, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0xd2,
	0x01, 0x0e, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0xd2, 0x01, 0x16, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0xd2, 0x01, 0x09, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x5f, 0x6b, 0x65, 0x79, 0xd2, 0x01, 0x0b, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0xd2, 0x01, 0x0b, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69,
	0x78, 0xd2, 0x01, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0xd2, 0x01, 0x0b, 0x65, 0x78,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0xd2, 0x01, 0x15, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x65, 0x6d, 0x61, 0x69,
	0x6c, 0xd2, 0x01, 0x16, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0xd2, 0x01, 0x0c, 0x6d, 0x61, 0x63,
	0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0xd2, 0x01, 0x08, 0x67, 0x70, 0x75, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0xd2, 0x01, 0x07, 0x67, 0x70, 0x75, 0x5f, 0x6e, 0x75, 0x6d, 0xd2, 0x01,
	0x0b, 0x70, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x62, 0x6c, 0x65, 0xd2, 0x01, 0x18, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74,
	0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x22, 0x5f, 0x0a, 0x0f, 0x4b, 0x38, 0x50, 0x72, 0x69,
	0x6f, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x72,
	0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x70, 0x72, 0x69, 0x6f, 0x72,
	0x69, 0x74, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xe9, 0x01, 0x0a, 0x23, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74,
	0x79, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x70, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x29, 0x0a, 0x10, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x70, 0x72, 0x69, 0x6f,
	0x72, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x50, 0x0a, 0x0d, 0x6b,
	0x38, 0x5f, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x70, 0x6f, 0x6f, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x4b, 0x38, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52,
	0x0c, 0x6b, 0x38, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x69, 0x65, 0x73, 0x3a, 0x25, 0x92,
	0x41, 0x22, 0x0a, 0x20, 0xd2, 0x01, 0x0a, 0x70, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0xd2, 0x01, 0x10, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x70, 0x72, 0x69, 0x6f,
	0x72, 0x69, 0x74, 0x79, 0x2a, 0xa9, 0x01, 0x0a, 0x10, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x1e, 0x52, 0x45, 0x53,
	0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x50, 0x4f, 0x4f, 0x4c, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a,
	0x16, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x50, 0x4f, 0x4f, 0x4c, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x41, 0x57, 0x53, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x52, 0x45, 0x53,
	0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x50, 0x4f, 0x4f, 0x4c, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x47, 0x43, 0x50, 0x10, 0x02, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43,
	0x45, 0x5f, 0x50, 0x4f, 0x4f, 0x4c, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54,
	0x49, 0x43, 0x10, 0x03, 0x12, 0x1a, 0x0a, 0x16, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45,
	0x5f, 0x50, 0x4f, 0x4f, 0x4c, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4b, 0x38, 0x53, 0x10, 0x04,
	0x2a, 0xdc, 0x01, 0x0a, 0x0d, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x52, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x52, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x50, 0x52, 0x49, 0x4f, 0x52, 0x49, 0x54, 0x59, 0x10, 0x01, 0x12,
	0x1d, 0x0a, 0x19, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x46, 0x41, 0x49, 0x52, 0x5f, 0x53, 0x48, 0x41, 0x52, 0x45, 0x10, 0x02, 0x12, 0x1e,
	0x0a, 0x1a, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x52, 0x4f, 0x55, 0x4e, 0x44, 0x5f, 0x52, 0x4f, 0x42, 0x49, 0x4e, 0x10, 0x03, 0x12, 0x1d,
	0x0a, 0x19, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x4b, 0x55, 0x42, 0x45, 0x52, 0x4e, 0x45, 0x54, 0x45, 0x53, 0x10, 0x04, 0x12, 0x18, 0x0a,
	0x14, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x53, 0x4c, 0x55, 0x52, 0x4d, 0x10, 0x05, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x43, 0x48, 0x45, 0x44,
	0x55, 0x4c, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50, 0x42, 0x53, 0x10, 0x06, 0x2a,
	0xb3, 0x01, 0x0a, 0x0d, 0x46, 0x69, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x1e, 0x0a, 0x1a, 0x46, 0x49, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x50, 0x4f, 0x4c,
	0x49, 0x43, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x17, 0x0a, 0x13, 0x46, 0x49, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x50, 0x4f, 0x4c,
	0x49, 0x43, 0x59, 0x5f, 0x42, 0x45, 0x53, 0x54, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x46, 0x49,
	0x54, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x57, 0x4f, 0x52,
	0x53, 0x54, 0x10, 0x02, 0x12, 0x1d, 0x0a, 0x19, 0x46, 0x49, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x5f,
	0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x4b, 0x55, 0x42, 0x45, 0x52, 0x4e, 0x45, 0x54, 0x45,
	0x53, 0x10, 0x03, 0x12, 0x18, 0x0a, 0x14, 0x46, 0x49, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x50,
	0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x53, 0x4c, 0x55, 0x52, 0x4d, 0x10, 0x04, 0x12, 0x16, 0x0a,
	0x12, 0x46, 0x49, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f,
	0x50, 0x42, 0x53, 0x10, 0x05, 0x42, 0x3e, 0x5a, 0x3c, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2d, 0x61,
	0x69, 0x2f, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x70,
	0x6f, 0x6f, 0x6c, 0x76, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_determined_resourcepool_v1_resourcepool_proto_rawDescOnce sync.Once
	file_determined_resourcepool_v1_resourcepool_proto_rawDescData = file_determined_resourcepool_v1_resourcepool_proto_rawDesc
)

func file_determined_resourcepool_v1_resourcepool_proto_rawDescGZIP() []byte {
	file_determined_resourcepool_v1_resourcepool_proto_rawDescOnce.Do(func() {
		file_determined_resourcepool_v1_resourcepool_proto_rawDescData = protoimpl.X.CompressGZIP(file_determined_resourcepool_v1_resourcepool_proto_rawDescData)
	})
	return file_determined_resourcepool_v1_resourcepool_proto_rawDescData
}

var file_determined_resourcepool_v1_resourcepool_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_determined_resourcepool_v1_resourcepool_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_determined_resourcepool_v1_resourcepool_proto_goTypes = []interface{}{
	(ResourcePoolType)(0),                       // 0: determined.resourcepool.v1.ResourcePoolType
	(SchedulerType)(0),                          // 1: determined.resourcepool.v1.SchedulerType
	(FittingPolicy)(0),                          // 2: determined.resourcepool.v1.FittingPolicy
	(*ResourcePool)(nil),                        // 3: determined.resourcepool.v1.ResourcePool
	(*ResourcePoolDetail)(nil),                  // 4: determined.resourcepool.v1.ResourcePoolDetail
	(*AwsCustomTag)(nil),                        // 5: determined.resourcepool.v1.AwsCustomTag
	(*ResourcePoolAwsDetail)(nil),               // 6: determined.resourcepool.v1.ResourcePoolAwsDetail
	(*ResourcePoolGcpDetail)(nil),               // 7: determined.resourcepool.v1.ResourcePoolGcpDetail
	(*K8PriorityClass)(nil),                     // 8: determined.resourcepool.v1.K8PriorityClass
	(*ResourcePoolPrioritySchedulerDetail)(nil), // 9: determined.resourcepool.v1.ResourcePoolPrioritySchedulerDetail
	nil,                      // 10: determined.resourcepool.v1.ResourcePool.ResourceManagerMetadataEntry
	(devicev1.Type)(0),       // 11: determined.device.v1.Type
	(*jobv1.QueueStats)(nil), // 12: determined.job.v1.QueueStats
}
var file_determined_resourcepool_v1_resourcepool_proto_depIdxs = []int32{
	0,  // 0: determined.resourcepool.v1.ResourcePool.type:type_name -> determined.resourcepool.v1.ResourcePoolType
	11, // 1: determined.resourcepool.v1.ResourcePool.slot_type:type_name -> determined.device.v1.Type
	1,  // 2: determined.resourcepool.v1.ResourcePool.scheduler_type:type_name -> determined.resourcepool.v1.SchedulerType
	2,  // 3: determined.resourcepool.v1.ResourcePool.scheduler_fitting_policy:type_name -> determined.resourcepool.v1.FittingPolicy
	4,  // 4: determined.resourcepool.v1.ResourcePool.details:type_name -> determined.resourcepool.v1.ResourcePoolDetail
	12, // 5: determined.resourcepool.v1.ResourcePool.stats:type_name -> determined.job.v1.QueueStats
	10, // 6: determined.resourcepool.v1.ResourcePool.resource_manager_metadata:type_name -> determined.resourcepool.v1.ResourcePool.ResourceManagerMetadataEntry
	6,  // 7: determined.resourcepool.v1.ResourcePoolDetail.aws:type_name -> determined.resourcepool.v1.ResourcePoolAwsDetail
	7,  // 8: determined.resourcepool.v1.ResourcePoolDetail.gcp:type_name -> determined.resourcepool.v1.ResourcePoolGcpDetail
	9,  // 9: determined.resourcepool.v1.ResourcePoolDetail.priority_scheduler:type_name -> determined.resourcepool.v1.ResourcePoolPrioritySchedulerDetail
	5,  // 10: determined.resourcepool.v1.ResourcePoolAwsDetail.custom_tags:type_name -> determined.resourcepool.v1.AwsCustomTag
	8,  // 11: determined.resourcepool.v1.ResourcePoolPrioritySchedulerDetail.k8_priorities:type_name -> determined.resourcepool.v1.K8PriorityClass
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_determined_resourcepool_v1_resourcepool_proto_init() }
func file_determined_resourcepool_v1_resourcepool_proto_init() {
	if File_determined_resourcepool_v1_resourcepool_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_determined_resourcepool_v1_resourcepool_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourcePool); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_resourcepool_v1_resourcepool_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourcePoolDetail); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_resourcepool_v1_resourcepool_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsCustomTag); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_resourcepool_v1_resourcepool_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourcePoolAwsDetail); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_resourcepool_v1_resourcepool_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourcePoolGcpDetail); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_resourcepool_v1_resourcepool_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*K8PriorityClass); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_resourcepool_v1_resourcepool_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourcePoolPrioritySchedulerDetail); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_determined_resourcepool_v1_resourcepool_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_determined_resourcepool_v1_resourcepool_proto_goTypes,
		DependencyIndexes: file_determined_resourcepool_v1_resourcepool_proto_depIdxs,
		EnumInfos:         file_determined_resourcepool_v1_resourcepool_proto_enumTypes,
		MessageInfos:      file_determined_resourcepool_v1_resourcepool_proto_msgTypes,
	}.Build()
	File_determined_resourcepool_v1_resourcepool_proto = out.File
	file_determined_resourcepool_v1_resourcepool_proto_rawDesc = nil
	file_determined_resourcepool_v1_resourcepool_proto_goTypes = nil
	file_determined_resourcepool_v1_resourcepool_proto_depIdxs = nil
}
