// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// source: determined/job/v1/job.proto

package jobv1

import (
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "github.com/grpc-ecosystem/grpc-gateway/protoc-gen-swagger/options"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Job type.
type Type int32

const (
	// Unspecified state.
	Type_TYPE_UNSPECIFIED Type = 0
	// Experiement Job.
	Type_TYPE_EXPERIMENT Type = 1
	// Jupyter Notebook Job.
	Type_TYPE_NOTEBOOK Type = 2
	// TensorBoard Job.
	Type_TYPE_TENSORBOARD Type = 3
	// Shell Job.
	Type_TYPE_SHELL Type = 4
	// Command Job.
	Type_TYPE_COMMAND Type = 5
	// CheckpointGC Job.
	Type_TYPE_CHECKPOINT_GC Type = 6
	// External Job.
	Type_TYPE_EXTERNAL Type = 7
	// Generic Job.
	Type_TYPE_GENERIC Type = 8
)

// Enum value maps for Type.
var (
	Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "TYPE_EXPERIMENT",
		2: "TYPE_NOTEBOOK",
		3: "TYPE_TENSORBOARD",
		4: "TYPE_SHELL",
		5: "TYPE_COMMAND",
		6: "TYPE_CHECKPOINT_GC",
		7: "TYPE_EXTERNAL",
		8: "TYPE_GENERIC",
	}
	Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":   0,
		"TYPE_EXPERIMENT":    1,
		"TYPE_NOTEBOOK":      2,
		"TYPE_TENSORBOARD":   3,
		"TYPE_SHELL":         4,
		"TYPE_COMMAND":       5,
		"TYPE_CHECKPOINT_GC": 6,
		"TYPE_EXTERNAL":      7,
		"TYPE_GENERIC":       8,
	}
)

func (x Type) Enum() *Type {
	p := new(Type)
	*p = x
	return p
}

func (x Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Type) Descriptor() protoreflect.EnumDescriptor {
	return file_determined_job_v1_job_proto_enumTypes[0].Descriptor()
}

func (Type) Type() protoreflect.EnumType {
	return &file_determined_job_v1_job_proto_enumTypes[0]
}

func (x Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Type.Descriptor instead.
func (Type) EnumDescriptor() ([]byte, []int) {
	return file_determined_job_v1_job_proto_rawDescGZIP(), []int{0}
}

// Job state.
type State int32

const (
	// Unspecified state.
	State_STATE_UNSPECIFIED State = 0
	// Job is queued and waiting to be schedlued.
	State_STATE_QUEUED State = 1
	// Job is scheduled.
	State_STATE_SCHEDULED State = 2
	// Job is scheduled as a backfill.
	State_STATE_SCHEDULED_BACKFILLED State = 3
)

// Enum value maps for State.
var (
	State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "STATE_QUEUED",
		2: "STATE_SCHEDULED",
		3: "STATE_SCHEDULED_BACKFILLED",
	}
	State_value = map[string]int32{
		"STATE_UNSPECIFIED":          0,
		"STATE_QUEUED":               1,
		"STATE_SCHEDULED":            2,
		"STATE_SCHEDULED_BACKFILLED": 3,
	}
)

func (x State) Enum() *State {
	p := new(State)
	*p = x
	return p
}

func (x State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (State) Descriptor() protoreflect.EnumDescriptor {
	return file_determined_job_v1_job_proto_enumTypes[1].Descriptor()
}

func (State) Type() protoreflect.EnumType {
	return &file_determined_job_v1_job_proto_enumTypes[1]
}

func (x State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use State.Descriptor instead.
func (State) EnumDescriptor() ([]byte, []int) {
	return file_determined_job_v1_job_proto_rawDescGZIP(), []int{1}
}

// Job summary.
type JobSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The scheduling state of the job.
	State State `protobuf:"varint,1,opt,name=state,proto3,enum=determined.job.v1.State" json:"state,omitempty"`
	// The number of jobs ahead of this one in the queue.
	JobsAhead int32 `protobuf:"varint,2,opt,name=jobs_ahead,json=jobsAhead,proto3" json:"jobs_ahead,omitempty"`
}

func (x *JobSummary) Reset() {
	*x = JobSummary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_job_v1_job_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobSummary) ProtoMessage() {}

func (x *JobSummary) ProtoReflect() protoreflect.Message {
	mi := &file_determined_job_v1_job_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobSummary.ProtoReflect.Descriptor instead.
func (*JobSummary) Descriptor() ([]byte, []int) {
	return file_determined_job_v1_job_proto_rawDescGZIP(), []int{0}
}

func (x *JobSummary) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STATE_UNSPECIFIED
}

func (x *JobSummary) GetJobsAhead() int32 {
	if x != nil {
		return x.JobsAhead
	}
	return 0
}

// LimitedJob is a Job with omitted fields.
type LimitedJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Job summary.
	Summary *JobSummary `protobuf:"bytes,1,opt,name=summary,proto3" json:"summary,omitempty"`
	// Job type.
	Type Type `protobuf:"varint,2,opt,name=type,proto3,enum=determined.job.v1.Type" json:"type,omitempty"`
	// Associated resource pool.
	ResourcePool string `protobuf:"bytes,5,opt,name=resource_pool,json=resourcePool,proto3" json:"resource_pool,omitempty"`
	// Whether the job is preemptible.
	IsPreemptible bool `protobuf:"varint,6,opt,name=is_preemptible,json=isPreemptible,proto3" json:"is_preemptible,omitempty"`
	// The job priority in priority scheduler.
	Priority int32 `protobuf:"varint,7,opt,name=priority,proto3" json:"priority,omitempty"`
	// The job weight in fairshare scheduler.
	Weight float64 `protobuf:"fixed64,8,opt,name=weight,proto3" json:"weight,omitempty"`
	// Job type.
	JobId string `protobuf:"bytes,10,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// Number of requested slots.
	RequestedSlots int32 `protobuf:"varint,11,opt,name=requested_slots,json=requestedSlots,proto3" json:"requested_slots,omitempty"`
	// Number of allocated slots.
	AllocatedSlots int32 `protobuf:"varint,12,opt,name=allocated_slots,json=allocatedSlots,proto3" json:"allocated_slots,omitempty"`
	// Job's progress from 0 to 1.
	Progress float32 `protobuf:"fixed32,14,opt,name=progress,proto3" json:"progress,omitempty"`
	// Job's workspace id.
	WorkspaceId int32 `protobuf:"varint,16,opt,name=workspace_id,json=workspaceId,proto3" json:"workspace_id,omitempty"`
}

func (x *LimitedJob) Reset() {
	*x = LimitedJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_job_v1_job_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LimitedJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LimitedJob) ProtoMessage() {}

func (x *LimitedJob) ProtoReflect() protoreflect.Message {
	mi := &file_determined_job_v1_job_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LimitedJob.ProtoReflect.Descriptor instead.
func (*LimitedJob) Descriptor() ([]byte, []int) {
	return file_determined_job_v1_job_proto_rawDescGZIP(), []int{1}
}

func (x *LimitedJob) GetSummary() *JobSummary {
	if x != nil {
		return x.Summary
	}
	return nil
}

func (x *LimitedJob) GetType() Type {
	if x != nil {
		return x.Type
	}
	return Type_TYPE_UNSPECIFIED
}

func (x *LimitedJob) GetResourcePool() string {
	if x != nil {
		return x.ResourcePool
	}
	return ""
}

func (x *LimitedJob) GetIsPreemptible() bool {
	if x != nil {
		return x.IsPreemptible
	}
	return false
}

func (x *LimitedJob) GetPriority() int32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *LimitedJob) GetWeight() float64 {
	if x != nil {
		return x.Weight
	}
	return 0
}

func (x *LimitedJob) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

func (x *LimitedJob) GetRequestedSlots() int32 {
	if x != nil {
		return x.RequestedSlots
	}
	return 0
}

func (x *LimitedJob) GetAllocatedSlots() int32 {
	if x != nil {
		return x.AllocatedSlots
	}
	return 0
}

func (x *LimitedJob) GetProgress() float32 {
	if x != nil {
		return x.Progress
	}
	return 0
}

func (x *LimitedJob) GetWorkspaceId() int32 {
	if x != nil {
		return x.WorkspaceId
	}
	return 0
}

// Job represents a user submitted work that is not in a terminal
// state.
type Job struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Job summary.
	Summary *JobSummary `protobuf:"bytes,1,opt,name=summary,proto3" json:"summary,omitempty"`
	// Job type.
	Type Type `protobuf:"varint,2,opt,name=type,proto3,enum=determined.job.v1.Type" json:"type,omitempty"`
	// The time when the job was submitted by the user.
	SubmissionTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=submission_time,json=submissionTime,proto3" json:"submission_time,omitempty"`
	// The username of the user who submitted the job.
	Username string `protobuf:"bytes,4,opt,name=username,proto3" json:"username,omitempty"`
	// The id of the user who submitted the job.
	UserId int32 `protobuf:"varint,15,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// Associated resource pool.
	ResourcePool string `protobuf:"bytes,5,opt,name=resource_pool,json=resourcePool,proto3" json:"resource_pool,omitempty"`
	// Whether the job is preemptible.
	IsPreemptible bool `protobuf:"varint,6,opt,name=is_preemptible,json=isPreemptible,proto3" json:"is_preemptible,omitempty"`
	// The job priority in priority scheduler.
	Priority int32 `protobuf:"varint,7,opt,name=priority,proto3" json:"priority,omitempty"`
	// The job weight in fairshare scheduler.
	Weight float64 `protobuf:"fixed64,8,opt,name=weight,proto3" json:"weight,omitempty"`
	// Entity ID.
	EntityId string `protobuf:"bytes,9,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// Job type.
	JobId string `protobuf:"bytes,10,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// Number of requested slots.
	RequestedSlots int32 `protobuf:"varint,11,opt,name=requested_slots,json=requestedSlots,proto3" json:"requested_slots,omitempty"`
	// Number of allocated slots.
	AllocatedSlots int32 `protobuf:"varint,12,opt,name=allocated_slots,json=allocatedSlots,proto3" json:"allocated_slots,omitempty"`
	// Job name.
	Name string `protobuf:"bytes,13,opt,name=name,proto3" json:"name,omitempty"`
	// Job's progress from 0 to 1.
	Progress float32 `protobuf:"fixed32,14,opt,name=progress,proto3" json:"progress,omitempty"`
	// Job's workspace id.
	WorkspaceId int32 `protobuf:"varint,16,opt,name=workspace_id,json=workspaceId,proto3" json:"workspace_id,omitempty"`
}

func (x *Job) Reset() {
	*x = Job{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_job_v1_job_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Job) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Job) ProtoMessage() {}

func (x *Job) ProtoReflect() protoreflect.Message {
	mi := &file_determined_job_v1_job_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Job.ProtoReflect.Descriptor instead.
func (*Job) Descriptor() ([]byte, []int) {
	return file_determined_job_v1_job_proto_rawDescGZIP(), []int{2}
}

func (x *Job) GetSummary() *JobSummary {
	if x != nil {
		return x.Summary
	}
	return nil
}

func (x *Job) GetType() Type {
	if x != nil {
		return x.Type
	}
	return Type_TYPE_UNSPECIFIED
}

func (x *Job) GetSubmissionTime() *timestamp.Timestamp {
	if x != nil {
		return x.SubmissionTime
	}
	return nil
}

func (x *Job) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *Job) GetUserId() int32 {
	if x != nil {
		return x.UserId
	}
	return 0
}

func (x *Job) GetResourcePool() string {
	if x != nil {
		return x.ResourcePool
	}
	return ""
}

func (x *Job) GetIsPreemptible() bool {
	if x != nil {
		return x.IsPreemptible
	}
	return false
}

func (x *Job) GetPriority() int32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *Job) GetWeight() float64 {
	if x != nil {
		return x.Weight
	}
	return 0
}

func (x *Job) GetEntityId() string {
	if x != nil {
		return x.EntityId
	}
	return ""
}

func (x *Job) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

func (x *Job) GetRequestedSlots() int32 {
	if x != nil {
		return x.RequestedSlots
	}
	return 0
}

func (x *Job) GetAllocatedSlots() int32 {
	if x != nil {
		return x.AllocatedSlots
	}
	return 0
}

func (x *Job) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Job) GetProgress() float32 {
	if x != nil {
		return x.Progress
	}
	return 0
}

func (x *Job) GetWorkspaceId() int32 {
	if x != nil {
		return x.WorkspaceId
	}
	return 0
}

// RBACJob is a job that can have either a limited or a full
// representation of a job.
type RBACJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// job represent one of the possible representations of a job.
	//
	// Types that are assignable to Job:
	//
	//	*RBACJob_Full
	//	*RBACJob_Limited
	Job isRBACJob_Job `protobuf_oneof:"job"`
}

func (x *RBACJob) Reset() {
	*x = RBACJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_job_v1_job_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RBACJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RBACJob) ProtoMessage() {}

func (x *RBACJob) ProtoReflect() protoreflect.Message {
	mi := &file_determined_job_v1_job_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RBACJob.ProtoReflect.Descriptor instead.
func (*RBACJob) Descriptor() ([]byte, []int) {
	return file_determined_job_v1_job_proto_rawDescGZIP(), []int{3}
}

func (m *RBACJob) GetJob() isRBACJob_Job {
	if m != nil {
		return m.Job
	}
	return nil
}

func (x *RBACJob) GetFull() *Job {
	if x, ok := x.GetJob().(*RBACJob_Full); ok {
		return x.Full
	}
	return nil
}

func (x *RBACJob) GetLimited() *LimitedJob {
	if x, ok := x.GetJob().(*RBACJob_Limited); ok {
		return x.Limited
	}
	return nil
}

type isRBACJob_Job interface {
	isRBACJob_Job()
}

type RBACJob_Full struct {
	// Full representation.
	Full *Job `protobuf:"bytes,1,opt,name=full,proto3,oneof"`
}

type RBACJob_Limited struct {
	// Limited representation for lower access levels.
	Limited *LimitedJob `protobuf:"bytes,2,opt,name=limited,proto3,oneof"`
}

func (*RBACJob_Full) isRBACJob_Job() {}

func (*RBACJob_Limited) isRBACJob_Job() {}

// Describes a message to control jobs in a queue.
type QueueControl struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Job id.
	JobId string `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// The action to perform.
	//
	// Types that are assignable to Action:
	//
	//	*QueueControl_AheadOf
	//	*QueueControl_BehindOf
	//	*QueueControl_ResourcePool
	//	*QueueControl_Priority
	//	*QueueControl_Weight
	Action isQueueControl_Action `protobuf_oneof:"action"`
}

func (x *QueueControl) Reset() {
	*x = QueueControl{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_job_v1_job_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueueControl) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueueControl) ProtoMessage() {}

func (x *QueueControl) ProtoReflect() protoreflect.Message {
	mi := &file_determined_job_v1_job_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueueControl.ProtoReflect.Descriptor instead.
func (*QueueControl) Descriptor() ([]byte, []int) {
	return file_determined_job_v1_job_proto_rawDescGZIP(), []int{4}
}

func (x *QueueControl) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

func (m *QueueControl) GetAction() isQueueControl_Action {
	if m != nil {
		return m.Action
	}
	return nil
}

// Deprecated: Do not use.
func (x *QueueControl) GetAheadOf() string {
	if x, ok := x.GetAction().(*QueueControl_AheadOf); ok {
		return x.AheadOf
	}
	return ""
}

// Deprecated: Do not use.
func (x *QueueControl) GetBehindOf() string {
	if x, ok := x.GetAction().(*QueueControl_BehindOf); ok {
		return x.BehindOf
	}
	return ""
}

func (x *QueueControl) GetResourcePool() string {
	if x, ok := x.GetAction().(*QueueControl_ResourcePool); ok {
		return x.ResourcePool
	}
	return ""
}

func (x *QueueControl) GetPriority() int32 {
	if x, ok := x.GetAction().(*QueueControl_Priority); ok {
		return x.Priority
	}
	return 0
}

func (x *QueueControl) GetWeight() float32 {
	if x, ok := x.GetAction().(*QueueControl_Weight); ok {
		return x.Weight
	}
	return 0
}

type isQueueControl_Action interface {
	isQueueControl_Action()
}

type QueueControl_AheadOf struct {
	// Deprecated; do not use.
	//
	// Deprecated: Do not use.
	AheadOf string `protobuf:"bytes,2,opt,name=ahead_of,json=aheadOf,proto3,oneof"`
}

type QueueControl_BehindOf struct {
	// Deprecated; do not use.
	//
	// Deprecated: Do not use.
	BehindOf string `protobuf:"bytes,4,opt,name=behind_of,json=behindOf,proto3,oneof"`
}

type QueueControl_ResourcePool struct {
	// Name of the target resource_pool to move the job to.
	ResourcePool string `protobuf:"bytes,3,opt,name=resource_pool,json=resourcePool,proto3,oneof"`
}

type QueueControl_Priority struct {
	// The desired job priority in priority scheduler.
	Priority int32 `protobuf:"varint,5,opt,name=priority,proto3,oneof"`
}

type QueueControl_Weight struct {
	// The desired job weight in fairshare scheduler.
	Weight float32 `protobuf:"fixed32,6,opt,name=weight,proto3,oneof"`
}

func (*QueueControl_AheadOf) isQueueControl_Action() {}

func (*QueueControl_BehindOf) isQueueControl_Action() {}

func (*QueueControl_ResourcePool) isQueueControl_Action() {}

func (*QueueControl_Priority) isQueueControl_Action() {}

func (*QueueControl_Weight) isQueueControl_Action() {}

// Statistics for a queue.
type QueueStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of queued jobs in the queue.
	QueuedCount int32 `protobuf:"varint,1,opt,name=queued_count,json=queuedCount,proto3" json:"queued_count,omitempty"`
	// Number of scheduled jobs in the queue.
	ScheduledCount int32 `protobuf:"varint,2,opt,name=scheduled_count,json=scheduledCount,proto3" json:"scheduled_count,omitempty"`
}

func (x *QueueStats) Reset() {
	*x = QueueStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_job_v1_job_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueueStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueueStats) ProtoMessage() {}

func (x *QueueStats) ProtoReflect() protoreflect.Message {
	mi := &file_determined_job_v1_job_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueueStats.ProtoReflect.Descriptor instead.
func (*QueueStats) Descriptor() ([]byte, []int) {
	return file_determined_job_v1_job_proto_rawDescGZIP(), []int{5}
}

func (x *QueueStats) GetQueuedCount() int32 {
	if x != nil {
		return x.QueuedCount
	}
	return 0
}

func (x *QueueStats) GetScheduledCount() int32 {
	if x != nil {
		return x.ScheduledCount
	}
	return 0
}

// Aggregate statistics for a queue.
type AggregateQueueStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The date of this entry.
	PeriodStart string `protobuf:"bytes,1,opt,name=period_start,json=periodStart,proto3" json:"period_start,omitempty"`
	// The total number of seconds queued.
	Seconds float32 `protobuf:"fixed32,2,opt,name=seconds,proto3" json:"seconds,omitempty"`
}

func (x *AggregateQueueStats) Reset() {
	*x = AggregateQueueStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_job_v1_job_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregateQueueStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregateQueueStats) ProtoMessage() {}

func (x *AggregateQueueStats) ProtoReflect() protoreflect.Message {
	mi := &file_determined_job_v1_job_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregateQueueStats.ProtoReflect.Descriptor instead.
func (*AggregateQueueStats) Descriptor() ([]byte, []int) {
	return file_determined_job_v1_job_proto_rawDescGZIP(), []int{6}
}

func (x *AggregateQueueStats) GetPeriodStart() string {
	if x != nil {
		return x.PeriodStart
	}
	return ""
}

func (x *AggregateQueueStats) GetSeconds() float32 {
	if x != nil {
		return x.Seconds
	}
	return 0
}

var File_determined_job_v1_job_proto protoreflect.FileDescriptor

var file_determined_job_v1_job_proto_rawDesc = []byte{
	0x0a, 0x1b, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x6a, 0x6f, 0x62,
	0x2f, 0x76, 0x31, 0x2f, 0x6a, 0x6f, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x11, 0x64,
	0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x6a, 0x6f, 0x62, 0x2e, 0x76, 0x31,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2c, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x73, 0x77,
	0x61, 0x67, 0x67, 0x65, 0x72, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0x77, 0x0a, 0x0a, 0x4a, 0x6f, 0x62, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x2e, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x18, 0x2e, 0x64,
	0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x6a, 0x6f, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x6a, 0x6f, 0x62, 0x73, 0x5f, 0x61, 0x68, 0x65, 0x61, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x09, 0x6a, 0x6f, 0x62, 0x73, 0x41, 0x68, 0x65, 0x61, 0x64, 0x3a, 0x1a, 0x92, 0x41,
	0x17, 0x0a, 0x15, 0xd2, 0x01, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0xd2, 0x01, 0x0a, 0x6a, 0x6f,
	0x62, 0x73, 0x5f, 0x61, 0x68, 0x65, 0x61, 0x64, 0x22, 0x85, 0x04, 0x0a, 0x0a, 0x4c, 0x69, 0x6d,
	0x69, 0x74, 0x65, 0x64, 0x4a, 0x6f, 0x62, 0x12, 0x37, 0x0a, 0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72,
	0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x6a, 0x6f, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62,
	0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79,
	0x12, 0x2b, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x17,
	0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x6a, 0x6f, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a,
	0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x6f,
	0x6f, 0x6c, 0x12, 0x25, 0x0a, 0x0e, 0x69, 0x73, 0x5f, 0x70, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74,
	0x69, 0x62, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x69, 0x73, 0x50, 0x72,
	0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x69,
	0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x72, 0x69,
	0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x01, 0x52, 0x06, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x15, 0x0a,
	0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6a,
	0x6f, 0x62, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65,
	0x64, 0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x53, 0x6c, 0x6f, 0x74, 0x73, 0x12, 0x27, 0x0a,
	0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x73,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65,
	0x64, 0x53, 0x6c, 0x6f, 0x74, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x02, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x10, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x49, 0x64, 0x3a, 0x69, 0x92, 0x41, 0x66, 0x0a, 0x64, 0xd2, 0x01, 0x04, 0x74,
	0x79, 0x70, 0x65, 0xd2, 0x01, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70,
	0x6f, 0x6f, 0x6c, 0xd2, 0x01, 0x0e, 0x69, 0x73, 0x5f, 0x70, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74,
	0x69, 0x62, 0x6c, 0x65, 0xd2, 0x01, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64,
	0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x73, 0xd2, 0x01, 0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x65, 0x64, 0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x73, 0xd2, 0x01, 0x0c, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64,
	0x22, 0xdc, 0x05, 0x0a, 0x03, 0x4a, 0x6f, 0x62, 0x12, 0x37, 0x0a, 0x07, 0x73, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x65, 0x74, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x6a, 0x6f, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f,
	0x62, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x12, 0x2b, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x17, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x6a, 0x6f, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x43,
	0x0a, 0x0f, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0e, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x17, 0x0a, 0x07, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x25, 0x0a,
	0x0e, 0x69, 0x73, 0x5f, 0x70, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x69, 0x73, 0x50, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74,
	0x69, 0x62, 0x6c, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79,
	0x12, 0x16, 0x0a, 0x06, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x01,
	0x52, 0x06, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x49, 0x64, 0x12, 0x15, 0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x73, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64,
	0x53, 0x6c, 0x6f, 0x74, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x65, 0x64, 0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e,
	0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x53, 0x6c, 0x6f, 0x74, 0x73, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x02, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x21,
	0x0a, 0x0c, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x10,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x49,
	0x64, 0x3a, 0x9b, 0x01, 0x92, 0x41, 0x97, 0x01, 0x0a, 0x94, 0x01, 0xd2, 0x01, 0x04, 0x74, 0x79,
	0x70, 0x65, 0xd2, 0x01, 0x0f, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0xd2, 0x01, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0xd2,
	0x01, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0xd2,
	0x01, 0x0e, 0x69, 0x73, 0x5f, 0x70, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x62, 0x6c, 0x65,
	0xd2, 0x01, 0x09, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0xd2, 0x01, 0x0c, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f,
	0x69, 0x64, 0xd2, 0x01, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x73,
	0x6c, 0x6f, 0x74, 0x73, 0xd2, 0x01, 0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x73, 0xd2, 0x01, 0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x22,
	0x79, 0x0a, 0x07, 0x52, 0x42, 0x41, 0x43, 0x4a, 0x6f, 0x62, 0x12, 0x2c, 0x0a, 0x04, 0x66, 0x75,
	0x6c, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72,
	0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x6a, 0x6f, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62,
	0x48, 0x00, 0x52, 0x04, 0x66, 0x75, 0x6c, 0x6c, 0x12, 0x39, 0x0a, 0x07, 0x6c, 0x69, 0x6d, 0x69,
	0x74, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x65, 0x74, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x6a, 0x6f, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x6d, 0x69, 0x74, 0x65, 0x64, 0x4a, 0x6f, 0x62, 0x48, 0x00, 0x52, 0x07, 0x6c, 0x69, 0x6d, 0x69,
	0x74, 0x65, 0x64, 0x42, 0x05, 0x0a, 0x03, 0x6a, 0x6f, 0x62, 0x22, 0xeb, 0x01, 0x0a, 0x0c, 0x51,
	0x75, 0x65, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12, 0x15, 0x0a, 0x06, 0x6a,
	0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6a, 0x6f, 0x62,
	0x49, 0x64, 0x12, 0x1f, 0x0a, 0x08, 0x61, 0x68, 0x65, 0x61, 0x64, 0x5f, 0x6f, 0x66, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x07, 0x61, 0x68, 0x65, 0x61,
	0x64, 0x4f, 0x66, 0x12, 0x21, 0x0a, 0x09, 0x62, 0x65, 0x68, 0x69, 0x6e, 0x64, 0x5f, 0x6f, 0x66,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x08, 0x62, 0x65,
	0x68, 0x69, 0x6e, 0x64, 0x4f, 0x66, 0x12, 0x25, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52,
	0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x1c, 0x0a,
	0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x48,
	0x00, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x18, 0x0a, 0x06, 0x77,
	0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00, 0x52, 0x06, 0x77,
	0x65, 0x69, 0x67, 0x68, 0x74, 0x3a, 0x17, 0x92, 0x41, 0x14, 0x0a, 0x12, 0xd2, 0x01, 0x06, 0x6a,
	0x6f, 0x62, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x08,
	0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x80, 0x01, 0x0a, 0x0a, 0x51, 0x75, 0x65,
	0x75, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x71, 0x75, 0x65, 0x75, 0x65,
	0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x71,
	0x75, 0x65, 0x75, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0e, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x3a, 0x26, 0x92, 0x41, 0x23, 0x0a, 0x21, 0xd2, 0x01, 0x0c, 0x71, 0x75, 0x65,
	0x75, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0xd2, 0x01, 0x0f, 0x73, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x72, 0x0a, 0x13, 0x41,
	0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x51, 0x75, 0x65, 0x75, 0x65, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x5f, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64,
	0x53, 0x74, 0x61, 0x72, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x07, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x3a,
	0x1e, 0x92, 0x41, 0x1b, 0x0a, 0x19, 0xd2, 0x01, 0x0c, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x5f,
	0x73, 0x74, 0x61, 0x72, 0x74, 0xd2, 0x01, 0x07, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x2a,
	0xb9, 0x01, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13,
	0x0a, 0x0f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x45, 0x58, 0x50, 0x45, 0x52, 0x49, 0x4d, 0x45, 0x4e,
	0x54, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x45,
	0x42, 0x4f, 0x4f, 0x4b, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x54,
	0x45, 0x4e, 0x53, 0x4f, 0x52, 0x42, 0x4f, 0x41, 0x52, 0x44, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x48, 0x45, 0x4c, 0x4c, 0x10, 0x04, 0x12, 0x10, 0x0a, 0x0c,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x4f, 0x4d, 0x4d, 0x41, 0x4e, 0x44, 0x10, 0x05, 0x12, 0x16,
	0x0a, 0x12, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x50, 0x4f, 0x49, 0x4e,
	0x54, 0x5f, 0x47, 0x43, 0x10, 0x06, 0x12, 0x11, 0x0a, 0x0d, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x45,
	0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x10, 0x07, 0x12, 0x10, 0x0a, 0x0c, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x47, 0x45, 0x4e, 0x45, 0x52, 0x49, 0x43, 0x10, 0x08, 0x2a, 0x65, 0x0a, 0x05, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x51, 0x55, 0x45, 0x55, 0x45, 0x44, 0x10, 0x01, 0x12, 0x13, 0x0a,
	0x0f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x44,
	0x10, 0x02, 0x12, 0x1e, 0x0a, 0x1a, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x43, 0x48, 0x45,
	0x44, 0x55, 0x4c, 0x45, 0x44, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x46, 0x49, 0x4c, 0x4c, 0x45, 0x44,
	0x10, 0x03, 0x42, 0x35, 0x5a, 0x33, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2d, 0x61, 0x69, 0x2f, 0x64,
	0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x70, 0x6b, 0x67, 0x2f, 0x6a, 0x6f, 0x62, 0x76, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_determined_job_v1_job_proto_rawDescOnce sync.Once
	file_determined_job_v1_job_proto_rawDescData = file_determined_job_v1_job_proto_rawDesc
)

func file_determined_job_v1_job_proto_rawDescGZIP() []byte {
	file_determined_job_v1_job_proto_rawDescOnce.Do(func() {
		file_determined_job_v1_job_proto_rawDescData = protoimpl.X.CompressGZIP(file_determined_job_v1_job_proto_rawDescData)
	})
	return file_determined_job_v1_job_proto_rawDescData
}

var file_determined_job_v1_job_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_determined_job_v1_job_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_determined_job_v1_job_proto_goTypes = []interface{}{
	(Type)(0),                   // 0: determined.job.v1.Type
	(State)(0),                  // 1: determined.job.v1.State
	(*JobSummary)(nil),          // 2: determined.job.v1.JobSummary
	(*LimitedJob)(nil),          // 3: determined.job.v1.LimitedJob
	(*Job)(nil),                 // 4: determined.job.v1.Job
	(*RBACJob)(nil),             // 5: determined.job.v1.RBACJob
	(*QueueControl)(nil),        // 6: determined.job.v1.QueueControl
	(*QueueStats)(nil),          // 7: determined.job.v1.QueueStats
	(*AggregateQueueStats)(nil), // 8: determined.job.v1.AggregateQueueStats
	(*timestamp.Timestamp)(nil), // 9: google.protobuf.Timestamp
}
var file_determined_job_v1_job_proto_depIdxs = []int32{
	1, // 0: determined.job.v1.JobSummary.state:type_name -> determined.job.v1.State
	2, // 1: determined.job.v1.LimitedJob.summary:type_name -> determined.job.v1.JobSummary
	0, // 2: determined.job.v1.LimitedJob.type:type_name -> determined.job.v1.Type
	2, // 3: determined.job.v1.Job.summary:type_name -> determined.job.v1.JobSummary
	0, // 4: determined.job.v1.Job.type:type_name -> determined.job.v1.Type
	9, // 5: determined.job.v1.Job.submission_time:type_name -> google.protobuf.Timestamp
	4, // 6: determined.job.v1.RBACJob.full:type_name -> determined.job.v1.Job
	3, // 7: determined.job.v1.RBACJob.limited:type_name -> determined.job.v1.LimitedJob
	8, // [8:8] is the sub-list for method output_type
	8, // [8:8] is the sub-list for method input_type
	8, // [8:8] is the sub-list for extension type_name
	8, // [8:8] is the sub-list for extension extendee
	0, // [0:8] is the sub-list for field type_name
}

func init() { file_determined_job_v1_job_proto_init() }
func file_determined_job_v1_job_proto_init() {
	if File_determined_job_v1_job_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_determined_job_v1_job_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobSummary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_job_v1_job_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LimitedJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_job_v1_job_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Job); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_job_v1_job_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RBACJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_job_v1_job_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueueControl); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_job_v1_job_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueueStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_job_v1_job_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AggregateQueueStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_determined_job_v1_job_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*RBACJob_Full)(nil),
		(*RBACJob_Limited)(nil),
	}
	file_determined_job_v1_job_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*QueueControl_AheadOf)(nil),
		(*QueueControl_BehindOf)(nil),
		(*QueueControl_ResourcePool)(nil),
		(*QueueControl_Priority)(nil),
		(*QueueControl_Weight)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_determined_job_v1_job_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_determined_job_v1_job_proto_goTypes,
		DependencyIndexes: file_determined_job_v1_job_proto_depIdxs,
		EnumInfos:         file_determined_job_v1_job_proto_enumTypes,
		MessageInfos:      file_determined_job_v1_job_proto_msgTypes,
	}.Build()
	File_determined_job_v1_job_proto = out.File
	file_determined_job_v1_job_proto_rawDesc = nil
	file_determined_job_v1_job_proto_goTypes = nil
	file_determined_job_v1_job_proto_depIdxs = nil
}
