// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// source: determined/experiment/v1/experiment.proto

package experimentv1

import (
	_struct "github.com/golang/protobuf/ptypes/struct"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	_ "github.com/grpc-ecosystem/grpc-gateway/protoc-gen-swagger/options"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The current state of the experiment.
type State int32

const (
	// The state of the experiment is unknown.
	State_STATE_UNSPECIFIED State = 0
	// The experiment is in an active state.
	State_STATE_ACTIVE State = 1
	// The experiment is in a paused state
	State_STATE_PAUSED State = 2
	// The experiment is completed and is shutting down.
	State_STATE_STOPPING_COMPLETED State = 3
	// The experiment is canceled and is shutting down.
	State_STATE_STOPPING_CANCELED State = 4
	// The experiment is errored and is shutting down.
	State_STATE_STOPPING_ERROR State = 5
	// The experiment is completed and is shut down.
	State_STATE_COMPLETED State = 6
	// The experiment is canceled and is shut down.
	State_STATE_CANCELED State = 7
	// The experiment is errored and is shut down.
	State_STATE_ERROR State = 8
	// The experiment has been deleted.
	State_STATE_DELETED State = 9
	// The experiment is deleting.
	State_STATE_DELETING State = 10
	// The experiment failed to delete.
	State_STATE_DELETE_FAILED State = 11
	// The experiment is killed and is shutting down.
	State_STATE_STOPPING_KILLED State = 12
	// The experiment is queued (waiting to be run, or job state is still queued).
	// Queued is a substate of the Active state.
	State_STATE_QUEUED State = 13
	// The experiment is pulling the image. Pulling is a substate of the Active
	// state.
	State_STATE_PULLING State = 14
	// The experiment is preparing the environment after finishing pulling the
	// image. Starting is a substate of the Active state.
	State_STATE_STARTING State = 15
	// The experiment has an allocation actively running.
	// Running is a substate of the Active state.
	State_STATE_RUNNING State = 16
)

// Enum value maps for State.
var (
	State_name = map[int32]string{
		0:  "STATE_UNSPECIFIED",
		1:  "STATE_ACTIVE",
		2:  "STATE_PAUSED",
		3:  "STATE_STOPPING_COMPLETED",
		4:  "STATE_STOPPING_CANCELED",
		5:  "STATE_STOPPING_ERROR",
		6:  "STATE_COMPLETED",
		7:  "STATE_CANCELED",
		8:  "STATE_ERROR",
		9:  "STATE_DELETED",
		10: "STATE_DELETING",
		11: "STATE_DELETE_FAILED",
		12: "STATE_STOPPING_KILLED",
		13: "STATE_QUEUED",
		14: "STATE_PULLING",
		15: "STATE_STARTING",
		16: "STATE_RUNNING",
	}
	State_value = map[string]int32{
		"STATE_UNSPECIFIED":        0,
		"STATE_ACTIVE":             1,
		"STATE_PAUSED":             2,
		"STATE_STOPPING_COMPLETED": 3,
		"STATE_STOPPING_CANCELED":  4,
		"STATE_STOPPING_ERROR":     5,
		"STATE_COMPLETED":          6,
		"STATE_CANCELED":           7,
		"STATE_ERROR":              8,
		"STATE_DELETED":            9,
		"STATE_DELETING":           10,
		"STATE_DELETE_FAILED":      11,
		"STATE_STOPPING_KILLED":    12,
		"STATE_QUEUED":             13,
		"STATE_PULLING":            14,
		"STATE_STARTING":           15,
		"STATE_RUNNING":            16,
	}
)

func (x State) Enum() *State {
	p := new(State)
	*p = x
	return p
}

func (x State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (State) Descriptor() protoreflect.EnumDescriptor {
	return file_determined_experiment_v1_experiment_proto_enumTypes[0].Descriptor()
}

func (State) Type() protoreflect.EnumType {
	return &file_determined_experiment_v1_experiment_proto_enumTypes[0]
}

func (x State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use State.Descriptor instead.
func (State) EnumDescriptor() ([]byte, []int) {
	return file_determined_experiment_v1_experiment_proto_rawDescGZIP(), []int{0}
}

// ExperimentTrial is trial-level data that is surfaced to the experiment
// level.
type ExperimentTrial struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// the searcher metric value associated with the best_validation_id for the
	// trial.
	SearcherMetricValue *float64 `protobuf:"fixed64,1,opt,name=searcher_metric_value,json=searcherMetricValue,proto3,oneof" json:"searcher_metric_value,omitempty"`
}

func (x *ExperimentTrial) Reset() {
	*x = ExperimentTrial{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_experiment_v1_experiment_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExperimentTrial) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExperimentTrial) ProtoMessage() {}

func (x *ExperimentTrial) ProtoReflect() protoreflect.Message {
	mi := &file_determined_experiment_v1_experiment_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExperimentTrial.ProtoReflect.Descriptor instead.
func (*ExperimentTrial) Descriptor() ([]byte, []int) {
	return file_determined_experiment_v1_experiment_proto_rawDescGZIP(), []int{0}
}

func (x *ExperimentTrial) GetSearcherMetricValue() float64 {
	if x != nil && x.SearcherMetricValue != nil {
		return *x.SearcherMetricValue
	}
	return 0
}

// Experiment is a collection of one or more trials that are exploring a
// user-defined hyperparameter space.
type Experiment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the experiment.
	Id int32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// The description of the experiment.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Labels attached to the experiment.
	Labels []string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty"`
	// The time the experiment was started.
	StartTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time the experiment ended if the experiment is stopped.
	EndTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The current state of the experiment.
	State State `protobuf:"varint,6,opt,name=state,proto3,enum=determined.experiment.v1.State" json:"state,omitempty"`
	// Boolean denoting whether the experiment was archived.
	Archived bool `protobuf:"varint,7,opt,name=archived,proto3" json:"archived,omitempty"`
	// The number of trials linked to the experiment.
	NumTrials int32 `protobuf:"varint,8,opt,name=num_trials,json=numTrials,proto3" json:"num_trials,omitempty"`
	// The ids of trials linked to the experiment.
	TrialIds []int32 `protobuf:"varint,20,rep,packed,name=trial_ids,json=trialIds,proto3" json:"trial_ids,omitempty"`
	// The display name of the user that created the experiment.
	DisplayName string `protobuf:"bytes,18,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The id of the user that created the experiment.
	UserId int32 `protobuf:"varint,19,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// The username of the user that created the experiment.
	Username string `protobuf:"bytes,10,opt,name=username,proto3" json:"username,omitempty"`
	// The resource pool the experiment was created in
	ResourcePool string `protobuf:"bytes,11,opt,name=resource_pool,json=resourcePool,proto3" json:"resource_pool,omitempty"`
	// The type of searcher for the experiment
	SearcherType string `protobuf:"bytes,12,opt,name=searcher_type,json=searcherType,proto3" json:"searcher_type,omitempty"`
	// The searcher metric name for the experiment
	SearcherMetric string `protobuf:"bytes,42,opt,name=searcher_metric,json=searcherMetric,proto3" json:"searcher_metric,omitempty"`
	// The hyperparameters for the experiment
	Hyperparameters *_struct.Struct `protobuf:"bytes,46,opt,name=hyperparameters,proto3" json:"hyperparameters,omitempty"`
	// The experiment name.
	Name string `protobuf:"bytes,13,opt,name=name,proto3" json:"name,omitempty"`
	// The experiment notes.
	Notes string `protobuf:"bytes,14,opt,name=notes,proto3" json:"notes,omitempty"`
	// Associated job's id.
	JobId string `protobuf:"bytes,15,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// Original id of a forked or continued experiment.
	ForkedFrom *wrappers.Int32Value `protobuf:"bytes,16,opt,name=forked_from,json=forkedFrom,proto3" json:"forked_from,omitempty"`
	// The current progress of a running experiment.
	Progress *wrappers.DoubleValue `protobuf:"bytes,17,opt,name=progress,proto3" json:"progress,omitempty"`
	// The id of the project associated with this experiment.
	ProjectId int32 `protobuf:"varint,21,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The name of the project associated with this experiment.
	ProjectName string `protobuf:"bytes,22,opt,name=project_name,json=projectName,proto3" json:"project_name,omitempty"`
	// The id of the workspace associated with this experiment.
	WorkspaceId int32 `protobuf:"varint,23,opt,name=workspace_id,json=workspaceId,proto3" json:"workspace_id,omitempty"`
	// The name of the workspace associated with this experiment.
	WorkspaceName string `protobuf:"bytes,24,opt,name=workspace_name,json=workspaceName,proto3" json:"workspace_name,omitempty"`
	// The archived status of the parent project (can be inherited from
	// workspace).
	ParentArchived bool `protobuf:"varint,25,opt,name=parent_archived,json=parentArchived,proto3" json:"parent_archived,omitempty"`
	// The configuration of the experiment.
	// Is deprecated for performance reasons on the listing experiment route.
	// Use GetExperimentResponse.config instead.
	//
	// Deprecated: Do not use.
	Config *_struct.Struct `protobuf:"bytes,26,opt,name=config,proto3" json:"config,omitempty"`
	// The original configuration that the user submitted.
	OriginalConfig string `protobuf:"bytes,27,opt,name=original_config,json=originalConfig,proto3" json:"original_config,omitempty"`
	// The id of the user who created the parent project.
	ProjectOwnerId int32 `protobuf:"varint,28,opt,name=project_owner_id,json=projectOwnerId,proto3" json:"project_owner_id,omitempty"`
	// The total size of checkpoints.
	CheckpointSize int64 `protobuf:"varint,29,opt,name=checkpoint_size,json=checkpointSize,proto3" json:"checkpoint_size,omitempty"`
	// The count of checkpoints.
	CheckpointCount int32 `protobuf:"varint,30,opt,name=checkpoint_count,json=checkpointCount,proto3" json:"checkpoint_count,omitempty"`
	// The metrics and hyperparameters associated with the best trial by searcher
	// metric.
	BestTrialSearcherMetric *float64 `protobuf:"fixed64,31,opt,name=best_trial_searcher_metric,json=bestTrialSearcherMetric,proto3,oneof" json:"best_trial_searcher_metric,omitempty"`
	// Id of experiment's best trial, calculated by the best searcher metrics
	// value of trial's best validation.
	BestTrialId *int32 `protobuf:"varint,32,opt,name=best_trial_id,json=bestTrialId,proto3,oneof" json:"best_trial_id,omitempty"`
	// Unmanaged experiments are detached.
	Unmanaged bool `protobuf:"varint,40,opt,name=unmanaged,proto3" json:"unmanaged,omitempty"`
	// Time in seconds which experiment ran or has been running.
	Duration *int32 `protobuf:"varint,41,opt,name=duration,proto3,oneof" json:"duration,omitempty"`
	// The id of external experiment
	ExternalExperimentId *string `protobuf:"bytes,43,opt,name=external_experiment_id,json=externalExperimentId,proto3,oneof" json:"external_experiment_id,omitempty"`
	// The id of external trial
	ExternalTrialId *string `protobuf:"bytes,44,opt,name=external_trial_id,json=externalTrialId,proto3,oneof" json:"external_trial_id,omitempty"`
	// Size of model definition file, for unmanaged experiments this should be 0.
	ModelDefinitionSize *int32 `protobuf:"varint,45,opt,name=model_definition_size,json=modelDefinitionSize,proto3,oneof" json:"model_definition_size,omitempty"`
	// The experiment pachyderm integration config.
	PachydermIntegration *_struct.Struct `protobuf:"bytes,47,opt,name=pachyderm_integration,json=pachydermIntegration,proto3,oneof" json:"pachyderm_integration,omitempty"`
}

func (x *Experiment) Reset() {
	*x = Experiment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_experiment_v1_experiment_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Experiment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Experiment) ProtoMessage() {}

func (x *Experiment) ProtoReflect() protoreflect.Message {
	mi := &file_determined_experiment_v1_experiment_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Experiment.ProtoReflect.Descriptor instead.
func (*Experiment) Descriptor() ([]byte, []int) {
	return file_determined_experiment_v1_experiment_proto_rawDescGZIP(), []int{1}
}

func (x *Experiment) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Experiment) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Experiment) GetLabels() []string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Experiment) GetStartTime() *timestamp.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Experiment) GetEndTime() *timestamp.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Experiment) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STATE_UNSPECIFIED
}

func (x *Experiment) GetArchived() bool {
	if x != nil {
		return x.Archived
	}
	return false
}

func (x *Experiment) GetNumTrials() int32 {
	if x != nil {
		return x.NumTrials
	}
	return 0
}

func (x *Experiment) GetTrialIds() []int32 {
	if x != nil {
		return x.TrialIds
	}
	return nil
}

func (x *Experiment) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Experiment) GetUserId() int32 {
	if x != nil {
		return x.UserId
	}
	return 0
}

func (x *Experiment) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *Experiment) GetResourcePool() string {
	if x != nil {
		return x.ResourcePool
	}
	return ""
}

func (x *Experiment) GetSearcherType() string {
	if x != nil {
		return x.SearcherType
	}
	return ""
}

func (x *Experiment) GetSearcherMetric() string {
	if x != nil {
		return x.SearcherMetric
	}
	return ""
}

func (x *Experiment) GetHyperparameters() *_struct.Struct {
	if x != nil {
		return x.Hyperparameters
	}
	return nil
}

func (x *Experiment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Experiment) GetNotes() string {
	if x != nil {
		return x.Notes
	}
	return ""
}

func (x *Experiment) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

func (x *Experiment) GetForkedFrom() *wrappers.Int32Value {
	if x != nil {
		return x.ForkedFrom
	}
	return nil
}

func (x *Experiment) GetProgress() *wrappers.DoubleValue {
	if x != nil {
		return x.Progress
	}
	return nil
}

func (x *Experiment) GetProjectId() int32 {
	if x != nil {
		return x.ProjectId
	}
	return 0
}

func (x *Experiment) GetProjectName() string {
	if x != nil {
		return x.ProjectName
	}
	return ""
}

func (x *Experiment) GetWorkspaceId() int32 {
	if x != nil {
		return x.WorkspaceId
	}
	return 0
}

func (x *Experiment) GetWorkspaceName() string {
	if x != nil {
		return x.WorkspaceName
	}
	return ""
}

func (x *Experiment) GetParentArchived() bool {
	if x != nil {
		return x.ParentArchived
	}
	return false
}

// Deprecated: Do not use.
func (x *Experiment) GetConfig() *_struct.Struct {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Experiment) GetOriginalConfig() string {
	if x != nil {
		return x.OriginalConfig
	}
	return ""
}

func (x *Experiment) GetProjectOwnerId() int32 {
	if x != nil {
		return x.ProjectOwnerId
	}
	return 0
}

func (x *Experiment) GetCheckpointSize() int64 {
	if x != nil {
		return x.CheckpointSize
	}
	return 0
}

func (x *Experiment) GetCheckpointCount() int32 {
	if x != nil {
		return x.CheckpointCount
	}
	return 0
}

func (x *Experiment) GetBestTrialSearcherMetric() float64 {
	if x != nil && x.BestTrialSearcherMetric != nil {
		return *x.BestTrialSearcherMetric
	}
	return 0
}

func (x *Experiment) GetBestTrialId() int32 {
	if x != nil && x.BestTrialId != nil {
		return *x.BestTrialId
	}
	return 0
}

func (x *Experiment) GetUnmanaged() bool {
	if x != nil {
		return x.Unmanaged
	}
	return false
}

func (x *Experiment) GetDuration() int32 {
	if x != nil && x.Duration != nil {
		return *x.Duration
	}
	return 0
}

func (x *Experiment) GetExternalExperimentId() string {
	if x != nil && x.ExternalExperimentId != nil {
		return *x.ExternalExperimentId
	}
	return ""
}

func (x *Experiment) GetExternalTrialId() string {
	if x != nil && x.ExternalTrialId != nil {
		return *x.ExternalTrialId
	}
	return ""
}

func (x *Experiment) GetModelDefinitionSize() int32 {
	if x != nil && x.ModelDefinitionSize != nil {
		return *x.ModelDefinitionSize
	}
	return 0
}

func (x *Experiment) GetPachydermIntegration() *_struct.Struct {
	if x != nil {
		return x.PachydermIntegration
	}
	return nil
}

// PatchExperiment is a partial update to an experiment with only id required.
type PatchExperiment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the experiment.
	Id int32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// The description of the experiment.
	Description *wrappers.StringValue `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Labels attached to the experiment.
	Labels *_struct.ListValue `protobuf:"bytes,3,opt,name=labels,proto3" json:"labels,omitempty"`
	// The experiment name.
	Name *wrappers.StringValue `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// The experiment notes.
	Notes *wrappers.StringValue `protobuf:"bytes,5,opt,name=notes,proto3" json:"notes,omitempty"`
	// Experiment config resources.
	Resources *PatchExperiment_PatchResources `protobuf:"bytes,6,opt,name=resources,proto3,oneof" json:"resources,omitempty"`
	// Experiment config checkpoint_storage.
	CheckpointStorage *PatchExperiment_PatchCheckpointStorage `protobuf:"bytes,7,opt,name=checkpoint_storage,json=checkpointStorage,proto3,oneof" json:"checkpoint_storage,omitempty"`
}

func (x *PatchExperiment) Reset() {
	*x = PatchExperiment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_experiment_v1_experiment_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchExperiment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchExperiment) ProtoMessage() {}

func (x *PatchExperiment) ProtoReflect() protoreflect.Message {
	mi := &file_determined_experiment_v1_experiment_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchExperiment.ProtoReflect.Descriptor instead.
func (*PatchExperiment) Descriptor() ([]byte, []int) {
	return file_determined_experiment_v1_experiment_proto_rawDescGZIP(), []int{2}
}

func (x *PatchExperiment) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *PatchExperiment) GetDescription() *wrappers.StringValue {
	if x != nil {
		return x.Description
	}
	return nil
}

func (x *PatchExperiment) GetLabels() *_struct.ListValue {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *PatchExperiment) GetName() *wrappers.StringValue {
	if x != nil {
		return x.Name
	}
	return nil
}

func (x *PatchExperiment) GetNotes() *wrappers.StringValue {
	if x != nil {
		return x.Notes
	}
	return nil
}

func (x *PatchExperiment) GetResources() *PatchExperiment_PatchResources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *PatchExperiment) GetCheckpointStorage() *PatchExperiment_PatchCheckpointStorage {
	if x != nil {
		return x.CheckpointStorage
	}
	return nil
}

// ValidationHistoryEntry is a single entry for a validation history for an
// experiment.
type ValidationHistoryEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id for the trial associated with this validation entry.
	TrialId int32 `protobuf:"varint,1,opt,name=trial_id,json=trialId,proto3" json:"trial_id,omitempty"`
	// The time at which the completed validation was reported.
	EndTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The value of the `searcher.metric`, indicated by the experiment config, for
	// the validation.
	SearcherMetric float32 `protobuf:"fixed32,3,opt,name=searcher_metric,json=searcherMetric,proto3" json:"searcher_metric,omitempty"`
}

func (x *ValidationHistoryEntry) Reset() {
	*x = ValidationHistoryEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_experiment_v1_experiment_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidationHistoryEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidationHistoryEntry) ProtoMessage() {}

func (x *ValidationHistoryEntry) ProtoReflect() protoreflect.Message {
	mi := &file_determined_experiment_v1_experiment_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidationHistoryEntry.ProtoReflect.Descriptor instead.
func (*ValidationHistoryEntry) Descriptor() ([]byte, []int) {
	return file_determined_experiment_v1_experiment_proto_rawDescGZIP(), []int{3}
}

func (x *ValidationHistoryEntry) GetTrialId() int32 {
	if x != nil {
		return x.TrialId
	}
	return 0
}

func (x *ValidationHistoryEntry) GetEndTime() *timestamp.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *ValidationHistoryEntry) GetSearcherMetric() float32 {
	if x != nil {
		return x.SearcherMetric
	}
	return 0
}

// File node is one node of file in experiment model definition file tree.
type FileNode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Path of file.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// Name of file.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Modification time of file.
	ModifiedTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=modified_time,json=modifiedTime,proto3" json:"modified_time,omitempty"`
	// Number of bytes in file content.
	ContentLength int32 `protobuf:"varint,4,opt,name=content_length,json=contentLength,proto3" json:"content_length,omitempty"`
	// Is this a directory.
	IsDir bool `protobuf:"varint,5,opt,name=is_dir,json=isDir,proto3" json:"is_dir,omitempty"`
	// MIME type of file.
	ContentType string `protobuf:"bytes,6,opt,name=content_type,json=contentType,proto3" json:"content_type,omitempty"`
	// Subdirectory files.
	Files []*FileNode `protobuf:"bytes,7,rep,name=files,proto3" json:"files,omitempty"`
}

func (x *FileNode) Reset() {
	*x = FileNode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_experiment_v1_experiment_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FileNode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileNode) ProtoMessage() {}

func (x *FileNode) ProtoReflect() protoreflect.Message {
	mi := &file_determined_experiment_v1_experiment_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileNode.ProtoReflect.Descriptor instead.
func (*FileNode) Descriptor() ([]byte, []int) {
	return file_determined_experiment_v1_experiment_proto_rawDescGZIP(), []int{4}
}

func (x *FileNode) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *FileNode) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FileNode) GetModifiedTime() *timestamp.Timestamp {
	if x != nil {
		return x.ModifiedTime
	}
	return nil
}

func (x *FileNode) GetContentLength() int32 {
	if x != nil {
		return x.ContentLength
	}
	return 0
}

func (x *FileNode) GetIsDir() bool {
	if x != nil {
		return x.IsDir
	}
	return false
}

func (x *FileNode) GetContentType() string {
	if x != nil {
		return x.ContentType
	}
	return ""
}

func (x *FileNode) GetFiles() []*FileNode {
	if x != nil {
		return x.Files
	}
	return nil
}

// Nested object for resources field patch.
type PatchExperiment_PatchResources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Experiment config resources.max_slots.
	MaxSlots *int32 `protobuf:"varint,1,opt,name=max_slots,json=maxSlots,proto3,oneof" json:"max_slots,omitempty"`
	// Experiment config resources.weight.
	Weight *float64 `protobuf:"fixed64,2,opt,name=weight,proto3,oneof" json:"weight,omitempty"`
	// Experiment config resources.priority.
	Priority *int32 `protobuf:"varint,3,opt,name=priority,proto3,oneof" json:"priority,omitempty"`
}

func (x *PatchExperiment_PatchResources) Reset() {
	*x = PatchExperiment_PatchResources{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_experiment_v1_experiment_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchExperiment_PatchResources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchExperiment_PatchResources) ProtoMessage() {}

func (x *PatchExperiment_PatchResources) ProtoReflect() protoreflect.Message {
	mi := &file_determined_experiment_v1_experiment_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchExperiment_PatchResources.ProtoReflect.Descriptor instead.
func (*PatchExperiment_PatchResources) Descriptor() ([]byte, []int) {
	return file_determined_experiment_v1_experiment_proto_rawDescGZIP(), []int{2, 0}
}

func (x *PatchExperiment_PatchResources) GetMaxSlots() int32 {
	if x != nil && x.MaxSlots != nil {
		return *x.MaxSlots
	}
	return 0
}

func (x *PatchExperiment_PatchResources) GetWeight() float64 {
	if x != nil && x.Weight != nil {
		return *x.Weight
	}
	return 0
}

func (x *PatchExperiment_PatchResources) GetPriority() int32 {
	if x != nil && x.Priority != nil {
		return *x.Priority
	}
	return 0
}

// Nested object for checkpoint_storage field patch.
type PatchExperiment_PatchCheckpointStorage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Experiment config checkpoint_storage.save_experiment_best.
	SaveExperimentBest int32 `protobuf:"varint,1,opt,name=save_experiment_best,json=saveExperimentBest,proto3" json:"save_experiment_best,omitempty"`
	// Experiment config checkpoint_storage.save_trial_best.
	SaveTrialBest int32 `protobuf:"varint,2,opt,name=save_trial_best,json=saveTrialBest,proto3" json:"save_trial_best,omitempty"`
	// Experiment config checkpoint_storage.save_trial_latest.
	SaveTrialLatest int32 `protobuf:"varint,3,opt,name=save_trial_latest,json=saveTrialLatest,proto3" json:"save_trial_latest,omitempty"`
}

func (x *PatchExperiment_PatchCheckpointStorage) Reset() {
	*x = PatchExperiment_PatchCheckpointStorage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_experiment_v1_experiment_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchExperiment_PatchCheckpointStorage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchExperiment_PatchCheckpointStorage) ProtoMessage() {}

func (x *PatchExperiment_PatchCheckpointStorage) ProtoReflect() protoreflect.Message {
	mi := &file_determined_experiment_v1_experiment_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchExperiment_PatchCheckpointStorage.ProtoReflect.Descriptor instead.
func (*PatchExperiment_PatchCheckpointStorage) Descriptor() ([]byte, []int) {
	return file_determined_experiment_v1_experiment_proto_rawDescGZIP(), []int{2, 1}
}

func (x *PatchExperiment_PatchCheckpointStorage) GetSaveExperimentBest() int32 {
	if x != nil {
		return x.SaveExperimentBest
	}
	return 0
}

func (x *PatchExperiment_PatchCheckpointStorage) GetSaveTrialBest() int32 {
	if x != nil {
		return x.SaveTrialBest
	}
	return 0
}

func (x *PatchExperiment_PatchCheckpointStorage) GetSaveTrialLatest() int32 {
	if x != nil {
		return x.SaveTrialLatest
	}
	return 0
}

var File_determined_experiment_v1_experiment_proto protoreflect.FileDescriptor

var file_determined_experiment_v1_experiment_proto_rawDesc = []byte{
	0x0a, 0x29, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x65, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x64, 0x65, 0x74,
	0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e,
	0x2d, 0x73, 0x77, 0x61, 0x67, 0x67, 0x65, 0x72, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x64, 0x0a, 0x0f, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x54, 0x72, 0x69, 0x61, 0x6c, 0x12, 0x37, 0x0a, 0x15, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65,
	0x72, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x13, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65, 0x72,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x88, 0x01, 0x01, 0x42, 0x18,
	0x0a, 0x16, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65, 0x72, 0x5f, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x96, 0x0f, 0x0a, 0x0a, 0x45, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x02, 0x69, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e,
	0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x61, 0x72,
	0x63, 0x68, 0x69, 0x76, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x61, 0x72,
	0x63, 0x68, 0x69, 0x76, 0x65, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x75, 0x6d, 0x5f, 0x74, 0x72,
	0x69, 0x61, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x6e, 0x75, 0x6d, 0x54,
	0x72, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69,
	0x64, 0x73, 0x18, 0x14, 0x20, 0x03, 0x28, 0x05, 0x52, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x49,
	0x64, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x13, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1a,
	0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12,
	0x23, 0x0a, 0x0d, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65, 0x72,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65, 0x72,
	0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x2a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x41, 0x0a,
	0x0f, 0x68, 0x79, 0x70, 0x65, 0x72, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x18, 0x2e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52,
	0x0f, 0x68, 0x79, 0x70, 0x65, 0x72, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x12, 0x15, 0x0a, 0x06, 0x6a, 0x6f,
	0x62, 0x5f, 0x69, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49,
	0x64, 0x12, 0x3c, 0x0a, 0x0b, 0x66, 0x6f, 0x72, 0x6b, 0x65, 0x64, 0x5f, 0x66, 0x72, 0x6f, 0x6d,
	0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x0a, 0x66, 0x6f, 0x72, 0x6b, 0x65, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x12,
	0x38, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x15, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x17, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x49, 0x64, 0x12, 0x25,
	0x0a, 0x0e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x18, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f,
	0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x64, 0x18, 0x19, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x64, 0x12, 0x33,
	0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x02, 0x18, 0x01, 0x52, 0x06, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f, 0x72,
	0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x28, 0x0a, 0x10,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x1c, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x4f,
	0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0e, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x29, 0x0a, 0x10, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x63, 0x68, 0x65, 0x63, 0x6b,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x1a, 0x62, 0x65,
	0x73, 0x74, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65,
	0x72, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00,
	0x52, 0x17, 0x62, 0x65, 0x73, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x88, 0x01, 0x01, 0x12, 0x27, 0x0a, 0x0d,
	0x62, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x20, 0x20,
	0x01, 0x28, 0x05, 0x48, 0x01, 0x52, 0x0b, 0x62, 0x65, 0x73, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c,
	0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x1c, 0x0a, 0x09, 0x75, 0x6e, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x64, 0x18, 0x28, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x75, 0x6e, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x64, 0x12, 0x1f, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x29, 0x20, 0x01, 0x28, 0x05, 0x48, 0x02, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x88, 0x01, 0x01, 0x12, 0x39, 0x0a, 0x16, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x2b,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x03, 0x52, 0x14, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12,
	0x2f, 0x0a, 0x11, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x74, 0x72, 0x69, 0x61,
	0x6c, 0x5f, 0x69, 0x64, 0x18, 0x2c, 0x20, 0x01, 0x28, 0x09, 0x48, 0x04, 0x52, 0x0f, 0x65, 0x78,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x49, 0x64, 0x88, 0x01, 0x01,
	0x12, 0x37, 0x0a, 0x15, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x2d, 0x20, 0x01, 0x28, 0x05, 0x48,
	0x05, 0x52, 0x13, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x69, 0x7a, 0x65, 0x88, 0x01, 0x01, 0x12, 0x51, 0x0a, 0x15, 0x70, 0x61, 0x63,
	0x68, 0x79, 0x64, 0x65, 0x72, 0x6d, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x2f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x48, 0x06, 0x52, 0x14, 0x70, 0x61, 0x63, 0x68, 0x79, 0x64, 0x65, 0x72, 0x6d, 0x49, 0x6e,
	0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x3a, 0x9f, 0x01, 0x92,
	0x41, 0x9b, 0x01, 0x0a, 0x98, 0x01, 0xd2, 0x01, 0x02, 0x69, 0x64, 0xd2, 0x01, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0xd2, 0x01, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0xd2,
	0x01, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0xd2, 0x01, 0x08, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76,
	0x65, 0x64, 0xd2, 0x01, 0x0a, 0x6e, 0x75, 0x6d, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0xd2,
	0x01, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0xd2, 0x01, 0x06, 0x6a, 0x6f, 0x62,
	0x5f, 0x69, 0x64, 0xd2, 0x01, 0x0d, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65, 0x72, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0xd2, 0x01, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0xd2, 0x01, 0x0f, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0xd2, 0x01, 0x10, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6f, 0x77, 0x6e,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x1d,
	0x0a, 0x1b, 0x5f, 0x62, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x65, 0x72, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x42, 0x10, 0x0a,
	0x0e, 0x5f, 0x62, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x42,
	0x0b, 0x0a, 0x09, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x19, 0x0a, 0x17,
	0x5f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x65, 0x78, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x42, 0x18, 0x0a,
	0x16, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x70, 0x61, 0x63, 0x68,
	0x79, 0x64, 0x65, 0x72, 0x6d, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0xb9, 0x06, 0x0a, 0x0f, 0x50, 0x61, 0x74, 0x63, 0x68, 0x45, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x02, 0x69, 0x64, 0x12, 0x3e, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x30, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x32, 0x0a, 0x05, 0x6e,
	0x6f, 0x74, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x12,
	0x5b, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x38, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e,
	0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61,
	0x74, 0x63, 0x68, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61,
	0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x48, 0x00, 0x52, 0x09,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x74, 0x0a, 0x12,
	0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72,
	0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x48, 0x01, 0x52, 0x11, 0x63, 0x68,
	0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x88,
	0x01, 0x01, 0x1a, 0x96, 0x01, 0x0a, 0x0e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x6c, 0x6f,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x53,
	0x6c, 0x6f, 0x74, 0x73, 0x88, 0x01, 0x01, 0x12, 0x1b, 0x0a, 0x06, 0x77, 0x65, 0x69, 0x67, 0x68,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x48, 0x01, 0x52, 0x06, 0x77, 0x65, 0x69, 0x67, 0x68,
	0x74, 0x88, 0x01, 0x01, 0x12, 0x1f, 0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x48, 0x02, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x88, 0x01, 0x01, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x6c,
	0x6f, 0x74, 0x73, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x42, 0x0b,
	0x0a, 0x09, 0x5f, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x1a, 0x9e, 0x01, 0x0a, 0x16,
	0x50, 0x61, 0x74, 0x63, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x73, 0x61, 0x76, 0x65, 0x5f, 0x65,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x62, 0x65, 0x73, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x12, 0x73, 0x61, 0x76, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x42, 0x65, 0x73, 0x74, 0x12, 0x26, 0x0a, 0x0f, 0x73, 0x61, 0x76, 0x65,
	0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x62, 0x65, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0d, 0x73, 0x61, 0x76, 0x65, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x42, 0x65, 0x73, 0x74,
	0x12, 0x2a, 0x0a, 0x11, 0x73, 0x61, 0x76, 0x65, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x6c,
	0x61, 0x74, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x73, 0x61, 0x76,
	0x65, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x4c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x3a, 0x0a, 0x92, 0x41,
	0x07, 0x0a, 0x05, 0xd2, 0x01, 0x02, 0x69, 0x64, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x22, 0xc2, 0x01,
	0x0a, 0x16, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x69, 0x73, 0x74,
	0x6f, 0x72, 0x79, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x69, 0x61,
	0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x74, 0x72, 0x69, 0x61,
	0x6c, 0x49, 0x64, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x65, 0x72, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x02, 0x52, 0x0e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65, 0x72, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x3a, 0x2d, 0x92, 0x41, 0x2a, 0x0a, 0x28, 0xd2, 0x01, 0x08, 0x74, 0x72, 0x69,
	0x61, 0x6c, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0xd2, 0x01, 0x0f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65, 0x72, 0x5f, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x22, 0x8e, 0x02, 0x0a, 0x08, 0x46, 0x69, 0x6c, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70,
	0x61, 0x74, 0x68, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x0d, 0x6d, 0x6f, 0x64, 0x69, 0x66,
	0x69, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x6d, 0x6f, 0x64, 0x69,
	0x66, 0x69, 0x65, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12,
	0x15, 0x0a, 0x06, 0x69, 0x73, 0x5f, 0x64, 0x69, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x05, 0x69, 0x73, 0x44, 0x69, 0x72, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x38, 0x0a, 0x05, 0x66, 0x69, 0x6c,
	0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72,
	0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x05, 0x66, 0x69,
	0x6c, 0x65, 0x73, 0x2a, 0xf8, 0x02, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a,
	0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x41, 0x43,
	0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x50, 0x41, 0x55, 0x53, 0x45, 0x44, 0x10, 0x02, 0x12, 0x1c, 0x0a, 0x18, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x4c,
	0x45, 0x54, 0x45, 0x44, 0x10, 0x03, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x53, 0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x5f, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x45,
	0x44, 0x10, 0x04, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x54, 0x4f,
	0x50, 0x50, 0x49, 0x4e, 0x47, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x05, 0x12, 0x13, 0x0a,
	0x0f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x45, 0x44,
	0x10, 0x06, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x43, 0x41, 0x4e, 0x43,
	0x45, 0x4c, 0x45, 0x44, 0x10, 0x07, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x08, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x09, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x0a, 0x12, 0x17,
	0x0a, 0x13, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x46,
	0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x0b, 0x12, 0x19, 0x0a, 0x15, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x5f, 0x4b, 0x49, 0x4c, 0x4c, 0x45, 0x44,
	0x10, 0x0c, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x51, 0x55, 0x45, 0x55,
	0x45, 0x44, 0x10, 0x0d, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x50, 0x55,
	0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x0e, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x0f, 0x12, 0x11, 0x0a, 0x0d, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x10, 0x42, 0x3c,
	0x5a, 0x3a, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x64, 0x65, 0x74,
	0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2d, 0x61, 0x69, 0x2f, 0x64, 0x65, 0x74, 0x65, 0x72,
	0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x70, 0x6b, 0x67, 0x2f,
	0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x76, 0x31, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_determined_experiment_v1_experiment_proto_rawDescOnce sync.Once
	file_determined_experiment_v1_experiment_proto_rawDescData = file_determined_experiment_v1_experiment_proto_rawDesc
)

func file_determined_experiment_v1_experiment_proto_rawDescGZIP() []byte {
	file_determined_experiment_v1_experiment_proto_rawDescOnce.Do(func() {
		file_determined_experiment_v1_experiment_proto_rawDescData = protoimpl.X.CompressGZIP(file_determined_experiment_v1_experiment_proto_rawDescData)
	})
	return file_determined_experiment_v1_experiment_proto_rawDescData
}

var file_determined_experiment_v1_experiment_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_determined_experiment_v1_experiment_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_determined_experiment_v1_experiment_proto_goTypes = []interface{}{
	(State)(0),                                     // 0: determined.experiment.v1.State
	(*ExperimentTrial)(nil),                        // 1: determined.experiment.v1.ExperimentTrial
	(*Experiment)(nil),                             // 2: determined.experiment.v1.Experiment
	(*PatchExperiment)(nil),                        // 3: determined.experiment.v1.PatchExperiment
	(*ValidationHistoryEntry)(nil),                 // 4: determined.experiment.v1.ValidationHistoryEntry
	(*FileNode)(nil),                               // 5: determined.experiment.v1.FileNode
	(*PatchExperiment_PatchResources)(nil),         // 6: determined.experiment.v1.PatchExperiment.PatchResources
	(*PatchExperiment_PatchCheckpointStorage)(nil), // 7: determined.experiment.v1.PatchExperiment.PatchCheckpointStorage
	(*timestamp.Timestamp)(nil),                    // 8: google.protobuf.Timestamp
	(*_struct.Struct)(nil),                         // 9: google.protobuf.Struct
	(*wrappers.Int32Value)(nil),                    // 10: google.protobuf.Int32Value
	(*wrappers.DoubleValue)(nil),                   // 11: google.protobuf.DoubleValue
	(*wrappers.StringValue)(nil),                   // 12: google.protobuf.StringValue
	(*_struct.ListValue)(nil),                      // 13: google.protobuf.ListValue
}
var file_determined_experiment_v1_experiment_proto_depIdxs = []int32{
	8,  // 0: determined.experiment.v1.Experiment.start_time:type_name -> google.protobuf.Timestamp
	8,  // 1: determined.experiment.v1.Experiment.end_time:type_name -> google.protobuf.Timestamp
	0,  // 2: determined.experiment.v1.Experiment.state:type_name -> determined.experiment.v1.State
	9,  // 3: determined.experiment.v1.Experiment.hyperparameters:type_name -> google.protobuf.Struct
	10, // 4: determined.experiment.v1.Experiment.forked_from:type_name -> google.protobuf.Int32Value
	11, // 5: determined.experiment.v1.Experiment.progress:type_name -> google.protobuf.DoubleValue
	9,  // 6: determined.experiment.v1.Experiment.config:type_name -> google.protobuf.Struct
	9,  // 7: determined.experiment.v1.Experiment.pachyderm_integration:type_name -> google.protobuf.Struct
	12, // 8: determined.experiment.v1.PatchExperiment.description:type_name -> google.protobuf.StringValue
	13, // 9: determined.experiment.v1.PatchExperiment.labels:type_name -> google.protobuf.ListValue
	12, // 10: determined.experiment.v1.PatchExperiment.name:type_name -> google.protobuf.StringValue
	12, // 11: determined.experiment.v1.PatchExperiment.notes:type_name -> google.protobuf.StringValue
	6,  // 12: determined.experiment.v1.PatchExperiment.resources:type_name -> determined.experiment.v1.PatchExperiment.PatchResources
	7,  // 13: determined.experiment.v1.PatchExperiment.checkpoint_storage:type_name -> determined.experiment.v1.PatchExperiment.PatchCheckpointStorage
	8,  // 14: determined.experiment.v1.ValidationHistoryEntry.end_time:type_name -> google.protobuf.Timestamp
	8,  // 15: determined.experiment.v1.FileNode.modified_time:type_name -> google.protobuf.Timestamp
	5,  // 16: determined.experiment.v1.FileNode.files:type_name -> determined.experiment.v1.FileNode
	17, // [17:17] is the sub-list for method output_type
	17, // [17:17] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_determined_experiment_v1_experiment_proto_init() }
func file_determined_experiment_v1_experiment_proto_init() {
	if File_determined_experiment_v1_experiment_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_determined_experiment_v1_experiment_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExperimentTrial); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_experiment_v1_experiment_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Experiment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_experiment_v1_experiment_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchExperiment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_experiment_v1_experiment_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValidationHistoryEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_experiment_v1_experiment_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FileNode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_experiment_v1_experiment_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchExperiment_PatchResources); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_experiment_v1_experiment_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchExperiment_PatchCheckpointStorage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_determined_experiment_v1_experiment_proto_msgTypes[0].OneofWrappers = []interface{}{}
	file_determined_experiment_v1_experiment_proto_msgTypes[1].OneofWrappers = []interface{}{}
	file_determined_experiment_v1_experiment_proto_msgTypes[2].OneofWrappers = []interface{}{}
	file_determined_experiment_v1_experiment_proto_msgTypes[5].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_determined_experiment_v1_experiment_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_determined_experiment_v1_experiment_proto_goTypes,
		DependencyIndexes: file_determined_experiment_v1_experiment_proto_depIdxs,
		EnumInfos:         file_determined_experiment_v1_experiment_proto_enumTypes,
		MessageInfos:      file_determined_experiment_v1_experiment_proto_msgTypes,
	}.Build()
	File_determined_experiment_v1_experiment_proto = out.File
	file_determined_experiment_v1_experiment_proto_rawDesc = nil
	file_determined_experiment_v1_experiment_proto_goTypes = nil
	file_determined_experiment_v1_experiment_proto_depIdxs = nil
}
