// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// source: determined/container/v1/container.proto

package containerv1

import (
	devicev1 "github.com/determined-ai/determined/proto/pkg/devicev1"
	_ "github.com/grpc-ecosystem/grpc-gateway/protoc-gen-swagger/options"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The current state of the container.
type State int32

const (
	// The container state is unknown.
	State_STATE_UNSPECIFIED State = 0
	// The container has been assigned to an agent but has not started yet.
	State_STATE_ASSIGNED State = 1
	// The container's base image is being pulled from the Docker registry.
	State_STATE_PULLING State = 2
	// The image has been built and the container is being started, but the
	// service in the container is not ready yet.
	State_STATE_STARTING State = 3
	// The service in the container is able to accept requests.
	State_STATE_RUNNING State = 4
	// The container has completely exited or the container has been aborted prior
	// to getting assigned.
	State_STATE_TERMINATED State = 5
)

// Enum value maps for State.
var (
	State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "STATE_ASSIGNED",
		2: "STATE_PULLING",
		3: "STATE_STARTING",
		4: "STATE_RUNNING",
		5: "STATE_TERMINATED",
	}
	State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"STATE_ASSIGNED":    1,
		"STATE_PULLING":     2,
		"STATE_STARTING":    3,
		"STATE_RUNNING":     4,
		"STATE_TERMINATED":  5,
	}
)

func (x State) Enum() *State {
	p := new(State)
	*p = x
	return p
}

func (x State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (State) Descriptor() protoreflect.EnumDescriptor {
	return file_determined_container_v1_container_proto_enumTypes[0].Descriptor()
}

func (State) Type() protoreflect.EnumType {
	return &file_determined_container_v1_container_proto_enumTypes[0]
}

func (x State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use State.Descriptor instead.
func (State) EnumDescriptor() ([]byte, []int) {
	return file_determined_container_v1_container_proto_rawDescGZIP(), []int{0}
}

// Container is a Docker container that is either scheduled to run or is
// currently running on a set of slots.
type Container struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the task that is currently managing this container.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The unique id of this instance of a container.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// The current state that the container is currently in.
	State State `protobuf:"varint,3,opt,name=state,proto3,enum=determined.container.v1.State" json:"state,omitempty"`
	// A list of devices that is being used by this container.
	Devices []*devicev1.Device `protobuf:"bytes,4,rep,name=devices,proto3" json:"devices,omitempty"`
	// User has insufficient permissions to view this container's details.
	// If true, we obfuscate:
	// (1) parent
	// (2) id
	// (4) devices
	PermissionDenied bool `protobuf:"varint,5,opt,name=permission_denied,json=permissionDenied,proto3" json:"permission_denied,omitempty"`
}

func (x *Container) Reset() {
	*x = Container{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_container_v1_container_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Container) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Container) ProtoMessage() {}

func (x *Container) ProtoReflect() protoreflect.Message {
	mi := &file_determined_container_v1_container_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Container.ProtoReflect.Descriptor instead.
func (*Container) Descriptor() ([]byte, []int) {
	return file_determined_container_v1_container_proto_rawDescGZIP(), []int{0}
}

func (x *Container) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *Container) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Container) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STATE_UNSPECIFIED
}

func (x *Container) GetDevices() []*devicev1.Device {
	if x != nil {
		return x.Devices
	}
	return nil
}

func (x *Container) GetPermissionDenied() bool {
	if x != nil {
		return x.PermissionDenied
	}
	return false
}

var File_determined_container_v1_container_proto protoreflect.FileDescriptor

var file_determined_container_v1_container_proto_rawDesc = []byte{
	0x0a, 0x27, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x64, 0x65, 0x74, 0x65, 0x72,
	0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x1a, 0x21, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65,
	0x6e, 0x2d, 0x73, 0x77, 0x61, 0x67, 0x67, 0x65, 0x72, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xe2, 0x01, 0x0a, 0x09, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x34, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72,
	0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x36, 0x0a, 0x07, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x07,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x70, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x10, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x44, 0x65,
	0x6e, 0x69, 0x65, 0x64, 0x3a, 0x12, 0x92, 0x41, 0x0f, 0x0a, 0x0d, 0xd2, 0x01, 0x02, 0x69, 0x64,
	0xd2, 0x01, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2a, 0x82, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x41, 0x53, 0x53, 0x49, 0x47, 0x4e, 0x45, 0x44, 0x10, 0x01, 0x12, 0x11, 0x0a,
	0x0d, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x50, 0x55, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x02,
	0x12, 0x12, 0x0a, 0x0e, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x52, 0x55,
	0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x54, 0x45, 0x52, 0x4d, 0x49, 0x4e, 0x41, 0x54, 0x45, 0x44, 0x10, 0x05, 0x42, 0x3b, 0x5a,
	0x39, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x64, 0x65, 0x74, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2d, 0x61, 0x69, 0x2f, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d,
	0x69, 0x6e, 0x65, 0x64, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x76, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_determined_container_v1_container_proto_rawDescOnce sync.Once
	file_determined_container_v1_container_proto_rawDescData = file_determined_container_v1_container_proto_rawDesc
)

func file_determined_container_v1_container_proto_rawDescGZIP() []byte {
	file_determined_container_v1_container_proto_rawDescOnce.Do(func() {
		file_determined_container_v1_container_proto_rawDescData = protoimpl.X.CompressGZIP(file_determined_container_v1_container_proto_rawDescData)
	})
	return file_determined_container_v1_container_proto_rawDescData
}

var file_determined_container_v1_container_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_determined_container_v1_container_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_determined_container_v1_container_proto_goTypes = []interface{}{
	(State)(0),              // 0: determined.container.v1.State
	(*Container)(nil),       // 1: determined.container.v1.Container
	(*devicev1.Device)(nil), // 2: determined.device.v1.Device
}
var file_determined_container_v1_container_proto_depIdxs = []int32{
	0, // 0: determined.container.v1.Container.state:type_name -> determined.container.v1.State
	2, // 1: determined.container.v1.Container.devices:type_name -> determined.device.v1.Device
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_determined_container_v1_container_proto_init() }
func file_determined_container_v1_container_proto_init() {
	if File_determined_container_v1_container_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_determined_container_v1_container_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Container); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_determined_container_v1_container_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_determined_container_v1_container_proto_goTypes,
		DependencyIndexes: file_determined_container_v1_container_proto_depIdxs,
		EnumInfos:         file_determined_container_v1_container_proto_enumTypes,
		MessageInfos:      file_determined_container_v1_container_proto_msgTypes,
	}.Build()
	File_determined_container_v1_container_proto = out.File
	file_determined_container_v1_container_proto_rawDesc = nil
	file_determined_container_v1_container_proto_goTypes = nil
	file_determined_container_v1_container_proto_depIdxs = nil
}
