// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// source: determined/api/v1/trial.proto

package apiv1

import (
	checkpointv1 "github.com/determined-ai/determined/proto/pkg/checkpointv1"
	commonv1 "github.com/determined-ai/determined/proto/pkg/commonv1"
	experimentv1 "github.com/determined-ai/determined/proto/pkg/experimentv1"
	logv1 "github.com/determined-ai/determined/proto/pkg/logv1"
	trialv1 "github.com/determined-ai/determined/proto/pkg/trialv1"
	_struct "github.com/golang/protobuf/ptypes/struct"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "github.com/grpc-ecosystem/grpc-gateway/protoc-gen-swagger/options"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Namespace for the sort field. corresponds to the different ways
// to access in the db
type TrialSorter_Namespace int32

const (
	// Namespace for columns in the trials table
	TrialSorter_NAMESPACE_UNSPECIFIED TrialSorter_Namespace = 0
	// Namespace corrspondings to trials->hparams
	TrialSorter_NAMESPACE_HPARAMS TrialSorter_Namespace = 1
	// Namespace corrspondings to steps->avg_metrics
	TrialSorter_NAMESPACE_TRAINING_METRICS TrialSorter_Namespace = 2
	// Namespace corrspondings to validations->validation_metrics
	TrialSorter_NAMESPACE_VALIDATION_METRICS TrialSorter_Namespace = 3
)

// Enum value maps for TrialSorter_Namespace.
var (
	TrialSorter_Namespace_name = map[int32]string{
		0: "NAMESPACE_UNSPECIFIED",
		1: "NAMESPACE_HPARAMS",
		2: "NAMESPACE_TRAINING_METRICS",
		3: "NAMESPACE_VALIDATION_METRICS",
	}
	TrialSorter_Namespace_value = map[string]int32{
		"NAMESPACE_UNSPECIFIED":        0,
		"NAMESPACE_HPARAMS":            1,
		"NAMESPACE_TRAINING_METRICS":   2,
		"NAMESPACE_VALIDATION_METRICS": 3,
	}
)

func (x TrialSorter_Namespace) Enum() *TrialSorter_Namespace {
	p := new(TrialSorter_Namespace)
	*p = x
	return p
}

func (x TrialSorter_Namespace) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TrialSorter_Namespace) Descriptor() protoreflect.EnumDescriptor {
	return file_determined_api_v1_trial_proto_enumTypes[0].Descriptor()
}

func (TrialSorter_Namespace) Type() protoreflect.EnumType {
	return &file_determined_api_v1_trial_proto_enumTypes[0]
}

func (x TrialSorter_Namespace) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TrialSorter_Namespace.Descriptor instead.
func (TrialSorter_Namespace) EnumDescriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{4, 0}
}

// Sorts trials by the given field.
type GetExperimentTrialsRequest_SortBy int32

const (
	// Returns trials in an unsorted list.
	GetExperimentTrialsRequest_SORT_BY_UNSPECIFIED GetExperimentTrialsRequest_SortBy = 0
	// Returns trials sorted by id.
	GetExperimentTrialsRequest_SORT_BY_ID GetExperimentTrialsRequest_SortBy = 1
	// Return trials sorted by start time.
	GetExperimentTrialsRequest_SORT_BY_START_TIME GetExperimentTrialsRequest_SortBy = 4
	// Return trials sorted by end time. Trials without end times are
	// returned after trials that are.
	GetExperimentTrialsRequest_SORT_BY_END_TIME GetExperimentTrialsRequest_SortBy = 5
	// Return trials sorted by state.
	GetExperimentTrialsRequest_SORT_BY_STATE GetExperimentTrialsRequest_SortBy = 6
	// Return the trials sorted by the best metric so far, where the metric is
	// specified by `searcher.metric` in the experiment configuration.
	GetExperimentTrialsRequest_SORT_BY_BEST_VALIDATION_METRIC GetExperimentTrialsRequest_SortBy = 7
	// Return the trials sorted by the latest metric so far, where the metric is
	// specified by `searcher.metric` in the experiment configuration.
	GetExperimentTrialsRequest_SORT_BY_LATEST_VALIDATION_METRIC GetExperimentTrialsRequest_SortBy = 8
	// Return the trials sorted by the number of batches completed.
	GetExperimentTrialsRequest_SORT_BY_BATCHES_PROCESSED GetExperimentTrialsRequest_SortBy = 9
	// Return the trials sorted by the total duration.
	GetExperimentTrialsRequest_SORT_BY_DURATION GetExperimentTrialsRequest_SortBy = 10
	// Return the trials sorted by the number of restarts.
	GetExperimentTrialsRequest_SORT_BY_RESTARTS GetExperimentTrialsRequest_SortBy = 11
	// Return the trials sorted by checkpoint size.
	GetExperimentTrialsRequest_SORT_BY_CHECKPOINT_SIZE GetExperimentTrialsRequest_SortBy = 12
	// Return the trials sorted by number of log retention days.
	GetExperimentTrialsRequest_SORT_BY_LOG_RETENTION_DAYS GetExperimentTrialsRequest_SortBy = 13
)

// Enum value maps for GetExperimentTrialsRequest_SortBy.
var (
	GetExperimentTrialsRequest_SortBy_name = map[int32]string{
		0:  "SORT_BY_UNSPECIFIED",
		1:  "SORT_BY_ID",
		4:  "SORT_BY_START_TIME",
		5:  "SORT_BY_END_TIME",
		6:  "SORT_BY_STATE",
		7:  "SORT_BY_BEST_VALIDATION_METRIC",
		8:  "SORT_BY_LATEST_VALIDATION_METRIC",
		9:  "SORT_BY_BATCHES_PROCESSED",
		10: "SORT_BY_DURATION",
		11: "SORT_BY_RESTARTS",
		12: "SORT_BY_CHECKPOINT_SIZE",
		13: "SORT_BY_LOG_RETENTION_DAYS",
	}
	GetExperimentTrialsRequest_SortBy_value = map[string]int32{
		"SORT_BY_UNSPECIFIED":              0,
		"SORT_BY_ID":                       1,
		"SORT_BY_START_TIME":               4,
		"SORT_BY_END_TIME":                 5,
		"SORT_BY_STATE":                    6,
		"SORT_BY_BEST_VALIDATION_METRIC":   7,
		"SORT_BY_LATEST_VALIDATION_METRIC": 8,
		"SORT_BY_BATCHES_PROCESSED":        9,
		"SORT_BY_DURATION":                 10,
		"SORT_BY_RESTARTS":                 11,
		"SORT_BY_CHECKPOINT_SIZE":          12,
		"SORT_BY_LOG_RETENTION_DAYS":       13,
	}
)

func (x GetExperimentTrialsRequest_SortBy) Enum() *GetExperimentTrialsRequest_SortBy {
	p := new(GetExperimentTrialsRequest_SortBy)
	*p = x
	return p
}

func (x GetExperimentTrialsRequest_SortBy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetExperimentTrialsRequest_SortBy) Descriptor() protoreflect.EnumDescriptor {
	return file_determined_api_v1_trial_proto_enumTypes[1].Descriptor()
}

func (GetExperimentTrialsRequest_SortBy) Type() protoreflect.EnumType {
	return &file_determined_api_v1_trial_proto_enumTypes[1]
}

func (x GetExperimentTrialsRequest_SortBy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetExperimentTrialsRequest_SortBy.Descriptor instead.
func (GetExperimentTrialsRequest_SortBy) EnumDescriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{13, 0}
}

// Filter workloads with training, validation, and checkpoint information.
type GetTrialWorkloadsRequest_FilterOption int32

const (
	// Any workload.
	GetTrialWorkloadsRequest_FILTER_OPTION_UNSPECIFIED GetTrialWorkloadsRequest_FilterOption = 0
	// Only workloads with an associated checkpoint.
	GetTrialWorkloadsRequest_FILTER_OPTION_CHECKPOINT GetTrialWorkloadsRequest_FilterOption = 1
	// Only validation workloads.
	GetTrialWorkloadsRequest_FILTER_OPTION_VALIDATION GetTrialWorkloadsRequest_FilterOption = 2
	// Only validation workloads or ones with an associated checkpoint.
	GetTrialWorkloadsRequest_FILTER_OPTION_CHECKPOINT_OR_VALIDATION GetTrialWorkloadsRequest_FilterOption = 3
)

// Enum value maps for GetTrialWorkloadsRequest_FilterOption.
var (
	GetTrialWorkloadsRequest_FilterOption_name = map[int32]string{
		0: "FILTER_OPTION_UNSPECIFIED",
		1: "FILTER_OPTION_CHECKPOINT",
		2: "FILTER_OPTION_VALIDATION",
		3: "FILTER_OPTION_CHECKPOINT_OR_VALIDATION",
	}
	GetTrialWorkloadsRequest_FilterOption_value = map[string]int32{
		"FILTER_OPTION_UNSPECIFIED":              0,
		"FILTER_OPTION_CHECKPOINT":               1,
		"FILTER_OPTION_VALIDATION":               2,
		"FILTER_OPTION_CHECKPOINT_OR_VALIDATION": 3,
	}
)

func (x GetTrialWorkloadsRequest_FilterOption) Enum() *GetTrialWorkloadsRequest_FilterOption {
	p := new(GetTrialWorkloadsRequest_FilterOption)
	*p = x
	return p
}

func (x GetTrialWorkloadsRequest_FilterOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetTrialWorkloadsRequest_FilterOption) Descriptor() protoreflect.EnumDescriptor {
	return file_determined_api_v1_trial_proto_enumTypes[2].Descriptor()
}

func (GetTrialWorkloadsRequest_FilterOption) Type() protoreflect.EnumType {
	return &file_determined_api_v1_trial_proto_enumTypes[2]
}

func (x GetTrialWorkloadsRequest_FilterOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetTrialWorkloadsRequest_FilterOption.Descriptor instead.
func (GetTrialWorkloadsRequest_FilterOption) EnumDescriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{21, 0}
}

// DownsampledMetrics captures a metric's name and downsampled data points.
type DownsampledMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A possibly down-sampled series of metrics' readings through the progress of
	// the trial.
	Data []*DataPoint `protobuf:"bytes,1,rep,name=data,proto3" json:"data,omitempty"`
	// Metric group (training, validation, or unset).
	//
	// Deprecated: Do not use.
	Type MetricType `protobuf:"varint,3,opt,name=type,proto3,enum=determined.api.v1.MetricType" json:"type,omitempty"`
	// Metric group (training, validation, etc).
	Group string `protobuf:"bytes,4,opt,name=group,proto3" json:"group,omitempty"`
}

func (x *DownsampledMetrics) Reset() {
	*x = DownsampledMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DownsampledMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownsampledMetrics) ProtoMessage() {}

func (x *DownsampledMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DownsampledMetrics.ProtoReflect.Descriptor instead.
func (*DownsampledMetrics) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{0}
}

func (x *DownsampledMetrics) GetData() []*DataPoint {
	if x != nil {
		return x.Data
	}
	return nil
}

// Deprecated: Do not use.
func (x *DownsampledMetrics) GetType() MetricType {
	if x != nil {
		return x.Type
	}
	return MetricType_METRIC_TYPE_UNSPECIFIED
}

func (x *DownsampledMetrics) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

// WorkloadContainer is a wrapper for Determined workloads to allow repeated
// oneof types.
type WorkloadContainer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// workload represent one of Determined workloads: training, validation, or
	// checkpoint.
	//
	// Types that are assignable to Workload:
	//
	//	*WorkloadContainer_Training
	//	*WorkloadContainer_Validation
	//	*WorkloadContainer_Checkpoint
	Workload isWorkloadContainer_Workload `protobuf_oneof:"workload"`
}

func (x *WorkloadContainer) Reset() {
	*x = WorkloadContainer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkloadContainer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadContainer) ProtoMessage() {}

func (x *WorkloadContainer) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadContainer.ProtoReflect.Descriptor instead.
func (*WorkloadContainer) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{1}
}

func (m *WorkloadContainer) GetWorkload() isWorkloadContainer_Workload {
	if m != nil {
		return m.Workload
	}
	return nil
}

func (x *WorkloadContainer) GetTraining() *trialv1.MetricsWorkload {
	if x, ok := x.GetWorkload().(*WorkloadContainer_Training); ok {
		return x.Training
	}
	return nil
}

func (x *WorkloadContainer) GetValidation() *trialv1.MetricsWorkload {
	if x, ok := x.GetWorkload().(*WorkloadContainer_Validation); ok {
		return x.Validation
	}
	return nil
}

func (x *WorkloadContainer) GetCheckpoint() *trialv1.CheckpointWorkload {
	if x, ok := x.GetWorkload().(*WorkloadContainer_Checkpoint); ok {
		return x.Checkpoint
	}
	return nil
}

type isWorkloadContainer_Workload interface {
	isWorkloadContainer_Workload()
}

type WorkloadContainer_Training struct {
	// Training workload.
	Training *trialv1.MetricsWorkload `protobuf:"bytes,4,opt,name=training,proto3,oneof"`
}

type WorkloadContainer_Validation struct {
	// Validation workload.
	Validation *trialv1.MetricsWorkload `protobuf:"bytes,5,opt,name=validation,proto3,oneof"`
}

type WorkloadContainer_Checkpoint struct {
	// Checkpoint workload.
	Checkpoint *trialv1.CheckpointWorkload `protobuf:"bytes,6,opt,name=checkpoint,proto3,oneof"`
}

func (*WorkloadContainer_Training) isWorkloadContainer_Workload() {}

func (*WorkloadContainer_Validation) isWorkloadContainer_Workload() {}

func (*WorkloadContainer_Checkpoint) isWorkloadContainer_Workload() {}

// A filter structure to allow for range filters on arbitrary keys
type ColumnFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the field on which the filters is applied.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The filter to apply to the given column
	Filter *commonv1.DoubleFieldFilter `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ColumnFilter) Reset() {
	*x = ColumnFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ColumnFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ColumnFilter) ProtoMessage() {}

func (x *ColumnFilter) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ColumnFilter.ProtoReflect.Descriptor instead.
func (*ColumnFilter) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{2}
}

func (x *ColumnFilter) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ColumnFilter) GetFilter() *commonv1.DoubleFieldFilter {
	if x != nil {
		return x.Filter
	}
	return nil
}

// Tag for trials. Implemented in such a way to allow easy
// evolvability into/coexistence with key/values tags
type TrialTag struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The actual tag.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *TrialTag) Reset() {
	*x = TrialTag{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrialTag) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrialTag) ProtoMessage() {}

func (x *TrialTag) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrialTag.ProtoReflect.Descriptor instead.
func (*TrialTag) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{3}
}

func (x *TrialTag) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

// Struct to specify a sorting for trials. Used for both determining sort order
// for returned trials, and for filtering trials by their rank according to
// sorter
type TrialSorter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The namespace for the sort field.
	Namespace TrialSorter_Namespace `protobuf:"varint,1,opt,name=namespace,proto3,enum=determined.api.v1.TrialSorter_Namespace" json:"namespace,omitempty"`
	// The name of the sort field.
	Field string `protobuf:"bytes,2,opt,name=field,proto3" json:"field,omitempty"`
	// The ordering for the sort.
	OrderBy OrderBy `protobuf:"varint,3,opt,name=order_by,json=orderBy,proto3,enum=determined.api.v1.OrderBy" json:"order_by,omitempty"`
}

func (x *TrialSorter) Reset() {
	*x = TrialSorter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrialSorter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrialSorter) ProtoMessage() {}

func (x *TrialSorter) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrialSorter.ProtoReflect.Descriptor instead.
func (*TrialSorter) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{4}
}

func (x *TrialSorter) GetNamespace() TrialSorter_Namespace {
	if x != nil {
		return x.Namespace
	}
	return TrialSorter_NAMESPACE_UNSPECIFIED
}

func (x *TrialSorter) GetField() string {
	if x != nil {
		return x.Field
	}
	return ""
}

func (x *TrialSorter) GetOrderBy() OrderBy {
	if x != nil {
		return x.OrderBy
	}
	return OrderBy_ORDER_BY_UNSPECIFIED
}

// Stream trial logs.
type TrialLogsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the trial.
	TrialId int32 `protobuf:"varint,1,opt,name=trial_id,json=trialId,proto3" json:"trial_id,omitempty"`
	// Limit the number of trial logs. A value of 0 denotes no limit.
	Limit int32 `protobuf:"varint,4,opt,name=limit,proto3" json:"limit,omitempty"`
	// Continue following logs until the trial stops.
	Follow bool `protobuf:"varint,5,opt,name=follow,proto3" json:"follow,omitempty"`
	// Limit the trial logs to a subset of agents.
	AgentIds []string `protobuf:"bytes,6,rep,name=agent_ids,json=agentIds,proto3" json:"agent_ids,omitempty"`
	// Limit the trial logs to a subset of containers.
	ContainerIds []string `protobuf:"bytes,7,rep,name=container_ids,json=containerIds,proto3" json:"container_ids,omitempty"`
	// Limit the trial logs to a subset of ranks.
	RankIds []int32 `protobuf:"varint,8,rep,packed,name=rank_ids,json=rankIds,proto3" json:"rank_ids,omitempty"`
	// Limit the trial logs to a subset of agents.
	Levels []logv1.LogLevel `protobuf:"varint,9,rep,packed,name=levels,proto3,enum=determined.log.v1.LogLevel" json:"levels,omitempty"`
	// Limit the trial logs to a subset of output streams.
	Stdtypes []string `protobuf:"bytes,10,rep,name=stdtypes,proto3" json:"stdtypes,omitempty"`
	// Limit the trial logs to a subset of sources.
	Sources []string `protobuf:"bytes,11,rep,name=sources,proto3" json:"sources,omitempty"`
	// Limit the trial logs to ones with a timestamp before a given time.
	TimestampBefore *timestamp.Timestamp `protobuf:"bytes,12,opt,name=timestamp_before,json=timestampBefore,proto3" json:"timestamp_before,omitempty"`
	// Limit the trial logs to ones with a timestamp after a given time.
	TimestampAfter *timestamp.Timestamp `protobuf:"bytes,13,opt,name=timestamp_after,json=timestampAfter,proto3" json:"timestamp_after,omitempty"`
	// Order logs in either ascending or descending order by timestamp.
	OrderBy OrderBy `protobuf:"varint,14,opt,name=order_by,json=orderBy,proto3,enum=determined.api.v1.OrderBy" json:"order_by,omitempty"`
	// Search the logs by whether the text contains a substring.
	SearchText string `protobuf:"bytes,15,opt,name=search_text,json=searchText,proto3" json:"search_text,omitempty"`
	// Search text is regex. Default to false.
	EnableRegex bool `protobuf:"varint,16,opt,name=enable_regex,json=enableRegex,proto3" json:"enable_regex,omitempty"`
}

func (x *TrialLogsRequest) Reset() {
	*x = TrialLogsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrialLogsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrialLogsRequest) ProtoMessage() {}

func (x *TrialLogsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrialLogsRequest.ProtoReflect.Descriptor instead.
func (*TrialLogsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{5}
}

func (x *TrialLogsRequest) GetTrialId() int32 {
	if x != nil {
		return x.TrialId
	}
	return 0
}

func (x *TrialLogsRequest) GetLimit() int32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *TrialLogsRequest) GetFollow() bool {
	if x != nil {
		return x.Follow
	}
	return false
}

func (x *TrialLogsRequest) GetAgentIds() []string {
	if x != nil {
		return x.AgentIds
	}
	return nil
}

func (x *TrialLogsRequest) GetContainerIds() []string {
	if x != nil {
		return x.ContainerIds
	}
	return nil
}

func (x *TrialLogsRequest) GetRankIds() []int32 {
	if x != nil {
		return x.RankIds
	}
	return nil
}

func (x *TrialLogsRequest) GetLevels() []logv1.LogLevel {
	if x != nil {
		return x.Levels
	}
	return nil
}

func (x *TrialLogsRequest) GetStdtypes() []string {
	if x != nil {
		return x.Stdtypes
	}
	return nil
}

func (x *TrialLogsRequest) GetSources() []string {
	if x != nil {
		return x.Sources
	}
	return nil
}

func (x *TrialLogsRequest) GetTimestampBefore() *timestamp.Timestamp {
	if x != nil {
		return x.TimestampBefore
	}
	return nil
}

func (x *TrialLogsRequest) GetTimestampAfter() *timestamp.Timestamp {
	if x != nil {
		return x.TimestampAfter
	}
	return nil
}

func (x *TrialLogsRequest) GetOrderBy() OrderBy {
	if x != nil {
		return x.OrderBy
	}
	return OrderBy_ORDER_BY_UNSPECIFIED
}

func (x *TrialLogsRequest) GetSearchText() string {
	if x != nil {
		return x.SearchText
	}
	return ""
}

func (x *TrialLogsRequest) GetEnableRegex() bool {
	if x != nil {
		return x.EnableRegex
	}
	return false
}

// Response to TrialLogsRequest.
type TrialLogsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the trial log.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The timestamp of the log.
	Timestamp *timestamp.Timestamp `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// The flat version of the log that UIs have shown historically.
	//
	// Deprecated: Do not use.
	Message string `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
	// The level of the log.
	Level logv1.LogLevel `protobuf:"varint,4,opt,name=level,proto3,enum=determined.log.v1.LogLevel" json:"level,omitempty"`
	// The ID of the trial associated with this log entry.
	TrialId int32 `protobuf:"varint,5,opt,name=trial_id,json=trialId,proto3" json:"trial_id,omitempty"`
	// The ID of the agent that logged this.
	AgentId *string `protobuf:"bytes,6,opt,name=agent_id,json=agentId,proto3,oneof" json:"agent_id,omitempty"`
	// The ID of the container or, in the case of k8s, the pod name.
	ContainerId *string `protobuf:"bytes,7,opt,name=container_id,json=containerId,proto3,oneof" json:"container_id,omitempty"`
	// The rank ID.
	RankId *int32 `protobuf:"varint,8,opt,name=rank_id,json=rankId,proto3,oneof" json:"rank_id,omitempty"`
	// The text of the log entry.
	Log *string `protobuf:"bytes,9,opt,name=log,proto3,oneof" json:"log,omitempty"`
	// The source of the log entry.
	Source *string `protobuf:"bytes,10,opt,name=source,proto3,oneof" json:"source,omitempty"`
	// The output stream (e.g. stdout, stderr).
	Stdtype *string `protobuf:"bytes,11,opt,name=stdtype,proto3,oneof" json:"stdtype,omitempty"`
}

func (x *TrialLogsResponse) Reset() {
	*x = TrialLogsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrialLogsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrialLogsResponse) ProtoMessage() {}

func (x *TrialLogsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrialLogsResponse.ProtoReflect.Descriptor instead.
func (*TrialLogsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{6}
}

func (x *TrialLogsResponse) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *TrialLogsResponse) GetTimestamp() *timestamp.Timestamp {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

// Deprecated: Do not use.
func (x *TrialLogsResponse) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *TrialLogsResponse) GetLevel() logv1.LogLevel {
	if x != nil {
		return x.Level
	}
	return logv1.LogLevel_LOG_LEVEL_UNSPECIFIED
}

func (x *TrialLogsResponse) GetTrialId() int32 {
	if x != nil {
		return x.TrialId
	}
	return 0
}

func (x *TrialLogsResponse) GetAgentId() string {
	if x != nil && x.AgentId != nil {
		return *x.AgentId
	}
	return ""
}

func (x *TrialLogsResponse) GetContainerId() string {
	if x != nil && x.ContainerId != nil {
		return *x.ContainerId
	}
	return ""
}

func (x *TrialLogsResponse) GetRankId() int32 {
	if x != nil && x.RankId != nil {
		return *x.RankId
	}
	return 0
}

func (x *TrialLogsResponse) GetLog() string {
	if x != nil && x.Log != nil {
		return *x.Log
	}
	return ""
}

func (x *TrialLogsResponse) GetSource() string {
	if x != nil && x.Source != nil {
		return *x.Source
	}
	return ""
}

func (x *TrialLogsResponse) GetStdtype() string {
	if x != nil && x.Stdtype != nil {
		return *x.Stdtype
	}
	return ""
}

// Stream distinct trial log fields.
type TrialLogsFieldsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the trial.
	TrialId int32 `protobuf:"varint,1,opt,name=trial_id,json=trialId,proto3" json:"trial_id,omitempty"`
	// Continue following fields until the trial stops.
	Follow bool `protobuf:"varint,2,opt,name=follow,proto3" json:"follow,omitempty"`
}

func (x *TrialLogsFieldsRequest) Reset() {
	*x = TrialLogsFieldsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrialLogsFieldsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrialLogsFieldsRequest) ProtoMessage() {}

func (x *TrialLogsFieldsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrialLogsFieldsRequest.ProtoReflect.Descriptor instead.
func (*TrialLogsFieldsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{7}
}

func (x *TrialLogsFieldsRequest) GetTrialId() int32 {
	if x != nil {
		return x.TrialId
	}
	return 0
}

func (x *TrialLogsFieldsRequest) GetFollow() bool {
	if x != nil {
		return x.Follow
	}
	return false
}

// Response to TrialLogFieldsRequest.
type TrialLogsFieldsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The distinct agent IDs present in the logs.
	AgentIds []string `protobuf:"bytes,1,rep,name=agent_ids,json=agentIds,proto3" json:"agent_ids,omitempty"`
	// The distinct container IDs present in the logs.
	ContainerIds []string `protobuf:"bytes,2,rep,name=container_ids,json=containerIds,proto3" json:"container_ids,omitempty"`
	// The distinct rank IDs present in the logs.
	RankIds []int32 `protobuf:"varint,3,rep,packed,name=rank_ids,json=rankIds,proto3" json:"rank_ids,omitempty"`
	// The distinct stdtypes present in the logs.
	Stdtypes []string `protobuf:"bytes,4,rep,name=stdtypes,proto3" json:"stdtypes,omitempty"`
	// The distinct sources present in the logs.
	Sources []string `protobuf:"bytes,5,rep,name=sources,proto3" json:"sources,omitempty"`
}

func (x *TrialLogsFieldsResponse) Reset() {
	*x = TrialLogsFieldsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrialLogsFieldsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrialLogsFieldsResponse) ProtoMessage() {}

func (x *TrialLogsFieldsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrialLogsFieldsResponse.ProtoReflect.Descriptor instead.
func (*TrialLogsFieldsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{8}
}

func (x *TrialLogsFieldsResponse) GetAgentIds() []string {
	if x != nil {
		return x.AgentIds
	}
	return nil
}

func (x *TrialLogsFieldsResponse) GetContainerIds() []string {
	if x != nil {
		return x.ContainerIds
	}
	return nil
}

func (x *TrialLogsFieldsResponse) GetRankIds() []int32 {
	if x != nil {
		return x.RankIds
	}
	return nil
}

func (x *TrialLogsFieldsResponse) GetStdtypes() []string {
	if x != nil {
		return x.Stdtypes
	}
	return nil
}

func (x *TrialLogsFieldsResponse) GetSources() []string {
	if x != nil {
		return x.Sources
	}
	return nil
}

// Get a list of checkpoints for a trial.
type GetTrialCheckpointsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The trial id.
	Id int32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// Sort checkpoints by the given field.
	//
	// Types that are assignable to SortBy:
	//
	//	*GetTrialCheckpointsRequest_SortByAttr
	//	*GetTrialCheckpointsRequest_SortByMetric
	SortBy isGetTrialCheckpointsRequest_SortBy `protobuf_oneof:"sort_by"`
	// Order checkpoints in either ascending or descending order.
	OrderBy OrderBy `protobuf:"varint,4,opt,name=order_by,json=orderBy,proto3,enum=determined.api.v1.OrderBy" json:"order_by,omitempty"`
	// Skip the number of checkpoints before returning results. Negative values
	// denote number of checkpoints to skip from the end before returning results.
	Offset int32 `protobuf:"varint,5,opt,name=offset,proto3" json:"offset,omitempty"`
	// Limit the number of checkpoints. A value of 0 denotes no limit.
	Limit int32 `protobuf:"varint,6,opt,name=limit,proto3" json:"limit,omitempty"`
	// Limit the checkpoints to those that match the states.
	States []checkpointv1.State `protobuf:"varint,7,rep,packed,name=states,proto3,enum=determined.checkpoint.v1.State" json:"states,omitempty"`
}

func (x *GetTrialCheckpointsRequest) Reset() {
	*x = GetTrialCheckpointsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTrialCheckpointsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTrialCheckpointsRequest) ProtoMessage() {}

func (x *GetTrialCheckpointsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTrialCheckpointsRequest.ProtoReflect.Descriptor instead.
func (*GetTrialCheckpointsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{9}
}

func (x *GetTrialCheckpointsRequest) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (m *GetTrialCheckpointsRequest) GetSortBy() isGetTrialCheckpointsRequest_SortBy {
	if m != nil {
		return m.SortBy
	}
	return nil
}

func (x *GetTrialCheckpointsRequest) GetSortByAttr() checkpointv1.SortBy {
	if x, ok := x.GetSortBy().(*GetTrialCheckpointsRequest_SortByAttr); ok {
		return x.SortByAttr
	}
	return checkpointv1.SortBy_SORT_BY_UNSPECIFIED
}

func (x *GetTrialCheckpointsRequest) GetSortByMetric() string {
	if x, ok := x.GetSortBy().(*GetTrialCheckpointsRequest_SortByMetric); ok {
		return x.SortByMetric
	}
	return ""
}

func (x *GetTrialCheckpointsRequest) GetOrderBy() OrderBy {
	if x != nil {
		return x.OrderBy
	}
	return OrderBy_ORDER_BY_UNSPECIFIED
}

func (x *GetTrialCheckpointsRequest) GetOffset() int32 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *GetTrialCheckpointsRequest) GetLimit() int32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *GetTrialCheckpointsRequest) GetStates() []checkpointv1.State {
	if x != nil {
		return x.States
	}
	return nil
}

type isGetTrialCheckpointsRequest_SortBy interface {
	isGetTrialCheckpointsRequest_SortBy()
}

type GetTrialCheckpointsRequest_SortByAttr struct {
	// Sort by preset checkpoint attribute.
	SortByAttr checkpointv1.SortBy `protobuf:"varint,2,opt,name=sort_by_attr,json=sortByAttr,proto3,enum=determined.checkpoint.v1.SortBy,oneof"`
}

type GetTrialCheckpointsRequest_SortByMetric struct {
	// Sort by custom validation metric name.
	SortByMetric string `protobuf:"bytes,3,opt,name=sort_by_metric,json=sortByMetric,proto3,oneof"`
}

func (*GetTrialCheckpointsRequest_SortByAttr) isGetTrialCheckpointsRequest_SortBy() {}

func (*GetTrialCheckpointsRequest_SortByMetric) isGetTrialCheckpointsRequest_SortBy() {}

// Response to GetTrialCheckpointsRequest.
type GetTrialCheckpointsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of returned checkpoints.
	Checkpoints []*checkpointv1.Checkpoint `protobuf:"bytes,1,rep,name=checkpoints,proto3" json:"checkpoints,omitempty"`
	// Pagination information of the full dataset.
	Pagination *Pagination `protobuf:"bytes,2,opt,name=pagination,proto3" json:"pagination,omitempty"`
}

func (x *GetTrialCheckpointsResponse) Reset() {
	*x = GetTrialCheckpointsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTrialCheckpointsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTrialCheckpointsResponse) ProtoMessage() {}

func (x *GetTrialCheckpointsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTrialCheckpointsResponse.ProtoReflect.Descriptor instead.
func (*GetTrialCheckpointsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{10}
}

func (x *GetTrialCheckpointsResponse) GetCheckpoints() []*checkpointv1.Checkpoint {
	if x != nil {
		return x.Checkpoints
	}
	return nil
}

func (x *GetTrialCheckpointsResponse) GetPagination() *Pagination {
	if x != nil {
		return x.Pagination
	}
	return nil
}

// Kill an trial.
type KillTrialRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The trial id
	Id int32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *KillTrialRequest) Reset() {
	*x = KillTrialRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KillTrialRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KillTrialRequest) ProtoMessage() {}

func (x *KillTrialRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KillTrialRequest.ProtoReflect.Descriptor instead.
func (*KillTrialRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{11}
}

func (x *KillTrialRequest) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

// Response to KillTrialRequest.
type KillTrialResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *KillTrialResponse) Reset() {
	*x = KillTrialResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KillTrialResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KillTrialResponse) ProtoMessage() {}

func (x *KillTrialResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KillTrialResponse.ProtoReflect.Descriptor instead.
func (*KillTrialResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{12}
}

// Get the list of trials for an experiment.
type GetExperimentTrialsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sort trials by the given field.
	SortBy GetExperimentTrialsRequest_SortBy `protobuf:"varint,1,opt,name=sort_by,json=sortBy,proto3,enum=determined.api.v1.GetExperimentTrialsRequest_SortBy" json:"sort_by,omitempty"`
	// Order trials in either ascending or descending order.
	OrderBy OrderBy `protobuf:"varint,2,opt,name=order_by,json=orderBy,proto3,enum=determined.api.v1.OrderBy" json:"order_by,omitempty"`
	// Skip the number of trials before returning results. Negative values
	// denote number of trials to skip from the end before returning results.
	Offset int32 `protobuf:"varint,3,opt,name=offset,proto3" json:"offset,omitempty"`
	// Limit the number of trials. A value of 0 denotes no limit.
	Limit int32 `protobuf:"varint,4,opt,name=limit,proto3" json:"limit,omitempty"`
	// Limit trials to those that match the provided state.
	States []experimentv1.State `protobuf:"varint,5,rep,packed,name=states,proto3,enum=determined.experiment.v1.State" json:"states,omitempty"`
	// Limit trials to those that are owned by the specified experiments.
	ExperimentId int32 `protobuf:"varint,6,opt,name=experiment_id,json=experimentId,proto3" json:"experiment_id,omitempty"`
}

func (x *GetExperimentTrialsRequest) Reset() {
	*x = GetExperimentTrialsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetExperimentTrialsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetExperimentTrialsRequest) ProtoMessage() {}

func (x *GetExperimentTrialsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetExperimentTrialsRequest.ProtoReflect.Descriptor instead.
func (*GetExperimentTrialsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{13}
}

func (x *GetExperimentTrialsRequest) GetSortBy() GetExperimentTrialsRequest_SortBy {
	if x != nil {
		return x.SortBy
	}
	return GetExperimentTrialsRequest_SORT_BY_UNSPECIFIED
}

func (x *GetExperimentTrialsRequest) GetOrderBy() OrderBy {
	if x != nil {
		return x.OrderBy
	}
	return OrderBy_ORDER_BY_UNSPECIFIED
}

func (x *GetExperimentTrialsRequest) GetOffset() int32 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *GetExperimentTrialsRequest) GetLimit() int32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *GetExperimentTrialsRequest) GetStates() []experimentv1.State {
	if x != nil {
		return x.States
	}
	return nil
}

func (x *GetExperimentTrialsRequest) GetExperimentId() int32 {
	if x != nil {
		return x.ExperimentId
	}
	return 0
}

// Response to GetExperimentTrialsRequest.
type GetExperimentTrialsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of returned trials.
	Trials []*trialv1.Trial `protobuf:"bytes,1,rep,name=trials,proto3" json:"trials,omitempty"`
	// Pagination information of the full dataset.
	Pagination *Pagination `protobuf:"bytes,2,opt,name=pagination,proto3" json:"pagination,omitempty"`
}

func (x *GetExperimentTrialsResponse) Reset() {
	*x = GetExperimentTrialsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetExperimentTrialsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetExperimentTrialsResponse) ProtoMessage() {}

func (x *GetExperimentTrialsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetExperimentTrialsResponse.ProtoReflect.Descriptor instead.
func (*GetExperimentTrialsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{14}
}

func (x *GetExperimentTrialsResponse) GetTrials() []*trialv1.Trial {
	if x != nil {
		return x.Trials
	}
	return nil
}

func (x *GetExperimentTrialsResponse) GetPagination() *Pagination {
	if x != nil {
		return x.Pagination
	}
	return nil
}

// Get the remaining log retention days for a trial id.
type GetTrialRemainingLogRetentionDaysRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The trial id.
	Id int32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *GetTrialRemainingLogRetentionDaysRequest) Reset() {
	*x = GetTrialRemainingLogRetentionDaysRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTrialRemainingLogRetentionDaysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTrialRemainingLogRetentionDaysRequest) ProtoMessage() {}

func (x *GetTrialRemainingLogRetentionDaysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTrialRemainingLogRetentionDaysRequest.ProtoReflect.Descriptor instead.
func (*GetTrialRemainingLogRetentionDaysRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{15}
}

func (x *GetTrialRemainingLogRetentionDaysRequest) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

// Response to GetTrialRemainingLogRetentionDaysRequest.
type GetTrialRemainingLogRetentionDaysResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The remaining log retention days for the trial id.
	RemainingDays *int32 `protobuf:"varint,1,opt,name=remaining_days,json=remainingDays,proto3,oneof" json:"remaining_days,omitempty"`
}

func (x *GetTrialRemainingLogRetentionDaysResponse) Reset() {
	*x = GetTrialRemainingLogRetentionDaysResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTrialRemainingLogRetentionDaysResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTrialRemainingLogRetentionDaysResponse) ProtoMessage() {}

func (x *GetTrialRemainingLogRetentionDaysResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTrialRemainingLogRetentionDaysResponse.ProtoReflect.Descriptor instead.
func (*GetTrialRemainingLogRetentionDaysResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{16}
}

func (x *GetTrialRemainingLogRetentionDaysResponse) GetRemainingDays() int32 {
	if x != nil && x.RemainingDays != nil {
		return *x.RemainingDays
	}
	return 0
}

// Get trial details.
type GetTrialRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested trial's id.
	TrialId int32 `protobuf:"varint,1,opt,name=trial_id,json=trialId,proto3" json:"trial_id,omitempty"`
}

func (x *GetTrialRequest) Reset() {
	*x = GetTrialRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTrialRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTrialRequest) ProtoMessage() {}

func (x *GetTrialRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTrialRequest.ProtoReflect.Descriptor instead.
func (*GetTrialRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{17}
}

func (x *GetTrialRequest) GetTrialId() int32 {
	if x != nil {
		return x.TrialId
	}
	return 0
}

// Response to GetTrialRequest.
type GetTrialResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested trial.
	Trial *trialv1.Trial `protobuf:"bytes,1,opt,name=trial,proto3" json:"trial,omitempty"`
}

func (x *GetTrialResponse) Reset() {
	*x = GetTrialResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTrialResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTrialResponse) ProtoMessage() {}

func (x *GetTrialResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTrialResponse.ProtoReflect.Descriptor instead.
func (*GetTrialResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{18}
}

func (x *GetTrialResponse) GetTrial() *trialv1.Trial {
	if x != nil {
		return x.Trial
	}
	return nil
}

// Get trial details by external experiment and trial ids.
type GetTrialByExternalIDRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// External experiment id.
	ExternalExperimentId string `protobuf:"bytes,1,opt,name=external_experiment_id,json=externalExperimentId,proto3" json:"external_experiment_id,omitempty"`
	// External trial id.
	ExternalTrialId string `protobuf:"bytes,2,opt,name=external_trial_id,json=externalTrialId,proto3" json:"external_trial_id,omitempty"`
}

func (x *GetTrialByExternalIDRequest) Reset() {
	*x = GetTrialByExternalIDRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTrialByExternalIDRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTrialByExternalIDRequest) ProtoMessage() {}

func (x *GetTrialByExternalIDRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTrialByExternalIDRequest.ProtoReflect.Descriptor instead.
func (*GetTrialByExternalIDRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{19}
}

func (x *GetTrialByExternalIDRequest) GetExternalExperimentId() string {
	if x != nil {
		return x.ExternalExperimentId
	}
	return ""
}

func (x *GetTrialByExternalIDRequest) GetExternalTrialId() string {
	if x != nil {
		return x.ExternalTrialId
	}
	return ""
}

// Response to GetTrialByExternalIDRequest.
type GetTrialByExternalIDResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested trial.
	Trial *trialv1.Trial `protobuf:"bytes,1,opt,name=trial,proto3" json:"trial,omitempty"`
}

func (x *GetTrialByExternalIDResponse) Reset() {
	*x = GetTrialByExternalIDResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTrialByExternalIDResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTrialByExternalIDResponse) ProtoMessage() {}

func (x *GetTrialByExternalIDResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTrialByExternalIDResponse.ProtoReflect.Descriptor instead.
func (*GetTrialByExternalIDResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{20}
}

func (x *GetTrialByExternalIDResponse) GetTrial() *trialv1.Trial {
	if x != nil {
		return x.Trial
	}
	return nil
}

// Get the list of workloads for a trial.
type GetTrialWorkloadsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Order workloads in either ascending or descending order.
	OrderBy OrderBy `protobuf:"varint,1,opt,name=order_by,json=orderBy,proto3,enum=determined.api.v1.OrderBy" json:"order_by,omitempty"`
	// Skip the number of workloads before returning results. Negative values
	// denote number of workloads to skip from the end before returning results.
	Offset int32 `protobuf:"varint,2,opt,name=offset,proto3" json:"offset,omitempty"`
	// Limit the number of workloads. A value of 0 denotes no limit.
	Limit int32 `protobuf:"varint,3,opt,name=limit,proto3" json:"limit,omitempty"`
	// Limit workloads to those that are owned by the specified trial.
	TrialId int32 `protobuf:"varint,4,opt,name=trial_id,json=trialId,proto3" json:"trial_id,omitempty"`
	// Sort workloads by batches, a training metric, or a validation metric.
	SortKey string `protobuf:"bytes,5,opt,name=sort_key,json=sortKey,proto3" json:"sort_key,omitempty"`
	// Filter workloads with validation and/or checkpoint information.
	Filter GetTrialWorkloadsRequest_FilterOption `protobuf:"varint,6,opt,name=filter,proto3,enum=determined.api.v1.GetTrialWorkloadsRequest_FilterOption" json:"filter,omitempty"`
	// Include per-batch metrics.
	IncludeBatchMetrics bool `protobuf:"varint,7,opt,name=include_batch_metrics,json=includeBatchMetrics,proto3" json:"include_batch_metrics,omitempty"`
	// When sorting workloads by sort_key, specify training or validation form of
	// a metric.
	//
	// Deprecated: Do not use.
	MetricType MetricType `protobuf:"varint,8,opt,name=metric_type,json=metricType,proto3,enum=determined.api.v1.MetricType" json:"metric_type,omitempty"`
	// Metric group (training, validation, etc).
	Group string `protobuf:"bytes,9,opt,name=group,proto3" json:"group,omitempty"`
	// Remove deleted checkpoints.
	RemoveDeletedCheckpoints bool `protobuf:"varint,10,opt,name=remove_deleted_checkpoints,json=removeDeletedCheckpoints,proto3" json:"remove_deleted_checkpoints,omitempty"`
}

func (x *GetTrialWorkloadsRequest) Reset() {
	*x = GetTrialWorkloadsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTrialWorkloadsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTrialWorkloadsRequest) ProtoMessage() {}

func (x *GetTrialWorkloadsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTrialWorkloadsRequest.ProtoReflect.Descriptor instead.
func (*GetTrialWorkloadsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{21}
}

func (x *GetTrialWorkloadsRequest) GetOrderBy() OrderBy {
	if x != nil {
		return x.OrderBy
	}
	return OrderBy_ORDER_BY_UNSPECIFIED
}

func (x *GetTrialWorkloadsRequest) GetOffset() int32 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *GetTrialWorkloadsRequest) GetLimit() int32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *GetTrialWorkloadsRequest) GetTrialId() int32 {
	if x != nil {
		return x.TrialId
	}
	return 0
}

func (x *GetTrialWorkloadsRequest) GetSortKey() string {
	if x != nil {
		return x.SortKey
	}
	return ""
}

func (x *GetTrialWorkloadsRequest) GetFilter() GetTrialWorkloadsRequest_FilterOption {
	if x != nil {
		return x.Filter
	}
	return GetTrialWorkloadsRequest_FILTER_OPTION_UNSPECIFIED
}

func (x *GetTrialWorkloadsRequest) GetIncludeBatchMetrics() bool {
	if x != nil {
		return x.IncludeBatchMetrics
	}
	return false
}

// Deprecated: Do not use.
func (x *GetTrialWorkloadsRequest) GetMetricType() MetricType {
	if x != nil {
		return x.MetricType
	}
	return MetricType_METRIC_TYPE_UNSPECIFIED
}

func (x *GetTrialWorkloadsRequest) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

func (x *GetTrialWorkloadsRequest) GetRemoveDeletedCheckpoints() bool {
	if x != nil {
		return x.RemoveDeletedCheckpoints
	}
	return false
}

// Response to GetTrialWorkloadsRequest.
type GetTrialWorkloadsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of returned workloads.
	Workloads []*WorkloadContainer `protobuf:"bytes,1,rep,name=workloads,proto3" json:"workloads,omitempty"`
	// Pagination information of the full dataset.
	Pagination *Pagination `protobuf:"bytes,2,opt,name=pagination,proto3" json:"pagination,omitempty"`
}

func (x *GetTrialWorkloadsResponse) Reset() {
	*x = GetTrialWorkloadsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTrialWorkloadsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTrialWorkloadsResponse) ProtoMessage() {}

func (x *GetTrialWorkloadsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTrialWorkloadsResponse.ProtoReflect.Descriptor instead.
func (*GetTrialWorkloadsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{22}
}

func (x *GetTrialWorkloadsResponse) GetWorkloads() []*WorkloadContainer {
	if x != nil {
		return x.Workloads
	}
	return nil
}

func (x *GetTrialWorkloadsResponse) GetPagination() *Pagination {
	if x != nil {
		return x.Pagination
	}
	return nil
}

// Stream trial profiler metrics.
type GetTrialProfilerMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The labels for the series requested.
	Labels *trialv1.TrialProfilerMetricLabels `protobuf:"bytes,1,opt,name=labels,proto3" json:"labels,omitempty"`
	// Continue streaming metrics until the trial stops. Defaults to False.
	Follow bool `protobuf:"varint,2,opt,name=follow,proto3" json:"follow,omitempty"`
}

func (x *GetTrialProfilerMetricsRequest) Reset() {
	*x = GetTrialProfilerMetricsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTrialProfilerMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTrialProfilerMetricsRequest) ProtoMessage() {}

func (x *GetTrialProfilerMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTrialProfilerMetricsRequest.ProtoReflect.Descriptor instead.
func (*GetTrialProfilerMetricsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{23}
}

func (x *GetTrialProfilerMetricsRequest) GetLabels() *trialv1.TrialProfilerMetricLabels {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *GetTrialProfilerMetricsRequest) GetFollow() bool {
	if x != nil {
		return x.Follow
	}
	return false
}

// Response to TrialProfilerMetricsResponse
type GetTrialProfilerMetricsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A batch matching the series requested.
	Batch *trialv1.TrialProfilerMetricsBatch `protobuf:"bytes,1,opt,name=batch,proto3" json:"batch,omitempty"`
}

func (x *GetTrialProfilerMetricsResponse) Reset() {
	*x = GetTrialProfilerMetricsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTrialProfilerMetricsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTrialProfilerMetricsResponse) ProtoMessage() {}

func (x *GetTrialProfilerMetricsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTrialProfilerMetricsResponse.ProtoReflect.Descriptor instead.
func (*GetTrialProfilerMetricsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{24}
}

func (x *GetTrialProfilerMetricsResponse) GetBatch() *trialv1.TrialProfilerMetricsBatch {
	if x != nil {
		return x.Batch
	}
	return nil
}

// Stream distinct available profiler metric label sets.
type GetTrialProfilerAvailableSeriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested trial's id.
	TrialId int32 `protobuf:"varint,1,opt,name=trial_id,json=trialId,proto3" json:"trial_id,omitempty"`
	// Continue streaming labels until the trial stops. Defaults to False.
	Follow bool `protobuf:"varint,2,opt,name=follow,proto3" json:"follow,omitempty"`
}

func (x *GetTrialProfilerAvailableSeriesRequest) Reset() {
	*x = GetTrialProfilerAvailableSeriesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTrialProfilerAvailableSeriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTrialProfilerAvailableSeriesRequest) ProtoMessage() {}

func (x *GetTrialProfilerAvailableSeriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTrialProfilerAvailableSeriesRequest.ProtoReflect.Descriptor instead.
func (*GetTrialProfilerAvailableSeriesRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{25}
}

func (x *GetTrialProfilerAvailableSeriesRequest) GetTrialId() int32 {
	if x != nil {
		return x.TrialId
	}
	return 0
}

func (x *GetTrialProfilerAvailableSeriesRequest) GetFollow() bool {
	if x != nil {
		return x.Follow
	}
	return false
}

// Response to TrialProfilerAvailableSeriesRequest.
type GetTrialProfilerAvailableSeriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The labels for the series.
	Labels []*trialv1.TrialProfilerMetricLabels `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty"`
}

func (x *GetTrialProfilerAvailableSeriesResponse) Reset() {
	*x = GetTrialProfilerAvailableSeriesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTrialProfilerAvailableSeriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTrialProfilerAvailableSeriesResponse) ProtoMessage() {}

func (x *GetTrialProfilerAvailableSeriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTrialProfilerAvailableSeriesResponse.ProtoReflect.Descriptor instead.
func (*GetTrialProfilerAvailableSeriesResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{26}
}

func (x *GetTrialProfilerAvailableSeriesResponse) GetLabels() []*trialv1.TrialProfilerMetricLabels {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Create a batch of trial profiler metrics.
type PostTrialProfilerMetricsBatchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The batches to create.
	Batches []*trialv1.TrialProfilerMetricsBatch `protobuf:"bytes,1,rep,name=batches,proto3" json:"batches,omitempty"`
}

func (x *PostTrialProfilerMetricsBatchRequest) Reset() {
	*x = PostTrialProfilerMetricsBatchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PostTrialProfilerMetricsBatchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PostTrialProfilerMetricsBatchRequest) ProtoMessage() {}

func (x *PostTrialProfilerMetricsBatchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PostTrialProfilerMetricsBatchRequest.ProtoReflect.Descriptor instead.
func (*PostTrialProfilerMetricsBatchRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{27}
}

func (x *PostTrialProfilerMetricsBatchRequest) GetBatches() []*trialv1.TrialProfilerMetricsBatch {
	if x != nil {
		return x.Batches
	}
	return nil
}

// Response to PostTrialProfilerMetricsBatchRequest
type PostTrialProfilerMetricsBatchResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PostTrialProfilerMetricsBatchResponse) Reset() {
	*x = PostTrialProfilerMetricsBatchResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PostTrialProfilerMetricsBatchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PostTrialProfilerMetricsBatchResponse) ProtoMessage() {}

func (x *PostTrialProfilerMetricsBatchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PostTrialProfilerMetricsBatchResponse.ProtoReflect.Descriptor instead.
func (*PostTrialProfilerMetricsBatchResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{28}
}

// Container for a requested trial and its metrics.
type ComparableTrial struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested trial.
	Trial *trialv1.Trial `protobuf:"bytes,1,opt,name=trial,proto3" json:"trial,omitempty"`
	// The downsampled datapoints.
	Metrics []*DownsampledMetrics `protobuf:"bytes,2,rep,name=metrics,proto3" json:"metrics,omitempty"`
}

func (x *ComparableTrial) Reset() {
	*x = ComparableTrial{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComparableTrial) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComparableTrial) ProtoMessage() {}

func (x *ComparableTrial) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComparableTrial.ProtoReflect.Descriptor instead.
func (*ComparableTrial) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{29}
}

func (x *ComparableTrial) GetTrial() *trialv1.Trial {
	if x != nil {
		return x.Trial
	}
	return nil
}

func (x *ComparableTrial) GetMetrics() []*DownsampledMetrics {
	if x != nil {
		return x.Metrics
	}
	return nil
}

// Get time-series downsampled metrics from multiple trials.
type CompareTrialsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested trial ids.
	TrialIds []int32 `protobuf:"varint,1,rep,packed,name=trial_ids,json=trialIds,proto3" json:"trial_ids,omitempty"`
	// The maximum number of data points to return after downsampling.
	MaxDatapoints int32 `protobuf:"varint,2,opt,name=max_datapoints,json=maxDatapoints,proto3" json:"max_datapoints,omitempty"`
	// The names of selected metrics.
	MetricNames []string `protobuf:"bytes,3,rep,name=metric_names,json=metricNames,proto3" json:"metric_names,omitempty"`
	// Sample from metrics after this batch number.
	StartBatches int32 `protobuf:"varint,4,opt,name=start_batches,json=startBatches,proto3" json:"start_batches,omitempty"`
	// Sample from metrics before this batch number.
	EndBatches int32 `protobuf:"varint,5,opt,name=end_batches,json=endBatches,proto3" json:"end_batches,omitempty"`
	// Metric group.
	//
	// Deprecated: Do not use.
	MetricType MetricType `protobuf:"varint,6,opt,name=metric_type,json=metricType,proto3,enum=determined.api.v1.MetricType" json:"metric_type,omitempty"`
	// Metric group (training, validation, etc).
	Group string `protobuf:"bytes,11,opt,name=group,proto3" json:"group,omitempty"`
	// metric ids for the query. must be in the form group.metric_name.
	MetricIds []string `protobuf:"bytes,9,rep,name=metric_ids,json=metricIds,proto3" json:"metric_ids,omitempty"`
	// The metric and range filter for a time series
	TimeSeriesFilter *commonv1.PolymorphicFilter `protobuf:"bytes,10,opt,name=time_series_filter,json=timeSeriesFilter,proto3" json:"time_series_filter,omitempty"`
}

func (x *CompareTrialsRequest) Reset() {
	*x = CompareTrialsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompareTrialsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompareTrialsRequest) ProtoMessage() {}

func (x *CompareTrialsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompareTrialsRequest.ProtoReflect.Descriptor instead.
func (*CompareTrialsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{30}
}

func (x *CompareTrialsRequest) GetTrialIds() []int32 {
	if x != nil {
		return x.TrialIds
	}
	return nil
}

func (x *CompareTrialsRequest) GetMaxDatapoints() int32 {
	if x != nil {
		return x.MaxDatapoints
	}
	return 0
}

func (x *CompareTrialsRequest) GetMetricNames() []string {
	if x != nil {
		return x.MetricNames
	}
	return nil
}

func (x *CompareTrialsRequest) GetStartBatches() int32 {
	if x != nil {
		return x.StartBatches
	}
	return 0
}

func (x *CompareTrialsRequest) GetEndBatches() int32 {
	if x != nil {
		return x.EndBatches
	}
	return 0
}

// Deprecated: Do not use.
func (x *CompareTrialsRequest) GetMetricType() MetricType {
	if x != nil {
		return x.MetricType
	}
	return MetricType_METRIC_TYPE_UNSPECIFIED
}

func (x *CompareTrialsRequest) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

func (x *CompareTrialsRequest) GetMetricIds() []string {
	if x != nil {
		return x.MetricIds
	}
	return nil
}

func (x *CompareTrialsRequest) GetTimeSeriesFilter() *commonv1.PolymorphicFilter {
	if x != nil {
		return x.TimeSeriesFilter
	}
	return nil
}

// Request for changing the log retention policy for the an experiment.
type PutTrialRetainLogsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the trial.
	TrialId int32 `protobuf:"varint,1,opt,name=trial_id,json=trialId,proto3" json:"trial_id,omitempty"`
	// The number of days to retain logs, starting from the end time of the task.
	NumDays int32 `protobuf:"varint,2,opt,name=num_days,json=numDays,proto3" json:"num_days,omitempty"`
}

func (x *PutTrialRetainLogsRequest) Reset() {
	*x = PutTrialRetainLogsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PutTrialRetainLogsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PutTrialRetainLogsRequest) ProtoMessage() {}

func (x *PutTrialRetainLogsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PutTrialRetainLogsRequest.ProtoReflect.Descriptor instead.
func (*PutTrialRetainLogsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{31}
}

func (x *PutTrialRetainLogsRequest) GetTrialId() int32 {
	if x != nil {
		return x.TrialId
	}
	return 0
}

func (x *PutTrialRetainLogsRequest) GetNumDays() int32 {
	if x != nil {
		return x.NumDays
	}
	return 0
}

// Response to PutExperimentRetainLogsRequest.
type PutTrialRetainLogsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PutTrialRetainLogsResponse) Reset() {
	*x = PutTrialRetainLogsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PutTrialRetainLogsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PutTrialRetainLogsResponse) ProtoMessage() {}

func (x *PutTrialRetainLogsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PutTrialRetainLogsResponse.ProtoReflect.Descriptor instead.
func (*PutTrialRetainLogsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{32}
}

// Response to CompareTrialsRequest.
type CompareTrialsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of objects containing trial and metrics information.
	Trials []*ComparableTrial `protobuf:"bytes,1,rep,name=trials,proto3" json:"trials,omitempty"`
}

func (x *CompareTrialsResponse) Reset() {
	*x = CompareTrialsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompareTrialsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompareTrialsResponse) ProtoMessage() {}

func (x *CompareTrialsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompareTrialsResponse.ProtoReflect.Descriptor instead.
func (*CompareTrialsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{33}
}

func (x *CompareTrialsResponse) GetTrials() []*ComparableTrial {
	if x != nil {
		return x.Trials
	}
	return nil
}

// Long poll for updates to the preemption status for an allocation.
type AllocationPreemptionSignalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the allocation.
	AllocationId string `protobuf:"bytes,1,opt,name=allocation_id,json=allocationId,proto3" json:"allocation_id,omitempty"`
	// The timeout in seconds.
	TimeoutSeconds int32 `protobuf:"varint,2,opt,name=timeout_seconds,json=timeoutSeconds,proto3" json:"timeout_seconds,omitempty"`
}

func (x *AllocationPreemptionSignalRequest) Reset() {
	*x = AllocationPreemptionSignalRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationPreemptionSignalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationPreemptionSignalRequest) ProtoMessage() {}

func (x *AllocationPreemptionSignalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationPreemptionSignalRequest.ProtoReflect.Descriptor instead.
func (*AllocationPreemptionSignalRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{34}
}

func (x *AllocationPreemptionSignalRequest) GetAllocationId() string {
	if x != nil {
		return x.AllocationId
	}
	return ""
}

func (x *AllocationPreemptionSignalRequest) GetTimeoutSeconds() int32 {
	if x != nil {
		return x.TimeoutSeconds
	}
	return 0
}

// Response to AllocationPreemptionSignalRequest.
type AllocationPreemptionSignalResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// True if signaling preempt, otherwise just a synchronization marker.
	Preempt bool `protobuf:"varint,1,opt,name=preempt,proto3" json:"preempt,omitempty"`
}

func (x *AllocationPreemptionSignalResponse) Reset() {
	*x = AllocationPreemptionSignalResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationPreemptionSignalResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationPreemptionSignalResponse) ProtoMessage() {}

func (x *AllocationPreemptionSignalResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationPreemptionSignalResponse.ProtoReflect.Descriptor instead.
func (*AllocationPreemptionSignalResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{35}
}

func (x *AllocationPreemptionSignalResponse) GetPreempt() bool {
	if x != nil {
		return x.Preempt
	}
	return false
}

// Acknowledge the receipt of some stop signal.
type AckAllocationPreemptionSignalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The allocation that is acknowledging the request.
	AllocationId string `protobuf:"bytes,1,opt,name=allocation_id,json=allocationId,proto3" json:"allocation_id,omitempty"`
}

func (x *AckAllocationPreemptionSignalRequest) Reset() {
	*x = AckAllocationPreemptionSignalRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AckAllocationPreemptionSignalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AckAllocationPreemptionSignalRequest) ProtoMessage() {}

func (x *AckAllocationPreemptionSignalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AckAllocationPreemptionSignalRequest.ProtoReflect.Descriptor instead.
func (*AckAllocationPreemptionSignalRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{36}
}

func (x *AckAllocationPreemptionSignalRequest) GetAllocationId() string {
	if x != nil {
		return x.AllocationId
	}
	return ""
}

// Allocation has been notified of a pending preemption
type AllocationPendingPreemptionSignalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the allocation.
	AllocationId string `protobuf:"bytes,1,opt,name=allocation_id,json=allocationId,proto3" json:"allocation_id,omitempty"`
}

func (x *AllocationPendingPreemptionSignalRequest) Reset() {
	*x = AllocationPendingPreemptionSignalRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationPendingPreemptionSignalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationPendingPreemptionSignalRequest) ProtoMessage() {}

func (x *AllocationPendingPreemptionSignalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationPendingPreemptionSignalRequest.ProtoReflect.Descriptor instead.
func (*AllocationPendingPreemptionSignalRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{37}
}

func (x *AllocationPendingPreemptionSignalRequest) GetAllocationId() string {
	if x != nil {
		return x.AllocationId
	}
	return ""
}

// Response to AllocationPendingPreemptionSignalRequest
type AllocationPendingPreemptionSignalResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AllocationPendingPreemptionSignalResponse) Reset() {
	*x = AllocationPendingPreemptionSignalResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationPendingPreemptionSignalResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationPendingPreemptionSignalResponse) ProtoMessage() {}

func (x *AllocationPendingPreemptionSignalResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationPendingPreemptionSignalResponse.ProtoReflect.Descriptor instead.
func (*AllocationPendingPreemptionSignalResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{38}
}

// Response to AckAllocationPreemptionSignalRequest.
type AckAllocationPreemptionSignalResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AckAllocationPreemptionSignalResponse) Reset() {
	*x = AckAllocationPreemptionSignalResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AckAllocationPreemptionSignalResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AckAllocationPreemptionSignalResponse) ProtoMessage() {}

func (x *AckAllocationPreemptionSignalResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AckAllocationPreemptionSignalResponse.ProtoReflect.Descriptor instead.
func (*AckAllocationPreemptionSignalResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{39}
}

// Mark some reservation as a daemon.
type MarkAllocationResourcesDaemonRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the allocation.
	AllocationId string `protobuf:"bytes,1,opt,name=allocation_id,json=allocationId,proto3" json:"allocation_id,omitempty"`
	// The id of the clump of resources to mark as daemon.
	ResourcesId string `protobuf:"bytes,2,opt,name=resources_id,json=resourcesId,proto3" json:"resources_id,omitempty"`
}

func (x *MarkAllocationResourcesDaemonRequest) Reset() {
	*x = MarkAllocationResourcesDaemonRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MarkAllocationResourcesDaemonRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MarkAllocationResourcesDaemonRequest) ProtoMessage() {}

func (x *MarkAllocationResourcesDaemonRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MarkAllocationResourcesDaemonRequest.ProtoReflect.Descriptor instead.
func (*MarkAllocationResourcesDaemonRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{40}
}

func (x *MarkAllocationResourcesDaemonRequest) GetAllocationId() string {
	if x != nil {
		return x.AllocationId
	}
	return ""
}

func (x *MarkAllocationResourcesDaemonRequest) GetResourcesId() string {
	if x != nil {
		return x.ResourcesId
	}
	return ""
}

// Response to MarkAllocationResourcesDaemonRequest.
type MarkAllocationResourcesDaemonResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *MarkAllocationResourcesDaemonResponse) Reset() {
	*x = MarkAllocationResourcesDaemonResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MarkAllocationResourcesDaemonResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MarkAllocationResourcesDaemonResponse) ProtoMessage() {}

func (x *MarkAllocationResourcesDaemonResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MarkAllocationResourcesDaemonResponse.ProtoReflect.Descriptor instead.
func (*MarkAllocationResourcesDaemonResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{41}
}

// Gathers the rendezvous info for an allocation.
type AllocationRendezvousInfoRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the allocation.
	AllocationId string `protobuf:"bytes,1,opt,name=allocation_id,json=allocationId,proto3" json:"allocation_id,omitempty"`
	// The id of the clump of resources.
	ResourcesId string `protobuf:"bytes,2,opt,name=resources_id,json=resourcesId,proto3" json:"resources_id,omitempty"`
}

func (x *AllocationRendezvousInfoRequest) Reset() {
	*x = AllocationRendezvousInfoRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationRendezvousInfoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationRendezvousInfoRequest) ProtoMessage() {}

func (x *AllocationRendezvousInfoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationRendezvousInfoRequest.ProtoReflect.Descriptor instead.
func (*AllocationRendezvousInfoRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{42}
}

func (x *AllocationRendezvousInfoRequest) GetAllocationId() string {
	if x != nil {
		return x.AllocationId
	}
	return ""
}

func (x *AllocationRendezvousInfoRequest) GetResourcesId() string {
	if x != nil {
		return x.ResourcesId
	}
	return ""
}

// Response to AllocationRendezvousInfoRequest
type AllocationRendezvousInfoResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The rendezvous information.
	RendezvousInfo *trialv1.RendezvousInfo `protobuf:"bytes,1,opt,name=rendezvous_info,json=rendezvousInfo,proto3" json:"rendezvous_info,omitempty"`
}

func (x *AllocationRendezvousInfoResponse) Reset() {
	*x = AllocationRendezvousInfoResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationRendezvousInfoResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationRendezvousInfoResponse) ProtoMessage() {}

func (x *AllocationRendezvousInfoResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationRendezvousInfoResponse.ProtoReflect.Descriptor instead.
func (*AllocationRendezvousInfoResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{43}
}

func (x *AllocationRendezvousInfoResponse) GetRendezvousInfo() *trialv1.RendezvousInfo {
	if x != nil {
		return x.RendezvousInfo
	}
	return nil
}

// Set the proxy address for some allocation.
type PostAllocationProxyAddressRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the allocation.
	AllocationId string `protobuf:"bytes,1,opt,name=allocation_id,json=allocationId,proto3" json:"allocation_id,omitempty"`
	// The address of the host where the service is, w.r.t. the master.
	ProxyAddress string `protobuf:"bytes,2,opt,name=proxy_address,json=proxyAddress,proto3" json:"proxy_address,omitempty"`
}

func (x *PostAllocationProxyAddressRequest) Reset() {
	*x = PostAllocationProxyAddressRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PostAllocationProxyAddressRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PostAllocationProxyAddressRequest) ProtoMessage() {}

func (x *PostAllocationProxyAddressRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PostAllocationProxyAddressRequest.ProtoReflect.Descriptor instead.
func (*PostAllocationProxyAddressRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{44}
}

func (x *PostAllocationProxyAddressRequest) GetAllocationId() string {
	if x != nil {
		return x.AllocationId
	}
	return ""
}

func (x *PostAllocationProxyAddressRequest) GetProxyAddress() string {
	if x != nil {
		return x.ProxyAddress
	}
	return ""
}

// Response to PostAllocationProxyAddressRequest
type PostAllocationProxyAddressResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PostAllocationProxyAddressResponse) Reset() {
	*x = PostAllocationProxyAddressResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PostAllocationProxyAddressResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PostAllocationProxyAddressResponse) ProtoMessage() {}

func (x *PostAllocationProxyAddressResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PostAllocationProxyAddressResponse.ProtoReflect.Descriptor instead.
func (*PostAllocationProxyAddressResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{45}
}

// Set the accelerator data for some allocation.
type PostAllocationAcceleratorDataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the allocation.
	AllocationId string `protobuf:"bytes,1,opt,name=allocation_id,json=allocationId,proto3" json:"allocation_id,omitempty"`
	// The accelerator data used by the allocation.
	AcceleratorData *AcceleratorData `protobuf:"bytes,2,opt,name=accelerator_data,json=acceleratorData,proto3" json:"accelerator_data,omitempty"`
}

func (x *PostAllocationAcceleratorDataRequest) Reset() {
	*x = PostAllocationAcceleratorDataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PostAllocationAcceleratorDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PostAllocationAcceleratorDataRequest) ProtoMessage() {}

func (x *PostAllocationAcceleratorDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PostAllocationAcceleratorDataRequest.ProtoReflect.Descriptor instead.
func (*PostAllocationAcceleratorDataRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{46}
}

func (x *PostAllocationAcceleratorDataRequest) GetAllocationId() string {
	if x != nil {
		return x.AllocationId
	}
	return ""
}

func (x *PostAllocationAcceleratorDataRequest) GetAcceleratorData() *AcceleratorData {
	if x != nil {
		return x.AcceleratorData
	}
	return nil
}

// Response to PostAllocationAcceleratorDataRequest
type PostAllocationAcceleratorDataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PostAllocationAcceleratorDataResponse) Reset() {
	*x = PostAllocationAcceleratorDataResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PostAllocationAcceleratorDataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PostAllocationAcceleratorDataResponse) ProtoMessage() {}

func (x *PostAllocationAcceleratorDataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PostAllocationAcceleratorDataResponse.ProtoReflect.Descriptor instead.
func (*PostAllocationAcceleratorDataResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{47}
}

// Accelerator data for a given allocation
type AcceleratorData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the container.
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// The id of the allocation.
	AllocationId string `protobuf:"bytes,2,opt,name=allocation_id,json=allocationId,proto3" json:"allocation_id,omitempty"`
	// The name of the node the allocation is on.
	NodeName string `protobuf:"bytes,3,opt,name=node_name,json=nodeName,proto3" json:"node_name,omitempty"`
	// The id of the agent associated with the allocation.
	TaskId string `protobuf:"bytes,4,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	// The type of accelerator.
	AcceleratorType string `protobuf:"bytes,5,opt,name=accelerator_type,json=acceleratorType,proto3" json:"accelerator_type,omitempty"`
	// An array of UUIDs of the accelerators associated with the allocation.
	AcceleratorUuids []string `protobuf:"bytes,6,rep,name=accelerator_uuids,json=acceleratorUuids,proto3" json:"accelerator_uuids,omitempty"`
	// The name of the resource pool.
	ResourcePool string `protobuf:"bytes,7,opt,name=resource_pool,json=resourcePool,proto3" json:"resource_pool,omitempty"`
}

func (x *AcceleratorData) Reset() {
	*x = AcceleratorData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AcceleratorData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcceleratorData) ProtoMessage() {}

func (x *AcceleratorData) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcceleratorData.ProtoReflect.Descriptor instead.
func (*AcceleratorData) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{48}
}

func (x *AcceleratorData) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

func (x *AcceleratorData) GetAllocationId() string {
	if x != nil {
		return x.AllocationId
	}
	return ""
}

func (x *AcceleratorData) GetNodeName() string {
	if x != nil {
		return x.NodeName
	}
	return ""
}

func (x *AcceleratorData) GetTaskId() string {
	if x != nil {
		return x.TaskId
	}
	return ""
}

func (x *AcceleratorData) GetAcceleratorType() string {
	if x != nil {
		return x.AcceleratorType
	}
	return ""
}

func (x *AcceleratorData) GetAcceleratorUuids() []string {
	if x != nil {
		return x.AcceleratorUuids
	}
	return nil
}

func (x *AcceleratorData) GetResourcePool() string {
	if x != nil {
		return x.ResourcePool
	}
	return ""
}

// Arguments to an all gather.
type AllocationAllGatherRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the allocation.
	AllocationId string `protobuf:"bytes,1,opt,name=allocation_id,json=allocationId,proto3" json:"allocation_id,omitempty"`
	// The UUID of the participant in an all gather.
	RequestUuid string `protobuf:"bytes,2,opt,name=request_uuid,json=requestUuid,proto3" json:"request_uuid,omitempty"`
	// The number of process to wait for.
	NumPeers int32 `protobuf:"varint,3,opt,name=num_peers,json=numPeers,proto3" json:"num_peers,omitempty"`
	// The data from this process.
	Data *_struct.Struct `protobuf:"bytes,4,opt,name=data,proto3" json:"data,omitempty"`
}

func (x *AllocationAllGatherRequest) Reset() {
	*x = AllocationAllGatherRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationAllGatherRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationAllGatherRequest) ProtoMessage() {}

func (x *AllocationAllGatherRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationAllGatherRequest.ProtoReflect.Descriptor instead.
func (*AllocationAllGatherRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{49}
}

func (x *AllocationAllGatherRequest) GetAllocationId() string {
	if x != nil {
		return x.AllocationId
	}
	return ""
}

func (x *AllocationAllGatherRequest) GetRequestUuid() string {
	if x != nil {
		return x.RequestUuid
	}
	return ""
}

func (x *AllocationAllGatherRequest) GetNumPeers() int32 {
	if x != nil {
		return x.NumPeers
	}
	return 0
}

func (x *AllocationAllGatherRequest) GetData() *_struct.Struct {
	if x != nil {
		return x.Data
	}
	return nil
}

// Response to AllocationAllGatherResponse
type AllocationAllGatherResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The data for all the processes.
	Data []*_struct.Struct `protobuf:"bytes,1,rep,name=data,proto3" json:"data,omitempty"`
}

func (x *AllocationAllGatherResponse) Reset() {
	*x = AllocationAllGatherResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationAllGatherResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationAllGatherResponse) ProtoMessage() {}

func (x *AllocationAllGatherResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationAllGatherResponse.ProtoReflect.Descriptor instead.
func (*AllocationAllGatherResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{50}
}

func (x *AllocationAllGatherResponse) GetData() []*_struct.Struct {
	if x != nil {
		return x.Data
	}
	return nil
}

// Arguments to a notify container running.
type NotifyContainerRunningRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the allocation.
	AllocationId string `protobuf:"bytes,1,opt,name=allocation_id,json=allocationId,proto3" json:"allocation_id,omitempty"`
	// The UUID of the participant in a notify container running message.
	RequestUuid string `protobuf:"bytes,2,opt,name=request_uuid,json=requestUuid,proto3" json:"request_uuid,omitempty"`
	// The number of process to wait for.
	NumPeers int32 `protobuf:"varint,3,opt,name=num_peers,json=numPeers,proto3" json:"num_peers,omitempty"`
	// The container's rank.
	Rank int32 `protobuf:"varint,4,opt,name=rank,proto3" json:"rank,omitempty"`
	// The name of the node who sent the request
	NodeName string `protobuf:"bytes,5,opt,name=node_name,json=nodeName,proto3" json:"node_name,omitempty"`
	// The data from this process.
	Data *_struct.Struct `protobuf:"bytes,6,opt,name=data,proto3" json:"data,omitempty"`
}

func (x *NotifyContainerRunningRequest) Reset() {
	*x = NotifyContainerRunningRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NotifyContainerRunningRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotifyContainerRunningRequest) ProtoMessage() {}

func (x *NotifyContainerRunningRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotifyContainerRunningRequest.ProtoReflect.Descriptor instead.
func (*NotifyContainerRunningRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{51}
}

func (x *NotifyContainerRunningRequest) GetAllocationId() string {
	if x != nil {
		return x.AllocationId
	}
	return ""
}

func (x *NotifyContainerRunningRequest) GetRequestUuid() string {
	if x != nil {
		return x.RequestUuid
	}
	return ""
}

func (x *NotifyContainerRunningRequest) GetNumPeers() int32 {
	if x != nil {
		return x.NumPeers
	}
	return 0
}

func (x *NotifyContainerRunningRequest) GetRank() int32 {
	if x != nil {
		return x.Rank
	}
	return 0
}

func (x *NotifyContainerRunningRequest) GetNodeName() string {
	if x != nil {
		return x.NodeName
	}
	return ""
}

func (x *NotifyContainerRunningRequest) GetData() *_struct.Struct {
	if x != nil {
		return x.Data
	}
	return nil
}

// Response to NotifyContainerRunningResponse
type NotifyContainerRunningResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The data for all the processes.
	Data []*_struct.Struct `protobuf:"bytes,1,rep,name=data,proto3" json:"data,omitempty"`
}

func (x *NotifyContainerRunningResponse) Reset() {
	*x = NotifyContainerRunningResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NotifyContainerRunningResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotifyContainerRunningResponse) ProtoMessage() {}

func (x *NotifyContainerRunningResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotifyContainerRunningResponse.ProtoReflect.Descriptor instead.
func (*NotifyContainerRunningResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{52}
}

func (x *NotifyContainerRunningResponse) GetData() []*_struct.Struct {
	if x != nil {
		return x.Data
	}
	return nil
}

// Report a voluntary, permanent early exit to the searcher.
type ReportTrialSearcherEarlyExitRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the trial.
	TrialId int32 `protobuf:"varint,1,opt,name=trial_id,json=trialId,proto3" json:"trial_id,omitempty"`
	// The exit reason.
	EarlyExit *trialv1.TrialEarlyExit `protobuf:"bytes,2,opt,name=early_exit,json=earlyExit,proto3" json:"early_exit,omitempty"`
}

func (x *ReportTrialSearcherEarlyExitRequest) Reset() {
	*x = ReportTrialSearcherEarlyExitRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportTrialSearcherEarlyExitRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportTrialSearcherEarlyExitRequest) ProtoMessage() {}

func (x *ReportTrialSearcherEarlyExitRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportTrialSearcherEarlyExitRequest.ProtoReflect.Descriptor instead.
func (*ReportTrialSearcherEarlyExitRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{53}
}

func (x *ReportTrialSearcherEarlyExitRequest) GetTrialId() int32 {
	if x != nil {
		return x.TrialId
	}
	return 0
}

func (x *ReportTrialSearcherEarlyExitRequest) GetEarlyExit() *trialv1.TrialEarlyExit {
	if x != nil {
		return x.EarlyExit
	}
	return nil
}

// Response to ReportTrialSearcherEarlyExitRequest
type ReportTrialSearcherEarlyExitResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ReportTrialSearcherEarlyExitResponse) Reset() {
	*x = ReportTrialSearcherEarlyExitResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportTrialSearcherEarlyExitResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportTrialSearcherEarlyExitResponse) ProtoMessage() {}

func (x *ReportTrialSearcherEarlyExitResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportTrialSearcherEarlyExitResponse.ProtoReflect.Descriptor instead.
func (*ReportTrialSearcherEarlyExitResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{54}
}

// For bookkeeping, updates the progress of the trial as a percent torwards
// the training length requested of it by the searcher.
type ReportTrialProgressRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the trial.
	TrialId int32 `protobuf:"varint,1,opt,name=trial_id,json=trialId,proto3" json:"trial_id,omitempty"`
	// Total units completed by the trial, in terms of the unit used to configure
	// the searcher.
	Progress float64 `protobuf:"fixed64,2,opt,name=progress,proto3" json:"progress,omitempty"`
	// Indicator for if the passed progress is raw and we want to skip any
	// calculation by searcher. Default to false.
	IsRaw bool `protobuf:"varint,3,opt,name=is_raw,json=isRaw,proto3" json:"is_raw,omitempty"`
}

func (x *ReportTrialProgressRequest) Reset() {
	*x = ReportTrialProgressRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportTrialProgressRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportTrialProgressRequest) ProtoMessage() {}

func (x *ReportTrialProgressRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportTrialProgressRequest.ProtoReflect.Descriptor instead.
func (*ReportTrialProgressRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{55}
}

func (x *ReportTrialProgressRequest) GetTrialId() int32 {
	if x != nil {
		return x.TrialId
	}
	return 0
}

func (x *ReportTrialProgressRequest) GetProgress() float64 {
	if x != nil {
		return x.Progress
	}
	return 0
}

func (x *ReportTrialProgressRequest) GetIsRaw() bool {
	if x != nil {
		return x.IsRaw
	}
	return false
}

// Response to ReportTrialProgressRequest
type ReportTrialProgressResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ReportTrialProgressResponse) Reset() {
	*x = ReportTrialProgressResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportTrialProgressResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportTrialProgressResponse) ProtoMessage() {}

func (x *ReportTrialProgressResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportTrialProgressResponse.ProtoReflect.Descriptor instead.
func (*ReportTrialProgressResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{56}
}

// Persist the given metrics for the trial.
type ReportTrialMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The metrics to persist.
	Metrics *trialv1.TrialMetrics `protobuf:"bytes,1,opt,name=metrics,proto3" json:"metrics,omitempty"`
	// The type of metrics to persist eg 'training', 'validation', etc.
	Group string `protobuf:"bytes,2,opt,name=group,proto3" json:"group,omitempty"`
}

func (x *ReportTrialMetricsRequest) Reset() {
	*x = ReportTrialMetricsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportTrialMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportTrialMetricsRequest) ProtoMessage() {}

func (x *ReportTrialMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportTrialMetricsRequest.ProtoReflect.Descriptor instead.
func (*ReportTrialMetricsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{57}
}

func (x *ReportTrialMetricsRequest) GetMetrics() *trialv1.TrialMetrics {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *ReportTrialMetricsRequest) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

// Response to ReportTrialMetricsRequest
type ReportTrialMetricsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ReportTrialMetricsResponse) Reset() {
	*x = ReportTrialMetricsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportTrialMetricsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportTrialMetricsResponse) ProtoMessage() {}

func (x *ReportTrialMetricsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportTrialMetricsResponse.ProtoReflect.Descriptor instead.
func (*ReportTrialMetricsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{58}
}

// Persist the given training metrics for the trial.
type ReportTrialTrainingMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The training metrics to persist.
	TrainingMetrics *trialv1.TrialMetrics `protobuf:"bytes,1,opt,name=training_metrics,json=trainingMetrics,proto3" json:"training_metrics,omitempty"`
}

func (x *ReportTrialTrainingMetricsRequest) Reset() {
	*x = ReportTrialTrainingMetricsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportTrialTrainingMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportTrialTrainingMetricsRequest) ProtoMessage() {}

func (x *ReportTrialTrainingMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportTrialTrainingMetricsRequest.ProtoReflect.Descriptor instead.
func (*ReportTrialTrainingMetricsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{59}
}

func (x *ReportTrialTrainingMetricsRequest) GetTrainingMetrics() *trialv1.TrialMetrics {
	if x != nil {
		return x.TrainingMetrics
	}
	return nil
}

// Response to ReportTrialTrainingMetricsRequest
type ReportTrialTrainingMetricsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ReportTrialTrainingMetricsResponse) Reset() {
	*x = ReportTrialTrainingMetricsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportTrialTrainingMetricsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportTrialTrainingMetricsResponse) ProtoMessage() {}

func (x *ReportTrialTrainingMetricsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportTrialTrainingMetricsResponse.ProtoReflect.Descriptor instead.
func (*ReportTrialTrainingMetricsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{60}
}

// Persist the given validation metrics for the trial.
type ReportTrialValidationMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The training metrics to persist.
	ValidationMetrics *trialv1.TrialMetrics `protobuf:"bytes,1,opt,name=validation_metrics,json=validationMetrics,proto3" json:"validation_metrics,omitempty"`
}

func (x *ReportTrialValidationMetricsRequest) Reset() {
	*x = ReportTrialValidationMetricsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportTrialValidationMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportTrialValidationMetricsRequest) ProtoMessage() {}

func (x *ReportTrialValidationMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportTrialValidationMetricsRequest.ProtoReflect.Descriptor instead.
func (*ReportTrialValidationMetricsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{61}
}

func (x *ReportTrialValidationMetricsRequest) GetValidationMetrics() *trialv1.TrialMetrics {
	if x != nil {
		return x.ValidationMetrics
	}
	return nil
}

// Response to ReportTrialValidationMetricsRequest
type ReportTrialValidationMetricsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ReportTrialValidationMetricsResponse) Reset() {
	*x = ReportTrialValidationMetricsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportTrialValidationMetricsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportTrialValidationMetricsResponse) ProtoMessage() {}

func (x *ReportTrialValidationMetricsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportTrialValidationMetricsResponse.ProtoReflect.Descriptor instead.
func (*ReportTrialValidationMetricsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{62}
}

// Partially update the trial metadata.
type PostTrialRunnerMetadataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the trial.
	TrialId int32 `protobuf:"varint,1,opt,name=trial_id,json=trialId,proto3" json:"trial_id,omitempty"`
	// The state for the trial runner.
	Metadata *trialv1.TrialRunnerMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *PostTrialRunnerMetadataRequest) Reset() {
	*x = PostTrialRunnerMetadataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PostTrialRunnerMetadataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PostTrialRunnerMetadataRequest) ProtoMessage() {}

func (x *PostTrialRunnerMetadataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PostTrialRunnerMetadataRequest.ProtoReflect.Descriptor instead.
func (*PostTrialRunnerMetadataRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{63}
}

func (x *PostTrialRunnerMetadataRequest) GetTrialId() int32 {
	if x != nil {
		return x.TrialId
	}
	return 0
}

func (x *PostTrialRunnerMetadataRequest) GetMetadata() *trialv1.TrialRunnerMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// Response to PatchTrialMetadataRequest
type PostTrialRunnerMetadataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PostTrialRunnerMetadataResponse) Reset() {
	*x = PostTrialRunnerMetadataResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PostTrialRunnerMetadataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PostTrialRunnerMetadataResponse) ProtoMessage() {}

func (x *PostTrialRunnerMetadataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PostTrialRunnerMetadataResponse.ProtoReflect.Descriptor instead.
func (*PostTrialRunnerMetadataResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{64}
}

// Stream training metrics.
type GetMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Trial IDs to get metrics for.
	TrialIds []int32 `protobuf:"varint,1,rep,packed,name=trial_ids,json=trialIds,proto3" json:"trial_ids,omitempty"`
	// The group of metrics to get eg 'training', 'validation', etc.
	Group string `protobuf:"bytes,2,opt,name=group,proto3" json:"group,omitempty"`
}

func (x *GetMetricsRequest) Reset() {
	*x = GetMetricsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetricsRequest) ProtoMessage() {}

func (x *GetMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetricsRequest.ProtoReflect.Descriptor instead.
func (*GetMetricsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{65}
}

func (x *GetMetricsRequest) GetTrialIds() []int32 {
	if x != nil {
		return x.TrialIds
	}
	return nil
}

func (x *GetMetricsRequest) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

// Response to GetMetricsRequest.
type GetMetricsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Metric response.
	Metrics []*trialv1.MetricsReport `protobuf:"bytes,1,rep,name=metrics,proto3" json:"metrics,omitempty"`
}

func (x *GetMetricsResponse) Reset() {
	*x = GetMetricsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMetricsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetricsResponse) ProtoMessage() {}

func (x *GetMetricsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetricsResponse.ProtoReflect.Descriptor instead.
func (*GetMetricsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{66}
}

func (x *GetMetricsResponse) GetMetrics() []*trialv1.MetricsReport {
	if x != nil {
		return x.Metrics
	}
	return nil
}

// Stream training metrics.
type GetTrainingMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Trial IDs to get metrics for.
	TrialIds []int32 `protobuf:"varint,1,rep,packed,name=trial_ids,json=trialIds,proto3" json:"trial_ids,omitempty"`
}

func (x *GetTrainingMetricsRequest) Reset() {
	*x = GetTrainingMetricsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTrainingMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTrainingMetricsRequest) ProtoMessage() {}

func (x *GetTrainingMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTrainingMetricsRequest.ProtoReflect.Descriptor instead.
func (*GetTrainingMetricsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{67}
}

func (x *GetTrainingMetricsRequest) GetTrialIds() []int32 {
	if x != nil {
		return x.TrialIds
	}
	return nil
}

// Response to GetTrainingMetricsRequest.
type GetTrainingMetricsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Metric response.
	Metrics []*trialv1.MetricsReport `protobuf:"bytes,1,rep,name=metrics,proto3" json:"metrics,omitempty"`
}

func (x *GetTrainingMetricsResponse) Reset() {
	*x = GetTrainingMetricsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTrainingMetricsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTrainingMetricsResponse) ProtoMessage() {}

func (x *GetTrainingMetricsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTrainingMetricsResponse.ProtoReflect.Descriptor instead.
func (*GetTrainingMetricsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{68}
}

func (x *GetTrainingMetricsResponse) GetMetrics() []*trialv1.MetricsReport {
	if x != nil {
		return x.Metrics
	}
	return nil
}

// Stream validation metrics.
type GetValidationMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Trial IDs to get metrics for.
	TrialIds []int32 `protobuf:"varint,1,rep,packed,name=trial_ids,json=trialIds,proto3" json:"trial_ids,omitempty"`
}

func (x *GetValidationMetricsRequest) Reset() {
	*x = GetValidationMetricsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetValidationMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetValidationMetricsRequest) ProtoMessage() {}

func (x *GetValidationMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetValidationMetricsRequest.ProtoReflect.Descriptor instead.
func (*GetValidationMetricsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{69}
}

func (x *GetValidationMetricsRequest) GetTrialIds() []int32 {
	if x != nil {
		return x.TrialIds
	}
	return nil
}

// Response to GetTrainingMetricsRequest.
type GetValidationMetricsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Metric response.
	Metrics []*trialv1.MetricsReport `protobuf:"bytes,1,rep,name=metrics,proto3" json:"metrics,omitempty"`
}

func (x *GetValidationMetricsResponse) Reset() {
	*x = GetValidationMetricsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetValidationMetricsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetValidationMetricsResponse) ProtoMessage() {}

func (x *GetValidationMetricsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetValidationMetricsResponse.ProtoReflect.Descriptor instead.
func (*GetValidationMetricsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{70}
}

func (x *GetValidationMetricsResponse) GetMetrics() []*trialv1.MetricsReport {
	if x != nil {
		return x.Metrics
	}
	return nil
}

// Create a trial.
type CreateTrialRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the parent experiment.
	ExperimentId int32 `protobuf:"varint,2,opt,name=experiment_id,json=experimentId,proto3" json:"experiment_id,omitempty"`
	// Trial hyperparameters.
	Hparams *_struct.Struct `protobuf:"bytes,6,opt,name=hparams,proto3" json:"hparams,omitempty"`
	// Currently only unmanaged trials are supported, must be true.
	Unmanaged bool `protobuf:"varint,40,opt,name=unmanaged,proto3" json:"unmanaged,omitempty"`
}

func (x *CreateTrialRequest) Reset() {
	*x = CreateTrialRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTrialRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTrialRequest) ProtoMessage() {}

func (x *CreateTrialRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTrialRequest.ProtoReflect.Descriptor instead.
func (*CreateTrialRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{71}
}

func (x *CreateTrialRequest) GetExperimentId() int32 {
	if x != nil {
		return x.ExperimentId
	}
	return 0
}

func (x *CreateTrialRequest) GetHparams() *_struct.Struct {
	if x != nil {
		return x.Hparams
	}
	return nil
}

func (x *CreateTrialRequest) GetUnmanaged() bool {
	if x != nil {
		return x.Unmanaged
	}
	return false
}

// Response to CreateTrialRequest.
type CreateTrialResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested trial.
	Trial *trialv1.Trial `protobuf:"bytes,1,opt,name=trial,proto3" json:"trial,omitempty"`
}

func (x *CreateTrialResponse) Reset() {
	*x = CreateTrialResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTrialResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTrialResponse) ProtoMessage() {}

func (x *CreateTrialResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTrialResponse.ProtoReflect.Descriptor instead.
func (*CreateTrialResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{72}
}

func (x *CreateTrialResponse) GetTrial() *trialv1.Trial {
	if x != nil {
		return x.Trial
	}
	return nil
}

// Put a trial.
type PutTrialRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// CreateTrialRequest payload.
	CreateTrialRequest *CreateTrialRequest `protobuf:"bytes,1,opt,name=create_trial_request,json=createTrialRequest,proto3" json:"create_trial_request,omitempty"`
	// External trial id.
	ExternalTrialId string `protobuf:"bytes,41,opt,name=external_trial_id,json=externalTrialId,proto3" json:"external_trial_id,omitempty"`
}

func (x *PutTrialRequest) Reset() {
	*x = PutTrialRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PutTrialRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PutTrialRequest) ProtoMessage() {}

func (x *PutTrialRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PutTrialRequest.ProtoReflect.Descriptor instead.
func (*PutTrialRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{73}
}

func (x *PutTrialRequest) GetCreateTrialRequest() *CreateTrialRequest {
	if x != nil {
		return x.CreateTrialRequest
	}
	return nil
}

func (x *PutTrialRequest) GetExternalTrialId() string {
	if x != nil {
		return x.ExternalTrialId
	}
	return ""
}

// Response to PutTrialRequest.
type PutTrialResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested trial.
	Trial *trialv1.Trial `protobuf:"bytes,1,opt,name=trial,proto3" json:"trial,omitempty"`
}

func (x *PutTrialResponse) Reset() {
	*x = PutTrialResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PutTrialResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PutTrialResponse) ProtoMessage() {}

func (x *PutTrialResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PutTrialResponse.ProtoReflect.Descriptor instead.
func (*PutTrialResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{74}
}

func (x *PutTrialResponse) GetTrial() *trialv1.Trial {
	if x != nil {
		return x.Trial
	}
	return nil
}

// Patch a trial.
type PatchTrialRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Trial id.
	TrialId int32 `protobuf:"varint,1,opt,name=trial_id,json=trialId,proto3" json:"trial_id,omitempty"`
	// The state of the trial.
	State *trialv1.State `protobuf:"varint,2,opt,name=state,proto3,enum=determined.trial.v1.State,oneof" json:"state,omitempty"`
}

func (x *PatchTrialRequest) Reset() {
	*x = PatchTrialRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchTrialRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchTrialRequest) ProtoMessage() {}

func (x *PatchTrialRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchTrialRequest.ProtoReflect.Descriptor instead.
func (*PatchTrialRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{75}
}

func (x *PatchTrialRequest) GetTrialId() int32 {
	if x != nil {
		return x.TrialId
	}
	return 0
}

func (x *PatchTrialRequest) GetState() trialv1.State {
	if x != nil && x.State != nil {
		return *x.State
	}
	return trialv1.State_STATE_UNSPECIFIED
}

// Response to PatchTrialRequest.
type PatchTrialResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested trial.
	Trial *trialv1.Trial `protobuf:"bytes,1,opt,name=trial,proto3" json:"trial,omitempty"`
}

func (x *PatchTrialResponse) Reset() {
	*x = PatchTrialResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchTrialResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchTrialResponse) ProtoMessage() {}

func (x *PatchTrialResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchTrialResponse.ProtoReflect.Descriptor instead.
func (*PatchTrialResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{76}
}

func (x *PatchTrialResponse) GetTrial() *trialv1.Trial {
	if x != nil {
		return x.Trial
	}
	return nil
}

// Start a trial.
type StartTrialRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Trial id.
	TrialId int32 `protobuf:"varint,1,opt,name=trial_id,json=trialId,proto3" json:"trial_id,omitempty"`
	// Whether resume is allowed.
	Resume bool `protobuf:"varint,2,opt,name=resume,proto3" json:"resume,omitempty"`
}

func (x *StartTrialRequest) Reset() {
	*x = StartTrialRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartTrialRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartTrialRequest) ProtoMessage() {}

func (x *StartTrialRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartTrialRequest.ProtoReflect.Descriptor instead.
func (*StartTrialRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{77}
}

func (x *StartTrialRequest) GetTrialId() int32 {
	if x != nil {
		return x.TrialId
	}
	return 0
}

func (x *StartTrialRequest) GetResume() bool {
	if x != nil {
		return x.Resume
	}
	return false
}

// Response to StartTrialRequest.
type StartTrialResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Trial run id.
	TrialRunId int32 `protobuf:"varint,1,opt,name=trial_run_id,json=trialRunId,proto3" json:"trial_run_id,omitempty"`
	// Latest checkpoint.
	LatestCheckpoint *string `protobuf:"bytes,2,opt,name=latest_checkpoint,json=latestCheckpoint,proto3,oneof" json:"latest_checkpoint,omitempty"`
	// Steps completed.
	StepsCompleted int32 `protobuf:"varint,3,opt,name=steps_completed,json=stepsCompleted,proto3" json:"steps_completed,omitempty"`
}

func (x *StartTrialResponse) Reset() {
	*x = StartTrialResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartTrialResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartTrialResponse) ProtoMessage() {}

func (x *StartTrialResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartTrialResponse.ProtoReflect.Descriptor instead.
func (*StartTrialResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{78}
}

func (x *StartTrialResponse) GetTrialRunId() int32 {
	if x != nil {
		return x.TrialRunId
	}
	return 0
}

func (x *StartTrialResponse) GetLatestCheckpoint() string {
	if x != nil && x.LatestCheckpoint != nil {
		return *x.LatestCheckpoint
	}
	return ""
}

func (x *StartTrialResponse) GetStepsCompleted() int32 {
	if x != nil {
		return x.StepsCompleted
	}
	return 0
}

// Create a TrialSourceInfo
type ReportTrialSourceInfoRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the TrialSourceInfo
	TrialSourceInfo *trialv1.TrialSourceInfo `protobuf:"bytes,1,opt,name=trial_source_info,json=trialSourceInfo,proto3" json:"trial_source_info,omitempty"`
}

func (x *ReportTrialSourceInfoRequest) Reset() {
	*x = ReportTrialSourceInfoRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportTrialSourceInfoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportTrialSourceInfoRequest) ProtoMessage() {}

func (x *ReportTrialSourceInfoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportTrialSourceInfoRequest.ProtoReflect.Descriptor instead.
func (*ReportTrialSourceInfoRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{79}
}

func (x *ReportTrialSourceInfoRequest) GetTrialSourceInfo() *trialv1.TrialSourceInfo {
	if x != nil {
		return x.TrialSourceInfo
	}
	return nil
}

// Response to making a TrialSourceInfo
type ReportTrialSourceInfoResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Trial ID of the created
	TrialId int32 `protobuf:"varint,1,opt,name=trial_id,json=trialId,proto3" json:"trial_id,omitempty"`
	// UUID of the checkpoint.
	CheckpointUuid string `protobuf:"bytes,2,opt,name=checkpoint_uuid,json=checkpointUuid,proto3" json:"checkpoint_uuid,omitempty"`
}

func (x *ReportTrialSourceInfoResponse) Reset() {
	*x = ReportTrialSourceInfoResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_trial_proto_msgTypes[80]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportTrialSourceInfoResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportTrialSourceInfoResponse) ProtoMessage() {}

func (x *ReportTrialSourceInfoResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_trial_proto_msgTypes[80]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportTrialSourceInfoResponse.ProtoReflect.Descriptor instead.
func (*ReportTrialSourceInfoResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_trial_proto_rawDescGZIP(), []int{80}
}

func (x *ReportTrialSourceInfoResponse) GetTrialId() int32 {
	if x != nil {
		return x.TrialId
	}
	return 0
}

func (x *ReportTrialSourceInfoResponse) GetCheckpointUuid() string {
	if x != nil {
		return x.CheckpointUuid
	}
	return ""
}

var File_determined_api_v1_trial_proto protoreflect.FileDescriptor

var file_determined_api_v1_trial_proto_rawDesc = []byte{
	0x0a, 0x1d, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x76, 0x31, 0x2f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x11, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e,
	0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x21, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64,
	0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x65,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x27, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x65, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d,
	0x69, 0x6e, 0x65, 0x64, 0x2f, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x6f, 0x67, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65,
	0x64, 0x2f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x72, 0x69, 0x61, 0x6c,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e,
	0x65, 0x64, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x64, 0x65, 0x74, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x61,
	0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29,
	0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x63, 0x68, 0x65, 0x63, 0x6b,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x73, 0x77, 0x61, 0x67, 0x67, 0x65, 0x72, 0x2f, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb0, 0x01, 0x0a, 0x12, 0x44, 0x6f, 0x77, 0x6e,
	0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x30,
	0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x64,
	0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x35, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d,
	0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x3a, 0x1b, 0x92,
	0x41, 0x18, 0x0a, 0x16, 0xd2, 0x01, 0x04, 0x64, 0x61, 0x74, 0x61, 0xd2, 0x01, 0x04, 0x74, 0x79,
	0x70, 0x65, 0xd2, 0x01, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x22, 0xf6, 0x01, 0x0a, 0x11, 0x57,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x12, 0x42, 0x0a, 0x08, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x24, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e,
	0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52, 0x08, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x69, 0x6e, 0x67, 0x12, 0x46, 0x0a, 0x0a, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72,
	0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00,
	0x52, 0x0a, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x0a,
	0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72,
	0x69, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52, 0x0a, 0x63, 0x68, 0x65,
	0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x0a, 0x0a, 0x08, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x22, 0x63, 0x0a, 0x0c, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d,
	0x69, 0x6e, 0x65, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x75, 0x62, 0x6c, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x29, 0x0a, 0x08, 0x54, 0x72, 0x69, 0x61,
	0x6c, 0x54, 0x61, 0x67, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x3a, 0x0b, 0x92, 0x41, 0x08, 0x0a, 0x06, 0xd2, 0x01, 0x03,
	0x6b, 0x65, 0x79, 0x22, 0xbe, 0x02, 0x0a, 0x0b, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x53, 0x6f, 0x72,
	0x74, 0x65, 0x72, 0x12, 0x46, 0x0a, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69,
	0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c,
	0x53, 0x6f, 0x72, 0x74, 0x65, 0x72, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x52, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x12, 0x35, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x52,
	0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x7f, 0x0a, 0x09, 0x4e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x4e, 0x41, 0x4d, 0x45, 0x53, 0x50, 0x41,
	0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x15, 0x0a, 0x11, 0x4e, 0x41, 0x4d, 0x45, 0x53, 0x50, 0x41, 0x43, 0x45, 0x5f, 0x48, 0x50,
	0x41, 0x52, 0x41, 0x4d, 0x53, 0x10, 0x01, 0x12, 0x1e, 0x0a, 0x1a, 0x4e, 0x41, 0x4d, 0x45, 0x53,
	0x50, 0x41, 0x43, 0x45, 0x5f, 0x54, 0x52, 0x41, 0x49, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x4d, 0x45,
	0x54, 0x52, 0x49, 0x43, 0x53, 0x10, 0x02, 0x12, 0x20, 0x0a, 0x1c, 0x4e, 0x41, 0x4d, 0x45, 0x53,
	0x50, 0x41, 0x43, 0x45, 0x5f, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x4d, 0x45, 0x54, 0x52, 0x49, 0x43, 0x53, 0x10, 0x03, 0x3a, 0x19, 0x92, 0x41, 0x16, 0x0a, 0x14,
	0xd2, 0x01, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0xd2, 0x01, 0x05, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x22, 0xbc, 0x04, 0x0a, 0x10, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x4c, 0x6f,
	0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x69,
	0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x74, 0x72, 0x69,
	0x61, 0x6c, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x6f,
	0x6c, 0x6c, 0x6f, 0x77, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x66, 0x6f, 0x6c, 0x6c,
	0x6f, 0x77, 0x12, 0x1b, 0x0a, 0x09, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x73, 0x12,
	0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x73,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x49, 0x64, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x72, 0x61, 0x6e, 0x6b, 0x5f, 0x69, 0x64, 0x73,
	0x18, 0x08, 0x20, 0x03, 0x28, 0x05, 0x52, 0x07, 0x72, 0x61, 0x6e, 0x6b, 0x49, 0x64, 0x73, 0x12,
	0x33, 0x0a, 0x06, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0e, 0x32,
	0x1b, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x6c, 0x6f, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x06, 0x6c, 0x65,
	0x76, 0x65, 0x6c, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x74, 0x64, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x18, 0x0a, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x73, 0x74, 0x64, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x12, 0x18, 0x0a, 0x07, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x07, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x45, 0x0a, 0x10, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x65, 0x66, 0x6f, 0x72,
	0x65, 0x12, 0x43, 0x0a, 0x0f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x61,
	0x66, 0x74, 0x65, 0x72, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x41, 0x66, 0x74, 0x65, 0x72, 0x12, 0x35, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f,
	0x62, 0x79, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72,
	0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x64,
	0x65, 0x72, 0x42, 0x79, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x1f, 0x0a,
	0x0b, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x65, 0x78, 0x74, 0x12, 0x21,
	0x0a, 0x0c, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x67, 0x65, 0x78, 0x18, 0x10,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x67, 0x65,
	0x78, 0x3a, 0x10, 0x92, 0x41, 0x0d, 0x0a, 0x0b, 0xd2, 0x01, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c,
	0x5f, 0x69, 0x64, 0x22, 0x80, 0x04, 0x0a, 0x11, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x4c, 0x6f, 0x67,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x38, 0x0a, 0x09, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x12, 0x1c, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x12, 0x31, 0x0a, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x1b, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x6c, 0x6f,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x05, 0x6c,
	0x65, 0x76, 0x65, 0x6c, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x49, 0x64, 0x12,
	0x1e, 0x0a, 0x08, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x07, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12,
	0x26, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x1c, 0x0a, 0x07, 0x72, 0x61, 0x6e, 0x6b, 0x5f,
	0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x48, 0x02, 0x52, 0x06, 0x72, 0x61, 0x6e, 0x6b,
	0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x15, 0x0a, 0x03, 0x6c, 0x6f, 0x67, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x03, 0x52, 0x03, 0x6c, 0x6f, 0x67, 0x88, 0x01, 0x01, 0x12, 0x1b, 0x0a, 0x06,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x48, 0x04, 0x52, 0x06,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a, 0x07, 0x73, 0x74, 0x64,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x48, 0x05, 0x52, 0x07, 0x73, 0x74,
	0x64, 0x74, 0x79, 0x70, 0x65, 0x88, 0x01, 0x01, 0x3a, 0x33, 0x92, 0x41, 0x30, 0x0a, 0x2e, 0xd2,
	0x01, 0x02, 0x69, 0x64, 0xd2, 0x01, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0xd2, 0x01, 0x07, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0xd2, 0x01, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0xd2, 0x01, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x42, 0x0b, 0x0a,
	0x09, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x42, 0x0a, 0x0a, 0x08, 0x5f,
	0x72, 0x61, 0x6e, 0x6b, 0x5f, 0x69, 0x64, 0x42, 0x06, 0x0a, 0x04, 0x5f, 0x6c, 0x6f, 0x67, 0x42,
	0x09, 0x0a, 0x07, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x73,
	0x74, 0x64, 0x74, 0x79, 0x70, 0x65, 0x22, 0x5d, 0x0a, 0x16, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x4c,
	0x6f, 0x67, 0x73, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x07, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x66,
	0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x66, 0x6f, 0x6c,
	0x6c, 0x6f, 0x77, 0x3a, 0x10, 0x92, 0x41, 0x0d, 0x0a, 0x0b, 0xd2, 0x01, 0x08, 0x74, 0x72, 0x69,
	0x61, 0x6c, 0x5f, 0x69, 0x64, 0x22, 0xc2, 0x01, 0x0a, 0x17, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x4c,
	0x6f, 0x67, 0x73, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x1b, 0x0a, 0x09, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x73, 0x12, 0x23,
	0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x49, 0x64, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x72, 0x61, 0x6e, 0x6b, 0x5f, 0x69, 0x64, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x05, 0x52, 0x07, 0x72, 0x61, 0x6e, 0x6b, 0x49, 0x64, 0x73, 0x12, 0x1a,
	0x0a, 0x08, 0x73, 0x74, 0x64, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x08, 0x73, 0x74, 0x64, 0x74, 0x79, 0x70, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x3a, 0x14, 0x92, 0x41, 0x11, 0x0a, 0x0f, 0xd2, 0x01, 0x02, 0x69, 0x64,
	0xd2, 0x01, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xc3, 0x02, 0x0a, 0x1a, 0x47,
	0x65, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x02, 0x69, 0x64, 0x12, 0x44, 0x0a, 0x0c, 0x73, 0x6f, 0x72,
	0x74, 0x5f, 0x62, 0x79, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x20, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x63, 0x68, 0x65,
	0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x72, 0x74, 0x42,
	0x79, 0x48, 0x00, 0x52, 0x0a, 0x73, 0x6f, 0x72, 0x74, 0x42, 0x79, 0x41, 0x74, 0x74, 0x72, 0x12,
	0x26, 0x0a, 0x0e, 0x73, 0x6f, 0x72, 0x74, 0x5f, 0x62, 0x79, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x6f, 0x72, 0x74, 0x42,
	0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x35, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x5f, 0x62, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x64, 0x65, 0x74, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72,
	0x64, 0x65, 0x72, 0x42, 0x79, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x16,
	0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x37, 0x0a, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x64,
	0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x73, 0x42, 0x09, 0x0a, 0x07, 0x73, 0x6f, 0x72, 0x74, 0x5f, 0x62, 0x79,
	0x22, 0xc6, 0x01, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x46, 0x0a, 0x0b, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e,
	0x65, 0x64, 0x2e, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x0b, 0x63, 0x68, 0x65,
	0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x3d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64,
	0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x61, 0x67,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x20, 0x92, 0x41, 0x1d, 0x0a, 0x1b, 0xd2, 0x01,
	0x0b, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0xd2, 0x01, 0x0a, 0x70,
	0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x22, 0x0a, 0x10, 0x4b, 0x69, 0x6c,
	0x6c, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x02, 0x69, 0x64, 0x22, 0x13, 0x0a,
	0x11, 0x4b, 0x69, 0x6c, 0x6c, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x8c, 0x05, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4d, 0x0a, 0x07, 0x73, 0x6f, 0x72, 0x74, 0x5f, 0x62, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x34, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x53, 0x6f, 0x72, 0x74, 0x42, 0x79, 0x52, 0x06, 0x73, 0x6f, 0x72, 0x74, 0x42, 0x79,
	0x12, 0x35, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x52, 0x07,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12,
	0x14, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x37, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x65, 0x73, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e,
	0x65, 0x64, 0x2e, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x65, 0x73, 0x12, 0x23,
	0x0a, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x49, 0x64, 0x22, 0xc4, 0x02, 0x0a, 0x06, 0x53, 0x6f, 0x72, 0x74, 0x42, 0x79, 0x12, 0x17,
	0x0a, 0x13, 0x53, 0x4f, 0x52, 0x54, 0x5f, 0x42, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x4f, 0x52, 0x54, 0x5f,
	0x42, 0x59, 0x5f, 0x49, 0x44, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x4f, 0x52, 0x54, 0x5f,
	0x42, 0x59, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x04, 0x12,
	0x14, 0x0a, 0x10, 0x53, 0x4f, 0x52, 0x54, 0x5f, 0x42, 0x59, 0x5f, 0x45, 0x4e, 0x44, 0x5f, 0x54,
	0x49, 0x4d, 0x45, 0x10, 0x05, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x4f, 0x52, 0x54, 0x5f, 0x42, 0x59,
	0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x10, 0x06, 0x12, 0x22, 0x0a, 0x1e, 0x53, 0x4f, 0x52, 0x54,
	0x5f, 0x42, 0x59, 0x5f, 0x42, 0x45, 0x53, 0x54, 0x5f, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x45, 0x54, 0x52, 0x49, 0x43, 0x10, 0x07, 0x12, 0x24, 0x0a, 0x20,
	0x53, 0x4f, 0x52, 0x54, 0x5f, 0x42, 0x59, 0x5f, 0x4c, 0x41, 0x54, 0x45, 0x53, 0x54, 0x5f, 0x56,
	0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x45, 0x54, 0x52, 0x49, 0x43,
	0x10, 0x08, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x4f, 0x52, 0x54, 0x5f, 0x42, 0x59, 0x5f, 0x42, 0x41,
	0x54, 0x43, 0x48, 0x45, 0x53, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x45, 0x44, 0x10,
	0x09, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x4f, 0x52, 0x54, 0x5f, 0x42, 0x59, 0x5f, 0x44, 0x55, 0x52,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0a, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x4f, 0x52, 0x54, 0x5f,
	0x42, 0x59, 0x5f, 0x52, 0x45, 0x53, 0x54, 0x41, 0x52, 0x54, 0x53, 0x10, 0x0b, 0x12, 0x1b, 0x0a,
	0x17, 0x53, 0x4f, 0x52, 0x54, 0x5f, 0x42, 0x59, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x50, 0x4f,
	0x49, 0x4e, 0x54, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x10, 0x0c, 0x12, 0x1e, 0x0a, 0x1a, 0x53, 0x4f,
	0x52, 0x54, 0x5f, 0x42, 0x59, 0x5f, 0x4c, 0x4f, 0x47, 0x5f, 0x52, 0x45, 0x54, 0x45, 0x4e, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x41, 0x59, 0x53, 0x10, 0x0d, 0x3a, 0x15, 0x92, 0x41, 0x12, 0x0a,
	0x10, 0xd2, 0x01, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69,
	0x64, 0x22, 0xad, 0x01, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x32, 0x0a, 0x06, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74,
	0x72, 0x69, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x06, 0x74,
	0x72, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x3d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x65, 0x74, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61,
	0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x61, 0x67, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x1b, 0x92, 0x41, 0x18, 0x0a, 0x16, 0xd2, 0x01, 0x06, 0x74, 0x72,
	0x69, 0x61, 0x6c, 0x73, 0xd2, 0x01, 0x0a, 0x70, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x3a, 0x0a, 0x28, 0x47, 0x65, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x6d,
	0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x4c, 0x6f, 0x67, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x61, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x02, 0x69, 0x64, 0x22, 0x6a, 0x0a,
	0x29, 0x47, 0x65, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69,
	0x6e, 0x67, 0x4c, 0x6f, 0x67, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61,
	0x79, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2a, 0x0a, 0x0e, 0x72, 0x65,
	0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x48, 0x00, 0x52, 0x0d, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x44,
	0x61, 0x79, 0x73, 0x88, 0x01, 0x01, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x72, 0x65, 0x6d, 0x61, 0x69,
	0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x22, 0x2c, 0x0a, 0x0f, 0x47, 0x65, 0x74,
	0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x08,
	0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07,
	0x74, 0x72, 0x69, 0x61, 0x6c, 0x49, 0x64, 0x22, 0x53, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x54, 0x72,
	0x69, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x05, 0x74,
	0x72, 0x69, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x65, 0x74,
	0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x05, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x3a, 0x0d, 0x92,
	0x41, 0x0a, 0x0a, 0x08, 0xd2, 0x01, 0x05, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x22, 0x7f, 0x0a, 0x1b,
	0x47, 0x65, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x42, 0x79, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x49, 0x44, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x34, 0x0a, 0x16, 0x65,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x65, 0x78, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x49,
	0x64, 0x12, 0x2a, 0x0a, 0x11, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x74, 0x72,
	0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x65, 0x78,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x49, 0x64, 0x22, 0x5f, 0x0a,
	0x1c, 0x47, 0x65, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x42, 0x79, 0x45, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x49, 0x44, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a,
	0x05, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64,
	0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x05, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x3a,
	0x0d, 0x92, 0x41, 0x0a, 0x0a, 0x08, 0xd2, 0x01, 0x05, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x22, 0xfd,
	0x04, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x57, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x35, 0x0a, 0x08, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e,
	0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x42, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x69,
	0x6d, 0x69, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74,
	0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x07, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x73,
	0x6f, 0x72, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73,
	0x6f, 0x72, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x50, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69,
	0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x72,
	0x69, 0x61, 0x6c, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x15, 0x69, 0x6e, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x42, 0x0a, 0x0b,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x1d, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x3c, 0x0a, 0x1a, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65,
	0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x18, 0x72, 0x65, 0x6d, 0x6f,
	0x76, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x73, 0x22, 0x95, 0x01, 0x0a, 0x0c, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x19, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f,
	0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x4f,
	0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x50, 0x4f, 0x49, 0x4e, 0x54,
	0x10, 0x01, 0x12, 0x1c, 0x0a, 0x18, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x4f, 0x50, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02,
	0x12, 0x2a, 0x0a, 0x26, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x5f, 0x4f, 0x52, 0x5f,
	0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x3a, 0x10, 0x92, 0x41,
	0x0d, 0x0a, 0x0b, 0xd2, 0x01, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x22, 0xbe,
	0x01, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x57, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42, 0x0a, 0x09,
	0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x43, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x09, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73,
	0x12, 0x3d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65,
	0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a,
	0x1e, 0x92, 0x41, 0x1b, 0x0a, 0x19, 0xd2, 0x01, 0x09, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x73, 0xd2, 0x01, 0x0a, 0x70, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x90, 0x01, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e,
	0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x6f,
	0x6c, 0x6c, 0x6f, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x66, 0x6f, 0x6c, 0x6c,
	0x6f, 0x77, 0x3a, 0x0e, 0x92, 0x41, 0x0b, 0x0a, 0x09, 0xd2, 0x01, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x22, 0x76, 0x0a, 0x1f, 0x47, 0x65, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x05, 0x62, 0x61, 0x74, 0x63, 0x68, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65,
	0x64, 0x2e, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x52, 0x05, 0x62, 0x61, 0x74, 0x63, 0x68, 0x3a, 0x0d, 0x92, 0x41, 0x0a,
	0x0a, 0x08, 0xd2, 0x01, 0x05, 0x62, 0x61, 0x74, 0x63, 0x68, 0x22, 0x6d, 0x0a, 0x26, 0x47, 0x65,
	0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x72, 0x41, 0x76,
	0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x49, 0x64, 0x12,
	0x16, 0x0a, 0x06, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x06, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x3a, 0x10, 0x92, 0x41, 0x0d, 0x0a, 0x0b, 0xd2, 0x01,
	0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x22, 0x81, 0x01, 0x0a, 0x27, 0x47, 0x65,
	0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x72, 0x41, 0x76,
	0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e,
	0x65, 0x64, 0x2e, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x61,
	0x6c, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x3a, 0x0e, 0x92,
	0x41, 0x0b, 0x0a, 0x09, 0xd2, 0x01, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x22, 0x7f, 0x0a,
	0x24, 0x50, 0x6f, 0x73, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x07, 0x62, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69,
	0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69,
	0x61, 0x6c, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x07, 0x62, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x3a,
	0x0d, 0x92, 0x41, 0x0a, 0x0a, 0x08, 0xd2, 0x01, 0x05, 0x62, 0x61, 0x74, 0x63, 0x68, 0x22, 0x27,
	0x0a, 0x25, 0x50, 0x6f, 0x73, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x9d, 0x01, 0x0a, 0x0f, 0x43, 0x6f, 0x6d, 0x70,
	0x61, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x12, 0x30, 0x0a, 0x05, 0x74,
	0x72, 0x69, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x65, 0x74,
	0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x05, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x12, 0x3f, 0x0a,
	0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x64, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x17,
	0x92, 0x41, 0x14, 0x0a, 0x12, 0xd2, 0x01, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0xd2,
	0x01, 0x05, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x22, 0xb7, 0x03, 0x0a, 0x14, 0x43, 0x6f, 0x6d, 0x70,
	0x61, 0x72, 0x65, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x05, 0x52, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x49, 0x64, 0x73, 0x12, 0x25, 0x0a,
	0x0e, 0x6d, 0x61, 0x78, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x6d, 0x61, 0x78, 0x44, 0x61, 0x74, 0x61, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x42, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b,
	0x65, 0x6e, 0x64, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0a, 0x65, 0x6e, 0x64, 0x42, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x12, 0x42, 0x0a,
	0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x14, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x49, 0x64, 0x73, 0x12, 0x55, 0x0a, 0x12, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73,
	0x65, 0x72, 0x69, 0x65, 0x73, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x79, 0x6d, 0x6f,
	0x72, 0x70, 0x68, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x10, 0x74, 0x69, 0x6d,
	0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x3a, 0x22, 0x92,
	0x41, 0x1f, 0x0a, 0x1d, 0xd2, 0x01, 0x0e, 0x6d, 0x61, 0x78, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x73, 0xd2, 0x01, 0x09, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64,
	0x73, 0x22, 0x73, 0x0a, 0x19, 0x50, 0x75, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x74,
	0x61, 0x69, 0x6e, 0x4c, 0x6f, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19,
	0x0a, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x07, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6e, 0x75, 0x6d,
	0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x6e, 0x75, 0x6d,
	0x44, 0x61, 0x79, 0x73, 0x3a, 0x20, 0x92, 0x41, 0x1d, 0x0a, 0x1b, 0xd2, 0x01, 0x0d, 0x65, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x08, 0x6e, 0x75,
	0x6d, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x22, 0x1c, 0x0a, 0x1a, 0x50, 0x75, 0x74, 0x54, 0x72, 0x69,
	0x61, 0x6c, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6e, 0x4c, 0x6f, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x63, 0x0a, 0x15, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x65, 0x54,
	0x72, 0x69, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3a, 0x0a,
	0x06, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x72, 0x69, 0x61,
	0x6c, 0x52, 0x06, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x3a, 0x0e, 0x92, 0x41, 0x0b, 0x0a, 0x09,
	0xd2, 0x01, 0x06, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x22, 0x88, 0x01, 0x0a, 0x21, 0x41, 0x6c,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f,
	0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x74,
	0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x3a, 0x15, 0x92,
	0x41, 0x12, 0x0a, 0x10, 0xd2, 0x01, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x22, 0x3e, 0x0a, 0x22, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x69, 0x67, 0x6e,
	0x61, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72,
	0x65, 0x65, 0x6d, 0x70, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x70, 0x72, 0x65,
	0x65, 0x6d, 0x70, 0x74, 0x22, 0x62, 0x0a, 0x24, 0x41, 0x63, 0x6b, 0x41, 0x6c, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x69, 0x67, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d,
	0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x3a, 0x15, 0x92, 0x41, 0x12, 0x0a, 0x10, 0xd2, 0x01, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x22, 0x66, 0x0a, 0x28, 0x41, 0x6c, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65,
	0x65, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x6c, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x3a, 0x15, 0x92, 0x41, 0x12, 0x0a, 0x10,
	0xd2, 0x01, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x22, 0x2b, 0x0a, 0x29, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x69, 0x67, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x27, 0x0a,
	0x25, 0x41, 0x63, 0x6b, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x94, 0x01, 0x0a, 0x24, 0x4d, 0x61, 0x72, 0x6b, 0x41,
	0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x44, 0x61, 0x65, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x49, 0x64, 0x3a, 0x24, 0x92, 0x41, 0x21, 0x0a, 0x1f, 0xd2, 0x01,
	0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0xd2, 0x01,
	0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x22, 0x27, 0x0a,
	0x25, 0x4d, 0x61, 0x72, 0x6b, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x44, 0x61, 0x65, 0x6d, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x8f, 0x01, 0x0a, 0x1f, 0x41, 0x6c, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x6e, 0x64, 0x65, 0x7a, 0x76, 0x6f, 0x75, 0x73, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12,
	0x21, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x49, 0x64, 0x3a, 0x24, 0x92, 0x41, 0x21, 0x0a, 0x1f, 0xd2, 0x01, 0x0d, 0x61, 0x6c, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x0c, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x5f, 0x69, 0x64, 0x22, 0x89, 0x01, 0x0a, 0x20, 0x41, 0x6c, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x6e, 0x64, 0x65, 0x7a, 0x76, 0x6f, 0x75,
	0x73, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4c, 0x0a,
	0x0f, 0x72, 0x65, 0x6e, 0x64, 0x65, 0x7a, 0x76, 0x6f, 0x75, 0x73, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69,
	0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6e,
	0x64, 0x65, 0x7a, 0x76, 0x6f, 0x75, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0e, 0x72, 0x65, 0x6e,
	0x64, 0x65, 0x7a, 0x76, 0x6f, 0x75, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x3a, 0x17, 0x92, 0x41, 0x14,
	0x0a, 0x12, 0xd2, 0x01, 0x0f, 0x72, 0x65, 0x6e, 0x64, 0x65, 0x7a, 0x76, 0x6f, 0x75, 0x73, 0x5f,
	0x69, 0x6e, 0x66, 0x6f, 0x22, 0x6d, 0x0a, 0x21, 0x50, 0x6f, 0x73, 0x74, 0x41, 0x6c, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x41, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x23,
	0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x41, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x22, 0x24, 0x0a, 0x22, 0x50, 0x6f, 0x73, 0x74, 0x41, 0x6c, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xc4, 0x01, 0x0a, 0x24, 0x50, 0x6f,
	0x73, 0x74, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x63, 0x65,
	0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x4d, 0x0a, 0x10, 0x61, 0x63, 0x63, 0x65, 0x6c,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x22, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x44, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x44, 0x61, 0x74, 0x61, 0x3a, 0x28, 0x92, 0x41, 0x25, 0x0a, 0x23, 0xd2, 0x01, 0x0d,
	0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x10,
	0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x22, 0x27, 0x0a, 0x25, 0x50, 0x6f, 0x73, 0x74, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x44, 0x61, 0x74,
	0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x8c, 0x02, 0x0a, 0x0f, 0x41, 0x63,
	0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x44, 0x61, 0x74, 0x61, 0x12, 0x21, 0x0a,
	0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6e, 0x6f, 0x64, 0x65, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x12, 0x29, 0x0a, 0x10, 0x61,
	0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x75, 0x75, 0x69, 0x64, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x10, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x55, 0x75,
	0x69, 0x64, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x22, 0xe0, 0x01, 0x0a, 0x1a, 0x41, 0x6c, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6c, 0x6c, 0x47, 0x61, 0x74, 0x68, 0x65, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x75, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x55, 0x75, 0x69, 0x64, 0x12,
	0x1b, 0x0a, 0x09, 0x6e, 0x75, 0x6d, 0x5f, 0x70, 0x65, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x6e, 0x75, 0x6d, 0x50, 0x65, 0x65, 0x72, 0x73, 0x12, 0x2b, 0x0a, 0x04,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x3a, 0x30, 0x92, 0x41, 0x2d, 0x0a, 0x2b,
	0xd2, 0x01, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0xd2, 0x01, 0x11, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x5f, 0x72, 0x65, 0x63, 0x76, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0xd2, 0x01, 0x04, 0x64, 0x61, 0x74, 0x61, 0x22, 0x58, 0x0a, 0x1b, 0x41,
	0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6c, 0x6c, 0x47, 0x61, 0x74, 0x68,
	0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2b, 0x0a, 0x04, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x3a, 0x0c, 0x92, 0x41, 0x09, 0x0a, 0x07, 0xd2, 0x01,
	0x04, 0x64, 0x61, 0x74, 0x61, 0x22, 0x94, 0x02, 0x0a, 0x1d, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x79,
	0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x75, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x55, 0x75, 0x69, 0x64, 0x12,
	0x1b, 0x0a, 0x09, 0x6e, 0x75, 0x6d, 0x5f, 0x70, 0x65, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x6e, 0x75, 0x6d, 0x50, 0x65, 0x65, 0x72, 0x73, 0x12, 0x12, 0x0a, 0x04,
	0x72, 0x61, 0x6e, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x72, 0x61, 0x6e, 0x6b,
	0x12, 0x1b, 0x0a, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x6e, 0x6f, 0x64, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a,
	0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x3a, 0x30, 0x92, 0x41, 0x2d, 0x0a,
	0x2b, 0xd2, 0x01, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0xd2, 0x01, 0x11, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x5f, 0x72, 0x65, 0x63, 0x76, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0xd2, 0x01, 0x04, 0x64, 0x61, 0x74, 0x61, 0x22, 0x5b, 0x0a, 0x1e,
	0x4e, 0x6f, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2b,
	0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x3a, 0x0c, 0x92, 0x41, 0x09,
	0x0a, 0x07, 0xd2, 0x01, 0x04, 0x64, 0x61, 0x74, 0x61, 0x22, 0x9f, 0x01, 0x0a, 0x23, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65,
	0x72, 0x45, 0x61, 0x72, 0x6c, 0x79, 0x45, 0x78, 0x69, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x07, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x49, 0x64, 0x12, 0x42, 0x0a, 0x0a,
	0x65, 0x61, 0x72, 0x6c, 0x79, 0x5f, 0x65, 0x78, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x23, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72,
	0x69, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x45, 0x61, 0x72, 0x6c,
	0x79, 0x45, 0x78, 0x69, 0x74, 0x52, 0x09, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x45, 0x78, 0x69, 0x74,
	0x3a, 0x19, 0x92, 0x41, 0x16, 0x0a, 0x14, 0xd2, 0x01, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f,
	0x69, 0x64, 0xd2, 0x01, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x22, 0x26, 0x0a, 0x24, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x65, 0x72, 0x45, 0x61, 0x72, 0x6c, 0x79, 0x45, 0x78, 0x69, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x87, 0x01, 0x0a, 0x1a, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x72,
	0x69, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x49, 0x64, 0x12, 0x1a, 0x0a,
	0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x15, 0x0a, 0x06, 0x69, 0x73, 0x5f,
	0x72, 0x61, 0x77, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x69, 0x73, 0x52, 0x61, 0x77,
	0x3a, 0x1b, 0x92, 0x41, 0x18, 0x0a, 0x16, 0xd2, 0x01, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f,
	0x69, 0x64, 0xd2, 0x01, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x22, 0x1d, 0x0a,
	0x1b, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x87, 0x01, 0x0a,
	0x19, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x07, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x64, 0x65,
	0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x07,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x3a, 0x17, 0x92,
	0x41, 0x14, 0x0a, 0x12, 0xd2, 0x01, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0xd2, 0x01,
	0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x1c, 0x0a, 0x1a, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x54, 0x72, 0x69, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x8b, 0x01, 0x0a, 0x21, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x54,
	0x72, 0x69, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x10, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65,
	0x64, 0x2e, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x0f, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e,
	0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x18, 0x92, 0x41, 0x15, 0x0a, 0x13, 0xd2,
	0x01, 0x10, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x22, 0x24, 0x0a, 0x22, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x72, 0x69, 0x61,
	0x6c, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x93, 0x01, 0x0a, 0x23, 0x52, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x50, 0x0a, 0x12, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x64,
	0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52,
	0x11, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x3a, 0x1a, 0x92, 0x41, 0x17, 0x0a, 0x15, 0xd2, 0x01, 0x12, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x22, 0x26,
	0x0a, 0x24, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x9e, 0x01, 0x0a, 0x1e, 0x50, 0x6f, 0x73, 0x74, 0x54,
	0x72, 0x69, 0x61, 0x6c, 0x52, 0x75, 0x6e, 0x6e, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x69,
	0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x74, 0x72, 0x69,
	0x61, 0x6c, 0x49, 0x64, 0x12, 0x44, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69,
	0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69,
	0x61, 0x6c, 0x52, 0x75, 0x6e, 0x6e, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x3a, 0x1b, 0x92, 0x41, 0x18, 0x0a,
	0x16, 0xd2, 0x01, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x21, 0x0a, 0x1f, 0x50, 0x6f, 0x73, 0x74, 0x54,
	0x72, 0x69, 0x61, 0x6c, 0x52, 0x75, 0x6e, 0x6e, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x7f, 0x0a, 0x11, 0x47, 0x65,
	0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x2c, 0x0a, 0x09, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x05, 0x42, 0x0f, 0x92, 0x41, 0x0c, 0xd2, 0x01, 0x09, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f,
	0x69, 0x64, 0x73, 0x52, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x49, 0x64, 0x73, 0x12, 0x21, 0x0a,
	0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0x92, 0x41,
	0x08, 0xd2, 0x01, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x3a, 0x19, 0x92, 0x41, 0x16, 0x0a, 0x14, 0xd2, 0x01, 0x09, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f,
	0x69, 0x64, 0x73, 0xd2, 0x01, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x63, 0x0a, 0x12, 0x47,
	0x65, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x3c, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e,
	0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a,
	0x0f, 0x92, 0x41, 0x0c, 0x0a, 0x0a, 0xd2, 0x01, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x22, 0x4b, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x05,
	0x52, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x49, 0x64, 0x73, 0x3a, 0x11, 0x92, 0x41, 0x0e, 0x0a,
	0x0c, 0xd2, 0x01, 0x09, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x73, 0x22, 0x6b, 0x0a,
	0x1a, 0x47, 0x65, 0x74, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x07, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x64,
	0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x0f, 0x92, 0x41, 0x0c, 0x0a, 0x0a,
	0xd2, 0x01, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x22, 0x4d, 0x0a, 0x1b, 0x47, 0x65,
	0x74, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x72, 0x69,
	0x61, 0x6c, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x05, 0x52, 0x08, 0x74, 0x72,
	0x69, 0x61, 0x6c, 0x49, 0x64, 0x73, 0x3a, 0x11, 0x92, 0x41, 0x0e, 0x0a, 0x0c, 0xd2, 0x01, 0x09,
	0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x73, 0x22, 0x6d, 0x0a, 0x1c, 0x47, 0x65, 0x74,
	0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x07, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x64, 0x65, 0x74,
	0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x07,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x0f, 0x92, 0x41, 0x0c, 0x0a, 0x0a, 0xd2, 0x01,
	0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x22, 0x8a, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x23, 0x0a, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x49, 0x64, 0x12, 0x31, 0x0a, 0x07, 0x68, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x07,
	0x68, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x75, 0x6e, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x64, 0x18, 0x28, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x75, 0x6e, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x64, 0x22, 0x56, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x72, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x05,
	0x74, 0x72, 0x69, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x65,
	0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x05, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x3a, 0x0d,
	0x92, 0x41, 0x0a, 0x0a, 0x08, 0xd2, 0x01, 0x05, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x22, 0x96, 0x01,
	0x0a, 0x0f, 0x50, 0x75, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x57, 0x0a, 0x14, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x72, 0x69, 0x61,
	0x6c, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x12, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x72,
	0x69, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2a, 0x0a, 0x11, 0x65, 0x78,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18,
	0x29, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x54,
	0x72, 0x69, 0x61, 0x6c, 0x49, 0x64, 0x22, 0x53, 0x0a, 0x10, 0x50, 0x75, 0x74, 0x54, 0x72, 0x69,
	0x61, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x05, 0x74, 0x72,
	0x69, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x65, 0x74, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x05, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x3a, 0x0d, 0x92, 0x41,
	0x0a, 0x0a, 0x08, 0xd2, 0x01, 0x05, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x22, 0x81, 0x01, 0x0a, 0x11,
	0x50, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x07, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x49, 0x64, 0x12, 0x35, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x64, 0x65,
	0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x88, 0x01, 0x01, 0x3a, 0x10, 0x92, 0x41, 0x0d, 0x0a, 0x0b, 0xd2, 0x01, 0x08, 0x74, 0x72, 0x69,
	0x61, 0x6c, 0x5f, 0x69, 0x64, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22,
	0x55, 0x0a, 0x12, 0x50, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x05, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65,
	0x64, 0x2e, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c,
	0x52, 0x05, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x3a, 0x0d, 0x92, 0x41, 0x0a, 0x0a, 0x08, 0xd2, 0x01,
	0x05, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x22, 0x58, 0x0a, 0x11, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54,
	0x72, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x74,
	0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x74,
	0x72, 0x69, 0x61, 0x6c, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x3a, 0x10,
	0x92, 0x41, 0x0d, 0x0a, 0x0b, 0xd2, 0x01, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64,
	0x22, 0xcf, 0x01, 0x0a, 0x12, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x20, 0x0a, 0x0c, 0x74, 0x72, 0x69, 0x61, 0x6c,
	0x5f, 0x72, 0x75, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x74,
	0x72, 0x69, 0x61, 0x6c, 0x52, 0x75, 0x6e, 0x49, 0x64, 0x12, 0x30, 0x0a, 0x11, 0x6c, 0x61, 0x74,
	0x65, 0x73, 0x74, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x10, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x27, 0x0a, 0x0f, 0x73,
	0x74, 0x65, 0x70, 0x73, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x73, 0x74, 0x65, 0x70, 0x73, 0x43, 0x6f, 0x6d, 0x70, 0x6c,
	0x65, 0x74, 0x65, 0x64, 0x3a, 0x26, 0x92, 0x41, 0x23, 0x0a, 0x21, 0xd2, 0x01, 0x0c, 0x74, 0x72,
	0x69, 0x61, 0x6c, 0x5f, 0x72, 0x75, 0x6e, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x0f, 0x73, 0x74, 0x65,
	0x70, 0x73, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x42, 0x14, 0x0a, 0x12,
	0x5f, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x22, 0x8b, 0x01, 0x0a, 0x1c, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x72, 0x69,
	0x61, 0x6c, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x11, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72, 0x69, 0x61,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x3a, 0x19, 0x92, 0x41, 0x16, 0x0a, 0x14, 0xd2, 0x01, 0x11, 0x74,
	0x72, 0x69, 0x61, 0x6c, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x22, 0x87, 0x01, 0x0a, 0x1d, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x49, 0x64, 0x12, 0x27, 0x0a,
	0x0f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x75, 0x75, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x55, 0x75, 0x69, 0x64, 0x3a, 0x22, 0x92, 0x41, 0x1f, 0x0a, 0x1d, 0xd2, 0x01, 0x08,
	0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x0f, 0x63, 0x68, 0x65, 0x63, 0x6b,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x75, 0x75, 0x69, 0x64, 0x42, 0x35, 0x5a, 0x33, 0x67, 0x69,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69,
	0x6e, 0x65, 0x64, 0x2d, 0x61, 0x69, 0x2f, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65,
	0x64, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_determined_api_v1_trial_proto_rawDescOnce sync.Once
	file_determined_api_v1_trial_proto_rawDescData = file_determined_api_v1_trial_proto_rawDesc
)

func file_determined_api_v1_trial_proto_rawDescGZIP() []byte {
	file_determined_api_v1_trial_proto_rawDescOnce.Do(func() {
		file_determined_api_v1_trial_proto_rawDescData = protoimpl.X.CompressGZIP(file_determined_api_v1_trial_proto_rawDescData)
	})
	return file_determined_api_v1_trial_proto_rawDescData
}

var file_determined_api_v1_trial_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_determined_api_v1_trial_proto_msgTypes = make([]protoimpl.MessageInfo, 81)
var file_determined_api_v1_trial_proto_goTypes = []interface{}{
	(TrialSorter_Namespace)(0),                        // 0: determined.api.v1.TrialSorter.Namespace
	(GetExperimentTrialsRequest_SortBy)(0),            // 1: determined.api.v1.GetExperimentTrialsRequest.SortBy
	(GetTrialWorkloadsRequest_FilterOption)(0),        // 2: determined.api.v1.GetTrialWorkloadsRequest.FilterOption
	(*DownsampledMetrics)(nil),                        // 3: determined.api.v1.DownsampledMetrics
	(*WorkloadContainer)(nil),                         // 4: determined.api.v1.WorkloadContainer
	(*ColumnFilter)(nil),                              // 5: determined.api.v1.ColumnFilter
	(*TrialTag)(nil),                                  // 6: determined.api.v1.TrialTag
	(*TrialSorter)(nil),                               // 7: determined.api.v1.TrialSorter
	(*TrialLogsRequest)(nil),                          // 8: determined.api.v1.TrialLogsRequest
	(*TrialLogsResponse)(nil),                         // 9: determined.api.v1.TrialLogsResponse
	(*TrialLogsFieldsRequest)(nil),                    // 10: determined.api.v1.TrialLogsFieldsRequest
	(*TrialLogsFieldsResponse)(nil),                   // 11: determined.api.v1.TrialLogsFieldsResponse
	(*GetTrialCheckpointsRequest)(nil),                // 12: determined.api.v1.GetTrialCheckpointsRequest
	(*GetTrialCheckpointsResponse)(nil),               // 13: determined.api.v1.GetTrialCheckpointsResponse
	(*KillTrialRequest)(nil),                          // 14: determined.api.v1.KillTrialRequest
	(*KillTrialResponse)(nil),                         // 15: determined.api.v1.KillTrialResponse
	(*GetExperimentTrialsRequest)(nil),                // 16: determined.api.v1.GetExperimentTrialsRequest
	(*GetExperimentTrialsResponse)(nil),               // 17: determined.api.v1.GetExperimentTrialsResponse
	(*GetTrialRemainingLogRetentionDaysRequest)(nil),  // 18: determined.api.v1.GetTrialRemainingLogRetentionDaysRequest
	(*GetTrialRemainingLogRetentionDaysResponse)(nil), // 19: determined.api.v1.GetTrialRemainingLogRetentionDaysResponse
	(*GetTrialRequest)(nil),                           // 20: determined.api.v1.GetTrialRequest
	(*GetTrialResponse)(nil),                          // 21: determined.api.v1.GetTrialResponse
	(*GetTrialByExternalIDRequest)(nil),               // 22: determined.api.v1.GetTrialByExternalIDRequest
	(*GetTrialByExternalIDResponse)(nil),              // 23: determined.api.v1.GetTrialByExternalIDResponse
	(*GetTrialWorkloadsRequest)(nil),                  // 24: determined.api.v1.GetTrialWorkloadsRequest
	(*GetTrialWorkloadsResponse)(nil),                 // 25: determined.api.v1.GetTrialWorkloadsResponse
	(*GetTrialProfilerMetricsRequest)(nil),            // 26: determined.api.v1.GetTrialProfilerMetricsRequest
	(*GetTrialProfilerMetricsResponse)(nil),           // 27: determined.api.v1.GetTrialProfilerMetricsResponse
	(*GetTrialProfilerAvailableSeriesRequest)(nil),    // 28: determined.api.v1.GetTrialProfilerAvailableSeriesRequest
	(*GetTrialProfilerAvailableSeriesResponse)(nil),   // 29: determined.api.v1.GetTrialProfilerAvailableSeriesResponse
	(*PostTrialProfilerMetricsBatchRequest)(nil),      // 30: determined.api.v1.PostTrialProfilerMetricsBatchRequest
	(*PostTrialProfilerMetricsBatchResponse)(nil),     // 31: determined.api.v1.PostTrialProfilerMetricsBatchResponse
	(*ComparableTrial)(nil),                           // 32: determined.api.v1.ComparableTrial
	(*CompareTrialsRequest)(nil),                      // 33: determined.api.v1.CompareTrialsRequest
	(*PutTrialRetainLogsRequest)(nil),                 // 34: determined.api.v1.PutTrialRetainLogsRequest
	(*PutTrialRetainLogsResponse)(nil),                // 35: determined.api.v1.PutTrialRetainLogsResponse
	(*CompareTrialsResponse)(nil),                     // 36: determined.api.v1.CompareTrialsResponse
	(*AllocationPreemptionSignalRequest)(nil),         // 37: determined.api.v1.AllocationPreemptionSignalRequest
	(*AllocationPreemptionSignalResponse)(nil),        // 38: determined.api.v1.AllocationPreemptionSignalResponse
	(*AckAllocationPreemptionSignalRequest)(nil),      // 39: determined.api.v1.AckAllocationPreemptionSignalRequest
	(*AllocationPendingPreemptionSignalRequest)(nil),  // 40: determined.api.v1.AllocationPendingPreemptionSignalRequest
	(*AllocationPendingPreemptionSignalResponse)(nil), // 41: determined.api.v1.AllocationPendingPreemptionSignalResponse
	(*AckAllocationPreemptionSignalResponse)(nil),     // 42: determined.api.v1.AckAllocationPreemptionSignalResponse
	(*MarkAllocationResourcesDaemonRequest)(nil),      // 43: determined.api.v1.MarkAllocationResourcesDaemonRequest
	(*MarkAllocationResourcesDaemonResponse)(nil),     // 44: determined.api.v1.MarkAllocationResourcesDaemonResponse
	(*AllocationRendezvousInfoRequest)(nil),           // 45: determined.api.v1.AllocationRendezvousInfoRequest
	(*AllocationRendezvousInfoResponse)(nil),          // 46: determined.api.v1.AllocationRendezvousInfoResponse
	(*PostAllocationProxyAddressRequest)(nil),         // 47: determined.api.v1.PostAllocationProxyAddressRequest
	(*PostAllocationProxyAddressResponse)(nil),        // 48: determined.api.v1.PostAllocationProxyAddressResponse
	(*PostAllocationAcceleratorDataRequest)(nil),      // 49: determined.api.v1.PostAllocationAcceleratorDataRequest
	(*PostAllocationAcceleratorDataResponse)(nil),     // 50: determined.api.v1.PostAllocationAcceleratorDataResponse
	(*AcceleratorData)(nil),                           // 51: determined.api.v1.AcceleratorData
	(*AllocationAllGatherRequest)(nil),                // 52: determined.api.v1.AllocationAllGatherRequest
	(*AllocationAllGatherResponse)(nil),               // 53: determined.api.v1.AllocationAllGatherResponse
	(*NotifyContainerRunningRequest)(nil),             // 54: determined.api.v1.NotifyContainerRunningRequest
	(*NotifyContainerRunningResponse)(nil),            // 55: determined.api.v1.NotifyContainerRunningResponse
	(*ReportTrialSearcherEarlyExitRequest)(nil),       // 56: determined.api.v1.ReportTrialSearcherEarlyExitRequest
	(*ReportTrialSearcherEarlyExitResponse)(nil),      // 57: determined.api.v1.ReportTrialSearcherEarlyExitResponse
	(*ReportTrialProgressRequest)(nil),                // 58: determined.api.v1.ReportTrialProgressRequest
	(*ReportTrialProgressResponse)(nil),               // 59: determined.api.v1.ReportTrialProgressResponse
	(*ReportTrialMetricsRequest)(nil),                 // 60: determined.api.v1.ReportTrialMetricsRequest
	(*ReportTrialMetricsResponse)(nil),                // 61: determined.api.v1.ReportTrialMetricsResponse
	(*ReportTrialTrainingMetricsRequest)(nil),         // 62: determined.api.v1.ReportTrialTrainingMetricsRequest
	(*ReportTrialTrainingMetricsResponse)(nil),        // 63: determined.api.v1.ReportTrialTrainingMetricsResponse
	(*ReportTrialValidationMetricsRequest)(nil),       // 64: determined.api.v1.ReportTrialValidationMetricsRequest
	(*ReportTrialValidationMetricsResponse)(nil),      // 65: determined.api.v1.ReportTrialValidationMetricsResponse
	(*PostTrialRunnerMetadataRequest)(nil),            // 66: determined.api.v1.PostTrialRunnerMetadataRequest
	(*PostTrialRunnerMetadataResponse)(nil),           // 67: determined.api.v1.PostTrialRunnerMetadataResponse
	(*GetMetricsRequest)(nil),                         // 68: determined.api.v1.GetMetricsRequest
	(*GetMetricsResponse)(nil),                        // 69: determined.api.v1.GetMetricsResponse
	(*GetTrainingMetricsRequest)(nil),                 // 70: determined.api.v1.GetTrainingMetricsRequest
	(*GetTrainingMetricsResponse)(nil),                // 71: determined.api.v1.GetTrainingMetricsResponse
	(*GetValidationMetricsRequest)(nil),               // 72: determined.api.v1.GetValidationMetricsRequest
	(*GetValidationMetricsResponse)(nil),              // 73: determined.api.v1.GetValidationMetricsResponse
	(*CreateTrialRequest)(nil),                        // 74: determined.api.v1.CreateTrialRequest
	(*CreateTrialResponse)(nil),                       // 75: determined.api.v1.CreateTrialResponse
	(*PutTrialRequest)(nil),                           // 76: determined.api.v1.PutTrialRequest
	(*PutTrialResponse)(nil),                          // 77: determined.api.v1.PutTrialResponse
	(*PatchTrialRequest)(nil),                         // 78: determined.api.v1.PatchTrialRequest
	(*PatchTrialResponse)(nil),                        // 79: determined.api.v1.PatchTrialResponse
	(*StartTrialRequest)(nil),                         // 80: determined.api.v1.StartTrialRequest
	(*StartTrialResponse)(nil),                        // 81: determined.api.v1.StartTrialResponse
	(*ReportTrialSourceInfoRequest)(nil),              // 82: determined.api.v1.ReportTrialSourceInfoRequest
	(*ReportTrialSourceInfoResponse)(nil),             // 83: determined.api.v1.ReportTrialSourceInfoResponse
	(*DataPoint)(nil),                                 // 84: determined.api.v1.DataPoint
	(MetricType)(0),                                   // 85: determined.api.v1.MetricType
	(*trialv1.MetricsWorkload)(nil),                   // 86: determined.trial.v1.MetricsWorkload
	(*trialv1.CheckpointWorkload)(nil),                // 87: determined.trial.v1.CheckpointWorkload
	(*commonv1.DoubleFieldFilter)(nil),                // 88: determined.common.v1.DoubleFieldFilter
	(OrderBy)(0),                                      // 89: determined.api.v1.OrderBy
	(logv1.LogLevel)(0),                               // 90: determined.log.v1.LogLevel
	(*timestamp.Timestamp)(nil),                       // 91: google.protobuf.Timestamp
	(checkpointv1.SortBy)(0),                          // 92: determined.checkpoint.v1.SortBy
	(checkpointv1.State)(0),                           // 93: determined.checkpoint.v1.State
	(*checkpointv1.Checkpoint)(nil),                   // 94: determined.checkpoint.v1.Checkpoint
	(*Pagination)(nil),                                // 95: determined.api.v1.Pagination
	(experimentv1.State)(0),                           // 96: determined.experiment.v1.State
	(*trialv1.Trial)(nil),                             // 97: determined.trial.v1.Trial
	(*trialv1.TrialProfilerMetricLabels)(nil),         // 98: determined.trial.v1.TrialProfilerMetricLabels
	(*trialv1.TrialProfilerMetricsBatch)(nil),         // 99: determined.trial.v1.TrialProfilerMetricsBatch
	(*commonv1.PolymorphicFilter)(nil),                // 100: determined.common.v1.PolymorphicFilter
	(*trialv1.RendezvousInfo)(nil),                    // 101: determined.trial.v1.RendezvousInfo
	(*_struct.Struct)(nil),                            // 102: google.protobuf.Struct
	(*trialv1.TrialEarlyExit)(nil),                    // 103: determined.trial.v1.TrialEarlyExit
	(*trialv1.TrialMetrics)(nil),                      // 104: determined.trial.v1.TrialMetrics
	(*trialv1.TrialRunnerMetadata)(nil),               // 105: determined.trial.v1.TrialRunnerMetadata
	(*trialv1.MetricsReport)(nil),                     // 106: determined.trial.v1.MetricsReport
	(trialv1.State)(0),                                // 107: determined.trial.v1.State
	(*trialv1.TrialSourceInfo)(nil),                   // 108: determined.trial.v1.TrialSourceInfo
}
var file_determined_api_v1_trial_proto_depIdxs = []int32{
	84,  // 0: determined.api.v1.DownsampledMetrics.data:type_name -> determined.api.v1.DataPoint
	85,  // 1: determined.api.v1.DownsampledMetrics.type:type_name -> determined.api.v1.MetricType
	86,  // 2: determined.api.v1.WorkloadContainer.training:type_name -> determined.trial.v1.MetricsWorkload
	86,  // 3: determined.api.v1.WorkloadContainer.validation:type_name -> determined.trial.v1.MetricsWorkload
	87,  // 4: determined.api.v1.WorkloadContainer.checkpoint:type_name -> determined.trial.v1.CheckpointWorkload
	88,  // 5: determined.api.v1.ColumnFilter.filter:type_name -> determined.common.v1.DoubleFieldFilter
	0,   // 6: determined.api.v1.TrialSorter.namespace:type_name -> determined.api.v1.TrialSorter.Namespace
	89,  // 7: determined.api.v1.TrialSorter.order_by:type_name -> determined.api.v1.OrderBy
	90,  // 8: determined.api.v1.TrialLogsRequest.levels:type_name -> determined.log.v1.LogLevel
	91,  // 9: determined.api.v1.TrialLogsRequest.timestamp_before:type_name -> google.protobuf.Timestamp
	91,  // 10: determined.api.v1.TrialLogsRequest.timestamp_after:type_name -> google.protobuf.Timestamp
	89,  // 11: determined.api.v1.TrialLogsRequest.order_by:type_name -> determined.api.v1.OrderBy
	91,  // 12: determined.api.v1.TrialLogsResponse.timestamp:type_name -> google.protobuf.Timestamp
	90,  // 13: determined.api.v1.TrialLogsResponse.level:type_name -> determined.log.v1.LogLevel
	92,  // 14: determined.api.v1.GetTrialCheckpointsRequest.sort_by_attr:type_name -> determined.checkpoint.v1.SortBy
	89,  // 15: determined.api.v1.GetTrialCheckpointsRequest.order_by:type_name -> determined.api.v1.OrderBy
	93,  // 16: determined.api.v1.GetTrialCheckpointsRequest.states:type_name -> determined.checkpoint.v1.State
	94,  // 17: determined.api.v1.GetTrialCheckpointsResponse.checkpoints:type_name -> determined.checkpoint.v1.Checkpoint
	95,  // 18: determined.api.v1.GetTrialCheckpointsResponse.pagination:type_name -> determined.api.v1.Pagination
	1,   // 19: determined.api.v1.GetExperimentTrialsRequest.sort_by:type_name -> determined.api.v1.GetExperimentTrialsRequest.SortBy
	89,  // 20: determined.api.v1.GetExperimentTrialsRequest.order_by:type_name -> determined.api.v1.OrderBy
	96,  // 21: determined.api.v1.GetExperimentTrialsRequest.states:type_name -> determined.experiment.v1.State
	97,  // 22: determined.api.v1.GetExperimentTrialsResponse.trials:type_name -> determined.trial.v1.Trial
	95,  // 23: determined.api.v1.GetExperimentTrialsResponse.pagination:type_name -> determined.api.v1.Pagination
	97,  // 24: determined.api.v1.GetTrialResponse.trial:type_name -> determined.trial.v1.Trial
	97,  // 25: determined.api.v1.GetTrialByExternalIDResponse.trial:type_name -> determined.trial.v1.Trial
	89,  // 26: determined.api.v1.GetTrialWorkloadsRequest.order_by:type_name -> determined.api.v1.OrderBy
	2,   // 27: determined.api.v1.GetTrialWorkloadsRequest.filter:type_name -> determined.api.v1.GetTrialWorkloadsRequest.FilterOption
	85,  // 28: determined.api.v1.GetTrialWorkloadsRequest.metric_type:type_name -> determined.api.v1.MetricType
	4,   // 29: determined.api.v1.GetTrialWorkloadsResponse.workloads:type_name -> determined.api.v1.WorkloadContainer
	95,  // 30: determined.api.v1.GetTrialWorkloadsResponse.pagination:type_name -> determined.api.v1.Pagination
	98,  // 31: determined.api.v1.GetTrialProfilerMetricsRequest.labels:type_name -> determined.trial.v1.TrialProfilerMetricLabels
	99,  // 32: determined.api.v1.GetTrialProfilerMetricsResponse.batch:type_name -> determined.trial.v1.TrialProfilerMetricsBatch
	98,  // 33: determined.api.v1.GetTrialProfilerAvailableSeriesResponse.labels:type_name -> determined.trial.v1.TrialProfilerMetricLabels
	99,  // 34: determined.api.v1.PostTrialProfilerMetricsBatchRequest.batches:type_name -> determined.trial.v1.TrialProfilerMetricsBatch
	97,  // 35: determined.api.v1.ComparableTrial.trial:type_name -> determined.trial.v1.Trial
	3,   // 36: determined.api.v1.ComparableTrial.metrics:type_name -> determined.api.v1.DownsampledMetrics
	85,  // 37: determined.api.v1.CompareTrialsRequest.metric_type:type_name -> determined.api.v1.MetricType
	100, // 38: determined.api.v1.CompareTrialsRequest.time_series_filter:type_name -> determined.common.v1.PolymorphicFilter
	32,  // 39: determined.api.v1.CompareTrialsResponse.trials:type_name -> determined.api.v1.ComparableTrial
	101, // 40: determined.api.v1.AllocationRendezvousInfoResponse.rendezvous_info:type_name -> determined.trial.v1.RendezvousInfo
	51,  // 41: determined.api.v1.PostAllocationAcceleratorDataRequest.accelerator_data:type_name -> determined.api.v1.AcceleratorData
	102, // 42: determined.api.v1.AllocationAllGatherRequest.data:type_name -> google.protobuf.Struct
	102, // 43: determined.api.v1.AllocationAllGatherResponse.data:type_name -> google.protobuf.Struct
	102, // 44: determined.api.v1.NotifyContainerRunningRequest.data:type_name -> google.protobuf.Struct
	102, // 45: determined.api.v1.NotifyContainerRunningResponse.data:type_name -> google.protobuf.Struct
	103, // 46: determined.api.v1.ReportTrialSearcherEarlyExitRequest.early_exit:type_name -> determined.trial.v1.TrialEarlyExit
	104, // 47: determined.api.v1.ReportTrialMetricsRequest.metrics:type_name -> determined.trial.v1.TrialMetrics
	104, // 48: determined.api.v1.ReportTrialTrainingMetricsRequest.training_metrics:type_name -> determined.trial.v1.TrialMetrics
	104, // 49: determined.api.v1.ReportTrialValidationMetricsRequest.validation_metrics:type_name -> determined.trial.v1.TrialMetrics
	105, // 50: determined.api.v1.PostTrialRunnerMetadataRequest.metadata:type_name -> determined.trial.v1.TrialRunnerMetadata
	106, // 51: determined.api.v1.GetMetricsResponse.metrics:type_name -> determined.trial.v1.MetricsReport
	106, // 52: determined.api.v1.GetTrainingMetricsResponse.metrics:type_name -> determined.trial.v1.MetricsReport
	106, // 53: determined.api.v1.GetValidationMetricsResponse.metrics:type_name -> determined.trial.v1.MetricsReport
	102, // 54: determined.api.v1.CreateTrialRequest.hparams:type_name -> google.protobuf.Struct
	97,  // 55: determined.api.v1.CreateTrialResponse.trial:type_name -> determined.trial.v1.Trial
	74,  // 56: determined.api.v1.PutTrialRequest.create_trial_request:type_name -> determined.api.v1.CreateTrialRequest
	97,  // 57: determined.api.v1.PutTrialResponse.trial:type_name -> determined.trial.v1.Trial
	107, // 58: determined.api.v1.PatchTrialRequest.state:type_name -> determined.trial.v1.State
	97,  // 59: determined.api.v1.PatchTrialResponse.trial:type_name -> determined.trial.v1.Trial
	108, // 60: determined.api.v1.ReportTrialSourceInfoRequest.trial_source_info:type_name -> determined.trial.v1.TrialSourceInfo
	61,  // [61:61] is the sub-list for method output_type
	61,  // [61:61] is the sub-list for method input_type
	61,  // [61:61] is the sub-list for extension type_name
	61,  // [61:61] is the sub-list for extension extendee
	0,   // [0:61] is the sub-list for field type_name
}

func init() { file_determined_api_v1_trial_proto_init() }
func file_determined_api_v1_trial_proto_init() {
	if File_determined_api_v1_trial_proto != nil {
		return
	}
	file_determined_api_v1_experiment_proto_init()
	file_determined_api_v1_pagination_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_determined_api_v1_trial_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DownsampledMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkloadContainer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ColumnFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrialTag); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrialSorter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrialLogsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrialLogsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrialLogsFieldsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrialLogsFieldsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTrialCheckpointsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTrialCheckpointsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KillTrialRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KillTrialResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetExperimentTrialsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetExperimentTrialsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTrialRemainingLogRetentionDaysRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTrialRemainingLogRetentionDaysResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTrialRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTrialResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTrialByExternalIDRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTrialByExternalIDResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTrialWorkloadsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTrialWorkloadsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTrialProfilerMetricsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTrialProfilerMetricsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTrialProfilerAvailableSeriesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTrialProfilerAvailableSeriesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PostTrialProfilerMetricsBatchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PostTrialProfilerMetricsBatchResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComparableTrial); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompareTrialsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PutTrialRetainLogsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PutTrialRetainLogsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompareTrialsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationPreemptionSignalRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationPreemptionSignalResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AckAllocationPreemptionSignalRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationPendingPreemptionSignalRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationPendingPreemptionSignalResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AckAllocationPreemptionSignalResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MarkAllocationResourcesDaemonRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MarkAllocationResourcesDaemonResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationRendezvousInfoRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationRendezvousInfoResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PostAllocationProxyAddressRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PostAllocationProxyAddressResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PostAllocationAcceleratorDataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PostAllocationAcceleratorDataResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AcceleratorData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationAllGatherRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationAllGatherResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NotifyContainerRunningRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NotifyContainerRunningResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportTrialSearcherEarlyExitRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportTrialSearcherEarlyExitResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportTrialProgressRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportTrialProgressResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportTrialMetricsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportTrialMetricsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportTrialTrainingMetricsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportTrialTrainingMetricsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportTrialValidationMetricsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportTrialValidationMetricsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PostTrialRunnerMetadataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PostTrialRunnerMetadataResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMetricsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMetricsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTrainingMetricsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTrainingMetricsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetValidationMetricsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetValidationMetricsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[71].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTrialRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[72].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTrialResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[73].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PutTrialRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[74].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PutTrialResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[75].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchTrialRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[76].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchTrialResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[77].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartTrialRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[78].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartTrialResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[79].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportTrialSourceInfoRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_trial_proto_msgTypes[80].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportTrialSourceInfoResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_determined_api_v1_trial_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*WorkloadContainer_Training)(nil),
		(*WorkloadContainer_Validation)(nil),
		(*WorkloadContainer_Checkpoint)(nil),
	}
	file_determined_api_v1_trial_proto_msgTypes[6].OneofWrappers = []interface{}{}
	file_determined_api_v1_trial_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*GetTrialCheckpointsRequest_SortByAttr)(nil),
		(*GetTrialCheckpointsRequest_SortByMetric)(nil),
	}
	file_determined_api_v1_trial_proto_msgTypes[16].OneofWrappers = []interface{}{}
	file_determined_api_v1_trial_proto_msgTypes[75].OneofWrappers = []interface{}{}
	file_determined_api_v1_trial_proto_msgTypes[78].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_determined_api_v1_trial_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   81,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_determined_api_v1_trial_proto_goTypes,
		DependencyIndexes: file_determined_api_v1_trial_proto_depIdxs,
		EnumInfos:         file_determined_api_v1_trial_proto_enumTypes,
		MessageInfos:      file_determined_api_v1_trial_proto_msgTypes,
	}.Build()
	File_determined_api_v1_trial_proto = out.File
	file_determined_api_v1_trial_proto_rawDesc = nil
	file_determined_api_v1_trial_proto_goTypes = nil
	file_determined_api_v1_trial_proto_depIdxs = nil
}
