// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// source: determined/api/v1/experiment.proto

package apiv1

import (
	checkpointv1 "github.com/determined-ai/determined/proto/pkg/checkpointv1"
	commonv1 "github.com/determined-ai/determined/proto/pkg/commonv1"
	experimentv1 "github.com/determined-ai/determined/proto/pkg/experimentv1"
	jobv1 "github.com/determined-ai/determined/proto/pkg/jobv1"
	metricv1 "github.com/determined-ai/determined/proto/pkg/metricv1"
	trialv1 "github.com/determined-ai/determined/proto/pkg/trialv1"
	utilv1 "github.com/determined-ai/determined/proto/pkg/utilv1"
	_struct "github.com/golang/protobuf/ptypes/struct"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	_ "github.com/grpc-ecosystem/grpc-gateway/protoc-gen-swagger/options"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// To distinguish the different categories of metrics.
type MetricType int32

const (
	// Zero-value (not allowed).
	MetricType_METRIC_TYPE_UNSPECIFIED MetricType = 0
	// For metrics emitted during training.
	MetricType_METRIC_TYPE_TRAINING MetricType = 1
	// For metrics emitted during validation.
	MetricType_METRIC_TYPE_VALIDATION MetricType = 2
	// For metrics emitted during profiling.
	MetricType_METRIC_TYPE_PROFILING MetricType = 3
)

// Enum value maps for MetricType.
var (
	MetricType_name = map[int32]string{
		0: "METRIC_TYPE_UNSPECIFIED",
		1: "METRIC_TYPE_TRAINING",
		2: "METRIC_TYPE_VALIDATION",
		3: "METRIC_TYPE_PROFILING",
	}
	MetricType_value = map[string]int32{
		"METRIC_TYPE_UNSPECIFIED": 0,
		"METRIC_TYPE_TRAINING":    1,
		"METRIC_TYPE_VALIDATION":  2,
		"METRIC_TYPE_PROFILING":   3,
	}
)

func (x MetricType) Enum() *MetricType {
	p := new(MetricType)
	*p = x
	return p
}

func (x MetricType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetricType) Descriptor() protoreflect.EnumDescriptor {
	return file_determined_api_v1_experiment_proto_enumTypes[0].Descriptor()
}

func (MetricType) Type() protoreflect.EnumType {
	return &file_determined_api_v1_experiment_proto_enumTypes[0]
}

func (x MetricType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetricType.Descriptor instead.
func (MetricType) EnumDescriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{0}
}

// Sorts experiments by the given field.
type GetExperimentsRequest_SortBy int32

const (
	// Returns experiments in an unsorted list.
	GetExperimentsRequest_SORT_BY_UNSPECIFIED GetExperimentsRequest_SortBy = 0
	// Returns experiments sorted by id.
	GetExperimentsRequest_SORT_BY_ID GetExperimentsRequest_SortBy = 1
	// Returns experiments sorted by description.
	GetExperimentsRequest_SORT_BY_DESCRIPTION GetExperimentsRequest_SortBy = 2
	// Return experiments sorted by start time.
	GetExperimentsRequest_SORT_BY_START_TIME GetExperimentsRequest_SortBy = 4
	// Return experiments sorted by end time. Experiments without end_time are
	// returned after the ones with end_time.
	GetExperimentsRequest_SORT_BY_END_TIME GetExperimentsRequest_SortBy = 5
	// Return experiments sorted by state.
	GetExperimentsRequest_SORT_BY_STATE GetExperimentsRequest_SortBy = 6
	// Return experiments sorted by number of trials.
	GetExperimentsRequest_SORT_BY_NUM_TRIALS GetExperimentsRequest_SortBy = 8
	// Return experiments sorted by progress.
	GetExperimentsRequest_SORT_BY_PROGRESS GetExperimentsRequest_SortBy = 9
	// Return experiments sorted by user.
	GetExperimentsRequest_SORT_BY_USER GetExperimentsRequest_SortBy = 10
	// Returns experiments sorted by name.
	GetExperimentsRequest_SORT_BY_NAME GetExperimentsRequest_SortBy = 11
	// Returns experiments sorted by originating model.
	GetExperimentsRequest_SORT_BY_FORKED_FROM GetExperimentsRequest_SortBy = 12
	// Returns experiments sorted by resource pool.
	GetExperimentsRequest_SORT_BY_RESOURCE_POOL GetExperimentsRequest_SortBy = 13
	// Returns experiments sorted by project.
	GetExperimentsRequest_SORT_BY_PROJECT_ID GetExperimentsRequest_SortBy = 14
	// Returns experiments sorted by checkpoint size.
	GetExperimentsRequest_SORT_BY_CHECKPOINT_SIZE GetExperimentsRequest_SortBy = 15
	// Returns experiments sorted by checkpoint count.
	GetExperimentsRequest_SORT_BY_CHECKPOINT_COUNT GetExperimentsRequest_SortBy = 16
	// Returns experiments sorted by searcher metric value..
	GetExperimentsRequest_SORT_BY_SEARCHER_METRIC_VAL GetExperimentsRequest_SortBy = 17
)

// Enum value maps for GetExperimentsRequest_SortBy.
var (
	GetExperimentsRequest_SortBy_name = map[int32]string{
		0:  "SORT_BY_UNSPECIFIED",
		1:  "SORT_BY_ID",
		2:  "SORT_BY_DESCRIPTION",
		4:  "SORT_BY_START_TIME",
		5:  "SORT_BY_END_TIME",
		6:  "SORT_BY_STATE",
		8:  "SORT_BY_NUM_TRIALS",
		9:  "SORT_BY_PROGRESS",
		10: "SORT_BY_USER",
		11: "SORT_BY_NAME",
		12: "SORT_BY_FORKED_FROM",
		13: "SORT_BY_RESOURCE_POOL",
		14: "SORT_BY_PROJECT_ID",
		15: "SORT_BY_CHECKPOINT_SIZE",
		16: "SORT_BY_CHECKPOINT_COUNT",
		17: "SORT_BY_SEARCHER_METRIC_VAL",
	}
	GetExperimentsRequest_SortBy_value = map[string]int32{
		"SORT_BY_UNSPECIFIED":         0,
		"SORT_BY_ID":                  1,
		"SORT_BY_DESCRIPTION":         2,
		"SORT_BY_START_TIME":          4,
		"SORT_BY_END_TIME":            5,
		"SORT_BY_STATE":               6,
		"SORT_BY_NUM_TRIALS":          8,
		"SORT_BY_PROGRESS":            9,
		"SORT_BY_USER":                10,
		"SORT_BY_NAME":                11,
		"SORT_BY_FORKED_FROM":         12,
		"SORT_BY_RESOURCE_POOL":       13,
		"SORT_BY_PROJECT_ID":          14,
		"SORT_BY_CHECKPOINT_SIZE":     15,
		"SORT_BY_CHECKPOINT_COUNT":    16,
		"SORT_BY_SEARCHER_METRIC_VAL": 17,
	}
)

func (x GetExperimentsRequest_SortBy) Enum() *GetExperimentsRequest_SortBy {
	p := new(GetExperimentsRequest_SortBy)
	*p = x
	return p
}

func (x GetExperimentsRequest_SortBy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetExperimentsRequest_SortBy) Descriptor() protoreflect.EnumDescriptor {
	return file_determined_api_v1_experiment_proto_enumTypes[1].Descriptor()
}

func (GetExperimentsRequest_SortBy) Type() protoreflect.EnumType {
	return &file_determined_api_v1_experiment_proto_enumTypes[1]
}

func (x GetExperimentsRequest_SortBy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetExperimentsRequest_SortBy.Descriptor instead.
func (GetExperimentsRequest_SortBy) EnumDescriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{3, 0}
}

// One datapoint in a series of metrics from a trial in batch.
type DataPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Total batches processed by the time this measurement is taken.
	Batches int32 `protobuf:"varint,1,opt,name=batches,proto3" json:"batches,omitempty"`
	// Values of the requested metrics at this point in the trial.
	Values *_struct.Struct `protobuf:"bytes,2,opt,name=values,proto3" json:"values,omitempty"`
	// The time the measurement is taken.
	Time *timestamp.Timestamp `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty"`
	// The epoch this measurement is taken.
	Epoch *float64 `protobuf:"fixed64,4,opt,name=epoch,proto3,oneof" json:"epoch,omitempty"`
}

func (x *DataPoint) Reset() {
	*x = DataPoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataPoint) ProtoMessage() {}

func (x *DataPoint) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataPoint.ProtoReflect.Descriptor instead.
func (*DataPoint) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{0}
}

func (x *DataPoint) GetBatches() int32 {
	if x != nil {
		return x.Batches
	}
	return 0
}

func (x *DataPoint) GetValues() *_struct.Struct {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *DataPoint) GetTime() *timestamp.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *DataPoint) GetEpoch() float64 {
	if x != nil && x.Epoch != nil {
		return *x.Epoch
	}
	return 0
}

// Get a single experiment.
type GetExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the experiment.
	ExperimentId int32 `protobuf:"varint,1,opt,name=experiment_id,json=experimentId,proto3" json:"experiment_id,omitempty"`
}

func (x *GetExperimentRequest) Reset() {
	*x = GetExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetExperimentRequest) ProtoMessage() {}

func (x *GetExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetExperimentRequest.ProtoReflect.Descriptor instead.
func (*GetExperimentRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{1}
}

func (x *GetExperimentRequest) GetExperimentId() int32 {
	if x != nil {
		return x.ExperimentId
	}
	return 0
}

// Response to GetExperimentRequest.
type GetExperimentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested experiment.
	Experiment *experimentv1.Experiment `protobuf:"bytes,1,opt,name=experiment,proto3" json:"experiment,omitempty"`
	// Associated job summary.
	JobSummary *jobv1.JobSummary `protobuf:"bytes,3,opt,name=job_summary,json=jobSummary,proto3" json:"job_summary,omitempty"`
	// The experiment's config.
	Config *_struct.Struct `protobuf:"bytes,4,opt,name=config,proto3" json:"config,omitempty"`
}

func (x *GetExperimentResponse) Reset() {
	*x = GetExperimentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetExperimentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetExperimentResponse) ProtoMessage() {}

func (x *GetExperimentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetExperimentResponse.ProtoReflect.Descriptor instead.
func (*GetExperimentResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{2}
}

func (x *GetExperimentResponse) GetExperiment() *experimentv1.Experiment {
	if x != nil {
		return x.Experiment
	}
	return nil
}

func (x *GetExperimentResponse) GetJobSummary() *jobv1.JobSummary {
	if x != nil {
		return x.JobSummary
	}
	return nil
}

func (x *GetExperimentResponse) GetConfig() *_struct.Struct {
	if x != nil {
		return x.Config
	}
	return nil
}

// Get a list of experiments.
type GetExperimentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sort experiments by the given field.
	SortBy GetExperimentsRequest_SortBy `protobuf:"varint,1,opt,name=sort_by,json=sortBy,proto3,enum=determined.api.v1.GetExperimentsRequest_SortBy" json:"sort_by,omitempty"`
	// Order experiments in either ascending or descending order.
	OrderBy OrderBy `protobuf:"varint,2,opt,name=order_by,json=orderBy,proto3,enum=determined.api.v1.OrderBy" json:"order_by,omitempty"`
	// Skip the number of experiments before returning results. Negative values
	// denote number of experiments to skip from the end before returning results.
	Offset int32 `protobuf:"varint,3,opt,name=offset,proto3" json:"offset,omitempty"`
	// Limit the number of experiments.
	// 0 or Unspecified - returns a default of 100.
	// -1               - returns everything.
	// -2               - returns pagination info but no experiments.
	Limit int32 `protobuf:"varint,4,opt,name=limit,proto3" json:"limit,omitempty"`
	// Limit experiments to those that match the description.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Limit experiments to those that match the name.
	Name string `protobuf:"bytes,10,opt,name=name,proto3" json:"name,omitempty"`
	// Limit experiments to those that match the provided labels.
	Labels []string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty"`
	// Limit experiments to those that are archived.
	Archived *wrappers.BoolValue `protobuf:"bytes,7,opt,name=archived,proto3" json:"archived,omitempty"`
	// Limit experiments to those that match the provided state.
	States []experimentv1.State `protobuf:"varint,8,rep,packed,name=states,proto3,enum=determined.experiment.v1.State" json:"states,omitempty"`
	// Limit experiments to those that are owned by users with the specified
	// usernames.
	Users []string `protobuf:"bytes,9,rep,name=users,proto3" json:"users,omitempty"`
	// Limit experiments to those that are owned by users with the specified
	// userIds.
	UserIds []int32 `protobuf:"varint,11,rep,packed,name=user_ids,json=userIds,proto3" json:"user_ids,omitempty"`
	// Limit experiments to those within a specified project, or 0 for all
	// projects.
	ProjectId int32 `protobuf:"varint,12,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// filtering by experiment ids
	ExperimentIdFilter *commonv1.Int32FieldFilter `protobuf:"bytes,13,opt,name=experiment_id_filter,json=experimentIdFilter,proto3" json:"experiment_id_filter,omitempty"`
	// whether to surface trial specific data from the best trial
	ShowTrialData bool `protobuf:"varint,14,opt,name=show_trial_data,json=showTrialData,proto3" json:"show_trial_data,omitempty"`
}

func (x *GetExperimentsRequest) Reset() {
	*x = GetExperimentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetExperimentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetExperimentsRequest) ProtoMessage() {}

func (x *GetExperimentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetExperimentsRequest.ProtoReflect.Descriptor instead.
func (*GetExperimentsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{3}
}

func (x *GetExperimentsRequest) GetSortBy() GetExperimentsRequest_SortBy {
	if x != nil {
		return x.SortBy
	}
	return GetExperimentsRequest_SORT_BY_UNSPECIFIED
}

func (x *GetExperimentsRequest) GetOrderBy() OrderBy {
	if x != nil {
		return x.OrderBy
	}
	return OrderBy_ORDER_BY_UNSPECIFIED
}

func (x *GetExperimentsRequest) GetOffset() int32 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *GetExperimentsRequest) GetLimit() int32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *GetExperimentsRequest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *GetExperimentsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetExperimentsRequest) GetLabels() []string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *GetExperimentsRequest) GetArchived() *wrappers.BoolValue {
	if x != nil {
		return x.Archived
	}
	return nil
}

func (x *GetExperimentsRequest) GetStates() []experimentv1.State {
	if x != nil {
		return x.States
	}
	return nil
}

func (x *GetExperimentsRequest) GetUsers() []string {
	if x != nil {
		return x.Users
	}
	return nil
}

func (x *GetExperimentsRequest) GetUserIds() []int32 {
	if x != nil {
		return x.UserIds
	}
	return nil
}

func (x *GetExperimentsRequest) GetProjectId() int32 {
	if x != nil {
		return x.ProjectId
	}
	return 0
}

func (x *GetExperimentsRequest) GetExperimentIdFilter() *commonv1.Int32FieldFilter {
	if x != nil {
		return x.ExperimentIdFilter
	}
	return nil
}

func (x *GetExperimentsRequest) GetShowTrialData() bool {
	if x != nil {
		return x.ShowTrialData
	}
	return false
}

// Response to GetExperimentsRequest.
type GetExperimentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of returned experiments.
	Experiments []*experimentv1.Experiment `protobuf:"bytes,1,rep,name=experiments,proto3" json:"experiments,omitempty"`
	// Pagination information of the full dataset.
	Pagination *Pagination `protobuf:"bytes,2,opt,name=pagination,proto3" json:"pagination,omitempty"`
}

func (x *GetExperimentsResponse) Reset() {
	*x = GetExperimentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetExperimentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetExperimentsResponse) ProtoMessage() {}

func (x *GetExperimentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetExperimentsResponse.ProtoReflect.Descriptor instead.
func (*GetExperimentsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{4}
}

func (x *GetExperimentsResponse) GetExperiments() []*experimentv1.Experiment {
	if x != nil {
		return x.Experiments
	}
	return nil
}

func (x *GetExperimentsResponse) GetPagination() *Pagination {
	if x != nil {
		return x.Pagination
	}
	return nil
}

// Get a list of experiment labels.
type GetExperimentLabelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Filter experiments by project.
	ProjectId int32 `protobuf:"varint,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *GetExperimentLabelsRequest) Reset() {
	*x = GetExperimentLabelsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetExperimentLabelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetExperimentLabelsRequest) ProtoMessage() {}

func (x *GetExperimentLabelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetExperimentLabelsRequest.ProtoReflect.Descriptor instead.
func (*GetExperimentLabelsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{5}
}

func (x *GetExperimentLabelsRequest) GetProjectId() int32 {
	if x != nil {
		return x.ProjectId
	}
	return 0
}

// Response to GetExperimentsLabelsRequest.
type GetExperimentLabelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of labels used across all experiments.
	Labels []string `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty"`
}

func (x *GetExperimentLabelsResponse) Reset() {
	*x = GetExperimentLabelsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetExperimentLabelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetExperimentLabelsResponse) ProtoMessage() {}

func (x *GetExperimentLabelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetExperimentLabelsResponse.ProtoReflect.Descriptor instead.
func (*GetExperimentLabelsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{6}
}

func (x *GetExperimentLabelsResponse) GetLabels() []string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Request for changing the log retention policy for the an experiment.
type PutExperimentRetainLogsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the experiment.
	ExperimentId int32 `protobuf:"varint,1,opt,name=experiment_id,json=experimentId,proto3" json:"experiment_id,omitempty"`
	// The number of days to retain logs, starting from the end time of the task.
	NumDays int32 `protobuf:"varint,2,opt,name=num_days,json=numDays,proto3" json:"num_days,omitempty"`
}

func (x *PutExperimentRetainLogsRequest) Reset() {
	*x = PutExperimentRetainLogsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PutExperimentRetainLogsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PutExperimentRetainLogsRequest) ProtoMessage() {}

func (x *PutExperimentRetainLogsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PutExperimentRetainLogsRequest.ProtoReflect.Descriptor instead.
func (*PutExperimentRetainLogsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{7}
}

func (x *PutExperimentRetainLogsRequest) GetExperimentId() int32 {
	if x != nil {
		return x.ExperimentId
	}
	return 0
}

func (x *PutExperimentRetainLogsRequest) GetNumDays() int32 {
	if x != nil {
		return x.NumDays
	}
	return 0
}

// Response to PutExperimentRetainLogsRequest.
type PutExperimentRetainLogsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PutExperimentRetainLogsResponse) Reset() {
	*x = PutExperimentRetainLogsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PutExperimentRetainLogsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PutExperimentRetainLogsResponse) ProtoMessage() {}

func (x *PutExperimentRetainLogsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PutExperimentRetainLogsResponse.ProtoReflect.Descriptor instead.
func (*PutExperimentRetainLogsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{8}
}

// Request for changing the log retention policy for the an experiment.
type PutExperimentsRetainLogsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ids of the experiments being moved.
	ExperimentIds []int32 `protobuf:"varint,1,rep,packed,name=experiment_ids,json=experimentIds,proto3" json:"experiment_ids,omitempty"`
	// The number of days to retain logs, starting from the end time of the task.
	NumDays int32 `protobuf:"varint,2,opt,name=num_days,json=numDays,proto3" json:"num_days,omitempty"`
	// Targets all experiments matching filters.
	Filters *BulkExperimentFilters `protobuf:"bytes,3,opt,name=filters,proto3" json:"filters,omitempty"`
	// Project id that the experiments belong to.
	ProjectId int32 `protobuf:"varint,4,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *PutExperimentsRetainLogsRequest) Reset() {
	*x = PutExperimentsRetainLogsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PutExperimentsRetainLogsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PutExperimentsRetainLogsRequest) ProtoMessage() {}

func (x *PutExperimentsRetainLogsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PutExperimentsRetainLogsRequest.ProtoReflect.Descriptor instead.
func (*PutExperimentsRetainLogsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{9}
}

func (x *PutExperimentsRetainLogsRequest) GetExperimentIds() []int32 {
	if x != nil {
		return x.ExperimentIds
	}
	return nil
}

func (x *PutExperimentsRetainLogsRequest) GetNumDays() int32 {
	if x != nil {
		return x.NumDays
	}
	return 0
}

func (x *PutExperimentsRetainLogsRequest) GetFilters() *BulkExperimentFilters {
	if x != nil {
		return x.Filters
	}
	return nil
}

func (x *PutExperimentsRetainLogsRequest) GetProjectId() int32 {
	if x != nil {
		return x.ProjectId
	}
	return 0
}

// Response to PutExperimentRetainLogsRequest.
type PutExperimentsRetainLogsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details on success or error for each experiment.
	Results []*ExperimentActionResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
}

func (x *PutExperimentsRetainLogsResponse) Reset() {
	*x = PutExperimentsRetainLogsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PutExperimentsRetainLogsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PutExperimentsRetainLogsResponse) ProtoMessage() {}

func (x *PutExperimentsRetainLogsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PutExperimentsRetainLogsResponse.ProtoReflect.Descriptor instead.
func (*PutExperimentsRetainLogsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{10}
}

func (x *PutExperimentsRetainLogsResponse) GetResults() []*ExperimentActionResult {
	if x != nil {
		return x.Results
	}
	return nil
}

// Request for adding a new experiment label.
type PutExperimentLabelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the experiment.
	ExperimentId int32 `protobuf:"varint,1,opt,name=experiment_id,json=experimentId,proto3" json:"experiment_id,omitempty"`
	// The label to add.
	Label string `protobuf:"bytes,2,opt,name=label,proto3" json:"label,omitempty"`
}

func (x *PutExperimentLabelRequest) Reset() {
	*x = PutExperimentLabelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PutExperimentLabelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PutExperimentLabelRequest) ProtoMessage() {}

func (x *PutExperimentLabelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PutExperimentLabelRequest.ProtoReflect.Descriptor instead.
func (*PutExperimentLabelRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{11}
}

func (x *PutExperimentLabelRequest) GetExperimentId() int32 {
	if x != nil {
		return x.ExperimentId
	}
	return 0
}

func (x *PutExperimentLabelRequest) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

// Response to PutExperimentLabelRequest.
type PutExperimentLabelResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The complete list of labels associated with the experiment.
	Labels []string `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty"`
}

func (x *PutExperimentLabelResponse) Reset() {
	*x = PutExperimentLabelResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PutExperimentLabelResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PutExperimentLabelResponse) ProtoMessage() {}

func (x *PutExperimentLabelResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PutExperimentLabelResponse.ProtoReflect.Descriptor instead.
func (*PutExperimentLabelResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{12}
}

func (x *PutExperimentLabelResponse) GetLabels() []string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Request for deleting an experiment label.
type DeleteExperimentLabelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the experiment.
	ExperimentId int32 `protobuf:"varint,1,opt,name=experiment_id,json=experimentId,proto3" json:"experiment_id,omitempty"`
	// The label to delete.
	Label string `protobuf:"bytes,2,opt,name=label,proto3" json:"label,omitempty"`
}

func (x *DeleteExperimentLabelRequest) Reset() {
	*x = DeleteExperimentLabelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteExperimentLabelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteExperimentLabelRequest) ProtoMessage() {}

func (x *DeleteExperimentLabelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteExperimentLabelRequest.ProtoReflect.Descriptor instead.
func (*DeleteExperimentLabelRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{13}
}

func (x *DeleteExperimentLabelRequest) GetExperimentId() int32 {
	if x != nil {
		return x.ExperimentId
	}
	return 0
}

func (x *DeleteExperimentLabelRequest) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

// Response to DeleteExperimentLabelRequest.
type DeleteExperimentLabelResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The complete list of labels associated with the experiment.
	Labels []string `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty"`
}

func (x *DeleteExperimentLabelResponse) Reset() {
	*x = DeleteExperimentLabelResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteExperimentLabelResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteExperimentLabelResponse) ProtoMessage() {}

func (x *DeleteExperimentLabelResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteExperimentLabelResponse.ProtoReflect.Descriptor instead.
func (*DeleteExperimentLabelResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{14}
}

func (x *DeleteExperimentLabelResponse) GetLabels() []string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Delete a single experiment.
type DeleteExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the experiment.
	ExperimentId int32 `protobuf:"varint,1,opt,name=experiment_id,json=experimentId,proto3" json:"experiment_id,omitempty"`
}

func (x *DeleteExperimentRequest) Reset() {
	*x = DeleteExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteExperimentRequest) ProtoMessage() {}

func (x *DeleteExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteExperimentRequest.ProtoReflect.Descriptor instead.
func (*DeleteExperimentRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{15}
}

func (x *DeleteExperimentRequest) GetExperimentId() int32 {
	if x != nil {
		return x.ExperimentId
	}
	return 0
}

// Response to DeleteExperimentRequest.
type DeleteExperimentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeleteExperimentResponse) Reset() {
	*x = DeleteExperimentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteExperimentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteExperimentResponse) ProtoMessage() {}

func (x *DeleteExperimentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteExperimentResponse.ProtoReflect.Descriptor instead.
func (*DeleteExperimentResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{16}
}

// Delete multiple experiments.
type DeleteExperimentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Selecting experiments by id.
	ExperimentIds []int32 `protobuf:"varint,1,rep,packed,name=experiment_ids,json=experimentIds,proto3" json:"experiment_ids,omitempty"`
	// Targets all experiments matching filters.
	Filters *BulkExperimentFilters `protobuf:"bytes,2,opt,name=filters,proto3" json:"filters,omitempty"`
	// Project id that the experiments belong to.
	ProjectId int32 `protobuf:"varint,3,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *DeleteExperimentsRequest) Reset() {
	*x = DeleteExperimentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteExperimentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteExperimentsRequest) ProtoMessage() {}

func (x *DeleteExperimentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteExperimentsRequest.ProtoReflect.Descriptor instead.
func (*DeleteExperimentsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{17}
}

func (x *DeleteExperimentsRequest) GetExperimentIds() []int32 {
	if x != nil {
		return x.ExperimentIds
	}
	return nil
}

func (x *DeleteExperimentsRequest) GetFilters() *BulkExperimentFilters {
	if x != nil {
		return x.Filters
	}
	return nil
}

func (x *DeleteExperimentsRequest) GetProjectId() int32 {
	if x != nil {
		return x.ProjectId
	}
	return 0
}

// Response to DeleteExperimentsRequest.
type DeleteExperimentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details on success or error for each experiment.
	Results []*ExperimentActionResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
}

func (x *DeleteExperimentsResponse) Reset() {
	*x = DeleteExperimentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteExperimentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteExperimentsResponse) ProtoMessage() {}

func (x *DeleteExperimentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteExperimentsResponse.ProtoReflect.Descriptor instead.
func (*DeleteExperimentsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{18}
}

func (x *DeleteExperimentsResponse) GetResults() []*ExperimentActionResult {
	if x != nil {
		return x.Results
	}
	return nil
}

// Get the best searcher validation.
type GetBestSearcherValidationMetricRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the experiment.
	ExperimentId int32 `protobuf:"varint,1,opt,name=experiment_id,json=experimentId,proto3" json:"experiment_id,omitempty"`
}

func (x *GetBestSearcherValidationMetricRequest) Reset() {
	*x = GetBestSearcherValidationMetricRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBestSearcherValidationMetricRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBestSearcherValidationMetricRequest) ProtoMessage() {}

func (x *GetBestSearcherValidationMetricRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBestSearcherValidationMetricRequest.ProtoReflect.Descriptor instead.
func (*GetBestSearcherValidationMetricRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{19}
}

func (x *GetBestSearcherValidationMetricRequest) GetExperimentId() int32 {
	if x != nil {
		return x.ExperimentId
	}
	return 0
}

// Response to GetBestSearcherValidationMetricRequest.
type GetBestSearcherValidationMetricResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The value of the metric.
	Metric float32 `protobuf:"fixed32,1,opt,name=metric,proto3" json:"metric,omitempty"`
}

func (x *GetBestSearcherValidationMetricResponse) Reset() {
	*x = GetBestSearcherValidationMetricResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBestSearcherValidationMetricResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBestSearcherValidationMetricResponse) ProtoMessage() {}

func (x *GetBestSearcherValidationMetricResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBestSearcherValidationMetricResponse.ProtoReflect.Descriptor instead.
func (*GetBestSearcherValidationMetricResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{20}
}

func (x *GetBestSearcherValidationMetricResponse) GetMetric() float32 {
	if x != nil {
		return x.Metric
	}
	return 0
}

// Preview hyperparameter search.
type PreviewHPSearchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The experiment config to simulate.
	Config *_struct.Struct `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// The searcher simulation seed.
	Seed uint32 `protobuf:"varint,2,opt,name=seed,proto3" json:"seed,omitempty"`
}

func (x *PreviewHPSearchRequest) Reset() {
	*x = PreviewHPSearchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PreviewHPSearchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreviewHPSearchRequest) ProtoMessage() {}

func (x *PreviewHPSearchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreviewHPSearchRequest.ProtoReflect.Descriptor instead.
func (*PreviewHPSearchRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{21}
}

func (x *PreviewHPSearchRequest) GetConfig() *_struct.Struct {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *PreviewHPSearchRequest) GetSeed() uint32 {
	if x != nil {
		return x.Seed
	}
	return 0
}

// Response to PreviewSearchRequest.
type PreviewHPSearchResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resulting summary.
	Summary *experimentv1.SearchSummary `protobuf:"bytes,1,opt,name=summary,proto3" json:"summary,omitempty"`
}

func (x *PreviewHPSearchResponse) Reset() {
	*x = PreviewHPSearchResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PreviewHPSearchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreviewHPSearchResponse) ProtoMessage() {}

func (x *PreviewHPSearchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreviewHPSearchResponse.ProtoReflect.Descriptor instead.
func (*PreviewHPSearchResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{22}
}

func (x *PreviewHPSearchResponse) GetSummary() *experimentv1.SearchSummary {
	if x != nil {
		return x.Summary
	}
	return nil
}

// Activate an experiment.
type ActivateExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The experiment id.
	Id int32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *ActivateExperimentRequest) Reset() {
	*x = ActivateExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActivateExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActivateExperimentRequest) ProtoMessage() {}

func (x *ActivateExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActivateExperimentRequest.ProtoReflect.Descriptor instead.
func (*ActivateExperimentRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{23}
}

func (x *ActivateExperimentRequest) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

// Response to ActivateExperimentRequest.
type ActivateExperimentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ActivateExperimentResponse) Reset() {
	*x = ActivateExperimentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActivateExperimentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActivateExperimentResponse) ProtoMessage() {}

func (x *ActivateExperimentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActivateExperimentResponse.ProtoReflect.Descriptor instead.
func (*ActivateExperimentResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{24}
}

// Message for results of individual experiments in a multi-experiment action.
type ExperimentActionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional error message.
	Error string `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	// Experiment ID.
	Id int32 `protobuf:"varint,2,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *ExperimentActionResult) Reset() {
	*x = ExperimentActionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExperimentActionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExperimentActionResult) ProtoMessage() {}

func (x *ExperimentActionResult) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExperimentActionResult.ProtoReflect.Descriptor instead.
func (*ExperimentActionResult) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{25}
}

func (x *ExperimentActionResult) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

func (x *ExperimentActionResult) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

// Activate multiple experiments.
type ActivateExperimentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Select experiments by id.
	ExperimentIds []int32 `protobuf:"varint,1,rep,packed,name=experiment_ids,json=experimentIds,proto3" json:"experiment_ids,omitempty"`
	// Targets all experiments matching filters.
	Filters *BulkExperimentFilters `protobuf:"bytes,2,opt,name=filters,proto3" json:"filters,omitempty"`
	// Project id that the experiments belong to.
	ProjectId int32 `protobuf:"varint,3,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *ActivateExperimentsRequest) Reset() {
	*x = ActivateExperimentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActivateExperimentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActivateExperimentsRequest) ProtoMessage() {}

func (x *ActivateExperimentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActivateExperimentsRequest.ProtoReflect.Descriptor instead.
func (*ActivateExperimentsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{26}
}

func (x *ActivateExperimentsRequest) GetExperimentIds() []int32 {
	if x != nil {
		return x.ExperimentIds
	}
	return nil
}

func (x *ActivateExperimentsRequest) GetFilters() *BulkExperimentFilters {
	if x != nil {
		return x.Filters
	}
	return nil
}

func (x *ActivateExperimentsRequest) GetProjectId() int32 {
	if x != nil {
		return x.ProjectId
	}
	return 0
}

// Response to ActivateExperimentsRequest.
type ActivateExperimentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details on success or error for each experiment.
	Results []*ExperimentActionResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
}

func (x *ActivateExperimentsResponse) Reset() {
	*x = ActivateExperimentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActivateExperimentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActivateExperimentsResponse) ProtoMessage() {}

func (x *ActivateExperimentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActivateExperimentsResponse.ProtoReflect.Descriptor instead.
func (*ActivateExperimentsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{27}
}

func (x *ActivateExperimentsResponse) GetResults() []*ExperimentActionResult {
	if x != nil {
		return x.Results
	}
	return nil
}

// Pause an experiment.
type PauseExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The experiment id.
	Id int32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *PauseExperimentRequest) Reset() {
	*x = PauseExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PauseExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PauseExperimentRequest) ProtoMessage() {}

func (x *PauseExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PauseExperimentRequest.ProtoReflect.Descriptor instead.
func (*PauseExperimentRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{28}
}

func (x *PauseExperimentRequest) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

// Response to PauseExperimentRequest.
type PauseExperimentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PauseExperimentResponse) Reset() {
	*x = PauseExperimentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PauseExperimentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PauseExperimentResponse) ProtoMessage() {}

func (x *PauseExperimentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PauseExperimentResponse.ProtoReflect.Descriptor instead.
func (*PauseExperimentResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{29}
}

// Filters to apply actions to multiple experiments.
type BulkExperimentFilters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Limit experiments to those that match the description.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// Limit experiments to those that match the name.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Limit experiments to those that match the provided labels.
	Labels []string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty"`
	// Limit experiments to those that are archived.
	Archived *wrappers.BoolValue `protobuf:"bytes,4,opt,name=archived,proto3" json:"archived,omitempty"`
	// Limit experiments to those that match the provided state.
	States []experimentv1.State `protobuf:"varint,5,rep,packed,name=states,proto3,enum=determined.experiment.v1.State" json:"states,omitempty"`
	// Limit experiments to those that are owned by users with the specified
	// userIds.
	UserIds []int32 `protobuf:"varint,6,rep,packed,name=user_ids,json=userIds,proto3" json:"user_ids,omitempty"`
	// Limit experiments to those within a specified project, or 0 for all
	// projects.
	ProjectId int32 `protobuf:"varint,7,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Experiment ids to exclude when filters are used.
	ExcludedExperimentIds []int32 `protobuf:"varint,8,rep,packed,name=excluded_experiment_ids,json=excludedExperimentIds,proto3" json:"excluded_experiment_ids,omitempty"`
}

func (x *BulkExperimentFilters) Reset() {
	*x = BulkExperimentFilters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BulkExperimentFilters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkExperimentFilters) ProtoMessage() {}

func (x *BulkExperimentFilters) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkExperimentFilters.ProtoReflect.Descriptor instead.
func (*BulkExperimentFilters) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{30}
}

func (x *BulkExperimentFilters) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *BulkExperimentFilters) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BulkExperimentFilters) GetLabels() []string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *BulkExperimentFilters) GetArchived() *wrappers.BoolValue {
	if x != nil {
		return x.Archived
	}
	return nil
}

func (x *BulkExperimentFilters) GetStates() []experimentv1.State {
	if x != nil {
		return x.States
	}
	return nil
}

func (x *BulkExperimentFilters) GetUserIds() []int32 {
	if x != nil {
		return x.UserIds
	}
	return nil
}

func (x *BulkExperimentFilters) GetProjectId() int32 {
	if x != nil {
		return x.ProjectId
	}
	return 0
}

func (x *BulkExperimentFilters) GetExcludedExperimentIds() []int32 {
	if x != nil {
		return x.ExcludedExperimentIds
	}
	return nil
}

// Pause multiple experiments.
type PauseExperimentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Selecting experiments by id.
	ExperimentIds []int32 `protobuf:"varint,1,rep,packed,name=experiment_ids,json=experimentIds,proto3" json:"experiment_ids,omitempty"`
	// Targets all experiments matching filters.
	Filters *BulkExperimentFilters `protobuf:"bytes,2,opt,name=filters,proto3" json:"filters,omitempty"`
	// Project id that the experiments belong to.
	ProjectId int32 `protobuf:"varint,3,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *PauseExperimentsRequest) Reset() {
	*x = PauseExperimentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PauseExperimentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PauseExperimentsRequest) ProtoMessage() {}

func (x *PauseExperimentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PauseExperimentsRequest.ProtoReflect.Descriptor instead.
func (*PauseExperimentsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{31}
}

func (x *PauseExperimentsRequest) GetExperimentIds() []int32 {
	if x != nil {
		return x.ExperimentIds
	}
	return nil
}

func (x *PauseExperimentsRequest) GetFilters() *BulkExperimentFilters {
	if x != nil {
		return x.Filters
	}
	return nil
}

func (x *PauseExperimentsRequest) GetProjectId() int32 {
	if x != nil {
		return x.ProjectId
	}
	return 0
}

// Response to PauseExperimentsRequest.
type PauseExperimentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details on success or error for each experiment.
	Results []*ExperimentActionResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
}

func (x *PauseExperimentsResponse) Reset() {
	*x = PauseExperimentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PauseExperimentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PauseExperimentsResponse) ProtoMessage() {}

func (x *PauseExperimentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PauseExperimentsResponse.ProtoReflect.Descriptor instead.
func (*PauseExperimentsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{32}
}

func (x *PauseExperimentsResponse) GetResults() []*ExperimentActionResult {
	if x != nil {
		return x.Results
	}
	return nil
}

// Cancel an experiment.
type CancelExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The experiment id.
	Id int32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *CancelExperimentRequest) Reset() {
	*x = CancelExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelExperimentRequest) ProtoMessage() {}

func (x *CancelExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelExperimentRequest.ProtoReflect.Descriptor instead.
func (*CancelExperimentRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{33}
}

func (x *CancelExperimentRequest) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

// Response to CancelExperimentRequest.
type CancelExperimentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CancelExperimentResponse) Reset() {
	*x = CancelExperimentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelExperimentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelExperimentResponse) ProtoMessage() {}

func (x *CancelExperimentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelExperimentResponse.ProtoReflect.Descriptor instead.
func (*CancelExperimentResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{34}
}

// Cancel multiple experiments.
type CancelExperimentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Selecting experiments by id.
	ExperimentIds []int32 `protobuf:"varint,1,rep,packed,name=experiment_ids,json=experimentIds,proto3" json:"experiment_ids,omitempty"`
	// Targets all experiments matching filters.
	Filters *BulkExperimentFilters `protobuf:"bytes,2,opt,name=filters,proto3" json:"filters,omitempty"`
	// Project id that the experiments belong to.
	ProjectId int32 `protobuf:"varint,3,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *CancelExperimentsRequest) Reset() {
	*x = CancelExperimentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelExperimentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelExperimentsRequest) ProtoMessage() {}

func (x *CancelExperimentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelExperimentsRequest.ProtoReflect.Descriptor instead.
func (*CancelExperimentsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{35}
}

func (x *CancelExperimentsRequest) GetExperimentIds() []int32 {
	if x != nil {
		return x.ExperimentIds
	}
	return nil
}

func (x *CancelExperimentsRequest) GetFilters() *BulkExperimentFilters {
	if x != nil {
		return x.Filters
	}
	return nil
}

func (x *CancelExperimentsRequest) GetProjectId() int32 {
	if x != nil {
		return x.ProjectId
	}
	return 0
}

// Response to CancelExperimentsRequest.
type CancelExperimentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details on success or error for each experiment.
	Results []*ExperimentActionResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
}

func (x *CancelExperimentsResponse) Reset() {
	*x = CancelExperimentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelExperimentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelExperimentsResponse) ProtoMessage() {}

func (x *CancelExperimentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelExperimentsResponse.ProtoReflect.Descriptor instead.
func (*CancelExperimentsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{36}
}

func (x *CancelExperimentsResponse) GetResults() []*ExperimentActionResult {
	if x != nil {
		return x.Results
	}
	return nil
}

// Kill an experiment.
type KillExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The experiment id.
	Id int32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *KillExperimentRequest) Reset() {
	*x = KillExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KillExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KillExperimentRequest) ProtoMessage() {}

func (x *KillExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KillExperimentRequest.ProtoReflect.Descriptor instead.
func (*KillExperimentRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{37}
}

func (x *KillExperimentRequest) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

// Response to KillExperimentRequest.
type KillExperimentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *KillExperimentResponse) Reset() {
	*x = KillExperimentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KillExperimentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KillExperimentResponse) ProtoMessage() {}

func (x *KillExperimentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KillExperimentResponse.ProtoReflect.Descriptor instead.
func (*KillExperimentResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{38}
}

// Kill multiple experiments.
type KillExperimentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Selecting experiments by id.
	ExperimentIds []int32 `protobuf:"varint,1,rep,packed,name=experiment_ids,json=experimentIds,proto3" json:"experiment_ids,omitempty"`
	// Targets all experiments matching filters.
	Filters *BulkExperimentFilters `protobuf:"bytes,2,opt,name=filters,proto3" json:"filters,omitempty"`
	// Project id that the experiments belong to.
	ProjectId int32 `protobuf:"varint,3,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *KillExperimentsRequest) Reset() {
	*x = KillExperimentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KillExperimentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KillExperimentsRequest) ProtoMessage() {}

func (x *KillExperimentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KillExperimentsRequest.ProtoReflect.Descriptor instead.
func (*KillExperimentsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{39}
}

func (x *KillExperimentsRequest) GetExperimentIds() []int32 {
	if x != nil {
		return x.ExperimentIds
	}
	return nil
}

func (x *KillExperimentsRequest) GetFilters() *BulkExperimentFilters {
	if x != nil {
		return x.Filters
	}
	return nil
}

func (x *KillExperimentsRequest) GetProjectId() int32 {
	if x != nil {
		return x.ProjectId
	}
	return 0
}

// Response to KillExperimentsRequest.
type KillExperimentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details on success or error for each experiment.
	Results []*ExperimentActionResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
}

func (x *KillExperimentsResponse) Reset() {
	*x = KillExperimentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KillExperimentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KillExperimentsResponse) ProtoMessage() {}

func (x *KillExperimentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KillExperimentsResponse.ProtoReflect.Descriptor instead.
func (*KillExperimentsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{40}
}

func (x *KillExperimentsResponse) GetResults() []*ExperimentActionResult {
	if x != nil {
		return x.Results
	}
	return nil
}

// Archive an experiment.
type ArchiveExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The experiment id.
	Id int32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *ArchiveExperimentRequest) Reset() {
	*x = ArchiveExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArchiveExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArchiveExperimentRequest) ProtoMessage() {}

func (x *ArchiveExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArchiveExperimentRequest.ProtoReflect.Descriptor instead.
func (*ArchiveExperimentRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{41}
}

func (x *ArchiveExperimentRequest) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

// Response to ArchiveExperimentRequest.
type ArchiveExperimentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ArchiveExperimentResponse) Reset() {
	*x = ArchiveExperimentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArchiveExperimentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArchiveExperimentResponse) ProtoMessage() {}

func (x *ArchiveExperimentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArchiveExperimentResponse.ProtoReflect.Descriptor instead.
func (*ArchiveExperimentResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{42}
}

// Archive multiple experiments.
type ArchiveExperimentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Selecting experiments by id.
	ExperimentIds []int32 `protobuf:"varint,1,rep,packed,name=experiment_ids,json=experimentIds,proto3" json:"experiment_ids,omitempty"`
	// Targets all experiments matching filters.
	Filters *BulkExperimentFilters `protobuf:"bytes,2,opt,name=filters,proto3" json:"filters,omitempty"`
	// Project id that the experiments belong to.
	ProjectId int32 `protobuf:"varint,3,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *ArchiveExperimentsRequest) Reset() {
	*x = ArchiveExperimentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArchiveExperimentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArchiveExperimentsRequest) ProtoMessage() {}

func (x *ArchiveExperimentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArchiveExperimentsRequest.ProtoReflect.Descriptor instead.
func (*ArchiveExperimentsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{43}
}

func (x *ArchiveExperimentsRequest) GetExperimentIds() []int32 {
	if x != nil {
		return x.ExperimentIds
	}
	return nil
}

func (x *ArchiveExperimentsRequest) GetFilters() *BulkExperimentFilters {
	if x != nil {
		return x.Filters
	}
	return nil
}

func (x *ArchiveExperimentsRequest) GetProjectId() int32 {
	if x != nil {
		return x.ProjectId
	}
	return 0
}

// Response to ArchiveExperimentsRequest.
type ArchiveExperimentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details on success or error for each experiment.
	Results []*ExperimentActionResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
}

func (x *ArchiveExperimentsResponse) Reset() {
	*x = ArchiveExperimentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArchiveExperimentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArchiveExperimentsResponse) ProtoMessage() {}

func (x *ArchiveExperimentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArchiveExperimentsResponse.ProtoReflect.Descriptor instead.
func (*ArchiveExperimentsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{44}
}

func (x *ArchiveExperimentsResponse) GetResults() []*ExperimentActionResult {
	if x != nil {
		return x.Results
	}
	return nil
}

// Unarchive an experiment.
type UnarchiveExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The experiment id.
	Id int32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *UnarchiveExperimentRequest) Reset() {
	*x = UnarchiveExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnarchiveExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnarchiveExperimentRequest) ProtoMessage() {}

func (x *UnarchiveExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnarchiveExperimentRequest.ProtoReflect.Descriptor instead.
func (*UnarchiveExperimentRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{45}
}

func (x *UnarchiveExperimentRequest) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

// Response to UnarchiveExperimentRequest.
type UnarchiveExperimentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UnarchiveExperimentResponse) Reset() {
	*x = UnarchiveExperimentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnarchiveExperimentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnarchiveExperimentResponse) ProtoMessage() {}

func (x *UnarchiveExperimentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnarchiveExperimentResponse.ProtoReflect.Descriptor instead.
func (*UnarchiveExperimentResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{46}
}

// Unarchive multiple experiments.
type UnarchiveExperimentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Selecting experiments by id.
	ExperimentIds []int32 `protobuf:"varint,1,rep,packed,name=experiment_ids,json=experimentIds,proto3" json:"experiment_ids,omitempty"`
	// Targets all experiments matching filters.
	Filters *BulkExperimentFilters `protobuf:"bytes,2,opt,name=filters,proto3" json:"filters,omitempty"`
	// Project id that the experiments belong to.
	ProjectId int32 `protobuf:"varint,3,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *UnarchiveExperimentsRequest) Reset() {
	*x = UnarchiveExperimentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnarchiveExperimentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnarchiveExperimentsRequest) ProtoMessage() {}

func (x *UnarchiveExperimentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnarchiveExperimentsRequest.ProtoReflect.Descriptor instead.
func (*UnarchiveExperimentsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{47}
}

func (x *UnarchiveExperimentsRequest) GetExperimentIds() []int32 {
	if x != nil {
		return x.ExperimentIds
	}
	return nil
}

func (x *UnarchiveExperimentsRequest) GetFilters() *BulkExperimentFilters {
	if x != nil {
		return x.Filters
	}
	return nil
}

func (x *UnarchiveExperimentsRequest) GetProjectId() int32 {
	if x != nil {
		return x.ProjectId
	}
	return 0
}

// Response to UnarchiveExperimentsRequest.
type UnarchiveExperimentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details on success or error for each experiment.
	Results []*ExperimentActionResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
}

func (x *UnarchiveExperimentsResponse) Reset() {
	*x = UnarchiveExperimentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnarchiveExperimentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnarchiveExperimentsResponse) ProtoMessage() {}

func (x *UnarchiveExperimentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnarchiveExperimentsResponse.ProtoReflect.Descriptor instead.
func (*UnarchiveExperimentsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{48}
}

func (x *UnarchiveExperimentsResponse) GetResults() []*ExperimentActionResult {
	if x != nil {
		return x.Results
	}
	return nil
}

// Patch an experiment by providing the updated attributes. Only description,
// label, name, and notes fields will be updated through this endpoint, and
// others will be ignored.
type PatchExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Patched experiment attributes.
	Experiment *experimentv1.PatchExperiment `protobuf:"bytes,2,opt,name=experiment,proto3" json:"experiment,omitempty"`
}

func (x *PatchExperimentRequest) Reset() {
	*x = PatchExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchExperimentRequest) ProtoMessage() {}

func (x *PatchExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchExperimentRequest.ProtoReflect.Descriptor instead.
func (*PatchExperimentRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{49}
}

func (x *PatchExperimentRequest) GetExperiment() *experimentv1.PatchExperiment {
	if x != nil {
		return x.Experiment
	}
	return nil
}

// Response to PatchExperimentRequest.
type PatchExperimentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Patched experiment.
	Experiment *experimentv1.Experiment `protobuf:"bytes,1,opt,name=experiment,proto3" json:"experiment,omitempty"`
}

func (x *PatchExperimentResponse) Reset() {
	*x = PatchExperimentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchExperimentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchExperimentResponse) ProtoMessage() {}

func (x *PatchExperimentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchExperimentResponse.ProtoReflect.Descriptor instead.
func (*PatchExperimentResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{50}
}

func (x *PatchExperimentResponse) GetExperiment() *experimentv1.Experiment {
	if x != nil {
		return x.Experiment
	}
	return nil
}

// Get a list of checkpoints for an experiment.
type GetExperimentCheckpointsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The experiment id.
	Id int32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// Sort checkpoints by the given field.
	//
	// Types that are assignable to SortBy:
	//
	//	*GetExperimentCheckpointsRequest_SortByAttr
	//	*GetExperimentCheckpointsRequest_SortByMetric
	SortBy isGetExperimentCheckpointsRequest_SortBy `protobuf_oneof:"sort_by"`
	// Order checkpoints in either ascending or descending order.
	OrderBy OrderBy `protobuf:"varint,4,opt,name=order_by,json=orderBy,proto3,enum=determined.api.v1.OrderBy" json:"order_by,omitempty"`
	// Skip the number of checkpoints before returning results. Negative values
	// denote number of checkpoints to skip from the end before returning results.
	Offset int32 `protobuf:"varint,5,opt,name=offset,proto3" json:"offset,omitempty"`
	// Limit the number of checkpoints. A value of 0 denotes no limit.
	Limit int32 `protobuf:"varint,6,opt,name=limit,proto3" json:"limit,omitempty"`
	// Limit the checkpoints to those that match the states.
	States []checkpointv1.State `protobuf:"varint,7,rep,packed,name=states,proto3,enum=determined.checkpoint.v1.State" json:"states,omitempty"`
}

func (x *GetExperimentCheckpointsRequest) Reset() {
	*x = GetExperimentCheckpointsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetExperimentCheckpointsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetExperimentCheckpointsRequest) ProtoMessage() {}

func (x *GetExperimentCheckpointsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetExperimentCheckpointsRequest.ProtoReflect.Descriptor instead.
func (*GetExperimentCheckpointsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{51}
}

func (x *GetExperimentCheckpointsRequest) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (m *GetExperimentCheckpointsRequest) GetSortBy() isGetExperimentCheckpointsRequest_SortBy {
	if m != nil {
		return m.SortBy
	}
	return nil
}

func (x *GetExperimentCheckpointsRequest) GetSortByAttr() checkpointv1.SortBy {
	if x, ok := x.GetSortBy().(*GetExperimentCheckpointsRequest_SortByAttr); ok {
		return x.SortByAttr
	}
	return checkpointv1.SortBy_SORT_BY_UNSPECIFIED
}

func (x *GetExperimentCheckpointsRequest) GetSortByMetric() string {
	if x, ok := x.GetSortBy().(*GetExperimentCheckpointsRequest_SortByMetric); ok {
		return x.SortByMetric
	}
	return ""
}

func (x *GetExperimentCheckpointsRequest) GetOrderBy() OrderBy {
	if x != nil {
		return x.OrderBy
	}
	return OrderBy_ORDER_BY_UNSPECIFIED
}

func (x *GetExperimentCheckpointsRequest) GetOffset() int32 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *GetExperimentCheckpointsRequest) GetLimit() int32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *GetExperimentCheckpointsRequest) GetStates() []checkpointv1.State {
	if x != nil {
		return x.States
	}
	return nil
}

type isGetExperimentCheckpointsRequest_SortBy interface {
	isGetExperimentCheckpointsRequest_SortBy()
}

type GetExperimentCheckpointsRequest_SortByAttr struct {
	// Sort by preset checkpoint attribute.
	SortByAttr checkpointv1.SortBy `protobuf:"varint,2,opt,name=sort_by_attr,json=sortByAttr,proto3,enum=determined.checkpoint.v1.SortBy,oneof"`
}

type GetExperimentCheckpointsRequest_SortByMetric struct {
	// Sort by custom validation metric name.
	SortByMetric string `protobuf:"bytes,3,opt,name=sort_by_metric,json=sortByMetric,proto3,oneof"`
}

func (*GetExperimentCheckpointsRequest_SortByAttr) isGetExperimentCheckpointsRequest_SortBy() {}

func (*GetExperimentCheckpointsRequest_SortByMetric) isGetExperimentCheckpointsRequest_SortBy() {}

// Response to GetExperimentCheckpointsRequest.
type GetExperimentCheckpointsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of returned checkpoints.
	Checkpoints []*checkpointv1.Checkpoint `protobuf:"bytes,1,rep,name=checkpoints,proto3" json:"checkpoints,omitempty"`
	// Pagination information of the full dataset.
	Pagination *Pagination `protobuf:"bytes,2,opt,name=pagination,proto3" json:"pagination,omitempty"`
}

func (x *GetExperimentCheckpointsResponse) Reset() {
	*x = GetExperimentCheckpointsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetExperimentCheckpointsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetExperimentCheckpointsResponse) ProtoMessage() {}

func (x *GetExperimentCheckpointsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetExperimentCheckpointsResponse.ProtoReflect.Descriptor instead.
func (*GetExperimentCheckpointsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{52}
}

func (x *GetExperimentCheckpointsResponse) GetCheckpoints() []*checkpointv1.Checkpoint {
	if x != nil {
		return x.Checkpoints
	}
	return nil
}

func (x *GetExperimentCheckpointsResponse) GetPagination() *Pagination {
	if x != nil {
		return x.Pagination
	}
	return nil
}

// Get the validation history for the requested experiment. The
// validation history is a time ordered list of the historical
// best validations.
type GetExperimentValidationHistoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the experiment.
	ExperimentId int32 `protobuf:"varint,1,opt,name=experiment_id,json=experimentId,proto3" json:"experiment_id,omitempty"`
}

func (x *GetExperimentValidationHistoryRequest) Reset() {
	*x = GetExperimentValidationHistoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetExperimentValidationHistoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetExperimentValidationHistoryRequest) ProtoMessage() {}

func (x *GetExperimentValidationHistoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetExperimentValidationHistoryRequest.ProtoReflect.Descriptor instead.
func (*GetExperimentValidationHistoryRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{53}
}

func (x *GetExperimentValidationHistoryRequest) GetExperimentId() int32 {
	if x != nil {
		return x.ExperimentId
	}
	return 0
}

// Response to GetExperimentValidationHistoryRequest.
type GetExperimentValidationHistoryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// validation_history is a collection of zero or more validation metrics for
	// an experiment, describing the best metrics as they were reported through
	// the lifetime of an experiment. The historical list of best validations.
	ValidationHistory []*experimentv1.ValidationHistoryEntry `protobuf:"bytes,1,rep,name=validation_history,json=validationHistory,proto3" json:"validation_history,omitempty"`
}

func (x *GetExperimentValidationHistoryResponse) Reset() {
	*x = GetExperimentValidationHistoryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetExperimentValidationHistoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetExperimentValidationHistoryResponse) ProtoMessage() {}

func (x *GetExperimentValidationHistoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetExperimentValidationHistoryResponse.ProtoReflect.Descriptor instead.
func (*GetExperimentValidationHistoryResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{54}
}

func (x *GetExperimentValidationHistoryResponse) GetValidationHistory() []*experimentv1.ValidationHistoryEntry {
	if x != nil {
		return x.ValidationHistory
	}
	return nil
}

// Request to create a new experiment.
type CreateExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Experiment context.
	ModelDefinition []*utilv1.File `protobuf:"bytes,1,rep,name=model_definition,json=modelDefinition,proto3" json:"model_definition,omitempty"`
	// Experiment config (YAML).
	Config string `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// Only validate instead of creating the experiment. A dry run.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Parent experiment id.
	ParentId int32 `protobuf:"varint,4,opt,name=parent_id,json=parentId,proto3" json:"parent_id,omitempty"`
	// Request to auto-activate the experiment.
	Activate bool `protobuf:"varint,5,opt,name=activate,proto3" json:"activate,omitempty"`
	// Project id to contain the experiment.
	ProjectId int32 `protobuf:"varint,6,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Template to use for the experiment.
	Template *string `protobuf:"bytes,7,opt,name=template,proto3,oneof" json:"template,omitempty"`
	// Unmanaged experiments are detached.
	Unmanaged *bool `protobuf:"varint,40,opt,name=unmanaged,proto3,oneof" json:"unmanaged,omitempty"`
}

func (x *CreateExperimentRequest) Reset() {
	*x = CreateExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateExperimentRequest) ProtoMessage() {}

func (x *CreateExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateExperimentRequest.ProtoReflect.Descriptor instead.
func (*CreateExperimentRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{55}
}

func (x *CreateExperimentRequest) GetModelDefinition() []*utilv1.File {
	if x != nil {
		return x.ModelDefinition
	}
	return nil
}

func (x *CreateExperimentRequest) GetConfig() string {
	if x != nil {
		return x.Config
	}
	return ""
}

func (x *CreateExperimentRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *CreateExperimentRequest) GetParentId() int32 {
	if x != nil {
		return x.ParentId
	}
	return 0
}

func (x *CreateExperimentRequest) GetActivate() bool {
	if x != nil {
		return x.Activate
	}
	return false
}

func (x *CreateExperimentRequest) GetProjectId() int32 {
	if x != nil {
		return x.ProjectId
	}
	return 0
}

func (x *CreateExperimentRequest) GetTemplate() string {
	if x != nil && x.Template != nil {
		return *x.Template
	}
	return ""
}

func (x *CreateExperimentRequest) GetUnmanaged() bool {
	if x != nil && x.Unmanaged != nil {
		return *x.Unmanaged
	}
	return false
}

// Response to CreateExperimentRequest.
type CreateExperimentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The created experiment.
	Experiment *experimentv1.Experiment `protobuf:"bytes,1,opt,name=experiment,proto3" json:"experiment,omitempty"`
	// The created experiment config.
	Config *_struct.Struct `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// List of any related warnings.
	Warnings []LaunchWarning `protobuf:"varint,3,rep,packed,name=warnings,proto3,enum=determined.api.v1.LaunchWarning" json:"warnings,omitempty"`
}

func (x *CreateExperimentResponse) Reset() {
	*x = CreateExperimentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateExperimentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateExperimentResponse) ProtoMessage() {}

func (x *CreateExperimentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateExperimentResponse.ProtoReflect.Descriptor instead.
func (*CreateExperimentResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{56}
}

func (x *CreateExperimentResponse) GetExperiment() *experimentv1.Experiment {
	if x != nil {
		return x.Experiment
	}
	return nil
}

func (x *CreateExperimentResponse) GetConfig() *_struct.Struct {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *CreateExperimentResponse) GetWarnings() []LaunchWarning {
	if x != nil {
		return x.Warnings
	}
	return nil
}

// PutExperimentRequest is CreateExperimentRequest with external_experiment_id
// field added. Use for unmanaged experiments only.
type PutExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// CreateExperimentRequest payload.
	CreateExperimentRequest *CreateExperimentRequest `protobuf:"bytes,1,opt,name=create_experiment_request,json=createExperimentRequest,proto3" json:"create_experiment_request,omitempty"`
	// External experiment id.
	ExternalExperimentId string `protobuf:"bytes,41,opt,name=external_experiment_id,json=externalExperimentId,proto3" json:"external_experiment_id,omitempty"`
}

func (x *PutExperimentRequest) Reset() {
	*x = PutExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PutExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PutExperimentRequest) ProtoMessage() {}

func (x *PutExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PutExperimentRequest.ProtoReflect.Descriptor instead.
func (*PutExperimentRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{57}
}

func (x *PutExperimentRequest) GetCreateExperimentRequest() *CreateExperimentRequest {
	if x != nil {
		return x.CreateExperimentRequest
	}
	return nil
}

func (x *PutExperimentRequest) GetExternalExperimentId() string {
	if x != nil {
		return x.ExternalExperimentId
	}
	return ""
}

// Response to PutExperimentRequest.
type PutExperimentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The created experiment.
	Experiment *experimentv1.Experiment `protobuf:"bytes,1,opt,name=experiment,proto3" json:"experiment,omitempty"`
	// The created experiment config.
	Config *_struct.Struct `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"` // Note: no LaunchWarnings.
}

func (x *PutExperimentResponse) Reset() {
	*x = PutExperimentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PutExperimentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PutExperimentResponse) ProtoMessage() {}

func (x *PutExperimentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PutExperimentResponse.ProtoReflect.Descriptor instead.
func (*PutExperimentResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{58}
}

func (x *PutExperimentResponse) GetExperiment() *experimentv1.Experiment {
	if x != nil {
		return x.Experiment
	}
	return nil
}

func (x *PutExperimentResponse) GetConfig() *_struct.Struct {
	if x != nil {
		return x.Config
	}
	return nil
}

// Request to continue an experiment.
type ContinueExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Experiment ID to continue.
	Id int32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// Experiment config (YAML) to merge with the experiment's config.
	OverrideConfig string `protobuf:"bytes,2,opt,name=override_config,json=overrideConfig,proto3" json:"override_config,omitempty"`
}

func (x *ContinueExperimentRequest) Reset() {
	*x = ContinueExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContinueExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContinueExperimentRequest) ProtoMessage() {}

func (x *ContinueExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContinueExperimentRequest.ProtoReflect.Descriptor instead.
func (*ContinueExperimentRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{59}
}

func (x *ContinueExperimentRequest) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *ContinueExperimentRequest) GetOverrideConfig() string {
	if x != nil {
		return x.OverrideConfig
	}
	return ""
}

// Request to continue an experiment.
type ContinueExperimentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The created experiment.
	Experiment *experimentv1.Experiment `protobuf:"bytes,1,opt,name=experiment,proto3" json:"experiment,omitempty"`
	// List of any related warnings.
	Warnings []LaunchWarning `protobuf:"varint,2,rep,packed,name=warnings,proto3,enum=determined.api.v1.LaunchWarning" json:"warnings,omitempty"`
}

func (x *ContinueExperimentResponse) Reset() {
	*x = ContinueExperimentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContinueExperimentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContinueExperimentResponse) ProtoMessage() {}

func (x *ContinueExperimentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContinueExperimentResponse.ProtoReflect.Descriptor instead.
func (*ContinueExperimentResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{60}
}

func (x *ContinueExperimentResponse) GetExperiment() *experimentv1.Experiment {
	if x != nil {
		return x.Experiment
	}
	return nil
}

func (x *ContinueExperimentResponse) GetWarnings() []LaunchWarning {
	if x != nil {
		return x.Warnings
	}
	return nil
}

// Request for the set of metrics recorded by multiple experiments.
type ExpMetricNamesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ids for the experiments.
	Ids []int32 `protobuf:"varint,1,rep,packed,name=ids,proto3" json:"ids,omitempty"`
	// Seconds to wait when polling for updates.
	PeriodSeconds int32 `protobuf:"varint,2,opt,name=period_seconds,json=periodSeconds,proto3" json:"period_seconds,omitempty"`
}

func (x *ExpMetricNamesRequest) Reset() {
	*x = ExpMetricNamesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExpMetricNamesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExpMetricNamesRequest) ProtoMessage() {}

func (x *ExpMetricNamesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExpMetricNamesRequest.ProtoReflect.Descriptor instead.
func (*ExpMetricNamesRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{61}
}

func (x *ExpMetricNamesRequest) GetIds() []int32 {
	if x != nil {
		return x.Ids
	}
	return nil
}

func (x *ExpMetricNamesRequest) GetPeriodSeconds() int32 {
	if x != nil {
		return x.PeriodSeconds
	}
	return 0
}

// Response to ExpMetricNamesRequest.
type ExpMetricNamesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The names of the searcher metrics.
	SearcherMetrics []string `protobuf:"bytes,1,rep,name=searcher_metrics,json=searcherMetrics,proto3" json:"searcher_metrics,omitempty"`
	// List of training metric names.
	//
	// Deprecated: Do not use.
	TrainingMetrics []string `protobuf:"bytes,2,rep,name=training_metrics,json=trainingMetrics,proto3" json:"training_metrics,omitempty"`
	// List of validation metric names.
	//
	// Deprecated: Do not use.
	ValidationMetrics []string `protobuf:"bytes,3,rep,name=validation_metrics,json=validationMetrics,proto3" json:"validation_metrics,omitempty"`
	// List of metric group-name pairs.
	MetricNames []*metricv1.MetricIdentifier `protobuf:"bytes,4,rep,name=metric_names,json=metricNames,proto3" json:"metric_names,omitempty"`
}

func (x *ExpMetricNamesResponse) Reset() {
	*x = ExpMetricNamesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExpMetricNamesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExpMetricNamesResponse) ProtoMessage() {}

func (x *ExpMetricNamesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExpMetricNamesResponse.ProtoReflect.Descriptor instead.
func (*ExpMetricNamesResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{62}
}

func (x *ExpMetricNamesResponse) GetSearcherMetrics() []string {
	if x != nil {
		return x.SearcherMetrics
	}
	return nil
}

// Deprecated: Do not use.
func (x *ExpMetricNamesResponse) GetTrainingMetrics() []string {
	if x != nil {
		return x.TrainingMetrics
	}
	return nil
}

// Deprecated: Do not use.
func (x *ExpMetricNamesResponse) GetValidationMetrics() []string {
	if x != nil {
		return x.ValidationMetrics
	}
	return nil
}

func (x *ExpMetricNamesResponse) GetMetricNames() []*metricv1.MetricIdentifier {
	if x != nil {
		return x.MetricNames
	}
	return nil
}

// Request the milestones (in batches processed) at which a metric is recorded
// by an experiment.
type MetricBatchesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the experiment.
	ExperimentId int32 `protobuf:"varint,1,opt,name=experiment_id,json=experimentId,proto3" json:"experiment_id,omitempty"`
	// A metric name.
	MetricName string `protobuf:"bytes,2,opt,name=metric_name,json=metricName,proto3" json:"metric_name,omitempty"`
	// The type of metric.
	//
	// Deprecated: Do not use.
	MetricType MetricType `protobuf:"varint,3,opt,name=metric_type,json=metricType,proto3,enum=determined.api.v1.MetricType" json:"metric_type,omitempty"`
	// Metric group (training, validation, etc).
	Group string `protobuf:"bytes,5,opt,name=group,proto3" json:"group,omitempty"`
	// Seconds to wait when polling for updates.
	PeriodSeconds int32 `protobuf:"varint,4,opt,name=period_seconds,json=periodSeconds,proto3" json:"period_seconds,omitempty"`
}

func (x *MetricBatchesRequest) Reset() {
	*x = MetricBatchesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetricBatchesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricBatchesRequest) ProtoMessage() {}

func (x *MetricBatchesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricBatchesRequest.ProtoReflect.Descriptor instead.
func (*MetricBatchesRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{63}
}

func (x *MetricBatchesRequest) GetExperimentId() int32 {
	if x != nil {
		return x.ExperimentId
	}
	return 0
}

func (x *MetricBatchesRequest) GetMetricName() string {
	if x != nil {
		return x.MetricName
	}
	return ""
}

// Deprecated: Do not use.
func (x *MetricBatchesRequest) GetMetricType() MetricType {
	if x != nil {
		return x.MetricType
	}
	return MetricType_METRIC_TYPE_UNSPECIFIED
}

func (x *MetricBatchesRequest) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

func (x *MetricBatchesRequest) GetPeriodSeconds() int32 {
	if x != nil {
		return x.PeriodSeconds
	}
	return 0
}

// Response to MetricBatchesRequest.
type MetricBatchesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Milestones (in batches processed) at which the specified metric is
	// recorded.
	Batches []int32 `protobuf:"varint,1,rep,packed,name=batches,proto3" json:"batches,omitempty"`
}

func (x *MetricBatchesResponse) Reset() {
	*x = MetricBatchesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetricBatchesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricBatchesResponse) ProtoMessage() {}

func (x *MetricBatchesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricBatchesResponse.ProtoReflect.Descriptor instead.
func (*MetricBatchesResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{64}
}

func (x *MetricBatchesResponse) GetBatches() []int32 {
	if x != nil {
		return x.Batches
	}
	return nil
}

// Request metrics from all trials at a point of progress.
type TrialsSnapshotRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the experiment.
	ExperimentId int32 `protobuf:"varint,1,opt,name=experiment_id,json=experimentId,proto3" json:"experiment_id,omitempty"`
	// A metric name.
	MetricName string `protobuf:"bytes,2,opt,name=metric_name,json=metricName,proto3" json:"metric_name,omitempty"`
	// The type of metric.
	//
	// Deprecated: Do not use.
	MetricType MetricType `protobuf:"varint,3,opt,name=metric_type,json=metricType,proto3,enum=determined.api.v1.MetricType" json:"metric_type,omitempty"`
	// Metric group (training, validation, etc).
	Group string `protobuf:"bytes,7,opt,name=group,proto3" json:"group,omitempty"`
	// The point of progress at which to query metrics.
	BatchesProcessed int32 `protobuf:"varint,4,opt,name=batches_processed,json=batchesProcessed,proto3" json:"batches_processed,omitempty"`
	// A range either side of batches_processed to include near-misses.
	BatchesMargin int32 `protobuf:"varint,5,opt,name=batches_margin,json=batchesMargin,proto3" json:"batches_margin,omitempty"`
	// Seconds to wait when polling for updates.
	PeriodSeconds int32 `protobuf:"varint,6,opt,name=period_seconds,json=periodSeconds,proto3" json:"period_seconds,omitempty"`
}

func (x *TrialsSnapshotRequest) Reset() {
	*x = TrialsSnapshotRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrialsSnapshotRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrialsSnapshotRequest) ProtoMessage() {}

func (x *TrialsSnapshotRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrialsSnapshotRequest.ProtoReflect.Descriptor instead.
func (*TrialsSnapshotRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{65}
}

func (x *TrialsSnapshotRequest) GetExperimentId() int32 {
	if x != nil {
		return x.ExperimentId
	}
	return 0
}

func (x *TrialsSnapshotRequest) GetMetricName() string {
	if x != nil {
		return x.MetricName
	}
	return ""
}

// Deprecated: Do not use.
func (x *TrialsSnapshotRequest) GetMetricType() MetricType {
	if x != nil {
		return x.MetricType
	}
	return MetricType_METRIC_TYPE_UNSPECIFIED
}

func (x *TrialsSnapshotRequest) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

func (x *TrialsSnapshotRequest) GetBatchesProcessed() int32 {
	if x != nil {
		return x.BatchesProcessed
	}
	return 0
}

func (x *TrialsSnapshotRequest) GetBatchesMargin() int32 {
	if x != nil {
		return x.BatchesMargin
	}
	return 0
}

func (x *TrialsSnapshotRequest) GetPeriodSeconds() int32 {
	if x != nil {
		return x.PeriodSeconds
	}
	return 0
}

// Response to TrialsSnapshotRequest
type TrialsSnapshotResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of trials.
	Trials []*TrialsSnapshotResponse_Trial `protobuf:"bytes,1,rep,name=trials,proto3" json:"trials,omitempty"`
}

func (x *TrialsSnapshotResponse) Reset() {
	*x = TrialsSnapshotResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrialsSnapshotResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrialsSnapshotResponse) ProtoMessage() {}

func (x *TrialsSnapshotResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrialsSnapshotResponse.ProtoReflect.Descriptor instead.
func (*TrialsSnapshotResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{66}
}

func (x *TrialsSnapshotResponse) GetTrials() []*TrialsSnapshotResponse_Trial {
	if x != nil {
		return x.Trials
	}
	return nil
}

// Request a sample of metrics over time for a sample of trials.
type TrialsSampleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the experiment.
	ExperimentId int32 `protobuf:"varint,1,opt,name=experiment_id,json=experimentId,proto3" json:"experiment_id,omitempty"`
	// A metric name.
	MetricName string `protobuf:"bytes,2,opt,name=metric_name,json=metricName,proto3" json:"metric_name,omitempty"`
	// The type of metric.
	//
	// Deprecated: Do not use.
	MetricType MetricType `protobuf:"varint,3,opt,name=metric_type,json=metricType,proto3,enum=determined.api.v1.MetricType" json:"metric_type,omitempty"`
	// Metric group (training, validation, etc).
	Group string `protobuf:"bytes,9,opt,name=group,proto3" json:"group,omitempty"`
	// Maximum number of trials to fetch data for.
	MaxTrials int32 `protobuf:"varint,4,opt,name=max_trials,json=maxTrials,proto3" json:"max_trials,omitempty"`
	// Maximum number of initial / historical data points.
	MaxDatapoints int32 `protobuf:"varint,5,opt,name=max_datapoints,json=maxDatapoints,proto3" json:"max_datapoints,omitempty"`
	// Beginning of window (inclusive) to fetch data for.
	StartBatches int32 `protobuf:"varint,6,opt,name=start_batches,json=startBatches,proto3" json:"start_batches,omitempty"`
	// Ending of window (inclusive) to fetch data for.
	EndBatches int32 `protobuf:"varint,7,opt,name=end_batches,json=endBatches,proto3" json:"end_batches,omitempty"`
	// Seconds to wait when polling for updates.
	PeriodSeconds int32 `protobuf:"varint,8,opt,name=period_seconds,json=periodSeconds,proto3" json:"period_seconds,omitempty"`
}

func (x *TrialsSampleRequest) Reset() {
	*x = TrialsSampleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrialsSampleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrialsSampleRequest) ProtoMessage() {}

func (x *TrialsSampleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrialsSampleRequest.ProtoReflect.Descriptor instead.
func (*TrialsSampleRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{67}
}

func (x *TrialsSampleRequest) GetExperimentId() int32 {
	if x != nil {
		return x.ExperimentId
	}
	return 0
}

func (x *TrialsSampleRequest) GetMetricName() string {
	if x != nil {
		return x.MetricName
	}
	return ""
}

// Deprecated: Do not use.
func (x *TrialsSampleRequest) GetMetricType() MetricType {
	if x != nil {
		return x.MetricType
	}
	return MetricType_METRIC_TYPE_UNSPECIFIED
}

func (x *TrialsSampleRequest) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

func (x *TrialsSampleRequest) GetMaxTrials() int32 {
	if x != nil {
		return x.MaxTrials
	}
	return 0
}

func (x *TrialsSampleRequest) GetMaxDatapoints() int32 {
	if x != nil {
		return x.MaxDatapoints
	}
	return 0
}

func (x *TrialsSampleRequest) GetStartBatches() int32 {
	if x != nil {
		return x.StartBatches
	}
	return 0
}

func (x *TrialsSampleRequest) GetEndBatches() int32 {
	if x != nil {
		return x.EndBatches
	}
	return 0
}

func (x *TrialsSampleRequest) GetPeriodSeconds() int32 {
	if x != nil {
		return x.PeriodSeconds
	}
	return 0
}

// Response to TrialsSampleRequest
type TrialsSampleResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A historical or incremental series of data points for the trials.
	Trials []*TrialsSampleResponse_Trial `protobuf:"bytes,1,rep,name=trials,proto3" json:"trials,omitempty"`
	// IDs of trials that are newly included in the data.
	PromotedTrials []int32 `protobuf:"varint,2,rep,packed,name=promoted_trials,json=promotedTrials,proto3" json:"promoted_trials,omitempty"`
	// IDs of trials that are no longer included in the top N trials.
	DemotedTrials []int32 `protobuf:"varint,3,rep,packed,name=demoted_trials,json=demotedTrials,proto3" json:"demoted_trials,omitempty"`
}

func (x *TrialsSampleResponse) Reset() {
	*x = TrialsSampleResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrialsSampleResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrialsSampleResponse) ProtoMessage() {}

func (x *TrialsSampleResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrialsSampleResponse.ProtoReflect.Descriptor instead.
func (*TrialsSampleResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{68}
}

func (x *TrialsSampleResponse) GetTrials() []*TrialsSampleResponse_Trial {
	if x != nil {
		return x.Trials
	}
	return nil
}

func (x *TrialsSampleResponse) GetPromotedTrials() []int32 {
	if x != nil {
		return x.PromotedTrials
	}
	return nil
}

func (x *TrialsSampleResponse) GetDemotedTrials() []int32 {
	if x != nil {
		return x.DemotedTrials
	}
	return nil
}

// Request for an experiment model definition.
type GetModelDefRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the experiment.
	ExperimentId int32 `protobuf:"varint,1,opt,name=experiment_id,json=experimentId,proto3" json:"experiment_id,omitempty"`
}

func (x *GetModelDefRequest) Reset() {
	*x = GetModelDefRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetModelDefRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModelDefRequest) ProtoMessage() {}

func (x *GetModelDefRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetModelDefRequest.ProtoReflect.Descriptor instead.
func (*GetModelDefRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{69}
}

func (x *GetModelDefRequest) GetExperimentId() int32 {
	if x != nil {
		return x.ExperimentId
	}
	return 0
}

// Response to GetModelDefRequest.
type GetModelDefResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The base64-encoded, gzipped, tarball.
	B64Tgz string `protobuf:"bytes,1,opt,name=b64_tgz,json=b64Tgz,proto3" json:"b64_tgz,omitempty"`
}

func (x *GetModelDefResponse) Reset() {
	*x = GetModelDefResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetModelDefResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModelDefResponse) ProtoMessage() {}

func (x *GetModelDefResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetModelDefResponse.ProtoReflect.Descriptor instead.
func (*GetModelDefResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{70}
}

func (x *GetModelDefResponse) GetB64Tgz() string {
	if x != nil {
		return x.B64Tgz
	}
	return ""
}

// Request to move an experiment into a project.
type MoveExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the experiment being moved.
	ExperimentId int32 `protobuf:"varint,1,opt,name=experiment_id,json=experimentId,proto3" json:"experiment_id,omitempty"`
	// The id of the new parent project.
	DestinationProjectId int32 `protobuf:"varint,2,opt,name=destination_project_id,json=destinationProjectId,proto3" json:"destination_project_id,omitempty"`
}

func (x *MoveExperimentRequest) Reset() {
	*x = MoveExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MoveExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveExperimentRequest) ProtoMessage() {}

func (x *MoveExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveExperimentRequest.ProtoReflect.Descriptor instead.
func (*MoveExperimentRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{71}
}

func (x *MoveExperimentRequest) GetExperimentId() int32 {
	if x != nil {
		return x.ExperimentId
	}
	return 0
}

func (x *MoveExperimentRequest) GetDestinationProjectId() int32 {
	if x != nil {
		return x.DestinationProjectId
	}
	return 0
}

// Response to MoveExperimentRequest.
type MoveExperimentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *MoveExperimentResponse) Reset() {
	*x = MoveExperimentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MoveExperimentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveExperimentResponse) ProtoMessage() {}

func (x *MoveExperimentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveExperimentResponse.ProtoReflect.Descriptor instead.
func (*MoveExperimentResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{72}
}

// Request to move an experiment into a project.
type MoveExperimentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ids of the experiments being moved.
	ExperimentIds []int32 `protobuf:"varint,1,rep,packed,name=experiment_ids,json=experimentIds,proto3" json:"experiment_ids,omitempty"`
	// The id of the new parent project.
	DestinationProjectId int32 `protobuf:"varint,2,opt,name=destination_project_id,json=destinationProjectId,proto3" json:"destination_project_id,omitempty"`
	// Targets all experiments matching filters.
	Filters *BulkExperimentFilters `protobuf:"bytes,3,opt,name=filters,proto3" json:"filters,omitempty"`
	// Project id that the experiments belong to.
	ProjectId int32 `protobuf:"varint,4,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *MoveExperimentsRequest) Reset() {
	*x = MoveExperimentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MoveExperimentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveExperimentsRequest) ProtoMessage() {}

func (x *MoveExperimentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveExperimentsRequest.ProtoReflect.Descriptor instead.
func (*MoveExperimentsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{73}
}

func (x *MoveExperimentsRequest) GetExperimentIds() []int32 {
	if x != nil {
		return x.ExperimentIds
	}
	return nil
}

func (x *MoveExperimentsRequest) GetDestinationProjectId() int32 {
	if x != nil {
		return x.DestinationProjectId
	}
	return 0
}

func (x *MoveExperimentsRequest) GetFilters() *BulkExperimentFilters {
	if x != nil {
		return x.Filters
	}
	return nil
}

func (x *MoveExperimentsRequest) GetProjectId() int32 {
	if x != nil {
		return x.ProjectId
	}
	return 0
}

// Response to MoveExperimentsRequest.
type MoveExperimentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details on success or error for each experiment.
	Results []*ExperimentActionResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
}

func (x *MoveExperimentsResponse) Reset() {
	*x = MoveExperimentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MoveExperimentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveExperimentsResponse) ProtoMessage() {}

func (x *MoveExperimentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveExperimentsResponse.ProtoReflect.Descriptor instead.
func (*MoveExperimentsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{74}
}

func (x *MoveExperimentsResponse) GetResults() []*ExperimentActionResult {
	if x != nil {
		return x.Results
	}
	return nil
}

// Request to get model definition file tree of an experiment.
type GetModelDefTreeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the experiment.
	ExperimentId int32 `protobuf:"varint,1,opt,name=experiment_id,json=experimentId,proto3" json:"experiment_id,omitempty"`
}

func (x *GetModelDefTreeRequest) Reset() {
	*x = GetModelDefTreeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetModelDefTreeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModelDefTreeRequest) ProtoMessage() {}

func (x *GetModelDefTreeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetModelDefTreeRequest.ProtoReflect.Descriptor instead.
func (*GetModelDefTreeRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{75}
}

func (x *GetModelDefTreeRequest) GetExperimentId() int32 {
	if x != nil {
		return x.ExperimentId
	}
	return 0
}

// Response to GetModelDefTreeRequest.
type GetModelDefTreeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// File tree of an experiment.
	Files []*experimentv1.FileNode `protobuf:"bytes,1,rep,name=files,proto3" json:"files,omitempty"`
}

func (x *GetModelDefTreeResponse) Reset() {
	*x = GetModelDefTreeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetModelDefTreeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModelDefTreeResponse) ProtoMessage() {}

func (x *GetModelDefTreeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetModelDefTreeResponse.ProtoReflect.Descriptor instead.
func (*GetModelDefTreeResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{76}
}

func (x *GetModelDefTreeResponse) GetFiles() []*experimentv1.FileNode {
	if x != nil {
		return x.Files
	}
	return nil
}

// Request to get a file of model definition.
type GetModelDefFileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the experiment.
	ExperimentId int32 `protobuf:"varint,1,opt,name=experiment_id,json=experimentId,proto3" json:"experiment_id,omitempty"`
	// The path of file.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *GetModelDefFileRequest) Reset() {
	*x = GetModelDefFileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetModelDefFileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModelDefFileRequest) ProtoMessage() {}

func (x *GetModelDefFileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetModelDefFileRequest.ProtoReflect.Descriptor instead.
func (*GetModelDefFileRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{77}
}

func (x *GetModelDefFileRequest) GetExperimentId() int32 {
	if x != nil {
		return x.ExperimentId
	}
	return 0
}

func (x *GetModelDefFileRequest) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

// Response to GetModelDefFileRequest.
type GetModelDefFileResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Content of file.
	File []byte `protobuf:"bytes,1,opt,name=file,proto3" json:"file,omitempty"`
}

func (x *GetModelDefFileResponse) Reset() {
	*x = GetModelDefFileResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetModelDefFileResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModelDefFileResponse) ProtoMessage() {}

func (x *GetModelDefFileResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetModelDefFileResponse.ProtoReflect.Descriptor instead.
func (*GetModelDefFileResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{78}
}

func (x *GetModelDefFileResponse) GetFile() []byte {
	if x != nil {
		return x.File
	}
	return nil
}

// Request for searching experiments
type SearchExperimentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the project to look at
	ProjectId *int32 `protobuf:"varint,1,opt,name=project_id,json=projectId,proto3,oneof" json:"project_id,omitempty"`
	// How many experiments to skip before including in the results
	Offset int32 `protobuf:"varint,2,opt,name=offset,proto3" json:"offset,omitempty"`
	// How many results to show
	Limit int32 `protobuf:"varint,3,opt,name=limit,proto3" json:"limit,omitempty"`
	// Sort parameters in the format <col1>=(asc|desc),<col2>=(asc|desc)
	Sort *string `protobuf:"bytes,4,opt,name=sort,proto3,oneof" json:"sort,omitempty"`
	// Filter expression
	Filter *string `protobuf:"bytes,5,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
}

func (x *SearchExperimentsRequest) Reset() {
	*x = SearchExperimentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchExperimentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchExperimentsRequest) ProtoMessage() {}

func (x *SearchExperimentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchExperimentsRequest.ProtoReflect.Descriptor instead.
func (*SearchExperimentsRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{79}
}

func (x *SearchExperimentsRequest) GetProjectId() int32 {
	if x != nil && x.ProjectId != nil {
		return *x.ProjectId
	}
	return 0
}

func (x *SearchExperimentsRequest) GetOffset() int32 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *SearchExperimentsRequest) GetLimit() int32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *SearchExperimentsRequest) GetSort() string {
	if x != nil && x.Sort != nil {
		return *x.Sort
	}
	return ""
}

func (x *SearchExperimentsRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

// combination of experiment and best trial with metrics
type SearchExperimentExperiment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The experiment in question
	Experiment *experimentv1.Experiment `protobuf:"bytes,1,opt,name=experiment,proto3" json:"experiment,omitempty"`
	// The best performing trial associated with the experiment
	BestTrial *trialv1.Trial `protobuf:"bytes,2,opt,name=best_trial,json=bestTrial,proto3" json:"best_trial,omitempty"`
}

func (x *SearchExperimentExperiment) Reset() {
	*x = SearchExperimentExperiment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[80]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchExperimentExperiment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchExperimentExperiment) ProtoMessage() {}

func (x *SearchExperimentExperiment) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[80]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchExperimentExperiment.ProtoReflect.Descriptor instead.
func (*SearchExperimentExperiment) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{80}
}

func (x *SearchExperimentExperiment) GetExperiment() *experimentv1.Experiment {
	if x != nil {
		return x.Experiment
	}
	return nil
}

func (x *SearchExperimentExperiment) GetBestTrial() *trialv1.Trial {
	if x != nil {
		return x.BestTrial
	}
	return nil
}

// Response for searching experiments
type SearchExperimentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of returned experiments.
	Experiments []*SearchExperimentExperiment `protobuf:"bytes,1,rep,name=experiments,proto3" json:"experiments,omitempty"`
	// Pagination information of the full dataset
	Pagination *Pagination `protobuf:"bytes,2,opt,name=pagination,proto3" json:"pagination,omitempty"`
}

func (x *SearchExperimentsResponse) Reset() {
	*x = SearchExperimentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[81]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchExperimentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchExperimentsResponse) ProtoMessage() {}

func (x *SearchExperimentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[81]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchExperimentsResponse.ProtoReflect.Descriptor instead.
func (*SearchExperimentsResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{81}
}

func (x *SearchExperimentsResponse) GetExperiments() []*SearchExperimentExperiment {
	if x != nil {
		return x.Experiments
	}
	return nil
}

func (x *SearchExperimentsResponse) GetPagination() *Pagination {
	if x != nil {
		return x.Pagination
	}
	return nil
}

// Request to delete a tensorboard files.
type DeleteTensorboardFilesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of experiment that the tensorboard files are linked to.
	ExperimentId int32 `protobuf:"varint,1,opt,name=experiment_id,json=experimentId,proto3" json:"experiment_id,omitempty"`
}

func (x *DeleteTensorboardFilesRequest) Reset() {
	*x = DeleteTensorboardFilesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[82]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTensorboardFilesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTensorboardFilesRequest) ProtoMessage() {}

func (x *DeleteTensorboardFilesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[82]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTensorboardFilesRequest.ProtoReflect.Descriptor instead.
func (*DeleteTensorboardFilesRequest) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{82}
}

func (x *DeleteTensorboardFilesRequest) GetExperimentId() int32 {
	if x != nil {
		return x.ExperimentId
	}
	return 0
}

// Response to DeleteTensorboardRequest.
type DeleteTensorboardFilesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeleteTensorboardFilesResponse) Reset() {
	*x = DeleteTensorboardFilesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[83]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTensorboardFilesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTensorboardFilesResponse) ProtoMessage() {}

func (x *DeleteTensorboardFilesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[83]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTensorboardFilesResponse.ProtoReflect.Descriptor instead.
func (*DeleteTensorboardFilesResponse) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{83}
}

// Metric value and metadata for a trial that has progress this far.
type TrialsSnapshotResponse_Trial struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the trial.
	TrialId int32 `protobuf:"varint,1,opt,name=trial_id,json=trialId,proto3" json:"trial_id,omitempty"`
	// A dictionary of hyperparameter values for this trial.
	Hparams *_struct.Struct `protobuf:"bytes,2,opt,name=hparams,proto3" json:"hparams,omitempty"`
	// The value of the metric in this trial at this point.
	Metric float64 `protobuf:"fixed64,3,opt,name=metric,proto3" json:"metric,omitempty"`
	// The number of batches processed for this particular datapoint.
	BatchesProcessed int32 `protobuf:"varint,4,opt,name=batches_processed,json=batchesProcessed,proto3" json:"batches_processed,omitempty"`
}

func (x *TrialsSnapshotResponse_Trial) Reset() {
	*x = TrialsSnapshotResponse_Trial{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[84]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrialsSnapshotResponse_Trial) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrialsSnapshotResponse_Trial) ProtoMessage() {}

func (x *TrialsSnapshotResponse_Trial) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[84]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrialsSnapshotResponse_Trial.ProtoReflect.Descriptor instead.
func (*TrialsSnapshotResponse_Trial) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{66, 0}
}

func (x *TrialsSnapshotResponse_Trial) GetTrialId() int32 {
	if x != nil {
		return x.TrialId
	}
	return 0
}

func (x *TrialsSnapshotResponse_Trial) GetHparams() *_struct.Struct {
	if x != nil {
		return x.Hparams
	}
	return nil
}

func (x *TrialsSnapshotResponse_Trial) GetMetric() float64 {
	if x != nil {
		return x.Metric
	}
	return 0
}

func (x *TrialsSnapshotResponse_Trial) GetBatchesProcessed() int32 {
	if x != nil {
		return x.BatchesProcessed
	}
	return 0
}

// Metadata and metrics stream from a trial.
type TrialsSampleResponse_Trial struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the trial.
	TrialId int32 `protobuf:"varint,1,opt,name=trial_id,json=trialId,proto3" json:"trial_id,omitempty"`
	// Hyperparamters values for this specific trial.
	Hparams *_struct.Struct `protobuf:"bytes,2,opt,name=hparams,proto3" json:"hparams,omitempty"`
	// A possibly down-sampled series of metric readings through the progress of
	// the trial.
	Data []*DataPoint `protobuf:"bytes,3,rep,name=data,proto3" json:"data,omitempty"`
}

func (x *TrialsSampleResponse_Trial) Reset() {
	*x = TrialsSampleResponse_Trial{}
	if protoimpl.UnsafeEnabled {
		mi := &file_determined_api_v1_experiment_proto_msgTypes[85]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrialsSampleResponse_Trial) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrialsSampleResponse_Trial) ProtoMessage() {}

func (x *TrialsSampleResponse_Trial) ProtoReflect() protoreflect.Message {
	mi := &file_determined_api_v1_experiment_proto_msgTypes[85]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrialsSampleResponse_Trial.ProtoReflect.Descriptor instead.
func (*TrialsSampleResponse_Trial) Descriptor() ([]byte, []int) {
	return file_determined_api_v1_experiment_proto_rawDescGZIP(), []int{68, 0}
}

func (x *TrialsSampleResponse_Trial) GetTrialId() int32 {
	if x != nil {
		return x.TrialId
	}
	return 0
}

func (x *TrialsSampleResponse_Trial) GetHparams() *_struct.Struct {
	if x != nil {
		return x.Hparams
	}
	return nil
}

func (x *TrialsSampleResponse_Trial) GetData() []*DataPoint {
	if x != nil {
		return x.Data
	}
	return nil
}

var File_determined_api_v1_experiment_proto protoreflect.FileDescriptor

var file_determined_api_v1_experiment_proto_rawDesc = []byte{
	0x0a, 0x22, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x76, 0x31, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x11, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67,
	0x65, 0x6e, 0x2d, 0x73, 0x77, 0x61, 0x67, 0x67, 0x65, 0x72, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65,
	0x64, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x64, 0x65, 0x74, 0x65, 0x72,
	0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x2f,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x64, 0x65,
	0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69,
	0x6e, 0x65, 0x64, 0x2f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x64, 0x65, 0x74, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65,
	0x64, 0x2f, 0x6a, 0x6f, 0x62, 0x2f, 0x76, 0x31, 0x2f, 0x6a, 0x6f, 0x62, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1d, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x75,
	0x74, 0x69, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x75, 0x74, 0x69, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x27, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x65, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x64, 0x65, 0x74, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x2f, 0x76, 0x31, 0x2f,
	0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xcb, 0x01, 0x0a, 0x09,
	0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x62, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x73, 0x12, 0x2f, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x06, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04,
	0x74, 0x69, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x65, 0x70, 0x6f, 0x63, 0x68, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x05, 0x65, 0x70, 0x6f, 0x63, 0x68, 0x88, 0x01, 0x01, 0x3a,
	0x1e, 0x92, 0x41, 0x1b, 0x0a, 0x19, 0xd2, 0x01, 0x07, 0x62, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73,
	0xd2, 0x01, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0xd2, 0x01, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x42,
	0x08, 0x0a, 0x06, 0x5f, 0x65, 0x70, 0x6f, 0x63, 0x68, 0x22, 0x3b, 0x0a, 0x14, 0x47, 0x65, 0x74,
	0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x22, 0xe2, 0x01, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x45, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x44, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65,
	0x64, 0x2e, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3e, 0x0a, 0x0b, 0x6a, 0x6f, 0x62, 0x5f, 0x73, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x65,
	0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x6a, 0x6f, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x4a, 0x6f, 0x62, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x0a, 0x6a, 0x6f, 0x62, 0x53,
	0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x2f, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52,
	0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3a, 0x12, 0x92, 0x41, 0x0f, 0x0a, 0x0d, 0xd2, 0x01,
	0x0a, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0xdf, 0x07, 0x0a, 0x15,
	0x47, 0x65, 0x74, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x07, 0x73, 0x6f, 0x72, 0x74, 0x5f, 0x62, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69,
	0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x53, 0x6f, 0x72, 0x74, 0x42, 0x79, 0x52, 0x06, 0x73, 0x6f, 0x72, 0x74, 0x42, 0x79, 0x12,
	0x35, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x1a, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x52, 0x07, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x14,
	0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x36, 0x0a, 0x08, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x64, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x08, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x64, 0x12, 0x37, 0x0a, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x64, 0x65, 0x74,
	0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x75, 0x73, 0x65, 0x72, 0x73, 0x18, 0x09, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x05, 0x75, 0x73, 0x65, 0x72, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x75, 0x73, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x05, 0x52, 0x07, 0x75, 0x73, 0x65,
	0x72, 0x49, 0x64, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x49, 0x64, 0x12, 0x58, 0x0a, 0x14, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x69, 0x64, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x12, 0x65, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x26, 0x0a,
	0x0f, 0x73, 0x68, 0x6f, 0x77, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x73, 0x68, 0x6f, 0x77, 0x54, 0x72, 0x69, 0x61,
	0x6c, 0x44, 0x61, 0x74, 0x61, 0x22, 0x85, 0x03, 0x0a, 0x06, 0x53, 0x6f, 0x72, 0x74, 0x42, 0x79,
	0x12, 0x17, 0x0a, 0x13, 0x53, 0x4f, 0x52, 0x54, 0x5f, 0x42, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x4f, 0x52,
	0x54, 0x5f, 0x42, 0x59, 0x5f, 0x49, 0x44, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x4f, 0x52,
	0x54, 0x5f, 0x42, 0x59, 0x5f, 0x44, 0x45, 0x53, 0x43, 0x52, 0x49, 0x50, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x4f, 0x52, 0x54, 0x5f, 0x42, 0x59, 0x5f, 0x53, 0x54,
	0x41, 0x52, 0x54, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x04, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x4f,
	0x52, 0x54, 0x5f, 0x42, 0x59, 0x5f, 0x45, 0x4e, 0x44, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x05,
	0x12, 0x11, 0x0a, 0x0d, 0x53, 0x4f, 0x52, 0x54, 0x5f, 0x42, 0x59, 0x5f, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x10, 0x06, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x4f, 0x52, 0x54, 0x5f, 0x42, 0x59, 0x5f, 0x4e,
	0x55, 0x4d, 0x5f, 0x54, 0x52, 0x49, 0x41, 0x4c, 0x53, 0x10, 0x08, 0x12, 0x14, 0x0a, 0x10, 0x53,
	0x4f, 0x52, 0x54, 0x5f, 0x42, 0x59, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10,
	0x09, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x4f, 0x52, 0x54, 0x5f, 0x42, 0x59, 0x5f, 0x55, 0x53, 0x45,
	0x52, 0x10, 0x0a, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x4f, 0x52, 0x54, 0x5f, 0x42, 0x59, 0x5f, 0x4e,
	0x41, 0x4d, 0x45, 0x10, 0x0b, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x4f, 0x52, 0x54, 0x5f, 0x42, 0x59,
	0x5f, 0x46, 0x4f, 0x52, 0x4b, 0x45, 0x44, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x10, 0x0c, 0x12, 0x19,
	0x0a, 0x15, 0x53, 0x4f, 0x52, 0x54, 0x5f, 0x42, 0x59, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52,
	0x43, 0x45, 0x5f, 0x50, 0x4f, 0x4f, 0x4c, 0x10, 0x0d, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x4f, 0x52,
	0x54, 0x5f, 0x42, 0x59, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x49, 0x44, 0x10,
	0x0e, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x4f, 0x52, 0x54, 0x5f, 0x42, 0x59, 0x5f, 0x43, 0x48, 0x45,
	0x43, 0x4b, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x10, 0x0f, 0x12, 0x1c,
	0x0a, 0x18, 0x53, 0x4f, 0x52, 0x54, 0x5f, 0x42, 0x59, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x50,
	0x4f, 0x49, 0x4e, 0x54, 0x5f, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x10, 0x10, 0x12, 0x1f, 0x0a, 0x1b,
	0x53, 0x4f, 0x52, 0x54, 0x5f, 0x42, 0x59, 0x5f, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x45, 0x52,
	0x5f, 0x4d, 0x45, 0x54, 0x52, 0x49, 0x43, 0x5f, 0x56, 0x41, 0x4c, 0x10, 0x11, 0x22, 0xc1, 0x01,
	0x0a, 0x16, 0x47, 0x65, 0x74, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x65, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x0b, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x12, 0x3d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65,
	0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a,
	0x20, 0x92, 0x41, 0x1d, 0x0a, 0x1b, 0xd2, 0x01, 0x0b, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0xd2, 0x01, 0x0a, 0x70, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x3b, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x22, 0x35,
	0x0a, 0x1b, 0x47, 0x65, 0x74, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x0a,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x22, 0x82, 0x01, 0x0a, 0x1e, 0x50, 0x75, 0x74, 0x45, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6e, 0x4c, 0x6f, 0x67,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0c, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a,
	0x08, 0x6e, 0x75, 0x6d, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x07, 0x6e, 0x75, 0x6d, 0x44, 0x61, 0x79, 0x73, 0x3a, 0x20, 0x92, 0x41, 0x1d, 0x0a, 0x1b, 0xd2,
	0x01, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0xd2,
	0x01, 0x08, 0x6e, 0x75, 0x6d, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x22, 0x21, 0x0a, 0x1f, 0x50, 0x75,
	0x74, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x74, 0x61, 0x69,
	0x6e, 0x4c, 0x6f, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xf6, 0x01,
	0x0a, 0x1f, 0x50, 0x75, 0x74, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x52, 0x65, 0x74, 0x61, 0x69, 0x6e, 0x4c, 0x6f, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x25, 0x0a, 0x0e, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x05, 0x52, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x6e, 0x75, 0x6d, 0x5f,
	0x64, 0x61, 0x79, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x6e, 0x75, 0x6d, 0x44,
	0x61, 0x79, 0x73, 0x12, 0x42, 0x0a, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65,
	0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x45, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x52, 0x07,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x3a, 0x2e, 0x92, 0x41, 0x2b, 0x0a, 0x29, 0xd2, 0x01, 0x0a,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x0e, 0x65, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0xd2, 0x01, 0x08, 0x6e, 0x75,
	0x6d, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x22, 0x78, 0x0a, 0x20, 0x50, 0x75, 0x74, 0x45, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6e, 0x4c, 0x6f,
	0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x43, 0x0a, 0x07, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x64, 0x65,
	0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x3a,
	0x0f, 0x92, 0x41, 0x0c, 0x0a, 0x0a, 0xd2, 0x01, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x22, 0x75, 0x0a, 0x19, 0x50, 0x75, 0x74, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a,
	0x0d, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x3a, 0x1d, 0x92, 0x41, 0x1a, 0x0a, 0x18, 0xd2,
	0x01, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0xd2,
	0x01, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x22, 0x44, 0x0a, 0x1a, 0x50, 0x75, 0x74, 0x45, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x3a, 0x0e, 0x92,
	0x41, 0x0b, 0x0a, 0x09, 0xd2, 0x01, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x22, 0x78, 0x0a,
	0x1c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a,
	0x0d, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x3a, 0x1d, 0x92, 0x41, 0x1a, 0x0a, 0x18, 0xd2,
	0x01, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0xd2,
	0x01, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x22, 0x47, 0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x3a, 0x0e, 0x92, 0x41, 0x0b, 0x0a, 0x09, 0xd2, 0x01, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x22, 0x3e, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x65,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x0c, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64,
	0x22, 0x1a, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xc9, 0x01, 0x0a,
	0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x65, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x05, 0x52, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x73,
	0x12, 0x42, 0x0a, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x52, 0x07, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x49, 0x64, 0x3a, 0x23, 0x92, 0x41, 0x20, 0x0a, 0x1e, 0xd2, 0x01, 0x0a, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x0e, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x22, 0x71, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x43, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69,
	0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x3a, 0x0f, 0x92, 0x41, 0x0c, 0x0a,
	0x0a, 0xd2, 0x01, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0x4d, 0x0a, 0x26, 0x47,
	0x65, 0x74, 0x42, 0x65, 0x73, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65, 0x72, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x65, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x22, 0x41, 0x0a, 0x27, 0x47, 0x65,
	0x74, 0x42, 0x65, 0x73, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65, 0x72, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x06, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x22, 0x5d, 0x0a,
	0x16, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x48, 0x50, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2f, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x65, 0x65, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x73, 0x65, 0x65, 0x64, 0x22, 0x5c, 0x0a, 0x17,
	0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x48, 0x50, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72,
	0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x52, 0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x22, 0x2b, 0x0a, 0x19, 0x41, 0x63,
	0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x02, 0x69, 0x64, 0x22, 0x1c, 0x0a, 0x1a, 0x41, 0x63, 0x74, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x52, 0x0a, 0x16, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12,
	0x14, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x02, 0x69, 0x64, 0x3a, 0x12, 0x92, 0x41, 0x0f, 0x0a, 0x0d, 0xd2, 0x01, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0xd2, 0x01, 0x02, 0x69, 0x64, 0x22, 0xcb, 0x01, 0x0a, 0x1a, 0x41, 0x63,
	0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x65, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x05,
	0x52, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x73, 0x12,
	0x42, 0x0a, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x52, 0x07, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x49, 0x64, 0x3a, 0x23, 0x92, 0x41, 0x20, 0x0a, 0x1e, 0xd2, 0x01, 0x0a, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x0e, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x22, 0x73, 0x0a, 0x1b, 0x41, 0x63, 0x74, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x43, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d,
	0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x3a, 0x0f, 0x92, 0x41, 0x0c,
	0x0a, 0x0a, 0xd2, 0x01, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0x28, 0x0a, 0x16,
	0x50, 0x61, 0x75, 0x73, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x02, 0x69, 0x64, 0x22, 0x19, 0x0a, 0x17, 0x50, 0x61, 0x75, 0x73, 0x65, 0x45,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0xc8, 0x02, 0x0a, 0x15, 0x42, 0x75, 0x6c, 0x6b, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x36, 0x0a, 0x08, 0x61, 0x72, 0x63,
	0x68, 0x69, 0x76, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f,
	0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65,
	0x64, 0x12, 0x37, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x0e, 0x32, 0x1f, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x65,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x65, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x05, 0x52, 0x07, 0x75, 0x73,
	0x65, 0x72, 0x49, 0x64, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x49, 0x64, 0x12, 0x36, 0x0a, 0x17, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64,
	0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18,
	0x08, 0x20, 0x03, 0x28, 0x05, 0x52, 0x15, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x45,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x73, 0x22, 0xc8, 0x01, 0x0a,
	0x17, 0x50, 0x61, 0x75, 0x73, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x65, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x05,
	0x52, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x73, 0x12,
	0x42, 0x0a, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x52, 0x07, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x49, 0x64, 0x3a, 0x23, 0x92, 0x41, 0x20, 0x0a, 0x1e, 0xd2, 0x01, 0x0a, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x0e, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x22, 0x70, 0x0a, 0x18, 0x50, 0x61, 0x75, 0x73, 0x65,
	0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x43, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65,
	0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52,
	0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x3a, 0x0f, 0x92, 0x41, 0x0c, 0x0a, 0x0a, 0xd2,
	0x01, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0x29, 0x0a, 0x17, 0x43, 0x61, 0x6e,
	0x63, 0x65, 0x6c, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x02, 0x69, 0x64, 0x22, 0x1a, 0x0a, 0x18, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x45, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0xc9, 0x01, 0x0a, 0x18, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x45, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x25, 0x0a,
	0x0e, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x05, 0x52, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x49, 0x64, 0x73, 0x12, 0x42, 0x0a, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e,
	0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x45, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x52,
	0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x3a, 0x23, 0x92, 0x41, 0x20, 0x0a, 0x1e, 0xd2, 0x01,
	0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x0e, 0x65, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x22, 0x71, 0x0a, 0x19,
	0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x43, 0x0a, 0x07, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x64, 0x65, 0x74,
	0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x3a, 0x0f,
	0x92, 0x41, 0x0c, 0x0a, 0x0a, 0xd2, 0x01, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22,
	0x27, 0x0a, 0x15, 0x4b, 0x69, 0x6c, 0x6c, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x02, 0x69, 0x64, 0x22, 0x18, 0x0a, 0x16, 0x4b, 0x69, 0x6c, 0x6c,
	0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0xc7, 0x01, 0x0a, 0x16, 0x4b, 0x69, 0x6c, 0x6c, 0x45, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x25, 0x0a,
	0x0e, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x05, 0x52, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x49, 0x64, 0x73, 0x12, 0x42, 0x0a, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e,
	0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x45, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x52,
	0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x3a, 0x23, 0x92, 0x41, 0x20, 0x0a, 0x1e, 0xd2, 0x01,
	0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x0e, 0x65, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x22, 0x6f, 0x0a, 0x17,
	0x4b, 0x69, 0x6c, 0x6c, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x43, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72,
	0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x3a, 0x0f, 0x92, 0x41,
	0x0c, 0x0a, 0x0a, 0xd2, 0x01, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0x2a, 0x0a,
	0x18, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x02, 0x69, 0x64, 0x22, 0x1b, 0x0a, 0x19, 0x41, 0x72, 0x63,
	0x68, 0x69, 0x76, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xca, 0x01, 0x0a, 0x19, 0x41, 0x72, 0x63, 0x68, 0x69,
	0x76, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x05, 0x52, 0x0d, 0x65, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x73, 0x12, 0x42, 0x0a, 0x07, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x64,
	0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x52, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x3a, 0x23,
	0x92, 0x41, 0x20, 0x0a, 0x1e, 0xd2, 0x01, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0xd2, 0x01, 0x0e, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x69, 0x64, 0x73, 0x22, 0x72, 0x0a, 0x1a, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x45, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x43, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x3a, 0x0f, 0x92, 0x41, 0x0c, 0x0a, 0x0a, 0xd2, 0x01, 0x07,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0x2c, 0x0a, 0x1a, 0x55, 0x6e, 0x61, 0x72, 0x63,
	0x68, 0x69, 0x76, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x02, 0x69, 0x64, 0x22, 0x1d, 0x0a, 0x1b, 0x55, 0x6e, 0x61, 0x72, 0x63, 0x68, 0x69,
	0x76, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0xcc, 0x01, 0x0a, 0x1b, 0x55, 0x6e, 0x61, 0x72, 0x63, 0x68, 0x69,
	0x76, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x05, 0x52, 0x0d, 0x65, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x73, 0x12, 0x42, 0x0a, 0x07, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x64,
	0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x52, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x3a, 0x23,
	0x92, 0x41, 0x20, 0x0a, 0x1e, 0xd2, 0x01, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0xd2, 0x01, 0x0e, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x69, 0x64, 0x73, 0x22, 0x74, 0x0a, 0x1c, 0x55, 0x6e, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65,
	0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x43, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65,
	0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52,
	0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x3a, 0x0f, 0x92, 0x41, 0x0c, 0x0a, 0x0a, 0xd2,
	0x01, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0x63, 0x0a, 0x16, 0x50, 0x61, 0x74,
	0x63, 0x68, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d,
	0x69, 0x6e, 0x65, 0x64, 0x2e, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x5f,
	0x0a, 0x17, 0x50, 0x61, 0x74, 0x63, 0x68, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x0a, 0x65, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x65, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x22,
	0xc8, 0x02, 0x0a, 0x1f, 0x47, 0x65, 0x74, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x02, 0x69, 0x64, 0x12, 0x44, 0x0a, 0x0c, 0x73, 0x6f, 0x72, 0x74, 0x5f, 0x62, 0x79, 0x5f, 0x61,
	0x74, 0x74, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x20, 0x2e, 0x64, 0x65, 0x74, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x72, 0x74, 0x42, 0x79, 0x48, 0x00, 0x52, 0x0a, 0x73,
	0x6f, 0x72, 0x74, 0x42, 0x79, 0x41, 0x74, 0x74, 0x72, 0x12, 0x26, 0x0a, 0x0e, 0x73, 0x6f, 0x72,
	0x74, 0x5f, 0x62, 0x79, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x6f, 0x72, 0x74, 0x42, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x12, 0x35, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x52,
	0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x12, 0x14, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x37, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x65, 0x73,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69,
	0x6e, 0x65, 0x64, 0x2e, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x65, 0x73, 0x42,
	0x09, 0x0a, 0x07, 0x73, 0x6f, 0x72, 0x74, 0x5f, 0x62, 0x79, 0x22, 0xcb, 0x01, 0x0a, 0x20, 0x47,
	0x65, 0x74, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x68, 0x65, 0x63,
	0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x46, 0x0a, 0x0b, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65,
	0x64, 0x2e, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x0b, 0x63, 0x68, 0x65, 0x63,
	0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x3d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x65,
	0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x61, 0x67, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x20, 0x92, 0x41, 0x1d, 0x0a, 0x1b, 0xd2, 0x01, 0x0b,
	0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0xd2, 0x01, 0x0a, 0x70, 0x61,
	0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x4c, 0x0a, 0x25, 0x47, 0x65, 0x74, 0x45,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x22, 0x89, 0x01, 0x0a, 0x26, 0x47, 0x65, 0x74, 0x45, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x5f, 0x0a, 0x12, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x65, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x11, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x69, 0x73, 0x74, 0x6f,
	0x72, 0x79, 0x22, 0xd2, 0x02, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43,
	0x0a, 0x10, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72,
	0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x75, 0x74, 0x69, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69,
	0x6c, 0x65, 0x52, 0x0f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x23, 0x0a, 0x0d, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x1a, 0x0a,
	0x08, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x08, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x08, 0x74, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x08, 0x74, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x21, 0x0a, 0x09, 0x75, 0x6e, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x18, 0x28, 0x20, 0x01, 0x28, 0x08, 0x48, 0x01, 0x52, 0x09,
	0x75, 0x6e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x88, 0x01, 0x01, 0x42, 0x0b, 0x0a, 0x09,
	0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x75, 0x6e,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x22, 0xec, 0x01, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72,
	0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0a,
	0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2f, 0x0a, 0x06, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3c, 0x0a, 0x08, 0x77,
	0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x20, 0x2e,
	0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x57, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x52,
	0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x1b, 0x92, 0x41, 0x18, 0x0a, 0x16,
	0xd2, 0x01, 0x0a, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0xd2, 0x01, 0x06,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xb4, 0x01, 0x0a, 0x14, 0x50, 0x75, 0x74, 0x45, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x66, 0x0a, 0x19, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x17,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x34, 0x0a, 0x16, 0x65, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x29, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x22, 0xab, 0x01,
	0x0a, 0x15, 0x50, 0x75, 0x74, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x64, 0x65,
	0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2f, 0x0a,
	0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3a, 0x1b,
	0x92, 0x41, 0x18, 0x0a, 0x16, 0xd2, 0x01, 0x0a, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0xd2, 0x01, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x60, 0x0a, 0x19, 0x43,
	0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x02, 0x69, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x76, 0x65, 0x72,
	0x72, 0x69, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x3a, 0x0a, 0x92, 0x41, 0x07, 0x0a, 0x05, 0xd2, 0x01, 0x02, 0x69, 0x64, 0x22, 0xbd, 0x01,
	0x0a, 0x1a, 0x43, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x0a,
	0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x65, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x3c, 0x0a, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0e, 0x32, 0x20, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65,
	0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x57,
	0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73,
	0x3a, 0x1b, 0x92, 0x41, 0x18, 0x0a, 0x16, 0xd2, 0x01, 0x0a, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0xd2, 0x01, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x5b, 0x0a,
	0x15, 0x45, 0x78, 0x70, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x03, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x05, 0x42, 0x09, 0x92, 0x41, 0x06, 0xd2, 0x01, 0x03, 0x69, 0x64, 0x73, 0x52, 0x03,
	0x69, 0x64, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x5f, 0x73, 0x65,
	0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x70, 0x65, 0x72,
	0x69, 0x6f, 0x64, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x22, 0xf0, 0x01, 0x0a, 0x16, 0x45,
	0x78, 0x70, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65,
	0x72, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x12, 0x2d, 0x0a, 0x10, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0f,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12,
	0x31, 0x0a, 0x12, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52,
	0x11, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x12, 0x49, 0x0a, 0x0c, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72,
	0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x52, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0x85, 0x02,
	0x0a, 0x14, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x42, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x13, 0x92,
	0x41, 0x10, 0xd2, 0x01, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x69, 0x64, 0x52, 0x0c, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64,
	0x12, 0x32, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x11, 0x92, 0x41, 0x0e, 0xd2, 0x01, 0x0b, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x64, 0x65, 0x74, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0a, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x25,
	0x0a, 0x0e, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x53, 0x65,
	0x63, 0x6f, 0x6e, 0x64, 0x73, 0x22, 0x31, 0x0a, 0x15, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18,
	0x0a, 0x07, 0x62, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x05, 0x52,
	0x07, 0x62, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x22, 0xf3, 0x02, 0x0a, 0x15, 0x54, 0x72, 0x69,
	0x61, 0x6c, 0x73, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x38, 0x0a, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x13, 0x92, 0x41, 0x10, 0xd2, 0x01,
	0x0d, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x52, 0x0c,
	0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x32, 0x0a, 0x0b,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x11, 0x92, 0x41, 0x0e, 0xd2, 0x01, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x42, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e,
	0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x54, 0x79, 0x70, 0x65, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x44, 0x0a, 0x11, 0x62, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x17, 0x92, 0x41, 0x14, 0xd2, 0x01, 0x11, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x52, 0x10,
	0x62, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64,
	0x12, 0x25, 0x0a, 0x0e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x5f, 0x6d, 0x61, 0x72, 0x67,
	0x69, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x62, 0x61, 0x74, 0x63, 0x68, 0x65,
	0x73, 0x4d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x65, 0x72, 0x69, 0x6f,
	0x64, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0d, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x22, 0xc7,
	0x02, 0x0a, 0x16, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x06, 0x74, 0x72, 0x69,
	0x61, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x64, 0x65, 0x74, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72,
	0x69, 0x61, 0x6c, 0x73, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x06, 0x74, 0x72, 0x69, 0x61,
	0x6c, 0x73, 0x1a, 0xd3, 0x01, 0x0a, 0x05, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x12, 0x19, 0x0a, 0x08,
	0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07,
	0x74, 0x72, 0x69, 0x61, 0x6c, 0x49, 0x64, 0x12, 0x31, 0x0a, 0x07, 0x68, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x52, 0x07, 0x68, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x06, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x12, 0x2b, 0x0a, 0x11, 0x62, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x5f, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x3a,
	0x37, 0x92, 0x41, 0x34, 0x0a, 0x32, 0xd2, 0x01, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69,
	0x64, 0xd2, 0x01, 0x07, 0x68, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0xd2, 0x01, 0x06, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0xd2, 0x01, 0x11, 0x62, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x5f, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x3a, 0x0e, 0x92, 0x41, 0x0b, 0x0a, 0x09, 0xd2,
	0x01, 0x06, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x22, 0x90, 0x03, 0x0a, 0x13, 0x54, 0x72, 0x69,
	0x61, 0x6c, 0x73, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x38, 0x0a, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x13, 0x92, 0x41, 0x10, 0xd2, 0x01, 0x0d, 0x65,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x52, 0x0c, 0x65, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x32, 0x0a, 0x0b, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x11, 0x92, 0x41, 0x0e, 0xd2, 0x01, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x42,
	0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x61, 0x78, 0x5f,
	0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x6d, 0x61,
	0x78, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x6d, 0x61, 0x78, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0d, 0x6d, 0x61, 0x78, 0x44, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x23,
	0x0a, 0x0d, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x72, 0x74, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x6e, 0x64, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x65, 0x6e, 0x64, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x5f, 0x73,
	0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x70, 0x65,
	0x72, 0x69, 0x6f, 0x64, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x22, 0x8d, 0x03, 0x0a, 0x14,
	0x54, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x06, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65,
	0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x53,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x54, 0x72,
	0x69, 0x61, 0x6c, 0x52, 0x06, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x70,
	0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x05, 0x52, 0x0e, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x64, 0x54, 0x72,
	0x69, 0x61, 0x6c, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x64, 0x5f,
	0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x05, 0x52, 0x0d, 0x64, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x64, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x1a, 0xaa, 0x01, 0x0a, 0x05,
	0x54, 0x72, 0x69, 0x61, 0x6c, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x49, 0x64,
	0x12, 0x31, 0x0a, 0x07, 0x68, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x07, 0x68, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x12, 0x30, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52,
	0x04, 0x64, 0x61, 0x74, 0x61, 0x3a, 0x21, 0x92, 0x41, 0x1e, 0x0a, 0x1c, 0xd2, 0x01, 0x08, 0x74,
	0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x07, 0x68, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0xd2, 0x01, 0x04, 0x64, 0x61, 0x74, 0x61, 0x3a, 0x31, 0x92, 0x41, 0x2e, 0x0a, 0x2c, 0xd2,
	0x01, 0x06, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0xd2, 0x01, 0x0f, 0x70, 0x72, 0x6f, 0x6d, 0x6f,
	0x74, 0x65, 0x64, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0xd2, 0x01, 0x0e, 0x64, 0x65, 0x6d,
	0x6f, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x22, 0x39, 0x0a, 0x12, 0x47,
	0x65, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x65, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x22, 0x3f, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x44, 0x65, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x17, 0x0a,
	0x07, 0x62, 0x36, 0x34, 0x5f, 0x74, 0x67, 0x7a, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x62, 0x36, 0x34, 0x54, 0x67, 0x7a, 0x3a, 0x0f, 0x92, 0x41, 0x0c, 0x0a, 0x0a, 0xd2, 0x01, 0x07,
	0x62, 0x36, 0x34, 0x5f, 0x74, 0x67, 0x7a, 0x22, 0xa2, 0x01, 0x0a, 0x15, 0x4d, 0x6f, 0x76, 0x65,
	0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x34, 0x0a, 0x16, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x14, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x3a, 0x2e, 0x92, 0x41,
	0x2b, 0x0a, 0x29, 0xd2, 0x01, 0x16, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x0d, 0x65,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x22, 0x18, 0x0a, 0x16,
	0x4d, 0x6f, 0x76, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x96, 0x02, 0x0a, 0x16, 0x4d, 0x6f, 0x76, 0x65, 0x45,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x25, 0x0a, 0x0e, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x05, 0x52, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x64, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x14, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x42,
	0x0a, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x52, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49,
	0x64, 0x3a, 0x3c, 0x92, 0x41, 0x39, 0x0a, 0x37, 0xd2, 0x01, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x69, 0x64, 0xd2, 0x01, 0x16, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0xd2, 0x01,
	0x0e, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x22,
	0x6f, 0x0a, 0x17, 0x4d, 0x6f, 0x76, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x43, 0x0a, 0x07, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x64, 0x65,
	0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x3a,
	0x0f, 0x92, 0x41, 0x0c, 0x0a, 0x0a, 0xd2, 0x01, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x22, 0x3d, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x65, 0x66, 0x54,
	0x72, 0x65, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0c, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x22,
	0x53, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x65, 0x66, 0x54, 0x72,
	0x65, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x38, 0x0a, 0x05, 0x66, 0x69,
	0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x64, 0x65, 0x74, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x05, 0x66,
	0x69, 0x6c, 0x65, 0x73, 0x22, 0x51, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x44, 0x65, 0x66, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23,
	0x0a, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x22, 0x2d, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x44, 0x65, 0x66, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x22, 0xc5, 0x01, 0x0a, 0x18, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12,
	0x14, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x73, 0x6f, 0x72, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x04, 0x73, 0x6f, 0x72, 0x74, 0x88, 0x01, 0x01, 0x12, 0x1b,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x02,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x73,
	0x6f, 0x72, 0x74, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xb1,
	0x01, 0x0a, 0x1a, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x44, 0x0a,
	0x0a, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2e, 0x65,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x12, 0x39, 0x0a, 0x0a, 0x62, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x72, 0x69, 0x61,
	0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d,
	0x69, 0x6e, 0x65, 0x64, 0x2e, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72,
	0x69, 0x61, 0x6c, 0x52, 0x09, 0x62, 0x65, 0x73, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x3a, 0x12,
	0x92, 0x41, 0x0f, 0x0a, 0x0d, 0xd2, 0x01, 0x0a, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x22, 0xcd, 0x01, 0x0a, 0x19, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x4f, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e,
	0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0x3d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e,
	0x65, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x67, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x3a, 0x20, 0x92, 0x41, 0x1d, 0x0a, 0x1b, 0xd2, 0x01, 0x0b, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0xd2, 0x01, 0x0a, 0x70, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x5b, 0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73,
	0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x65, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x3a, 0x15, 0x92, 0x41, 0x12, 0x0a, 0x10, 0xd2,
	0x01, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x22,
	0x20, 0x0a, 0x1e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x2a, 0x7a, 0x0a, 0x0a, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1b, 0x0a, 0x17, 0x4d, 0x45, 0x54, 0x52, 0x49, 0x43, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14,
	0x4d, 0x45, 0x54, 0x52, 0x49, 0x43, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x54, 0x52, 0x41, 0x49,
	0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x4d, 0x45, 0x54, 0x52, 0x49, 0x43,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x02, 0x12, 0x19, 0x0a, 0x15, 0x4d, 0x45, 0x54, 0x52, 0x49, 0x43, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x50, 0x52, 0x4f, 0x46, 0x49, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x42, 0x35, 0x5a,
	0x33, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x64, 0x65, 0x74, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x2d, 0x61, 0x69, 0x2f, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d,
	0x69, 0x6e, 0x65, 0x64, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_determined_api_v1_experiment_proto_rawDescOnce sync.Once
	file_determined_api_v1_experiment_proto_rawDescData = file_determined_api_v1_experiment_proto_rawDesc
)

func file_determined_api_v1_experiment_proto_rawDescGZIP() []byte {
	file_determined_api_v1_experiment_proto_rawDescOnce.Do(func() {
		file_determined_api_v1_experiment_proto_rawDescData = protoimpl.X.CompressGZIP(file_determined_api_v1_experiment_proto_rawDescData)
	})
	return file_determined_api_v1_experiment_proto_rawDescData
}

var file_determined_api_v1_experiment_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_determined_api_v1_experiment_proto_msgTypes = make([]protoimpl.MessageInfo, 86)
var file_determined_api_v1_experiment_proto_goTypes = []interface{}{
	(MetricType)(0),                                 // 0: determined.api.v1.MetricType
	(GetExperimentsRequest_SortBy)(0),               // 1: determined.api.v1.GetExperimentsRequest.SortBy
	(*DataPoint)(nil),                               // 2: determined.api.v1.DataPoint
	(*GetExperimentRequest)(nil),                    // 3: determined.api.v1.GetExperimentRequest
	(*GetExperimentResponse)(nil),                   // 4: determined.api.v1.GetExperimentResponse
	(*GetExperimentsRequest)(nil),                   // 5: determined.api.v1.GetExperimentsRequest
	(*GetExperimentsResponse)(nil),                  // 6: determined.api.v1.GetExperimentsResponse
	(*GetExperimentLabelsRequest)(nil),              // 7: determined.api.v1.GetExperimentLabelsRequest
	(*GetExperimentLabelsResponse)(nil),             // 8: determined.api.v1.GetExperimentLabelsResponse
	(*PutExperimentRetainLogsRequest)(nil),          // 9: determined.api.v1.PutExperimentRetainLogsRequest
	(*PutExperimentRetainLogsResponse)(nil),         // 10: determined.api.v1.PutExperimentRetainLogsResponse
	(*PutExperimentsRetainLogsRequest)(nil),         // 11: determined.api.v1.PutExperimentsRetainLogsRequest
	(*PutExperimentsRetainLogsResponse)(nil),        // 12: determined.api.v1.PutExperimentsRetainLogsResponse
	(*PutExperimentLabelRequest)(nil),               // 13: determined.api.v1.PutExperimentLabelRequest
	(*PutExperimentLabelResponse)(nil),              // 14: determined.api.v1.PutExperimentLabelResponse
	(*DeleteExperimentLabelRequest)(nil),            // 15: determined.api.v1.DeleteExperimentLabelRequest
	(*DeleteExperimentLabelResponse)(nil),           // 16: determined.api.v1.DeleteExperimentLabelResponse
	(*DeleteExperimentRequest)(nil),                 // 17: determined.api.v1.DeleteExperimentRequest
	(*DeleteExperimentResponse)(nil),                // 18: determined.api.v1.DeleteExperimentResponse
	(*DeleteExperimentsRequest)(nil),                // 19: determined.api.v1.DeleteExperimentsRequest
	(*DeleteExperimentsResponse)(nil),               // 20: determined.api.v1.DeleteExperimentsResponse
	(*GetBestSearcherValidationMetricRequest)(nil),  // 21: determined.api.v1.GetBestSearcherValidationMetricRequest
	(*GetBestSearcherValidationMetricResponse)(nil), // 22: determined.api.v1.GetBestSearcherValidationMetricResponse
	(*PreviewHPSearchRequest)(nil),                  // 23: determined.api.v1.PreviewHPSearchRequest
	(*PreviewHPSearchResponse)(nil),                 // 24: determined.api.v1.PreviewHPSearchResponse
	(*ActivateExperimentRequest)(nil),               // 25: determined.api.v1.ActivateExperimentRequest
	(*ActivateExperimentResponse)(nil),              // 26: determined.api.v1.ActivateExperimentResponse
	(*ExperimentActionResult)(nil),                  // 27: determined.api.v1.ExperimentActionResult
	(*ActivateExperimentsRequest)(nil),              // 28: determined.api.v1.ActivateExperimentsRequest
	(*ActivateExperimentsResponse)(nil),             // 29: determined.api.v1.ActivateExperimentsResponse
	(*PauseExperimentRequest)(nil),                  // 30: determined.api.v1.PauseExperimentRequest
	(*PauseExperimentResponse)(nil),                 // 31: determined.api.v1.PauseExperimentResponse
	(*BulkExperimentFilters)(nil),                   // 32: determined.api.v1.BulkExperimentFilters
	(*PauseExperimentsRequest)(nil),                 // 33: determined.api.v1.PauseExperimentsRequest
	(*PauseExperimentsResponse)(nil),                // 34: determined.api.v1.PauseExperimentsResponse
	(*CancelExperimentRequest)(nil),                 // 35: determined.api.v1.CancelExperimentRequest
	(*CancelExperimentResponse)(nil),                // 36: determined.api.v1.CancelExperimentResponse
	(*CancelExperimentsRequest)(nil),                // 37: determined.api.v1.CancelExperimentsRequest
	(*CancelExperimentsResponse)(nil),               // 38: determined.api.v1.CancelExperimentsResponse
	(*KillExperimentRequest)(nil),                   // 39: determined.api.v1.KillExperimentRequest
	(*KillExperimentResponse)(nil),                  // 40: determined.api.v1.KillExperimentResponse
	(*KillExperimentsRequest)(nil),                  // 41: determined.api.v1.KillExperimentsRequest
	(*KillExperimentsResponse)(nil),                 // 42: determined.api.v1.KillExperimentsResponse
	(*ArchiveExperimentRequest)(nil),                // 43: determined.api.v1.ArchiveExperimentRequest
	(*ArchiveExperimentResponse)(nil),               // 44: determined.api.v1.ArchiveExperimentResponse
	(*ArchiveExperimentsRequest)(nil),               // 45: determined.api.v1.ArchiveExperimentsRequest
	(*ArchiveExperimentsResponse)(nil),              // 46: determined.api.v1.ArchiveExperimentsResponse
	(*UnarchiveExperimentRequest)(nil),              // 47: determined.api.v1.UnarchiveExperimentRequest
	(*UnarchiveExperimentResponse)(nil),             // 48: determined.api.v1.UnarchiveExperimentResponse
	(*UnarchiveExperimentsRequest)(nil),             // 49: determined.api.v1.UnarchiveExperimentsRequest
	(*UnarchiveExperimentsResponse)(nil),            // 50: determined.api.v1.UnarchiveExperimentsResponse
	(*PatchExperimentRequest)(nil),                  // 51: determined.api.v1.PatchExperimentRequest
	(*PatchExperimentResponse)(nil),                 // 52: determined.api.v1.PatchExperimentResponse
	(*GetExperimentCheckpointsRequest)(nil),         // 53: determined.api.v1.GetExperimentCheckpointsRequest
	(*GetExperimentCheckpointsResponse)(nil),        // 54: determined.api.v1.GetExperimentCheckpointsResponse
	(*GetExperimentValidationHistoryRequest)(nil),   // 55: determined.api.v1.GetExperimentValidationHistoryRequest
	(*GetExperimentValidationHistoryResponse)(nil),  // 56: determined.api.v1.GetExperimentValidationHistoryResponse
	(*CreateExperimentRequest)(nil),                 // 57: determined.api.v1.CreateExperimentRequest
	(*CreateExperimentResponse)(nil),                // 58: determined.api.v1.CreateExperimentResponse
	(*PutExperimentRequest)(nil),                    // 59: determined.api.v1.PutExperimentRequest
	(*PutExperimentResponse)(nil),                   // 60: determined.api.v1.PutExperimentResponse
	(*ContinueExperimentRequest)(nil),               // 61: determined.api.v1.ContinueExperimentRequest
	(*ContinueExperimentResponse)(nil),              // 62: determined.api.v1.ContinueExperimentResponse
	(*ExpMetricNamesRequest)(nil),                   // 63: determined.api.v1.ExpMetricNamesRequest
	(*ExpMetricNamesResponse)(nil),                  // 64: determined.api.v1.ExpMetricNamesResponse
	(*MetricBatchesRequest)(nil),                    // 65: determined.api.v1.MetricBatchesRequest
	(*MetricBatchesResponse)(nil),                   // 66: determined.api.v1.MetricBatchesResponse
	(*TrialsSnapshotRequest)(nil),                   // 67: determined.api.v1.TrialsSnapshotRequest
	(*TrialsSnapshotResponse)(nil),                  // 68: determined.api.v1.TrialsSnapshotResponse
	(*TrialsSampleRequest)(nil),                     // 69: determined.api.v1.TrialsSampleRequest
	(*TrialsSampleResponse)(nil),                    // 70: determined.api.v1.TrialsSampleResponse
	(*GetModelDefRequest)(nil),                      // 71: determined.api.v1.GetModelDefRequest
	(*GetModelDefResponse)(nil),                     // 72: determined.api.v1.GetModelDefResponse
	(*MoveExperimentRequest)(nil),                   // 73: determined.api.v1.MoveExperimentRequest
	(*MoveExperimentResponse)(nil),                  // 74: determined.api.v1.MoveExperimentResponse
	(*MoveExperimentsRequest)(nil),                  // 75: determined.api.v1.MoveExperimentsRequest
	(*MoveExperimentsResponse)(nil),                 // 76: determined.api.v1.MoveExperimentsResponse
	(*GetModelDefTreeRequest)(nil),                  // 77: determined.api.v1.GetModelDefTreeRequest
	(*GetModelDefTreeResponse)(nil),                 // 78: determined.api.v1.GetModelDefTreeResponse
	(*GetModelDefFileRequest)(nil),                  // 79: determined.api.v1.GetModelDefFileRequest
	(*GetModelDefFileResponse)(nil),                 // 80: determined.api.v1.GetModelDefFileResponse
	(*SearchExperimentsRequest)(nil),                // 81: determined.api.v1.SearchExperimentsRequest
	(*SearchExperimentExperiment)(nil),              // 82: determined.api.v1.SearchExperimentExperiment
	(*SearchExperimentsResponse)(nil),               // 83: determined.api.v1.SearchExperimentsResponse
	(*DeleteTensorboardFilesRequest)(nil),           // 84: determined.api.v1.DeleteTensorboardFilesRequest
	(*DeleteTensorboardFilesResponse)(nil),          // 85: determined.api.v1.DeleteTensorboardFilesResponse
	(*TrialsSnapshotResponse_Trial)(nil),            // 86: determined.api.v1.TrialsSnapshotResponse.Trial
	(*TrialsSampleResponse_Trial)(nil),              // 87: determined.api.v1.TrialsSampleResponse.Trial
	(*_struct.Struct)(nil),                          // 88: google.protobuf.Struct
	(*timestamp.Timestamp)(nil),                     // 89: google.protobuf.Timestamp
	(*experimentv1.Experiment)(nil),                 // 90: determined.experiment.v1.Experiment
	(*jobv1.JobSummary)(nil),                        // 91: determined.job.v1.JobSummary
	(OrderBy)(0),                                    // 92: determined.api.v1.OrderBy
	(*wrappers.BoolValue)(nil),                      // 93: google.protobuf.BoolValue
	(experimentv1.State)(0),                         // 94: determined.experiment.v1.State
	(*commonv1.Int32FieldFilter)(nil),               // 95: determined.common.v1.Int32FieldFilter
	(*Pagination)(nil),                              // 96: determined.api.v1.Pagination
	(*experimentv1.SearchSummary)(nil),              // 97: determined.experiment.v1.SearchSummary
	(*experimentv1.PatchExperiment)(nil),            // 98: determined.experiment.v1.PatchExperiment
	(checkpointv1.SortBy)(0),                        // 99: determined.checkpoint.v1.SortBy
	(checkpointv1.State)(0),                         // 100: determined.checkpoint.v1.State
	(*checkpointv1.Checkpoint)(nil),                 // 101: determined.checkpoint.v1.Checkpoint
	(*experimentv1.ValidationHistoryEntry)(nil),     // 102: determined.experiment.v1.ValidationHistoryEntry
	(*utilv1.File)(nil),                             // 103: determined.util.v1.File
	(LaunchWarning)(0),                              // 104: determined.api.v1.LaunchWarning
	(*metricv1.MetricIdentifier)(nil),               // 105: determined.metric.v1.MetricIdentifier
	(*experimentv1.FileNode)(nil),                   // 106: determined.experiment.v1.FileNode
	(*trialv1.Trial)(nil),                           // 107: determined.trial.v1.Trial
}
var file_determined_api_v1_experiment_proto_depIdxs = []int32{
	88,  // 0: determined.api.v1.DataPoint.values:type_name -> google.protobuf.Struct
	89,  // 1: determined.api.v1.DataPoint.time:type_name -> google.protobuf.Timestamp
	90,  // 2: determined.api.v1.GetExperimentResponse.experiment:type_name -> determined.experiment.v1.Experiment
	91,  // 3: determined.api.v1.GetExperimentResponse.job_summary:type_name -> determined.job.v1.JobSummary
	88,  // 4: determined.api.v1.GetExperimentResponse.config:type_name -> google.protobuf.Struct
	1,   // 5: determined.api.v1.GetExperimentsRequest.sort_by:type_name -> determined.api.v1.GetExperimentsRequest.SortBy
	92,  // 6: determined.api.v1.GetExperimentsRequest.order_by:type_name -> determined.api.v1.OrderBy
	93,  // 7: determined.api.v1.GetExperimentsRequest.archived:type_name -> google.protobuf.BoolValue
	94,  // 8: determined.api.v1.GetExperimentsRequest.states:type_name -> determined.experiment.v1.State
	95,  // 9: determined.api.v1.GetExperimentsRequest.experiment_id_filter:type_name -> determined.common.v1.Int32FieldFilter
	90,  // 10: determined.api.v1.GetExperimentsResponse.experiments:type_name -> determined.experiment.v1.Experiment
	96,  // 11: determined.api.v1.GetExperimentsResponse.pagination:type_name -> determined.api.v1.Pagination
	32,  // 12: determined.api.v1.PutExperimentsRetainLogsRequest.filters:type_name -> determined.api.v1.BulkExperimentFilters
	27,  // 13: determined.api.v1.PutExperimentsRetainLogsResponse.results:type_name -> determined.api.v1.ExperimentActionResult
	32,  // 14: determined.api.v1.DeleteExperimentsRequest.filters:type_name -> determined.api.v1.BulkExperimentFilters
	27,  // 15: determined.api.v1.DeleteExperimentsResponse.results:type_name -> determined.api.v1.ExperimentActionResult
	88,  // 16: determined.api.v1.PreviewHPSearchRequest.config:type_name -> google.protobuf.Struct
	97,  // 17: determined.api.v1.PreviewHPSearchResponse.summary:type_name -> determined.experiment.v1.SearchSummary
	32,  // 18: determined.api.v1.ActivateExperimentsRequest.filters:type_name -> determined.api.v1.BulkExperimentFilters
	27,  // 19: determined.api.v1.ActivateExperimentsResponse.results:type_name -> determined.api.v1.ExperimentActionResult
	93,  // 20: determined.api.v1.BulkExperimentFilters.archived:type_name -> google.protobuf.BoolValue
	94,  // 21: determined.api.v1.BulkExperimentFilters.states:type_name -> determined.experiment.v1.State
	32,  // 22: determined.api.v1.PauseExperimentsRequest.filters:type_name -> determined.api.v1.BulkExperimentFilters
	27,  // 23: determined.api.v1.PauseExperimentsResponse.results:type_name -> determined.api.v1.ExperimentActionResult
	32,  // 24: determined.api.v1.CancelExperimentsRequest.filters:type_name -> determined.api.v1.BulkExperimentFilters
	27,  // 25: determined.api.v1.CancelExperimentsResponse.results:type_name -> determined.api.v1.ExperimentActionResult
	32,  // 26: determined.api.v1.KillExperimentsRequest.filters:type_name -> determined.api.v1.BulkExperimentFilters
	27,  // 27: determined.api.v1.KillExperimentsResponse.results:type_name -> determined.api.v1.ExperimentActionResult
	32,  // 28: determined.api.v1.ArchiveExperimentsRequest.filters:type_name -> determined.api.v1.BulkExperimentFilters
	27,  // 29: determined.api.v1.ArchiveExperimentsResponse.results:type_name -> determined.api.v1.ExperimentActionResult
	32,  // 30: determined.api.v1.UnarchiveExperimentsRequest.filters:type_name -> determined.api.v1.BulkExperimentFilters
	27,  // 31: determined.api.v1.UnarchiveExperimentsResponse.results:type_name -> determined.api.v1.ExperimentActionResult
	98,  // 32: determined.api.v1.PatchExperimentRequest.experiment:type_name -> determined.experiment.v1.PatchExperiment
	90,  // 33: determined.api.v1.PatchExperimentResponse.experiment:type_name -> determined.experiment.v1.Experiment
	99,  // 34: determined.api.v1.GetExperimentCheckpointsRequest.sort_by_attr:type_name -> determined.checkpoint.v1.SortBy
	92,  // 35: determined.api.v1.GetExperimentCheckpointsRequest.order_by:type_name -> determined.api.v1.OrderBy
	100, // 36: determined.api.v1.GetExperimentCheckpointsRequest.states:type_name -> determined.checkpoint.v1.State
	101, // 37: determined.api.v1.GetExperimentCheckpointsResponse.checkpoints:type_name -> determined.checkpoint.v1.Checkpoint
	96,  // 38: determined.api.v1.GetExperimentCheckpointsResponse.pagination:type_name -> determined.api.v1.Pagination
	102, // 39: determined.api.v1.GetExperimentValidationHistoryResponse.validation_history:type_name -> determined.experiment.v1.ValidationHistoryEntry
	103, // 40: determined.api.v1.CreateExperimentRequest.model_definition:type_name -> determined.util.v1.File
	90,  // 41: determined.api.v1.CreateExperimentResponse.experiment:type_name -> determined.experiment.v1.Experiment
	88,  // 42: determined.api.v1.CreateExperimentResponse.config:type_name -> google.protobuf.Struct
	104, // 43: determined.api.v1.CreateExperimentResponse.warnings:type_name -> determined.api.v1.LaunchWarning
	57,  // 44: determined.api.v1.PutExperimentRequest.create_experiment_request:type_name -> determined.api.v1.CreateExperimentRequest
	90,  // 45: determined.api.v1.PutExperimentResponse.experiment:type_name -> determined.experiment.v1.Experiment
	88,  // 46: determined.api.v1.PutExperimentResponse.config:type_name -> google.protobuf.Struct
	90,  // 47: determined.api.v1.ContinueExperimentResponse.experiment:type_name -> determined.experiment.v1.Experiment
	104, // 48: determined.api.v1.ContinueExperimentResponse.warnings:type_name -> determined.api.v1.LaunchWarning
	105, // 49: determined.api.v1.ExpMetricNamesResponse.metric_names:type_name -> determined.metric.v1.MetricIdentifier
	0,   // 50: determined.api.v1.MetricBatchesRequest.metric_type:type_name -> determined.api.v1.MetricType
	0,   // 51: determined.api.v1.TrialsSnapshotRequest.metric_type:type_name -> determined.api.v1.MetricType
	86,  // 52: determined.api.v1.TrialsSnapshotResponse.trials:type_name -> determined.api.v1.TrialsSnapshotResponse.Trial
	0,   // 53: determined.api.v1.TrialsSampleRequest.metric_type:type_name -> determined.api.v1.MetricType
	87,  // 54: determined.api.v1.TrialsSampleResponse.trials:type_name -> determined.api.v1.TrialsSampleResponse.Trial
	32,  // 55: determined.api.v1.MoveExperimentsRequest.filters:type_name -> determined.api.v1.BulkExperimentFilters
	27,  // 56: determined.api.v1.MoveExperimentsResponse.results:type_name -> determined.api.v1.ExperimentActionResult
	106, // 57: determined.api.v1.GetModelDefTreeResponse.files:type_name -> determined.experiment.v1.FileNode
	90,  // 58: determined.api.v1.SearchExperimentExperiment.experiment:type_name -> determined.experiment.v1.Experiment
	107, // 59: determined.api.v1.SearchExperimentExperiment.best_trial:type_name -> determined.trial.v1.Trial
	82,  // 60: determined.api.v1.SearchExperimentsResponse.experiments:type_name -> determined.api.v1.SearchExperimentExperiment
	96,  // 61: determined.api.v1.SearchExperimentsResponse.pagination:type_name -> determined.api.v1.Pagination
	88,  // 62: determined.api.v1.TrialsSnapshotResponse.Trial.hparams:type_name -> google.protobuf.Struct
	88,  // 63: determined.api.v1.TrialsSampleResponse.Trial.hparams:type_name -> google.protobuf.Struct
	2,   // 64: determined.api.v1.TrialsSampleResponse.Trial.data:type_name -> determined.api.v1.DataPoint
	65,  // [65:65] is the sub-list for method output_type
	65,  // [65:65] is the sub-list for method input_type
	65,  // [65:65] is the sub-list for extension type_name
	65,  // [65:65] is the sub-list for extension extendee
	0,   // [0:65] is the sub-list for field type_name
}

func init() { file_determined_api_v1_experiment_proto_init() }
func file_determined_api_v1_experiment_proto_init() {
	if File_determined_api_v1_experiment_proto != nil {
		return
	}
	file_determined_api_v1_command_proto_init()
	file_determined_api_v1_pagination_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_determined_api_v1_experiment_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataPoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetExperimentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetExperimentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetExperimentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetExperimentLabelsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetExperimentLabelsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PutExperimentRetainLogsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PutExperimentRetainLogsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PutExperimentsRetainLogsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PutExperimentsRetainLogsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PutExperimentLabelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PutExperimentLabelResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteExperimentLabelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteExperimentLabelResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteExperimentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteExperimentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteExperimentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBestSearcherValidationMetricRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBestSearcherValidationMetricResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PreviewHPSearchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PreviewHPSearchResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActivateExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActivateExperimentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExperimentActionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActivateExperimentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActivateExperimentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PauseExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PauseExperimentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BulkExperimentFilters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PauseExperimentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PauseExperimentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelExperimentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelExperimentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelExperimentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KillExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KillExperimentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KillExperimentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KillExperimentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArchiveExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArchiveExperimentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArchiveExperimentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArchiveExperimentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UnarchiveExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UnarchiveExperimentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UnarchiveExperimentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UnarchiveExperimentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchExperimentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetExperimentCheckpointsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetExperimentCheckpointsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetExperimentValidationHistoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetExperimentValidationHistoryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateExperimentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PutExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PutExperimentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContinueExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContinueExperimentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExpMetricNamesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExpMetricNamesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetricBatchesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetricBatchesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrialsSnapshotRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrialsSnapshotResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrialsSampleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrialsSampleResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetModelDefRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetModelDefResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[71].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MoveExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[72].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MoveExperimentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[73].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MoveExperimentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[74].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MoveExperimentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[75].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetModelDefTreeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[76].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetModelDefTreeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[77].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetModelDefFileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[78].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetModelDefFileResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[79].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchExperimentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[80].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchExperimentExperiment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[81].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchExperimentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[82].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTensorboardFilesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[83].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTensorboardFilesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[84].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrialsSnapshotResponse_Trial); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_determined_api_v1_experiment_proto_msgTypes[85].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrialsSampleResponse_Trial); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_determined_api_v1_experiment_proto_msgTypes[0].OneofWrappers = []interface{}{}
	file_determined_api_v1_experiment_proto_msgTypes[51].OneofWrappers = []interface{}{
		(*GetExperimentCheckpointsRequest_SortByAttr)(nil),
		(*GetExperimentCheckpointsRequest_SortByMetric)(nil),
	}
	file_determined_api_v1_experiment_proto_msgTypes[55].OneofWrappers = []interface{}{}
	file_determined_api_v1_experiment_proto_msgTypes[79].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_determined_api_v1_experiment_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   86,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_determined_api_v1_experiment_proto_goTypes,
		DependencyIndexes: file_determined_api_v1_experiment_proto_depIdxs,
		EnumInfos:         file_determined_api_v1_experiment_proto_enumTypes,
		MessageInfos:      file_determined_api_v1_experiment_proto_msgTypes,
	}.Build()
	File_determined_api_v1_experiment_proto = out.File
	file_determined_api_v1_experiment_proto_rawDesc = nil
	file_determined_api_v1_experiment_proto_goTypes = nil
	file_determined_api_v1_experiment_proto_depIdxs = nil
}
