-- CREATE RUN METADATA TABLE
CREATE TABLE runs_metadata (
    run_id INTEGER PRIMARY KEY,
    metadata JSONB,
    FOREIGN KEY (run_id) REFERENCES runs(id) ON DELETE CASCADE
);

-- CREATE INDEX TABLE
CREATE TABLE runs_metadata_index (
    id integer PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,
    run_id INTEGER,
    flat_key VARCHAR,
    string_value VARCHAR,
    integer_value INTEGER,
    float_value FLOAT,
    boolean_value BOOLEAN,
    timestamp_value TIMESTAMP,
    project_id INTEGER,
    FOREIGN KEY (run_id) REFERENCES runs(id) ON DELETE CASCADE,
    FOREIGN KEY (project_id) REFERENCES projects(id) ON DELETE CASCADE
);
-- CREATE FILTER-OPTIMIZING INDEX(ES)
CREATE INDEX idx_flat_key ON runs_metadata_index (flat_key);
