-- migrations/20200415135511_scim.tx.up.sql
CREATE SCHEMA IF NOT EXISTS scim;
CREATE TABLE IF NOT EXISTS scim.users (
    id          uuid PRIMARY KEY NOT NULL,
    user_id     INTEGER NOT NULL REFERENCES users(id),
    external_id TEXT NULL,
    name        jsonb NOT NULL,
    emails      jsonb NOT NULL
);

-- migrations/20200513150510_oauth.tx.up.sql
CREATE SCHEMA IF NOT EXISTS oauth;
CREATE TABLE IF NOT EXISTS oauth.tokens (
    access text NOT NULL,
    access_create_at timestamptz NOT NULL,
    access_expires_in bigint NOT NULL,
    client_id text NOT NULL,
    code text NOT NULL,
    code_create_at timestamptz NOT NULL,
    code_expires_in bigint NOT NULL,
    redirect_uri text NOT NULL,
    refresh text NOT NULL,
    refresh_create_at timestamptz NOT NULL,
    refresh_expires_in bigint NOT NULL,
    scope text NOT NULL,
    user_id text NOT NULL,

    id bigserial,

    CONSTRAINT oauth_tokens_pkey PRIMARY KEY (id)
);

CREATE INDEX IF NOT EXISTS idx_oauth_tokens_code ON oauth.tokens (code);
CREATE INDEX IF NOT EXISTS idx_oauth_tokens_access ON oauth.tokens (access);
CREATE INDEX IF NOT EXISTS idx_oauth_tokens_refresh ON oauth.tokens (refresh);

CREATE TABLE IF NOT EXISTS oauth.clients (
    id text NOT NULL,
    secret text NOT NULL,
    domain text NOT NULL,
    name text NOT NULL,

    CONSTRAINT oauth_clients_pkey PRIMARY KEY (id)
);

-- migrations/20220418102556_add-user-attributes.tx.up.sql
ALTER TABLE IF EXISTS scim.users ADD COLUMN IF NOT EXISTS raw_attributes jsonb;

-- migrations/20220628065553_dispatcher-state-persistence.tx.up.sql
CREATE TABLE IF NOT EXISTS resourcemanagers_dispatcher_dispatches (
    dispatch_id text PRIMARY KEY,
    resource_id text NOT NULL REFERENCES allocation_resources(resource_id) ON DELETE CASCADE NOT NULL,
    allocation_id text NOT NULL
);

-- migrations/20220628070126_add-original-users-to-dispatches.tx.up.sql
ALTER TABLE IF EXISTS resourcemanagers_dispatcher_dispatches
    -- Used to cancel the job, since it must be the original user that cancels it.
    ADD COLUMN IF NOT EXISTS impersonated_user text NOT NULL;

-- migrations/20220915145212_add-rbac.tx.up.sql
CREATE TABLE IF NOT EXISTS roles (
    id integer PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY NOT NULL,
    role_name TEXT NOT NULL UNIQUE,
    created_at TIMESTAMP NOT NULL DEFAULT NOW()
);

CREATE TABLE IF NOT EXISTS role_assignment_scopes (
    id integer PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,
scope_workspace_id integer REFERENCES workspaces (id) ON DELETE CASCADE NULL UNIQUE
);

CREATE TABLE IF NOT EXISTS role_assignments (
    group_id integer REFERENCES groups (id),
    role_id integer REFERENCES roles (id) ON DELETE CASCADE,
    scope_id integer NULL REFERENCES role_assignment_scopes (id) ON DELETE CASCADE,

    UNIQUE (group_id, role_id, scope_id)
);

CREATE TABLE IF NOT EXISTS permissions (
    id integer PRIMARY KEY NOT NULL,
    name TEXT NOT NULL,
    global_only boolean NOT NULL
);

CREATE TABLE IF NOT EXISTS permission_assignments (
    permission_id integer REFERENCES permissions (id) ON DELETE CASCADE,
    role_id integer REFERENCES roles (id) ON DELETE CASCADE,

    PRIMARY KEY (permission_id, role_id)
);

-- migrations/20220915145217_add-rbac-precanned-roles-and-permissions.tx.up.sql
INSERT INTO permissions(id, name, global_only) VALUES
    (2001, 'create experiment', false),
    (2004, 'update experiment', false),
    (5002, 'view project', false),
    (96001, 'update roles', true),
    (2005, 'update experiment metadata', false),
    (93001, 'update group', true),
    (94001, 'create workspace', true),
    (4004, 'delete workspace', false),
    (5003, 'update project', false),
    (5004, 'delete project', false),
    (6002, 'assign roles', false),
    (91001, 'administrate user', true),
    (2002, 'view experiment artifacts', false),
    (4003, 'update workspace', false),
    (2003, 'view experiment metadata', false),
    (2006, 'delete experiment', false),
    (4002, 'view workspace', false),
    (5001, 'create project', false)
    ON CONFLICT DO NOTHING;

INSERT INTO roles(id, role_name) VALUES
    (1, 'ClusterAdmin'),
    (2, 'WorkspaceAdmin'),
    (3, 'WorkspaceCreator'),
    (4, 'Viewer'),
    (5, 'Editor')
    ON CONFLICT DO NOTHING;

INSERT INTO permission_assignments(permission_id, role_id)
SELECT id AS permission_id, 1 FROM permissions
ON CONFLICT DO NOTHING;

INSERT INTO permission_assignments(permission_id, role_id)
SELECT id AS permission_id, 2 FROM permissions WHERE name IN (
    'create experiment',
    'view experiment artifacts',
    'view experiment metadata',
    'update experiment',
    'update experiment metadata',
    'delete experiment',
    'view workspace',
    'update workspace',
    'delete workspace',
    'view project',
    'create project',
    'delete project',
    'assign roles'
)
ON CONFLICT DO NOTHING;

INSERT INTO permission_assignments(permission_id, role_id)
SELECT id AS permission_id, 3 FROM permissions WHERE name = 'create workspace'
ON CONFLICT DO NOTHING;

INSERT INTO permission_assignments(permission_id, role_id)
SELECT id AS permission_id, 4 FROM permissions WHERE name IN (
    'view experiment artifacts',
    'view experiment metadata',
    'view project',
    'view experiment'
)
ON CONFLICT DO NOTHING;

INSERT INTO permission_assignments(permission_id, role_id)
SELECT id AS permission_id, 5 FROM permissions WHERE name IN (
    'create experiment',
    'view experiment artifacts',
    'view experiment metadata',
    'update experiment',
    'update experiment metadata',
    'delete experiment',
    'view workspace',
    'update workspace',
    'view project',
    'create project',
    'update project'
)
ON CONFLICT DO NOTHING;

-- migrations/20220920120431_add-workspace-viewer-to-viewer.tx.up.sql
INSERT INTO permission_assignments(permission_id, role_id)
    SELECT id AS permission_id, 4 FROM permissions WHERE name = 'view workspace'
    ON CONFLICT DO NOTHING;

-- migrations/20220923152549_add-project-update-permissions.tx.up.sql
INSERT INTO permission_assignments(permission_id, role_id)
    SELECT id AS permission_id, 2 FROM permissions WHERE name = 'update project'
    ON CONFLICT DO NOTHING;

-- migrations/20221003134951_add-permission-workspace-set-agent-user-group.tx.up.sql
INSERT INTO permissions(id, name, global_only) VALUES (4005, 'set agent user group on workspace', false)
    ON CONFLICT DO NOTHING;
INSERT INTO permission_assignments(permission_id, role_id) VALUES (4005, 1) ON CONFLICT DO NOTHING;

-- migrations/20221010145619_add-cluster-admin-to-admin.tx.up.sql
INSERT INTO role_assignment_scopes(scope_workspace_id)
    SELECT NULL WHERE NOT EXISTS (
        SELECT * FROM role_assignment_scopes WHERE scope_workspace_id IS NULL
    ) ON CONFLICT DO NOTHING;

INSERT INTO role_assignments(role_id, group_id, scope_id)
WITH
    g AS (
        SELECT id FROM groups WHERE user_id = 1
    ),
    s AS (
        SELECT id FROM role_assignment_scopes WHERE scope_workspace_id IS NULL
    )
SELECT 1, g.id AS group_id, s.id AS scope_id FROM g, s
WHERE (
          -- Only assign ClusterAdmin to 'admin' if it is a fresh cluster installation.
          SELECT MIN(created_at) >= NOW() - INTERVAL '1 hour' FROM gopg_migrations WHERE version = '20200401000000'
    ) ON CONFLICT DO NOTHING;

-- migrations/20221010150438_add-edit-webhooks-permissions.tx.up.sql
INSERT INTO permissions(id, name, global_only) VALUES (97001, 'edit webhooks', true) ON CONFLICT DO NOTHING;
INSERT INTO permission_assignments(permission_id, role_id) VALUES (97001, 1) ON CONFLICT DO NOTHING;

-- migrations/20221020115625_role-assignments-group-id-on-delete-cascade.tx.up.sql
ALTER TABLE IF EXISTS role_assignments
DROP CONSTRAINT role_assignments_group_id_fkey,
  ADD CONSTRAINT role_assignments_group_id_fkey
    FOREIGN KEY (group_id) REFERENCES groups (id) ON DELETE CASCADE;

-- migrations/20221101121000_add-permission-set-workspace-checkpoint-storage.tx.up.sql
INSERT INTO permissions(id, name, global_only) VALUES
    (4006, 'set checkpoint storage config on workspace', false) ON CONFLICT DO NOTHING;
INSERT INTO permission_assignments(permission_id, role_id) VALUES
    (4006, 1),
    (4006, 2)
    ON CONFLICT DO NOTHING;

-- migrations/20221104091414_fixup-dispatcher-state-persistence.tx.up.sql
ALTER TABLE IF EXISTS public.resourcemanagers_dispatcher_dispatches ALTER COLUMN resource_id DROP NOT NULL;
ALTER TABLE IF EXISTS public.resourcemanagers_dispatcher_dispatches
DROP CONSTRAINT IF EXISTS resourcemanagers_dispatcher_dispatches_resource_id_fkey,
  ADD CONSTRAINT resourcemanagers_dispatcher_dispatches_resource_id_fkey
    FOREIGN KEY (resource_id) REFERENCES public.allocation_resources(resource_id) ON DELETE SET NULL;

-- migrations/20230118101629_add-rbac-model-registry-precanned-roles-and-permissions.tx.up.sql
INSERT into permissions(id, name, global_only) VALUES
    (7001, 'view model registry', false),
    (7002, 'edit model registry', false),
    (7003, 'create model registry', false)
    ON CONFLICT DO NOTHING;

INSERT INTO roles(id, role_name) VALUES
    (6, 'ModelRegistryViewer') ON CONFLICT DO NOTHING;

INSERT INTO permission_assignments(permission_id, role_id)
SELECT id AS permission_id, 1 FROM permissions WHERE name IN (
    'view model registry',
    'edit model registry',
    'create model registry') ON CONFLICT DO NOTHING;

INSERT INTO permission_assignments(permission_id, role_id)
SELECT id AS permission_id, 2 FROM permissions WHERE name IN (
    'view model registry',
    'edit model registry',
    'create model registry') ON CONFLICT DO NOTHING;

INSERT INTO permission_assignments(permission_id, role_id)
SELECT id AS permission_id, 4 FROM permissions WHERE name = 'view model registry'
ON CONFLICT DO NOTHING;

INSERT INTO permission_assignments(permission_id, role_id)
SELECT id AS permission_id, 5 FROM permissions WHERE name IN (
        'view model registry',
        'edit model registry',
        'create model registry') ON CONFLICT DO NOTHING;

INSERT INTO permission_assignments(permission_id, role_id)
SELECT id AS permission_id, 6 FROM permissions WHERE name = 'view model registry'
ON CONFLICT DO NOTHING;

-- migrations/20230131200051_add-permissions-ntsc.tx.up.sql
INSERT INTO permissions(id, name, global_only) VALUES
    (3001, 'create notebooks/shells/commands', false),
    (3002, 'view notebooks/shells/commands', false),
    (3003, 'update notebooks/shells/commands', false)
    ON CONFLICT DO NOTHING;
INSERT INTO permission_assignments(permission_id, role_id) VALUES
    (3001, 1),
    (3001, 2),
    (3001, 5),
    (3002, 1),
    (3002, 2),
    (3002, 4),
    (3002, 5),
    (3003, 1),
    (3003, 2),
    (3003, 5)
    ON CONFLICT DO NOTHING;

-- migrations/20230306153250_add-table-resource-managers-dispatcher-state.tx.up.sql
CREATE TABLE IF NOT EXISTS resourcemanagers_dispatcher_rm_state (
    id int UNIQUE DEFAULT(0),
    CONSTRAINT id_test CHECK (id = 0),
    disabled_agents text[] NOT NULL DEFAULT '{}'
);

-- migrations/20230322100611_add-rbac-update-agents.tx.up.sql
INSERT INTO permissions (
    id, name, global_only
) VALUES
    (8003, 'update agents', true)
    ON CONFLICT DO NOTHING;
-- ClusterAdmin role
INSERT INTO permission_assignments (permission_id, role_id) VALUES
    (8003, 1)
    ON CONFLICT DO NOTHING;

-- migrations/20230328130101_add_port_offset_allocations.tx.up.sql
ALTER TABLE IF EXISTS allocations
    ADD COLUMN IF NOT EXISTS ports jsonb DEFAULT '{}' not null;

-- migrations/20230331111924_remote-user-ee.tx.up.sql
-- SCIM users are remote users; their passwords are either synced from Okta or blank and they must
-- use SSO. Additionally, regular users can be marked as remote users.
UPDATE users SET remote = true WHERE id IN (SELECT user_id FROM scim.users);

-- migrations/20230404144709_add-rbac-delete-model.tx.up.sql
INSERT INTO permissions (
    id, name, global_only
) VALUES
    (7004, 'delete model registry', false) ON CONFLICT DO NOTHING;
-- ClusterAdmin, WorkspaceAdmin, Editor roles
INSERT INTO permission_assignments (permission_id, role_id) VALUES
    (7004, 1),
    (7004, 2),
    (7004, 5)
    ON CONFLICT DO NOTHING;

-- migrations/20230406104244_add-rbac-misc.tx.up.sql
INSERT INTO permissions (
    id, name, global_only
) VALUES
    (8001, 'view master logs', true),
    (8002, 'view detailed cluster usage', true)
    ON CONFLICT DO NOTHING;
-- ClusterAdmin role
INSERT INTO permission_assignments (permission_id, role_id) VALUES
    (8001, 1),
    (8002, 1)
    ON CONFLICT DO NOTHING;

-- migrations/20230601145606_add-rbac-agent-info.tx.up.sql
INSERT INTO permissions (
    id, name, global_only
) VALUES
    (8004, 'view sensitive agent info', true)
    ON CONFLICT DO NOTHING;
-- ClusterAdmin role
INSERT INTO permission_assignments (permission_id, role_id) VALUES (8004, 1) ON CONFLICT DO NOTHING;

-- migrations/20230622152651_assign-template-permissions.tx.up.sql
--   // Ability to view templates.
--   PERMISSION_TYPE_VIEW_TEMPLATES = 9001;
--   // Ability to update templates.
--   PERMISSION_TYPE_UPDATE_TEMPLATES = 9002;
--   // Ability to create templates.
--   PERMISSION_TYPE_CREATE_TEMPLATES = 9003;
--   // Ability to delete templates.
--   PERMISSION_TYPE_DELETE_TEMPLATES = 9004;

INSERT INTO permissions(id, name, global_only) VALUES
    (9001, 'view templates', false),
    (9002, 'update templates', false),
    (9003, 'create templates', false),
    (9004, 'delete templates', false)
    ON CONFLICT DO NOTHING;

--    (1, 'ClusterAdmin'),
--    (2, 'WorkspaceAdmin'),
--    (3, 'WorkspaceCreator'),
--    (4, 'Viewer'),
--    (5, 'Editor');

INSERT INTO permission_assignments(permission_id, role_id)
SELECT id AS permission_id, 1 FROM permissions WHERE name IN (
    'view templates',
    'update templates',
    'create templates',
    'delete templates'
) ON CONFLICT DO NOTHING;

INSERT INTO permission_assignments(permission_id, role_id)
SELECT id AS permission_id, 2 FROM permissions WHERE name IN (
    'view templates',
    'update templates',
    'create templates',
    'delete templates'
) ON CONFLICT DO NOTHING;

INSERT INTO permission_assignments(permission_id, role_id)
SELECT id AS permission_id, 4 FROM permissions WHERE name IN (
    'view templates'
) ON CONFLICT DO NOTHING;

INSERT INTO permission_assignments(permission_id, role_id)
SELECT id AS permission_id, 5 FROM permissions WHERE name IN (
    'view templates',
    'update templates',
    'create templates',
    'delete templates'
) ON CONFLICT DO NOTHING;


-- migrations/20230627154016_precanned-jobq-control-permissions.tx.up.sql
--  // Ability to control strict job queue.
--  PERMISSION_TYPE_CONTROL_STRICT_JOB_QUEUE = 8101;

INSERT into permissions(id, name, global_only) VALUES
    (8101, 'control strict job queue', true) ON CONFLICT DO NOTHING;
-- determined> select * from roles;
-- +----+---------------------+----------------------------+
-- | id | role_name           | created_at                 |
-- |----+---------------------+----------------------------|
-- | 1  | ClusterAdmin        | 2023-05-30 16:20:54.825443 |
-- | 2  | WorkspaceAdmin      | 2023-05-30 16:20:54.825443 |
-- | 3  | WorkspaceCreator    | 2023-05-30 16:20:54.825443 |
-- | 4  | Viewer              | 2023-05-30 16:20:54.825443 |
-- | 5  | Editor              | 2023-05-30 16:20:54.825443 |
-- | 6  | ModelRegistryViewer | 2023-05-30 16:20:55.136146 |
-- +----+---------------------+----------------------------+
-- SELECT 6

INSERT INTO permission_assignments (permission_id, role_id)
SELECT 8101, roles.id
FROM roles
WHERE roles.role_name IN ('ClusterAdmin') ON CONFLICT DO NOTHING;

-- migrations/20230629164635_add-rbac-delete-others-models-and-versions.tx.up.sql
INSERT INTO permissions (
    id, name, global_only
) VALUES
    (7005, 'delete model version', false),
    (7006, 'delete other user model registry', false),
    (7007, 'delete other user model version', false)
    ON CONFLICT DO NOTHING;
INSERT INTO permission_assignments (permission_id, role_id) VALUES
    (7005, 1), -- ClusterAdmin
    (7005, 2), -- WorkspaceAdmin
    (7005, 5), -- Editor
    (7006, 1),
    (7006, 2),
    (7007, 1),
    (7007, 2)
    ON CONFLICT DO NOTHING;

-- migrations/20230705120612_add-rbac-master-config.tx.up.sql
--  // Ability to view master configs
--  PERMISSION_TYPE_VIEW_MASTER_CONFIG = 8005;

INSERT into permissions(id, name, global_only) VALUES
    (8005, 'view master config', true) ON CONFLICT DO NOTHING;
-- determined> select * from roles;
-- +----+---------------------+----------------------------+
-- | id | role_name           | created_at                 |
-- |----+---------------------+----------------------------|
-- | 1  | ClusterAdmin        | 2023-05-30 16:20:54.825443 |
-- | 2  | WorkspaceAdmin      | 2023-05-30 16:20:54.825443 |
-- | 3  | WorkspaceCreator    | 2023-05-30 16:20:54.825443 |
-- | 4  | Viewer              | 2023-05-30 16:20:54.825443 |
-- | 5  | Editor              | 2023-05-30 16:20:54.825443 |
-- | 6  | ModelRegistryViewer | 2023-05-30 16:20:55.136146 |
-- +----+---------------------+----------------------------+
-- SELECT 6
INSERT INTO permission_assignments (permission_id, role_id)
SELECT 8005, roles.id
FROM roles
WHERE roles.role_name IN ('ClusterAdmin')
ON CONFLICT DO NOTHING;

-- migrations/20230717074913_add-rbac-patch-master-config.tx.up.sql
--  // Ability to update master configs
--  PERMISSION_TYPE_VIEW_MASTER_CONFIG = 8006;

INSERT into permissions(id, name, global_only) VALUES
    (8006, 'update master config', true) ON CONFLICT DO NOTHING;
-- determined> select * from roles;
-- +----+---------------------+----------------------------+
-- | id | role_name           | created_at                 |
-- |----+---------------------+----------------------------|
-- | 1  | ClusterAdmin        | 2023-05-30 16:20:54.825443 |
-- | 2  | WorkspaceAdmin      | 2023-05-30 16:20:54.825443 |
-- | 3  | WorkspaceCreator    | 2023-05-30 16:20:54.825443 |
-- | 4  | Viewer              | 2023-05-30 16:20:54.825443 |
-- | 5  | Editor              | 2023-05-30 16:20:54.825443 |
-- | 6  | ModelRegistryViewer | 2023-05-30 16:20:55.136146 |
-- +----+---------------------+----------------------------+
-- SELECT 6
INSERT INTO permission_assignments (permission_id, role_id)
SELECT 8006, roles.id
FROM roles
WHERE roles.role_name IN ('ClusterAdmin')
ON CONFLICT DO NOTHING;

-- migrations/20230717134652_add-rbac-oauth.tx.up.sql
--   // Ability to manage OAuth clients and settings.
--   PERMISSION_TYPE_ADMINSTRATE_OAUTH = 91002;
INSERT INTO permissions(id, name, global_only) VALUES
    (91002, 'manage oauth', true) ON CONFLICT DO NOTHING;

INSERT INTO permission_assignments(permission_id, role_id)
SELECT p.id AS permission_id, r.id AS role_id
FROM permissions p
         JOIN roles r ON r.role_name = 'ClusterAdmin'
WHERE p.name IN ('manage oauth')
ON CONFLICT DO NOTHING;

-- migrations/20230817192921_add-rp-workspace-bindings-permissions.tx.up.sql
INSERT INTO permissions(id, name, global_only) VALUES
    (4007, 'set default resource pool on workspace', false),
    (10001, 'modify rp workspace bindings', true)
    ON CONFLICT DO NOTHING;

-- add permission for cluster admin and workspace admin
INSERT INTO permission_assignments(permission_id, role_id)
SELECT id AS permission_id, 1 FROM permissions WHERE name IN (
    'set default resource pool on workspace',
    'modify rp workspace bindings'
) ON CONFLICT DO NOTHING;

INSERT INTO permission_assignments(permission_id, role_id)
SELECT id AS permission_id, 2 FROM permissions WHERE name IN (
    'set default resource pool on workspace'
) ON CONFLICT DO NOTHING;

-- migrations/20230829165639_add-rbac-external-jobs.tx.up.sql
--  // Ability to view external jobs
--  PERMISSION_TYPE_VIEW_EXTERNAL_JOBS = 8007;

INSERT into permissions(id, name, global_only) VALUES
    (8007, 'view external jobs', true) ON CONFLICT DO NOTHING;
-- determined> select * from roles;
-- +----+---------------------+----------------------------+
-- | id | role_name           | created_at                 |
-- |----+---------------------+----------------------------|
-- | 1  | ClusterAdmin        | 2023-05-30 16:20:54.825443 |
-- | 2  | WorkspaceAdmin      | 2023-05-30 16:20:54.825443 |
-- | 3  | WorkspaceCreator    | 2023-05-30 16:20:54.825443 |
-- | 4  | Viewer              | 2023-05-30 16:20:54.825443 |
-- | 5  | Editor              | 2023-05-30 16:20:54.825443 |
-- | 6  | ModelRegistryViewer | 2023-05-30 16:20:55.136146 |
-- +----+---------------------+----------------------------+
-- SELECT 6
INSERT INTO permission_assignments (permission_id, role_id)
SELECT 8007, roles.id
FROM roles
WHERE roles.role_name IN ('ClusterAdmin')
ON CONFLICT DO NOTHING;

-- migrations/20231030092419_remove-editor-update-workspace-perm.tx.up.sql
DELETE FROM permission_assignments WHERE permission_id = 4003 AND role_id = 5;

-- migrations/20240307112341_add-editor-restricted-role.tx.up.sql
INSERT INTO roles(id, role_name) VALUES (7, 'EditorRestricted') ON CONFLICT DO NOTHING;

INSERT INTO permission_assignments(permission_id, role_id)
SELECT permission_id, 7 FROM permission_assignments
WHERE
        role_id = (SELECT id FROM roles WHERE role_name = 'Editor')
  AND permission_id NOT IN (SELECT id FROM permissions
                            WHERE name = 'create notebooks/shells/commands'
                               OR name = 'update notebooks/shells/commands')
ON CONFLICT DO NOTHING;


