/*
 starting state:

 determined> \d raw_steps;
 +---------------+--------------------------+---------------------------------------------------------+
 | Column        | Type                     | Modifiers                                               |
 |---------------+--------------------------+---------------------------------------------------------|
 | trial_id      | integer                  |  not null                                               |
 | end_time      | timestamp with time zone |                                                         |
 | metrics       | jsonb                    |                                                         |
 | total_batches | integer                  |  not null default 0                                     |
 | trial_run_id  | integer                  |  not null default 0                                     |
 | archived      | boolean                  |  not null default false                                 |
 | id            | integer                  |  not null default nextval('raw_steps_id_seq'::regclass) |
 +---------------+--------------------------+---------------------------------------------------------+
 Indexes:
 "steps_trial_id_total_batches_run_id_unique" UNIQUE, btree (trial_id, total_batches, trial_run_id)
 "steps_archived" btree (archived)
 Foreign-key constraints:
 "steps_trial_id_fkey" FOREIGN KEY (trial_id) REFERENCES trials(id)

 determined> \d raw_validations;
 +---------------+--------------------------+--------------------------------------------+
 | Column        | Type                     | Modifiers                                  |
 |---------------+--------------------------+--------------------------------------------|
 | id            | integer                  |  not null generated by default as identity |
 | trial_id      | integer                  |  not null                                  |
 | end_time      | timestamp with time zone |                                            |
 | metrics       | jsonb                    |                                            |
 | total_batches | integer                  |  not null default 0                        |
 | trial_run_id  | integer                  |  not null default 0                        |
 | archived      | boolean                  |  not null default false                    |
 +---------------+--------------------------+--------------------------------------------+
 Indexes:
 "validations_pkey" PRIMARY KEY, btree (id)
 "validations_trial_id_total_batches_run_id_unique" UNIQUE, btree (trial_id, total_batches, trial_run_id)
 "ix_validations_trial_id" btree (trial_id)
 "validations_archived" btree (archived)
 Referenced by:
 TABLE "trials" CONSTRAINT "trials_latest_validation_id_fkey" FOREIGN KEY (latest_validation_id) REFERENCES raw_validations(id) ON DELETE SET NULL
 Triggers:
 autoupdate_exp_validation_metrics_name AFTER INSERT ON raw_validations FOR EACH ROW EXECUTE PROCEDURE autoupdate_exp_validation_metrics_name()
 */
-- fix missing foreign key constraint on raw_validations
DELETE FROM raw_validations
WHERE NOT EXISTS (
    SELECT 1
    FROM trials
    WHERE trials.id = raw_validations.trial_id
);
ALTER TABLE raw_validations
ADD FOREIGN KEY (trial_id) REFERENCES trials (id);

CREATE TYPE metric_partition_type AS ENUM ('VALIDATION', 'TRAINING', 'GENERIC');

CREATE SEQUENCE metrics_id_seq;
SELECT setval(
    'metrics_id_seq',
    greatest(
        coalesce(
            (
                SELECT max(id)
                FROM raw_steps
            ),
            0
        ),
        coalesce(
            (
                SELECT max(id)
                FROM raw_validations
            ),
            0
        )
    ) + 1,
    true
);

-- reshape raw_validations
ALTER TABLE raw_validations
ADD COLUMN partition_type metric_partition_type NOT NULL DEFAULT 'VALIDATION';
ALTER TABLE raw_validations
ADD COLUMN custom_type text;
ALTER TABLE raw_validations
ALTER COLUMN id DROP IDENTITY;
ALTER TABLE raw_validations
ALTER COLUMN id
SET DEFAULT nextval('metrics_id_seq');

-- reshape raw_steps
ALTER TABLE raw_steps
ADD COLUMN partition_type metric_partition_type NOT NULL DEFAULT 'TRAINING';
ALTER TABLE raw_steps
ADD COLUMN custom_type text;
ALTER TABLE raw_steps
ALTER COLUMN id
SET DEFAULT nextval('metrics_id_seq');

CREATE TABLE generic_metrics (
    trial_id integer NOT NULL,
    end_time timestamp with time zone,
    metrics jsonb,
    total_batches integer NOT NULL DEFAULT 0,
    trial_run_id integer NOT NULL DEFAULT 0,
    archived boolean NOT NULL DEFAULT false,
    id integer NOT NULL DEFAULT nextval('metrics_id_seq'),
    partition_type metric_partition_type NOT NULL DEFAULT 'GENERIC',
    custom_type text,
    FOREIGN KEY (trial_id) REFERENCES trials (id)
);
CREATE UNIQUE INDEX generic_metrics_trial_id_total_batches_run_id_unique
ON generic_metrics (trial_id, total_batches, trial_run_id);
CREATE INDEX generic_metrics_archived
ON generic_metrics (archived);


CREATE TABLE metrics (
    trial_id integer NOT NULL,
    end_time timestamp with time zone,
    metrics jsonb,
    total_batches integer NOT NULL DEFAULT 0,
    trial_run_id integer NOT NULL DEFAULT 0,
    archived boolean NOT NULL DEFAULT false,
    id integer NOT NULL DEFAULT nextval('metrics_id_seq'),
    custom_type text,
    partition_type metric_partition_type NOT NULL DEFAULT 'GENERIC'
) PARTITION BY LIST (partition_type);

ALTER TABLE metrics ATTACH PARTITION generic_metrics FOR
VALUES IN ('GENERIC');
ALTER TABLE metrics ATTACH PARTITION raw_validations FOR
VALUES IN ('VALIDATION');
ALTER TABLE metrics ATTACH PARTITION raw_steps FOR
VALUES IN ('TRAINING');
