DO $$
    BEGIN
        IF EXISTS (SELECT 1
                  FROM information_schema.columns
                  WHERE table_schema = 'public'
                    AND table_name = 'trial_logs'
                    AND column_name = 'id'
                    AND numeric_precision = 32) THEN
            ALTER TABLE public.trial_logs ADD COLUMN id_new int8 NULL;
            UPDATE public.trial_logs SET id_new = id;
            ALTER TABLE public.trial_logs DROP CONSTRAINT trial_logs_pkey;
            ALTER TABLE public.trial_logs RENAME COLUMN id TO id_old;
            ALTER TABLE public.trial_logs RENAME COLUMN id_new TO id;
            ALTER TABLE public.trial_logs ADD PRIMARY KEY (id);
            ALTER TABLE public.trial_logs DROP COLUMN id_old;
            ALTER TABLE public.trial_logs ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
                SEQUENCE NAME public.trial_logs_id_seq
                START WITH 1
                INCREMENT BY 1
                NO MINVALUE
                NO MAXVALUE
                CACHE 1
            );
            PERFORM setval('public.trial_logs_id_seq', (SELECT MAX(id) FROM public.trial_logs), true);
        END IF;
    END;
$$
