CREATE TABLE public.models (
	id integer NOT NULL,
	name character varying UNIQUE NOT NULL,
	description character varying,
	metadata jsonb,
	creation_time timestamp with time zone NOT NULL,
	last_updated_time timestamp with time zone,

	CONSTRAINT models_pkey PRIMARY KEY (id)
);

ALTER TABLE public.models ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.models_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);

CREATE TABLE public.model_versions (
	id integer NOT NULL,
	version integer NOT NULL,
	model_id integer NOT NULL,
	checkpoint_id integer NOT NULL,
	metadata jsonb,
	creation_time timestamp with time zone NOT NULL,

	CONSTRAINT model_versions_pkey PRIMARY KEY (id),
	CONSTRAINT model_and_version_unique UNIQUE (model_id, version),
	FOREIGN KEY(model_id) REFERENCES public.models(id),
	FOREIGN KEY(checkpoint_id) REFERENCES public.checkpoints(id)
);

ALTER TABLE public.model_versions ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.model_versions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
