CREATE TABLE roles (
    id integer PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY NOT NULL,
    role_name TEXT NOT NULL UNIQUE,
    created_at TIMESTAMP NOT NULL DEFAULT NOW()
);

CREATE TABLE role_assignment_scopes (
    id integer PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,
    scope_workspace_id integer REFERENCES workspaces (id) ON DELETE CASCADE NULL UNIQUE
);

CREATE TABLE role_assignments (
    group_id integer REFERENCES groups (id),
    role_id integer REFERENCES roles (id) ON DELETE CASCADE,
    scope_id integer NULL REFERENCES role_assignment_scopes (id) ON DELETE CASCADE,

    UNIQUE (group_id, role_id, scope_id)
);

CREATE TABLE permissions (
    id integer PRIMARY KEY NOT NULL,
    name TEXT NOT NULL,
    global_only boolean NOT NULL
);

CREATE TABLE permission_assignments (
    permission_id integer REFERENCES permissions (id) ON DELETE CASCADE,
    role_id integer REFERENCES roles (id) ON DELETE CASCADE,

    PRIMARY KEY (permission_id, role_id)
);
