// Code generated by gen.py. DO NOT EDIT.

package schemas

import (
	"encoding/json"
	"sync"
)

var (
	textAzureConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/azure.json",
    "title": "AzureConfig",
    "type": "object",
    "additionalProperties": false,
    "required": [
        "type"
    ],
    "eventuallyRequired": [
        "container"
    ],
    "eventually": {
        "checks": {
            "Exactly one of connection_string or account_url must be set": {
                "oneOf": [
                    {
                        "eventuallyRequired": [
                            "connection_string"
                        ]
                    },
                    {
                        "eventuallyRequired": [
                            "account_url"
                        ]
                    }
                ]
            }
        }
    },
    "checks": {
        "credential and connection_string must not both be set": {
            "not": {
                "required": [
                    "connection_string",
                    "credential"
                ],
                "properties": {
                    "connection_string": {
                        "type": "string"
                    },
                    "credential": {
                        "type": "string"
                    }
                }
            }
        }
    },
    "properties": {
        "type": {
            "const": "azure"
        },
        "container": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "connection_string": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "account_url": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "credential": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "save_experiment_best": {
            "type": [
                "integer",
                "null"
            ],
            "default": 0,
            "minimum": 0
        },
        "save_trial_best": {
            "type": [
                "integer",
                "null"
            ],
            "default": 1,
            "minimum": 0
        },
        "save_trial_latest": {
            "type": [
                "integer",
                "null"
            ],
            "default": 1,
            "minimum": 0
        }
    }
}
`)
	textBindMountV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/bind-mount.json",
    "title": "BindMount",
    "additionalProperties": false,
    "required": [
        "host_path",
        "container_path"
    ],
    "type": "object",
    "properties": {
        "host_path": {
            "type": "string",
            "checks": {
                "host_path must be an absolute path": {
                    "pattern": "^/"
                }
            }
        },
        "container_path": {
            "type": "string",
            "checks": {
                "container_path must not be \".\"": {
                    "not": {
                        "const": "."
                    }
                }
            }
        },
        "read_only": {
            "type": [
                "boolean",
                "null"
            ],
            "default": false
        },
        "propagation": {
            "type": [
                "string",
                "null"
            ],
            "default": "rprivate"
        }
    }
}
`)
	textBindMountsConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/bind-mounts.json",
    "title": "BindMountsConfig",
    "type": "array",
    "items": {
        "$ref": "http://determined.ai/schemas/expconf/v0/bind-mount.json"
    }
}
`)
	textCheckGridHyperparameterV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/check-grid-hyperparameter.json",
    "title": "CheckGridHyperparameter",
    "union": {
        "items": [
            {
                "unionKey": "type:array",
                "type": "array",
                "items": {
                    "$ref": "http://determined.ai/schemas/expconf/v0/check-grid-hyperparameter.json"
                }
            },
            {
                "unionKey": "not:hasattr:type",
                "type": "object",
                "properties": {
                    "type": false
                },
                "additionalProperties": {
                    "$ref": "http://determined.ai/schemas/expconf/v0/check-grid-hyperparameter.json"
                }
            },
            {
                "unionKey": "never",
                "not": {
                    "type": [
                        "object",
                        "array"
                    ]
                }
            },
            {
                "unionKey": "hasattr:type",
                "type": "object",
                "required": [
                    "type"
                ],
                "properties": {
                    "type": {
                        "type": "string"
                    }
                },
                "checks": {
                    "grid search is in use but count was not provided": {
                        "if": {
                            "$comment": "if type is double/log/int, expect non-null count",
                            "properties": {
                                "type": {
                                    "enum": [
                                        "double",
                                        "log",
                                        "int"
                                    ]
                                }
                            }
                        },
                        "then": {
                            "not": {
                                "properties": {
                                    "count": {
                                        "type": "null"
                                    }
                                }
                            }
                        }
                    }
                }
            }
        ]
    }
}
`)
	textCheckPositiveLengthV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/check-positive-length.json",
    "title": "CheckPositiveLength",
    "allOf": [
        {
            "$ref": "http://determined.ai/schemas/expconf/v0/length.json"
        },
        {
            "additionalProperties": {
                "type": "integer",
                "minimum": 1
            }
        }
    ]
}
`)
	textCheckpointStorageConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/checkpoint-storage.json",
    "title": "CheckpointStorageConfig",
    "$comment": "this is a union of all possible properties, with validation for the common properties",
    "if": {
        "required": [
            "type"
        ]
    },
    "then": {
        "union": {
            "defaultMessage": "is not an object where object[\"type\"] is one of 'shared_fs', 'directory', 's3', 'gcs', or 'azure'",
            "items": [
                {
                    "unionKey": "const:type=shared_fs",
                    "$ref": "http://determined.ai/schemas/expconf/v0/shared-fs.json"
                },
                {
                    "unionKey": "const:type=directory",
                    "$ref": "http://determined.ai/schemas/expconf/v0/directory.json"
                },
                {
                    "unionKey": "const:type=s3",
                    "$ref": "http://determined.ai/schemas/expconf/v0/s3.json"
                },
                {
                    "unionKey": "const:type=gcs",
                    "$ref": "http://determined.ai/schemas/expconf/v0/gcs.json"
                },
                {
                    "unionKey": "const:type=azure",
                    "$ref": "http://determined.ai/schemas/expconf/v0/azure.json"
                }
            ]
        }
    },
    "additionalProperties": false,
    "eventuallyRequired": [
        "type"
    ],
    "properties": {
        "access_key": true,
        "account_url": true,
        "bucket": true,
        "checkpoint_path": true,
        "connection_string": true,
        "container": true,
        "container_path": true,
        "credential": true,
        "endpoint_url": true,
        "prefix": true,
        "host_path": true,
        "propagation": true,
        "secret_key": true,
        "storage_path": true,
        "tensorboard_path": true,
        "type": true,
        "user": true,
        "save_experiment_best": {
            "type": [
                "integer",
                "null"
            ],
            "default": 0,
            "minimum": 0
        },
        "save_trial_best": {
            "type": [
                "integer",
                "null"
            ],
            "default": 1,
            "minimum": 0
        },
        "save_trial_latest": {
            "type": [
                "integer",
                "null"
            ],
            "default": 1,
            "minimum": 0
        }
    }
}
`)
	textDeviceV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/device.json",
    "title": "Device",
    "additionalProperties": false,
    "required": [
        "host_path",
        "container_path"
    ],
    "type": "object",
    "properties": {
        "host_path": {
            "type": "string"
        },
        "container_path": {
            "type": "string"
        },
        "mode": {
            "type": [
                "string",
                "null"
            ],
            "default": "mrw"
        }
    }
}
`)
	textDevicesConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/devices.json",
    "title": "DevicesConfig",
    "type": "array",
    "items": {
        "union": {
            "defaultMessage": "is neither a list of --device strings nor a map containing host_path, container_path, and mode",
            "items": [
                {
                    "unionKey": "never",
                    "$ref": "http://determined.ai/schemas/expconf/v0/device.json"
                },
                {
                    "unionKey": "never",
                    "type": "string",
                    "$comment": "from man docker-run: --device=onhost:incontainer[:mode] ",
                    "pattern": "^/[^:]*:/[^:]*(:[rwm]*)?"
                }
            ]
        }
    }
}
`)
	textDirectoryConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/directory.json",
    "title": "DirectoryConfig",
    "type": "object",
    "additionalProperties": false,
    "required": [
        "type"
    ],
    "eventuallyRequired": [
        "container_path"
    ],
    "properties": {
        "type": {
            "const": "directory"
        },
        "container_path": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "save_experiment_best": {
            "type": [
                "integer",
                "null"
            ],
            "default": 0,
            "minimum": 0
        },
        "save_trial_best": {
            "type": [
                "integer",
                "null"
            ],
            "default": 1,
            "minimum": 0
        },
        "save_trial_latest": {
            "type": [
                "integer",
                "null"
            ],
            "default": 1,
            "minimum": 0
        }
    }
}
`)
	textEnvironmentImageMapV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/environment-image-map.json",
    "title": "EnvironmentImageMap",
    "type": "object",
    "additionalProperties": false,
    "required": [],
    "eventuallyRequired": [
        "cpu",
        "cuda",
        "rocm"
    ],
    "properties": {
        "cpu": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "cuda": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "rocm": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "gpu": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        }
    }
}
`)
	textEnvironmentImageV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/environment-image.json",
    "title": "EnvironmentImage",
    "union": {
        "defaultMessage": "is neither a string nor a map of cpu, cuda, or rocm to strings",
        "items": [
            {
                "unionKey": "never",
                "$ref": "http://determined.ai/schemas/expconf/v0/environment-image-map.json"
            },
            {
                "unionKey": "never",
                "type": "string"
            }
        ]
    }
}
`)
	textEnvironmentVariablesMapV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/environment-variables-map.json",
    "title": "EnvironmentVariablesMap",
    "type": "object",
    "additionalProperties": false,
    "properties": {
        "cpu": {
            "type": [
                "array",
                "null"
            ],
            "default": [],
            "items": {
                "type": "string"
            }
        },
        "cuda": {
            "type": [
                "array",
                "null"
            ],
            "default": [],
            "items": {
                "type": "string"
            }
        },
        "rocm": {
            "type": [
                "array",
                "null"
            ],
            "default": [],
            "items": {
                "type": "string"
            }
        },
        "gpu": {
            "type": [
                "array",
                "null"
            ],
            "default": [],
            "items": {
                "type": "string"
            }
        }
    }
}
`)
	textEnvironmentVariablesV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/environment-variables.json",
    "title": "EnvironmentVariables",
    "union": {
        "defaultMessage": "is neither a list of strings nor a map of cpu, cuda, or rocm to lists of strings",
        "items": [
            {
                "unionKey": "never",
                "$ref": "http://determined.ai/schemas/expconf/v0/environment-variables-map.json"
            },
            {
                "unionKey": "never",
                "type": "array",
                "items": {
                    "type": "string"
                }
            }
        ]
    }
}
`)
	textEnvironmentConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/environment.json",
    "title": "EnvironmentConfig",
    "type": "object",
    "additionalProperties": false,
    "required": [],
    "eventuallyRequired": [
        "image"
    ],
    "properties": {
        "image": {
            "type": [
                "object",
                "string",
                "null"
            ],
            "default": {},
            "optionalRef": "http://determined.ai/schemas/expconf/v0/environment-image.json"
        },
        "environment_variables": {
            "type": [
                "object",
                "array",
                "null"
            ],
            "default": [],
            "optionalRef": "http://determined.ai/schemas/expconf/v0/environment-variables.json"
        },
        "proxy_ports": {
            "type": [
                "array",
                "null"
            ],
            "default": [],
            "optionalRef": "http://determined.ai/schemas/expconf/v0/proxy-ports.json"
        },
        "ports": {
            "type": [
                "object",
                "null"
            ],
            "default": {},
            "additionalProperties": {
                "type": "integer"
            }
        },
        "force_pull_image": {
            "type": [
                "boolean",
                "null"
            ],
            "default": false
        },
        "registry_auth": {
            "type": [
                "object",
                "null"
            ],
            "default": null,
            "optionalRef": "http://determined.ai/schemas/expconf/v0/registry-auth.json"
        },
        "add_capabilities": {
            "type": [
                "array",
                "null"
            ],
            "default": [],
            "items": {
                "type": "string"
            }
        },
        "drop_capabilities": {
            "type": [
                "array",
                "null"
            ],
            "default": [],
            "items": {
                "type": "string"
            }
        },
        "pod_spec": {
            "type": [
                "object",
                "null"
            ],
            "default": null,
            "disallowProperties": {
                "name": "pod Name is not a configurable option",
                "name_space": "pod NameSpace is not a configurable option"
            },
            "properties": {
                "spec": {
                    "type": [
                        "object",
                        "null"
                    ],
                    "default": null,
                    "properties": {
                        "containers": {
                            "type": [
                                "array",
                                "null"
                            ],
                            "default": null,
                            "items": {
                                "$comment": "if container name is 'determined-container', reject most edits to the container spec (which is ours to configure)",
                                "if": {
                                    "properties": {
                                        "name": {
                                            "const": "determined-container"
                                        }
                                    }
                                },
                                "then": {
                                    "type": "object",
                                    "disallowProperties": {
                                        "image": "container Image is not configurable, set it in the experiment config",
                                        "command": "container Command is not configurable",
                                        "args": "container Args are not configurable",
                                        "working_dir": "container WorkingDir is not configurable",
                                        "ports": "container Ports are not configurable",
                                        "liveness_probe": "container LivenessProbe is not configurable",
                                        "readiness_probe": "container ReadinessProbe is not configurable",
                                        "startup_probe": "container StartupProbe is not configurable",
                                        "lifecycle": "container Lifecycle is not configurable",
                                        "termination_message_path": "container TerminationMessagePath is not configurable",
                                        "termination_message_policy": "container TerminationMessagePolicy is not configurable",
                                        "image_pull_policy": "container ImagePullPolicy is not configurable, set it in the experiment config",
                                        "security_context": "container SecurityContext is not configurable, set it in the experiment config"
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
`)
	textExperimentConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/experiment.json",
    "title": "ExperimentConfig",
    "type": "object",
    "additionalProperties": false,
    "eventuallyRequired": [
        "checkpoint_storage",
        "name",
        "hyperparameters",
        "reproducibility",
        "searcher"
    ],
    "properties": {
        "bind_mounts": {
            "type": [
                "array",
                "null"
            ],
            "default": [],
            "optionalRef": "http://determined.ai/schemas/expconf/v0/bind-mounts.json"
        },
        "checkpoint_policy": {
            "enum": [
                null,
                "best",
                "all",
                "none"
            ],
            "default": "best"
        },
        "checkpoint_storage": {
            "type": [
                "object",
                "null"
            ],
            "default": null,
            "optionalRef": "http://determined.ai/schemas/expconf/v0/checkpoint-storage.json"
        },
        "data": {
            "type": [
                "object",
                "null"
            ],
            "default": {}
        },
        "integrations": {
            "type": [
                "object",
                "null"
            ],
            "default": null,
            "optionalRef": "http://determined.ai/schemas/expconf/v0/integrations.json"
        },
        "data_layer": {
            "$comment": "the data_layer feature was removed in 0.19.10, and the config is ignored",
            "type": [
                "object",
                "null"
            ],
            "default": null
        },
        "debug": {
            "type": [
                "boolean",
                "null"
            ],
            "default": false
        },
        "description": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "entrypoint": {
            "type": [
                "string",
                "array",
                "null"
            ],
            "items": {
                "type": "string"
            },
            "default": null
        },
        "environment": {
            "type": [
                "object",
                "null"
            ],
            "default": {},
            "optionalRef": "http://determined.ai/schemas/expconf/v0/environment.json"
        },
        "hyperparameters": {
            "type": [
                "object",
                "null"
            ],
            "default": {},
            "optionalRef": "http://determined.ai/schemas/expconf/v0/hyperparameters.json"
        },
        "internal": {
            "$comment": "allow forking pre-0.15.6 non-Native-API experiments",
            "type": "null",
            "default": null
        },
        "labels": {
            "type": [
                "array",
                "null"
            ],
            "default": [],
            "items": {
                "type": "string"
            }
        },
        "log_policies": {
            "type": [
                "array",
                "null"
            ],
            "$comment": "setting default to [] lets the actual default always comes from WithDefaults()",
            "default": [],
            "optionalRef": "http://determined.ai/schemas/expconf/v0/log-policies.json"
        },
        "retention_policy": {
            "type": [
                "object",
                "null"
            ],
            "default": null,
            "optionalRef": "http://determined.ai/schemas/expconf/v0/retention-policy.json"
        },
        "max_restarts": {
            "type": [
                "integer",
                "null"
            ],
            "minimum": 0,
            "default": 5
        },
        "min_checkpoint_period": {
            "type": [
                "object",
                "null"
            ],
            "default": {
                "batches": 0
            },
            "optionalRef": "http://determined.ai/schemas/expconf/v0/length.json"
        },
        "min_validation_period": {
            "type": [
                "object",
                "null"
            ],
            "default": {
                "batches": 0
            },
            "optionalRef": "http://determined.ai/schemas/expconf/v0/length.json"
        },
        "name": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "optimizations": {
            "type": [
                "object",
                "null"
            ],
            "default": {},
            "optionalRef": "http://determined.ai/schemas/expconf/v0/optimizations.json"
        },
        "pbs": {
            "type": [
                "object",
                "null"
            ],
            "default": {},
            "optionalRef": "http://determined.ai/schemas/expconf/v0/hpc-cluster-pbs.json"
        },
        "perform_initial_validation": {
            "type": [
                "boolean",
                "null"
            ],
            "default": false
        },
        "preemption_timeout": {
            "type": [
                "integer",
                "null"
            ],
            "default": null
        },
        "profiling": {
            "type": [
                "object",
                "null"
            ],
            "default": {},
            "optionalRef": "http://determined.ai/schemas/expconf/v0/profiling.json"
        },
        "project": {
            "type": [
                "string",
                "null"
            ],
            "default": ""
        },
        "records_per_epoch": {
            "type": [
                "integer",
                "null"
            ],
            "default": 0
        },
        "reproducibility": {
            "type": [
                "object",
                "null"
            ],
            "default": {},
            "optionalRef": "http://determined.ai/schemas/expconf/v0/reproducibility.json"
        },
        "resources": {
            "type": [
                "object",
                "null"
            ],
            "default": {},
            "optionalRef": "http://determined.ai/schemas/expconf/v0/resources.json"
        },
        "scheduling_unit": {
            "type": [
                "integer",
                "null"
            ],
            "minimum": 1,
            "default": 100
        },
        "searcher": {
            "type": [
                "object",
                "null"
            ],
            "default": null,
            "optionalRef": "http://determined.ai/schemas/expconf/v0/searcher.json"
        },
        "security": {
            "type": [
                "object",
                "null"
            ],
            "default": null,
            "optionalRef": "http://determined.ai/schemas/expconf/v0/security.json"
        },
        "slurm": {
            "type": [
                "object",
                "null"
            ],
            "default": {},
            "optionalRef": "http://determined.ai/schemas/expconf/v0/hpc-cluster-slurm.json"
        },
        "tensorboard_storage": {
            "type": [
                "object",
                "null"
            ],
            "default": null,
            "optionalRef": "http://determined.ai/schemas/expconf/v0/tensorboard-storage.json"
        },
        "workspace": {
            "type": [
                "string",
                "null"
            ],
            "default": ""
        }
    },
    "allOf": [
        {
            "if": {
                "$comment": "when grid search is in use, expect hp counts",
                "properties": {
                    "searcher": {
                        "properties": {
                            "name": {
                                "const": "grid"
                            }
                        }
                    }
                }
            },
            "then": {
                "properties": {
                    "hyperparameters": {
                        "additionalProperties": {
                            "$ref": "http://determined.ai/schemas/expconf/v0/check-grid-hyperparameter.json"
                        }
                    }
                }
            }
        }
    ]
}
`)
	textGCSConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/gcs.json",
    "title": "GCSConfig",
    "type": "object",
    "additionalProperties": false,
    "required": [
        "type"
    ],
    "eventuallyRequired": [
        "bucket"
    ],
    "properties": {
        "type": {
            "const": "gcs"
        },
        "bucket": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "prefix": {
            "type": [
                "string",
                "null"
            ],
            "checks": {
                "prefix cannot contain /../": {
                    "not": {
                        "anyOf": [
                            {
                                "type": "string",
                                "pattern": "/\\.\\./"
                            },
                            {
                                "type": "string",
                                "pattern": "^\\.\\./"
                            },
                            {
                                "type": "string",
                                "pattern": "/\\.\\.$"
                            },
                            {
                                "type": "string",
                                "pattern": "^\\.\\.$"
                            }
                        ]
                    }
                }
            },
            "default": null
        },
        "save_experiment_best": {
            "type": [
                "integer",
                "null"
            ],
            "default": 0,
            "minimum": 0
        },
        "save_trial_best": {
            "type": [
                "integer",
                "null"
            ],
            "default": 1,
            "minimum": 0
        },
        "save_trial_latest": {
            "type": [
                "integer",
                "null"
            ],
            "default": 1,
            "minimum": 0
        }
    }
}
`)
	textPbsConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/hpc-cluster-pbs.json",
    "title": "PbsConfig",
    "type": "object",
    "additionalProperties": false,
    "required": [],
    "properties": {
        "slots_per_node": {
            "type": [
                "integer",
                "null"
            ],
            "minimum": 1,
            "default": null
        },
        "pbsbatch_args": {
            "type": [
                "array",
                "null"
            ],
            "default": null,
            "items": {
                "type": "string"
            }
        }
    }
}
`)
	textSlurmConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/hpc-cluster-slurm.json",
    "title": "SlurmConfig",
    "type": "object",
    "additionalProperties": false,
    "required": [],
    "properties": {
        "slots_per_node": {
            "type": [
                "integer",
                "null"
            ],
            "minimum": 1,
            "default": null
        },
        "gpu_type": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "sbatch_args": {
            "type": [
                "array",
                "null"
            ],
            "default": null,
            "items": {
                "type": "string"
            }
        }
    }
}
`)
	textCategoricalHyperparameterV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/hyperparameter-categorical.json",
    "title": "CategoricalHyperparameter",
    "type": "object",
    "additionalProperties": false,
    "required": [
        "type",
        "vals"
    ],
    "properties": {
        "type": {
            "const": "categorical"
        },
        "vals": {
            "type": "array",
            "minLength": 1
        }
    }
}
`)
	textConstHyperparameterV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/hyperparameter-const.json",
    "title": "ConstHyperparameter",
    "type": "object",
    "additionalProperties": false,
    "required": [
        "type",
        "val"
    ],
    "properties": {
        "type": {
            "const": "const"
        },
        "val": true
    }
}
`)
	textDoubleHyperparameterV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/hyperparameter-double.json",
    "title": "DoubleHyperparameter",
    "type": "object",
    "additionalProperties": false,
    "required": [
        "type",
        "minval",
        "maxval"
    ],
    "properties": {
        "type": {
            "const": "double"
        },
        "minval": {
            "type": "number"
        },
        "maxval": {
            "type": "number"
        },
        "count": {
            "type": [
                "integer",
                "null"
            ],
            "default": null,
            "minimum": 1
        }
    },
    "compareProperties": {
        "type": "a<b",
        "a": "minval",
        "b": "maxval"
    }
}
`)
	textIntHyperparameterV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/hyperparameter-int.json",
    "title": "IntHyperparameter",
    "type": "object",
    "additionalProperties": false,
    "required": [
        "type",
        "minval",
        "maxval"
    ],
    "properties": {
        "type": {
            "const": "int"
        },
        "minval": {
            "type": "integer"
        },
        "maxval": {
            "type": "integer"
        },
        "count": {
            "type": [
                "integer",
                "null"
            ],
            "default": null,
            "minimum": 1
        }
    },
    "compareProperties": {
        "type": "a<b",
        "a": "minval",
        "b": "maxval"
    }
}
`)
	textLogHyperparameterV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/hyperparameter-log.json",
    "title": "LogHyperparameter",
    "type": "object",
    "additionalProperties": false,
    "required": [
        "type",
        "minval",
        "maxval",
        "base"
    ],
    "properties": {
        "type": {
            "const": "log"
        },
        "minval": {
            "type": "number"
        },
        "maxval": {
            "type": "number"
        },
        "base": {
            "type": "number",
            "exclusiveMinimum": 0
        },
        "count": {
            "type": [
                "integer",
                "null"
            ],
            "default": null,
            "minimum": 1
        }
    },
    "compareProperties": {
        "type": "a<b",
        "a": "minval",
        "b": "maxval"
    }
}
`)
	textHyperparameterV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/hyperparameter.json",
    "title": "Hyperparameter",
    "union": {
        "items": [
            {
                "unionKey": "const:type=int",
                "$ref": "http://determined.ai/schemas/expconf/v0/hyperparameter-int.json"
            },
            {
                "unionKey": "const:type=double",
                "$ref": "http://determined.ai/schemas/expconf/v0/hyperparameter-double.json"
            },
            {
                "unionKey": "const:type=log",
                "$ref": "http://determined.ai/schemas/expconf/v0/hyperparameter-log.json"
            },
            {
                "unionKey": "const:type=const",
                "$ref": "http://determined.ai/schemas/expconf/v0/hyperparameter-const.json"
            },
            {
                "unionKey": "const:type=categorical",
                "$ref": "http://determined.ai/schemas/expconf/v0/hyperparameter-categorical.json"
            },
            {
                "unionKey": "always",
                "type": "object",
                "checks": {
                    "if a hyperparameter object's [\"type\"] is set, it must be one of \"int\", \"double\", \"log\", const\", or \"categorical\"": {
                        "properties": {
                            "type": false
                        }
                    }
                },
                "additionalProperties": {
                    "$ref": "http://determined.ai/schemas/expconf/v0/hyperparameter.json"
                }
            },
            {
                "unionKey": "never",
                "not": {
                    "type": "object"
                }
            }
        ]
    }
}
`)
	textHyperparametersV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/hyperparameters.json",
    "title": "Hyperparameters",
    "type": "object",
    "additionalProperties": {
        "$ref": "http://determined.ai/schemas/expconf/v0/hyperparameter.json"
    }
}
`)
	textIntegrationsConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/integrations.json",
    "title": "IntegrationsConfig",
    "type": "object",
    "additionalProperties": false,
    "properties": {
        "pachyderm": {
            "type": [
                "object",
                "null"
            ],
            "default": null,
            "optionalRef": "http://determined.ai/schemas/expconf/v0/pachyderm.json"
        },
        "webhooks": {
            "type": [
                "object",
                "null"
            ],
            "default": null,
            "optionalRef": "http://determined.ai/schemas/expconf/v0/webhooks.json"
        }
    }
}
`)
	textKerberosConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/kerberos.json",
    "title": "KerberosConfig",
    "$comment": "KerberosConfig has not been used in a very long time",
    "type": "object",
    "additionalProperties": false,
    "required": [
        "config_file"
    ],
    "properties": {
        "config_file": {
            "type": "string"
        }
    }
}
`)
	textLengthV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/length.json",
    "title": "Length",
    "union": {
        "defaultMessage": "a length object must have one attribute named \"batches\", \"records\", or \"epochs\"",
        "items": [
            {
                "unionKey": "singleproperty:batches",
                "type": "object",
                "additionalProperties": false,
                "required": [
                    "batches"
                ],
                "properties": {
                    "batches": {
                        "type": "integer",
                        "minimum": 0
                    }
                }
            },
            {
                "unionKey": "singleproperty:records",
                "type": "object",
                "additionalProperties": false,
                "required": [
                    "records"
                ],
                "properties": {
                    "records": {
                        "type": "integer",
                        "minimum": 0
                    }
                }
            },
            {
                "unionKey": "singleproperty:epochs",
                "type": "object",
                "additionalProperties": false,
                "required": [
                    "epochs"
                ],
                "properties": {
                    "epochs": {
                        "type": "integer",
                        "minimum": 0
                    }
                }
            }
        ]
    }
}
`)
	textLogActionV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/log-action.json",
    "title": "LogAction",
    "union": {
        "defaultMessage": "must be one of \"cancel_retries\" or \"exclude_node\"",
        "items": [
            {
                "unionKey": "never",
                "const": "cancel_retries"
            },
            {
                "unionKey": "never",
                "const": "exclude_node"
            },
            {
                "unionKey": "const:type=cancel_retries",
                "$ref": "http://determined.ai/schemas/expconf/v0/log-legacy-action-cancel-retries.json"
            },
            {
                "unionKey": "const:type=exclude_node",
                "$ref": "http://determined.ai/schemas/expconf/v0/log-legacy-action-exclude-node.json"
            }
        ]
    }
}
`)
	textLogLegacyActionCancelRetriesV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/log-legacy-action-cancel-retries.json",
    "title": "LogLegacyActionCancelRetries",
    "additionalProperties": false,
    "type": "object",
    "required": [
        "type"
    ],
    "eventuallyRequired": [],
    "properties": {
        "type": {
            "const": "cancel_retries"
        }
    }
}
`)
	textLogLegacyActionExcludeNodeV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/log-legacy-action-exclude-node.json",
    "title": "LogLegacyActionExcludeNode",
    "additionalProperties": false,
    "type": "object",
    "required": [
        "type"
    ],
    "eventuallyRequired": [],
    "properties": {
        "type": {
            "const": "exclude_node"
        }
    }
}
`)
	textLogPoliciesConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/log-policies.json",
    "title": "LogPoliciesConfig",
    "type": "array",
    "items": {
        "$ref": "http://determined.ai/schemas/expconf/v0/log-policy.json"
    }
}
`)
	textLogPolicyV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/log-policy.json",
    "title": "LogPolicy",
    "additionalProperties": false,
    "type": "object",
    "properties": {
        "name": {
            "type": [
                "string",
                "null"
            ],
            "$comment": "Legacy log policy doesn't have a name. Legacy log policy will be deprecated.",
            "default": null
        },
        "pattern": {
            "type": [
                "string",
                "null"
            ],
            "$comment": "Pattern can be null. So user can override it to disable the default log polices.",
            "default": null
        },
        "action": {
            "type": [
                "string",
                "object",
                "null"
            ],
            "optionalRef": "http://determined.ai/schemas/expconf/v0/log-action.json",
            "default": null
        }
    },
    "checks": {
        "\"name\" must be set, and \"pattern\" is also required unless you intend to disable an existing policy": {
            "anyOf": [
                {
                    "required": [
                        "name"
                    ],
                    "$comment": "modern policy requirement"
                },
                {
                    "required": [
                        "pattern",
                        "action"
                    ],
                    "$comment": "legacy policy requirements"
                }
            ]
        }
    }
}
`)
	textOptimizationsConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/optimizations.json",
    "title": "OptimizationsConfig",
    "type": "object",
    "additionalProperties": false,
    "required": [],
    "properties": {
        "aggregation_frequency": {
            "type": [
                "integer",
                "null"
            ],
            "minimum": 1,
            "default": 1
        },
        "auto_tune_tensor_fusion": {
            "type": [
                "boolean",
                "null"
            ],
            "default": false
        },
        "average_aggregated_gradients": {
            "type": [
                "boolean",
                "null"
            ],
            "default": true
        },
        "average_training_metrics": {
            "type": [
                "boolean",
                "null"
            ],
            "default": true
        },
        "gradient_compression": {
            "type": [
                "boolean",
                "null"
            ],
            "default": false
        },
        "grad_updates_size_file": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "mixed_precision": {
            "enum": [
                null,
                "O0",
                "O1",
                "O2",
                "O3"
            ],
            "default": "O0",
            "checks": {
                "mixed_precision should be a string starting with an uppercase letter 'O'": {
                    "pattern": "^O"
                }
            }
        },
        "tensor_fusion_cycle_time": {
            "type": [
                "integer",
                "null"
            ],
            "minimum": 0,
            "default": 1
        },
        "tensor_fusion_threshold": {
            "type": [
                "integer",
                "null"
            ],
            "minimum": 0,
            "default": 64
        }
    }
}
`)
	textPachydermDatasetConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/pachyderm-dataset.json",
    "title": "PachydermDatasetConfig",
    "type": "object",
    "additionalProperties": false,
    "required": [
        "project",
        "repo",
        "commit",
        "branch",
        "token"
    ],
    "properties": {
        "project": {
            "type": [
                "string"
            ]
        },
        "repo": {
            "type": [
                "string"
            ]
        },
        "commit": {
            "type": [
                "string"
            ]
        },
        "branch": {
            "type": [
                "string"
            ]
        },
        "token": {
            "type": [
                "string"
            ]
        }
    }
}
`)
	textPachydermPachdConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/pachyderm-pachd.json",
    "title": "PachydermPachdConfig",
    "type": "object",
    "additionalProperties": false,
    "required": [
        "host",
        "port"
    ],
    "properties": {
        "host": {
            "type": [
                "string"
            ]
        },
        "port": {
            "type": [
                "integer"
            ]
        }
    }
}
`)
	textPachydermProxyConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/pachyderm-proxy.json",
    "title": "PachydermProxyConfig",
    "type": "object",
    "additionalProperties": false,
    "required": [
        "scheme",
        "host",
        "port"
    ],
    "properties": {
        "scheme": {
            "type": [
                "string"
            ]
        },
        "host": {
            "type": [
                "string"
            ]
        },
        "port": {
            "type": [
                "integer"
            ]
        }
    }
}
`)
	textPachydermConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/pachyderm.json",
    "title": "PachydermConfig",
    "type": "object",
    "additionalProperties": false,
    "required": [
        "pachd",
        "proxy",
        "dataset"
    ],
    "eventuallyRequired": [],
    "properties": {
        "pachd": {
            "type": [
                "object"
            ],
            "$ref": "http://determined.ai/schemas/expconf/v0/pachyderm-pachd.json"
        },
        "proxy": {
            "type": [
                "object"
            ],
            "$ref": "http://determined.ai/schemas/expconf/v0/pachyderm-proxy.json"
        },
        "dataset": {
            "type": [
                "object"
            ],
            "$ref": "http://determined.ai/schemas/expconf/v0/pachyderm-dataset.json"
        }
    }
}
`)
	textProfilingConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/profiling.json",
    "title": "ProfilingConfig",
    "type": "object",
    "additionalProperties": false,
    "required": [],
    "properties": {
        "enabled": {
            "type": [
                "boolean",
                "null"
            ],
            "default": false
        },
        "begin_on_batch": {
            "type": [
                "integer",
                "null"
            ],
            "default": 0,
            "minimum": 0
        },
        "end_after_batch": {
            "type": [
                "integer",
                "null"
            ],
            "default": null,
            "minimum": 0
        },
        "sync_timings": {
            "type": [
                "boolean",
                "null"
            ],
            "default": true
        }
    },
    "compareProperties": {
        "type": "a<=b",
        "a": "begin_on_batch",
        "b": "end_after_batch"
    }
}
`)
	textProxyPortV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/proxy-port.json",
    "title": "ProxyPort",
    "additionalProperties": false,
    "required": [
        "proxy_port"
    ],
    "type": "object",
    "properties": {
        "proxy_port": {
            "type": "number"
        },
        "proxy_tcp": {
            "type": [
                "boolean",
                "null"
            ],
            "default": false
        },
        "unauthenticated": {
            "type": [
                "boolean",
                "null"
            ],
            "default": false
        },
        "default_service_id": {
            "type": [
                "boolean",
                "null"
            ],
            "default": false
        }
    }
}
`)
	textProxyPortsConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/proxy-ports.json",
    "title": "ProxyPortsConfig",
    "type": "array",
    "items": {
        "$ref": "http://determined.ai/schemas/expconf/v0/proxy-port.json"
    }
}
`)
	textRegistryAuthV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/registry-auth.json",
    "title": "RegistryAuth",
    "type": "object",
    "additionalProperties": false,
    "required": [],
    "properties": {
        "username": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "password": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "auth": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "email": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "serveraddress": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "identitytoken": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "registrytoken": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        }
    }
}
`)
	textReproducibilityConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/reproducibility.json",
    "title": "ReproducibilityConfig",
    "type": "object",
    "additionalProperties": false,
    "eventuallyRequired": [
        "experiment_seed"
    ],
    "properties": {
        "experiment_seed": {
            "type": [
                "integer",
                "null"
            ],
            "default": null,
            "minimum": 0
        }
    }
}
`)
	textResourcesConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/resources.json",
    "title": "ResourcesConfig",
    "type": "object",
    "additionalProperties": false,
    "required": [],
    "properties": {
        "agent_label": {
            "$comment": "the agent_label feature was removed in 0.20.0, and the config is ignored",
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "devices": {
            "type": [
                "array",
                "null"
            ],
            "default": [],
            "optionalRef": "http://determined.ai/schemas/expconf/v0/devices.json"
        },
        "is_single_node": {
            "type": [
                "boolean",
                "null"
            ],
            "default": null
        },
        "max_slots": {
            "type": [
                "integer",
                "null"
            ],
            "default": null
        },
        "native_parallel": {
            "type": [
                "boolean",
                "null"
            ],
            "default": false
        },
        "priority": {
            "type": [
                "integer",
                "null"
            ],
            "minimum": 1,
            "maximum": 99,
            "default": null
        },
        "resource_pool": {
            "type": [
                "string",
                "null"
            ],
            "default": ""
        },
        "shm_size": {
            "type": [
                "integer",
                "string",
                "null"
            ],
            "checks": {
                "must be a valid memory size": {
                    "pattern": "^([0-9]*[.])?[0-9]+ ?(([kmgtpKMGTP]([iI]?[bB])?)|[bB])?$"
                }
            },
            "default": null
        },
        "slots": {
            "type": [
                "integer",
                "null"
            ],
            "default": null
        },
        "slots_per_trial": {
            "type": [
                "integer",
                "null"
            ],
            "minimum": 0,
            "default": 1
        },
        "weight": {
            "type": [
                "number",
                "null"
            ],
            "default": 1
        }
    }
}
`)
	textRetentionPolicyConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/retention-policy.json",
    "title": "RetentionPolicyConfig",
    "type": "object",
    "additionalProperties": false,
    "eventuallyRequired": [
        "log_retention_days"
    ],
    "properties": {
        "log_retention_days": {
            "type": [
                "integer",
                "null"
            ],
            "minimum": -1,
            "maximum": 32767,
            "default": null
        }
    }
}
`)
	textS3ConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/s3.json",
    "title": "S3Config",
    "type": "object",
    "additionalProperties": false,
    "required": [
        "type"
    ],
    "eventuallyRequired": [
        "bucket"
    ],
    "properties": {
        "type": {
            "const": "s3"
        },
        "access_key": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "bucket": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "secret_key": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "endpoint_url": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "prefix": {
            "type": [
                "string",
                "null"
            ],
            "checks": {
                "prefix cannot contain /../": {
                    "not": {
                        "anyOf": [
                            {
                                "type": "string",
                                "pattern": "/\\.\\./"
                            },
                            {
                                "type": "string",
                                "pattern": "^\\.\\./"
                            },
                            {
                                "type": "string",
                                "pattern": "/\\.\\.$"
                            },
                            {
                                "type": "string",
                                "pattern": "^\\.\\.$"
                            }
                        ]
                    }
                }
            },
            "default": null
        },
        "save_experiment_best": {
            "type": [
                "integer",
                "null"
            ],
            "default": 0,
            "minimum": 0
        },
        "save_trial_best": {
            "type": [
                "integer",
                "null"
            ],
            "default": 1,
            "minimum": 0
        },
        "save_trial_latest": {
            "type": [
                "integer",
                "null"
            ],
            "default": 1,
            "minimum": 0
        }
    }
}
`)
	textAdaptiveASHAConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/searcher-adaptive-asha.json",
    "title": "AdaptiveASHAConfig",
    "type": "object",
    "additionalProperties": false,
    "required": [
        "name"
    ],
    "eventuallyRequired": [
        "max_trials",
        "metric"
    ],
    "properties": {
        "name": {
            "const": "adaptive_asha"
        },
        "bracket_rungs": {
            "type": [
                "array",
                "null"
            ],
            "default": [],
            "items": {
                "type": "integer"
            }
        },
        "max_trials": {
            "type": [
                "integer",
                "null"
            ],
            "default": null,
            "minimum": 1
        },
        "time_metric": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "max_time": {
            "type": [
                "integer",
                "null"
            ],
            "default": null
        },
        "mode": {
            "enum": [
                null,
                "aggressive",
                "standard",
                "conservative"
            ],
            "default": "standard"
        },
        "divisor": {
            "type": [
                "number",
                "null"
            ],
            "exclusiveMinimum": 1,
            "default": 4
        },
        "max_rungs": {
            "type": [
                "integer",
                "null"
            ],
            "minimum": 1,
            "default": 5
        },
        "max_concurrent_trials": {
            "type": [
                "integer",
                "null"
            ],
            "minimum": 0,
            "default": 16
        },
        "max_length": {
            "type": [
                "object",
                "integer",
                "null"
            ],
            "default": null,
            "optionalRef": "http://determined.ai/schemas/expconf/v0/searcher-length.json"
        },
        "stop_once": {
            "type": [
                "boolean",
                "null"
            ],
            "default": null
        },
        "metric": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "smaller_is_better": {
            "type": [
                "boolean",
                "null"
            ],
            "default": true
        },
        "source_trial_id": {
            "type": [
                "integer",
                "null"
            ],
            "default": null
        },
        "source_checkpoint_uuid": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        }
    }
}
`)
	textAdaptiveSimpleConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$comment": "this is an EOL searcher, not to be used in new experiments",
    "$id": "http://determined.ai/schemas/expconf/v0/searcher-adaptive-simple.json",
    "title": "AdaptiveSimpleConfig",
    "type": "object",
    "additionalProperties": false,
    "required": [
        "name"
    ],
    "eventuallyRequired": [
        "max_trials",
        "metric"
    ],
    "properties": {
        "name": {
            "const": "adaptive_simple"
        },
        "max_trials": {
            "type": [
                "integer",
                "null"
            ],
            "default": null,
            "minimum": 1,
            "maximum": 2000
        },
        "mode": {
            "enum": [
                null,
                "aggressive",
                "standard",
                "conservative"
            ],
            "default": "standard"
        },
        "divisor": {
            "type": [
                "number",
                "null"
            ],
            "exclusiveMinimum": 1,
            "default": 4
        },
        "max_rungs": {
            "type": [
                "integer",
                "null"
            ],
            "minimum": 1,
            "default": 5
        },
        "max_length": {
            "type": [
                "object",
                "null"
            ],
            "default": null,
            "optionalRef": "http://determined.ai/schemas/expconf/v0/check-positive-length.json"
        },
        "metric": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "smaller_is_better": {
            "type": [
                "boolean",
                "null"
            ],
            "default": true
        },
        "source_trial_id": {
            "type": [
                "integer",
                "null"
            ],
            "default": null
        },
        "source_checkpoint_uuid": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        }
    }
}
`)
	textAdaptiveConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$comment": "this is an EOL searcher, not to be used in new experiments",
    "$id": "http://determined.ai/schemas/expconf/v0/searcher-adaptive.json",
    "title": "AdaptiveConfig",
    "type": "object",
    "additionalProperties": false,
    "required": [
        "name"
    ],
    "eventuallyRequired": [
        "budget",
        "metric"
    ],
    "properties": {
        "name": {
            "const": "adaptive"
        },
        "budget": {
            "type": [
                "object",
                "null"
            ],
            "default": null,
            "optionalRef": "http://determined.ai/schemas/expconf/v0/length.json"
        },
        "bracket_rungs": {
            "type": [
                "array",
                "null"
            ],
            "default": [],
            "items": {
                "type": "integer"
            }
        },
        "mode": {
            "enum": [
                null,
                "aggressive",
                "standard",
                "conservative"
            ],
            "default": "standard"
        },
        "divisor": {
            "type": [
                "number",
                "null"
            ],
            "exclusiveMinimum": 1,
            "default": 4
        },
        "max_rungs": {
            "type": [
                "integer",
                "null"
            ],
            "minimum": 1,
            "default": 5
        },
        "max_length": {
            "type": [
                "object",
                "null"
            ],
            "default": null,
            "optionalRef": "http://determined.ai/schemas/expconf/v0/check-positive-length.json"
        },
        "train_stragglers": {
            "type": [
                "boolean",
                "null"
            ],
            "default": true
        },
        "metric": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "smaller_is_better": {
            "type": [
                "boolean",
                "null"
            ],
            "default": true
        },
        "source_trial_id": {
            "type": [
                "integer",
                "null"
            ],
            "default": null
        },
        "source_checkpoint_uuid": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        }
    }
}
`)
	textAsyncHalvingConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/searcher-async-halving.json",
    "title": "AsyncHalvingConfig",
    "type": "object",
    "additionalProperties": false,
    "required": [
        "name"
    ],
    "eventuallyRequired": [
        "num_rungs",
        "max_trials",
        "metric"
    ],
    "properties": {
        "name": {
            "const": "async_halving"
        },
        "num_rungs": {
            "type": [
                "integer",
                "null"
            ],
            "default": null,
            "minimum": 1
        },
        "max_length": {
            "type": [
                "object",
                "null"
            ],
            "default": null,
            "optionalRef": "http://determined.ai/schemas/expconf/v0/check-positive-length.json"
        },
        "max_trials": {
            "type": [
                "integer",
                "null"
            ],
            "default": null,
            "minimum": 1
        },
        "divisor": {
            "type": [
                "number",
                "null"
            ],
            "exclusiveMinimum": 1,
            "default": 4
        },
        "max_concurrent_trials": {
            "type": [
                "integer",
                "null"
            ],
            "minimum": 0,
            "default": 16
        },
        "stop_once": {
            "type": [
                "boolean",
                "null"
            ],
            "default": null
        },
        "metric": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "time_metric": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "max_time": {
            "type": [
                "integer",
                "null"
            ],
            "default": null
        },
        "smaller_is_better": {
            "type": [
                "boolean",
                "null"
            ],
            "default": true
        },
        "source_trial_id": {
            "type": [
                "integer",
                "null"
            ],
            "default": null
        },
        "source_checkpoint_uuid": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        }
    }
}
`)
	textCustomConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$comment": "this is an EOL searcher, not to be used in new experiments",
    "$id": "http://determined.ai/schemas/expconf/v0/searcher-custom.json",
    "title": "CustomConfig",
    "type": "object",
    "additionalProperties": true,
    "required": [
        "name"
    ],
    "eventuallyRequired": [
        "metric"
    ],
    "properties": {
        "name": {
            "const": "custom"
        },
        "metric": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "smaller_is_better": {
            "type": [
                "boolean",
                "null"
            ],
            "default": true
        },
        "unit": {
            "enum": [
                "batches",
                "records",
                "epochs",
                null
            ],
            "default": null
        }
    }
}
`)
	textGridConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/searcher-grid.json",
    "title": "GridConfig",
    "type": "object",
    "additionalProperties": false,
    "required": [
        "name"
    ],
    "eventuallyRequired": [
        "metric"
    ],
    "properties": {
        "name": {
            "const": "grid"
        },
        "max_concurrent_trials": {
            "type": [
                "integer",
                "null"
            ],
            "minimum": 0,
            "default": 16
        },
        "max_length": {
            "type": [
                "object",
                "integer",
                "null"
            ],
            "default": null,
            "optionalRef": "http://determined.ai/schemas/expconf/v0/searcher-length.json"
        },
        "metric": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "smaller_is_better": {
            "type": [
                "boolean",
                "null"
            ],
            "default": true
        },
        "source_trial_id": {
            "type": [
                "integer",
                "null"
            ],
            "default": null
        },
        "source_checkpoint_uuid": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        }
    }
}
`)
	textSearcherLengthV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/searcher-length.json",
    "title": "SearcherLength",
    "$comment": "SearcherLength is either a positive Length or a positive integer",
    "union": {
        "items": [
            {
                "unionKey": "not:type:object",
                "type": "integer",
                "minimum": 0
            },
            {
                "unionKey": "always",
                "$ref": "http://determined.ai/schemas/expconf/v0/check-positive-length.json"
            }
        ]
    }
}
`)
	textRandomConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/searcher-random.json",
    "title": "RandomConfig",
    "type": "object",
    "additionalProperties": false,
    "required": [
        "name"
    ],
    "eventuallyRequired": [
        "max_trials",
        "metric"
    ],
    "properties": {
        "name": {
            "const": "random"
        },
        "max_concurrent_trials": {
            "type": [
                "integer",
                "null"
            ],
            "minimum": 0,
            "default": 16
        },
        "max_trials": {
            "type": [
                "integer",
                "null"
            ],
            "default": null,
            "minimum": 1
        },
        "max_length": {
            "type": [
                "object",
                "integer",
                "null"
            ],
            "default": null,
            "optionalRef": "http://determined.ai/schemas/expconf/v0/searcher-length.json"
        },
        "metric": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "smaller_is_better": {
            "type": [
                "boolean",
                "null"
            ],
            "default": true
        },
        "source_trial_id": {
            "type": [
                "integer",
                "null"
            ],
            "default": null
        },
        "source_checkpoint_uuid": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        }
    }
}
`)
	textSingleConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/searcher-single.json",
    "title": "SingleConfig",
    "type": "object",
    "additionalProperties": false,
    "required": [
        "name"
    ],
    "eventuallyRequired": [
        "metric"
    ],
    "properties": {
        "name": {
            "const": "single"
        },
        "max_length": {
            "type": [
                "object",
                "integer",
                "null"
            ],
            "default": null,
            "optionalRef": "http://determined.ai/schemas/expconf/v0/searcher-length.json"
        },
        "metric": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "smaller_is_better": {
            "type": [
                "boolean",
                "null"
            ],
            "default": true
        },
        "source_trial_id": {
            "type": [
                "integer",
                "null"
            ],
            "default": null
        },
        "source_checkpoint_uuid": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        }
    }
}
`)
	textSyncHalvingConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$comment": "this is an EOL searcher, not to be used in new experiments",
    "$id": "http://determined.ai/schemas/expconf/v0/searcher-sync-halving.json",
    "title": "SyncHalvingConfig",
    "type": "object",
    "additionalProperties": false,
    "required": [
        "name"
    ],
    "eventuallyRequired": [
        "num_rungs",
        "budget",
        "metric"
    ],
    "properties": {
        "name": {
            "const": "sync_halving"
        },
        "budget": {
            "type": [
                "object",
                "null"
            ],
            "default": null,
            "optionalRef": "http://determined.ai/schemas/expconf/v0/check-positive-length.json"
        },
        "num_rungs": {
            "type": [
                "integer",
                "null"
            ],
            "default": null,
            "minimum": 1
        },
        "max_length": {
            "type": [
                "object",
                "null"
            ],
            "default": null,
            "optionalRef": "http://determined.ai/schemas/expconf/v0/check-positive-length.json"
        },
        "divisor": {
            "type": [
                "number",
                "null"
            ],
            "exclusiveMinimum": 1,
            "default": 4
        },
        "train_stragglers": {
            "type": [
                "boolean",
                "null"
            ],
            "default": true
        },
        "metric": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "smaller_is_better": {
            "type": [
                "boolean",
                "null"
            ],
            "default": true
        },
        "source_trial_id": {
            "type": [
                "integer",
                "null"
            ],
            "default": null
        },
        "source_checkpoint_uuid": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        }
    }
}
`)
	textSearcherConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/searcher.json",
    "title": "SearcherConfig",
    "$comment": "this is a union of all possible properties, with validation for the common properties",
    "if": {
        "required": [
            "name"
        ]
    },
    "then": {
        "union": {
            "defaultMessage": "is not an object where object[\"name\"] is one of 'single', 'random', 'grid', 'custom', or 'adaptive_asha'",
            "items": [
                {
                    "unionKey": "const:name=single",
                    "$ref": "http://determined.ai/schemas/expconf/v0/searcher-single.json"
                },
                {
                    "unionKey": "const:name=random",
                    "$ref": "http://determined.ai/schemas/expconf/v0/searcher-random.json"
                },
                {
                    "unionKey": "const:name=grid",
                    "$ref": "http://determined.ai/schemas/expconf/v0/searcher-grid.json"
                },
                {
                    "unionKey": "const:name=adaptive_asha",
                    "$ref": "http://determined.ai/schemas/expconf/v0/searcher-adaptive-asha.json"
                },
                {
                    "unionKey": "const:name=async_halving",
                    "$ref": "http://determined.ai/schemas/expconf/v0/searcher-async-halving.json"
                },
                {
                    "$comment": "this is an EOL searcher, not to be used in new experiments",
                    "unionKey": "const:name=custom",
                    "$ref": "http://determined.ai/schemas/expconf/v0/searcher-custom.json"
                },
                {
                    "$comment": "this is an EOL searcher, not to be used in new experiments",
                    "unionKey": "const:name=adaptive",
                    "$ref": "http://determined.ai/schemas/expconf/v0/searcher-adaptive.json"
                },
                {
                    "$comment": "this is an EOL searcher, not to be used in new experiments",
                    "unionKey": "const:name=adaptive_simple",
                    "$ref": "http://determined.ai/schemas/expconf/v0/searcher-adaptive-simple.json"
                },
                {
                    "$comment": "this is an EOL searcher, not to be used in new experiments",
                    "unionKey": "const:name=sync_halving",
                    "$ref": "http://determined.ai/schemas/expconf/v0/searcher-sync-halving.json"
                }
            ]
        }
    },
    "additionalProperties": false,
    "eventuallyRequired": [
        "name",
        "metric"
    ],
    "properties": {
        "bracket_rungs": true,
        "divisor": true,
        "max_concurrent_trials": true,
        "max_length": true,
        "max_rungs": true,
        "max_time": true,
        "time_metric": true,
        "max_trials": true,
        "mode": true,
        "name": true,
        "num_rungs": true,
        "stop_once": true,
        "metric": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "smaller_is_better": {
            "type": [
                "boolean",
                "null"
            ],
            "default": true
        },
        "source_trial_id": {
            "type": [
                "integer",
                "null"
            ],
            "default": null
        },
        "source_checkpoint_uuid": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "budget": true,
        "train_stragglers": true,
        "unit": true
    }
}
`)
	textSecurityConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/security.json",
    "title": "SecurityConfig",
    "$comment": "SecurityConfig has not been used in a very long time",
    "type": "object",
    "additionalProperties": false,
    "properties": {
        "kerberos": {
            "type": [
                "object",
                "null"
            ],
            "default": null,
            "optionalRef": "http://determined.ai/schemas/expconf/v0/kerberos.json"
        }
    }
}
`)
	textSharedFSConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/shared-fs.json",
    "title": "SharedFSConfig",
    "type": "object",
    "additionalProperties": false,
    "required": [
        "type"
    ],
    "eventuallyRequired": [
        "host_path"
    ],
    "properties": {
        "type": {
            "const": "shared_fs"
        },
        "host_path": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "storage_path": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "propagation": {
            "type": [
                "string",
                "null"
            ],
            "default": "rprivate"
        },
        "container_path": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "checkpoint_path": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "tensorboard_path": {
            "type": [
                "string",
                "null"
            ],
            "default": null
        },
        "save_experiment_best": {
            "type": [
                "integer",
                "null"
            ],
            "default": 0,
            "minimum": 0
        },
        "save_trial_best": {
            "type": [
                "integer",
                "null"
            ],
            "default": 1,
            "minimum": 0
        },
        "save_trial_latest": {
            "type": [
                "integer",
                "null"
            ],
            "default": 1,
            "minimum": 0
        }
    },
    "checks": {
        "storage_path must either be a relative directory or a subdirectory of host_path": {
            "compareProperties": {
                "type": "a_is_subdir_of_b",
                "a": "storage_path",
                "b": "host_path"
            }
        }
    }
}
`)
	textTensorboardStorageConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/tensorboard-storage.json",
    "title": "TensorboardStorageConfig",
    "$comment": "TensorboardStorageConfig has not been used in a very long time",
    "union": {
        "defaultMessage": "this field is deprecated and will be ignored",
        "items": [
            {
                "unionKey": "never",
                "$ref": "http://determined.ai/schemas/expconf/v0/shared-fs.json"
            },
            {
                "unionKey": "never",
                "$ref": "http://determined.ai/schemas/expconf/v0/s3.json"
            },
            {
                "unionKey": "never",
                "$ref": "http://determined.ai/schemas/expconf/v0/gcs.json"
            }
        ]
    },
    "disallowProperties": {
        "save_experiment_best": "this field is deprecated and will be ignored",
        "save_trial_best": "this field is deprecated and will be ignored",
        "save_trial_latest": "this field is deprecated and will be ignored"
    }
}
`)
	textTestRootV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/test-root.json",
    "title": "TestRoot",
    "type": "object",
    "additionalProperties": false,
    "required": [
        "val_x"
    ],
    "properties": {
        "val_x": {
            "type": "integer"
        },
        "sub_obj": {
            "type": [
                "object",
                "null"
            ],
            "default": {},
            "optionalRef": "http://determined.ai/schemas/expconf/v0/test-sub.json"
        },
        "sub_union": {
            "type": [
                "object",
                "null"
            ],
            "default": null,
            "optionalRef": "http://determined.ai/schemas/expconf/v0/test-union.json"
        },
        "runtime_defaultable": {
            "type": [
                "integer",
                "null"
            ],
            "default": null
        },
        "defaulted_array": {
            "type": [
                "array",
                "null"
            ],
            "default": [],
            "items": {
                "type": "string"
            }
        },
        "nodefault_array": {
            "type": [
                "array",
                "null"
            ],
            "default": null,
            "items": {
                "type": "string"
            }
        }
    }
}
`)
	textTestSubV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/test-sub.json",
    "title": "TestSub",
    "type": "object",
    "additionalProperties": false,
    "required": [],
    "properties": {
        "val_y": {
            "type": [
                "string",
                "null"
            ],
            "default": "default_y"
        }
    }
}
`)
	textTestUnionAV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/test-union-a.json",
    "title": "TestUnionA",
    "type": "object",
    "additionalProperties": false,
    "required": [
        "type",
        "val_a"
    ],
    "properties": {
        "type": {
            "const": "a"
        },
        "val_a": {
            "type": "integer"
        },
        "common_val": {
            "type": [
                "string",
                "null"
            ],
            "default": "default-common-val"
        }
    }
}
`)
	textTestUnionBV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/test-union-b.json",
    "title": "TestUnionB",
    "type": "object",
    "additionalProperties": false,
    "required": [
        "type",
        "val_b"
    ],
    "properties": {
        "type": {
            "const": "b"
        },
        "val_b": {
            "type": "integer"
        },
        "common_val": {
            "type": [
                "string",
                "null"
            ],
            "default": "default-common-val"
        }
    }
}
`)
	textTestUnionV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/test-union.json",
    "title": "TestUnion",
    "union": {
        "defaultMessage": "bad test union",
        "items": [
            {
                "unionKey": "const:type=a",
                "$ref": "http://determined.ai/schemas/expconf/v0/test-union-a.json"
            },
            {
                "unionKey": "const:type=b",
                "$ref": "http://determined.ai/schemas/expconf/v0/test-union-b.json"
            }
        ]
    }
}
`)
	textWebhooksConfigV0 = []byte(`{
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://determined.ai/schemas/expconf/v0/webhooks.json",
    "title": "WebhooksConfig",
    "type": "object",
    "additionalProperties": false,
    "eventuallyRequired": [],
    "properties": {
        "webhook_id": {
            "type": [
                "array",
                "null"
            ],
            "default": null,
            "items": {
                "type": "integer"
            }
        },
        "webhook_name": {
            "type": [
                "array",
                "null"
            ],
            "default": null,
            "items": {
                "type": "string"
            }
        },
        "exclude": {
            "type": [
                "boolean",
                "null"
            ],
            "default": false
        }
    }
}
`)
	schemaAzureConfigV0 interface{}

	schemaBindMountV0 interface{}

	schemaBindMountsConfigV0 interface{}

	schemaCheckGridHyperparameterV0 interface{}

	schemaCheckPositiveLengthV0 interface{}

	schemaCheckpointStorageConfigV0 interface{}

	schemaDeviceV0 interface{}

	schemaDevicesConfigV0 interface{}

	schemaDirectoryConfigV0 interface{}

	schemaEnvironmentImageMapV0 interface{}

	schemaEnvironmentImageV0 interface{}

	schemaEnvironmentVariablesMapV0 interface{}

	schemaEnvironmentVariablesV0 interface{}

	schemaEnvironmentConfigV0 interface{}

	schemaExperimentConfigV0 interface{}

	schemaGCSConfigV0 interface{}

	schemaPbsConfigV0 interface{}

	schemaSlurmConfigV0 interface{}

	schemaCategoricalHyperparameterV0 interface{}

	schemaConstHyperparameterV0 interface{}

	schemaDoubleHyperparameterV0 interface{}

	schemaIntHyperparameterV0 interface{}

	schemaLogHyperparameterV0 interface{}

	schemaHyperparameterV0 interface{}

	schemaHyperparametersV0 interface{}

	schemaIntegrationsConfigV0 interface{}

	schemaKerberosConfigV0 interface{}

	schemaLengthV0 interface{}

	schemaLogActionV0 interface{}

	schemaLogLegacyActionCancelRetriesV0 interface{}

	schemaLogLegacyActionExcludeNodeV0 interface{}

	schemaLogPoliciesConfigV0 interface{}

	schemaLogPolicyV0 interface{}

	schemaOptimizationsConfigV0 interface{}

	schemaPachydermDatasetConfigV0 interface{}

	schemaPachydermPachdConfigV0 interface{}

	schemaPachydermProxyConfigV0 interface{}

	schemaPachydermConfigV0 interface{}

	schemaProfilingConfigV0 interface{}

	schemaProxyPortV0 interface{}

	schemaProxyPortsConfigV0 interface{}

	schemaRegistryAuthV0 interface{}

	schemaReproducibilityConfigV0 interface{}

	schemaResourcesConfigV0 interface{}

	schemaRetentionPolicyConfigV0 interface{}

	schemaS3ConfigV0 interface{}

	schemaAdaptiveASHAConfigV0 interface{}

	schemaAdaptiveSimpleConfigV0 interface{}

	schemaAdaptiveConfigV0 interface{}

	schemaAsyncHalvingConfigV0 interface{}

	schemaCustomConfigV0 interface{}

	schemaGridConfigV0 interface{}

	schemaSearcherLengthV0 interface{}

	schemaRandomConfigV0 interface{}

	schemaSingleConfigV0 interface{}

	schemaSyncHalvingConfigV0 interface{}

	schemaSearcherConfigV0 interface{}

	schemaSecurityConfigV0 interface{}

	schemaSharedFSConfigV0 interface{}

	schemaTensorboardStorageConfigV0 interface{}

	schemaTestRootV0 interface{}

	schemaTestSubV0 interface{}

	schemaTestUnionAV0 interface{}

	schemaTestUnionBV0 interface{}

	schemaTestUnionV0 interface{}

	schemaWebhooksConfigV0 interface{}

	cacheLock sync.RWMutex

	cachedSchemaMap map[string]interface{}

	cachedSchemaBytesMap map[string][]byte
)

func ParsedAzureConfigV0() interface{} {
	cacheLock.RLock()
	if schemaAzureConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaAzureConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaAzureConfigV0 != nil {
		return schemaAzureConfigV0
	}
	err := json.Unmarshal(textAzureConfigV0, &schemaAzureConfigV0)
	if err != nil {
		panic("invalid embedded json for AzureConfigV0")
	}
	return schemaAzureConfigV0
}

func ParsedBindMountV0() interface{} {
	cacheLock.RLock()
	if schemaBindMountV0 != nil {
		cacheLock.RUnlock()
		return schemaBindMountV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaBindMountV0 != nil {
		return schemaBindMountV0
	}
	err := json.Unmarshal(textBindMountV0, &schemaBindMountV0)
	if err != nil {
		panic("invalid embedded json for BindMountV0")
	}
	return schemaBindMountV0
}

func ParsedBindMountsConfigV0() interface{} {
	cacheLock.RLock()
	if schemaBindMountsConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaBindMountsConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaBindMountsConfigV0 != nil {
		return schemaBindMountsConfigV0
	}
	err := json.Unmarshal(textBindMountsConfigV0, &schemaBindMountsConfigV0)
	if err != nil {
		panic("invalid embedded json for BindMountsConfigV0")
	}
	return schemaBindMountsConfigV0
}

func ParsedCheckGridHyperparameterV0() interface{} {
	cacheLock.RLock()
	if schemaCheckGridHyperparameterV0 != nil {
		cacheLock.RUnlock()
		return schemaCheckGridHyperparameterV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaCheckGridHyperparameterV0 != nil {
		return schemaCheckGridHyperparameterV0
	}
	err := json.Unmarshal(textCheckGridHyperparameterV0, &schemaCheckGridHyperparameterV0)
	if err != nil {
		panic("invalid embedded json for CheckGridHyperparameterV0")
	}
	return schemaCheckGridHyperparameterV0
}

func ParsedCheckPositiveLengthV0() interface{} {
	cacheLock.RLock()
	if schemaCheckPositiveLengthV0 != nil {
		cacheLock.RUnlock()
		return schemaCheckPositiveLengthV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaCheckPositiveLengthV0 != nil {
		return schemaCheckPositiveLengthV0
	}
	err := json.Unmarshal(textCheckPositiveLengthV0, &schemaCheckPositiveLengthV0)
	if err != nil {
		panic("invalid embedded json for CheckPositiveLengthV0")
	}
	return schemaCheckPositiveLengthV0
}

func ParsedCheckpointStorageConfigV0() interface{} {
	cacheLock.RLock()
	if schemaCheckpointStorageConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaCheckpointStorageConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaCheckpointStorageConfigV0 != nil {
		return schemaCheckpointStorageConfigV0
	}
	err := json.Unmarshal(textCheckpointStorageConfigV0, &schemaCheckpointStorageConfigV0)
	if err != nil {
		panic("invalid embedded json for CheckpointStorageConfigV0")
	}
	return schemaCheckpointStorageConfigV0
}

func ParsedDeviceV0() interface{} {
	cacheLock.RLock()
	if schemaDeviceV0 != nil {
		cacheLock.RUnlock()
		return schemaDeviceV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaDeviceV0 != nil {
		return schemaDeviceV0
	}
	err := json.Unmarshal(textDeviceV0, &schemaDeviceV0)
	if err != nil {
		panic("invalid embedded json for DeviceV0")
	}
	return schemaDeviceV0
}

func ParsedDevicesConfigV0() interface{} {
	cacheLock.RLock()
	if schemaDevicesConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaDevicesConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaDevicesConfigV0 != nil {
		return schemaDevicesConfigV0
	}
	err := json.Unmarshal(textDevicesConfigV0, &schemaDevicesConfigV0)
	if err != nil {
		panic("invalid embedded json for DevicesConfigV0")
	}
	return schemaDevicesConfigV0
}

func ParsedDirectoryConfigV0() interface{} {
	cacheLock.RLock()
	if schemaDirectoryConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaDirectoryConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaDirectoryConfigV0 != nil {
		return schemaDirectoryConfigV0
	}
	err := json.Unmarshal(textDirectoryConfigV0, &schemaDirectoryConfigV0)
	if err != nil {
		panic("invalid embedded json for DirectoryConfigV0")
	}
	return schemaDirectoryConfigV0
}

func ParsedEnvironmentImageMapV0() interface{} {
	cacheLock.RLock()
	if schemaEnvironmentImageMapV0 != nil {
		cacheLock.RUnlock()
		return schemaEnvironmentImageMapV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaEnvironmentImageMapV0 != nil {
		return schemaEnvironmentImageMapV0
	}
	err := json.Unmarshal(textEnvironmentImageMapV0, &schemaEnvironmentImageMapV0)
	if err != nil {
		panic("invalid embedded json for EnvironmentImageMapV0")
	}
	return schemaEnvironmentImageMapV0
}

func ParsedEnvironmentImageV0() interface{} {
	cacheLock.RLock()
	if schemaEnvironmentImageV0 != nil {
		cacheLock.RUnlock()
		return schemaEnvironmentImageV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaEnvironmentImageV0 != nil {
		return schemaEnvironmentImageV0
	}
	err := json.Unmarshal(textEnvironmentImageV0, &schemaEnvironmentImageV0)
	if err != nil {
		panic("invalid embedded json for EnvironmentImageV0")
	}
	return schemaEnvironmentImageV0
}

func ParsedEnvironmentVariablesMapV0() interface{} {
	cacheLock.RLock()
	if schemaEnvironmentVariablesMapV0 != nil {
		cacheLock.RUnlock()
		return schemaEnvironmentVariablesMapV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaEnvironmentVariablesMapV0 != nil {
		return schemaEnvironmentVariablesMapV0
	}
	err := json.Unmarshal(textEnvironmentVariablesMapV0, &schemaEnvironmentVariablesMapV0)
	if err != nil {
		panic("invalid embedded json for EnvironmentVariablesMapV0")
	}
	return schemaEnvironmentVariablesMapV0
}

func ParsedEnvironmentVariablesV0() interface{} {
	cacheLock.RLock()
	if schemaEnvironmentVariablesV0 != nil {
		cacheLock.RUnlock()
		return schemaEnvironmentVariablesV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaEnvironmentVariablesV0 != nil {
		return schemaEnvironmentVariablesV0
	}
	err := json.Unmarshal(textEnvironmentVariablesV0, &schemaEnvironmentVariablesV0)
	if err != nil {
		panic("invalid embedded json for EnvironmentVariablesV0")
	}
	return schemaEnvironmentVariablesV0
}

func ParsedEnvironmentConfigV0() interface{} {
	cacheLock.RLock()
	if schemaEnvironmentConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaEnvironmentConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaEnvironmentConfigV0 != nil {
		return schemaEnvironmentConfigV0
	}
	err := json.Unmarshal(textEnvironmentConfigV0, &schemaEnvironmentConfigV0)
	if err != nil {
		panic("invalid embedded json for EnvironmentConfigV0")
	}
	return schemaEnvironmentConfigV0
}

func ParsedExperimentConfigV0() interface{} {
	cacheLock.RLock()
	if schemaExperimentConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaExperimentConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaExperimentConfigV0 != nil {
		return schemaExperimentConfigV0
	}
	err := json.Unmarshal(textExperimentConfigV0, &schemaExperimentConfigV0)
	if err != nil {
		panic("invalid embedded json for ExperimentConfigV0")
	}
	return schemaExperimentConfigV0
}

func ParsedGCSConfigV0() interface{} {
	cacheLock.RLock()
	if schemaGCSConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaGCSConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaGCSConfigV0 != nil {
		return schemaGCSConfigV0
	}
	err := json.Unmarshal(textGCSConfigV0, &schemaGCSConfigV0)
	if err != nil {
		panic("invalid embedded json for GCSConfigV0")
	}
	return schemaGCSConfigV0
}

func ParsedPbsConfigV0() interface{} {
	cacheLock.RLock()
	if schemaPbsConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaPbsConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaPbsConfigV0 != nil {
		return schemaPbsConfigV0
	}
	err := json.Unmarshal(textPbsConfigV0, &schemaPbsConfigV0)
	if err != nil {
		panic("invalid embedded json for PbsConfigV0")
	}
	return schemaPbsConfigV0
}

func ParsedSlurmConfigV0() interface{} {
	cacheLock.RLock()
	if schemaSlurmConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaSlurmConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaSlurmConfigV0 != nil {
		return schemaSlurmConfigV0
	}
	err := json.Unmarshal(textSlurmConfigV0, &schemaSlurmConfigV0)
	if err != nil {
		panic("invalid embedded json for SlurmConfigV0")
	}
	return schemaSlurmConfigV0
}

func ParsedCategoricalHyperparameterV0() interface{} {
	cacheLock.RLock()
	if schemaCategoricalHyperparameterV0 != nil {
		cacheLock.RUnlock()
		return schemaCategoricalHyperparameterV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaCategoricalHyperparameterV0 != nil {
		return schemaCategoricalHyperparameterV0
	}
	err := json.Unmarshal(textCategoricalHyperparameterV0, &schemaCategoricalHyperparameterV0)
	if err != nil {
		panic("invalid embedded json for CategoricalHyperparameterV0")
	}
	return schemaCategoricalHyperparameterV0
}

func ParsedConstHyperparameterV0() interface{} {
	cacheLock.RLock()
	if schemaConstHyperparameterV0 != nil {
		cacheLock.RUnlock()
		return schemaConstHyperparameterV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaConstHyperparameterV0 != nil {
		return schemaConstHyperparameterV0
	}
	err := json.Unmarshal(textConstHyperparameterV0, &schemaConstHyperparameterV0)
	if err != nil {
		panic("invalid embedded json for ConstHyperparameterV0")
	}
	return schemaConstHyperparameterV0
}

func ParsedDoubleHyperparameterV0() interface{} {
	cacheLock.RLock()
	if schemaDoubleHyperparameterV0 != nil {
		cacheLock.RUnlock()
		return schemaDoubleHyperparameterV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaDoubleHyperparameterV0 != nil {
		return schemaDoubleHyperparameterV0
	}
	err := json.Unmarshal(textDoubleHyperparameterV0, &schemaDoubleHyperparameterV0)
	if err != nil {
		panic("invalid embedded json for DoubleHyperparameterV0")
	}
	return schemaDoubleHyperparameterV0
}

func ParsedIntHyperparameterV0() interface{} {
	cacheLock.RLock()
	if schemaIntHyperparameterV0 != nil {
		cacheLock.RUnlock()
		return schemaIntHyperparameterV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaIntHyperparameterV0 != nil {
		return schemaIntHyperparameterV0
	}
	err := json.Unmarshal(textIntHyperparameterV0, &schemaIntHyperparameterV0)
	if err != nil {
		panic("invalid embedded json for IntHyperparameterV0")
	}
	return schemaIntHyperparameterV0
}

func ParsedLogHyperparameterV0() interface{} {
	cacheLock.RLock()
	if schemaLogHyperparameterV0 != nil {
		cacheLock.RUnlock()
		return schemaLogHyperparameterV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaLogHyperparameterV0 != nil {
		return schemaLogHyperparameterV0
	}
	err := json.Unmarshal(textLogHyperparameterV0, &schemaLogHyperparameterV0)
	if err != nil {
		panic("invalid embedded json for LogHyperparameterV0")
	}
	return schemaLogHyperparameterV0
}

func ParsedHyperparameterV0() interface{} {
	cacheLock.RLock()
	if schemaHyperparameterV0 != nil {
		cacheLock.RUnlock()
		return schemaHyperparameterV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaHyperparameterV0 != nil {
		return schemaHyperparameterV0
	}
	err := json.Unmarshal(textHyperparameterV0, &schemaHyperparameterV0)
	if err != nil {
		panic("invalid embedded json for HyperparameterV0")
	}
	return schemaHyperparameterV0
}

func ParsedHyperparametersV0() interface{} {
	cacheLock.RLock()
	if schemaHyperparametersV0 != nil {
		cacheLock.RUnlock()
		return schemaHyperparametersV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaHyperparametersV0 != nil {
		return schemaHyperparametersV0
	}
	err := json.Unmarshal(textHyperparametersV0, &schemaHyperparametersV0)
	if err != nil {
		panic("invalid embedded json for HyperparametersV0")
	}
	return schemaHyperparametersV0
}

func ParsedIntegrationsConfigV0() interface{} {
	cacheLock.RLock()
	if schemaIntegrationsConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaIntegrationsConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaIntegrationsConfigV0 != nil {
		return schemaIntegrationsConfigV0
	}
	err := json.Unmarshal(textIntegrationsConfigV0, &schemaIntegrationsConfigV0)
	if err != nil {
		panic("invalid embedded json for IntegrationsConfigV0")
	}
	return schemaIntegrationsConfigV0
}

func ParsedKerberosConfigV0() interface{} {
	cacheLock.RLock()
	if schemaKerberosConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaKerberosConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaKerberosConfigV0 != nil {
		return schemaKerberosConfigV0
	}
	err := json.Unmarshal(textKerberosConfigV0, &schemaKerberosConfigV0)
	if err != nil {
		panic("invalid embedded json for KerberosConfigV0")
	}
	return schemaKerberosConfigV0
}

func ParsedLengthV0() interface{} {
	cacheLock.RLock()
	if schemaLengthV0 != nil {
		cacheLock.RUnlock()
		return schemaLengthV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaLengthV0 != nil {
		return schemaLengthV0
	}
	err := json.Unmarshal(textLengthV0, &schemaLengthV0)
	if err != nil {
		panic("invalid embedded json for LengthV0")
	}
	return schemaLengthV0
}

func ParsedLogActionV0() interface{} {
	cacheLock.RLock()
	if schemaLogActionV0 != nil {
		cacheLock.RUnlock()
		return schemaLogActionV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaLogActionV0 != nil {
		return schemaLogActionV0
	}
	err := json.Unmarshal(textLogActionV0, &schemaLogActionV0)
	if err != nil {
		panic("invalid embedded json for LogActionV0")
	}
	return schemaLogActionV0
}

func ParsedLogLegacyActionCancelRetriesV0() interface{} {
	cacheLock.RLock()
	if schemaLogLegacyActionCancelRetriesV0 != nil {
		cacheLock.RUnlock()
		return schemaLogLegacyActionCancelRetriesV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaLogLegacyActionCancelRetriesV0 != nil {
		return schemaLogLegacyActionCancelRetriesV0
	}
	err := json.Unmarshal(textLogLegacyActionCancelRetriesV0, &schemaLogLegacyActionCancelRetriesV0)
	if err != nil {
		panic("invalid embedded json for LogLegacyActionCancelRetriesV0")
	}
	return schemaLogLegacyActionCancelRetriesV0
}

func ParsedLogLegacyActionExcludeNodeV0() interface{} {
	cacheLock.RLock()
	if schemaLogLegacyActionExcludeNodeV0 != nil {
		cacheLock.RUnlock()
		return schemaLogLegacyActionExcludeNodeV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaLogLegacyActionExcludeNodeV0 != nil {
		return schemaLogLegacyActionExcludeNodeV0
	}
	err := json.Unmarshal(textLogLegacyActionExcludeNodeV0, &schemaLogLegacyActionExcludeNodeV0)
	if err != nil {
		panic("invalid embedded json for LogLegacyActionExcludeNodeV0")
	}
	return schemaLogLegacyActionExcludeNodeV0
}

func ParsedLogPoliciesConfigV0() interface{} {
	cacheLock.RLock()
	if schemaLogPoliciesConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaLogPoliciesConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaLogPoliciesConfigV0 != nil {
		return schemaLogPoliciesConfigV0
	}
	err := json.Unmarshal(textLogPoliciesConfigV0, &schemaLogPoliciesConfigV0)
	if err != nil {
		panic("invalid embedded json for LogPoliciesConfigV0")
	}
	return schemaLogPoliciesConfigV0
}

func ParsedLogPolicyV0() interface{} {
	cacheLock.RLock()
	if schemaLogPolicyV0 != nil {
		cacheLock.RUnlock()
		return schemaLogPolicyV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaLogPolicyV0 != nil {
		return schemaLogPolicyV0
	}
	err := json.Unmarshal(textLogPolicyV0, &schemaLogPolicyV0)
	if err != nil {
		panic("invalid embedded json for LogPolicyV0")
	}
	return schemaLogPolicyV0
}

func ParsedOptimizationsConfigV0() interface{} {
	cacheLock.RLock()
	if schemaOptimizationsConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaOptimizationsConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaOptimizationsConfigV0 != nil {
		return schemaOptimizationsConfigV0
	}
	err := json.Unmarshal(textOptimizationsConfigV0, &schemaOptimizationsConfigV0)
	if err != nil {
		panic("invalid embedded json for OptimizationsConfigV0")
	}
	return schemaOptimizationsConfigV0
}

func ParsedPachydermDatasetConfigV0() interface{} {
	cacheLock.RLock()
	if schemaPachydermDatasetConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaPachydermDatasetConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaPachydermDatasetConfigV0 != nil {
		return schemaPachydermDatasetConfigV0
	}
	err := json.Unmarshal(textPachydermDatasetConfigV0, &schemaPachydermDatasetConfigV0)
	if err != nil {
		panic("invalid embedded json for PachydermDatasetConfigV0")
	}
	return schemaPachydermDatasetConfigV0
}

func ParsedPachydermPachdConfigV0() interface{} {
	cacheLock.RLock()
	if schemaPachydermPachdConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaPachydermPachdConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaPachydermPachdConfigV0 != nil {
		return schemaPachydermPachdConfigV0
	}
	err := json.Unmarshal(textPachydermPachdConfigV0, &schemaPachydermPachdConfigV0)
	if err != nil {
		panic("invalid embedded json for PachydermPachdConfigV0")
	}
	return schemaPachydermPachdConfigV0
}

func ParsedPachydermProxyConfigV0() interface{} {
	cacheLock.RLock()
	if schemaPachydermProxyConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaPachydermProxyConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaPachydermProxyConfigV0 != nil {
		return schemaPachydermProxyConfigV0
	}
	err := json.Unmarshal(textPachydermProxyConfigV0, &schemaPachydermProxyConfigV0)
	if err != nil {
		panic("invalid embedded json for PachydermProxyConfigV0")
	}
	return schemaPachydermProxyConfigV0
}

func ParsedPachydermConfigV0() interface{} {
	cacheLock.RLock()
	if schemaPachydermConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaPachydermConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaPachydermConfigV0 != nil {
		return schemaPachydermConfigV0
	}
	err := json.Unmarshal(textPachydermConfigV0, &schemaPachydermConfigV0)
	if err != nil {
		panic("invalid embedded json for PachydermConfigV0")
	}
	return schemaPachydermConfigV0
}

func ParsedProfilingConfigV0() interface{} {
	cacheLock.RLock()
	if schemaProfilingConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaProfilingConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaProfilingConfigV0 != nil {
		return schemaProfilingConfigV0
	}
	err := json.Unmarshal(textProfilingConfigV0, &schemaProfilingConfigV0)
	if err != nil {
		panic("invalid embedded json for ProfilingConfigV0")
	}
	return schemaProfilingConfigV0
}

func ParsedProxyPortV0() interface{} {
	cacheLock.RLock()
	if schemaProxyPortV0 != nil {
		cacheLock.RUnlock()
		return schemaProxyPortV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaProxyPortV0 != nil {
		return schemaProxyPortV0
	}
	err := json.Unmarshal(textProxyPortV0, &schemaProxyPortV0)
	if err != nil {
		panic("invalid embedded json for ProxyPortV0")
	}
	return schemaProxyPortV0
}

func ParsedProxyPortsConfigV0() interface{} {
	cacheLock.RLock()
	if schemaProxyPortsConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaProxyPortsConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaProxyPortsConfigV0 != nil {
		return schemaProxyPortsConfigV0
	}
	err := json.Unmarshal(textProxyPortsConfigV0, &schemaProxyPortsConfigV0)
	if err != nil {
		panic("invalid embedded json for ProxyPortsConfigV0")
	}
	return schemaProxyPortsConfigV0
}

func ParsedRegistryAuthV0() interface{} {
	cacheLock.RLock()
	if schemaRegistryAuthV0 != nil {
		cacheLock.RUnlock()
		return schemaRegistryAuthV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaRegistryAuthV0 != nil {
		return schemaRegistryAuthV0
	}
	err := json.Unmarshal(textRegistryAuthV0, &schemaRegistryAuthV0)
	if err != nil {
		panic("invalid embedded json for RegistryAuthV0")
	}
	return schemaRegistryAuthV0
}

func ParsedReproducibilityConfigV0() interface{} {
	cacheLock.RLock()
	if schemaReproducibilityConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaReproducibilityConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaReproducibilityConfigV0 != nil {
		return schemaReproducibilityConfigV0
	}
	err := json.Unmarshal(textReproducibilityConfigV0, &schemaReproducibilityConfigV0)
	if err != nil {
		panic("invalid embedded json for ReproducibilityConfigV0")
	}
	return schemaReproducibilityConfigV0
}

func ParsedResourcesConfigV0() interface{} {
	cacheLock.RLock()
	if schemaResourcesConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaResourcesConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaResourcesConfigV0 != nil {
		return schemaResourcesConfigV0
	}
	err := json.Unmarshal(textResourcesConfigV0, &schemaResourcesConfigV0)
	if err != nil {
		panic("invalid embedded json for ResourcesConfigV0")
	}
	return schemaResourcesConfigV0
}

func ParsedRetentionPolicyConfigV0() interface{} {
	cacheLock.RLock()
	if schemaRetentionPolicyConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaRetentionPolicyConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaRetentionPolicyConfigV0 != nil {
		return schemaRetentionPolicyConfigV0
	}
	err := json.Unmarshal(textRetentionPolicyConfigV0, &schemaRetentionPolicyConfigV0)
	if err != nil {
		panic("invalid embedded json for RetentionPolicyConfigV0")
	}
	return schemaRetentionPolicyConfigV0
}

func ParsedS3ConfigV0() interface{} {
	cacheLock.RLock()
	if schemaS3ConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaS3ConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaS3ConfigV0 != nil {
		return schemaS3ConfigV0
	}
	err := json.Unmarshal(textS3ConfigV0, &schemaS3ConfigV0)
	if err != nil {
		panic("invalid embedded json for S3ConfigV0")
	}
	return schemaS3ConfigV0
}

func ParsedAdaptiveASHAConfigV0() interface{} {
	cacheLock.RLock()
	if schemaAdaptiveASHAConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaAdaptiveASHAConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaAdaptiveASHAConfigV0 != nil {
		return schemaAdaptiveASHAConfigV0
	}
	err := json.Unmarshal(textAdaptiveASHAConfigV0, &schemaAdaptiveASHAConfigV0)
	if err != nil {
		panic("invalid embedded json for AdaptiveASHAConfigV0")
	}
	return schemaAdaptiveASHAConfigV0
}

func ParsedAdaptiveSimpleConfigV0() interface{} {
	cacheLock.RLock()
	if schemaAdaptiveSimpleConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaAdaptiveSimpleConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaAdaptiveSimpleConfigV0 != nil {
		return schemaAdaptiveSimpleConfigV0
	}
	err := json.Unmarshal(textAdaptiveSimpleConfigV0, &schemaAdaptiveSimpleConfigV0)
	if err != nil {
		panic("invalid embedded json for AdaptiveSimpleConfigV0")
	}
	return schemaAdaptiveSimpleConfigV0
}

func ParsedAdaptiveConfigV0() interface{} {
	cacheLock.RLock()
	if schemaAdaptiveConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaAdaptiveConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaAdaptiveConfigV0 != nil {
		return schemaAdaptiveConfigV0
	}
	err := json.Unmarshal(textAdaptiveConfigV0, &schemaAdaptiveConfigV0)
	if err != nil {
		panic("invalid embedded json for AdaptiveConfigV0")
	}
	return schemaAdaptiveConfigV0
}

func ParsedAsyncHalvingConfigV0() interface{} {
	cacheLock.RLock()
	if schemaAsyncHalvingConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaAsyncHalvingConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaAsyncHalvingConfigV0 != nil {
		return schemaAsyncHalvingConfigV0
	}
	err := json.Unmarshal(textAsyncHalvingConfigV0, &schemaAsyncHalvingConfigV0)
	if err != nil {
		panic("invalid embedded json for AsyncHalvingConfigV0")
	}
	return schemaAsyncHalvingConfigV0
}

func ParsedCustomConfigV0() interface{} {
	cacheLock.RLock()
	if schemaCustomConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaCustomConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaCustomConfigV0 != nil {
		return schemaCustomConfigV0
	}
	err := json.Unmarshal(textCustomConfigV0, &schemaCustomConfigV0)
	if err != nil {
		panic("invalid embedded json for CustomConfigV0")
	}
	return schemaCustomConfigV0
}

func ParsedGridConfigV0() interface{} {
	cacheLock.RLock()
	if schemaGridConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaGridConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaGridConfigV0 != nil {
		return schemaGridConfigV0
	}
	err := json.Unmarshal(textGridConfigV0, &schemaGridConfigV0)
	if err != nil {
		panic("invalid embedded json for GridConfigV0")
	}
	return schemaGridConfigV0
}

func ParsedSearcherLengthV0() interface{} {
	cacheLock.RLock()
	if schemaSearcherLengthV0 != nil {
		cacheLock.RUnlock()
		return schemaSearcherLengthV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaSearcherLengthV0 != nil {
		return schemaSearcherLengthV0
	}
	err := json.Unmarshal(textSearcherLengthV0, &schemaSearcherLengthV0)
	if err != nil {
		panic("invalid embedded json for SearcherLengthV0")
	}
	return schemaSearcherLengthV0
}

func ParsedRandomConfigV0() interface{} {
	cacheLock.RLock()
	if schemaRandomConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaRandomConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaRandomConfigV0 != nil {
		return schemaRandomConfigV0
	}
	err := json.Unmarshal(textRandomConfigV0, &schemaRandomConfigV0)
	if err != nil {
		panic("invalid embedded json for RandomConfigV0")
	}
	return schemaRandomConfigV0
}

func ParsedSingleConfigV0() interface{} {
	cacheLock.RLock()
	if schemaSingleConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaSingleConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaSingleConfigV0 != nil {
		return schemaSingleConfigV0
	}
	err := json.Unmarshal(textSingleConfigV0, &schemaSingleConfigV0)
	if err != nil {
		panic("invalid embedded json for SingleConfigV0")
	}
	return schemaSingleConfigV0
}

func ParsedSyncHalvingConfigV0() interface{} {
	cacheLock.RLock()
	if schemaSyncHalvingConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaSyncHalvingConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaSyncHalvingConfigV0 != nil {
		return schemaSyncHalvingConfigV0
	}
	err := json.Unmarshal(textSyncHalvingConfigV0, &schemaSyncHalvingConfigV0)
	if err != nil {
		panic("invalid embedded json for SyncHalvingConfigV0")
	}
	return schemaSyncHalvingConfigV0
}

func ParsedSearcherConfigV0() interface{} {
	cacheLock.RLock()
	if schemaSearcherConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaSearcherConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaSearcherConfigV0 != nil {
		return schemaSearcherConfigV0
	}
	err := json.Unmarshal(textSearcherConfigV0, &schemaSearcherConfigV0)
	if err != nil {
		panic("invalid embedded json for SearcherConfigV0")
	}
	return schemaSearcherConfigV0
}

func ParsedSecurityConfigV0() interface{} {
	cacheLock.RLock()
	if schemaSecurityConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaSecurityConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaSecurityConfigV0 != nil {
		return schemaSecurityConfigV0
	}
	err := json.Unmarshal(textSecurityConfigV0, &schemaSecurityConfigV0)
	if err != nil {
		panic("invalid embedded json for SecurityConfigV0")
	}
	return schemaSecurityConfigV0
}

func ParsedSharedFSConfigV0() interface{} {
	cacheLock.RLock()
	if schemaSharedFSConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaSharedFSConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaSharedFSConfigV0 != nil {
		return schemaSharedFSConfigV0
	}
	err := json.Unmarshal(textSharedFSConfigV0, &schemaSharedFSConfigV0)
	if err != nil {
		panic("invalid embedded json for SharedFSConfigV0")
	}
	return schemaSharedFSConfigV0
}

func ParsedTensorboardStorageConfigV0() interface{} {
	cacheLock.RLock()
	if schemaTensorboardStorageConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaTensorboardStorageConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaTensorboardStorageConfigV0 != nil {
		return schemaTensorboardStorageConfigV0
	}
	err := json.Unmarshal(textTensorboardStorageConfigV0, &schemaTensorboardStorageConfigV0)
	if err != nil {
		panic("invalid embedded json for TensorboardStorageConfigV0")
	}
	return schemaTensorboardStorageConfigV0
}

func ParsedTestRootV0() interface{} {
	cacheLock.RLock()
	if schemaTestRootV0 != nil {
		cacheLock.RUnlock()
		return schemaTestRootV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaTestRootV0 != nil {
		return schemaTestRootV0
	}
	err := json.Unmarshal(textTestRootV0, &schemaTestRootV0)
	if err != nil {
		panic("invalid embedded json for TestRootV0")
	}
	return schemaTestRootV0
}

func ParsedTestSubV0() interface{} {
	cacheLock.RLock()
	if schemaTestSubV0 != nil {
		cacheLock.RUnlock()
		return schemaTestSubV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaTestSubV0 != nil {
		return schemaTestSubV0
	}
	err := json.Unmarshal(textTestSubV0, &schemaTestSubV0)
	if err != nil {
		panic("invalid embedded json for TestSubV0")
	}
	return schemaTestSubV0
}

func ParsedTestUnionAV0() interface{} {
	cacheLock.RLock()
	if schemaTestUnionAV0 != nil {
		cacheLock.RUnlock()
		return schemaTestUnionAV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaTestUnionAV0 != nil {
		return schemaTestUnionAV0
	}
	err := json.Unmarshal(textTestUnionAV0, &schemaTestUnionAV0)
	if err != nil {
		panic("invalid embedded json for TestUnionAV0")
	}
	return schemaTestUnionAV0
}

func ParsedTestUnionBV0() interface{} {
	cacheLock.RLock()
	if schemaTestUnionBV0 != nil {
		cacheLock.RUnlock()
		return schemaTestUnionBV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaTestUnionBV0 != nil {
		return schemaTestUnionBV0
	}
	err := json.Unmarshal(textTestUnionBV0, &schemaTestUnionBV0)
	if err != nil {
		panic("invalid embedded json for TestUnionBV0")
	}
	return schemaTestUnionBV0
}

func ParsedTestUnionV0() interface{} {
	cacheLock.RLock()
	if schemaTestUnionV0 != nil {
		cacheLock.RUnlock()
		return schemaTestUnionV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaTestUnionV0 != nil {
		return schemaTestUnionV0
	}
	err := json.Unmarshal(textTestUnionV0, &schemaTestUnionV0)
	if err != nil {
		panic("invalid embedded json for TestUnionV0")
	}
	return schemaTestUnionV0
}

func ParsedWebhooksConfigV0() interface{} {
	cacheLock.RLock()
	if schemaWebhooksConfigV0 != nil {
		cacheLock.RUnlock()
		return schemaWebhooksConfigV0
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if schemaWebhooksConfigV0 != nil {
		return schemaWebhooksConfigV0
	}
	err := json.Unmarshal(textWebhooksConfigV0, &schemaWebhooksConfigV0)
	if err != nil {
		panic("invalid embedded json for WebhooksConfigV0")
	}
	return schemaWebhooksConfigV0
}

func schemaBytesMap() map[string][]byte {
	cacheLock.RLock()
	if cachedSchemaBytesMap != nil {
		cacheLock.RUnlock()
		return cachedSchemaBytesMap
	}
	cacheLock.RUnlock()

	cacheLock.Lock()
	defer cacheLock.Unlock()
	if cachedSchemaBytesMap != nil {
		return cachedSchemaBytesMap
	}
	var url string
	cachedSchemaBytesMap = map[string][]byte{}
	url = "http://determined.ai/schemas/expconf/v0/azure.json"
	cachedSchemaBytesMap[url] = textAzureConfigV0
	url = "http://determined.ai/schemas/expconf/v0/bind-mount.json"
	cachedSchemaBytesMap[url] = textBindMountV0
	url = "http://determined.ai/schemas/expconf/v0/bind-mounts.json"
	cachedSchemaBytesMap[url] = textBindMountsConfigV0
	url = "http://determined.ai/schemas/expconf/v0/check-grid-hyperparameter.json"
	cachedSchemaBytesMap[url] = textCheckGridHyperparameterV0
	url = "http://determined.ai/schemas/expconf/v0/check-positive-length.json"
	cachedSchemaBytesMap[url] = textCheckPositiveLengthV0
	url = "http://determined.ai/schemas/expconf/v0/checkpoint-storage.json"
	cachedSchemaBytesMap[url] = textCheckpointStorageConfigV0
	url = "http://determined.ai/schemas/expconf/v0/device.json"
	cachedSchemaBytesMap[url] = textDeviceV0
	url = "http://determined.ai/schemas/expconf/v0/devices.json"
	cachedSchemaBytesMap[url] = textDevicesConfigV0
	url = "http://determined.ai/schemas/expconf/v0/directory.json"
	cachedSchemaBytesMap[url] = textDirectoryConfigV0
	url = "http://determined.ai/schemas/expconf/v0/environment-image-map.json"
	cachedSchemaBytesMap[url] = textEnvironmentImageMapV0
	url = "http://determined.ai/schemas/expconf/v0/environment-image.json"
	cachedSchemaBytesMap[url] = textEnvironmentImageV0
	url = "http://determined.ai/schemas/expconf/v0/environment-variables-map.json"
	cachedSchemaBytesMap[url] = textEnvironmentVariablesMapV0
	url = "http://determined.ai/schemas/expconf/v0/environment-variables.json"
	cachedSchemaBytesMap[url] = textEnvironmentVariablesV0
	url = "http://determined.ai/schemas/expconf/v0/environment.json"
	cachedSchemaBytesMap[url] = textEnvironmentConfigV0
	url = "http://determined.ai/schemas/expconf/v0/experiment.json"
	cachedSchemaBytesMap[url] = textExperimentConfigV0
	url = "http://determined.ai/schemas/expconf/v0/gcs.json"
	cachedSchemaBytesMap[url] = textGCSConfigV0
	url = "http://determined.ai/schemas/expconf/v0/hpc-cluster-pbs.json"
	cachedSchemaBytesMap[url] = textPbsConfigV0
	url = "http://determined.ai/schemas/expconf/v0/hpc-cluster-slurm.json"
	cachedSchemaBytesMap[url] = textSlurmConfigV0
	url = "http://determined.ai/schemas/expconf/v0/hyperparameter-categorical.json"
	cachedSchemaBytesMap[url] = textCategoricalHyperparameterV0
	url = "http://determined.ai/schemas/expconf/v0/hyperparameter-const.json"
	cachedSchemaBytesMap[url] = textConstHyperparameterV0
	url = "http://determined.ai/schemas/expconf/v0/hyperparameter-double.json"
	cachedSchemaBytesMap[url] = textDoubleHyperparameterV0
	url = "http://determined.ai/schemas/expconf/v0/hyperparameter-int.json"
	cachedSchemaBytesMap[url] = textIntHyperparameterV0
	url = "http://determined.ai/schemas/expconf/v0/hyperparameter-log.json"
	cachedSchemaBytesMap[url] = textLogHyperparameterV0
	url = "http://determined.ai/schemas/expconf/v0/hyperparameter.json"
	cachedSchemaBytesMap[url] = textHyperparameterV0
	url = "http://determined.ai/schemas/expconf/v0/hyperparameters.json"
	cachedSchemaBytesMap[url] = textHyperparametersV0
	url = "http://determined.ai/schemas/expconf/v0/integrations.json"
	cachedSchemaBytesMap[url] = textIntegrationsConfigV0
	url = "http://determined.ai/schemas/expconf/v0/kerberos.json"
	cachedSchemaBytesMap[url] = textKerberosConfigV0
	url = "http://determined.ai/schemas/expconf/v0/length.json"
	cachedSchemaBytesMap[url] = textLengthV0
	url = "http://determined.ai/schemas/expconf/v0/log-action.json"
	cachedSchemaBytesMap[url] = textLogActionV0
	url = "http://determined.ai/schemas/expconf/v0/log-legacy-action-cancel-retries.json"
	cachedSchemaBytesMap[url] = textLogLegacyActionCancelRetriesV0
	url = "http://determined.ai/schemas/expconf/v0/log-legacy-action-exclude-node.json"
	cachedSchemaBytesMap[url] = textLogLegacyActionExcludeNodeV0
	url = "http://determined.ai/schemas/expconf/v0/log-policies.json"
	cachedSchemaBytesMap[url] = textLogPoliciesConfigV0
	url = "http://determined.ai/schemas/expconf/v0/log-policy.json"
	cachedSchemaBytesMap[url] = textLogPolicyV0
	url = "http://determined.ai/schemas/expconf/v0/optimizations.json"
	cachedSchemaBytesMap[url] = textOptimizationsConfigV0
	url = "http://determined.ai/schemas/expconf/v0/pachyderm-dataset.json"
	cachedSchemaBytesMap[url] = textPachydermDatasetConfigV0
	url = "http://determined.ai/schemas/expconf/v0/pachyderm-pachd.json"
	cachedSchemaBytesMap[url] = textPachydermPachdConfigV0
	url = "http://determined.ai/schemas/expconf/v0/pachyderm-proxy.json"
	cachedSchemaBytesMap[url] = textPachydermProxyConfigV0
	url = "http://determined.ai/schemas/expconf/v0/pachyderm.json"
	cachedSchemaBytesMap[url] = textPachydermConfigV0
	url = "http://determined.ai/schemas/expconf/v0/profiling.json"
	cachedSchemaBytesMap[url] = textProfilingConfigV0
	url = "http://determined.ai/schemas/expconf/v0/proxy-port.json"
	cachedSchemaBytesMap[url] = textProxyPortV0
	url = "http://determined.ai/schemas/expconf/v0/proxy-ports.json"
	cachedSchemaBytesMap[url] = textProxyPortsConfigV0
	url = "http://determined.ai/schemas/expconf/v0/registry-auth.json"
	cachedSchemaBytesMap[url] = textRegistryAuthV0
	url = "http://determined.ai/schemas/expconf/v0/reproducibility.json"
	cachedSchemaBytesMap[url] = textReproducibilityConfigV0
	url = "http://determined.ai/schemas/expconf/v0/resources.json"
	cachedSchemaBytesMap[url] = textResourcesConfigV0
	url = "http://determined.ai/schemas/expconf/v0/retention-policy.json"
	cachedSchemaBytesMap[url] = textRetentionPolicyConfigV0
	url = "http://determined.ai/schemas/expconf/v0/s3.json"
	cachedSchemaBytesMap[url] = textS3ConfigV0
	url = "http://determined.ai/schemas/expconf/v0/searcher-adaptive-asha.json"
	cachedSchemaBytesMap[url] = textAdaptiveASHAConfigV0
	url = "http://determined.ai/schemas/expconf/v0/searcher-adaptive-simple.json"
	cachedSchemaBytesMap[url] = textAdaptiveSimpleConfigV0
	url = "http://determined.ai/schemas/expconf/v0/searcher-adaptive.json"
	cachedSchemaBytesMap[url] = textAdaptiveConfigV0
	url = "http://determined.ai/schemas/expconf/v0/searcher-async-halving.json"
	cachedSchemaBytesMap[url] = textAsyncHalvingConfigV0
	url = "http://determined.ai/schemas/expconf/v0/searcher-custom.json"
	cachedSchemaBytesMap[url] = textCustomConfigV0
	url = "http://determined.ai/schemas/expconf/v0/searcher-grid.json"
	cachedSchemaBytesMap[url] = textGridConfigV0
	url = "http://determined.ai/schemas/expconf/v0/searcher-length.json"
	cachedSchemaBytesMap[url] = textSearcherLengthV0
	url = "http://determined.ai/schemas/expconf/v0/searcher-random.json"
	cachedSchemaBytesMap[url] = textRandomConfigV0
	url = "http://determined.ai/schemas/expconf/v0/searcher-single.json"
	cachedSchemaBytesMap[url] = textSingleConfigV0
	url = "http://determined.ai/schemas/expconf/v0/searcher-sync-halving.json"
	cachedSchemaBytesMap[url] = textSyncHalvingConfigV0
	url = "http://determined.ai/schemas/expconf/v0/searcher.json"
	cachedSchemaBytesMap[url] = textSearcherConfigV0
	url = "http://determined.ai/schemas/expconf/v0/security.json"
	cachedSchemaBytesMap[url] = textSecurityConfigV0
	url = "http://determined.ai/schemas/expconf/v0/shared-fs.json"
	cachedSchemaBytesMap[url] = textSharedFSConfigV0
	url = "http://determined.ai/schemas/expconf/v0/tensorboard-storage.json"
	cachedSchemaBytesMap[url] = textTensorboardStorageConfigV0
	url = "http://determined.ai/schemas/expconf/v0/test-root.json"
	cachedSchemaBytesMap[url] = textTestRootV0
	url = "http://determined.ai/schemas/expconf/v0/test-sub.json"
	cachedSchemaBytesMap[url] = textTestSubV0
	url = "http://determined.ai/schemas/expconf/v0/test-union-a.json"
	cachedSchemaBytesMap[url] = textTestUnionAV0
	url = "http://determined.ai/schemas/expconf/v0/test-union-b.json"
	cachedSchemaBytesMap[url] = textTestUnionBV0
	url = "http://determined.ai/schemas/expconf/v0/test-union.json"
	cachedSchemaBytesMap[url] = textTestUnionV0
	url = "http://determined.ai/schemas/expconf/v0/webhooks.json"
	cachedSchemaBytesMap[url] = textWebhooksConfigV0
	return cachedSchemaBytesMap
}
