/*
Launcher API

The Launcher API is the execution layer for the Capsules framework.  It handles all the details of launching and monitoring runtime environments.

API version: 3.3.7
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package launcher

import (
	"encoding/json"
)

// ResourceRequirements struct for ResourceRequirements
type ResourceRequirements struct {
	Instances *map[string]int32 `json:"instances,omitempty"`
	Cores *map[string]float32 `json:"cores,omitempty"`
	Memory *map[string]string `json:"memory,omitempty"`
	Gpus *map[string]int32 `json:"gpus,omitempty"`
	Scratch *map[string]string `json:"scratch,omitempty"`
	AdditionalPropertiesField *map[string]interface{} `json:"additionalProperties,omitempty"`
}

// NewResourceRequirements instantiates a new ResourceRequirements object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewResourceRequirements() *ResourceRequirements {
	this := ResourceRequirements{}
	return &this
}

// NewResourceRequirementsWithDefaults instantiates a new ResourceRequirements object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewResourceRequirementsWithDefaults() *ResourceRequirements {
	this := ResourceRequirements{}
	return &this
}

// GetInstances returns the Instances field value if set, zero value otherwise.
func (o *ResourceRequirements) GetInstances() map[string]int32 {
	if o == nil || o.Instances == nil {
		var ret map[string]int32
		return ret
	}
	return *o.Instances
}

// GetInstancesOk returns a tuple with the Instances field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ResourceRequirements) GetInstancesOk() (*map[string]int32, bool) {
	if o == nil || o.Instances == nil {
		return nil, false
	}
	return o.Instances, true
}

// HasInstances returns a boolean if a field has been set.
func (o *ResourceRequirements) HasInstances() bool {
	if o != nil && o.Instances != nil {
		return true
	}

	return false
}

// SetInstances gets a reference to the given map[string]int32 and assigns it to the Instances field.
func (o *ResourceRequirements) SetInstances(v map[string]int32) {
	o.Instances = &v
}

// GetCores returns the Cores field value if set, zero value otherwise.
func (o *ResourceRequirements) GetCores() map[string]float32 {
	if o == nil || o.Cores == nil {
		var ret map[string]float32
		return ret
	}
	return *o.Cores
}

// GetCoresOk returns a tuple with the Cores field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ResourceRequirements) GetCoresOk() (*map[string]float32, bool) {
	if o == nil || o.Cores == nil {
		return nil, false
	}
	return o.Cores, true
}

// HasCores returns a boolean if a field has been set.
func (o *ResourceRequirements) HasCores() bool {
	if o != nil && o.Cores != nil {
		return true
	}

	return false
}

// SetCores gets a reference to the given map[string]float32 and assigns it to the Cores field.
func (o *ResourceRequirements) SetCores(v map[string]float32) {
	o.Cores = &v
}

// GetMemory returns the Memory field value if set, zero value otherwise.
func (o *ResourceRequirements) GetMemory() map[string]string {
	if o == nil || o.Memory == nil {
		var ret map[string]string
		return ret
	}
	return *o.Memory
}

// GetMemoryOk returns a tuple with the Memory field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ResourceRequirements) GetMemoryOk() (*map[string]string, bool) {
	if o == nil || o.Memory == nil {
		return nil, false
	}
	return o.Memory, true
}

// HasMemory returns a boolean if a field has been set.
func (o *ResourceRequirements) HasMemory() bool {
	if o != nil && o.Memory != nil {
		return true
	}

	return false
}

// SetMemory gets a reference to the given map[string]string and assigns it to the Memory field.
func (o *ResourceRequirements) SetMemory(v map[string]string) {
	o.Memory = &v
}

// GetGpus returns the Gpus field value if set, zero value otherwise.
func (o *ResourceRequirements) GetGpus() map[string]int32 {
	if o == nil || o.Gpus == nil {
		var ret map[string]int32
		return ret
	}
	return *o.Gpus
}

// GetGpusOk returns a tuple with the Gpus field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ResourceRequirements) GetGpusOk() (*map[string]int32, bool) {
	if o == nil || o.Gpus == nil {
		return nil, false
	}
	return o.Gpus, true
}

// HasGpus returns a boolean if a field has been set.
func (o *ResourceRequirements) HasGpus() bool {
	if o != nil && o.Gpus != nil {
		return true
	}

	return false
}

// SetGpus gets a reference to the given map[string]int32 and assigns it to the Gpus field.
func (o *ResourceRequirements) SetGpus(v map[string]int32) {
	o.Gpus = &v
}

// GetScratch returns the Scratch field value if set, zero value otherwise.
func (o *ResourceRequirements) GetScratch() map[string]string {
	if o == nil || o.Scratch == nil {
		var ret map[string]string
		return ret
	}
	return *o.Scratch
}

// GetScratchOk returns a tuple with the Scratch field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ResourceRequirements) GetScratchOk() (*map[string]string, bool) {
	if o == nil || o.Scratch == nil {
		return nil, false
	}
	return o.Scratch, true
}

// HasScratch returns a boolean if a field has been set.
func (o *ResourceRequirements) HasScratch() bool {
	if o != nil && o.Scratch != nil {
		return true
	}

	return false
}

// SetScratch gets a reference to the given map[string]string and assigns it to the Scratch field.
func (o *ResourceRequirements) SetScratch(v map[string]string) {
	o.Scratch = &v
}

// GetAdditionalPropertiesField returns the AdditionalPropertiesField field value if set, zero value otherwise.
func (o *ResourceRequirements) GetAdditionalPropertiesField() map[string]interface{} {
	if o == nil || o.AdditionalPropertiesField == nil {
		var ret map[string]interface{}
		return ret
	}
	return *o.AdditionalPropertiesField
}

// GetAdditionalPropertiesFieldOk returns a tuple with the AdditionalPropertiesField field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ResourceRequirements) GetAdditionalPropertiesFieldOk() (*map[string]interface{}, bool) {
	if o == nil || o.AdditionalPropertiesField == nil {
		return nil, false
	}
	return o.AdditionalPropertiesField, true
}

// HasAdditionalPropertiesField returns a boolean if a field has been set.
func (o *ResourceRequirements) HasAdditionalPropertiesField() bool {
	if o != nil && o.AdditionalPropertiesField != nil {
		return true
	}

	return false
}

// SetAdditionalPropertiesField gets a reference to the given map[string]interface{} and assigns it to the AdditionalPropertiesField field.
func (o *ResourceRequirements) SetAdditionalPropertiesField(v map[string]interface{}) {
	o.AdditionalPropertiesField = &v
}

func (o ResourceRequirements) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Instances != nil {
		toSerialize["instances"] = o.Instances
	}
	if o.Cores != nil {
		toSerialize["cores"] = o.Cores
	}
	if o.Memory != nil {
		toSerialize["memory"] = o.Memory
	}
	if o.Gpus != nil {
		toSerialize["gpus"] = o.Gpus
	}
	if o.Scratch != nil {
		toSerialize["scratch"] = o.Scratch
	}
	if o.AdditionalPropertiesField != nil {
		toSerialize["additionalProperties"] = o.AdditionalPropertiesField
	}
	return json.Marshal(toSerialize)
}

type NullableResourceRequirements struct {
	value *ResourceRequirements
	isSet bool
}

func (v NullableResourceRequirements) Get() *ResourceRequirements {
	return v.value
}

func (v *NullableResourceRequirements) Set(val *ResourceRequirements) {
	v.value = val
	v.isSet = true
}

func (v NullableResourceRequirements) IsSet() bool {
	return v.isSet
}

func (v *NullableResourceRequirements) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableResourceRequirements(val *ResourceRequirements) *NullableResourceRequirements {
	return &NullableResourceRequirements{value: val, isSet: true}
}

func (v NullableResourceRequirements) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableResourceRequirements) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


