/*
Launcher API

The Launcher API is the execution layer for the Capsules framework.  It handles all the details of launching and monitoring runtime environments.

API version: 3.3.7
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package launcher

import (
	"encoding/json"
)

// Manifest Describes the capsule to be launched
type Manifest struct {
	ManifestVersion string `json:"manifestVersion"`
	ClientMetadata ClientMetadata `json:"clientMetadata"`
	WarehouseMetadata *WarehouseMetadata `json:"warehouseMetadata,omitempty"`
	DispatchMetadata *DispatchMetadata `json:"dispatchMetadata,omitempty"`
	Payloads *[]Payload `json:"payloads,omitempty"`
	SharedData *[]Data `json:"sharedData,omitempty"`
	AdditionalPropertiesField *map[string]interface{} `json:"additionalProperties,omitempty"`
}

// NewManifest instantiates a new Manifest object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewManifest(manifestVersion string, clientMetadata ClientMetadata) *Manifest {
	this := Manifest{}
	this.ManifestVersion = manifestVersion
	this.ClientMetadata = clientMetadata
	return &this
}

// NewManifestWithDefaults instantiates a new Manifest object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewManifestWithDefaults() *Manifest {
	this := Manifest{}
	return &this
}

// GetManifestVersion returns the ManifestVersion field value
func (o *Manifest) GetManifestVersion() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.ManifestVersion
}

// GetManifestVersionOk returns a tuple with the ManifestVersion field value
// and a boolean to check if the value has been set.
func (o *Manifest) GetManifestVersionOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.ManifestVersion, true
}

// SetManifestVersion sets field value
func (o *Manifest) SetManifestVersion(v string) {
	o.ManifestVersion = v
}

// GetClientMetadata returns the ClientMetadata field value
func (o *Manifest) GetClientMetadata() ClientMetadata {
	if o == nil {
		var ret ClientMetadata
		return ret
	}

	return o.ClientMetadata
}

// GetClientMetadataOk returns a tuple with the ClientMetadata field value
// and a boolean to check if the value has been set.
func (o *Manifest) GetClientMetadataOk() (*ClientMetadata, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.ClientMetadata, true
}

// SetClientMetadata sets field value
func (o *Manifest) SetClientMetadata(v ClientMetadata) {
	o.ClientMetadata = v
}

// GetWarehouseMetadata returns the WarehouseMetadata field value if set, zero value otherwise.
func (o *Manifest) GetWarehouseMetadata() WarehouseMetadata {
	if o == nil || o.WarehouseMetadata == nil {
		var ret WarehouseMetadata
		return ret
	}
	return *o.WarehouseMetadata
}

// GetWarehouseMetadataOk returns a tuple with the WarehouseMetadata field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Manifest) GetWarehouseMetadataOk() (*WarehouseMetadata, bool) {
	if o == nil || o.WarehouseMetadata == nil {
		return nil, false
	}
	return o.WarehouseMetadata, true
}

// HasWarehouseMetadata returns a boolean if a field has been set.
func (o *Manifest) HasWarehouseMetadata() bool {
	if o != nil && o.WarehouseMetadata != nil {
		return true
	}

	return false
}

// SetWarehouseMetadata gets a reference to the given WarehouseMetadata and assigns it to the WarehouseMetadata field.
func (o *Manifest) SetWarehouseMetadata(v WarehouseMetadata) {
	o.WarehouseMetadata = &v
}

// GetDispatchMetadata returns the DispatchMetadata field value if set, zero value otherwise.
func (o *Manifest) GetDispatchMetadata() DispatchMetadata {
	if o == nil || o.DispatchMetadata == nil {
		var ret DispatchMetadata
		return ret
	}
	return *o.DispatchMetadata
}

// GetDispatchMetadataOk returns a tuple with the DispatchMetadata field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Manifest) GetDispatchMetadataOk() (*DispatchMetadata, bool) {
	if o == nil || o.DispatchMetadata == nil {
		return nil, false
	}
	return o.DispatchMetadata, true
}

// HasDispatchMetadata returns a boolean if a field has been set.
func (o *Manifest) HasDispatchMetadata() bool {
	if o != nil && o.DispatchMetadata != nil {
		return true
	}

	return false
}

// SetDispatchMetadata gets a reference to the given DispatchMetadata and assigns it to the DispatchMetadata field.
func (o *Manifest) SetDispatchMetadata(v DispatchMetadata) {
	o.DispatchMetadata = &v
}

// GetPayloads returns the Payloads field value if set, zero value otherwise.
func (o *Manifest) GetPayloads() []Payload {
	if o == nil || o.Payloads == nil {
		var ret []Payload
		return ret
	}
	return *o.Payloads
}

// GetPayloadsOk returns a tuple with the Payloads field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Manifest) GetPayloadsOk() (*[]Payload, bool) {
	if o == nil || o.Payloads == nil {
		return nil, false
	}
	return o.Payloads, true
}

// HasPayloads returns a boolean if a field has been set.
func (o *Manifest) HasPayloads() bool {
	if o != nil && o.Payloads != nil {
		return true
	}

	return false
}

// SetPayloads gets a reference to the given []Payload and assigns it to the Payloads field.
func (o *Manifest) SetPayloads(v []Payload) {
	o.Payloads = &v
}

// GetSharedData returns the SharedData field value if set, zero value otherwise.
func (o *Manifest) GetSharedData() []Data {
	if o == nil || o.SharedData == nil {
		var ret []Data
		return ret
	}
	return *o.SharedData
}

// GetSharedDataOk returns a tuple with the SharedData field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Manifest) GetSharedDataOk() (*[]Data, bool) {
	if o == nil || o.SharedData == nil {
		return nil, false
	}
	return o.SharedData, true
}

// HasSharedData returns a boolean if a field has been set.
func (o *Manifest) HasSharedData() bool {
	if o != nil && o.SharedData != nil {
		return true
	}

	return false
}

// SetSharedData gets a reference to the given []Data and assigns it to the SharedData field.
func (o *Manifest) SetSharedData(v []Data) {
	o.SharedData = &v
}

// GetAdditionalPropertiesField returns the AdditionalPropertiesField field value if set, zero value otherwise.
func (o *Manifest) GetAdditionalPropertiesField() map[string]interface{} {
	if o == nil || o.AdditionalPropertiesField == nil {
		var ret map[string]interface{}
		return ret
	}
	return *o.AdditionalPropertiesField
}

// GetAdditionalPropertiesFieldOk returns a tuple with the AdditionalPropertiesField field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Manifest) GetAdditionalPropertiesFieldOk() (*map[string]interface{}, bool) {
	if o == nil || o.AdditionalPropertiesField == nil {
		return nil, false
	}
	return o.AdditionalPropertiesField, true
}

// HasAdditionalPropertiesField returns a boolean if a field has been set.
func (o *Manifest) HasAdditionalPropertiesField() bool {
	if o != nil && o.AdditionalPropertiesField != nil {
		return true
	}

	return false
}

// SetAdditionalPropertiesField gets a reference to the given map[string]interface{} and assigns it to the AdditionalPropertiesField field.
func (o *Manifest) SetAdditionalPropertiesField(v map[string]interface{}) {
	o.AdditionalPropertiesField = &v
}

func (o Manifest) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["manifestVersion"] = o.ManifestVersion
	}
	if true {
		toSerialize["clientMetadata"] = o.ClientMetadata
	}
	if o.WarehouseMetadata != nil {
		toSerialize["warehouseMetadata"] = o.WarehouseMetadata
	}
	if o.DispatchMetadata != nil {
		toSerialize["dispatchMetadata"] = o.DispatchMetadata
	}
	if o.Payloads != nil {
		toSerialize["payloads"] = o.Payloads
	}
	if o.SharedData != nil {
		toSerialize["sharedData"] = o.SharedData
	}
	if o.AdditionalPropertiesField != nil {
		toSerialize["additionalProperties"] = o.AdditionalPropertiesField
	}
	return json.Marshal(toSerialize)
}

type NullableManifest struct {
	value *Manifest
	isSet bool
}

func (v NullableManifest) Get() *Manifest {
	return v.value
}

func (v *NullableManifest) Set(val *Manifest) {
	v.value = val
	v.isSet = true
}

func (v NullableManifest) IsSet() bool {
	return v.isSet
}

func (v *NullableManifest) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableManifest(val *Manifest) *NullableManifest {
	return &NullableManifest{value: val, isSet: true}
}

func (v NullableManifest) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableManifest) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


