/*
Launcher API

The Launcher API is the execution layer for the Capsules framework.  It handles all the details of launching and monitoring runtime environments.

API version: 3.3.7
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package launcher

import (
	"encoding/json"
)

// DispatchInfo struct for DispatchInfo
type DispatchInfo struct {
	LaunchedCapsuleReference *OwnedResourceReference `json:"launchedCapsuleReference,omitempty"`
	LaunchingUser *string `json:"launchingUser,omitempty"`
	DispatchId *string `json:"dispatchId,omitempty"`
	State *DispatchState `json:"state,omitempty"`
	Events *[]Event `json:"events,omitempty"`
	LastUpdated *string `json:"lastUpdated,omitempty"`
	PayloadStates *map[string]DispatchState `json:"payloadStates,omitempty"`
	AdditionalPropertiesField *map[string]interface{} `json:"additionalProperties,omitempty"`
}

// NewDispatchInfo instantiates a new DispatchInfo object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDispatchInfo() *DispatchInfo {
	this := DispatchInfo{}
	return &this
}

// NewDispatchInfoWithDefaults instantiates a new DispatchInfo object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDispatchInfoWithDefaults() *DispatchInfo {
	this := DispatchInfo{}
	return &this
}

// GetLaunchedCapsuleReference returns the LaunchedCapsuleReference field value if set, zero value otherwise.
func (o *DispatchInfo) GetLaunchedCapsuleReference() OwnedResourceReference {
	if o == nil || o.LaunchedCapsuleReference == nil {
		var ret OwnedResourceReference
		return ret
	}
	return *o.LaunchedCapsuleReference
}

// GetLaunchedCapsuleReferenceOk returns a tuple with the LaunchedCapsuleReference field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DispatchInfo) GetLaunchedCapsuleReferenceOk() (*OwnedResourceReference, bool) {
	if o == nil || o.LaunchedCapsuleReference == nil {
		return nil, false
	}
	return o.LaunchedCapsuleReference, true
}

// HasLaunchedCapsuleReference returns a boolean if a field has been set.
func (o *DispatchInfo) HasLaunchedCapsuleReference() bool {
	if o != nil && o.LaunchedCapsuleReference != nil {
		return true
	}

	return false
}

// SetLaunchedCapsuleReference gets a reference to the given OwnedResourceReference and assigns it to the LaunchedCapsuleReference field.
func (o *DispatchInfo) SetLaunchedCapsuleReference(v OwnedResourceReference) {
	o.LaunchedCapsuleReference = &v
}

// GetLaunchingUser returns the LaunchingUser field value if set, zero value otherwise.
func (o *DispatchInfo) GetLaunchingUser() string {
	if o == nil || o.LaunchingUser == nil {
		var ret string
		return ret
	}
	return *o.LaunchingUser
}

// GetLaunchingUserOk returns a tuple with the LaunchingUser field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DispatchInfo) GetLaunchingUserOk() (*string, bool) {
	if o == nil || o.LaunchingUser == nil {
		return nil, false
	}
	return o.LaunchingUser, true
}

// HasLaunchingUser returns a boolean if a field has been set.
func (o *DispatchInfo) HasLaunchingUser() bool {
	if o != nil && o.LaunchingUser != nil {
		return true
	}

	return false
}

// SetLaunchingUser gets a reference to the given string and assigns it to the LaunchingUser field.
func (o *DispatchInfo) SetLaunchingUser(v string) {
	o.LaunchingUser = &v
}

// GetDispatchId returns the DispatchId field value if set, zero value otherwise.
func (o *DispatchInfo) GetDispatchId() string {
	if o == nil || o.DispatchId == nil {
		var ret string
		return ret
	}
	return *o.DispatchId
}

// GetDispatchIdOk returns a tuple with the DispatchId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DispatchInfo) GetDispatchIdOk() (*string, bool) {
	if o == nil || o.DispatchId == nil {
		return nil, false
	}
	return o.DispatchId, true
}

// HasDispatchId returns a boolean if a field has been set.
func (o *DispatchInfo) HasDispatchId() bool {
	if o != nil && o.DispatchId != nil {
		return true
	}

	return false
}

// SetDispatchId gets a reference to the given string and assigns it to the DispatchId field.
func (o *DispatchInfo) SetDispatchId(v string) {
	o.DispatchId = &v
}

// GetState returns the State field value if set, zero value otherwise.
func (o *DispatchInfo) GetState() DispatchState {
	if o == nil || o.State == nil {
		var ret DispatchState
		return ret
	}
	return *o.State
}

// GetStateOk returns a tuple with the State field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DispatchInfo) GetStateOk() (*DispatchState, bool) {
	if o == nil || o.State == nil {
		return nil, false
	}
	return o.State, true
}

// HasState returns a boolean if a field has been set.
func (o *DispatchInfo) HasState() bool {
	if o != nil && o.State != nil {
		return true
	}

	return false
}

// SetState gets a reference to the given DispatchState and assigns it to the State field.
func (o *DispatchInfo) SetState(v DispatchState) {
	o.State = &v
}

// GetEvents returns the Events field value if set, zero value otherwise.
func (o *DispatchInfo) GetEvents() []Event {
	if o == nil || o.Events == nil {
		var ret []Event
		return ret
	}
	return *o.Events
}

// GetEventsOk returns a tuple with the Events field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DispatchInfo) GetEventsOk() (*[]Event, bool) {
	if o == nil || o.Events == nil {
		return nil, false
	}
	return o.Events, true
}

// HasEvents returns a boolean if a field has been set.
func (o *DispatchInfo) HasEvents() bool {
	if o != nil && o.Events != nil {
		return true
	}

	return false
}

// SetEvents gets a reference to the given []Event and assigns it to the Events field.
func (o *DispatchInfo) SetEvents(v []Event) {
	o.Events = &v
}

// GetLastUpdated returns the LastUpdated field value if set, zero value otherwise.
func (o *DispatchInfo) GetLastUpdated() string {
	if o == nil || o.LastUpdated == nil {
		var ret string
		return ret
	}
	return *o.LastUpdated
}

// GetLastUpdatedOk returns a tuple with the LastUpdated field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DispatchInfo) GetLastUpdatedOk() (*string, bool) {
	if o == nil || o.LastUpdated == nil {
		return nil, false
	}
	return o.LastUpdated, true
}

// HasLastUpdated returns a boolean if a field has been set.
func (o *DispatchInfo) HasLastUpdated() bool {
	if o != nil && o.LastUpdated != nil {
		return true
	}

	return false
}

// SetLastUpdated gets a reference to the given string and assigns it to the LastUpdated field.
func (o *DispatchInfo) SetLastUpdated(v string) {
	o.LastUpdated = &v
}

// GetPayloadStates returns the PayloadStates field value if set, zero value otherwise.
func (o *DispatchInfo) GetPayloadStates() map[string]DispatchState {
	if o == nil || o.PayloadStates == nil {
		var ret map[string]DispatchState
		return ret
	}
	return *o.PayloadStates
}

// GetPayloadStatesOk returns a tuple with the PayloadStates field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DispatchInfo) GetPayloadStatesOk() (*map[string]DispatchState, bool) {
	if o == nil || o.PayloadStates == nil {
		return nil, false
	}
	return o.PayloadStates, true
}

// HasPayloadStates returns a boolean if a field has been set.
func (o *DispatchInfo) HasPayloadStates() bool {
	if o != nil && o.PayloadStates != nil {
		return true
	}

	return false
}

// SetPayloadStates gets a reference to the given map[string]DispatchState and assigns it to the PayloadStates field.
func (o *DispatchInfo) SetPayloadStates(v map[string]DispatchState) {
	o.PayloadStates = &v
}

// GetAdditionalPropertiesField returns the AdditionalPropertiesField field value if set, zero value otherwise.
func (o *DispatchInfo) GetAdditionalPropertiesField() map[string]interface{} {
	if o == nil || o.AdditionalPropertiesField == nil {
		var ret map[string]interface{}
		return ret
	}
	return *o.AdditionalPropertiesField
}

// GetAdditionalPropertiesFieldOk returns a tuple with the AdditionalPropertiesField field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DispatchInfo) GetAdditionalPropertiesFieldOk() (*map[string]interface{}, bool) {
	if o == nil || o.AdditionalPropertiesField == nil {
		return nil, false
	}
	return o.AdditionalPropertiesField, true
}

// HasAdditionalPropertiesField returns a boolean if a field has been set.
func (o *DispatchInfo) HasAdditionalPropertiesField() bool {
	if o != nil && o.AdditionalPropertiesField != nil {
		return true
	}

	return false
}

// SetAdditionalPropertiesField gets a reference to the given map[string]interface{} and assigns it to the AdditionalPropertiesField field.
func (o *DispatchInfo) SetAdditionalPropertiesField(v map[string]interface{}) {
	o.AdditionalPropertiesField = &v
}

func (o DispatchInfo) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.LaunchedCapsuleReference != nil {
		toSerialize["launchedCapsuleReference"] = o.LaunchedCapsuleReference
	}
	if o.LaunchingUser != nil {
		toSerialize["launchingUser"] = o.LaunchingUser
	}
	if o.DispatchId != nil {
		toSerialize["dispatchId"] = o.DispatchId
	}
	if o.State != nil {
		toSerialize["state"] = o.State
	}
	if o.Events != nil {
		toSerialize["events"] = o.Events
	}
	if o.LastUpdated != nil {
		toSerialize["lastUpdated"] = o.LastUpdated
	}
	if o.PayloadStates != nil {
		toSerialize["payloadStates"] = o.PayloadStates
	}
	if o.AdditionalPropertiesField != nil {
		toSerialize["additionalProperties"] = o.AdditionalPropertiesField
	}
	return json.Marshal(toSerialize)
}

type NullableDispatchInfo struct {
	value *DispatchInfo
	isSet bool
}

func (v NullableDispatchInfo) Get() *DispatchInfo {
	return v.value
}

func (v *NullableDispatchInfo) Set(val *DispatchInfo) {
	v.value = val
	v.isSet = true
}

func (v NullableDispatchInfo) IsSet() bool {
	return v.isSet
}

func (v *NullableDispatchInfo) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDispatchInfo(val *DispatchInfo) *NullableDispatchInfo {
	return &NullableDispatchInfo{value: val, isSet: true}
}

func (v NullableDispatchInfo) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDispatchInfo) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


