/*
Launcher API

The Launcher API is the execution layer for the Capsules framework.  It handles all the details of launching and monitoring runtime environments.

API version: 3.3.7
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package launcher

import (
	"bytes"
	_context "context"
	_ioutil "io/ioutil"
	_nethttp "net/http"
	_neturl "net/url"
	"strings"
	"reflect"
)

// Linger please
var (
	_ _context.Context
)

// TerminatedApiService TerminatedApi service
type TerminatedApiService service

type ApiDeleteAllTerminatedRequest struct {
	ctx _context.Context
	ApiService *TerminatedApiService
	owner string
}


func (r ApiDeleteAllTerminatedRequest) Execute() (*_nethttp.Response, error) {
	return r.ApiService.DeleteAllTerminatedExecute(r)
}

/*
DeleteAllTerminated Removes all terminated environments belonging to the given owner

 @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param owner The username of the user whose resources that you wish to access
 @return ApiDeleteAllTerminatedRequest
*/
func (a *TerminatedApiService) DeleteAllTerminated(ctx _context.Context, owner string) ApiDeleteAllTerminatedRequest {
	return ApiDeleteAllTerminatedRequest{
		ApiService: a,
		ctx: ctx,
		owner: owner,
	}
}

// Execute executes the request
func (a *TerminatedApiService) DeleteAllTerminatedExecute(r ApiDeleteAllTerminatedRequest) (*_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TerminatedApiService.DeleteAllTerminated")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/terminated/{owner}"
	localVarPath = strings.Replace(localVarPath, "{"+"owner"+"}", _neturl.PathEscape(parameterToString(r.owner, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiDeleteTerminatedRequest struct {
	ctx _context.Context
	ApiService *TerminatedApiService
	owner string
	environment string
}


func (r ApiDeleteTerminatedRequest) Execute() (*_nethttp.Response, error) {
	return r.ApiService.DeleteTerminatedExecute(r)
}

/*
DeleteTerminated Removes a terminated environment

 @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param owner The username of the user whose resources that you wish to access
 @param environment The environment that you wish to access
 @return ApiDeleteTerminatedRequest
*/
func (a *TerminatedApiService) DeleteTerminated(ctx _context.Context, owner string, environment string) ApiDeleteTerminatedRequest {
	return ApiDeleteTerminatedRequest{
		ApiService: a,
		ctx: ctx,
		owner: owner,
		environment: environment,
	}
}

// Execute executes the request
func (a *TerminatedApiService) DeleteTerminatedExecute(r ApiDeleteTerminatedRequest) (*_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TerminatedApiService.DeleteTerminated")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/terminated/{owner}/environments/{environment}"
	localVarPath = strings.Replace(localVarPath, "{"+"owner"+"}", _neturl.PathEscape(parameterToString(r.owner, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"environment"+"}", _neturl.PathEscape(parameterToString(r.environment, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiGetTerminatedRequest struct {
	ctx _context.Context
	ApiService *TerminatedApiService
	owner string
	environment string
}


func (r ApiGetTerminatedRequest) Execute() (Manifest, *_nethttp.Response, error) {
	return r.ApiService.GetTerminatedExecute(r)
}

/*
GetTerminated Gets a specific terminated environment launched by the given owner

 @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param owner The username of the user whose resources that you wish to access
 @param environment The environment that you wish to access
 @return ApiGetTerminatedRequest
*/
func (a *TerminatedApiService) GetTerminated(ctx _context.Context, owner string, environment string) ApiGetTerminatedRequest {
	return ApiGetTerminatedRequest{
		ApiService: a,
		ctx: ctx,
		owner: owner,
		environment: environment,
	}
}

// Execute executes the request
//  @return Manifest
func (a *TerminatedApiService) GetTerminatedExecute(r ApiGetTerminatedRequest) (Manifest, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  Manifest
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TerminatedApiService.GetTerminated")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/terminated/{owner}/environments/{environment}"
	localVarPath = strings.Replace(localVarPath, "{"+"owner"+"}", _neturl.PathEscape(parameterToString(r.owner, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"environment"+"}", _neturl.PathEscape(parameterToString(r.environment, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json", "application/yaml"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiGetTerminatedACLsRequest struct {
	ctx _context.Context
	ApiService *TerminatedApiService
	owner string
}


func (r ApiGetTerminatedACLsRequest) Execute() (ACLS, *_nethttp.Response, error) {
	return r.ApiService.GetTerminatedACLsExecute(r)
}

/*
GetTerminatedACLs Gets the ACLs that control who can manage the terminated environments belonging to the given owner

 @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param owner The username of the user whose resources that you wish to access
 @return ApiGetTerminatedACLsRequest
*/
func (a *TerminatedApiService) GetTerminatedACLs(ctx _context.Context, owner string) ApiGetTerminatedACLsRequest {
	return ApiGetTerminatedACLsRequest{
		ApiService: a,
		ctx: ctx,
		owner: owner,
	}
}

// Execute executes the request
//  @return ACLS
func (a *TerminatedApiService) GetTerminatedACLsExecute(r ApiGetTerminatedACLsRequest) (ACLS, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  ACLS
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TerminatedApiService.GetTerminatedACLs")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/terminated/{owner}/acls"
	localVarPath = strings.Replace(localVarPath, "{"+"owner"+"}", _neturl.PathEscape(parameterToString(r.owner, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json", "application/yaml"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiListAllTerminatedRequest struct {
	ctx _context.Context
	ApiService *TerminatedApiService
	limit *int32
	offset *int32
	reverse *bool
	eventLimit *int32
	state *[]DispatchState
}

// Number of results to limit to, used in conjunction with offset to page through results
func (r ApiListAllTerminatedRequest) Limit(limit int32) ApiListAllTerminatedRequest {
	r.limit = &limit
	return r
}
// Number of results to offset by, used in conjunction with limit to page through results
func (r ApiListAllTerminatedRequest) Offset(offset int32) ApiListAllTerminatedRequest {
	r.offset = &offset
	return r
}
// Whether to reverse the default sort order in the returned results
func (r ApiListAllTerminatedRequest) Reverse(reverse bool) ApiListAllTerminatedRequest {
	r.reverse = &reverse
	return r
}
// Number of events to limit to per DispatchInfo
func (r ApiListAllTerminatedRequest) EventLimit(eventLimit int32) ApiListAllTerminatedRequest {
	r.eventLimit = &eventLimit
	return r
}
// Results must be in the given state(s)
func (r ApiListAllTerminatedRequest) State(state []DispatchState) ApiListAllTerminatedRequest {
	r.state = &state
	return r
}

func (r ApiListAllTerminatedRequest) Execute() (map[string][]DispatchInfo, *_nethttp.Response, error) {
	return r.ApiService.ListAllTerminatedExecute(r)
}

/*
ListAllTerminated Gets all terminated environments that the user can view

 @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiListAllTerminatedRequest
*/
func (a *TerminatedApiService) ListAllTerminated(ctx _context.Context) ApiListAllTerminatedRequest {
	return ApiListAllTerminatedRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return map[string][]DispatchInfo
func (a *TerminatedApiService) ListAllTerminatedExecute(r ApiListAllTerminatedRequest) (map[string][]DispatchInfo, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  map[string][]DispatchInfo
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TerminatedApiService.ListAllTerminated")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/terminated"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.limit != nil {
		localVarQueryParams.Add("limit", parameterToString(*r.limit, ""))
	}
	if r.offset != nil {
		localVarQueryParams.Add("offset", parameterToString(*r.offset, ""))
	}
	if r.reverse != nil {
		localVarQueryParams.Add("reverse", parameterToString(*r.reverse, ""))
	}
	if r.eventLimit != nil {
		localVarQueryParams.Add("eventLimit", parameterToString(*r.eventLimit, ""))
	}
	if r.state != nil {
		t := *r.state
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				localVarQueryParams.Add("state", parameterToString(s.Index(i), "multi"))
			}
		} else {
			localVarQueryParams.Add("state", parameterToString(t, "multi"))
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json", "application/yaml"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiListOwnedTerminatedRequest struct {
	ctx _context.Context
	ApiService *TerminatedApiService
	owner string
	limit *int32
	offset *int32
	reverse *bool
	eventLimit *int32
	state *[]DispatchState
}

// Number of results to limit to, used in conjunction with offset to page through results
func (r ApiListOwnedTerminatedRequest) Limit(limit int32) ApiListOwnedTerminatedRequest {
	r.limit = &limit
	return r
}
// Number of results to offset by, used in conjunction with limit to page through results
func (r ApiListOwnedTerminatedRequest) Offset(offset int32) ApiListOwnedTerminatedRequest {
	r.offset = &offset
	return r
}
// Whether to reverse the default sort order in the returned results
func (r ApiListOwnedTerminatedRequest) Reverse(reverse bool) ApiListOwnedTerminatedRequest {
	r.reverse = &reverse
	return r
}
// Number of events to limit to per DispatchInfo
func (r ApiListOwnedTerminatedRequest) EventLimit(eventLimit int32) ApiListOwnedTerminatedRequest {
	r.eventLimit = &eventLimit
	return r
}
// Results must be in the given state(s)
func (r ApiListOwnedTerminatedRequest) State(state []DispatchState) ApiListOwnedTerminatedRequest {
	r.state = &state
	return r
}

func (r ApiListOwnedTerminatedRequest) Execute() (map[string][]DispatchInfo, *_nethttp.Response, error) {
	return r.ApiService.ListOwnedTerminatedExecute(r)
}

/*
ListOwnedTerminated Gets all terminated environments belonging to the given owner

 @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param owner The username of the user whose resources that you wish to access
 @return ApiListOwnedTerminatedRequest
*/
func (a *TerminatedApiService) ListOwnedTerminated(ctx _context.Context, owner string) ApiListOwnedTerminatedRequest {
	return ApiListOwnedTerminatedRequest{
		ApiService: a,
		ctx: ctx,
		owner: owner,
	}
}

// Execute executes the request
//  @return map[string][]DispatchInfo
func (a *TerminatedApiService) ListOwnedTerminatedExecute(r ApiListOwnedTerminatedRequest) (map[string][]DispatchInfo, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  map[string][]DispatchInfo
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TerminatedApiService.ListOwnedTerminated")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/terminated/{owner}"
	localVarPath = strings.Replace(localVarPath, "{"+"owner"+"}", _neturl.PathEscape(parameterToString(r.owner, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.limit != nil {
		localVarQueryParams.Add("limit", parameterToString(*r.limit, ""))
	}
	if r.offset != nil {
		localVarQueryParams.Add("offset", parameterToString(*r.offset, ""))
	}
	if r.reverse != nil {
		localVarQueryParams.Add("reverse", parameterToString(*r.reverse, ""))
	}
	if r.eventLimit != nil {
		localVarQueryParams.Add("eventLimit", parameterToString(*r.eventLimit, ""))
	}
	if r.state != nil {
		t := *r.state
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				localVarQueryParams.Add("state", parameterToString(s.Index(i), "multi"))
			}
		} else {
			localVarQueryParams.Add("state", parameterToString(t, "multi"))
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json", "application/yaml"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiSetTerminatedACLsRequest struct {
	ctx _context.Context
	ApiService *TerminatedApiService
	owner string
	aCLS *ACLS
}

// The ACLs to set
func (r ApiSetTerminatedACLsRequest) ACLS(aCLS ACLS) ApiSetTerminatedACLsRequest {
	r.aCLS = &aCLS
	return r
}

func (r ApiSetTerminatedACLsRequest) Execute() (*_nethttp.Response, error) {
	return r.ApiService.SetTerminatedACLsExecute(r)
}

/*
SetTerminatedACLs Sets the ACLs that control who can manage the terminated environments belonging to the given owner

 @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param owner The username of the user whose resources that you wish to access
 @return ApiSetTerminatedACLsRequest
*/
func (a *TerminatedApiService) SetTerminatedACLs(ctx _context.Context, owner string) ApiSetTerminatedACLsRequest {
	return ApiSetTerminatedACLsRequest{
		ApiService: a,
		ctx: ctx,
		owner: owner,
	}
}

// Execute executes the request
func (a *TerminatedApiService) SetTerminatedACLsExecute(r ApiSetTerminatedACLsRequest) (*_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "TerminatedApiService.SetTerminatedACLs")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/terminated/{owner}/acls"
	localVarPath = strings.Replace(localVarPath, "{"+"owner"+"}", _neturl.PathEscape(parameterToString(r.owner, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.aCLS == nil {
		return nil, reportError("aCLS is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/yaml"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.aCLS
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}
