/*
Launcher API

The Launcher API is the execution layer for the Capsules framework.  It handles all the details of launching and monitoring runtime environments.

API version: 3.3.7
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package launcher

import (
	"bytes"
	_context "context"
	_ioutil "io/ioutil"
	_nethttp "net/http"
	_neturl "net/url"
	"strings"
	"reflect"
)

// Linger please
var (
	_ _context.Context
)

// RunningApiService RunningApi service
type RunningApiService service

type ApiGetRunningRequest struct {
	ctx _context.Context
	ApiService *RunningApiService
	owner string
	environment string
}


func (r ApiGetRunningRequest) Execute() (Manifest, *_nethttp.Response, error) {
	return r.ApiService.GetRunningExecute(r)
}

/*
GetRunning Gets a specific running environment launched by the given owner

 @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param owner The username of the user whose resources that you wish to access
 @param environment The environment that you wish to access
 @return ApiGetRunningRequest
*/
func (a *RunningApiService) GetRunning(ctx _context.Context, owner string, environment string) ApiGetRunningRequest {
	return ApiGetRunningRequest{
		ApiService: a,
		ctx: ctx,
		owner: owner,
		environment: environment,
	}
}

// Execute executes the request
//  @return Manifest
func (a *RunningApiService) GetRunningExecute(r ApiGetRunningRequest) (Manifest, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  Manifest
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RunningApiService.GetRunning")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/running/{owner}/environments/{environment}"
	localVarPath = strings.Replace(localVarPath, "{"+"owner"+"}", _neturl.PathEscape(parameterToString(r.owner, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"environment"+"}", _neturl.PathEscape(parameterToString(r.environment, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json", "application/yaml"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiGetRunningACLsRequest struct {
	ctx _context.Context
	ApiService *RunningApiService
	owner string
}


func (r ApiGetRunningACLsRequest) Execute() (ACLS, *_nethttp.Response, error) {
	return r.ApiService.GetRunningACLsExecute(r)
}

/*
GetRunningACLs Gets the ACLs that control who can manage the running environments belonging to the given owner

 @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param owner The username of the user whose resources that you wish to access
 @return ApiGetRunningACLsRequest
*/
func (a *RunningApiService) GetRunningACLs(ctx _context.Context, owner string) ApiGetRunningACLsRequest {
	return ApiGetRunningACLsRequest{
		ApiService: a,
		ctx: ctx,
		owner: owner,
	}
}

// Execute executes the request
//  @return ACLS
func (a *RunningApiService) GetRunningACLsExecute(r ApiGetRunningACLsRequest) (ACLS, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  ACLS
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RunningApiService.GetRunningACLs")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/running/{owner}/acls"
	localVarPath = strings.Replace(localVarPath, "{"+"owner"+"}", _neturl.PathEscape(parameterToString(r.owner, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json", "application/yaml"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiGetUserInterfacesRequest struct {
	ctx _context.Context
	ApiService *RunningApiService
	owner string
	environment string
}


func (r ApiGetUserInterfacesRequest) Execute() (map[string][]UserInterface, *_nethttp.Response, error) {
	return r.ApiService.GetUserInterfacesExecute(r)
}

/*
GetUserInterfaces Gets the User Interfaces associated with the running environment launched by the given owner

 @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param owner The username of the user whose resources that you wish to access
 @param environment The environment that you wish to access
 @return ApiGetUserInterfacesRequest
*/
func (a *RunningApiService) GetUserInterfaces(ctx _context.Context, owner string, environment string) ApiGetUserInterfacesRequest {
	return ApiGetUserInterfacesRequest{
		ApiService: a,
		ctx: ctx,
		owner: owner,
		environment: environment,
	}
}

// Execute executes the request
//  @return map[string][]UserInterface
func (a *RunningApiService) GetUserInterfacesExecute(r ApiGetUserInterfacesRequest) (map[string][]UserInterface, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  map[string][]UserInterface
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RunningApiService.GetUserInterfaces")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/running/{owner}/environments/{environment}/uis"
	localVarPath = strings.Replace(localVarPath, "{"+"owner"+"}", _neturl.PathEscape(parameterToString(r.owner, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"environment"+"}", _neturl.PathEscape(parameterToString(r.environment, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json", "application/yaml"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiListAllRunningRequest struct {
	ctx _context.Context
	ApiService *RunningApiService
	limit *int32
	offset *int32
	reverse *bool
	eventLimit *int32
	state *[]DispatchState
}

// Number of results to limit to, used in conjunction with offset to page through results
func (r ApiListAllRunningRequest) Limit(limit int32) ApiListAllRunningRequest {
	r.limit = &limit
	return r
}
// Number of results to offset by, used in conjunction with limit to page through results
func (r ApiListAllRunningRequest) Offset(offset int32) ApiListAllRunningRequest {
	r.offset = &offset
	return r
}
// Whether to reverse the default sort order in the returned results
func (r ApiListAllRunningRequest) Reverse(reverse bool) ApiListAllRunningRequest {
	r.reverse = &reverse
	return r
}
// Number of events to limit to per DispatchInfo
func (r ApiListAllRunningRequest) EventLimit(eventLimit int32) ApiListAllRunningRequest {
	r.eventLimit = &eventLimit
	return r
}
// Results must be in the given state(s)
func (r ApiListAllRunningRequest) State(state []DispatchState) ApiListAllRunningRequest {
	r.state = &state
	return r
}

func (r ApiListAllRunningRequest) Execute() (map[string][]DispatchInfo, *_nethttp.Response, error) {
	return r.ApiService.ListAllRunningExecute(r)
}

/*
ListAllRunning Gets all running environments that the user can view

 @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiListAllRunningRequest
*/
func (a *RunningApiService) ListAllRunning(ctx _context.Context) ApiListAllRunningRequest {
	return ApiListAllRunningRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return map[string][]DispatchInfo
func (a *RunningApiService) ListAllRunningExecute(r ApiListAllRunningRequest) (map[string][]DispatchInfo, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  map[string][]DispatchInfo
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RunningApiService.ListAllRunning")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/running"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.limit != nil {
		localVarQueryParams.Add("limit", parameterToString(*r.limit, ""))
	}
	if r.offset != nil {
		localVarQueryParams.Add("offset", parameterToString(*r.offset, ""))
	}
	if r.reverse != nil {
		localVarQueryParams.Add("reverse", parameterToString(*r.reverse, ""))
	}
	if r.eventLimit != nil {
		localVarQueryParams.Add("eventLimit", parameterToString(*r.eventLimit, ""))
	}
	if r.state != nil {
		t := *r.state
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				localVarQueryParams.Add("state", parameterToString(s.Index(i), "multi"))
			}
		} else {
			localVarQueryParams.Add("state", parameterToString(t, "multi"))
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json", "application/yaml"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiListOwnedRunningRequest struct {
	ctx _context.Context
	ApiService *RunningApiService
	owner string
	limit *int32
	offset *int32
	reverse *bool
	eventLimit *int32
	state *[]DispatchState
}

// Number of results to limit to, used in conjunction with offset to page through results
func (r ApiListOwnedRunningRequest) Limit(limit int32) ApiListOwnedRunningRequest {
	r.limit = &limit
	return r
}
// Number of results to offset by, used in conjunction with limit to page through results
func (r ApiListOwnedRunningRequest) Offset(offset int32) ApiListOwnedRunningRequest {
	r.offset = &offset
	return r
}
// Whether to reverse the default sort order in the returned results
func (r ApiListOwnedRunningRequest) Reverse(reverse bool) ApiListOwnedRunningRequest {
	r.reverse = &reverse
	return r
}
// Number of events to limit to per DispatchInfo
func (r ApiListOwnedRunningRequest) EventLimit(eventLimit int32) ApiListOwnedRunningRequest {
	r.eventLimit = &eventLimit
	return r
}
// Results must be in the given state(s)
func (r ApiListOwnedRunningRequest) State(state []DispatchState) ApiListOwnedRunningRequest {
	r.state = &state
	return r
}

func (r ApiListOwnedRunningRequest) Execute() (map[string][]DispatchInfo, *_nethttp.Response, error) {
	return r.ApiService.ListOwnedRunningExecute(r)
}

/*
ListOwnedRunning Gets all running environments launched by the given owner

 @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param owner The username of the user whose resources that you wish to access
 @return ApiListOwnedRunningRequest
*/
func (a *RunningApiService) ListOwnedRunning(ctx _context.Context, owner string) ApiListOwnedRunningRequest {
	return ApiListOwnedRunningRequest{
		ApiService: a,
		ctx: ctx,
		owner: owner,
	}
}

// Execute executes the request
//  @return map[string][]DispatchInfo
func (a *RunningApiService) ListOwnedRunningExecute(r ApiListOwnedRunningRequest) (map[string][]DispatchInfo, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  map[string][]DispatchInfo
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RunningApiService.ListOwnedRunning")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/running/{owner}"
	localVarPath = strings.Replace(localVarPath, "{"+"owner"+"}", _neturl.PathEscape(parameterToString(r.owner, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.limit != nil {
		localVarQueryParams.Add("limit", parameterToString(*r.limit, ""))
	}
	if r.offset != nil {
		localVarQueryParams.Add("offset", parameterToString(*r.offset, ""))
	}
	if r.reverse != nil {
		localVarQueryParams.Add("reverse", parameterToString(*r.reverse, ""))
	}
	if r.eventLimit != nil {
		localVarQueryParams.Add("eventLimit", parameterToString(*r.eventLimit, ""))
	}
	if r.state != nil {
		t := *r.state
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				localVarQueryParams.Add("state", parameterToString(s.Index(i), "multi"))
			}
		} else {
			localVarQueryParams.Add("state", parameterToString(t, "multi"))
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json", "application/yaml"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiSetRunningACLsRequest struct {
	ctx _context.Context
	ApiService *RunningApiService
	owner string
	aCLS *ACLS
}

// The ACLs to set
func (r ApiSetRunningACLsRequest) ACLS(aCLS ACLS) ApiSetRunningACLsRequest {
	r.aCLS = &aCLS
	return r
}

func (r ApiSetRunningACLsRequest) Execute() (*_nethttp.Response, error) {
	return r.ApiService.SetRunningACLsExecute(r)
}

/*
SetRunningACLs Sets the ACLs that control who can manage the running environments belonging to the given owner

 @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param owner The username of the user whose resources that you wish to access
 @return ApiSetRunningACLsRequest
*/
func (a *RunningApiService) SetRunningACLs(ctx _context.Context, owner string) ApiSetRunningACLsRequest {
	return ApiSetRunningACLsRequest{
		ApiService: a,
		ctx: ctx,
		owner: owner,
	}
}

// Execute executes the request
func (a *RunningApiService) SetRunningACLsExecute(r ApiSetRunningACLsRequest) (*_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RunningApiService.SetRunningACLs")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/running/{owner}/acls"
	localVarPath = strings.Replace(localVarPath, "{"+"owner"+"}", _neturl.PathEscape(parameterToString(r.owner, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.aCLS == nil {
		return nil, reportError("aCLS is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/yaml"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.aCLS
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiTerminateAllRunningRequest struct {
	ctx _context.Context
	ApiService *RunningApiService
	owner string
	force *bool
}

// Whether to force termination
func (r ApiTerminateAllRunningRequest) Force(force bool) ApiTerminateAllRunningRequest {
	r.force = &force
	return r
}

func (r ApiTerminateAllRunningRequest) Execute() (*_nethttp.Response, error) {
	return r.ApiService.TerminateAllRunningExecute(r)
}

/*
TerminateAllRunning Terminates all running environments owned by the given owner

 @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param owner The username of the user whose resources that you wish to access
 @return ApiTerminateAllRunningRequest
*/
func (a *RunningApiService) TerminateAllRunning(ctx _context.Context, owner string) ApiTerminateAllRunningRequest {
	return ApiTerminateAllRunningRequest{
		ApiService: a,
		ctx: ctx,
		owner: owner,
	}
}

// Execute executes the request
func (a *RunningApiService) TerminateAllRunningExecute(r ApiTerminateAllRunningRequest) (*_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RunningApiService.TerminateAllRunning")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/running/{owner}"
	localVarPath = strings.Replace(localVarPath, "{"+"owner"+"}", _neturl.PathEscape(parameterToString(r.owner, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.force != nil {
		localVarQueryParams.Add("force", parameterToString(*r.force, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiTerminateRunningRequest struct {
	ctx _context.Context
	ApiService *RunningApiService
	owner string
	environment string
	force *bool
}

// Whether to force termination
func (r ApiTerminateRunningRequest) Force(force bool) ApiTerminateRunningRequest {
	r.force = &force
	return r
}

func (r ApiTerminateRunningRequest) Execute() (DispatchInfo, *_nethttp.Response, error) {
	return r.ApiService.TerminateRunningExecute(r)
}

/*
TerminateRunning Terminates a running environment

 @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param owner The username of the user whose resources that you wish to access
 @param environment The environment that you wish to access
 @return ApiTerminateRunningRequest
*/
func (a *RunningApiService) TerminateRunning(ctx _context.Context, owner string, environment string) ApiTerminateRunningRequest {
	return ApiTerminateRunningRequest{
		ApiService: a,
		ctx: ctx,
		owner: owner,
		environment: environment,
	}
}

// Execute executes the request
//  @return DispatchInfo
func (a *RunningApiService) TerminateRunningExecute(r ApiTerminateRunningRequest) (DispatchInfo, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  DispatchInfo
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RunningApiService.TerminateRunning")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/running/{owner}/environments/{environment}"
	localVarPath = strings.Replace(localVarPath, "{"+"owner"+"}", _neturl.PathEscape(parameterToString(r.owner, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"environment"+"}", _neturl.PathEscape(parameterToString(r.environment, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.force != nil {
		localVarQueryParams.Add("force", parameterToString(*r.force, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json", "application/yaml"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiTerminateRunningAsyncRequest struct {
	ctx _context.Context
	ApiService *RunningApiService
	owner string
	environment string
	force *bool
}

// Whether to force termination
func (r ApiTerminateRunningAsyncRequest) Force(force bool) ApiTerminateRunningAsyncRequest {
	r.force = &force
	return r
}

func (r ApiTerminateRunningAsyncRequest) Execute() (DispatchInfo, *_nethttp.Response, error) {
	return r.ApiService.TerminateRunningAsyncExecute(r)
}

/*
TerminateRunningAsync Terminates a running environment in an asynchronous manner

 @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param owner The username of the user whose resources that you wish to access
 @param environment The environment that you wish to access
 @return ApiTerminateRunningAsyncRequest
*/
func (a *RunningApiService) TerminateRunningAsync(ctx _context.Context, owner string, environment string) ApiTerminateRunningAsyncRequest {
	return ApiTerminateRunningAsyncRequest{
		ApiService: a,
		ctx: ctx,
		owner: owner,
		environment: environment,
	}
}

// Execute executes the request
//  @return DispatchInfo
func (a *RunningApiService) TerminateRunningAsyncExecute(r ApiTerminateRunningAsyncRequest) (DispatchInfo, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  DispatchInfo
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RunningApiService.TerminateRunningAsync")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/running/{owner}/environments/{environment}/async"
	localVarPath = strings.Replace(localVarPath, "{"+"owner"+"}", _neturl.PathEscape(parameterToString(r.owner, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"environment"+"}", _neturl.PathEscape(parameterToString(r.environment, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.force != nil {
		localVarQueryParams.Add("force", parameterToString(*r.force, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json", "application/yaml"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
