/*
Launcher API

The Launcher API is the execution layer for the Capsules framework.  It handles all the details of launching and monitoring runtime environments.

API version: 3.3.7
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package launcher

import (
	"bytes"
	_context "context"
	_ioutil "io/ioutil"
	_nethttp "net/http"
	_neturl "net/url"
	"strings"
)

// Linger please
var (
	_ _context.Context
)

// MonitoringApiService MonitoringApi service
type MonitoringApiService service

type ApiCanManageEnvironmentRequest struct {
	ctx _context.Context
	ApiService *MonitoringApiService
	owner string
	environment string
}


func (r ApiCanManageEnvironmentRequest) Execute() (DispatchManagementStatus, *_nethttp.Response, error) {
	return r.ApiService.CanManageEnvironmentExecute(r)
}

/*
CanManageEnvironment Gets the management status of the environment

 @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param owner The username of the user whose resources that you wish to access
 @param environment The environment that you wish to access
 @return ApiCanManageEnvironmentRequest
*/
func (a *MonitoringApiService) CanManageEnvironment(ctx _context.Context, owner string, environment string) ApiCanManageEnvironmentRequest {
	return ApiCanManageEnvironmentRequest{
		ApiService: a,
		ctx: ctx,
		owner: owner,
		environment: environment,
	}
}

// Execute executes the request
//  @return DispatchManagementStatus
func (a *MonitoringApiService) CanManageEnvironmentExecute(r ApiCanManageEnvironmentRequest) (DispatchManagementStatus, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  DispatchManagementStatus
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "MonitoringApiService.CanManageEnvironment")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/monitoring/{owner}/environments/{environment}/management"
	localVarPath = strings.Replace(localVarPath, "{"+"owner"+"}", _neturl.PathEscape(parameterToString(r.owner, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"environment"+"}", _neturl.PathEscape(parameterToString(r.environment, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json", "application/yaml"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiDeleteEnvironmentRequest struct {
	ctx _context.Context
	ApiService *MonitoringApiService
	owner string
	environment string
}


func (r ApiDeleteEnvironmentRequest) Execute() (*_nethttp.Response, error) {
	return r.ApiService.DeleteEnvironmentExecute(r)
}

/*
DeleteEnvironment Deletes an environment regardless of status (destructive) which is not the same as terminating it, the environment may still be running but no longer visible to the dispatch server after this operation succeeds

 @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param owner The username of the user whose resources that you wish to access
 @param environment The environment that you wish to access
 @return ApiDeleteEnvironmentRequest
*/
func (a *MonitoringApiService) DeleteEnvironment(ctx _context.Context, owner string, environment string) ApiDeleteEnvironmentRequest {
	return ApiDeleteEnvironmentRequest{
		ApiService: a,
		ctx: ctx,
		owner: owner,
		environment: environment,
	}
}

// Execute executes the request
func (a *MonitoringApiService) DeleteEnvironmentExecute(r ApiDeleteEnvironmentRequest) (*_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "MonitoringApiService.DeleteEnvironment")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/monitoring/{owner}/environments/{environment}/management"
	localVarPath = strings.Replace(localVarPath, "{"+"owner"+"}", _neturl.PathEscape(parameterToString(r.owner, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"environment"+"}", _neturl.PathEscape(parameterToString(r.environment, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiDeleteEnvironmentLogRequest struct {
	ctx _context.Context
	ApiService *MonitoringApiService
	owner string
	environment string
	log string
}


func (r ApiDeleteEnvironmentLogRequest) Execute() (*_nethttp.Response, error) {
	return r.ApiService.DeleteEnvironmentLogExecute(r)
}

/*
DeleteEnvironmentLog Deletes a specific log file for the environment

 @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param owner The username of the user whose resources that you wish to access
 @param environment The environment that you wish to access
 @param log The log file that you wish to access
 @return ApiDeleteEnvironmentLogRequest
*/
func (a *MonitoringApiService) DeleteEnvironmentLog(ctx _context.Context, owner string, environment string, log string) ApiDeleteEnvironmentLogRequest {
	return ApiDeleteEnvironmentLogRequest{
		ApiService: a,
		ctx: ctx,
		owner: owner,
		environment: environment,
		log: log,
	}
}

// Execute executes the request
func (a *MonitoringApiService) DeleteEnvironmentLogExecute(r ApiDeleteEnvironmentLogRequest) (*_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "MonitoringApiService.DeleteEnvironmentLog")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/monitoring/{owner}/environments/{environment}/logs/{log}"
	localVarPath = strings.Replace(localVarPath, "{"+"owner"+"}", _neturl.PathEscape(parameterToString(r.owner, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"environment"+"}", _neturl.PathEscape(parameterToString(r.environment, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"log"+"}", _neturl.PathEscape(parameterToString(r.log, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiDeleteEnvironmentLogsRequest struct {
	ctx _context.Context
	ApiService *MonitoringApiService
	owner string
	environment string
}


func (r ApiDeleteEnvironmentLogsRequest) Execute() (*_nethttp.Response, error) {
	return r.ApiService.DeleteEnvironmentLogsExecute(r)
}

/*
DeleteEnvironmentLogs Deletes all available log files for the environment

 @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param owner The username of the user whose resources that you wish to access
 @param environment The environment that you wish to access
 @return ApiDeleteEnvironmentLogsRequest
*/
func (a *MonitoringApiService) DeleteEnvironmentLogs(ctx _context.Context, owner string, environment string) ApiDeleteEnvironmentLogsRequest {
	return ApiDeleteEnvironmentLogsRequest{
		ApiService: a,
		ctx: ctx,
		owner: owner,
		environment: environment,
	}
}

// Execute executes the request
func (a *MonitoringApiService) DeleteEnvironmentLogsExecute(r ApiDeleteEnvironmentLogsRequest) (*_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "MonitoringApiService.DeleteEnvironmentLogs")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/monitoring/{owner}/environments/{environment}/logs"
	localVarPath = strings.Replace(localVarPath, "{"+"owner"+"}", _neturl.PathEscape(parameterToString(r.owner, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"environment"+"}", _neturl.PathEscape(parameterToString(r.environment, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiGetEnvironmentDetailsRequest struct {
	ctx _context.Context
	ApiService *MonitoringApiService
	owner string
	environment string
}


func (r ApiGetEnvironmentDetailsRequest) Execute() (Manifest, *_nethttp.Response, error) {
	return r.ApiService.GetEnvironmentDetailsExecute(r)
}

/*
GetEnvironmentDetails Gets the current details of the environment

 @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param owner The username of the user whose resources that you wish to access
 @param environment The environment that you wish to access
 @return ApiGetEnvironmentDetailsRequest
*/
func (a *MonitoringApiService) GetEnvironmentDetails(ctx _context.Context, owner string, environment string) ApiGetEnvironmentDetailsRequest {
	return ApiGetEnvironmentDetailsRequest{
		ApiService: a,
		ctx: ctx,
		owner: owner,
		environment: environment,
	}
}

// Execute executes the request
//  @return Manifest
func (a *MonitoringApiService) GetEnvironmentDetailsExecute(r ApiGetEnvironmentDetailsRequest) (Manifest, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  Manifest
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "MonitoringApiService.GetEnvironmentDetails")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/monitoring/{owner}/environments/{environment}"
	localVarPath = strings.Replace(localVarPath, "{"+"owner"+"}", _neturl.PathEscape(parameterToString(r.owner, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"environment"+"}", _neturl.PathEscape(parameterToString(r.environment, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json", "application/yaml"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiGetEnvironmentStatusRequest struct {
	ctx _context.Context
	ApiService *MonitoringApiService
	owner string
	environment string
	eventLimit *int32
	refresh *bool
}

// Number of events to limit to per DispatchInfo
func (r ApiGetEnvironmentStatusRequest) EventLimit(eventLimit int32) ApiGetEnvironmentStatusRequest {
	r.eventLimit = &eventLimit
	return r
}
// Whether to actively refresh information prior to returning it
func (r ApiGetEnvironmentStatusRequest) Refresh(refresh bool) ApiGetEnvironmentStatusRequest {
	r.refresh = &refresh
	return r
}

func (r ApiGetEnvironmentStatusRequest) Execute() (DispatchInfo, *_nethttp.Response, error) {
	return r.ApiService.GetEnvironmentStatusExecute(r)
}

/*
GetEnvironmentStatus Gets the status of an environment

 @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param owner The username of the user whose resources that you wish to access
 @param environment The environment that you wish to access
 @return ApiGetEnvironmentStatusRequest
*/
func (a *MonitoringApiService) GetEnvironmentStatus(ctx _context.Context, owner string, environment string) ApiGetEnvironmentStatusRequest {
	return ApiGetEnvironmentStatusRequest{
		ApiService: a,
		ctx: ctx,
		owner: owner,
		environment: environment,
	}
}

// Execute executes the request
//  @return DispatchInfo
func (a *MonitoringApiService) GetEnvironmentStatusExecute(r ApiGetEnvironmentStatusRequest) (DispatchInfo, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  DispatchInfo
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "MonitoringApiService.GetEnvironmentStatus")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/monitoring/{owner}/environments/{environment}/status"
	localVarPath = strings.Replace(localVarPath, "{"+"owner"+"}", _neturl.PathEscape(parameterToString(r.owner, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"environment"+"}", _neturl.PathEscape(parameterToString(r.environment, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.eventLimit != nil {
		localVarQueryParams.Add("eventLimit", parameterToString(*r.eventLimit, ""))
	}
	if r.refresh != nil {
		localVarQueryParams.Add("refresh", parameterToString(*r.refresh, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json", "application/yaml"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiListEnvironmentLogsRequest struct {
	ctx _context.Context
	ApiService *MonitoringApiService
	owner string
	environment string
}


func (r ApiListEnvironmentLogsRequest) Execute() (map[string][]EnvironmentLogSource, *_nethttp.Response, error) {
	return r.ApiService.ListEnvironmentLogsExecute(r)
}

/*
ListEnvironmentLogs Gets the content of a log file from the environment

 @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param owner The username of the user whose resources that you wish to access
 @param environment The environment that you wish to access
 @return ApiListEnvironmentLogsRequest
*/
func (a *MonitoringApiService) ListEnvironmentLogs(ctx _context.Context, owner string, environment string) ApiListEnvironmentLogsRequest {
	return ApiListEnvironmentLogsRequest{
		ApiService: a,
		ctx: ctx,
		owner: owner,
		environment: environment,
	}
}

// Execute executes the request
//  @return map[string][]EnvironmentLogSource
func (a *MonitoringApiService) ListEnvironmentLogsExecute(r ApiListEnvironmentLogsRequest) (map[string][]EnvironmentLogSource, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  map[string][]EnvironmentLogSource
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "MonitoringApiService.ListEnvironmentLogs")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/monitoring/{owner}/environments/{environment}/logs"
	localVarPath = strings.Replace(localVarPath, "{"+"owner"+"}", _neturl.PathEscape(parameterToString(r.owner, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"environment"+"}", _neturl.PathEscape(parameterToString(r.environment, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json", "application/yaml"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiLoadEnvironmentLogRequest struct {
	ctx _context.Context
	ApiService *MonitoringApiService
	owner string
	environment string
	log string
	ifModifiedSince *string
	ifUnmodifiedSince *string
	range_ *string
	ifRange *string
}

// Makes the request conditional on the resource having been modified since the given date.  If the resource is unmodified a 304 Not Modified is returned.
func (r ApiLoadEnvironmentLogRequest) IfModifiedSince(ifModifiedSince string) ApiLoadEnvironmentLogRequest {
	r.ifModifiedSince = &ifModifiedSince
	return r
}
// Makes the request conditional on the resource having not been modified since the given date.  If the resource has been modified a 412 Precondition Failed is returned.
func (r ApiLoadEnvironmentLogRequest) IfUnmodifiedSince(ifUnmodifiedSince string) ApiLoadEnvironmentLogRequest {
	r.ifUnmodifiedSince = &ifUnmodifiedSince
	return r
}
// Specifies a range of the resource to return instead of the full resource.  Byte based ranges per RFC 7233 are supported, additionally line based ranges are also permitted.  These support the same range syntax as byte ranges except using lines instead of bytes as the unit.  The main difference between byte and line ranges is that byte ranges use zero based indexing whereas line ranges use 1 based indexing.  So a range of 1-5 would be the 2nd through 6th bytes but the 1st through 5th  lines.  Note that per the specification range boundaries are always inclusive.  If a range is statisfiable you will receive a 206 Partial Content response with a Content-Range header indicating the portion of the resource returned.  If the range is unsatisfiable then you will receive a 416 Range Unsatisfiable response.  If the range matches the full size of the content then you will just receive a 200 OK response with the full resource.  Range specifications that are invalid are silently discarded and will just result in the server returning a normal 200 OK response.  Ranges can be specified relative to the start/end of the content per RFC 7233.  Note that when line  ranges are used in this way the returned Content-Range header may not match the lines returned because the server does not know in advance how many lines are in the resource.  However the starting line will always be correct and thus can be used by clients to display line numbers if they so wish.  Note that ONLY a single range may be requested.  If multiple ranges are requested the server will just return the full resource. 
func (r ApiLoadEnvironmentLogRequest) Range_(range_ string) ApiLoadEnvironmentLogRequest {
	r.range_ = &range_
	return r
}
// Make a Range request conditional on the resource having not been modified since the given date.  If the resource has been modified since the given date then the Range request will not be honoured and the full resource will be returned instead.
func (r ApiLoadEnvironmentLogRequest) IfRange(ifRange string) ApiLoadEnvironmentLogRequest {
	r.ifRange = &ifRange
	return r
}

func (r ApiLoadEnvironmentLogRequest) Execute() (string, *_nethttp.Response, error) {
	return r.ApiService.LoadEnvironmentLogExecute(r)
}

/*
LoadEnvironmentLog Gets the available log files for the environment

 @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param owner The username of the user whose resources that you wish to access
 @param environment The environment that you wish to access
 @param log The log file that you wish to access
 @return ApiLoadEnvironmentLogRequest
*/
func (a *MonitoringApiService) LoadEnvironmentLog(ctx _context.Context, owner string, environment string, log string) ApiLoadEnvironmentLogRequest {
	return ApiLoadEnvironmentLogRequest{
		ApiService: a,
		ctx: ctx,
		owner: owner,
		environment: environment,
		log: log,
	}
}

// Execute executes the request
//  @return string
func (a *MonitoringApiService) LoadEnvironmentLogExecute(r ApiLoadEnvironmentLogRequest) (string, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  string
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "MonitoringApiService.LoadEnvironmentLog")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/monitoring/{owner}/environments/{environment}/logs/{log}"
	localVarPath = strings.Replace(localVarPath, "{"+"owner"+"}", _neturl.PathEscape(parameterToString(r.owner, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"environment"+"}", _neturl.PathEscape(parameterToString(r.environment, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"log"+"}", _neturl.PathEscape(parameterToString(r.log, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/octet-stream", "multipart/byteranges"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.ifModifiedSince != nil {
		localVarHeaderParams["If-Modified-Since"] = parameterToString(*r.ifModifiedSince, "")
	}
	if r.ifUnmodifiedSince != nil {
		localVarHeaderParams["If-Unmodified-Since"] = parameterToString(*r.ifUnmodifiedSince, "")
	}
	if r.range_ != nil {
		localVarHeaderParams["Range"] = parameterToString(*r.range_, "")
	}
	if r.ifRange != nil {
		localVarHeaderParams["If-Range"] = parameterToString(*r.ifRange, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
