# Go API client for launcher

The Launcher API is the execution layer for the Capsules framework.  It handles all the details of launching and monitoring runtime environments.

## Overview
This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [OpenAPI-spec](https://www.openapis.org/) from a remote server, you can easily generate an API client.

- API version: 3.3.7
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.GoClientCodegen

## Installation

Install the following dependencies:

```shell
go get github.com/stretchr/testify/assert
go get golang.org/x/oauth2
go get golang.org/x/net/context
```

Put the package under your project folder and add the following in import:

```golang
import sw "./launcher"
```

To use a proxy, set the environment variable `HTTP_PROXY`:

```golang
os.Setenv("HTTP_PROXY", "http://proxy_name:proxy_port")
```

## Configuration of Server URL

Default configuration comes with `Servers` field that contains server objects as defined in the OpenAPI specification.

### Select Server Configuration

For using other server than the one defined on index 0 set context value `sw.ContextServerIndex` of type `int`.

```golang
ctx := context.WithValue(context.Background(), sw.ContextServerIndex, 1)
```

### Templated Server URL

Templated server URL is formatted using default variables from configuration or from context value `sw.ContextServerVariables` of type `map[string]string`.

```golang
ctx := context.WithValue(context.Background(), sw.ContextServerVariables, map[string]string{
	"basePath": "v2",
})
```

Note, enum values are always validated and all unused variables are silently ignored.

### URLs Configuration per Operation

Each operation can use different server URL defined using `OperationServers` map in the `Configuration`.
An operation is uniquely identified by `"{classname}Service.{nickname}"` string.
Similar rules for overriding default operation server index and variables applies by using `sw.ContextOperationServerIndices` and `sw.ContextOperationServerVariables` context maps.

```
ctx := context.WithValue(context.Background(), sw.ContextOperationServerIndices, map[string]int{
	"{classname}Service.{nickname}": 2,
})
ctx = context.WithValue(context.Background(), sw.ContextOperationServerVariables, map[string]map[string]string{
	"{classname}Service.{nickname}": {
		"port": "8443",
	},
})
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AdminApi* | [**GetLoggerLevel**](docs/AdminApi.md#getloggerlevel) | **Get** /admin/loggers/{logger} | Gets the log level for a specific logger
*AdminApi* | [**GetRootLogLevel**](docs/AdminApi.md#getrootloglevel) | **Get** /admin/log-level | Gets the current root log level
*AdminApi* | [**ListAllLoggerLevels**](docs/AdminApi.md#listallloggerlevels) | **Get** /admin/loggers | Gets the log level for all loggers
*AdminApi* | [**SetAllLoggerLevels**](docs/AdminApi.md#setallloggerlevels) | **Put** /admin/loggers | Sets the log level for multiple loggers
*AdminApi* | [**SetLoggerLevel**](docs/AdminApi.md#setloggerlevel) | **Put** /admin/loggers/{logger} | Sets the log level for a specific logger
*AdminApi* | [**SetRootLogLevel**](docs/AdminApi.md#setrootloglevel) | **Put** /admin/log-level | Sets the root log level
*InfoApi* | [**GetApi**](docs/InfoApi.md#getapi) | **Get** /info/api | Gets the API definition
*InfoApi* | [**GetApiVersion**](docs/InfoApi.md#getapiversion) | **Get** /info/version/api | Gets the API version
*InfoApi* | [**GetServerRevision**](docs/InfoApi.md#getserverrevision) | **Get** /info/version/revision | Gets the Server revision
*InfoApi* | [**GetServerVersion**](docs/InfoApi.md#getserverversion) | **Get** /info/version/server | Gets the Server version
*LaunchApi* | [**AddCredential**](docs/LaunchApi.md#addcredential) | **Put** /launch/credentials/{owner}/{name} | Creates/updates a credential that the Dispatch Centre can use to launch environments on behalf of the user
*LaunchApi* | [**HasCredential**](docs/LaunchApi.md#hascredential) | **Head** /launch/credentials/{owner}/{name} | Determines whether a given credential has been provided
*LaunchApi* | [**Launch**](docs/LaunchApi.md#launch) | **Put** /launch | Launches the runtime environment described by the provided manifest in a synchronous manner
*LaunchApi* | [**LaunchAsync**](docs/LaunchApi.md#launchasync) | **Put** /launch/async | Launches the runtime environment described by the provided manifest in an asynchronous manner
*LaunchApi* | [**RemoveCredential**](docs/LaunchApi.md#removecredential) | **Delete** /launch/credentials/{owner}/{name} | Removes a credential
*MonitoringApi* | [**CanManageEnvironment**](docs/MonitoringApi.md#canmanageenvironment) | **Get** /monitoring/{owner}/environments/{environment}/management | Gets the management status of the environment
*MonitoringApi* | [**DeleteEnvironment**](docs/MonitoringApi.md#deleteenvironment) | **Delete** /monitoring/{owner}/environments/{environment}/management | Deletes an environment regardless of status (destructive) which is not the same as terminating it, the environment may still be running but no longer visible to the dispatch server after this operation succeeds
*MonitoringApi* | [**DeleteEnvironmentLog**](docs/MonitoringApi.md#deleteenvironmentlog) | **Delete** /monitoring/{owner}/environments/{environment}/logs/{log} | Deletes a specific log file for the environment
*MonitoringApi* | [**DeleteEnvironmentLogs**](docs/MonitoringApi.md#deleteenvironmentlogs) | **Delete** /monitoring/{owner}/environments/{environment}/logs | Deletes all available log files for the environment
*MonitoringApi* | [**GetEnvironmentDetails**](docs/MonitoringApi.md#getenvironmentdetails) | **Get** /monitoring/{owner}/environments/{environment} | Gets the current details of the environment
*MonitoringApi* | [**GetEnvironmentStatus**](docs/MonitoringApi.md#getenvironmentstatus) | **Get** /monitoring/{owner}/environments/{environment}/status | Gets the status of an environment
*MonitoringApi* | [**ListEnvironmentLogs**](docs/MonitoringApi.md#listenvironmentlogs) | **Get** /monitoring/{owner}/environments/{environment}/logs | Gets the content of a log file from the environment
*MonitoringApi* | [**LoadEnvironmentLog**](docs/MonitoringApi.md#loadenvironmentlog) | **Get** /monitoring/{owner}/environments/{environment}/logs/{log} | Gets the available log files for the environment
*RunningApi* | [**GetRunning**](docs/RunningApi.md#getrunning) | **Get** /running/{owner}/environments/{environment} | Gets a specific running environment launched by the given owner
*RunningApi* | [**GetRunningACLs**](docs/RunningApi.md#getrunningacls) | **Get** /running/{owner}/acls | Gets the ACLs that control who can manage the running environments belonging to the given owner
*RunningApi* | [**GetUserInterfaces**](docs/RunningApi.md#getuserinterfaces) | **Get** /running/{owner}/environments/{environment}/uis | Gets the User Interfaces associated with the running environment launched by the given owner
*RunningApi* | [**ListAllRunning**](docs/RunningApi.md#listallrunning) | **Get** /running | Gets all running environments that the user can view
*RunningApi* | [**ListOwnedRunning**](docs/RunningApi.md#listownedrunning) | **Get** /running/{owner} | Gets all running environments launched by the given owner
*RunningApi* | [**SetRunningACLs**](docs/RunningApi.md#setrunningacls) | **Put** /running/{owner}/acls | Sets the ACLs that control who can manage the running environments belonging to the given owner
*RunningApi* | [**TerminateAllRunning**](docs/RunningApi.md#terminateallrunning) | **Delete** /running/{owner} | Terminates all running environments owned by the given owner
*RunningApi* | [**TerminateRunning**](docs/RunningApi.md#terminaterunning) | **Delete** /running/{owner}/environments/{environment} | Terminates a running environment
*RunningApi* | [**TerminateRunningAsync**](docs/RunningApi.md#terminaterunningasync) | **Delete** /running/{owner}/environments/{environment}/async | Terminates a running environment in an asynchronous manner
*TerminatedApi* | [**DeleteAllTerminated**](docs/TerminatedApi.md#deleteallterminated) | **Delete** /terminated/{owner} | Removes all terminated environments belonging to the given owner
*TerminatedApi* | [**DeleteTerminated**](docs/TerminatedApi.md#deleteterminated) | **Delete** /terminated/{owner}/environments/{environment} | Removes a terminated environment
*TerminatedApi* | [**GetTerminated**](docs/TerminatedApi.md#getterminated) | **Get** /terminated/{owner}/environments/{environment} | Gets a specific terminated environment launched by the given owner
*TerminatedApi* | [**GetTerminatedACLs**](docs/TerminatedApi.md#getterminatedacls) | **Get** /terminated/{owner}/acls | Gets the ACLs that control who can manage the terminated environments belonging to the given owner
*TerminatedApi* | [**ListAllTerminated**](docs/TerminatedApi.md#listallterminated) | **Get** /terminated | Gets all terminated environments that the user can view
*TerminatedApi* | [**ListOwnedTerminated**](docs/TerminatedApi.md#listownedterminated) | **Get** /terminated/{owner} | Gets all terminated environments belonging to the given owner
*TerminatedApi* | [**SetTerminatedACLs**](docs/TerminatedApi.md#setterminatedacls) | **Put** /terminated/{owner}/acls | Sets the ACLs that control who can manage the terminated environments belonging to the given owner


## Documentation For Models

 - [ACLInfo](docs/ACLInfo.md)
 - [ACLS](docs/ACLS.md)
 - [ClientMetadata](docs/ClientMetadata.md)
 - [Data](docs/Data.md)
 - [DispatchInfo](docs/DispatchInfo.md)
 - [DispatchManagementStatus](docs/DispatchManagementStatus.md)
 - [DispatchMetadata](docs/DispatchMetadata.md)
 - [DispatchState](docs/DispatchState.md)
 - [EnvironmentLogSource](docs/EnvironmentLogSource.md)
 - [Event](docs/Event.md)
 - [LaunchParameters](docs/LaunchParameters.md)
 - [LogLevel](docs/LogLevel.md)
 - [Manifest](docs/Manifest.md)
 - [OwnedResourceReference](docs/OwnedResourceReference.md)
 - [Payload](docs/Payload.md)
 - [Problem](docs/Problem.md)
 - [ReferenceProblem](docs/ReferenceProblem.md)
 - [ResourceRequirements](docs/ResourceRequirements.md)
 - [UserInterface](docs/UserInterface.md)
 - [WarehouseMetadata](docs/WarehouseMetadata.md)


## Documentation For Authorization



### BearerAuth

- **Type**: HTTP Bearer token authentication

Example

```golang
auth := context.WithValue(context.Background(), sw.ContextAccessToken, "BEARERTOKENSTRING")
r, err := client.Service.Operation(auth, args)
```


## Documentation for Utility Methods

Due to the fact that model structure members are all pointers, this package contains
a number of utility functions to easily obtain pointers to values of basic types.
Each of these functions takes a value of the given basic type and returns a pointer to it:

* `PtrBool`
* `PtrInt`
* `PtrInt32`
* `PtrInt64`
* `PtrFloat`
* `PtrFloat32`
* `PtrFloat64`
* `PtrString`
* `PtrTime`

## Author



