import pytest

from determined.common.api import bindings
from tests.fixtures import api_responses

_MASTER = "http://localhost:8080"


@pytest.fixture
def single_item_resource_pools() -> bindings.v1GetResourcePoolsResponse:
    sample_resource_pools = api_responses.sample_get_resource_pool()
    single_item_pagination = bindings.v1Pagination(endIndex=1, startIndex=0, total=1)
    return bindings.v1GetResourcePoolsResponse(
        resourcePools=[sample_resource_pools], pagination=single_item_pagination
    )
