# Code generated by stream-gen. DO NOT EDIT.

"""Wire formats for the determined streaming updates subsystem"""

import typing


class ServerMsg:
    @classmethod
    def from_json(cls, obj: typing.Any) -> "ServerMsg":
        return cls(**obj)  # type: ignore

    def to_json(self) -> typing.Dict[str, typing.Any]:
        return dict(vars(self))

    def __repr__(self) -> str:
        body = ", ".join(f"{k}={v}" for k, v in vars(self).items())
        return f"{type(self).__name__}({body})"

    def __eq__(self, other: object) -> bool:
        return isinstance(other, type(self)) and vars(self) == vars(other)


class DeleteMsg:
    def __init__(self, keys: str) -> None:
        self.keys = keys

    @classmethod
    def from_json(cls, keys: str) -> "DeleteMsg":
        return cls(keys)

    def to_json(self) -> str:
        return self.keys

    def __repr__(self) -> str:
        return f"{type(self).__name__}({self.keys})"

    def __eq__(self, other: object) -> bool:
        return isinstance(other, type(self)) and self.keys == other.keys


class ClientMsg:
    def to_json(self) -> typing.Dict[str, typing.Any]:
        return {k: v for k, v in vars(self).items() if v is not None}

    def __repr__(self) -> str:
        body = ", ".join(f"{k}={v}" for k, v in vars(self).items())
        return f"{type(self).__name__}({body})"

    def __eq__(self, other: object) -> bool:
        return isinstance(other, type(self)) and self.to_json() == other.to_json()


class ModelMsg(ServerMsg):
    def __init__(
        self,
        id: "int",
        name: "str",
        description: "str",
        archived: "bool",
        creation_time: "float",
        notes: "str",
        workspace_id: "int",
        user_id: "int",
        last_updated_time: "float",
        metadata: "typing.Any",
        labels: "typing.List[str]",
        seq: "int",
    ) -> None:
        self.id = id
        self.name = name
        self.description = description
        self.archived = archived
        self.creation_time = creation_time
        self.notes = notes
        self.workspace_id = workspace_id
        self.user_id = user_id
        self.last_updated_time = last_updated_time
        self.metadata = metadata
        self.labels = labels
        self.seq = seq


class ModelsDeleted(DeleteMsg):
    pass


class ModelSubscriptionSpec(ClientMsg):
    def __init__(
        self,
        workspace_ids: "typing.Optional[typing.List[int]]" = None,
        model_ids: "typing.Optional[typing.List[int]]" = None,
        user_ids: "typing.Optional[typing.List[int]]" = None,
        since: "typing.Optional[int]" = None,
    ) -> None:
        self.workspace_ids = workspace_ids
        self.model_ids = model_ids
        self.user_ids = user_ids
        self.since = since


class ModelVersionMsg(ServerMsg):
    def __init__(
        self,
        id: "int",
        name: "str",
        version: "int",
        checkpoint_uuid: "str",
        creation_time: "float",
        last_updated_time: "float",
        metadata: "typing.Any",
        model_id: "int",
        user_id: "int",
        comment: "str",
        labels: "typing.List[str]",
        notes: "str",
        workspace_id: "str",
        seq: "int",
    ) -> None:
        self.id = id
        self.name = name
        self.version = version
        self.checkpoint_uuid = checkpoint_uuid
        self.creation_time = creation_time
        self.last_updated_time = last_updated_time
        self.metadata = metadata
        self.model_id = model_id
        self.user_id = user_id
        self.comment = comment
        self.labels = labels
        self.notes = notes
        self.workspace_id = workspace_id
        self.seq = seq


class ModelVersionsDeleted(DeleteMsg):
    pass


class ModelVersionSubscriptionSpec(ClientMsg):
    def __init__(
        self,
        model_ids: "typing.Optional[typing.List[int]]" = None,
        model_version_ids: "typing.Optional[typing.List[int]]" = None,
        user_ids: "typing.Optional[typing.List[int]]" = None,
        since: "typing.Optional[int]" = None,
    ) -> None:
        self.model_ids = model_ids
        self.model_version_ids = model_version_ids
        self.user_ids = user_ids
        self.since = since


class ProjectMsg(ServerMsg):
    def __init__(
        self,
        id: "int",
        name: "str",
        description: "str",
        archived: "bool",
        created_at: "float",
        notes: "typing.Any",
        workspace_id: "int",
        user_id: "int",
        immutable: "bool",
        state: "str",
        key: "str",
        seq: "int",
    ) -> None:
        self.id = id
        self.name = name
        self.description = description
        self.archived = archived
        self.created_at = created_at
        self.notes = notes
        self.workspace_id = workspace_id
        self.user_id = user_id
        self.immutable = immutable
        self.state = state
        self.key = key
        self.seq = seq


class ProjectsDeleted(DeleteMsg):
    pass


class ProjectSubscriptionSpec(ClientMsg):
    def __init__(
        self,
        workspace_ids: "typing.Optional[typing.List[int]]" = None,
        project_ids: "typing.Optional[typing.List[int]]" = None,
        since: "typing.Optional[int]" = None,
    ) -> None:
        self.workspace_ids = workspace_ids
        self.project_ids = project_ids
        self.since = since
