# Code generated by generate_bindings.py. DO NOT EDIT.
import enum
import json
import math
import os
import typing
from urllib import parse

import requests

if typing.TYPE_CHECKING:
    from determined.common import api

# flake8: noqa
Json = typing.Any


# Unset is a type to distinguish between things not set and things set to None.
class Unset:
    pass


_unset = Unset()


def dump_float(val: typing.Any) -> typing.Any:
    if math.isnan(val):
        return "Nan"
    if math.isinf(val):
        return "Infinity" if val > 0 else "-Infinity"
    return val


class APIHttpError(Exception):
    # APIHttpError is used if an HTTP(s) API request fails.
    def __init__(self, operation_name: str, response: requests.Response) -> None:
        self.response = response
        self.operation_name = operation_name
        self.message = (
            f"API Error: {operation_name} failed: {response.reason}."
        )

    def __str__(self) -> str:
        return self.message


class APIHttpStreamError(APIHttpError):
    # APIHttpStreamError is used if an streaming API request fails mid-stream.
    def __init__(self, operation_name: str, error: "runtimeStreamError") -> None:
        self.operation_name = operation_name
        self.error = error
        self.message = (
            f"Stream Error during {operation_name}: {error.message}"
        )

    def __str__(self) -> str:
        return self.message


class DetEnum(enum.Enum):
    def __str__(self) -> str:
        skip = len(self.prefix())
        return f"{self.value[skip:]}"
    @classmethod
    def prefix(cls) -> str:
        prefix: str = os.path.commonprefix([e.value for e in cls])
        return prefix if prefix.endswith("_") else ""


class Printable:
    # A mixin to provide a __str__ method for classes with attributes.
    def __str__(self) -> str:
        allowed_types = (str, int, float, bool, DetEnum)
        attrs = []
        for k, v in self.__dict__.items():
            if v is None: continue
            if isinstance(v, list):
                vals = [str(x) if isinstance(x, allowed_types) else "..." for x in v]
                attrs.append(f'{k}=[{", ".join(vals)}]')
            elif isinstance(v, allowed_types):
                attrs.append(f'{k}={v}')
            else:
                attrs.append(f'{k}=...')
        attrs_str = ', '.join(attrs)
        return f'{self.__class__.__name__}({attrs_str})'



class GetMasterResponseProduct(DetEnum):
    """Different kinds of Determined Cloud offerings
    - PRODUCT_UNSPECIFIED: Not a Cloud Community offering
    - PRODUCT_COMMUNITY: Determined Cloud, Community Edition
    """
    UNSPECIFIED = "PRODUCT_UNSPECIFIED"
    COMMUNITY = "PRODUCT_COMMUNITY"

class GetTrialWorkloadsRequestFilterOption(DetEnum):
    """Filter workloads with training, validation, and checkpoint information.
    - FILTER_OPTION_UNSPECIFIED: Any workload.
    - FILTER_OPTION_CHECKPOINT: Only workloads with an associated checkpoint.
    - FILTER_OPTION_VALIDATION: Only validation workloads.
    - FILTER_OPTION_CHECKPOINT_OR_VALIDATION: Only validation workloads or ones with an associated checkpoint.
    """
    UNSPECIFIED = "FILTER_OPTION_UNSPECIFIED"
    CHECKPOINT = "FILTER_OPTION_CHECKPOINT"
    VALIDATION = "FILTER_OPTION_VALIDATION"
    CHECKPOINT_OR_VALIDATION = "FILTER_OPTION_CHECKPOINT_OR_VALIDATION"

class HealthCheck(Printable):
    database: "typing.Optional[HealthStatus]" = None
    resource_managers: "typing.Optional[typing.Sequence[ResourceManagerHealth]]" = None
    status: "typing.Optional[HealthStatus]" = None

    def __init__(
        self,
        *,
        database: "typing.Union[HealthStatus, None, Unset]" = _unset,
        resource_managers: "typing.Union[typing.Sequence[ResourceManagerHealth], None, Unset]" = _unset,
        status: "typing.Union[HealthStatus, None, Unset]" = _unset,
    ):
        if not isinstance(database, Unset):
            self.database = database
        if not isinstance(resource_managers, Unset):
            self.resource_managers = resource_managers
        if not isinstance(status, Unset):
            self.status = status

    @classmethod
    def from_json(cls, obj: Json) -> "HealthCheck":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "database" in obj:
            kwargs["database"] = HealthStatus(obj["database"]) if obj["database"] is not None else None
        if "resource_managers" in obj:
            kwargs["resource_managers"] = [ResourceManagerHealth.from_json(x) for x in obj["resource_managers"]] if obj["resource_managers"] is not None else None
        if "status" in obj:
            kwargs["status"] = HealthStatus(obj["status"]) if obj["status"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "database" in vars(self):
            out["database"] = None if self.database is None else self.database.value
        if not omit_unset or "resource_managers" in vars(self):
            out["resource_managers"] = None if self.resource_managers is None else [x.to_json(omit_unset) for x in self.resource_managers]
        if not omit_unset or "status" in vars(self):
            out["status"] = None if self.status is None else self.status.value
        return out

class HealthStatus(DetEnum):
    up = "up"
    down = "down"

class PatchCheckpointOptionalResources(Printable):
    """Gets around not being able to do "Optional map<string, int64>".
    Not ideal but this API is marked internal for now.
    """
    resources: "typing.Optional[typing.Dict[str, str]]" = None

    def __init__(
        self,
        *,
        resources: "typing.Union[typing.Dict[str, str], None, Unset]" = _unset,
    ):
        if not isinstance(resources, Unset):
            self.resources = resources

    @classmethod
    def from_json(cls, obj: Json) -> "PatchCheckpointOptionalResources":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "resources" in obj:
            kwargs["resources"] = obj["resources"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "resources" in vars(self):
            out["resources"] = self.resources
        return out

class PatchExperimentPatchCheckpointStorage(Printable):
    """Nested object for checkpoint_storage field patch."""
    saveExperimentBest: "typing.Optional[int]" = None
    saveTrialBest: "typing.Optional[int]" = None
    saveTrialLatest: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        saveExperimentBest: "typing.Union[int, None, Unset]" = _unset,
        saveTrialBest: "typing.Union[int, None, Unset]" = _unset,
        saveTrialLatest: "typing.Union[int, None, Unset]" = _unset,
    ):
        if not isinstance(saveExperimentBest, Unset):
            self.saveExperimentBest = saveExperimentBest
        if not isinstance(saveTrialBest, Unset):
            self.saveTrialBest = saveTrialBest
        if not isinstance(saveTrialLatest, Unset):
            self.saveTrialLatest = saveTrialLatest

    @classmethod
    def from_json(cls, obj: Json) -> "PatchExperimentPatchCheckpointStorage":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "saveExperimentBest" in obj:
            kwargs["saveExperimentBest"] = obj["saveExperimentBest"]
        if "saveTrialBest" in obj:
            kwargs["saveTrialBest"] = obj["saveTrialBest"]
        if "saveTrialLatest" in obj:
            kwargs["saveTrialLatest"] = obj["saveTrialLatest"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "saveExperimentBest" in vars(self):
            out["saveExperimentBest"] = self.saveExperimentBest
        if not omit_unset or "saveTrialBest" in vars(self):
            out["saveTrialBest"] = self.saveTrialBest
        if not omit_unset or "saveTrialLatest" in vars(self):
            out["saveTrialLatest"] = self.saveTrialLatest
        return out

class PatchExperimentPatchResources(Printable):
    """Nested object for resources field patch."""
    maxSlots: "typing.Optional[int]" = None
    priority: "typing.Optional[int]" = None
    weight: "typing.Optional[float]" = None

    def __init__(
        self,
        *,
        maxSlots: "typing.Union[int, None, Unset]" = _unset,
        priority: "typing.Union[int, None, Unset]" = _unset,
        weight: "typing.Union[float, None, Unset]" = _unset,
    ):
        if not isinstance(maxSlots, Unset):
            self.maxSlots = maxSlots
        if not isinstance(priority, Unset):
            self.priority = priority
        if not isinstance(weight, Unset):
            self.weight = weight

    @classmethod
    def from_json(cls, obj: Json) -> "PatchExperimentPatchResources":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "maxSlots" in obj:
            kwargs["maxSlots"] = obj["maxSlots"]
        if "priority" in obj:
            kwargs["priority"] = obj["priority"]
        if "weight" in obj:
            kwargs["weight"] = float(obj["weight"]) if obj["weight"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "maxSlots" in vars(self):
            out["maxSlots"] = self.maxSlots
        if not omit_unset or "priority" in vars(self):
            out["priority"] = self.priority
        if not omit_unset or "weight" in vars(self):
            out["weight"] = None if self.weight is None else dump_float(self.weight)
        return out

class ResourceManagerHealth(Printable):
    cluster_name: "typing.Optional[str]" = None
    status: "typing.Optional[HealthStatus]" = None

    def __init__(
        self,
        *,
        cluster_name: "typing.Union[str, None, Unset]" = _unset,
        status: "typing.Union[HealthStatus, None, Unset]" = _unset,
    ):
        if not isinstance(cluster_name, Unset):
            self.cluster_name = cluster_name
        if not isinstance(status, Unset):
            self.status = status

    @classmethod
    def from_json(cls, obj: Json) -> "ResourceManagerHealth":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "cluster_name" in obj:
            kwargs["cluster_name"] = obj["cluster_name"]
        if "status" in obj:
            kwargs["status"] = HealthStatus(obj["status"]) if obj["status"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "cluster_name" in vars(self):
            out["cluster_name"] = self.cluster_name
        if not omit_unset or "status" in vars(self):
            out["status"] = None if self.status is None else self.status.value
        return out

class ResourcesSummaryDevices(Printable):
    """A wrapper message of a list of devices."""
    devices: "typing.Optional[typing.Sequence[v1Device]]" = None

    def __init__(
        self,
        *,
        devices: "typing.Union[typing.Sequence[v1Device], None, Unset]" = _unset,
    ):
        if not isinstance(devices, Unset):
            self.devices = devices

    @classmethod
    def from_json(cls, obj: Json) -> "ResourcesSummaryDevices":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "devices" in obj:
            kwargs["devices"] = [v1Device.from_json(x) for x in obj["devices"]] if obj["devices"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "devices" in vars(self):
            out["devices"] = None if self.devices is None else [x.to_json(omit_unset) for x in self.devices]
        return out

class TrialProfilerMetricLabelsProfilerMetricType(DetEnum):
    """To distinguish the 2 different categories of metrics.
    - PROFILER_METRIC_TYPE_UNSPECIFIED: Zero-value (not allowed).
    - PROFILER_METRIC_TYPE_SYSTEM: For systems metrics, like GPU utilization or memory.
    - PROFILER_METRIC_TYPE_TIMING: For timing metrics, like how long a backwards pass or getting a batch
    from the dataloader took.
    - PROFILER_METRIC_TYPE_MISC: For other miscellaneous metrics.
    """
    UNSPECIFIED = "PROFILER_METRIC_TYPE_UNSPECIFIED"
    SYSTEM = "PROFILER_METRIC_TYPE_SYSTEM"
    TIMING = "PROFILER_METRIC_TYPE_TIMING"
    MISC = "PROFILER_METRIC_TYPE_MISC"

class checkpointv1SortBy(DetEnum):
    """Sorts options for checkpoints by the given field.
    - SORT_BY_UNSPECIFIED: Returns checkpoints in an unsorted list.
    - SORT_BY_UUID: Returns checkpoints sorted by UUID.
    - SORT_BY_TRIAL_ID: Returns checkpoints sorted by trial id.
    - SORT_BY_BATCH_NUMBER: Returns checkpoints sorted by batch number.
    - SORT_BY_END_TIME: Returns checkpoints sorted by end time.
    - SORT_BY_STATE: Returns checkpoints sorted by state.
    - SORT_BY_SEARCHER_METRIC: Returns checkpoints sorted by the experiment's `searcher.metric`
    configuration setting.
    """
    UNSPECIFIED = "SORT_BY_UNSPECIFIED"
    UUID = "SORT_BY_UUID"
    TRIAL_ID = "SORT_BY_TRIAL_ID"
    BATCH_NUMBER = "SORT_BY_BATCH_NUMBER"
    END_TIME = "SORT_BY_END_TIME"
    STATE = "SORT_BY_STATE"
    SEARCHER_METRIC = "SORT_BY_SEARCHER_METRIC"

class checkpointv1State(DetEnum):
    """The current state of the checkpoint.
    - STATE_UNSPECIFIED: The state of the checkpoint is unknown.
    - STATE_ACTIVE: The checkpoint is in an active state.
    - STATE_COMPLETED: The checkpoint is persisted to checkpoint storage.
    - STATE_ERROR: The checkpoint errored.
    - STATE_DELETED: The checkpoint has been deleted.
    - STATE_PARTIALLY_DELETED: The checkpoint has been partially deleted.
    """
    UNSPECIFIED = "STATE_UNSPECIFIED"
    ACTIVE = "STATE_ACTIVE"
    COMPLETED = "STATE_COMPLETED"
    ERROR = "STATE_ERROR"
    DELETED = "STATE_DELETED"
    PARTIALLY_DELETED = "STATE_PARTIALLY_DELETED"

class containerv1State(DetEnum):
    """The current state of the container.
    - STATE_UNSPECIFIED: The container state is unknown.
    - STATE_ASSIGNED: The container has been assigned to an agent but has not started yet.
    - STATE_PULLING: The container's base image is being pulled from the Docker registry.
    - STATE_STARTING: The image has been built and the container is being started, but the
    service in the container is not ready yet.
    - STATE_RUNNING: The service in the container is able to accept requests.
    - STATE_TERMINATED: The container has completely exited or the container has been aborted prior
    to getting assigned.
    """
    UNSPECIFIED = "STATE_UNSPECIFIED"
    ASSIGNED = "STATE_ASSIGNED"
    PULLING = "STATE_PULLING"
    STARTING = "STATE_STARTING"
    RUNNING = "STATE_RUNNING"
    TERMINATED = "STATE_TERMINATED"

class devicev1Type(DetEnum):
    """The type of the Device.
    - TYPE_UNSPECIFIED: An unspecified device type.
    - TYPE_CPU: A CPU device.
    - TYPE_CUDA: CUDA device.
    - TYPE_ROCM: ROCM.
    """
    UNSPECIFIED = "TYPE_UNSPECIFIED"
    CPU = "TYPE_CPU"
    CUDA = "TYPE_CUDA"
    ROCM = "TYPE_ROCM"

class experimentv1State(DetEnum):
    """The current state of the experiment.
    - STATE_UNSPECIFIED: The state of the experiment is unknown.
    - STATE_ACTIVE: The experiment is in an active state.
    - STATE_PAUSED: The experiment is in a paused state
    - STATE_STOPPING_COMPLETED: The experiment is completed and is shutting down.
    - STATE_STOPPING_CANCELED: The experiment is canceled and is shutting down.
    - STATE_STOPPING_ERROR: The experiment is errored and is shutting down.
    - STATE_COMPLETED: The experiment is completed and is shut down.
    - STATE_CANCELED: The experiment is canceled and is shut down.
    - STATE_ERROR: The experiment is errored and is shut down.
    - STATE_DELETED: The experiment has been deleted.
    - STATE_DELETING: The experiment is deleting.
    - STATE_DELETE_FAILED: The experiment failed to delete.
    - STATE_STOPPING_KILLED: The experiment is killed and is shutting down.
    - STATE_QUEUED: The experiment is queued (waiting to be run, or job state is still queued).
    Queued is a substate of the Active state.
    - STATE_PULLING: The experiment is pulling the image. Pulling is a substate of the Active
    state.
    - STATE_STARTING: The experiment is preparing the environment after finishing pulling the
    image. Starting is a substate of the Active state.
    - STATE_RUNNING: The experiment has an allocation actively running.
    Running is a substate of the Active state.
    """
    UNSPECIFIED = "STATE_UNSPECIFIED"
    ACTIVE = "STATE_ACTIVE"
    PAUSED = "STATE_PAUSED"
    STOPPING_COMPLETED = "STATE_STOPPING_COMPLETED"
    STOPPING_CANCELED = "STATE_STOPPING_CANCELED"
    STOPPING_ERROR = "STATE_STOPPING_ERROR"
    COMPLETED = "STATE_COMPLETED"
    CANCELED = "STATE_CANCELED"
    ERROR = "STATE_ERROR"
    DELETED = "STATE_DELETED"
    DELETING = "STATE_DELETING"
    DELETE_FAILED = "STATE_DELETE_FAILED"
    STOPPING_KILLED = "STATE_STOPPING_KILLED"
    QUEUED = "STATE_QUEUED"
    PULLING = "STATE_PULLING"
    STARTING = "STATE_STARTING"
    RUNNING = "STATE_RUNNING"

class jobv1State(DetEnum):
    """Job state.
    - STATE_UNSPECIFIED: Unspecified state.
    - STATE_QUEUED: Job is queued and waiting to be schedlued.
    - STATE_SCHEDULED: Job is scheduled.
    - STATE_SCHEDULED_BACKFILLED: Job is scheduled as a backfill.
    """
    UNSPECIFIED = "STATE_UNSPECIFIED"
    QUEUED = "STATE_QUEUED"
    SCHEDULED = "STATE_SCHEDULED"
    SCHEDULED_BACKFILLED = "STATE_SCHEDULED_BACKFILLED"

class jobv1Type(DetEnum):
    """Job type.
    - TYPE_UNSPECIFIED: Unspecified state.
    - TYPE_EXPERIMENT: Experiement Job.
    - TYPE_NOTEBOOK: Jupyter Notebook Job.
    - TYPE_TENSORBOARD: TensorBoard Job.
    - TYPE_SHELL: Shell Job.
    - TYPE_COMMAND: Command Job.
    - TYPE_CHECKPOINT_GC: CheckpointGC Job.
    - TYPE_EXTERNAL: External Job.
    - TYPE_GENERIC: Generic Job.
    """
    UNSPECIFIED = "TYPE_UNSPECIFIED"
    EXPERIMENT = "TYPE_EXPERIMENT"
    NOTEBOOK = "TYPE_NOTEBOOK"
    TENSORBOARD = "TYPE_TENSORBOARD"
    SHELL = "TYPE_SHELL"
    COMMAND = "TYPE_COMMAND"
    CHECKPOINT_GC = "TYPE_CHECKPOINT_GC"
    EXTERNAL = "TYPE_EXTERNAL"
    GENERIC = "TYPE_GENERIC"

class protobufAny(Printable):
    """https://developers.google.com/protocol-buffers/docs/reference/java/com/google/protobuf/Any"""
    typeUrl: "typing.Optional[str]" = None
    value: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        typeUrl: "typing.Union[str, None, Unset]" = _unset,
        value: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(typeUrl, Unset):
            self.typeUrl = typeUrl
        if not isinstance(value, Unset):
            self.value = value

    @classmethod
    def from_json(cls, obj: Json) -> "protobufAny":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "typeUrl" in obj:
            kwargs["typeUrl"] = obj["typeUrl"]
        if "value" in obj:
            kwargs["value"] = obj["value"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "typeUrl" in vars(self):
            out["typeUrl"] = self.typeUrl
        if not omit_unset or "value" in vars(self):
            out["value"] = self.value
        return out

class protobufFieldMask(Printable):
    """https://protobuf.dev/reference/java/api-docs/com/google/protobuf/FieldMask"""
    paths: "typing.Optional[typing.Sequence[str]]" = None

    def __init__(
        self,
        *,
        paths: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
    ):
        if not isinstance(paths, Unset):
            self.paths = paths

    @classmethod
    def from_json(cls, obj: Json) -> "protobufFieldMask":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "paths" in obj:
            kwargs["paths"] = obj["paths"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "paths" in vars(self):
            out["paths"] = self.paths
        return out

class protobufNullValue(DetEnum):
    """`NullValue` is a singleton enumeration to represent the null value for the
    `Value` type union.
    The JSON representation for `NullValue` is JSON `null`.
    - NULL_VALUE: Null value.
    """
    NULL_VALUE = "NULL_VALUE"

class runtimeError(Printable):
    code: "typing.Optional[int]" = None
    details: "typing.Optional[typing.Sequence[protobufAny]]" = None
    error: "typing.Optional[str]" = None
    message: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        code: "typing.Union[int, None, Unset]" = _unset,
        details: "typing.Union[typing.Sequence[protobufAny], None, Unset]" = _unset,
        error: "typing.Union[str, None, Unset]" = _unset,
        message: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(code, Unset):
            self.code = code
        if not isinstance(details, Unset):
            self.details = details
        if not isinstance(error, Unset):
            self.error = error
        if not isinstance(message, Unset):
            self.message = message

    @classmethod
    def from_json(cls, obj: Json) -> "runtimeError":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "code" in obj:
            kwargs["code"] = obj["code"]
        if "details" in obj:
            kwargs["details"] = [protobufAny.from_json(x) for x in obj["details"]] if obj["details"] is not None else None
        if "error" in obj:
            kwargs["error"] = obj["error"]
        if "message" in obj:
            kwargs["message"] = obj["message"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "code" in vars(self):
            out["code"] = self.code
        if not omit_unset or "details" in vars(self):
            out["details"] = None if self.details is None else [x.to_json(omit_unset) for x in self.details]
        if not omit_unset or "error" in vars(self):
            out["error"] = self.error
        if not omit_unset or "message" in vars(self):
            out["message"] = self.message
        return out

class runtimeStreamError(Printable):
    details: "typing.Optional[typing.Sequence[protobufAny]]" = None
    grpcCode: "typing.Optional[int]" = None
    httpCode: "typing.Optional[int]" = None
    httpStatus: "typing.Optional[str]" = None
    message: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        details: "typing.Union[typing.Sequence[protobufAny], None, Unset]" = _unset,
        grpcCode: "typing.Union[int, None, Unset]" = _unset,
        httpCode: "typing.Union[int, None, Unset]" = _unset,
        httpStatus: "typing.Union[str, None, Unset]" = _unset,
        message: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(details, Unset):
            self.details = details
        if not isinstance(grpcCode, Unset):
            self.grpcCode = grpcCode
        if not isinstance(httpCode, Unset):
            self.httpCode = httpCode
        if not isinstance(httpStatus, Unset):
            self.httpStatus = httpStatus
        if not isinstance(message, Unset):
            self.message = message

    @classmethod
    def from_json(cls, obj: Json) -> "runtimeStreamError":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "details" in obj:
            kwargs["details"] = [protobufAny.from_json(x) for x in obj["details"]] if obj["details"] is not None else None
        if "grpcCode" in obj:
            kwargs["grpcCode"] = obj["grpcCode"]
        if "httpCode" in obj:
            kwargs["httpCode"] = obj["httpCode"]
        if "httpStatus" in obj:
            kwargs["httpStatus"] = obj["httpStatus"]
        if "message" in obj:
            kwargs["message"] = obj["message"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "details" in vars(self):
            out["details"] = None if self.details is None else [x.to_json(omit_unset) for x in self.details]
        if not omit_unset or "grpcCode" in vars(self):
            out["grpcCode"] = self.grpcCode
        if not omit_unset or "httpCode" in vars(self):
            out["httpCode"] = self.httpCode
        if not omit_unset or "httpStatus" in vars(self):
            out["httpStatus"] = self.httpStatus
        if not omit_unset or "message" in vars(self):
            out["message"] = self.message
        return out

class taskv1State(DetEnum):
    """The current state of the task.
    - STATE_UNSPECIFIED: The task state is unknown.
    - STATE_PULLING: The task's base image is being pulled from the Docker registry.
    - STATE_STARTING: The image has been pulled and the task is being started, but the task is
    not ready yet.
    - STATE_RUNNING: The service in the task is running.
    - STATE_TERMINATED: The task has exited or has been aborted.
    - STATE_TERMINATING: The task has begun to exit.
    - STATE_WAITING: The task is waiting on something to complete.
    - STATE_QUEUED: Additional state to cover queueing operations.
    """
    UNSPECIFIED = "STATE_UNSPECIFIED"
    PULLING = "STATE_PULLING"
    STARTING = "STATE_STARTING"
    RUNNING = "STATE_RUNNING"
    TERMINATED = "STATE_TERMINATED"
    TERMINATING = "STATE_TERMINATING"
    WAITING = "STATE_WAITING"
    QUEUED = "STATE_QUEUED"

class trialv1State(DetEnum):
    """The current state of the trial. see \dT+ trial_state in db
    - STATE_UNSPECIFIED: The trial is in an unspecified state.
    - STATE_ACTIVE: The trial is in an active state.
    - STATE_PAUSED: The trial is in a paused state
    - STATE_STOPPING_CANCELED: The trial is canceled and is shutting down.
    - STATE_STOPPING_KILLED: The trial is killed and is shutting down.
    - STATE_STOPPING_COMPLETED: The trial is completed and is shutting down.
    - STATE_STOPPING_ERROR: The trial is errored and is shutting down.
    - STATE_CANCELED: The trial is canceled and is shut down.
    - STATE_COMPLETED: The trial is completed and is shut down.
    - STATE_ERROR: The trial is errored and is shut down.
    - STATE_QUEUED: The trial is queued (waiting to be run, or job state is still queued).
    Queued is a substate of the Active state.
    - STATE_PULLING: The trial is pulling the image. Pulling is a substate of the Active
    state.
    - STATE_STARTING: The trial is preparing the environment after finishing pulling the
    image. Starting is a substate of the Active state.
    - STATE_RUNNING: The trial's allocation is actively running.
    Running is a substate of the Active state.
    """
    UNSPECIFIED = "STATE_UNSPECIFIED"
    ACTIVE = "STATE_ACTIVE"
    PAUSED = "STATE_PAUSED"
    STOPPING_CANCELED = "STATE_STOPPING_CANCELED"
    STOPPING_KILLED = "STATE_STOPPING_KILLED"
    STOPPING_COMPLETED = "STATE_STOPPING_COMPLETED"
    STOPPING_ERROR = "STATE_STOPPING_ERROR"
    CANCELED = "STATE_CANCELED"
    COMPLETED = "STATE_COMPLETED"
    ERROR = "STATE_ERROR"
    QUEUED = "STATE_QUEUED"
    PULLING = "STATE_PULLING"
    STARTING = "STATE_STARTING"
    RUNNING = "STATE_RUNNING"

class trialv1Trial(Printable):
    """Trial is a set of workloads and are exploring a determined set of
    hyperparameters.
    """
    bestCheckpoint: "typing.Optional[v1CheckpointWorkload]" = None
    bestValidation: "typing.Optional[v1MetricsWorkload]" = None
    checkpointCount: "typing.Optional[int]" = None
    endTime: "typing.Optional[str]" = None
    latestValidation: "typing.Optional[v1MetricsWorkload]" = None
    logPolicyMatched: "typing.Optional[str]" = None
    logRetentionDays: "typing.Optional[int]" = None
    metadata: "typing.Optional[typing.Dict[str, typing.Any]]" = None
    runnerState: "typing.Optional[str]" = None
    searcherMetricValue: "typing.Optional[float]" = None
    summaryMetrics: "typing.Optional[typing.Dict[str, typing.Any]]" = None
    taskId: "typing.Optional[str]" = None
    taskIds: "typing.Optional[typing.Sequence[str]]" = None
    totalCheckpointSize: "typing.Optional[str]" = None
    wallClockTime: "typing.Optional[float]" = None
    warmStartCheckpointUuid: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        experimentId: int,
        hparams: "typing.Dict[str, typing.Any]",
        id: int,
        restarts: int,
        startTime: str,
        state: "trialv1State",
        totalBatchesProcessed: int,
        bestCheckpoint: "typing.Union[v1CheckpointWorkload, None, Unset]" = _unset,
        bestValidation: "typing.Union[v1MetricsWorkload, None, Unset]" = _unset,
        checkpointCount: "typing.Union[int, None, Unset]" = _unset,
        endTime: "typing.Union[str, None, Unset]" = _unset,
        latestValidation: "typing.Union[v1MetricsWorkload, None, Unset]" = _unset,
        logPolicyMatched: "typing.Union[str, None, Unset]" = _unset,
        logRetentionDays: "typing.Union[int, None, Unset]" = _unset,
        metadata: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
        runnerState: "typing.Union[str, None, Unset]" = _unset,
        searcherMetricValue: "typing.Union[float, None, Unset]" = _unset,
        summaryMetrics: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
        taskId: "typing.Union[str, None, Unset]" = _unset,
        taskIds: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
        totalCheckpointSize: "typing.Union[str, None, Unset]" = _unset,
        wallClockTime: "typing.Union[float, None, Unset]" = _unset,
        warmStartCheckpointUuid: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.experimentId = experimentId
        self.hparams = hparams
        self.id = id
        self.restarts = restarts
        self.startTime = startTime
        self.state = state
        self.totalBatchesProcessed = totalBatchesProcessed
        if not isinstance(bestCheckpoint, Unset):
            self.bestCheckpoint = bestCheckpoint
        if not isinstance(bestValidation, Unset):
            self.bestValidation = bestValidation
        if not isinstance(checkpointCount, Unset):
            self.checkpointCount = checkpointCount
        if not isinstance(endTime, Unset):
            self.endTime = endTime
        if not isinstance(latestValidation, Unset):
            self.latestValidation = latestValidation
        if not isinstance(logPolicyMatched, Unset):
            self.logPolicyMatched = logPolicyMatched
        if not isinstance(logRetentionDays, Unset):
            self.logRetentionDays = logRetentionDays
        if not isinstance(metadata, Unset):
            self.metadata = metadata
        if not isinstance(runnerState, Unset):
            self.runnerState = runnerState
        if not isinstance(searcherMetricValue, Unset):
            self.searcherMetricValue = searcherMetricValue
        if not isinstance(summaryMetrics, Unset):
            self.summaryMetrics = summaryMetrics
        if not isinstance(taskId, Unset):
            self.taskId = taskId
        if not isinstance(taskIds, Unset):
            self.taskIds = taskIds
        if not isinstance(totalCheckpointSize, Unset):
            self.totalCheckpointSize = totalCheckpointSize
        if not isinstance(wallClockTime, Unset):
            self.wallClockTime = wallClockTime
        if not isinstance(warmStartCheckpointUuid, Unset):
            self.warmStartCheckpointUuid = warmStartCheckpointUuid

    @classmethod
    def from_json(cls, obj: Json) -> "trialv1Trial":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "experimentId": obj["experimentId"],
            "hparams": obj["hparams"],
            "id": obj["id"],
            "restarts": obj["restarts"],
            "startTime": obj["startTime"],
            "state": trialv1State(obj["state"]),
            "totalBatchesProcessed": obj["totalBatchesProcessed"],
        }
        if "bestCheckpoint" in obj:
            kwargs["bestCheckpoint"] = v1CheckpointWorkload.from_json(obj["bestCheckpoint"]) if obj["bestCheckpoint"] is not None else None
        if "bestValidation" in obj:
            kwargs["bestValidation"] = v1MetricsWorkload.from_json(obj["bestValidation"]) if obj["bestValidation"] is not None else None
        if "checkpointCount" in obj:
            kwargs["checkpointCount"] = obj["checkpointCount"]
        if "endTime" in obj:
            kwargs["endTime"] = obj["endTime"]
        if "latestValidation" in obj:
            kwargs["latestValidation"] = v1MetricsWorkload.from_json(obj["latestValidation"]) if obj["latestValidation"] is not None else None
        if "logPolicyMatched" in obj:
            kwargs["logPolicyMatched"] = obj["logPolicyMatched"]
        if "logRetentionDays" in obj:
            kwargs["logRetentionDays"] = obj["logRetentionDays"]
        if "metadata" in obj:
            kwargs["metadata"] = obj["metadata"]
        if "runnerState" in obj:
            kwargs["runnerState"] = obj["runnerState"]
        if "searcherMetricValue" in obj:
            kwargs["searcherMetricValue"] = float(obj["searcherMetricValue"]) if obj["searcherMetricValue"] is not None else None
        if "summaryMetrics" in obj:
            kwargs["summaryMetrics"] = obj["summaryMetrics"]
        if "taskId" in obj:
            kwargs["taskId"] = obj["taskId"]
        if "taskIds" in obj:
            kwargs["taskIds"] = obj["taskIds"]
        if "totalCheckpointSize" in obj:
            kwargs["totalCheckpointSize"] = obj["totalCheckpointSize"]
        if "wallClockTime" in obj:
            kwargs["wallClockTime"] = float(obj["wallClockTime"]) if obj["wallClockTime"] is not None else None
        if "warmStartCheckpointUuid" in obj:
            kwargs["warmStartCheckpointUuid"] = obj["warmStartCheckpointUuid"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "experimentId": self.experimentId,
            "hparams": self.hparams,
            "id": self.id,
            "restarts": self.restarts,
            "startTime": self.startTime,
            "state": self.state.value,
            "totalBatchesProcessed": self.totalBatchesProcessed,
        }
        if not omit_unset or "bestCheckpoint" in vars(self):
            out["bestCheckpoint"] = None if self.bestCheckpoint is None else self.bestCheckpoint.to_json(omit_unset)
        if not omit_unset or "bestValidation" in vars(self):
            out["bestValidation"] = None if self.bestValidation is None else self.bestValidation.to_json(omit_unset)
        if not omit_unset or "checkpointCount" in vars(self):
            out["checkpointCount"] = self.checkpointCount
        if not omit_unset or "endTime" in vars(self):
            out["endTime"] = self.endTime
        if not omit_unset or "latestValidation" in vars(self):
            out["latestValidation"] = None if self.latestValidation is None else self.latestValidation.to_json(omit_unset)
        if not omit_unset or "logPolicyMatched" in vars(self):
            out["logPolicyMatched"] = self.logPolicyMatched
        if not omit_unset or "logRetentionDays" in vars(self):
            out["logRetentionDays"] = self.logRetentionDays
        if not omit_unset or "metadata" in vars(self):
            out["metadata"] = self.metadata
        if not omit_unset or "runnerState" in vars(self):
            out["runnerState"] = self.runnerState
        if not omit_unset or "searcherMetricValue" in vars(self):
            out["searcherMetricValue"] = None if self.searcherMetricValue is None else dump_float(self.searcherMetricValue)
        if not omit_unset or "summaryMetrics" in vars(self):
            out["summaryMetrics"] = self.summaryMetrics
        if not omit_unset or "taskId" in vars(self):
            out["taskId"] = self.taskId
        if not omit_unset or "taskIds" in vars(self):
            out["taskIds"] = self.taskIds
        if not omit_unset or "totalCheckpointSize" in vars(self):
            out["totalCheckpointSize"] = self.totalCheckpointSize
        if not omit_unset or "wallClockTime" in vars(self):
            out["wallClockTime"] = None if self.wallClockTime is None else dump_float(self.wallClockTime)
        if not omit_unset or "warmStartCheckpointUuid" in vars(self):
            out["warmStartCheckpointUuid"] = self.warmStartCheckpointUuid
        return out

class v1AcceleratorData(Printable):
    acceleratorType: "typing.Optional[str]" = None
    acceleratorUuids: "typing.Optional[typing.Sequence[str]]" = None
    allocationId: "typing.Optional[str]" = None
    containerId: "typing.Optional[str]" = None
    nodeName: "typing.Optional[str]" = None
    resourcePool: "typing.Optional[str]" = None
    taskId: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        acceleratorType: "typing.Union[str, None, Unset]" = _unset,
        acceleratorUuids: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
        allocationId: "typing.Union[str, None, Unset]" = _unset,
        containerId: "typing.Union[str, None, Unset]" = _unset,
        nodeName: "typing.Union[str, None, Unset]" = _unset,
        resourcePool: "typing.Union[str, None, Unset]" = _unset,
        taskId: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(acceleratorType, Unset):
            self.acceleratorType = acceleratorType
        if not isinstance(acceleratorUuids, Unset):
            self.acceleratorUuids = acceleratorUuids
        if not isinstance(allocationId, Unset):
            self.allocationId = allocationId
        if not isinstance(containerId, Unset):
            self.containerId = containerId
        if not isinstance(nodeName, Unset):
            self.nodeName = nodeName
        if not isinstance(resourcePool, Unset):
            self.resourcePool = resourcePool
        if not isinstance(taskId, Unset):
            self.taskId = taskId

    @classmethod
    def from_json(cls, obj: Json) -> "v1AcceleratorData":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "acceleratorType" in obj:
            kwargs["acceleratorType"] = obj["acceleratorType"]
        if "acceleratorUuids" in obj:
            kwargs["acceleratorUuids"] = obj["acceleratorUuids"]
        if "allocationId" in obj:
            kwargs["allocationId"] = obj["allocationId"]
        if "containerId" in obj:
            kwargs["containerId"] = obj["containerId"]
        if "nodeName" in obj:
            kwargs["nodeName"] = obj["nodeName"]
        if "resourcePool" in obj:
            kwargs["resourcePool"] = obj["resourcePool"]
        if "taskId" in obj:
            kwargs["taskId"] = obj["taskId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "acceleratorType" in vars(self):
            out["acceleratorType"] = self.acceleratorType
        if not omit_unset or "acceleratorUuids" in vars(self):
            out["acceleratorUuids"] = self.acceleratorUuids
        if not omit_unset or "allocationId" in vars(self):
            out["allocationId"] = self.allocationId
        if not omit_unset or "containerId" in vars(self):
            out["containerId"] = self.containerId
        if not omit_unset or "nodeName" in vars(self):
            out["nodeName"] = self.nodeName
        if not omit_unset or "resourcePool" in vars(self):
            out["resourcePool"] = self.resourcePool
        if not omit_unset or "taskId" in vars(self):
            out["taskId"] = self.taskId
        return out

class v1AckAllocationPreemptionSignalRequest(Printable):
    """Acknowledge the receipt of some stop signal."""

    def __init__(
        self,
        *,
        allocationId: str,
    ):
        self.allocationId = allocationId

    @classmethod
    def from_json(cls, obj: Json) -> "v1AckAllocationPreemptionSignalRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "allocationId": obj["allocationId"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "allocationId": self.allocationId,
        }
        return out

class v1ActivateExperimentsRequest(Printable):
    """Activate multiple experiments."""
    filters: "typing.Optional[v1BulkExperimentFilters]" = None

    def __init__(
        self,
        *,
        experimentIds: "typing.Sequence[int]",
        projectId: int,
        filters: "typing.Union[v1BulkExperimentFilters, None, Unset]" = _unset,
    ):
        self.experimentIds = experimentIds
        self.projectId = projectId
        if not isinstance(filters, Unset):
            self.filters = filters

    @classmethod
    def from_json(cls, obj: Json) -> "v1ActivateExperimentsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "experimentIds": obj["experimentIds"],
            "projectId": obj["projectId"],
        }
        if "filters" in obj:
            kwargs["filters"] = v1BulkExperimentFilters.from_json(obj["filters"]) if obj["filters"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "experimentIds": self.experimentIds,
            "projectId": self.projectId,
        }
        if not omit_unset or "filters" in vars(self):
            out["filters"] = None if self.filters is None else self.filters.to_json(omit_unset)
        return out

class v1ActivateExperimentsResponse(Printable):
    """Response to ActivateExperimentsRequest."""

    def __init__(
        self,
        *,
        results: "typing.Sequence[v1ExperimentActionResult]",
    ):
        self.results = results

    @classmethod
    def from_json(cls, obj: Json) -> "v1ActivateExperimentsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "results": [v1ExperimentActionResult.from_json(x) for x in obj["results"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "results": [x.to_json(omit_unset) for x in self.results],
        }
        return out

class v1ActivityType(DetEnum):
    """ActivityType represents a user activity
    - ACTIVITY_TYPE_UNSPECIFIED: Default activity type.
    - ACTIVITY_TYPE_GET: Represents a get request.
    """
    UNSPECIFIED = "ACTIVITY_TYPE_UNSPECIFIED"
    GET = "ACTIVITY_TYPE_GET"

class v1AddProjectNoteResponse(Printable):
    """Response to AddProjectNoteRequest."""

    def __init__(
        self,
        *,
        notes: "typing.Sequence[v1Note]",
    ):
        self.notes = notes

    @classmethod
    def from_json(cls, obj: Json) -> "v1AddProjectNoteResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "notes": [v1Note.from_json(x) for x in obj["notes"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "notes": [x.to_json(omit_unset) for x in self.notes],
        }
        return out

class v1Address(Printable):
    """Address represents an exposed port on a container."""
    containerIp: "typing.Optional[str]" = None
    containerPort: "typing.Optional[int]" = None
    hostIp: "typing.Optional[str]" = None
    hostPort: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        containerIp: "typing.Union[str, None, Unset]" = _unset,
        containerPort: "typing.Union[int, None, Unset]" = _unset,
        hostIp: "typing.Union[str, None, Unset]" = _unset,
        hostPort: "typing.Union[int, None, Unset]" = _unset,
    ):
        if not isinstance(containerIp, Unset):
            self.containerIp = containerIp
        if not isinstance(containerPort, Unset):
            self.containerPort = containerPort
        if not isinstance(hostIp, Unset):
            self.hostIp = hostIp
        if not isinstance(hostPort, Unset):
            self.hostPort = hostPort

    @classmethod
    def from_json(cls, obj: Json) -> "v1Address":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "containerIp" in obj:
            kwargs["containerIp"] = obj["containerIp"]
        if "containerPort" in obj:
            kwargs["containerPort"] = obj["containerPort"]
        if "hostIp" in obj:
            kwargs["hostIp"] = obj["hostIp"]
        if "hostPort" in obj:
            kwargs["hostPort"] = obj["hostPort"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "containerIp" in vars(self):
            out["containerIp"] = self.containerIp
        if not omit_unset or "containerPort" in vars(self):
            out["containerPort"] = self.containerPort
        if not omit_unset or "hostIp" in vars(self):
            out["hostIp"] = self.hostIp
        if not omit_unset or "hostPort" in vars(self):
            out["hostPort"] = self.hostPort
        return out

class v1Agent(Printable):
    """Agent is a pool of resources where containers are run."""
    addresses: "typing.Optional[typing.Sequence[str]]" = None
    containers: "typing.Optional[typing.Dict[str, v1Container]]" = None
    draining: "typing.Optional[bool]" = None
    enabled: "typing.Optional[bool]" = None
    registeredTime: "typing.Optional[str]" = None
    resourcePools: "typing.Optional[typing.Sequence[str]]" = None
    slots: "typing.Optional[typing.Dict[str, v1Slot]]" = None
    version: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        id: str,
        slotStats: "v1SlotStats",
        addresses: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
        containers: "typing.Union[typing.Dict[str, v1Container], None, Unset]" = _unset,
        draining: "typing.Union[bool, None, Unset]" = _unset,
        enabled: "typing.Union[bool, None, Unset]" = _unset,
        registeredTime: "typing.Union[str, None, Unset]" = _unset,
        resourcePools: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
        slots: "typing.Union[typing.Dict[str, v1Slot], None, Unset]" = _unset,
        version: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.id = id
        self.slotStats = slotStats
        if not isinstance(addresses, Unset):
            self.addresses = addresses
        if not isinstance(containers, Unset):
            self.containers = containers
        if not isinstance(draining, Unset):
            self.draining = draining
        if not isinstance(enabled, Unset):
            self.enabled = enabled
        if not isinstance(registeredTime, Unset):
            self.registeredTime = registeredTime
        if not isinstance(resourcePools, Unset):
            self.resourcePools = resourcePools
        if not isinstance(slots, Unset):
            self.slots = slots
        if not isinstance(version, Unset):
            self.version = version

    @classmethod
    def from_json(cls, obj: Json) -> "v1Agent":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "id": obj["id"],
            "slotStats": v1SlotStats.from_json(obj["slotStats"]),
        }
        if "addresses" in obj:
            kwargs["addresses"] = obj["addresses"]
        if "containers" in obj:
            kwargs["containers"] = {k: v1Container.from_json(v) for k, v in obj["containers"].items()} if obj["containers"] is not None else None
        if "draining" in obj:
            kwargs["draining"] = obj["draining"]
        if "enabled" in obj:
            kwargs["enabled"] = obj["enabled"]
        if "registeredTime" in obj:
            kwargs["registeredTime"] = obj["registeredTime"]
        if "resourcePools" in obj:
            kwargs["resourcePools"] = obj["resourcePools"]
        if "slots" in obj:
            kwargs["slots"] = {k: v1Slot.from_json(v) for k, v in obj["slots"].items()} if obj["slots"] is not None else None
        if "version" in obj:
            kwargs["version"] = obj["version"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "id": self.id,
            "slotStats": self.slotStats.to_json(omit_unset),
        }
        if not omit_unset or "addresses" in vars(self):
            out["addresses"] = self.addresses
        if not omit_unset or "containers" in vars(self):
            out["containers"] = None if self.containers is None else {k: v.to_json(omit_unset) for k, v in self.containers.items()}
        if not omit_unset or "draining" in vars(self):
            out["draining"] = self.draining
        if not omit_unset or "enabled" in vars(self):
            out["enabled"] = self.enabled
        if not omit_unset or "registeredTime" in vars(self):
            out["registeredTime"] = self.registeredTime
        if not omit_unset or "resourcePools" in vars(self):
            out["resourcePools"] = self.resourcePools
        if not omit_unset or "slots" in vars(self):
            out["slots"] = None if self.slots is None else {k: v.to_json(omit_unset) for k, v in self.slots.items()}
        if not omit_unset or "version" in vars(self):
            out["version"] = self.version
        return out

class v1AgentUserGroup(Printable):
    """AgentUserGroup represents a username and primary group for a user on an
    agent host machine.
    """
    agentGid: "typing.Optional[int]" = None
    agentGroup: "typing.Optional[str]" = None
    agentUid: "typing.Optional[int]" = None
    agentUser: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        agentGid: "typing.Union[int, None, Unset]" = _unset,
        agentGroup: "typing.Union[str, None, Unset]" = _unset,
        agentUid: "typing.Union[int, None, Unset]" = _unset,
        agentUser: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(agentGid, Unset):
            self.agentGid = agentGid
        if not isinstance(agentGroup, Unset):
            self.agentGroup = agentGroup
        if not isinstance(agentUid, Unset):
            self.agentUid = agentUid
        if not isinstance(agentUser, Unset):
            self.agentUser = agentUser

    @classmethod
    def from_json(cls, obj: Json) -> "v1AgentUserGroup":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "agentGid" in obj:
            kwargs["agentGid"] = obj["agentGid"]
        if "agentGroup" in obj:
            kwargs["agentGroup"] = obj["agentGroup"]
        if "agentUid" in obj:
            kwargs["agentUid"] = obj["agentUid"]
        if "agentUser" in obj:
            kwargs["agentUser"] = obj["agentUser"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "agentGid" in vars(self):
            out["agentGid"] = self.agentGid
        if not omit_unset or "agentGroup" in vars(self):
            out["agentGroup"] = self.agentGroup
        if not omit_unset or "agentUid" in vars(self):
            out["agentUid"] = self.agentUid
        if not omit_unset or "agentUser" in vars(self):
            out["agentUser"] = self.agentUser
        return out

class v1AggregateQueueStats(Printable):
    """Aggregate statistics for a queue."""

    def __init__(
        self,
        *,
        periodStart: str,
        seconds: float,
    ):
        self.periodStart = periodStart
        self.seconds = seconds

    @classmethod
    def from_json(cls, obj: Json) -> "v1AggregateQueueStats":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "periodStart": obj["periodStart"],
            "seconds": float(obj["seconds"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "periodStart": self.periodStart,
            "seconds": dump_float(self.seconds),
        }
        return out

class v1Allocation(Printable):
    """Allocation tracks a specific instance of a Task."""
    endTime: "typing.Optional[str]" = None
    exitReason: "typing.Optional[str]" = None
    isReady: "typing.Optional[bool]" = None
    startTime: "typing.Optional[str]" = None
    statusCode: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        allocationId: str,
        slots: int,
        state: "taskv1State",
        taskId: str,
        endTime: "typing.Union[str, None, Unset]" = _unset,
        exitReason: "typing.Union[str, None, Unset]" = _unset,
        isReady: "typing.Union[bool, None, Unset]" = _unset,
        startTime: "typing.Union[str, None, Unset]" = _unset,
        statusCode: "typing.Union[int, None, Unset]" = _unset,
    ):
        self.allocationId = allocationId
        self.slots = slots
        self.state = state
        self.taskId = taskId
        if not isinstance(endTime, Unset):
            self.endTime = endTime
        if not isinstance(exitReason, Unset):
            self.exitReason = exitReason
        if not isinstance(isReady, Unset):
            self.isReady = isReady
        if not isinstance(startTime, Unset):
            self.startTime = startTime
        if not isinstance(statusCode, Unset):
            self.statusCode = statusCode

    @classmethod
    def from_json(cls, obj: Json) -> "v1Allocation":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "allocationId": obj["allocationId"],
            "slots": obj["slots"],
            "state": taskv1State(obj["state"]),
            "taskId": obj["taskId"],
        }
        if "endTime" in obj:
            kwargs["endTime"] = obj["endTime"]
        if "exitReason" in obj:
            kwargs["exitReason"] = obj["exitReason"]
        if "isReady" in obj:
            kwargs["isReady"] = obj["isReady"]
        if "startTime" in obj:
            kwargs["startTime"] = obj["startTime"]
        if "statusCode" in obj:
            kwargs["statusCode"] = obj["statusCode"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "allocationId": self.allocationId,
            "slots": self.slots,
            "state": self.state.value,
            "taskId": self.taskId,
        }
        if not omit_unset or "endTime" in vars(self):
            out["endTime"] = self.endTime
        if not omit_unset or "exitReason" in vars(self):
            out["exitReason"] = self.exitReason
        if not omit_unset or "isReady" in vars(self):
            out["isReady"] = self.isReady
        if not omit_unset or "startTime" in vars(self):
            out["startTime"] = self.startTime
        if not omit_unset or "statusCode" in vars(self):
            out["statusCode"] = self.statusCode
        return out

class v1AllocationAllGatherRequest(Printable):
    """Arguments to an all gather."""
    numPeers: "typing.Optional[int]" = None
    requestUuid: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        allocationId: str,
        data: "typing.Dict[str, typing.Any]",
        numPeers: "typing.Union[int, None, Unset]" = _unset,
        requestUuid: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.allocationId = allocationId
        self.data = data
        if not isinstance(numPeers, Unset):
            self.numPeers = numPeers
        if not isinstance(requestUuid, Unset):
            self.requestUuid = requestUuid

    @classmethod
    def from_json(cls, obj: Json) -> "v1AllocationAllGatherRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "allocationId": obj["allocationId"],
            "data": obj["data"],
        }
        if "numPeers" in obj:
            kwargs["numPeers"] = obj["numPeers"]
        if "requestUuid" in obj:
            kwargs["requestUuid"] = obj["requestUuid"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "allocationId": self.allocationId,
            "data": self.data,
        }
        if not omit_unset or "numPeers" in vars(self):
            out["numPeers"] = self.numPeers
        if not omit_unset or "requestUuid" in vars(self):
            out["requestUuid"] = self.requestUuid
        return out

class v1AllocationAllGatherResponse(Printable):

    def __init__(
        self,
        *,
        data: "typing.Sequence[typing.Dict[str, typing.Any]]",
    ):
        self.data = data

    @classmethod
    def from_json(cls, obj: Json) -> "v1AllocationAllGatherResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "data": obj["data"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "data": self.data,
        }
        return out

class v1AllocationPendingPreemptionSignalRequest(Printable):

    def __init__(
        self,
        *,
        allocationId: str,
    ):
        self.allocationId = allocationId

    @classmethod
    def from_json(cls, obj: Json) -> "v1AllocationPendingPreemptionSignalRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "allocationId": obj["allocationId"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "allocationId": self.allocationId,
        }
        return out

class v1AllocationPreemptionSignalResponse(Printable):
    """Response to AllocationPreemptionSignalRequest."""
    preempt: "typing.Optional[bool]" = None

    def __init__(
        self,
        *,
        preempt: "typing.Union[bool, None, Unset]" = _unset,
    ):
        if not isinstance(preempt, Unset):
            self.preempt = preempt

    @classmethod
    def from_json(cls, obj: Json) -> "v1AllocationPreemptionSignalResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "preempt" in obj:
            kwargs["preempt"] = obj["preempt"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "preempt" in vars(self):
            out["preempt"] = self.preempt
        return out

class v1AllocationReadyRequest(Printable):
    """Mark the given task as ready."""
    allocationId: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        allocationId: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(allocationId, Unset):
            self.allocationId = allocationId

    @classmethod
    def from_json(cls, obj: Json) -> "v1AllocationReadyRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "allocationId" in obj:
            kwargs["allocationId"] = obj["allocationId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "allocationId" in vars(self):
            out["allocationId"] = self.allocationId
        return out

class v1AllocationRendezvousInfoResponse(Printable):

    def __init__(
        self,
        *,
        rendezvousInfo: "v1RendezvousInfo",
    ):
        self.rendezvousInfo = rendezvousInfo

    @classmethod
    def from_json(cls, obj: Json) -> "v1AllocationRendezvousInfoResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "rendezvousInfo": v1RendezvousInfo.from_json(obj["rendezvousInfo"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "rendezvousInfo": self.rendezvousInfo.to_json(omit_unset),
        }
        return out

class v1AllocationSummary(Printable):
    """AllocationSummary contains information about a task for external display."""
    allocationId: "typing.Optional[str]" = None
    name: "typing.Optional[str]" = None
    priority: "typing.Optional[int]" = None
    proxyPorts: "typing.Optional[typing.Sequence[v1ProxyPortConfig]]" = None
    registeredTime: "typing.Optional[str]" = None
    resourcePool: "typing.Optional[str]" = None
    resources: "typing.Optional[typing.Sequence[v1ResourcesSummary]]" = None
    schedulerType: "typing.Optional[str]" = None
    slotsNeeded: "typing.Optional[int]" = None
    taskId: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        allocationId: "typing.Union[str, None, Unset]" = _unset,
        name: "typing.Union[str, None, Unset]" = _unset,
        priority: "typing.Union[int, None, Unset]" = _unset,
        proxyPorts: "typing.Union[typing.Sequence[v1ProxyPortConfig], None, Unset]" = _unset,
        registeredTime: "typing.Union[str, None, Unset]" = _unset,
        resourcePool: "typing.Union[str, None, Unset]" = _unset,
        resources: "typing.Union[typing.Sequence[v1ResourcesSummary], None, Unset]" = _unset,
        schedulerType: "typing.Union[str, None, Unset]" = _unset,
        slotsNeeded: "typing.Union[int, None, Unset]" = _unset,
        taskId: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(allocationId, Unset):
            self.allocationId = allocationId
        if not isinstance(name, Unset):
            self.name = name
        if not isinstance(priority, Unset):
            self.priority = priority
        if not isinstance(proxyPorts, Unset):
            self.proxyPorts = proxyPorts
        if not isinstance(registeredTime, Unset):
            self.registeredTime = registeredTime
        if not isinstance(resourcePool, Unset):
            self.resourcePool = resourcePool
        if not isinstance(resources, Unset):
            self.resources = resources
        if not isinstance(schedulerType, Unset):
            self.schedulerType = schedulerType
        if not isinstance(slotsNeeded, Unset):
            self.slotsNeeded = slotsNeeded
        if not isinstance(taskId, Unset):
            self.taskId = taskId

    @classmethod
    def from_json(cls, obj: Json) -> "v1AllocationSummary":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "allocationId" in obj:
            kwargs["allocationId"] = obj["allocationId"]
        if "name" in obj:
            kwargs["name"] = obj["name"]
        if "priority" in obj:
            kwargs["priority"] = obj["priority"]
        if "proxyPorts" in obj:
            kwargs["proxyPorts"] = [v1ProxyPortConfig.from_json(x) for x in obj["proxyPorts"]] if obj["proxyPorts"] is not None else None
        if "registeredTime" in obj:
            kwargs["registeredTime"] = obj["registeredTime"]
        if "resourcePool" in obj:
            kwargs["resourcePool"] = obj["resourcePool"]
        if "resources" in obj:
            kwargs["resources"] = [v1ResourcesSummary.from_json(x) for x in obj["resources"]] if obj["resources"] is not None else None
        if "schedulerType" in obj:
            kwargs["schedulerType"] = obj["schedulerType"]
        if "slotsNeeded" in obj:
            kwargs["slotsNeeded"] = obj["slotsNeeded"]
        if "taskId" in obj:
            kwargs["taskId"] = obj["taskId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "allocationId" in vars(self):
            out["allocationId"] = self.allocationId
        if not omit_unset or "name" in vars(self):
            out["name"] = self.name
        if not omit_unset or "priority" in vars(self):
            out["priority"] = self.priority
        if not omit_unset or "proxyPorts" in vars(self):
            out["proxyPorts"] = None if self.proxyPorts is None else [x.to_json(omit_unset) for x in self.proxyPorts]
        if not omit_unset or "registeredTime" in vars(self):
            out["registeredTime"] = self.registeredTime
        if not omit_unset or "resourcePool" in vars(self):
            out["resourcePool"] = self.resourcePool
        if not omit_unset or "resources" in vars(self):
            out["resources"] = None if self.resources is None else [x.to_json(omit_unset) for x in self.resources]
        if not omit_unset or "schedulerType" in vars(self):
            out["schedulerType"] = self.schedulerType
        if not omit_unset or "slotsNeeded" in vars(self):
            out["slotsNeeded"] = self.slotsNeeded
        if not omit_unset or "taskId" in vars(self):
            out["taskId"] = self.taskId
        return out

class v1AllocationWaitingRequest(Printable):
    """Mark the given task as waiting."""
    allocationId: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        allocationId: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(allocationId, Unset):
            self.allocationId = allocationId

    @classmethod
    def from_json(cls, obj: Json) -> "v1AllocationWaitingRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "allocationId" in obj:
            kwargs["allocationId"] = obj["allocationId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "allocationId" in vars(self):
            out["allocationId"] = self.allocationId
        return out

class v1ArchiveExperimentsRequest(Printable):
    """Archive multiple experiments."""
    filters: "typing.Optional[v1BulkExperimentFilters]" = None

    def __init__(
        self,
        *,
        experimentIds: "typing.Sequence[int]",
        projectId: int,
        filters: "typing.Union[v1BulkExperimentFilters, None, Unset]" = _unset,
    ):
        self.experimentIds = experimentIds
        self.projectId = projectId
        if not isinstance(filters, Unset):
            self.filters = filters

    @classmethod
    def from_json(cls, obj: Json) -> "v1ArchiveExperimentsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "experimentIds": obj["experimentIds"],
            "projectId": obj["projectId"],
        }
        if "filters" in obj:
            kwargs["filters"] = v1BulkExperimentFilters.from_json(obj["filters"]) if obj["filters"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "experimentIds": self.experimentIds,
            "projectId": self.projectId,
        }
        if not omit_unset or "filters" in vars(self):
            out["filters"] = None if self.filters is None else self.filters.to_json(omit_unset)
        return out

class v1ArchiveExperimentsResponse(Printable):
    """Response to ArchiveExperimentsRequest."""

    def __init__(
        self,
        *,
        results: "typing.Sequence[v1ExperimentActionResult]",
    ):
        self.results = results

    @classmethod
    def from_json(cls, obj: Json) -> "v1ArchiveExperimentsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "results": [v1ExperimentActionResult.from_json(x) for x in obj["results"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "results": [x.to_json(omit_unset) for x in self.results],
        }
        return out

class v1ArchiveRunsRequest(Printable):
    filter: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        projectId: int,
        runIds: "typing.Sequence[int]",
        filter: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.projectId = projectId
        self.runIds = runIds
        if not isinstance(filter, Unset):
            self.filter = filter

    @classmethod
    def from_json(cls, obj: Json) -> "v1ArchiveRunsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "projectId": obj["projectId"],
            "runIds": obj["runIds"],
        }
        if "filter" in obj:
            kwargs["filter"] = obj["filter"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "projectId": self.projectId,
            "runIds": self.runIds,
        }
        if not omit_unset or "filter" in vars(self):
            out["filter"] = self.filter
        return out

class v1ArchiveRunsResponse(Printable):
    """Response to ArchiveRunsRequest."""

    def __init__(
        self,
        *,
        results: "typing.Sequence[v1RunActionResult]",
    ):
        self.results = results

    @classmethod
    def from_json(cls, obj: Json) -> "v1ArchiveRunsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "results": [v1RunActionResult.from_json(x) for x in obj["results"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "results": [x.to_json(omit_unset) for x in self.results],
        }
        return out

class v1AssignMultipleGroupsRequest(Printable):
    """Add and remove multiple users from multiple groups."""

    def __init__(
        self,
        *,
        addGroups: "typing.Sequence[int]",
        removeGroups: "typing.Sequence[int]",
        userIds: "typing.Sequence[int]",
    ):
        self.addGroups = addGroups
        self.removeGroups = removeGroups
        self.userIds = userIds

    @classmethod
    def from_json(cls, obj: Json) -> "v1AssignMultipleGroupsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "addGroups": obj["addGroups"],
            "removeGroups": obj["removeGroups"],
            "userIds": obj["userIds"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "addGroups": self.addGroups,
            "removeGroups": self.removeGroups,
            "userIds": self.userIds,
        }
        return out

class v1AssignRolesRequest(Printable):
    """AssignRolesRequest is the body of the request for the call to
    grant a user or group a role. It requires group_id, role_id,
    and either scope_workspace_id or scope_project_id.
    """
    groupRoleAssignments: "typing.Optional[typing.Sequence[v1GroupRoleAssignment]]" = None
    userRoleAssignments: "typing.Optional[typing.Sequence[v1UserRoleAssignment]]" = None

    def __init__(
        self,
        *,
        groupRoleAssignments: "typing.Union[typing.Sequence[v1GroupRoleAssignment], None, Unset]" = _unset,
        userRoleAssignments: "typing.Union[typing.Sequence[v1UserRoleAssignment], None, Unset]" = _unset,
    ):
        if not isinstance(groupRoleAssignments, Unset):
            self.groupRoleAssignments = groupRoleAssignments
        if not isinstance(userRoleAssignments, Unset):
            self.userRoleAssignments = userRoleAssignments

    @classmethod
    def from_json(cls, obj: Json) -> "v1AssignRolesRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "groupRoleAssignments" in obj:
            kwargs["groupRoleAssignments"] = [v1GroupRoleAssignment.from_json(x) for x in obj["groupRoleAssignments"]] if obj["groupRoleAssignments"] is not None else None
        if "userRoleAssignments" in obj:
            kwargs["userRoleAssignments"] = [v1UserRoleAssignment.from_json(x) for x in obj["userRoleAssignments"]] if obj["userRoleAssignments"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "groupRoleAssignments" in vars(self):
            out["groupRoleAssignments"] = None if self.groupRoleAssignments is None else [x.to_json(omit_unset) for x in self.groupRoleAssignments]
        if not omit_unset or "userRoleAssignments" in vars(self):
            out["userRoleAssignments"] = None if self.userRoleAssignments is None else [x.to_json(omit_unset) for x in self.userRoleAssignments]
        return out

class v1AwsCustomTag(Printable):

    def __init__(
        self,
        *,
        key: str,
        value: str,
    ):
        self.key = key
        self.value = value

    @classmethod
    def from_json(cls, obj: Json) -> "v1AwsCustomTag":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "key": obj["key"],
            "value": obj["value"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "key": self.key,
            "value": self.value,
        }
        return out

class v1BindRPToWorkspaceRequest(Printable):
    workspaceIds: "typing.Optional[typing.Sequence[int]]" = None
    workspaceNames: "typing.Optional[typing.Sequence[str]]" = None

    def __init__(
        self,
        *,
        resourcePoolName: str,
        workspaceIds: "typing.Union[typing.Sequence[int], None, Unset]" = _unset,
        workspaceNames: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
    ):
        self.resourcePoolName = resourcePoolName
        if not isinstance(workspaceIds, Unset):
            self.workspaceIds = workspaceIds
        if not isinstance(workspaceNames, Unset):
            self.workspaceNames = workspaceNames

    @classmethod
    def from_json(cls, obj: Json) -> "v1BindRPToWorkspaceRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "resourcePoolName": obj["resourcePoolName"],
        }
        if "workspaceIds" in obj:
            kwargs["workspaceIds"] = obj["workspaceIds"]
        if "workspaceNames" in obj:
            kwargs["workspaceNames"] = obj["workspaceNames"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "resourcePoolName": self.resourcePoolName,
        }
        if not omit_unset or "workspaceIds" in vars(self):
            out["workspaceIds"] = self.workspaceIds
        if not omit_unset or "workspaceNames" in vars(self):
            out["workspaceNames"] = self.workspaceNames
        return out

class v1BulkAutoCreateWorkspaceNamespaceBindingsRequest(Printable):
    """Request for binding the given workpaces to new auto-created namespaces."""
    workspaceIds: "typing.Optional[typing.Sequence[int]]" = None

    def __init__(
        self,
        *,
        workspaceIds: "typing.Union[typing.Sequence[int], None, Unset]" = _unset,
    ):
        if not isinstance(workspaceIds, Unset):
            self.workspaceIds = workspaceIds

    @classmethod
    def from_json(cls, obj: Json) -> "v1BulkAutoCreateWorkspaceNamespaceBindingsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "workspaceIds" in obj:
            kwargs["workspaceIds"] = obj["workspaceIds"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "workspaceIds" in vars(self):
            out["workspaceIds"] = self.workspaceIds
        return out

class v1BulkExperimentFilters(Printable):
    """Filters to apply actions to multiple experiments."""
    archived: "typing.Optional[bool]" = None
    description: "typing.Optional[str]" = None
    excludedExperimentIds: "typing.Optional[typing.Sequence[int]]" = None
    labels: "typing.Optional[typing.Sequence[str]]" = None
    name: "typing.Optional[str]" = None
    projectId: "typing.Optional[int]" = None
    states: "typing.Optional[typing.Sequence[experimentv1State]]" = None
    userIds: "typing.Optional[typing.Sequence[int]]" = None

    def __init__(
        self,
        *,
        archived: "typing.Union[bool, None, Unset]" = _unset,
        description: "typing.Union[str, None, Unset]" = _unset,
        excludedExperimentIds: "typing.Union[typing.Sequence[int], None, Unset]" = _unset,
        labels: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
        name: "typing.Union[str, None, Unset]" = _unset,
        projectId: "typing.Union[int, None, Unset]" = _unset,
        states: "typing.Union[typing.Sequence[experimentv1State], None, Unset]" = _unset,
        userIds: "typing.Union[typing.Sequence[int], None, Unset]" = _unset,
    ):
        if not isinstance(archived, Unset):
            self.archived = archived
        if not isinstance(description, Unset):
            self.description = description
        if not isinstance(excludedExperimentIds, Unset):
            self.excludedExperimentIds = excludedExperimentIds
        if not isinstance(labels, Unset):
            self.labels = labels
        if not isinstance(name, Unset):
            self.name = name
        if not isinstance(projectId, Unset):
            self.projectId = projectId
        if not isinstance(states, Unset):
            self.states = states
        if not isinstance(userIds, Unset):
            self.userIds = userIds

    @classmethod
    def from_json(cls, obj: Json) -> "v1BulkExperimentFilters":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "archived" in obj:
            kwargs["archived"] = obj["archived"]
        if "description" in obj:
            kwargs["description"] = obj["description"]
        if "excludedExperimentIds" in obj:
            kwargs["excludedExperimentIds"] = obj["excludedExperimentIds"]
        if "labels" in obj:
            kwargs["labels"] = obj["labels"]
        if "name" in obj:
            kwargs["name"] = obj["name"]
        if "projectId" in obj:
            kwargs["projectId"] = obj["projectId"]
        if "states" in obj:
            kwargs["states"] = [experimentv1State(x) for x in obj["states"]] if obj["states"] is not None else None
        if "userIds" in obj:
            kwargs["userIds"] = obj["userIds"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "archived" in vars(self):
            out["archived"] = self.archived
        if not omit_unset or "description" in vars(self):
            out["description"] = self.description
        if not omit_unset or "excludedExperimentIds" in vars(self):
            out["excludedExperimentIds"] = self.excludedExperimentIds
        if not omit_unset or "labels" in vars(self):
            out["labels"] = self.labels
        if not omit_unset or "name" in vars(self):
            out["name"] = self.name
        if not omit_unset or "projectId" in vars(self):
            out["projectId"] = self.projectId
        if not omit_unset or "states" in vars(self):
            out["states"] = None if self.states is None else [x.value for x in self.states]
        if not omit_unset or "userIds" in vars(self):
            out["userIds"] = self.userIds
        return out

class v1CancelExperimentsRequest(Printable):
    """Cancel multiple experiments."""
    filters: "typing.Optional[v1BulkExperimentFilters]" = None

    def __init__(
        self,
        *,
        experimentIds: "typing.Sequence[int]",
        projectId: int,
        filters: "typing.Union[v1BulkExperimentFilters, None, Unset]" = _unset,
    ):
        self.experimentIds = experimentIds
        self.projectId = projectId
        if not isinstance(filters, Unset):
            self.filters = filters

    @classmethod
    def from_json(cls, obj: Json) -> "v1CancelExperimentsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "experimentIds": obj["experimentIds"],
            "projectId": obj["projectId"],
        }
        if "filters" in obj:
            kwargs["filters"] = v1BulkExperimentFilters.from_json(obj["filters"]) if obj["filters"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "experimentIds": self.experimentIds,
            "projectId": self.projectId,
        }
        if not omit_unset or "filters" in vars(self):
            out["filters"] = None if self.filters is None else self.filters.to_json(omit_unset)
        return out

class v1CancelExperimentsResponse(Printable):
    """Response to CancelExperimentsRequest."""

    def __init__(
        self,
        *,
        results: "typing.Sequence[v1ExperimentActionResult]",
    ):
        self.results = results

    @classmethod
    def from_json(cls, obj: Json) -> "v1CancelExperimentsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "results": [v1ExperimentActionResult.from_json(x) for x in obj["results"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "results": [x.to_json(omit_unset) for x in self.results],
        }
        return out

class v1Checkpoint(Printable):
    """Checkpoint a collection of files saved by a task."""
    allocationId: "typing.Optional[str]" = None
    reportTime: "typing.Optional[str]" = None
    storageId: "typing.Optional[int]" = None
    taskId: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        metadata: "typing.Dict[str, typing.Any]",
        resources: "typing.Dict[str, str]",
        state: "checkpointv1State",
        training: "v1CheckpointTrainingMetadata",
        uuid: str,
        allocationId: "typing.Union[str, None, Unset]" = _unset,
        reportTime: "typing.Union[str, None, Unset]" = _unset,
        storageId: "typing.Union[int, None, Unset]" = _unset,
        taskId: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.metadata = metadata
        self.resources = resources
        self.state = state
        self.training = training
        self.uuid = uuid
        if not isinstance(allocationId, Unset):
            self.allocationId = allocationId
        if not isinstance(reportTime, Unset):
            self.reportTime = reportTime
        if not isinstance(storageId, Unset):
            self.storageId = storageId
        if not isinstance(taskId, Unset):
            self.taskId = taskId

    @classmethod
    def from_json(cls, obj: Json) -> "v1Checkpoint":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "metadata": obj["metadata"],
            "resources": obj["resources"],
            "state": checkpointv1State(obj["state"]),
            "training": v1CheckpointTrainingMetadata.from_json(obj["training"]),
            "uuid": obj["uuid"],
        }
        if "allocationId" in obj:
            kwargs["allocationId"] = obj["allocationId"]
        if "reportTime" in obj:
            kwargs["reportTime"] = obj["reportTime"]
        if "storageId" in obj:
            kwargs["storageId"] = obj["storageId"]
        if "taskId" in obj:
            kwargs["taskId"] = obj["taskId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "metadata": self.metadata,
            "resources": self.resources,
            "state": self.state.value,
            "training": self.training.to_json(omit_unset),
            "uuid": self.uuid,
        }
        if not omit_unset or "allocationId" in vars(self):
            out["allocationId"] = self.allocationId
        if not omit_unset or "reportTime" in vars(self):
            out["reportTime"] = self.reportTime
        if not omit_unset or "storageId" in vars(self):
            out["storageId"] = self.storageId
        if not omit_unset or "taskId" in vars(self):
            out["taskId"] = self.taskId
        return out

class v1CheckpointTrainingMetadata(Printable):
    """CheckpointTrainingMetadata is specifically metadata about training."""
    experimentConfig: "typing.Optional[typing.Dict[str, typing.Any]]" = None
    experimentId: "typing.Optional[int]" = None
    hparams: "typing.Optional[typing.Dict[str, typing.Any]]" = None
    searcherMetric: "typing.Optional[float]" = None
    trainingMetrics: "typing.Optional[v1Metrics]" = None
    trialId: "typing.Optional[int]" = None
    validationMetrics: "typing.Optional[v1Metrics]" = None

    def __init__(
        self,
        *,
        experimentConfig: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
        experimentId: "typing.Union[int, None, Unset]" = _unset,
        hparams: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
        searcherMetric: "typing.Union[float, None, Unset]" = _unset,
        trainingMetrics: "typing.Union[v1Metrics, None, Unset]" = _unset,
        trialId: "typing.Union[int, None, Unset]" = _unset,
        validationMetrics: "typing.Union[v1Metrics, None, Unset]" = _unset,
    ):
        if not isinstance(experimentConfig, Unset):
            self.experimentConfig = experimentConfig
        if not isinstance(experimentId, Unset):
            self.experimentId = experimentId
        if not isinstance(hparams, Unset):
            self.hparams = hparams
        if not isinstance(searcherMetric, Unset):
            self.searcherMetric = searcherMetric
        if not isinstance(trainingMetrics, Unset):
            self.trainingMetrics = trainingMetrics
        if not isinstance(trialId, Unset):
            self.trialId = trialId
        if not isinstance(validationMetrics, Unset):
            self.validationMetrics = validationMetrics

    @classmethod
    def from_json(cls, obj: Json) -> "v1CheckpointTrainingMetadata":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "experimentConfig" in obj:
            kwargs["experimentConfig"] = obj["experimentConfig"]
        if "experimentId" in obj:
            kwargs["experimentId"] = obj["experimentId"]
        if "hparams" in obj:
            kwargs["hparams"] = obj["hparams"]
        if "searcherMetric" in obj:
            kwargs["searcherMetric"] = float(obj["searcherMetric"]) if obj["searcherMetric"] is not None else None
        if "trainingMetrics" in obj:
            kwargs["trainingMetrics"] = v1Metrics.from_json(obj["trainingMetrics"]) if obj["trainingMetrics"] is not None else None
        if "trialId" in obj:
            kwargs["trialId"] = obj["trialId"]
        if "validationMetrics" in obj:
            kwargs["validationMetrics"] = v1Metrics.from_json(obj["validationMetrics"]) if obj["validationMetrics"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "experimentConfig" in vars(self):
            out["experimentConfig"] = self.experimentConfig
        if not omit_unset or "experimentId" in vars(self):
            out["experimentId"] = self.experimentId
        if not omit_unset or "hparams" in vars(self):
            out["hparams"] = self.hparams
        if not omit_unset or "searcherMetric" in vars(self):
            out["searcherMetric"] = None if self.searcherMetric is None else dump_float(self.searcherMetric)
        if not omit_unset or "trainingMetrics" in vars(self):
            out["trainingMetrics"] = None if self.trainingMetrics is None else self.trainingMetrics.to_json(omit_unset)
        if not omit_unset or "trialId" in vars(self):
            out["trialId"] = self.trialId
        if not omit_unset or "validationMetrics" in vars(self):
            out["validationMetrics"] = None if self.validationMetrics is None else self.validationMetrics.to_json(omit_unset)
        return out

class v1CheckpointWorkload(Printable):
    """CheckpointWorkload is an artifact created by a trial during training."""
    endTime: "typing.Optional[str]" = None
    metadata: "typing.Optional[typing.Dict[str, typing.Any]]" = None
    resources: "typing.Optional[typing.Dict[str, str]]" = None
    uuid: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        state: "checkpointv1State",
        totalBatches: int,
        endTime: "typing.Union[str, None, Unset]" = _unset,
        metadata: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
        resources: "typing.Union[typing.Dict[str, str], None, Unset]" = _unset,
        uuid: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.state = state
        self.totalBatches = totalBatches
        if not isinstance(endTime, Unset):
            self.endTime = endTime
        if not isinstance(metadata, Unset):
            self.metadata = metadata
        if not isinstance(resources, Unset):
            self.resources = resources
        if not isinstance(uuid, Unset):
            self.uuid = uuid

    @classmethod
    def from_json(cls, obj: Json) -> "v1CheckpointWorkload":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "state": checkpointv1State(obj["state"]),
            "totalBatches": obj["totalBatches"],
        }
        if "endTime" in obj:
            kwargs["endTime"] = obj["endTime"]
        if "metadata" in obj:
            kwargs["metadata"] = obj["metadata"]
        if "resources" in obj:
            kwargs["resources"] = obj["resources"]
        if "uuid" in obj:
            kwargs["uuid"] = obj["uuid"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "state": self.state.value,
            "totalBatches": self.totalBatches,
        }
        if not omit_unset or "endTime" in vars(self):
            out["endTime"] = self.endTime
        if not omit_unset or "metadata" in vars(self):
            out["metadata"] = self.metadata
        if not omit_unset or "resources" in vars(self):
            out["resources"] = self.resources
        if not omit_unset or "uuid" in vars(self):
            out["uuid"] = self.uuid
        return out

class v1CheckpointsRemoveFilesRequest(Printable):
    """Request to delete files matching globs in checkpoints."""

    def __init__(
        self,
        *,
        checkpointGlobs: "typing.Sequence[str]",
        checkpointUuids: "typing.Sequence[str]",
    ):
        self.checkpointGlobs = checkpointGlobs
        self.checkpointUuids = checkpointUuids

    @classmethod
    def from_json(cls, obj: Json) -> "v1CheckpointsRemoveFilesRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "checkpointGlobs": obj["checkpointGlobs"],
            "checkpointUuids": obj["checkpointUuids"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "checkpointGlobs": self.checkpointGlobs,
            "checkpointUuids": self.checkpointUuids,
        }
        return out

class v1CleanupLogsResponse(Printable):
    """Response to CleanupLogsRequest."""

    def __init__(
        self,
        *,
        removedCount: str,
    ):
        self.removedCount = removedCount

    @classmethod
    def from_json(cls, obj: Json) -> "v1CleanupLogsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "removedCount": obj["removedCount"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "removedCount": self.removedCount,
        }
        return out

class v1ClusterMessage(Printable):
    """Active notice from the server admin."""
    createdTime: "typing.Optional[str]" = None
    endTime: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        message: str,
        startTime: str,
        createdTime: "typing.Union[str, None, Unset]" = _unset,
        endTime: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.message = message
        self.startTime = startTime
        if not isinstance(createdTime, Unset):
            self.createdTime = createdTime
        if not isinstance(endTime, Unset):
            self.endTime = endTime

    @classmethod
    def from_json(cls, obj: Json) -> "v1ClusterMessage":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "message": obj["message"],
            "startTime": obj["startTime"],
        }
        if "createdTime" in obj:
            kwargs["createdTime"] = obj["createdTime"]
        if "endTime" in obj:
            kwargs["endTime"] = obj["endTime"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "message": self.message,
            "startTime": self.startTime,
        }
        if not omit_unset or "createdTime" in vars(self):
            out["createdTime"] = self.createdTime
        if not omit_unset or "endTime" in vars(self):
            out["endTime"] = self.endTime
        return out

class v1ColumnType(DetEnum):
    """ColumnType indicates the type of data under the column
    - COLUMN_TYPE_UNSPECIFIED: data type is unknown/mixed
    - COLUMN_TYPE_TEXT: data type is textual
    - COLUMN_TYPE_NUMBER: data type is numeric
    - COLUMN_TYPE_DATE: data type is a date
    - COLUMN_TYPE_ARRAY: data type is an array
    """
    UNSPECIFIED = "COLUMN_TYPE_UNSPECIFIED"
    TEXT = "COLUMN_TYPE_TEXT"
    NUMBER = "COLUMN_TYPE_NUMBER"
    DATE = "COLUMN_TYPE_DATE"
    ARRAY = "COLUMN_TYPE_ARRAY"

class v1Command(Printable):
    """Command is a single container running the configured command."""
    container: "typing.Optional[v1Container]" = None
    displayName: "typing.Optional[str]" = None
    exitStatus: "typing.Optional[str]" = None
    userId: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        description: str,
        id: str,
        jobId: str,
        resourcePool: str,
        startTime: str,
        state: "taskv1State",
        username: str,
        workspaceId: int,
        container: "typing.Union[v1Container, None, Unset]" = _unset,
        displayName: "typing.Union[str, None, Unset]" = _unset,
        exitStatus: "typing.Union[str, None, Unset]" = _unset,
        userId: "typing.Union[int, None, Unset]" = _unset,
    ):
        self.description = description
        self.id = id
        self.jobId = jobId
        self.resourcePool = resourcePool
        self.startTime = startTime
        self.state = state
        self.username = username
        self.workspaceId = workspaceId
        if not isinstance(container, Unset):
            self.container = container
        if not isinstance(displayName, Unset):
            self.displayName = displayName
        if not isinstance(exitStatus, Unset):
            self.exitStatus = exitStatus
        if not isinstance(userId, Unset):
            self.userId = userId

    @classmethod
    def from_json(cls, obj: Json) -> "v1Command":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "description": obj["description"],
            "id": obj["id"],
            "jobId": obj["jobId"],
            "resourcePool": obj["resourcePool"],
            "startTime": obj["startTime"],
            "state": taskv1State(obj["state"]),
            "username": obj["username"],
            "workspaceId": obj["workspaceId"],
        }
        if "container" in obj:
            kwargs["container"] = v1Container.from_json(obj["container"]) if obj["container"] is not None else None
        if "displayName" in obj:
            kwargs["displayName"] = obj["displayName"]
        if "exitStatus" in obj:
            kwargs["exitStatus"] = obj["exitStatus"]
        if "userId" in obj:
            kwargs["userId"] = obj["userId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "description": self.description,
            "id": self.id,
            "jobId": self.jobId,
            "resourcePool": self.resourcePool,
            "startTime": self.startTime,
            "state": self.state.value,
            "username": self.username,
            "workspaceId": self.workspaceId,
        }
        if not omit_unset or "container" in vars(self):
            out["container"] = None if self.container is None else self.container.to_json(omit_unset)
        if not omit_unset or "displayName" in vars(self):
            out["displayName"] = self.displayName
        if not omit_unset or "exitStatus" in vars(self):
            out["exitStatus"] = self.exitStatus
        if not omit_unset or "userId" in vars(self):
            out["userId"] = self.userId
        return out

class v1ComparableTrial(Printable):
    """Container for a requested trial and its metrics."""

    def __init__(
        self,
        *,
        metrics: "typing.Sequence[v1DownsampledMetrics]",
        trial: "trialv1Trial",
    ):
        self.metrics = metrics
        self.trial = trial

    @classmethod
    def from_json(cls, obj: Json) -> "v1ComparableTrial":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "metrics": [v1DownsampledMetrics.from_json(x) for x in obj["metrics"]],
            "trial": trialv1Trial.from_json(obj["trial"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "metrics": [x.to_json(omit_unset) for x in self.metrics],
            "trial": self.trial.to_json(omit_unset),
        }
        return out

class v1CompareTrialsResponse(Printable):
    """Response to CompareTrialsRequest."""

    def __init__(
        self,
        *,
        trials: "typing.Sequence[v1ComparableTrial]",
    ):
        self.trials = trials

    @classmethod
    def from_json(cls, obj: Json) -> "v1CompareTrialsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "trials": [v1ComparableTrial.from_json(x) for x in obj["trials"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "trials": [x.to_json(omit_unset) for x in self.trials],
        }
        return out

class v1Config(Printable):
    """The config to be patched into Master Config."""
    log: "typing.Optional[v1LogConfig]" = None

    def __init__(
        self,
        *,
        log: "typing.Union[v1LogConfig, None, Unset]" = _unset,
    ):
        if not isinstance(log, Unset):
            self.log = log

    @classmethod
    def from_json(cls, obj: Json) -> "v1Config":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "log" in obj:
            kwargs["log"] = v1LogConfig.from_json(obj["log"]) if obj["log"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "log" in vars(self):
            out["log"] = None if self.log is None else self.log.to_json(omit_unset)
        return out

class v1Container(Printable):
    """Container is a Docker container that is either scheduled to run or is
    currently running on a set of slots.
    """
    devices: "typing.Optional[typing.Sequence[v1Device]]" = None
    parent: "typing.Optional[str]" = None
    permissionDenied: "typing.Optional[bool]" = None

    def __init__(
        self,
        *,
        id: str,
        state: "containerv1State",
        devices: "typing.Union[typing.Sequence[v1Device], None, Unset]" = _unset,
        parent: "typing.Union[str, None, Unset]" = _unset,
        permissionDenied: "typing.Union[bool, None, Unset]" = _unset,
    ):
        self.id = id
        self.state = state
        if not isinstance(devices, Unset):
            self.devices = devices
        if not isinstance(parent, Unset):
            self.parent = parent
        if not isinstance(permissionDenied, Unset):
            self.permissionDenied = permissionDenied

    @classmethod
    def from_json(cls, obj: Json) -> "v1Container":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "id": obj["id"],
            "state": containerv1State(obj["state"]),
        }
        if "devices" in obj:
            kwargs["devices"] = [v1Device.from_json(x) for x in obj["devices"]] if obj["devices"] is not None else None
        if "parent" in obj:
            kwargs["parent"] = obj["parent"]
        if "permissionDenied" in obj:
            kwargs["permissionDenied"] = obj["permissionDenied"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "id": self.id,
            "state": self.state.value,
        }
        if not omit_unset or "devices" in vars(self):
            out["devices"] = None if self.devices is None else [x.to_json(omit_unset) for x in self.devices]
        if not omit_unset or "parent" in vars(self):
            out["parent"] = self.parent
        if not omit_unset or "permissionDenied" in vars(self):
            out["permissionDenied"] = self.permissionDenied
        return out

class v1ContinueExperimentRequest(Printable):
    """Request to continue an experiment."""
    overrideConfig: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        id: int,
        overrideConfig: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.id = id
        if not isinstance(overrideConfig, Unset):
            self.overrideConfig = overrideConfig

    @classmethod
    def from_json(cls, obj: Json) -> "v1ContinueExperimentRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "id": obj["id"],
        }
        if "overrideConfig" in obj:
            kwargs["overrideConfig"] = obj["overrideConfig"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "id": self.id,
        }
        if not omit_unset or "overrideConfig" in vars(self):
            out["overrideConfig"] = self.overrideConfig
        return out

class v1ContinueExperimentResponse(Printable):
    """Request to continue an experiment."""
    warnings: "typing.Optional[typing.Sequence[v1LaunchWarning]]" = None

    def __init__(
        self,
        *,
        experiment: "v1Experiment",
        warnings: "typing.Union[typing.Sequence[v1LaunchWarning], None, Unset]" = _unset,
    ):
        self.experiment = experiment
        if not isinstance(warnings, Unset):
            self.warnings = warnings

    @classmethod
    def from_json(cls, obj: Json) -> "v1ContinueExperimentResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "experiment": v1Experiment.from_json(obj["experiment"]),
        }
        if "warnings" in obj:
            kwargs["warnings"] = [v1LaunchWarning(x) for x in obj["warnings"]] if obj["warnings"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "experiment": self.experiment.to_json(omit_unset),
        }
        if not omit_unset or "warnings" in vars(self):
            out["warnings"] = None if self.warnings is None else [x.value for x in self.warnings]
        return out

class v1CreateExperimentRequest(Printable):
    """Request to create a new experiment."""
    activate: "typing.Optional[bool]" = None
    config: "typing.Optional[str]" = None
    modelDefinition: "typing.Optional[typing.Sequence[v1File]]" = None
    parentId: "typing.Optional[int]" = None
    projectId: "typing.Optional[int]" = None
    template: "typing.Optional[str]" = None
    unmanaged: "typing.Optional[bool]" = None
    validateOnly: "typing.Optional[bool]" = None

    def __init__(
        self,
        *,
        activate: "typing.Union[bool, None, Unset]" = _unset,
        config: "typing.Union[str, None, Unset]" = _unset,
        modelDefinition: "typing.Union[typing.Sequence[v1File], None, Unset]" = _unset,
        parentId: "typing.Union[int, None, Unset]" = _unset,
        projectId: "typing.Union[int, None, Unset]" = _unset,
        template: "typing.Union[str, None, Unset]" = _unset,
        unmanaged: "typing.Union[bool, None, Unset]" = _unset,
        validateOnly: "typing.Union[bool, None, Unset]" = _unset,
    ):
        if not isinstance(activate, Unset):
            self.activate = activate
        if not isinstance(config, Unset):
            self.config = config
        if not isinstance(modelDefinition, Unset):
            self.modelDefinition = modelDefinition
        if not isinstance(parentId, Unset):
            self.parentId = parentId
        if not isinstance(projectId, Unset):
            self.projectId = projectId
        if not isinstance(template, Unset):
            self.template = template
        if not isinstance(unmanaged, Unset):
            self.unmanaged = unmanaged
        if not isinstance(validateOnly, Unset):
            self.validateOnly = validateOnly

    @classmethod
    def from_json(cls, obj: Json) -> "v1CreateExperimentRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "activate" in obj:
            kwargs["activate"] = obj["activate"]
        if "config" in obj:
            kwargs["config"] = obj["config"]
        if "modelDefinition" in obj:
            kwargs["modelDefinition"] = [v1File.from_json(x) for x in obj["modelDefinition"]] if obj["modelDefinition"] is not None else None
        if "parentId" in obj:
            kwargs["parentId"] = obj["parentId"]
        if "projectId" in obj:
            kwargs["projectId"] = obj["projectId"]
        if "template" in obj:
            kwargs["template"] = obj["template"]
        if "unmanaged" in obj:
            kwargs["unmanaged"] = obj["unmanaged"]
        if "validateOnly" in obj:
            kwargs["validateOnly"] = obj["validateOnly"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "activate" in vars(self):
            out["activate"] = self.activate
        if not omit_unset or "config" in vars(self):
            out["config"] = self.config
        if not omit_unset or "modelDefinition" in vars(self):
            out["modelDefinition"] = None if self.modelDefinition is None else [x.to_json(omit_unset) for x in self.modelDefinition]
        if not omit_unset or "parentId" in vars(self):
            out["parentId"] = self.parentId
        if not omit_unset or "projectId" in vars(self):
            out["projectId"] = self.projectId
        if not omit_unset or "template" in vars(self):
            out["template"] = self.template
        if not omit_unset or "unmanaged" in vars(self):
            out["unmanaged"] = self.unmanaged
        if not omit_unset or "validateOnly" in vars(self):
            out["validateOnly"] = self.validateOnly
        return out

class v1CreateExperimentResponse(Printable):
    """Response to CreateExperimentRequest."""
    warnings: "typing.Optional[typing.Sequence[v1LaunchWarning]]" = None

    def __init__(
        self,
        *,
        config: "typing.Dict[str, typing.Any]",
        experiment: "v1Experiment",
        warnings: "typing.Union[typing.Sequence[v1LaunchWarning], None, Unset]" = _unset,
    ):
        self.config = config
        self.experiment = experiment
        if not isinstance(warnings, Unset):
            self.warnings = warnings

    @classmethod
    def from_json(cls, obj: Json) -> "v1CreateExperimentResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "config": obj["config"],
            "experiment": v1Experiment.from_json(obj["experiment"]),
        }
        if "warnings" in obj:
            kwargs["warnings"] = [v1LaunchWarning(x) for x in obj["warnings"]] if obj["warnings"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "config": self.config,
            "experiment": self.experiment.to_json(omit_unset),
        }
        if not omit_unset or "warnings" in vars(self):
            out["warnings"] = None if self.warnings is None else [x.value for x in self.warnings]
        return out

class v1CreateGenericTaskRequest(Printable):
    """Request to create a new generic task."""
    forkedFrom: "typing.Optional[str]" = None
    inheritContext: "typing.Optional[bool]" = None
    noPause: "typing.Optional[bool]" = None
    parentId: "typing.Optional[str]" = None
    projectId: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        config: str,
        contextDirectory: "typing.Sequence[v1File]",
        forkedFrom: "typing.Union[str, None, Unset]" = _unset,
        inheritContext: "typing.Union[bool, None, Unset]" = _unset,
        noPause: "typing.Union[bool, None, Unset]" = _unset,
        parentId: "typing.Union[str, None, Unset]" = _unset,
        projectId: "typing.Union[int, None, Unset]" = _unset,
    ):
        self.config = config
        self.contextDirectory = contextDirectory
        if not isinstance(forkedFrom, Unset):
            self.forkedFrom = forkedFrom
        if not isinstance(inheritContext, Unset):
            self.inheritContext = inheritContext
        if not isinstance(noPause, Unset):
            self.noPause = noPause
        if not isinstance(parentId, Unset):
            self.parentId = parentId
        if not isinstance(projectId, Unset):
            self.projectId = projectId

    @classmethod
    def from_json(cls, obj: Json) -> "v1CreateGenericTaskRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "config": obj["config"],
            "contextDirectory": [v1File.from_json(x) for x in obj["contextDirectory"]],
        }
        if "forkedFrom" in obj:
            kwargs["forkedFrom"] = obj["forkedFrom"]
        if "inheritContext" in obj:
            kwargs["inheritContext"] = obj["inheritContext"]
        if "noPause" in obj:
            kwargs["noPause"] = obj["noPause"]
        if "parentId" in obj:
            kwargs["parentId"] = obj["parentId"]
        if "projectId" in obj:
            kwargs["projectId"] = obj["projectId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "config": self.config,
            "contextDirectory": [x.to_json(omit_unset) for x in self.contextDirectory],
        }
        if not omit_unset or "forkedFrom" in vars(self):
            out["forkedFrom"] = self.forkedFrom
        if not omit_unset or "inheritContext" in vars(self):
            out["inheritContext"] = self.inheritContext
        if not omit_unset or "noPause" in vars(self):
            out["noPause"] = self.noPause
        if not omit_unset or "parentId" in vars(self):
            out["parentId"] = self.parentId
        if not omit_unset or "projectId" in vars(self):
            out["projectId"] = self.projectId
        return out

class v1CreateGenericTaskResponse(Printable):
    """Response to CreateExperimentRequest."""
    warnings: "typing.Optional[typing.Sequence[v1LaunchWarning]]" = None

    def __init__(
        self,
        *,
        taskId: str,
        warnings: "typing.Union[typing.Sequence[v1LaunchWarning], None, Unset]" = _unset,
    ):
        self.taskId = taskId
        if not isinstance(warnings, Unset):
            self.warnings = warnings

    @classmethod
    def from_json(cls, obj: Json) -> "v1CreateGenericTaskResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "taskId": obj["taskId"],
        }
        if "warnings" in obj:
            kwargs["warnings"] = [v1LaunchWarning(x) for x in obj["warnings"]] if obj["warnings"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "taskId": self.taskId,
        }
        if not omit_unset or "warnings" in vars(self):
            out["warnings"] = None if self.warnings is None else [x.value for x in self.warnings]
        return out

class v1CreateGroupRequest(Printable):
    """CreateGroupRequest is the body of the request for the call
    to create a group.
    """
    addUsers: "typing.Optional[typing.Sequence[int]]" = None

    def __init__(
        self,
        *,
        name: str,
        addUsers: "typing.Union[typing.Sequence[int], None, Unset]" = _unset,
    ):
        self.name = name
        if not isinstance(addUsers, Unset):
            self.addUsers = addUsers

    @classmethod
    def from_json(cls, obj: Json) -> "v1CreateGroupRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "name": obj["name"],
        }
        if "addUsers" in obj:
            kwargs["addUsers"] = obj["addUsers"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "name": self.name,
        }
        if not omit_unset or "addUsers" in vars(self):
            out["addUsers"] = self.addUsers
        return out

class v1CreateGroupResponse(Printable):
    """CreateGroupResponse is the body of the response for the call
    to update a group and its members.
    """

    def __init__(
        self,
        *,
        group: "v1GroupDetails",
    ):
        self.group = group

    @classmethod
    def from_json(cls, obj: Json) -> "v1CreateGroupResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "group": v1GroupDetails.from_json(obj["group"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "group": self.group.to_json(omit_unset),
        }
        return out

class v1CreateTrialRequest(Printable):
    """Create a trial."""
    experimentId: "typing.Optional[int]" = None
    hparams: "typing.Optional[typing.Dict[str, typing.Any]]" = None
    unmanaged: "typing.Optional[bool]" = None

    def __init__(
        self,
        *,
        experimentId: "typing.Union[int, None, Unset]" = _unset,
        hparams: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
        unmanaged: "typing.Union[bool, None, Unset]" = _unset,
    ):
        if not isinstance(experimentId, Unset):
            self.experimentId = experimentId
        if not isinstance(hparams, Unset):
            self.hparams = hparams
        if not isinstance(unmanaged, Unset):
            self.unmanaged = unmanaged

    @classmethod
    def from_json(cls, obj: Json) -> "v1CreateTrialRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "experimentId" in obj:
            kwargs["experimentId"] = obj["experimentId"]
        if "hparams" in obj:
            kwargs["hparams"] = obj["hparams"]
        if "unmanaged" in obj:
            kwargs["unmanaged"] = obj["unmanaged"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "experimentId" in vars(self):
            out["experimentId"] = self.experimentId
        if not omit_unset or "hparams" in vars(self):
            out["hparams"] = self.hparams
        if not omit_unset or "unmanaged" in vars(self):
            out["unmanaged"] = self.unmanaged
        return out

class v1CreateTrialResponse(Printable):
    """Response to CreateTrialRequest."""

    def __init__(
        self,
        *,
        trial: "trialv1Trial",
    ):
        self.trial = trial

    @classmethod
    def from_json(cls, obj: Json) -> "v1CreateTrialResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "trial": trialv1Trial.from_json(obj["trial"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "trial": self.trial.to_json(omit_unset),
        }
        return out

class v1CurrentUserResponse(Printable):
    """Response to CurrentUserRequest."""

    def __init__(
        self,
        *,
        user: "v1User",
    ):
        self.user = user

    @classmethod
    def from_json(cls, obj: Json) -> "v1CurrentUserResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "user": v1User.from_json(obj["user"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "user": self.user.to_json(omit_unset),
        }
        return out

class v1CustomWebhookEventData(Printable):
    """Event data for custom trigger."""
    description: "typing.Optional[str]" = None
    level: "typing.Optional[v1LogLevel]" = None
    title: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        description: "typing.Union[str, None, Unset]" = _unset,
        level: "typing.Union[v1LogLevel, None, Unset]" = _unset,
        title: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(description, Unset):
            self.description = description
        if not isinstance(level, Unset):
            self.level = level
        if not isinstance(title, Unset):
            self.title = title

    @classmethod
    def from_json(cls, obj: Json) -> "v1CustomWebhookEventData":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "description" in obj:
            kwargs["description"] = obj["description"]
        if "level" in obj:
            kwargs["level"] = v1LogLevel(obj["level"]) if obj["level"] is not None else None
        if "title" in obj:
            kwargs["title"] = obj["title"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "description" in vars(self):
            out["description"] = self.description
        if not omit_unset or "level" in vars(self):
            out["level"] = None if self.level is None else self.level.value
        if not omit_unset or "title" in vars(self):
            out["title"] = self.title
        return out

class v1DataPoint(Printable):
    """One datapoint in a series of metrics from a trial in batch."""
    epoch: "typing.Optional[float]" = None
    values: "typing.Optional[typing.Dict[str, typing.Any]]" = None

    def __init__(
        self,
        *,
        batches: int,
        time: str,
        epoch: "typing.Union[float, None, Unset]" = _unset,
        values: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
    ):
        self.batches = batches
        self.time = time
        if not isinstance(epoch, Unset):
            self.epoch = epoch
        if not isinstance(values, Unset):
            self.values = values

    @classmethod
    def from_json(cls, obj: Json) -> "v1DataPoint":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "batches": obj["batches"],
            "time": obj["time"],
        }
        if "epoch" in obj:
            kwargs["epoch"] = float(obj["epoch"]) if obj["epoch"] is not None else None
        if "values" in obj:
            kwargs["values"] = obj["values"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "batches": self.batches,
            "time": self.time,
        }
        if not omit_unset or "epoch" in vars(self):
            out["epoch"] = None if self.epoch is None else dump_float(self.epoch)
        if not omit_unset or "values" in vars(self):
            out["values"] = self.values
        return out

class v1DeleteCheckpointsRequest(Printable):

    def __init__(
        self,
        *,
        checkpointUuids: "typing.Sequence[str]",
    ):
        self.checkpointUuids = checkpointUuids

    @classmethod
    def from_json(cls, obj: Json) -> "v1DeleteCheckpointsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "checkpointUuids": obj["checkpointUuids"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "checkpointUuids": self.checkpointUuids,
        }
        return out

class v1DeleteExperimentLabelResponse(Printable):
    """Response to DeleteExperimentLabelRequest."""

    def __init__(
        self,
        *,
        labels: "typing.Sequence[str]",
    ):
        self.labels = labels

    @classmethod
    def from_json(cls, obj: Json) -> "v1DeleteExperimentLabelResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "labels": obj["labels"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "labels": self.labels,
        }
        return out

class v1DeleteExperimentsRequest(Printable):
    """Delete multiple experiments."""
    filters: "typing.Optional[v1BulkExperimentFilters]" = None

    def __init__(
        self,
        *,
        experimentIds: "typing.Sequence[int]",
        projectId: int,
        filters: "typing.Union[v1BulkExperimentFilters, None, Unset]" = _unset,
    ):
        self.experimentIds = experimentIds
        self.projectId = projectId
        if not isinstance(filters, Unset):
            self.filters = filters

    @classmethod
    def from_json(cls, obj: Json) -> "v1DeleteExperimentsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "experimentIds": obj["experimentIds"],
            "projectId": obj["projectId"],
        }
        if "filters" in obj:
            kwargs["filters"] = v1BulkExperimentFilters.from_json(obj["filters"]) if obj["filters"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "experimentIds": self.experimentIds,
            "projectId": self.projectId,
        }
        if not omit_unset or "filters" in vars(self):
            out["filters"] = None if self.filters is None else self.filters.to_json(omit_unset)
        return out

class v1DeleteExperimentsResponse(Printable):
    """Response to DeleteExperimentsRequest."""

    def __init__(
        self,
        *,
        results: "typing.Sequence[v1ExperimentActionResult]",
    ):
        self.results = results

    @classmethod
    def from_json(cls, obj: Json) -> "v1DeleteExperimentsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "results": [v1ExperimentActionResult.from_json(x) for x in obj["results"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "results": [x.to_json(omit_unset) for x in self.results],
        }
        return out

class v1DeleteProjectResponse(Printable):
    """Response to DeleteProjectRequest."""

    def __init__(
        self,
        *,
        completed: bool,
    ):
        self.completed = completed

    @classmethod
    def from_json(cls, obj: Json) -> "v1DeleteProjectResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "completed": obj["completed"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "completed": self.completed,
        }
        return out

class v1DeleteRunsRequest(Printable):
    """Delete runs."""
    filter: "typing.Optional[str]" = None
    projectId: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        runIds: "typing.Sequence[int]",
        filter: "typing.Union[str, None, Unset]" = _unset,
        projectId: "typing.Union[int, None, Unset]" = _unset,
    ):
        self.runIds = runIds
        if not isinstance(filter, Unset):
            self.filter = filter
        if not isinstance(projectId, Unset):
            self.projectId = projectId

    @classmethod
    def from_json(cls, obj: Json) -> "v1DeleteRunsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "runIds": obj["runIds"],
        }
        if "filter" in obj:
            kwargs["filter"] = obj["filter"]
        if "projectId" in obj:
            kwargs["projectId"] = obj["projectId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "runIds": self.runIds,
        }
        if not omit_unset or "filter" in vars(self):
            out["filter"] = self.filter
        if not omit_unset or "projectId" in vars(self):
            out["projectId"] = self.projectId
        return out

class v1DeleteRunsResponse(Printable):
    """Response to DeleteRunsResponse."""

    def __init__(
        self,
        *,
        results: "typing.Sequence[v1RunActionResult]",
    ):
        self.results = results

    @classmethod
    def from_json(cls, obj: Json) -> "v1DeleteRunsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "results": [v1RunActionResult.from_json(x) for x in obj["results"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "results": [x.to_json(omit_unset) for x in self.results],
        }
        return out

class v1DeleteWorkspaceResponse(Printable):
    """Response to DeleteWorkspaceRequest."""

    def __init__(
        self,
        *,
        completed: bool,
    ):
        self.completed = completed

    @classmethod
    def from_json(cls, obj: Json) -> "v1DeleteWorkspaceResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "completed": obj["completed"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "completed": self.completed,
        }
        return out

class v1Device(Printable):
    """Device represents a single computational device on an agent."""
    brand: "typing.Optional[str]" = None
    id: "typing.Optional[int]" = None
    type: "typing.Optional[devicev1Type]" = None
    uuid: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        brand: "typing.Union[str, None, Unset]" = _unset,
        id: "typing.Union[int, None, Unset]" = _unset,
        type: "typing.Union[devicev1Type, None, Unset]" = _unset,
        uuid: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(brand, Unset):
            self.brand = brand
        if not isinstance(id, Unset):
            self.id = id
        if not isinstance(type, Unset):
            self.type = type
        if not isinstance(uuid, Unset):
            self.uuid = uuid

    @classmethod
    def from_json(cls, obj: Json) -> "v1Device":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "brand" in obj:
            kwargs["brand"] = obj["brand"]
        if "id" in obj:
            kwargs["id"] = obj["id"]
        if "type" in obj:
            kwargs["type"] = devicev1Type(obj["type"]) if obj["type"] is not None else None
        if "uuid" in obj:
            kwargs["uuid"] = obj["uuid"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "brand" in vars(self):
            out["brand"] = self.brand
        if not omit_unset or "id" in vars(self):
            out["id"] = self.id
        if not omit_unset or "type" in vars(self):
            out["type"] = None if self.type is None else self.type.value
        if not omit_unset or "uuid" in vars(self):
            out["uuid"] = self.uuid
        return out

class v1DeviceStats(Printable):
    """DeviceStats contains statistics about a single device group."""
    states: "typing.Optional[typing.Dict[str, int]]" = None

    def __init__(
        self,
        *,
        disabled: int,
        draining: int,
        total: int,
        states: "typing.Union[typing.Dict[str, int], None, Unset]" = _unset,
    ):
        self.disabled = disabled
        self.draining = draining
        self.total = total
        if not isinstance(states, Unset):
            self.states = states

    @classmethod
    def from_json(cls, obj: Json) -> "v1DeviceStats":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "disabled": obj["disabled"],
            "draining": obj["draining"],
            "total": obj["total"],
        }
        if "states" in obj:
            kwargs["states"] = obj["states"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "disabled": self.disabled,
            "draining": self.draining,
            "total": self.total,
        }
        if not omit_unset or "states" in vars(self):
            out["states"] = self.states
        return out

class v1DisableAgentRequest(Printable):
    """Disable the agent."""
    agentId: "typing.Optional[str]" = None
    drain: "typing.Optional[bool]" = None

    def __init__(
        self,
        *,
        agentId: "typing.Union[str, None, Unset]" = _unset,
        drain: "typing.Union[bool, None, Unset]" = _unset,
    ):
        if not isinstance(agentId, Unset):
            self.agentId = agentId
        if not isinstance(drain, Unset):
            self.drain = drain

    @classmethod
    def from_json(cls, obj: Json) -> "v1DisableAgentRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "agentId" in obj:
            kwargs["agentId"] = obj["agentId"]
        if "drain" in obj:
            kwargs["drain"] = obj["drain"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "agentId" in vars(self):
            out["agentId"] = self.agentId
        if not omit_unset or "drain" in vars(self):
            out["drain"] = self.drain
        return out

class v1DisableAgentResponse(Printable):
    """Response to DisableAgentRequest."""
    agent: "typing.Optional[v1Agent]" = None

    def __init__(
        self,
        *,
        agent: "typing.Union[v1Agent, None, Unset]" = _unset,
    ):
        if not isinstance(agent, Unset):
            self.agent = agent

    @classmethod
    def from_json(cls, obj: Json) -> "v1DisableAgentResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "agent" in obj:
            kwargs["agent"] = v1Agent.from_json(obj["agent"]) if obj["agent"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "agent" in vars(self):
            out["agent"] = None if self.agent is None else self.agent.to_json(omit_unset)
        return out

class v1DisableSlotRequest(Printable):
    """Disable the slot."""
    agentId: "typing.Optional[str]" = None
    drain: "typing.Optional[bool]" = None
    slotId: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        agentId: "typing.Union[str, None, Unset]" = _unset,
        drain: "typing.Union[bool, None, Unset]" = _unset,
        slotId: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(agentId, Unset):
            self.agentId = agentId
        if not isinstance(drain, Unset):
            self.drain = drain
        if not isinstance(slotId, Unset):
            self.slotId = slotId

    @classmethod
    def from_json(cls, obj: Json) -> "v1DisableSlotRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "agentId" in obj:
            kwargs["agentId"] = obj["agentId"]
        if "drain" in obj:
            kwargs["drain"] = obj["drain"]
        if "slotId" in obj:
            kwargs["slotId"] = obj["slotId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "agentId" in vars(self):
            out["agentId"] = self.agentId
        if not omit_unset or "drain" in vars(self):
            out["drain"] = self.drain
        if not omit_unset or "slotId" in vars(self):
            out["slotId"] = self.slotId
        return out

class v1DisableSlotResponse(Printable):
    """Response to DisableSlotRequest."""
    slot: "typing.Optional[v1Slot]" = None

    def __init__(
        self,
        *,
        slot: "typing.Union[v1Slot, None, Unset]" = _unset,
    ):
        if not isinstance(slot, Unset):
            self.slot = slot

    @classmethod
    def from_json(cls, obj: Json) -> "v1DisableSlotResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "slot" in obj:
            kwargs["slot"] = v1Slot.from_json(obj["slot"]) if obj["slot"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "slot" in vars(self):
            out["slot"] = None if self.slot is None else self.slot.to_json(omit_unset)
        return out

class v1DoubleFieldFilter(Printable):
    """Double filters."""
    gt: "typing.Optional[float]" = None
    gte: "typing.Optional[float]" = None
    lt: "typing.Optional[float]" = None
    lte: "typing.Optional[float]" = None

    def __init__(
        self,
        *,
        gt: "typing.Union[float, None, Unset]" = _unset,
        gte: "typing.Union[float, None, Unset]" = _unset,
        lt: "typing.Union[float, None, Unset]" = _unset,
        lte: "typing.Union[float, None, Unset]" = _unset,
    ):
        if not isinstance(gt, Unset):
            self.gt = gt
        if not isinstance(gte, Unset):
            self.gte = gte
        if not isinstance(lt, Unset):
            self.lt = lt
        if not isinstance(lte, Unset):
            self.lte = lte

    @classmethod
    def from_json(cls, obj: Json) -> "v1DoubleFieldFilter":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "gt" in obj:
            kwargs["gt"] = float(obj["gt"]) if obj["gt"] is not None else None
        if "gte" in obj:
            kwargs["gte"] = float(obj["gte"]) if obj["gte"] is not None else None
        if "lt" in obj:
            kwargs["lt"] = float(obj["lt"]) if obj["lt"] is not None else None
        if "lte" in obj:
            kwargs["lte"] = float(obj["lte"]) if obj["lte"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "gt" in vars(self):
            out["gt"] = None if self.gt is None else dump_float(self.gt)
        if not omit_unset or "gte" in vars(self):
            out["gte"] = None if self.gte is None else dump_float(self.gte)
        if not omit_unset or "lt" in vars(self):
            out["lt"] = None if self.lt is None else dump_float(self.lt)
        if not omit_unset or "lte" in vars(self):
            out["lte"] = None if self.lte is None else dump_float(self.lte)
        return out

class v1DownsampledMetrics(Printable):
    """DownsampledMetrics captures a metric's name and downsampled data points."""

    def __init__(
        self,
        *,
        data: "typing.Sequence[v1DataPoint]",
        group: str,
        type: "v1MetricType",
    ):
        self.data = data
        self.group = group
        self.type = type

    @classmethod
    def from_json(cls, obj: Json) -> "v1DownsampledMetrics":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "data": [v1DataPoint.from_json(x) for x in obj["data"]],
            "group": obj["group"],
            "type": v1MetricType(obj["type"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "data": [x.to_json(omit_unset) for x in self.data],
            "group": self.group,
            "type": self.type.value,
        }
        return out

class v1EnableAgentResponse(Printable):
    """Response to EnableAgentRequest."""
    agent: "typing.Optional[v1Agent]" = None

    def __init__(
        self,
        *,
        agent: "typing.Union[v1Agent, None, Unset]" = _unset,
    ):
        if not isinstance(agent, Unset):
            self.agent = agent

    @classmethod
    def from_json(cls, obj: Json) -> "v1EnableAgentResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "agent" in obj:
            kwargs["agent"] = v1Agent.from_json(obj["agent"]) if obj["agent"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "agent" in vars(self):
            out["agent"] = None if self.agent is None else self.agent.to_json(omit_unset)
        return out

class v1EnableSlotResponse(Printable):
    """Response to EnableSlotRequest."""
    slot: "typing.Optional[v1Slot]" = None

    def __init__(
        self,
        *,
        slot: "typing.Union[v1Slot, None, Unset]" = _unset,
    ):
        if not isinstance(slot, Unset):
            self.slot = slot

    @classmethod
    def from_json(cls, obj: Json) -> "v1EnableSlotResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "slot" in obj:
            kwargs["slot"] = v1Slot.from_json(obj["slot"]) if obj["slot"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "slot" in vars(self):
            out["slot"] = None if self.slot is None else self.slot.to_json(omit_unset)
        return out

class v1EntityType(DetEnum):
    """EntityType represents an entity
    - ENTITY_TYPE_UNSPECIFIED: Default entity type.
    - ENTITY_TYPE_PROJECT: Represents a project.
    """
    UNSPECIFIED = "ENTITY_TYPE_UNSPECIFIED"
    PROJECT = "ENTITY_TYPE_PROJECT"

class v1ExpMetricNamesResponse(Printable):
    """Response to ExpMetricNamesRequest."""
    metricNames: "typing.Optional[typing.Sequence[v1MetricIdentifier]]" = None
    searcherMetrics: "typing.Optional[typing.Sequence[str]]" = None
    trainingMetrics: "typing.Optional[typing.Sequence[str]]" = None
    validationMetrics: "typing.Optional[typing.Sequence[str]]" = None

    def __init__(
        self,
        *,
        metricNames: "typing.Union[typing.Sequence[v1MetricIdentifier], None, Unset]" = _unset,
        searcherMetrics: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
        trainingMetrics: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
        validationMetrics: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
    ):
        if not isinstance(metricNames, Unset):
            self.metricNames = metricNames
        if not isinstance(searcherMetrics, Unset):
            self.searcherMetrics = searcherMetrics
        if not isinstance(trainingMetrics, Unset):
            self.trainingMetrics = trainingMetrics
        if not isinstance(validationMetrics, Unset):
            self.validationMetrics = validationMetrics

    @classmethod
    def from_json(cls, obj: Json) -> "v1ExpMetricNamesResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "metricNames" in obj:
            kwargs["metricNames"] = [v1MetricIdentifier.from_json(x) for x in obj["metricNames"]] if obj["metricNames"] is not None else None
        if "searcherMetrics" in obj:
            kwargs["searcherMetrics"] = obj["searcherMetrics"]
        if "trainingMetrics" in obj:
            kwargs["trainingMetrics"] = obj["trainingMetrics"]
        if "validationMetrics" in obj:
            kwargs["validationMetrics"] = obj["validationMetrics"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "metricNames" in vars(self):
            out["metricNames"] = None if self.metricNames is None else [x.to_json(omit_unset) for x in self.metricNames]
        if not omit_unset or "searcherMetrics" in vars(self):
            out["searcherMetrics"] = self.searcherMetrics
        if not omit_unset or "trainingMetrics" in vars(self):
            out["trainingMetrics"] = self.trainingMetrics
        if not omit_unset or "validationMetrics" in vars(self):
            out["validationMetrics"] = self.validationMetrics
        return out

class v1Experiment(Printable):
    """Experiment is a collection of one or more trials that are exploring a
    user-defined hyperparameter space.
    """
    bestTrialId: "typing.Optional[int]" = None
    bestTrialSearcherMetric: "typing.Optional[float]" = None
    checkpointCount: "typing.Optional[int]" = None
    checkpointSize: "typing.Optional[str]" = None
    description: "typing.Optional[str]" = None
    displayName: "typing.Optional[str]" = None
    duration: "typing.Optional[int]" = None
    endTime: "typing.Optional[str]" = None
    externalExperimentId: "typing.Optional[str]" = None
    externalTrialId: "typing.Optional[str]" = None
    forkedFrom: "typing.Optional[int]" = None
    hyperparameters: "typing.Optional[typing.Dict[str, typing.Any]]" = None
    labels: "typing.Optional[typing.Sequence[str]]" = None
    modelDefinitionSize: "typing.Optional[int]" = None
    notes: "typing.Optional[str]" = None
    pachydermIntegration: "typing.Optional[typing.Dict[str, typing.Any]]" = None
    parentArchived: "typing.Optional[bool]" = None
    progress: "typing.Optional[float]" = None
    projectName: "typing.Optional[str]" = None
    resourcePool: "typing.Optional[str]" = None
    searcherMetric: "typing.Optional[str]" = None
    trialIds: "typing.Optional[typing.Sequence[int]]" = None
    unmanaged: "typing.Optional[bool]" = None
    userId: "typing.Optional[int]" = None
    workspaceId: "typing.Optional[int]" = None
    workspaceName: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        archived: bool,
        config: "typing.Dict[str, typing.Any]",
        id: int,
        jobId: str,
        name: str,
        numTrials: int,
        originalConfig: str,
        projectId: int,
        projectOwnerId: int,
        searcherType: str,
        startTime: str,
        state: "experimentv1State",
        username: str,
        bestTrialId: "typing.Union[int, None, Unset]" = _unset,
        bestTrialSearcherMetric: "typing.Union[float, None, Unset]" = _unset,
        checkpointCount: "typing.Union[int, None, Unset]" = _unset,
        checkpointSize: "typing.Union[str, None, Unset]" = _unset,
        description: "typing.Union[str, None, Unset]" = _unset,
        displayName: "typing.Union[str, None, Unset]" = _unset,
        duration: "typing.Union[int, None, Unset]" = _unset,
        endTime: "typing.Union[str, None, Unset]" = _unset,
        externalExperimentId: "typing.Union[str, None, Unset]" = _unset,
        externalTrialId: "typing.Union[str, None, Unset]" = _unset,
        forkedFrom: "typing.Union[int, None, Unset]" = _unset,
        hyperparameters: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
        labels: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
        modelDefinitionSize: "typing.Union[int, None, Unset]" = _unset,
        notes: "typing.Union[str, None, Unset]" = _unset,
        pachydermIntegration: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
        parentArchived: "typing.Union[bool, None, Unset]" = _unset,
        progress: "typing.Union[float, None, Unset]" = _unset,
        projectName: "typing.Union[str, None, Unset]" = _unset,
        resourcePool: "typing.Union[str, None, Unset]" = _unset,
        searcherMetric: "typing.Union[str, None, Unset]" = _unset,
        trialIds: "typing.Union[typing.Sequence[int], None, Unset]" = _unset,
        unmanaged: "typing.Union[bool, None, Unset]" = _unset,
        userId: "typing.Union[int, None, Unset]" = _unset,
        workspaceId: "typing.Union[int, None, Unset]" = _unset,
        workspaceName: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.archived = archived
        self.config = config
        self.id = id
        self.jobId = jobId
        self.name = name
        self.numTrials = numTrials
        self.originalConfig = originalConfig
        self.projectId = projectId
        self.projectOwnerId = projectOwnerId
        self.searcherType = searcherType
        self.startTime = startTime
        self.state = state
        self.username = username
        if not isinstance(bestTrialId, Unset):
            self.bestTrialId = bestTrialId
        if not isinstance(bestTrialSearcherMetric, Unset):
            self.bestTrialSearcherMetric = bestTrialSearcherMetric
        if not isinstance(checkpointCount, Unset):
            self.checkpointCount = checkpointCount
        if not isinstance(checkpointSize, Unset):
            self.checkpointSize = checkpointSize
        if not isinstance(description, Unset):
            self.description = description
        if not isinstance(displayName, Unset):
            self.displayName = displayName
        if not isinstance(duration, Unset):
            self.duration = duration
        if not isinstance(endTime, Unset):
            self.endTime = endTime
        if not isinstance(externalExperimentId, Unset):
            self.externalExperimentId = externalExperimentId
        if not isinstance(externalTrialId, Unset):
            self.externalTrialId = externalTrialId
        if not isinstance(forkedFrom, Unset):
            self.forkedFrom = forkedFrom
        if not isinstance(hyperparameters, Unset):
            self.hyperparameters = hyperparameters
        if not isinstance(labels, Unset):
            self.labels = labels
        if not isinstance(modelDefinitionSize, Unset):
            self.modelDefinitionSize = modelDefinitionSize
        if not isinstance(notes, Unset):
            self.notes = notes
        if not isinstance(pachydermIntegration, Unset):
            self.pachydermIntegration = pachydermIntegration
        if not isinstance(parentArchived, Unset):
            self.parentArchived = parentArchived
        if not isinstance(progress, Unset):
            self.progress = progress
        if not isinstance(projectName, Unset):
            self.projectName = projectName
        if not isinstance(resourcePool, Unset):
            self.resourcePool = resourcePool
        if not isinstance(searcherMetric, Unset):
            self.searcherMetric = searcherMetric
        if not isinstance(trialIds, Unset):
            self.trialIds = trialIds
        if not isinstance(unmanaged, Unset):
            self.unmanaged = unmanaged
        if not isinstance(userId, Unset):
            self.userId = userId
        if not isinstance(workspaceId, Unset):
            self.workspaceId = workspaceId
        if not isinstance(workspaceName, Unset):
            self.workspaceName = workspaceName

    @classmethod
    def from_json(cls, obj: Json) -> "v1Experiment":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "archived": obj["archived"],
            "config": obj["config"],
            "id": obj["id"],
            "jobId": obj["jobId"],
            "name": obj["name"],
            "numTrials": obj["numTrials"],
            "originalConfig": obj["originalConfig"],
            "projectId": obj["projectId"],
            "projectOwnerId": obj["projectOwnerId"],
            "searcherType": obj["searcherType"],
            "startTime": obj["startTime"],
            "state": experimentv1State(obj["state"]),
            "username": obj["username"],
        }
        if "bestTrialId" in obj:
            kwargs["bestTrialId"] = obj["bestTrialId"]
        if "bestTrialSearcherMetric" in obj:
            kwargs["bestTrialSearcherMetric"] = float(obj["bestTrialSearcherMetric"]) if obj["bestTrialSearcherMetric"] is not None else None
        if "checkpointCount" in obj:
            kwargs["checkpointCount"] = obj["checkpointCount"]
        if "checkpointSize" in obj:
            kwargs["checkpointSize"] = obj["checkpointSize"]
        if "description" in obj:
            kwargs["description"] = obj["description"]
        if "displayName" in obj:
            kwargs["displayName"] = obj["displayName"]
        if "duration" in obj:
            kwargs["duration"] = obj["duration"]
        if "endTime" in obj:
            kwargs["endTime"] = obj["endTime"]
        if "externalExperimentId" in obj:
            kwargs["externalExperimentId"] = obj["externalExperimentId"]
        if "externalTrialId" in obj:
            kwargs["externalTrialId"] = obj["externalTrialId"]
        if "forkedFrom" in obj:
            kwargs["forkedFrom"] = obj["forkedFrom"]
        if "hyperparameters" in obj:
            kwargs["hyperparameters"] = obj["hyperparameters"]
        if "labels" in obj:
            kwargs["labels"] = obj["labels"]
        if "modelDefinitionSize" in obj:
            kwargs["modelDefinitionSize"] = obj["modelDefinitionSize"]
        if "notes" in obj:
            kwargs["notes"] = obj["notes"]
        if "pachydermIntegration" in obj:
            kwargs["pachydermIntegration"] = obj["pachydermIntegration"]
        if "parentArchived" in obj:
            kwargs["parentArchived"] = obj["parentArchived"]
        if "progress" in obj:
            kwargs["progress"] = float(obj["progress"]) if obj["progress"] is not None else None
        if "projectName" in obj:
            kwargs["projectName"] = obj["projectName"]
        if "resourcePool" in obj:
            kwargs["resourcePool"] = obj["resourcePool"]
        if "searcherMetric" in obj:
            kwargs["searcherMetric"] = obj["searcherMetric"]
        if "trialIds" in obj:
            kwargs["trialIds"] = obj["trialIds"]
        if "unmanaged" in obj:
            kwargs["unmanaged"] = obj["unmanaged"]
        if "userId" in obj:
            kwargs["userId"] = obj["userId"]
        if "workspaceId" in obj:
            kwargs["workspaceId"] = obj["workspaceId"]
        if "workspaceName" in obj:
            kwargs["workspaceName"] = obj["workspaceName"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "archived": self.archived,
            "config": self.config,
            "id": self.id,
            "jobId": self.jobId,
            "name": self.name,
            "numTrials": self.numTrials,
            "originalConfig": self.originalConfig,
            "projectId": self.projectId,
            "projectOwnerId": self.projectOwnerId,
            "searcherType": self.searcherType,
            "startTime": self.startTime,
            "state": self.state.value,
            "username": self.username,
        }
        if not omit_unset or "bestTrialId" in vars(self):
            out["bestTrialId"] = self.bestTrialId
        if not omit_unset or "bestTrialSearcherMetric" in vars(self):
            out["bestTrialSearcherMetric"] = None if self.bestTrialSearcherMetric is None else dump_float(self.bestTrialSearcherMetric)
        if not omit_unset or "checkpointCount" in vars(self):
            out["checkpointCount"] = self.checkpointCount
        if not omit_unset or "checkpointSize" in vars(self):
            out["checkpointSize"] = self.checkpointSize
        if not omit_unset or "description" in vars(self):
            out["description"] = self.description
        if not omit_unset or "displayName" in vars(self):
            out["displayName"] = self.displayName
        if not omit_unset or "duration" in vars(self):
            out["duration"] = self.duration
        if not omit_unset or "endTime" in vars(self):
            out["endTime"] = self.endTime
        if not omit_unset or "externalExperimentId" in vars(self):
            out["externalExperimentId"] = self.externalExperimentId
        if not omit_unset or "externalTrialId" in vars(self):
            out["externalTrialId"] = self.externalTrialId
        if not omit_unset or "forkedFrom" in vars(self):
            out["forkedFrom"] = self.forkedFrom
        if not omit_unset or "hyperparameters" in vars(self):
            out["hyperparameters"] = self.hyperparameters
        if not omit_unset or "labels" in vars(self):
            out["labels"] = self.labels
        if not omit_unset or "modelDefinitionSize" in vars(self):
            out["modelDefinitionSize"] = self.modelDefinitionSize
        if not omit_unset or "notes" in vars(self):
            out["notes"] = self.notes
        if not omit_unset or "pachydermIntegration" in vars(self):
            out["pachydermIntegration"] = self.pachydermIntegration
        if not omit_unset or "parentArchived" in vars(self):
            out["parentArchived"] = self.parentArchived
        if not omit_unset or "progress" in vars(self):
            out["progress"] = None if self.progress is None else dump_float(self.progress)
        if not omit_unset or "projectName" in vars(self):
            out["projectName"] = self.projectName
        if not omit_unset or "resourcePool" in vars(self):
            out["resourcePool"] = self.resourcePool
        if not omit_unset or "searcherMetric" in vars(self):
            out["searcherMetric"] = self.searcherMetric
        if not omit_unset or "trialIds" in vars(self):
            out["trialIds"] = self.trialIds
        if not omit_unset or "unmanaged" in vars(self):
            out["unmanaged"] = self.unmanaged
        if not omit_unset or "userId" in vars(self):
            out["userId"] = self.userId
        if not omit_unset or "workspaceId" in vars(self):
            out["workspaceId"] = self.workspaceId
        if not omit_unset or "workspaceName" in vars(self):
            out["workspaceName"] = self.workspaceName
        return out

class v1ExperimentActionResult(Printable):
    """Message for results of individual experiments in a multi-experiment action."""

    def __init__(
        self,
        *,
        error: str,
        id: int,
    ):
        self.error = error
        self.id = id

    @classmethod
    def from_json(cls, obj: Json) -> "v1ExperimentActionResult":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "error": obj["error"],
            "id": obj["id"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "error": self.error,
            "id": self.id,
        }
        return out

class v1FailureType(DetEnum):
    """The failure type of a resource.
    - FAILURE_TYPE_UNSPECIFIED: UNSPECIFIED denotes an error that is not defined below.
    - FAILURE_TYPE_RESOURCES_FAILED: ResourcesFailed denotes that the container ran but failed with a non-zero
    exit code.
    - FAILURE_TYPE_RESOURCES_ABORTED: ResourcesAborted denotes the container was canceled before it was started.
    - FAILURE_TYPE_RESOURCES_MISSING: ResourcesMissing denotes the resources were missing when the master asked
    about it.
    - FAILURE_TYPE_TASK_ABORTED: TaskAborted denotes that the task was canceled before it was started.
    - FAILURE_TYPE_TASK_ERROR: TaskError denotes that the task failed without an associated exit code.
    - FAILURE_TYPE_AGENT_FAILED: AgentFailed denotes that the agent failed while the container was running.
    - FAILURE_TYPE_AGENT_ERROR: AgentError denotes that the agent failed to launch the container.
    - FAILURE_TYPE_RESTORE_ERROR: RestoreError denotes a failure to restore a running allocation on master
    blip.
    - FAILURE_TYPE_UNKNOWN_ERROR: UnknownError denotes an internal error that did not map to a know failure
    type.
    """
    UNSPECIFIED = "FAILURE_TYPE_UNSPECIFIED"
    RESOURCES_FAILED = "FAILURE_TYPE_RESOURCES_FAILED"
    RESOURCES_ABORTED = "FAILURE_TYPE_RESOURCES_ABORTED"
    RESOURCES_MISSING = "FAILURE_TYPE_RESOURCES_MISSING"
    TASK_ABORTED = "FAILURE_TYPE_TASK_ABORTED"
    TASK_ERROR = "FAILURE_TYPE_TASK_ERROR"
    AGENT_FAILED = "FAILURE_TYPE_AGENT_FAILED"
    AGENT_ERROR = "FAILURE_TYPE_AGENT_ERROR"
    RESTORE_ERROR = "FAILURE_TYPE_RESTORE_ERROR"
    UNKNOWN_ERROR = "FAILURE_TYPE_UNKNOWN_ERROR"

class v1File(Printable):
    """File is a Unix file."""

    def __init__(
        self,
        *,
        content: str,
        gid: int,
        mode: int,
        mtime: str,
        path: str,
        type: int,
        uid: int,
    ):
        self.content = content
        self.gid = gid
        self.mode = mode
        self.mtime = mtime
        self.path = path
        self.type = type
        self.uid = uid

    @classmethod
    def from_json(cls, obj: Json) -> "v1File":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "content": obj["content"],
            "gid": obj["gid"],
            "mode": obj["mode"],
            "mtime": obj["mtime"],
            "path": obj["path"],
            "type": obj["type"],
            "uid": obj["uid"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "content": self.content,
            "gid": self.gid,
            "mode": self.mode,
            "mtime": self.mtime,
            "path": self.path,
            "type": self.type,
            "uid": self.uid,
        }
        return out

class v1FileNode(Printable):
    """File node is one node of file in experiment model definition file tree."""
    contentLength: "typing.Optional[int]" = None
    contentType: "typing.Optional[str]" = None
    files: "typing.Optional[typing.Sequence[v1FileNode]]" = None
    isDir: "typing.Optional[bool]" = None
    modifiedTime: "typing.Optional[str]" = None
    name: "typing.Optional[str]" = None
    path: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        contentLength: "typing.Union[int, None, Unset]" = _unset,
        contentType: "typing.Union[str, None, Unset]" = _unset,
        files: "typing.Union[typing.Sequence[v1FileNode], None, Unset]" = _unset,
        isDir: "typing.Union[bool, None, Unset]" = _unset,
        modifiedTime: "typing.Union[str, None, Unset]" = _unset,
        name: "typing.Union[str, None, Unset]" = _unset,
        path: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(contentLength, Unset):
            self.contentLength = contentLength
        if not isinstance(contentType, Unset):
            self.contentType = contentType
        if not isinstance(files, Unset):
            self.files = files
        if not isinstance(isDir, Unset):
            self.isDir = isDir
        if not isinstance(modifiedTime, Unset):
            self.modifiedTime = modifiedTime
        if not isinstance(name, Unset):
            self.name = name
        if not isinstance(path, Unset):
            self.path = path

    @classmethod
    def from_json(cls, obj: Json) -> "v1FileNode":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "contentLength" in obj:
            kwargs["contentLength"] = obj["contentLength"]
        if "contentType" in obj:
            kwargs["contentType"] = obj["contentType"]
        if "files" in obj:
            kwargs["files"] = [v1FileNode.from_json(x) for x in obj["files"]] if obj["files"] is not None else None
        if "isDir" in obj:
            kwargs["isDir"] = obj["isDir"]
        if "modifiedTime" in obj:
            kwargs["modifiedTime"] = obj["modifiedTime"]
        if "name" in obj:
            kwargs["name"] = obj["name"]
        if "path" in obj:
            kwargs["path"] = obj["path"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "contentLength" in vars(self):
            out["contentLength"] = self.contentLength
        if not omit_unset or "contentType" in vars(self):
            out["contentType"] = self.contentType
        if not omit_unset or "files" in vars(self):
            out["files"] = None if self.files is None else [x.to_json(omit_unset) for x in self.files]
        if not omit_unset or "isDir" in vars(self):
            out["isDir"] = self.isDir
        if not omit_unset or "modifiedTime" in vars(self):
            out["modifiedTime"] = self.modifiedTime
        if not omit_unset or "name" in vars(self):
            out["name"] = self.name
        if not omit_unset or "path" in vars(self):
            out["path"] = self.path
        return out

class v1FittingPolicy(DetEnum):
    """The fitting policy of the scheduler.
    - FITTING_POLICY_UNSPECIFIED: Unspecified. This value will never actually be returned by the API, it is
    just an artifact of using protobuf.
    - FITTING_POLICY_BEST: Best fit. Tasks are preferentially “packed” together on the smallest number
    of agents
    - FITTING_POLICY_WORST: Worst fit. Tasks are placed on under-utilized agents, spreading out the
    tasks.
    - FITTING_POLICY_KUBERNETES: A kubernetes placeholder. In k8s, the task placement is delegated to the
    k8s scheduler so the fitting policy is not relevant.
    - FITTING_POLICY_SLURM: A slurm placeholder. When running on slurm, task placement is delegated.
    - FITTING_POLICY_PBS: A PBS placeholder. When running on PBS, task placement is delegated.
    """
    UNSPECIFIED = "FITTING_POLICY_UNSPECIFIED"
    BEST = "FITTING_POLICY_BEST"
    WORST = "FITTING_POLICY_WORST"
    KUBERNETES = "FITTING_POLICY_KUBERNETES"
    SLURM = "FITTING_POLICY_SLURM"
    PBS = "FITTING_POLICY_PBS"

class v1FlatRun(Printable):
    """Flat run respresentation. Used for the rows of the Run Table."""
    duration: "typing.Optional[int]" = None
    endTime: "typing.Optional[str]" = None
    experiment: "typing.Optional[v1FlatRunExperiment]" = None
    externalRunId: "typing.Optional[str]" = None
    hyperparameters: "typing.Optional[typing.Dict[str, typing.Any]]" = None
    labels: "typing.Optional[typing.Sequence[str]]" = None
    localId: "typing.Optional[str]" = None
    logPolicyMatched: "typing.Optional[str]" = None
    metadata: "typing.Optional[typing.Dict[str, typing.Any]]" = None
    searcherMetricValue: "typing.Optional[float]" = None
    summaryMetrics: "typing.Optional[typing.Dict[str, typing.Any]]" = None
    userId: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        archived: bool,
        checkpointCount: int,
        checkpointSize: str,
        id: int,
        parentArchived: bool,
        projectId: int,
        projectName: str,
        startTime: str,
        state: "trialv1State",
        workspaceId: int,
        workspaceName: str,
        duration: "typing.Union[int, None, Unset]" = _unset,
        endTime: "typing.Union[str, None, Unset]" = _unset,
        experiment: "typing.Union[v1FlatRunExperiment, None, Unset]" = _unset,
        externalRunId: "typing.Union[str, None, Unset]" = _unset,
        hyperparameters: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
        labels: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
        localId: "typing.Union[str, None, Unset]" = _unset,
        logPolicyMatched: "typing.Union[str, None, Unset]" = _unset,
        metadata: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
        searcherMetricValue: "typing.Union[float, None, Unset]" = _unset,
        summaryMetrics: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
        userId: "typing.Union[int, None, Unset]" = _unset,
    ):
        self.archived = archived
        self.checkpointCount = checkpointCount
        self.checkpointSize = checkpointSize
        self.id = id
        self.parentArchived = parentArchived
        self.projectId = projectId
        self.projectName = projectName
        self.startTime = startTime
        self.state = state
        self.workspaceId = workspaceId
        self.workspaceName = workspaceName
        if not isinstance(duration, Unset):
            self.duration = duration
        if not isinstance(endTime, Unset):
            self.endTime = endTime
        if not isinstance(experiment, Unset):
            self.experiment = experiment
        if not isinstance(externalRunId, Unset):
            self.externalRunId = externalRunId
        if not isinstance(hyperparameters, Unset):
            self.hyperparameters = hyperparameters
        if not isinstance(labels, Unset):
            self.labels = labels
        if not isinstance(localId, Unset):
            self.localId = localId
        if not isinstance(logPolicyMatched, Unset):
            self.logPolicyMatched = logPolicyMatched
        if not isinstance(metadata, Unset):
            self.metadata = metadata
        if not isinstance(searcherMetricValue, Unset):
            self.searcherMetricValue = searcherMetricValue
        if not isinstance(summaryMetrics, Unset):
            self.summaryMetrics = summaryMetrics
        if not isinstance(userId, Unset):
            self.userId = userId

    @classmethod
    def from_json(cls, obj: Json) -> "v1FlatRun":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "archived": obj["archived"],
            "checkpointCount": obj["checkpointCount"],
            "checkpointSize": obj["checkpointSize"],
            "id": obj["id"],
            "parentArchived": obj["parentArchived"],
            "projectId": obj["projectId"],
            "projectName": obj["projectName"],
            "startTime": obj["startTime"],
            "state": trialv1State(obj["state"]),
            "workspaceId": obj["workspaceId"],
            "workspaceName": obj["workspaceName"],
        }
        if "duration" in obj:
            kwargs["duration"] = obj["duration"]
        if "endTime" in obj:
            kwargs["endTime"] = obj["endTime"]
        if "experiment" in obj:
            kwargs["experiment"] = v1FlatRunExperiment.from_json(obj["experiment"]) if obj["experiment"] is not None else None
        if "externalRunId" in obj:
            kwargs["externalRunId"] = obj["externalRunId"]
        if "hyperparameters" in obj:
            kwargs["hyperparameters"] = obj["hyperparameters"]
        if "labels" in obj:
            kwargs["labels"] = obj["labels"]
        if "localId" in obj:
            kwargs["localId"] = obj["localId"]
        if "logPolicyMatched" in obj:
            kwargs["logPolicyMatched"] = obj["logPolicyMatched"]
        if "metadata" in obj:
            kwargs["metadata"] = obj["metadata"]
        if "searcherMetricValue" in obj:
            kwargs["searcherMetricValue"] = float(obj["searcherMetricValue"]) if obj["searcherMetricValue"] is not None else None
        if "summaryMetrics" in obj:
            kwargs["summaryMetrics"] = obj["summaryMetrics"]
        if "userId" in obj:
            kwargs["userId"] = obj["userId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "archived": self.archived,
            "checkpointCount": self.checkpointCount,
            "checkpointSize": self.checkpointSize,
            "id": self.id,
            "parentArchived": self.parentArchived,
            "projectId": self.projectId,
            "projectName": self.projectName,
            "startTime": self.startTime,
            "state": self.state.value,
            "workspaceId": self.workspaceId,
            "workspaceName": self.workspaceName,
        }
        if not omit_unset or "duration" in vars(self):
            out["duration"] = self.duration
        if not omit_unset or "endTime" in vars(self):
            out["endTime"] = self.endTime
        if not omit_unset or "experiment" in vars(self):
            out["experiment"] = None if self.experiment is None else self.experiment.to_json(omit_unset)
        if not omit_unset or "externalRunId" in vars(self):
            out["externalRunId"] = self.externalRunId
        if not omit_unset or "hyperparameters" in vars(self):
            out["hyperparameters"] = self.hyperparameters
        if not omit_unset or "labels" in vars(self):
            out["labels"] = self.labels
        if not omit_unset or "localId" in vars(self):
            out["localId"] = self.localId
        if not omit_unset or "logPolicyMatched" in vars(self):
            out["logPolicyMatched"] = self.logPolicyMatched
        if not omit_unset or "metadata" in vars(self):
            out["metadata"] = self.metadata
        if not omit_unset or "searcherMetricValue" in vars(self):
            out["searcherMetricValue"] = None if self.searcherMetricValue is None else dump_float(self.searcherMetricValue)
        if not omit_unset or "summaryMetrics" in vars(self):
            out["summaryMetrics"] = self.summaryMetrics
        if not omit_unset or "userId" in vars(self):
            out["userId"] = self.userId
        return out

class v1FlatRunExperiment(Printable):
    externalExperimentId: "typing.Optional[str]" = None
    forkedFrom: "typing.Optional[int]" = None
    pachydermIntegration: "typing.Optional[typing.Dict[str, typing.Any]]" = None

    def __init__(
        self,
        *,
        description: str,
        id: int,
        isMultitrial: bool,
        name: str,
        progress: float,
        resourcePool: str,
        searcherMetric: str,
        searcherType: str,
        unmanaged: bool,
        externalExperimentId: "typing.Union[str, None, Unset]" = _unset,
        forkedFrom: "typing.Union[int, None, Unset]" = _unset,
        pachydermIntegration: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
    ):
        self.description = description
        self.id = id
        self.isMultitrial = isMultitrial
        self.name = name
        self.progress = progress
        self.resourcePool = resourcePool
        self.searcherMetric = searcherMetric
        self.searcherType = searcherType
        self.unmanaged = unmanaged
        if not isinstance(externalExperimentId, Unset):
            self.externalExperimentId = externalExperimentId
        if not isinstance(forkedFrom, Unset):
            self.forkedFrom = forkedFrom
        if not isinstance(pachydermIntegration, Unset):
            self.pachydermIntegration = pachydermIntegration

    @classmethod
    def from_json(cls, obj: Json) -> "v1FlatRunExperiment":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "description": obj["description"],
            "id": obj["id"],
            "isMultitrial": obj["isMultitrial"],
            "name": obj["name"],
            "progress": float(obj["progress"]),
            "resourcePool": obj["resourcePool"],
            "searcherMetric": obj["searcherMetric"],
            "searcherType": obj["searcherType"],
            "unmanaged": obj["unmanaged"],
        }
        if "externalExperimentId" in obj:
            kwargs["externalExperimentId"] = obj["externalExperimentId"]
        if "forkedFrom" in obj:
            kwargs["forkedFrom"] = obj["forkedFrom"]
        if "pachydermIntegration" in obj:
            kwargs["pachydermIntegration"] = obj["pachydermIntegration"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "description": self.description,
            "id": self.id,
            "isMultitrial": self.isMultitrial,
            "name": self.name,
            "progress": dump_float(self.progress),
            "resourcePool": self.resourcePool,
            "searcherMetric": self.searcherMetric,
            "searcherType": self.searcherType,
            "unmanaged": self.unmanaged,
        }
        if not omit_unset or "externalExperimentId" in vars(self):
            out["externalExperimentId"] = self.externalExperimentId
        if not omit_unset or "forkedFrom" in vars(self):
            out["forkedFrom"] = self.forkedFrom
        if not omit_unset or "pachydermIntegration" in vars(self):
            out["pachydermIntegration"] = self.pachydermIntegration
        return out

class v1GenericTaskState(DetEnum):
    """State of a Generic task
    - GENERIC_TASK_STATE_UNSPECIFIED: The task state unknown
    - GENERIC_TASK_STATE_ACTIVE: The task state unknown
    - GENERIC_TASK_STATE_CANCELED: The task state unknown
    - GENERIC_TASK_STATE_COMPLETED: The task state unknown
    - GENERIC_TASK_STATE_ERROR: The task state unknown
    - GENERIC_TASK_STATE_PAUSED: The task state unknown
    - GENERIC_TASK_STATE_STOPPING_PAUSED: The task state unknown
    - GENERIC_TASK_STATE_STOPPING_CANCELED: The task state unknown
    - GENERIC_TASK_STATE_STOPPING_COMPLETED: The task state unknown
    - GENERIC_TASK_STATE_STOPPING_ERROR: The task state unknown
    """
    UNSPECIFIED = "GENERIC_TASK_STATE_UNSPECIFIED"
    ACTIVE = "GENERIC_TASK_STATE_ACTIVE"
    CANCELED = "GENERIC_TASK_STATE_CANCELED"
    COMPLETED = "GENERIC_TASK_STATE_COMPLETED"
    ERROR = "GENERIC_TASK_STATE_ERROR"
    PAUSED = "GENERIC_TASK_STATE_PAUSED"
    STOPPING_PAUSED = "GENERIC_TASK_STATE_STOPPING_PAUSED"
    STOPPING_CANCELED = "GENERIC_TASK_STATE_STOPPING_CANCELED"
    STOPPING_COMPLETED = "GENERIC_TASK_STATE_STOPPING_COMPLETED"
    STOPPING_ERROR = "GENERIC_TASK_STATE_STOPPING_ERROR"

class v1GetAccessTokensRequestSortBy(DetEnum):
    """Sort token info by the given field.
    - SORT_BY_UNSPECIFIED: Returns token info in an unsorted list.
    - SORT_BY_USER_ID: Returns token info sorted by user id.
    - SORT_BY_EXPIRY: Returns token info sorted by expiry.
    - SORT_BY_CREATED_AT: Returns token info sorted by created at.
    - SORT_BY_TOKEN_TYPE: Returns token info sorted by token type.
    - SORT_BY_REVOKED: Returns token info sorted by if it is revoked.
    - SORT_BY_DESCRIPTION: Returns token info sorted by description of token.
    """
    UNSPECIFIED = "SORT_BY_UNSPECIFIED"
    USER_ID = "SORT_BY_USER_ID"
    EXPIRY = "SORT_BY_EXPIRY"
    CREATED_AT = "SORT_BY_CREATED_AT"
    TOKEN_TYPE = "SORT_BY_TOKEN_TYPE"
    REVOKED = "SORT_BY_REVOKED"
    DESCRIPTION = "SORT_BY_DESCRIPTION"

class v1GetAccessTokensResponse(Printable):
    """Response to GetAccessTokensRequest."""
    pagination: "typing.Optional[v1Pagination]" = None

    def __init__(
        self,
        *,
        tokenInfo: "typing.Sequence[v1TokenInfo]",
        pagination: "typing.Union[v1Pagination, None, Unset]" = _unset,
    ):
        self.tokenInfo = tokenInfo
        if not isinstance(pagination, Unset):
            self.pagination = pagination

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetAccessTokensResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "tokenInfo": [v1TokenInfo.from_json(x) for x in obj["tokenInfo"]],
        }
        if "pagination" in obj:
            kwargs["pagination"] = v1Pagination.from_json(obj["pagination"]) if obj["pagination"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "tokenInfo": [x.to_json(omit_unset) for x in self.tokenInfo],
        }
        if not omit_unset or "pagination" in vars(self):
            out["pagination"] = None if self.pagination is None else self.pagination.to_json(omit_unset)
        return out

class v1GetActiveTasksCountResponse(Printable):
    """Response to GetActiveTasksCountRequest."""

    def __init__(
        self,
        *,
        commands: int,
        notebooks: int,
        shells: int,
        tensorboards: int,
    ):
        self.commands = commands
        self.notebooks = notebooks
        self.shells = shells
        self.tensorboards = tensorboards

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetActiveTasksCountResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "commands": obj["commands"],
            "notebooks": obj["notebooks"],
            "shells": obj["shells"],
            "tensorboards": obj["tensorboards"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "commands": self.commands,
            "notebooks": self.notebooks,
            "shells": self.shells,
            "tensorboards": self.tensorboards,
        }
        return out

class v1GetAgentResponse(Printable):
    """Response to GetAgentRequest."""

    def __init__(
        self,
        *,
        agent: "v1Agent",
    ):
        self.agent = agent

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetAgentResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "agent": v1Agent.from_json(obj["agent"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "agent": self.agent.to_json(omit_unset),
        }
        return out

class v1GetAgentsRequestSortBy(DetEnum):
    """Sorts agents by the given field.
    - SORT_BY_UNSPECIFIED: Returns agents in an unsorted list.
    - SORT_BY_ID: Returns agents sorted by id.
    - SORT_BY_TIME: Returns agents sorted by time.
    """
    UNSPECIFIED = "SORT_BY_UNSPECIFIED"
    ID = "SORT_BY_ID"
    TIME = "SORT_BY_TIME"

class v1GetAgentsResponse(Printable):
    """Response to GetAgentsRequest."""
    pagination: "typing.Optional[v1Pagination]" = None

    def __init__(
        self,
        *,
        agents: "typing.Sequence[v1Agent]",
        pagination: "typing.Union[v1Pagination, None, Unset]" = _unset,
    ):
        self.agents = agents
        if not isinstance(pagination, Unset):
            self.pagination = pagination

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetAgentsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "agents": [v1Agent.from_json(x) for x in obj["agents"]],
        }
        if "pagination" in obj:
            kwargs["pagination"] = v1Pagination.from_json(obj["pagination"]) if obj["pagination"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "agents": [x.to_json(omit_unset) for x in self.agents],
        }
        if not omit_unset or "pagination" in vars(self):
            out["pagination"] = None if self.pagination is None else self.pagination.to_json(omit_unset)
        return out

class v1GetAllocationResponse(Printable):

    def __init__(
        self,
        *,
        allocation: "v1Allocation",
    ):
        self.allocation = allocation

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetAllocationResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "allocation": v1Allocation.from_json(obj["allocation"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "allocation": self.allocation.to_json(omit_unset),
        }
        return out

class v1GetBestSearcherValidationMetricResponse(Printable):
    """Response to GetBestSearcherValidationMetricRequest."""
    metric: "typing.Optional[float]" = None

    def __init__(
        self,
        *,
        metric: "typing.Union[float, None, Unset]" = _unset,
    ):
        if not isinstance(metric, Unset):
            self.metric = metric

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetBestSearcherValidationMetricResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "metric" in obj:
            kwargs["metric"] = float(obj["metric"]) if obj["metric"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "metric" in vars(self):
            out["metric"] = None if self.metric is None else dump_float(self.metric)
        return out

class v1GetCheckpointResponse(Printable):
    """Response to GetCheckpointRequest."""

    def __init__(
        self,
        *,
        checkpoint: "v1Checkpoint",
    ):
        self.checkpoint = checkpoint

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetCheckpointResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "checkpoint": v1Checkpoint.from_json(obj["checkpoint"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "checkpoint": self.checkpoint.to_json(omit_unset),
        }
        return out

class v1GetClusterMessageResponse(Printable):
    """GetClusterMessageResponse is the response that contains the current cluster
    message.
    """
    clusterMessage: "typing.Optional[v1ClusterMessage]" = None

    def __init__(
        self,
        *,
        clusterMessage: "typing.Union[v1ClusterMessage, None, Unset]" = _unset,
    ):
        if not isinstance(clusterMessage, Unset):
            self.clusterMessage = clusterMessage

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetClusterMessageResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "clusterMessage" in obj:
            kwargs["clusterMessage"] = v1ClusterMessage.from_json(obj["clusterMessage"]) if obj["clusterMessage"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "clusterMessage" in vars(self):
            out["clusterMessage"] = None if self.clusterMessage is None else self.clusterMessage.to_json(omit_unset)
        return out

class v1GetCommandResponse(Printable):
    """Response to GetCommandRequest."""

    def __init__(
        self,
        *,
        command: "v1Command",
        config: "typing.Dict[str, typing.Any]",
    ):
        self.command = command
        self.config = config

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetCommandResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "command": v1Command.from_json(obj["command"]),
            "config": obj["config"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "command": self.command.to_json(omit_unset),
            "config": self.config,
        }
        return out

class v1GetCommandsRequestSortBy(DetEnum):
    """Sorts commands by the given field.
    - SORT_BY_UNSPECIFIED: Returns commands in an unsorted list.
    - SORT_BY_ID: Returns commands sorted by id.
    - SORT_BY_DESCRIPTION: Returns commands sorted by description.
    - SORT_BY_START_TIME: Return commands sorted by start time.
    - SORT_BY_WORKSPACE_ID: Return commands sorted by workspace_id.
    """
    UNSPECIFIED = "SORT_BY_UNSPECIFIED"
    ID = "SORT_BY_ID"
    DESCRIPTION = "SORT_BY_DESCRIPTION"
    START_TIME = "SORT_BY_START_TIME"
    WORKSPACE_ID = "SORT_BY_WORKSPACE_ID"

class v1GetCommandsResponse(Printable):
    """Response to GetCommandsRequest."""
    pagination: "typing.Optional[v1Pagination]" = None

    def __init__(
        self,
        *,
        commands: "typing.Sequence[v1Command]",
        pagination: "typing.Union[v1Pagination, None, Unset]" = _unset,
    ):
        self.commands = commands
        if not isinstance(pagination, Unset):
            self.pagination = pagination

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetCommandsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "commands": [v1Command.from_json(x) for x in obj["commands"]],
        }
        if "pagination" in obj:
            kwargs["pagination"] = v1Pagination.from_json(obj["pagination"]) if obj["pagination"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "commands": [x.to_json(omit_unset) for x in self.commands],
        }
        if not omit_unset or "pagination" in vars(self):
            out["pagination"] = None if self.pagination is None else self.pagination.to_json(omit_unset)
        return out

class v1GetExperimentCheckpointsResponse(Printable):
    """Response to GetExperimentCheckpointsRequest."""

    def __init__(
        self,
        *,
        checkpoints: "typing.Sequence[v1Checkpoint]",
        pagination: "v1Pagination",
    ):
        self.checkpoints = checkpoints
        self.pagination = pagination

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetExperimentCheckpointsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "checkpoints": [v1Checkpoint.from_json(x) for x in obj["checkpoints"]],
            "pagination": v1Pagination.from_json(obj["pagination"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "checkpoints": [x.to_json(omit_unset) for x in self.checkpoints],
            "pagination": self.pagination.to_json(omit_unset),
        }
        return out

class v1GetExperimentLabelsResponse(Printable):
    """Response to GetExperimentsLabelsRequest."""
    labels: "typing.Optional[typing.Sequence[str]]" = None

    def __init__(
        self,
        *,
        labels: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
    ):
        if not isinstance(labels, Unset):
            self.labels = labels

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetExperimentLabelsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "labels" in obj:
            kwargs["labels"] = obj["labels"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "labels" in vars(self):
            out["labels"] = self.labels
        return out

class v1GetExperimentResponse(Printable):
    """Response to GetExperimentRequest."""
    config: "typing.Optional[typing.Dict[str, typing.Any]]" = None
    jobSummary: "typing.Optional[v1JobSummary]" = None

    def __init__(
        self,
        *,
        experiment: "v1Experiment",
        config: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
        jobSummary: "typing.Union[v1JobSummary, None, Unset]" = _unset,
    ):
        self.experiment = experiment
        if not isinstance(config, Unset):
            self.config = config
        if not isinstance(jobSummary, Unset):
            self.jobSummary = jobSummary

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetExperimentResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "experiment": v1Experiment.from_json(obj["experiment"]),
        }
        if "config" in obj:
            kwargs["config"] = obj["config"]
        if "jobSummary" in obj:
            kwargs["jobSummary"] = v1JobSummary.from_json(obj["jobSummary"]) if obj["jobSummary"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "experiment": self.experiment.to_json(omit_unset),
        }
        if not omit_unset or "config" in vars(self):
            out["config"] = self.config
        if not omit_unset or "jobSummary" in vars(self):
            out["jobSummary"] = None if self.jobSummary is None else self.jobSummary.to_json(omit_unset)
        return out

class v1GetExperimentTrialsRequestSortBy(DetEnum):
    """Sorts trials by the given field.
    - SORT_BY_UNSPECIFIED: Returns trials in an unsorted list.
    - SORT_BY_ID: Returns trials sorted by id.
    - SORT_BY_START_TIME: Return trials sorted by start time.
    - SORT_BY_END_TIME: Return trials sorted by end time. Trials without end times are
    returned after trials that are.
    - SORT_BY_STATE: Return trials sorted by state.
    - SORT_BY_BEST_VALIDATION_METRIC: Return the trials sorted by the best metric so far, where the metric is
    specified by `searcher.metric` in the experiment configuration.
    - SORT_BY_LATEST_VALIDATION_METRIC: Return the trials sorted by the latest metric so far, where the metric is
    specified by `searcher.metric` in the experiment configuration.
    - SORT_BY_BATCHES_PROCESSED: Return the trials sorted by the number of batches completed.
    - SORT_BY_DURATION: Return the trials sorted by the total duration.
    - SORT_BY_RESTARTS: Return the trials sorted by the number of restarts.
    - SORT_BY_CHECKPOINT_SIZE: Return the trials sorted by checkpoint size.
    - SORT_BY_LOG_RETENTION_DAYS: Return the trials sorted by number of log retention days.
    """
    UNSPECIFIED = "SORT_BY_UNSPECIFIED"
    ID = "SORT_BY_ID"
    START_TIME = "SORT_BY_START_TIME"
    END_TIME = "SORT_BY_END_TIME"
    STATE = "SORT_BY_STATE"
    BEST_VALIDATION_METRIC = "SORT_BY_BEST_VALIDATION_METRIC"
    LATEST_VALIDATION_METRIC = "SORT_BY_LATEST_VALIDATION_METRIC"
    BATCHES_PROCESSED = "SORT_BY_BATCHES_PROCESSED"
    DURATION = "SORT_BY_DURATION"
    RESTARTS = "SORT_BY_RESTARTS"
    CHECKPOINT_SIZE = "SORT_BY_CHECKPOINT_SIZE"
    LOG_RETENTION_DAYS = "SORT_BY_LOG_RETENTION_DAYS"

class v1GetExperimentTrialsResponse(Printable):
    """Response to GetExperimentTrialsRequest."""

    def __init__(
        self,
        *,
        pagination: "v1Pagination",
        trials: "typing.Sequence[trialv1Trial]",
    ):
        self.pagination = pagination
        self.trials = trials

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetExperimentTrialsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "pagination": v1Pagination.from_json(obj["pagination"]),
            "trials": [trialv1Trial.from_json(x) for x in obj["trials"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "pagination": self.pagination.to_json(omit_unset),
            "trials": [x.to_json(omit_unset) for x in self.trials],
        }
        return out

class v1GetExperimentValidationHistoryResponse(Printable):
    """Response to GetExperimentValidationHistoryRequest."""
    validationHistory: "typing.Optional[typing.Sequence[v1ValidationHistoryEntry]]" = None

    def __init__(
        self,
        *,
        validationHistory: "typing.Union[typing.Sequence[v1ValidationHistoryEntry], None, Unset]" = _unset,
    ):
        if not isinstance(validationHistory, Unset):
            self.validationHistory = validationHistory

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetExperimentValidationHistoryResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "validationHistory" in obj:
            kwargs["validationHistory"] = [v1ValidationHistoryEntry.from_json(x) for x in obj["validationHistory"]] if obj["validationHistory"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "validationHistory" in vars(self):
            out["validationHistory"] = None if self.validationHistory is None else [x.to_json(omit_unset) for x in self.validationHistory]
        return out

class v1GetExperimentsRequestSortBy(DetEnum):
    """Sorts experiments by the given field.
    - SORT_BY_UNSPECIFIED: Returns experiments in an unsorted list.
    - SORT_BY_ID: Returns experiments sorted by id.
    - SORT_BY_DESCRIPTION: Returns experiments sorted by description.
    - SORT_BY_START_TIME: Return experiments sorted by start time.
    - SORT_BY_END_TIME: Return experiments sorted by end time. Experiments without end_time are
    returned after the ones with end_time.
    - SORT_BY_STATE: Return experiments sorted by state.
    - SORT_BY_NUM_TRIALS: Return experiments sorted by number of trials.
    - SORT_BY_PROGRESS: Return experiments sorted by progress.
    - SORT_BY_USER: Return experiments sorted by user.
    - SORT_BY_NAME: Returns experiments sorted by name.
    - SORT_BY_FORKED_FROM: Returns experiments sorted by originating model.
    - SORT_BY_RESOURCE_POOL: Returns experiments sorted by resource pool.
    - SORT_BY_PROJECT_ID: Returns experiments sorted by project.
    - SORT_BY_CHECKPOINT_SIZE: Returns experiments sorted by checkpoint size.
    - SORT_BY_CHECKPOINT_COUNT: Returns experiments sorted by checkpoint count.
    - SORT_BY_SEARCHER_METRIC_VAL: Returns experiments sorted by searcher metric value..
    """
    UNSPECIFIED = "SORT_BY_UNSPECIFIED"
    ID = "SORT_BY_ID"
    DESCRIPTION = "SORT_BY_DESCRIPTION"
    START_TIME = "SORT_BY_START_TIME"
    END_TIME = "SORT_BY_END_TIME"
    STATE = "SORT_BY_STATE"
    NUM_TRIALS = "SORT_BY_NUM_TRIALS"
    PROGRESS = "SORT_BY_PROGRESS"
    USER = "SORT_BY_USER"
    NAME = "SORT_BY_NAME"
    FORKED_FROM = "SORT_BY_FORKED_FROM"
    RESOURCE_POOL = "SORT_BY_RESOURCE_POOL"
    PROJECT_ID = "SORT_BY_PROJECT_ID"
    CHECKPOINT_SIZE = "SORT_BY_CHECKPOINT_SIZE"
    CHECKPOINT_COUNT = "SORT_BY_CHECKPOINT_COUNT"
    SEARCHER_METRIC_VAL = "SORT_BY_SEARCHER_METRIC_VAL"

class v1GetExperimentsResponse(Printable):
    """Response to GetExperimentsRequest."""

    def __init__(
        self,
        *,
        experiments: "typing.Sequence[v1Experiment]",
        pagination: "v1Pagination",
    ):
        self.experiments = experiments
        self.pagination = pagination

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetExperimentsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "experiments": [v1Experiment.from_json(x) for x in obj["experiments"]],
            "pagination": v1Pagination.from_json(obj["pagination"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "experiments": [x.to_json(omit_unset) for x in self.experiments],
            "pagination": self.pagination.to_json(omit_unset),
        }
        return out

class v1GetGenericTaskConfigResponse(Printable):

    def __init__(
        self,
        *,
        config: str,
    ):
        self.config = config

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetGenericTaskConfigResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "config": obj["config"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "config": self.config,
        }
        return out

class v1GetGlobalConfigPoliciesResponse(Printable):
    """Response to GetGlobalConfigPoliciesRequest."""
    configPolicies: "typing.Optional[typing.Dict[str, typing.Any]]" = None

    def __init__(
        self,
        *,
        configPolicies: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
    ):
        if not isinstance(configPolicies, Unset):
            self.configPolicies = configPolicies

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetGlobalConfigPoliciesResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "configPolicies" in obj:
            kwargs["configPolicies"] = obj["configPolicies"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "configPolicies" in vars(self):
            out["configPolicies"] = self.configPolicies
        return out

class v1GetGroupResponse(Printable):
    """GetGroupResponse is the body of the response for the call
    to get a group by id.
    """

    def __init__(
        self,
        *,
        group: "v1GroupDetails",
    ):
        self.group = group

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetGroupResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "group": v1GroupDetails.from_json(obj["group"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "group": self.group.to_json(omit_unset),
        }
        return out

class v1GetGroupsAndUsersAssignedToWorkspaceResponse(Printable):
    """Response object for GetGroupsAndUsersAssignedToWorkspace."""

    def __init__(
        self,
        *,
        assignments: "typing.Sequence[v1RoleWithAssignments]",
        groups: "typing.Sequence[v1GroupDetails]",
        usersAssignedDirectly: "typing.Sequence[v1User]",
    ):
        self.assignments = assignments
        self.groups = groups
        self.usersAssignedDirectly = usersAssignedDirectly

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetGroupsAndUsersAssignedToWorkspaceResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "assignments": [v1RoleWithAssignments.from_json(x) for x in obj["assignments"]],
            "groups": [v1GroupDetails.from_json(x) for x in obj["groups"]],
            "usersAssignedDirectly": [v1User.from_json(x) for x in obj["usersAssignedDirectly"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "assignments": [x.to_json(omit_unset) for x in self.assignments],
            "groups": [x.to_json(omit_unset) for x in self.groups],
            "usersAssignedDirectly": [x.to_json(omit_unset) for x in self.usersAssignedDirectly],
        }
        return out

class v1GetGroupsRequest(Printable):
    """GetGroupsRequest is the body of the request for the call
    to search for groups.
    """
    name: "typing.Optional[str]" = None
    offset: "typing.Optional[int]" = None
    userId: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        limit: int,
        name: "typing.Union[str, None, Unset]" = _unset,
        offset: "typing.Union[int, None, Unset]" = _unset,
        userId: "typing.Union[int, None, Unset]" = _unset,
    ):
        self.limit = limit
        if not isinstance(name, Unset):
            self.name = name
        if not isinstance(offset, Unset):
            self.offset = offset
        if not isinstance(userId, Unset):
            self.userId = userId

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetGroupsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "limit": obj["limit"],
        }
        if "name" in obj:
            kwargs["name"] = obj["name"]
        if "offset" in obj:
            kwargs["offset"] = obj["offset"]
        if "userId" in obj:
            kwargs["userId"] = obj["userId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "limit": self.limit,
        }
        if not omit_unset or "name" in vars(self):
            out["name"] = self.name
        if not omit_unset or "offset" in vars(self):
            out["offset"] = self.offset
        if not omit_unset or "userId" in vars(self):
            out["userId"] = self.userId
        return out

class v1GetGroupsResponse(Printable):
    """GetGroupsResponse is the body of the response for the call
    to search for groups.
    """
    groups: "typing.Optional[typing.Sequence[v1GroupSearchResult]]" = None
    pagination: "typing.Optional[v1Pagination]" = None

    def __init__(
        self,
        *,
        groups: "typing.Union[typing.Sequence[v1GroupSearchResult], None, Unset]" = _unset,
        pagination: "typing.Union[v1Pagination, None, Unset]" = _unset,
    ):
        if not isinstance(groups, Unset):
            self.groups = groups
        if not isinstance(pagination, Unset):
            self.pagination = pagination

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetGroupsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "groups" in obj:
            kwargs["groups"] = [v1GroupSearchResult.from_json(x) for x in obj["groups"]] if obj["groups"] is not None else None
        if "pagination" in obj:
            kwargs["pagination"] = v1Pagination.from_json(obj["pagination"]) if obj["pagination"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "groups" in vars(self):
            out["groups"] = None if self.groups is None else [x.to_json(omit_unset) for x in self.groups]
        if not omit_unset or "pagination" in vars(self):
            out["pagination"] = None if self.pagination is None else self.pagination.to_json(omit_unset)
        return out

class v1GetJobQueueStatsResponse(Printable):
    """Response to GetJobQueueStatsRequest."""

    def __init__(
        self,
        *,
        results: "typing.Sequence[v1RPQueueStat]",
    ):
        self.results = results

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetJobQueueStatsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "results": [v1RPQueueStat.from_json(x) for x in obj["results"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "results": [x.to_json(omit_unset) for x in self.results],
        }
        return out

class v1GetJobsResponse(Printable):
    """Response to GetJobsRequest."""

    def __init__(
        self,
        *,
        jobs: "typing.Sequence[v1Job]",
        pagination: "v1Pagination",
    ):
        self.jobs = jobs
        self.pagination = pagination

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetJobsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "jobs": [v1Job.from_json(x) for x in obj["jobs"]],
            "pagination": v1Pagination.from_json(obj["pagination"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "jobs": [x.to_json(omit_unset) for x in self.jobs],
            "pagination": self.pagination.to_json(omit_unset),
        }
        return out

class v1GetJobsV2Response(Printable):
    """Response to GetJobsV2Request."""

    def __init__(
        self,
        *,
        jobs: "typing.Sequence[v1RBACJob]",
        pagination: "v1Pagination",
    ):
        self.jobs = jobs
        self.pagination = pagination

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetJobsV2Response":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "jobs": [v1RBACJob.from_json(x) for x in obj["jobs"]],
            "pagination": v1Pagination.from_json(obj["pagination"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "jobs": [x.to_json(omit_unset) for x in self.jobs],
            "pagination": self.pagination.to_json(omit_unset),
        }
        return out

class v1GetKubernetesResourceManagersResponse(Printable):
    """Response to GetKubernetesResourceManagersRequest."""

    def __init__(
        self,
        *,
        resourceManagers: "typing.Sequence[str]",
    ):
        self.resourceManagers = resourceManagers

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetKubernetesResourceManagersResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "resourceManagers": obj["resourceManagers"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "resourceManagers": self.resourceManagers,
        }
        return out

class v1GetKubernetesResourceQuotasResponse(Printable):
    """Response for listing namespaces bound to a workspace."""

    def __init__(
        self,
        *,
        resourceQuotas: "typing.Dict[str, float]",
    ):
        self.resourceQuotas = resourceQuotas

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetKubernetesResourceQuotasResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "resourceQuotas": {k: float(v) for k, v in obj["resourceQuotas"].items()},
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "resourceQuotas": {k: dump_float(v) for k, v in self.resourceQuotas.items()},
        }
        return out

class v1GetMasterConfigResponse(Printable):
    """Response to GetMasterRequest."""

    def __init__(
        self,
        *,
        config: "typing.Dict[str, typing.Any]",
    ):
        self.config = config

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetMasterConfigResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "config": obj["config"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "config": self.config,
        }
        return out

class v1GetMasterResponse(Printable):
    """Response to GetMasterRequest."""
    branding: "typing.Optional[str]" = None
    clusterMessage: "typing.Optional[v1ClusterMessage]" = None
    externalLoginUri: "typing.Optional[str]" = None
    externalLogoutUri: "typing.Optional[str]" = None
    featureSwitches: "typing.Optional[typing.Sequence[str]]" = None
    product: "typing.Optional[GetMasterResponseProduct]" = None
    rbacEnabled: "typing.Optional[bool]" = None
    ssoProviders: "typing.Optional[typing.Sequence[v1SSOProvider]]" = None
    telemetryEnabled: "typing.Optional[bool]" = None
    userManagementEnabled: "typing.Optional[bool]" = None

    def __init__(
        self,
        *,
        clusterId: str,
        clusterName: str,
        hasCustomLogo: bool,
        masterId: str,
        strictJobQueueControl: bool,
        version: str,
        branding: "typing.Union[str, None, Unset]" = _unset,
        clusterMessage: "typing.Union[v1ClusterMessage, None, Unset]" = _unset,
        externalLoginUri: "typing.Union[str, None, Unset]" = _unset,
        externalLogoutUri: "typing.Union[str, None, Unset]" = _unset,
        featureSwitches: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
        product: "typing.Union[GetMasterResponseProduct, None, Unset]" = _unset,
        rbacEnabled: "typing.Union[bool, None, Unset]" = _unset,
        ssoProviders: "typing.Union[typing.Sequence[v1SSOProvider], None, Unset]" = _unset,
        telemetryEnabled: "typing.Union[bool, None, Unset]" = _unset,
        userManagementEnabled: "typing.Union[bool, None, Unset]" = _unset,
    ):
        self.clusterId = clusterId
        self.clusterName = clusterName
        self.hasCustomLogo = hasCustomLogo
        self.masterId = masterId
        self.strictJobQueueControl = strictJobQueueControl
        self.version = version
        if not isinstance(branding, Unset):
            self.branding = branding
        if not isinstance(clusterMessage, Unset):
            self.clusterMessage = clusterMessage
        if not isinstance(externalLoginUri, Unset):
            self.externalLoginUri = externalLoginUri
        if not isinstance(externalLogoutUri, Unset):
            self.externalLogoutUri = externalLogoutUri
        if not isinstance(featureSwitches, Unset):
            self.featureSwitches = featureSwitches
        if not isinstance(product, Unset):
            self.product = product
        if not isinstance(rbacEnabled, Unset):
            self.rbacEnabled = rbacEnabled
        if not isinstance(ssoProviders, Unset):
            self.ssoProviders = ssoProviders
        if not isinstance(telemetryEnabled, Unset):
            self.telemetryEnabled = telemetryEnabled
        if not isinstance(userManagementEnabled, Unset):
            self.userManagementEnabled = userManagementEnabled

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetMasterResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "clusterId": obj["clusterId"],
            "clusterName": obj["clusterName"],
            "hasCustomLogo": obj["hasCustomLogo"],
            "masterId": obj["masterId"],
            "strictJobQueueControl": obj["strictJobQueueControl"],
            "version": obj["version"],
        }
        if "branding" in obj:
            kwargs["branding"] = obj["branding"]
        if "clusterMessage" in obj:
            kwargs["clusterMessage"] = v1ClusterMessage.from_json(obj["clusterMessage"]) if obj["clusterMessage"] is not None else None
        if "externalLoginUri" in obj:
            kwargs["externalLoginUri"] = obj["externalLoginUri"]
        if "externalLogoutUri" in obj:
            kwargs["externalLogoutUri"] = obj["externalLogoutUri"]
        if "featureSwitches" in obj:
            kwargs["featureSwitches"] = obj["featureSwitches"]
        if "product" in obj:
            kwargs["product"] = GetMasterResponseProduct(obj["product"]) if obj["product"] is not None else None
        if "rbacEnabled" in obj:
            kwargs["rbacEnabled"] = obj["rbacEnabled"]
        if "ssoProviders" in obj:
            kwargs["ssoProviders"] = [v1SSOProvider.from_json(x) for x in obj["ssoProviders"]] if obj["ssoProviders"] is not None else None
        if "telemetryEnabled" in obj:
            kwargs["telemetryEnabled"] = obj["telemetryEnabled"]
        if "userManagementEnabled" in obj:
            kwargs["userManagementEnabled"] = obj["userManagementEnabled"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "clusterId": self.clusterId,
            "clusterName": self.clusterName,
            "hasCustomLogo": self.hasCustomLogo,
            "masterId": self.masterId,
            "strictJobQueueControl": self.strictJobQueueControl,
            "version": self.version,
        }
        if not omit_unset or "branding" in vars(self):
            out["branding"] = self.branding
        if not omit_unset or "clusterMessage" in vars(self):
            out["clusterMessage"] = None if self.clusterMessage is None else self.clusterMessage.to_json(omit_unset)
        if not omit_unset or "externalLoginUri" in vars(self):
            out["externalLoginUri"] = self.externalLoginUri
        if not omit_unset or "externalLogoutUri" in vars(self):
            out["externalLogoutUri"] = self.externalLogoutUri
        if not omit_unset or "featureSwitches" in vars(self):
            out["featureSwitches"] = self.featureSwitches
        if not omit_unset or "product" in vars(self):
            out["product"] = None if self.product is None else self.product.value
        if not omit_unset or "rbacEnabled" in vars(self):
            out["rbacEnabled"] = self.rbacEnabled
        if not omit_unset or "ssoProviders" in vars(self):
            out["ssoProviders"] = None if self.ssoProviders is None else [x.to_json(omit_unset) for x in self.ssoProviders]
        if not omit_unset or "telemetryEnabled" in vars(self):
            out["telemetryEnabled"] = self.telemetryEnabled
        if not omit_unset or "userManagementEnabled" in vars(self):
            out["userManagementEnabled"] = self.userManagementEnabled
        return out

class v1GetMeResponse(Printable):
    """Response to GetMeRequest."""

    def __init__(
        self,
        *,
        user: "v1User",
    ):
        self.user = user

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetMeResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "user": v1User.from_json(obj["user"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "user": self.user.to_json(omit_unset),
        }
        return out

class v1GetMetadataValuesResponse(Printable):
    """Response to GetMetadataValuesRequest."""
    values: "typing.Optional[typing.Sequence[str]]" = None

    def __init__(
        self,
        *,
        values: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
    ):
        if not isinstance(values, Unset):
            self.values = values

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetMetadataValuesResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "values" in obj:
            kwargs["values"] = obj["values"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "values" in vars(self):
            out["values"] = self.values
        return out

class v1GetMetricsResponse(Printable):
    """Response to GetMetricsRequest."""

    def __init__(
        self,
        *,
        metrics: "typing.Sequence[v1MetricsReport]",
    ):
        self.metrics = metrics

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetMetricsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "metrics": [v1MetricsReport.from_json(x) for x in obj["metrics"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "metrics": [x.to_json(omit_unset) for x in self.metrics],
        }
        return out

class v1GetModelDefFileRequest(Printable):
    """Request to get a file of model definition."""
    experimentId: "typing.Optional[int]" = None
    path: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        experimentId: "typing.Union[int, None, Unset]" = _unset,
        path: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(experimentId, Unset):
            self.experimentId = experimentId
        if not isinstance(path, Unset):
            self.path = path

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetModelDefFileRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "experimentId" in obj:
            kwargs["experimentId"] = obj["experimentId"]
        if "path" in obj:
            kwargs["path"] = obj["path"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "experimentId" in vars(self):
            out["experimentId"] = self.experimentId
        if not omit_unset or "path" in vars(self):
            out["path"] = self.path
        return out

class v1GetModelDefFileResponse(Printable):
    """Response to GetModelDefFileRequest."""
    file: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        file: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(file, Unset):
            self.file = file

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetModelDefFileResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "file" in obj:
            kwargs["file"] = obj["file"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "file" in vars(self):
            out["file"] = self.file
        return out

class v1GetModelDefResponse(Printable):
    """Response to GetModelDefRequest."""

    def __init__(
        self,
        *,
        b64Tgz: str,
    ):
        self.b64Tgz = b64Tgz

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetModelDefResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "b64Tgz": obj["b64Tgz"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "b64Tgz": self.b64Tgz,
        }
        return out

class v1GetModelDefTreeResponse(Printable):
    """Response to GetModelDefTreeRequest."""
    files: "typing.Optional[typing.Sequence[v1FileNode]]" = None

    def __init__(
        self,
        *,
        files: "typing.Union[typing.Sequence[v1FileNode], None, Unset]" = _unset,
    ):
        if not isinstance(files, Unset):
            self.files = files

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetModelDefTreeResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "files" in obj:
            kwargs["files"] = [v1FileNode.from_json(x) for x in obj["files"]] if obj["files"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "files" in vars(self):
            out["files"] = None if self.files is None else [x.to_json(omit_unset) for x in self.files]
        return out

class v1GetModelLabelsResponse(Printable):
    """Response to GetModelLabelsRequest."""

    def __init__(
        self,
        *,
        labels: "typing.Sequence[str]",
    ):
        self.labels = labels

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetModelLabelsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "labels": obj["labels"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "labels": self.labels,
        }
        return out

class v1GetModelResponse(Printable):
    """Response to GetModelRequest."""

    def __init__(
        self,
        *,
        model: "v1Model",
    ):
        self.model = model

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetModelResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "model": v1Model.from_json(obj["model"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "model": self.model.to_json(omit_unset),
        }
        return out

class v1GetModelVersionResponse(Printable):
    """Response for GetModelVersionRequest."""

    def __init__(
        self,
        *,
        modelVersion: "v1ModelVersion",
    ):
        self.modelVersion = modelVersion

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetModelVersionResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "modelVersion": v1ModelVersion.from_json(obj["modelVersion"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "modelVersion": self.modelVersion.to_json(omit_unset),
        }
        return out

class v1GetModelVersionsRequestSortBy(DetEnum):
    """Sort models by the given field.
    - SORT_BY_UNSPECIFIED: Returns model versions in an unsorted list.
    - SORT_BY_VERSION: Returns model versions sorted by version number.
    - SORT_BY_CREATION_TIME: Returns model versions sorted by creation_time.
    """
    UNSPECIFIED = "SORT_BY_UNSPECIFIED"
    VERSION = "SORT_BY_VERSION"
    CREATION_TIME = "SORT_BY_CREATION_TIME"

class v1GetModelVersionsResponse(Printable):
    """Response for GetModelVersionRequest."""

    def __init__(
        self,
        *,
        model: "v1Model",
        modelVersions: "typing.Sequence[v1ModelVersion]",
        pagination: "v1Pagination",
    ):
        self.model = model
        self.modelVersions = modelVersions
        self.pagination = pagination

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetModelVersionsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "model": v1Model.from_json(obj["model"]),
            "modelVersions": [v1ModelVersion.from_json(x) for x in obj["modelVersions"]],
            "pagination": v1Pagination.from_json(obj["pagination"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "model": self.model.to_json(omit_unset),
            "modelVersions": [x.to_json(omit_unset) for x in self.modelVersions],
            "pagination": self.pagination.to_json(omit_unset),
        }
        return out

class v1GetModelsRequestSortBy(DetEnum):
    """Sort models by the given field.
    - SORT_BY_UNSPECIFIED: Returns models in an unsorted list.
    - SORT_BY_NAME: Returns models sorted by name.
    - SORT_BY_DESCRIPTION: Returns models sorted by description.
    - SORT_BY_CREATION_TIME: Returns models sorted by creation time.
    - SORT_BY_LAST_UPDATED_TIME: Returns models sorted by last updated time.
    - SORT_BY_NUM_VERSIONS: Returns models sorted by number of version.
    - SORT_BY_WORKSPACE: Returns models sorted by workspace name.
    """
    UNSPECIFIED = "SORT_BY_UNSPECIFIED"
    NAME = "SORT_BY_NAME"
    DESCRIPTION = "SORT_BY_DESCRIPTION"
    CREATION_TIME = "SORT_BY_CREATION_TIME"
    LAST_UPDATED_TIME = "SORT_BY_LAST_UPDATED_TIME"
    NUM_VERSIONS = "SORT_BY_NUM_VERSIONS"
    WORKSPACE = "SORT_BY_WORKSPACE"

class v1GetModelsResponse(Printable):
    """Response to GetModelsRequest."""

    def __init__(
        self,
        *,
        models: "typing.Sequence[v1Model]",
        pagination: "v1Pagination",
    ):
        self.models = models
        self.pagination = pagination

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetModelsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "models": [v1Model.from_json(x) for x in obj["models"]],
            "pagination": v1Pagination.from_json(obj["pagination"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "models": [x.to_json(omit_unset) for x in self.models],
            "pagination": self.pagination.to_json(omit_unset),
        }
        return out

class v1GetNotebookResponse(Printable):
    """Response to GetNotebookRequest."""

    def __init__(
        self,
        *,
        config: "typing.Dict[str, typing.Any]",
        notebook: "v1Notebook",
    ):
        self.config = config
        self.notebook = notebook

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetNotebookResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "config": obj["config"],
            "notebook": v1Notebook.from_json(obj["notebook"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "config": self.config,
            "notebook": self.notebook.to_json(omit_unset),
        }
        return out

class v1GetNotebooksRequestSortBy(DetEnum):
    """Sorts notebooks by the given field.
    - SORT_BY_UNSPECIFIED: Returns notebooks in an unsorted list.
    - SORT_BY_ID: Returns notebooks sorted by id.
    - SORT_BY_DESCRIPTION: Returns notebooks sorted by description.
    - SORT_BY_START_TIME: Return notebooks sorted by start time.
    - SORT_BY_WORKSPACE_ID: Return notebooks sorted by workspace_id
    """
    UNSPECIFIED = "SORT_BY_UNSPECIFIED"
    ID = "SORT_BY_ID"
    DESCRIPTION = "SORT_BY_DESCRIPTION"
    START_TIME = "SORT_BY_START_TIME"
    WORKSPACE_ID = "SORT_BY_WORKSPACE_ID"

class v1GetNotebooksResponse(Printable):
    """Response to GetNotebooksRequest."""
    pagination: "typing.Optional[v1Pagination]" = None

    def __init__(
        self,
        *,
        notebooks: "typing.Sequence[v1Notebook]",
        pagination: "typing.Union[v1Pagination, None, Unset]" = _unset,
    ):
        self.notebooks = notebooks
        if not isinstance(pagination, Unset):
            self.pagination = pagination

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetNotebooksResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "notebooks": [v1Notebook.from_json(x) for x in obj["notebooks"]],
        }
        if "pagination" in obj:
            kwargs["pagination"] = v1Pagination.from_json(obj["pagination"]) if obj["pagination"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "notebooks": [x.to_json(omit_unset) for x in self.notebooks],
        }
        if not omit_unset or "pagination" in vars(self):
            out["pagination"] = None if self.pagination is None else self.pagination.to_json(omit_unset)
        return out

class v1GetPermissionsSummaryResponse(Printable):
    """Response to GetPermissionsSummaryRequest."""

    def __init__(
        self,
        *,
        assignments: "typing.Sequence[v1RoleAssignmentSummary]",
        roles: "typing.Sequence[v1Role]",
    ):
        self.assignments = assignments
        self.roles = roles

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetPermissionsSummaryResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "assignments": [v1RoleAssignmentSummary.from_json(x) for x in obj["assignments"]],
            "roles": [v1Role.from_json(x) for x in obj["roles"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "assignments": [x.to_json(omit_unset) for x in self.assignments],
            "roles": [x.to_json(omit_unset) for x in self.roles],
        }
        return out

class v1GetProjectByKeyResponse(Printable):
    """Response to GetProjectByKeyRequest."""

    def __init__(
        self,
        *,
        project: "v1Project",
    ):
        self.project = project

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetProjectByKeyResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "project": v1Project.from_json(obj["project"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "project": self.project.to_json(omit_unset),
        }
        return out

class v1GetProjectColumnsResponse(Printable):

    def __init__(
        self,
        *,
        columns: "typing.Sequence[v1ProjectColumn]",
    ):
        self.columns = columns

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetProjectColumnsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "columns": [v1ProjectColumn.from_json(x) for x in obj["columns"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "columns": [x.to_json(omit_unset) for x in self.columns],
        }
        return out

class v1GetProjectNumericMetricsRangeResponse(Printable):
    ranges: "typing.Optional[typing.Sequence[v1MetricsRange]]" = None

    def __init__(
        self,
        *,
        ranges: "typing.Union[typing.Sequence[v1MetricsRange], None, Unset]" = _unset,
    ):
        if not isinstance(ranges, Unset):
            self.ranges = ranges

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetProjectNumericMetricsRangeResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "ranges" in obj:
            kwargs["ranges"] = [v1MetricsRange.from_json(x) for x in obj["ranges"]] if obj["ranges"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "ranges" in vars(self):
            out["ranges"] = None if self.ranges is None else [x.to_json(omit_unset) for x in self.ranges]
        return out

class v1GetProjectResponse(Printable):
    """Response to GetProjectRequest."""

    def __init__(
        self,
        *,
        project: "v1Project",
    ):
        self.project = project

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetProjectResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "project": v1Project.from_json(obj["project"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "project": self.project.to_json(omit_unset),
        }
        return out

class v1GetProjectsByUserActivityResponse(Printable):
    """Response to GetProjectsByUserActivityRequest."""
    projects: "typing.Optional[typing.Sequence[v1Project]]" = None

    def __init__(
        self,
        *,
        projects: "typing.Union[typing.Sequence[v1Project], None, Unset]" = _unset,
    ):
        if not isinstance(projects, Unset):
            self.projects = projects

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetProjectsByUserActivityResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "projects" in obj:
            kwargs["projects"] = [v1Project.from_json(x) for x in obj["projects"]] if obj["projects"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "projects" in vars(self):
            out["projects"] = None if self.projects is None else [x.to_json(omit_unset) for x in self.projects]
        return out

class v1GetResourcePoolsResponse(Printable):
    """Response to GetResourcePoolsRequest."""
    pagination: "typing.Optional[v1Pagination]" = None
    resourcePools: "typing.Optional[typing.Sequence[v1ResourcePool]]" = None

    def __init__(
        self,
        *,
        pagination: "typing.Union[v1Pagination, None, Unset]" = _unset,
        resourcePools: "typing.Union[typing.Sequence[v1ResourcePool], None, Unset]" = _unset,
    ):
        if not isinstance(pagination, Unset):
            self.pagination = pagination
        if not isinstance(resourcePools, Unset):
            self.resourcePools = resourcePools

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetResourcePoolsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "pagination" in obj:
            kwargs["pagination"] = v1Pagination.from_json(obj["pagination"]) if obj["pagination"] is not None else None
        if "resourcePools" in obj:
            kwargs["resourcePools"] = [v1ResourcePool.from_json(x) for x in obj["resourcePools"]] if obj["resourcePools"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "pagination" in vars(self):
            out["pagination"] = None if self.pagination is None else self.pagination.to_json(omit_unset)
        if not omit_unset or "resourcePools" in vars(self):
            out["resourcePools"] = None if self.resourcePools is None else [x.to_json(omit_unset) for x in self.resourcePools]
        return out

class v1GetRolesAssignedToGroupResponse(Printable):

    def __init__(
        self,
        *,
        assignments: "typing.Sequence[v1RoleAssignmentSummary]",
        roles: "typing.Sequence[v1Role]",
    ):
        self.assignments = assignments
        self.roles = roles

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetRolesAssignedToGroupResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "assignments": [v1RoleAssignmentSummary.from_json(x) for x in obj["assignments"]],
            "roles": [v1Role.from_json(x) for x in obj["roles"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "assignments": [x.to_json(omit_unset) for x in self.assignments],
            "roles": [x.to_json(omit_unset) for x in self.roles],
        }
        return out

class v1GetRolesAssignedToUserResponse(Printable):

    def __init__(
        self,
        *,
        roles: "typing.Sequence[v1RoleWithAssignments]",
    ):
        self.roles = roles

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetRolesAssignedToUserResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "roles": [v1RoleWithAssignments.from_json(x) for x in obj["roles"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "roles": [x.to_json(omit_unset) for x in self.roles],
        }
        return out

class v1GetRolesByIDRequest(Printable):
    roleIds: "typing.Optional[typing.Sequence[int]]" = None

    def __init__(
        self,
        *,
        roleIds: "typing.Union[typing.Sequence[int], None, Unset]" = _unset,
    ):
        if not isinstance(roleIds, Unset):
            self.roleIds = roleIds

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetRolesByIDRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "roleIds" in obj:
            kwargs["roleIds"] = obj["roleIds"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "roleIds" in vars(self):
            out["roleIds"] = self.roleIds
        return out

class v1GetRolesByIDResponse(Printable):
    roles: "typing.Optional[typing.Sequence[v1RoleWithAssignments]]" = None

    def __init__(
        self,
        *,
        roles: "typing.Union[typing.Sequence[v1RoleWithAssignments], None, Unset]" = _unset,
    ):
        if not isinstance(roles, Unset):
            self.roles = roles

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetRolesByIDResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "roles" in obj:
            kwargs["roles"] = [v1RoleWithAssignments.from_json(x) for x in obj["roles"]] if obj["roles"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "roles" in vars(self):
            out["roles"] = None if self.roles is None else [x.to_json(omit_unset) for x in self.roles]
        return out

class v1GetRunMetadataResponse(Printable):
    """Response to get the metadata of a run."""
    metadata: "typing.Optional[typing.Dict[str, typing.Any]]" = None

    def __init__(
        self,
        *,
        metadata: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
    ):
        if not isinstance(metadata, Unset):
            self.metadata = metadata

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetRunMetadataResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "metadata" in obj:
            kwargs["metadata"] = obj["metadata"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "metadata" in vars(self):
            out["metadata"] = self.metadata
        return out

class v1GetShellResponse(Printable):
    """Response to GetShellRequest."""

    def __init__(
        self,
        *,
        config: "typing.Dict[str, typing.Any]",
        shell: "v1Shell",
    ):
        self.config = config
        self.shell = shell

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetShellResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "config": obj["config"],
            "shell": v1Shell.from_json(obj["shell"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "config": self.config,
            "shell": self.shell.to_json(omit_unset),
        }
        return out

class v1GetShellsRequestSortBy(DetEnum):
    """Sorts shells by the given field.
    - SORT_BY_UNSPECIFIED: Returns shells in an unsorted list.
    - SORT_BY_ID: Returns shells sorted by id.
    - SORT_BY_DESCRIPTION: Returns shells sorted by description.
    - SORT_BY_START_TIME: Return shells sorted by start time.
    - SORT_BY_WORKSPACE_ID: Return shells sorted by workspace_id.
    """
    UNSPECIFIED = "SORT_BY_UNSPECIFIED"
    ID = "SORT_BY_ID"
    DESCRIPTION = "SORT_BY_DESCRIPTION"
    START_TIME = "SORT_BY_START_TIME"
    WORKSPACE_ID = "SORT_BY_WORKSPACE_ID"

class v1GetShellsResponse(Printable):
    """Response to GetShellsRequest."""
    pagination: "typing.Optional[v1Pagination]" = None

    def __init__(
        self,
        *,
        shells: "typing.Sequence[v1Shell]",
        pagination: "typing.Union[v1Pagination, None, Unset]" = _unset,
    ):
        self.shells = shells
        if not isinstance(pagination, Unset):
            self.pagination = pagination

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetShellsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "shells": [v1Shell.from_json(x) for x in obj["shells"]],
        }
        if "pagination" in obj:
            kwargs["pagination"] = v1Pagination.from_json(obj["pagination"]) if obj["pagination"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "shells": [x.to_json(omit_unset) for x in self.shells],
        }
        if not omit_unset or "pagination" in vars(self):
            out["pagination"] = None if self.pagination is None else self.pagination.to_json(omit_unset)
        return out

class v1GetSlotResponse(Printable):
    """Response to GetSlotRequest."""
    slot: "typing.Optional[v1Slot]" = None

    def __init__(
        self,
        *,
        slot: "typing.Union[v1Slot, None, Unset]" = _unset,
    ):
        if not isinstance(slot, Unset):
            self.slot = slot

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetSlotResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "slot" in obj:
            kwargs["slot"] = v1Slot.from_json(obj["slot"]) if obj["slot"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "slot" in vars(self):
            out["slot"] = None if self.slot is None else self.slot.to_json(omit_unset)
        return out

class v1GetSlotsResponse(Printable):
    """Response to GetSlotsRequest."""
    slots: "typing.Optional[typing.Sequence[v1Slot]]" = None

    def __init__(
        self,
        *,
        slots: "typing.Union[typing.Sequence[v1Slot], None, Unset]" = _unset,
    ):
        if not isinstance(slots, Unset):
            self.slots = slots

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetSlotsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "slots" in obj:
            kwargs["slots"] = [v1Slot.from_json(x) for x in obj["slots"]] if obj["slots"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "slots" in vars(self):
            out["slots"] = None if self.slots is None else [x.to_json(omit_unset) for x in self.slots]
        return out

class v1GetTaskAcceleratorDataResponse(Printable):

    def __init__(
        self,
        *,
        acceleratorData: "typing.Sequence[v1AcceleratorData]",
    ):
        self.acceleratorData = acceleratorData

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetTaskAcceleratorDataResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "acceleratorData": [v1AcceleratorData.from_json(x) for x in obj["acceleratorData"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "acceleratorData": [x.to_json(omit_unset) for x in self.acceleratorData],
        }
        return out

class v1GetTaskContextDirectoryResponse(Printable):
    """Response to GetTaskContextDirectoryRequest."""

    def __init__(
        self,
        *,
        b64Tgz: str,
    ):
        self.b64Tgz = b64Tgz

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetTaskContextDirectoryResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "b64Tgz": obj["b64Tgz"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "b64Tgz": self.b64Tgz,
        }
        return out

class v1GetTaskResponse(Printable):
    """Response to GetTaskRequest."""

    def __init__(
        self,
        *,
        task: "v1Task",
    ):
        self.task = task

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetTaskResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "task": v1Task.from_json(obj["task"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "task": self.task.to_json(omit_unset),
        }
        return out

class v1GetTasksResponse(Printable):
    """Response to GetTasksRequest."""
    allocationIdToSummary: "typing.Optional[typing.Dict[str, v1AllocationSummary]]" = None

    def __init__(
        self,
        *,
        allocationIdToSummary: "typing.Union[typing.Dict[str, v1AllocationSummary], None, Unset]" = _unset,
    ):
        if not isinstance(allocationIdToSummary, Unset):
            self.allocationIdToSummary = allocationIdToSummary

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetTasksResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "allocationIdToSummary" in obj:
            kwargs["allocationIdToSummary"] = {k: v1AllocationSummary.from_json(v) for k, v in obj["allocationIdToSummary"].items()} if obj["allocationIdToSummary"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "allocationIdToSummary" in vars(self):
            out["allocationIdToSummary"] = None if self.allocationIdToSummary is None else {k: v.to_json(omit_unset) for k, v in self.allocationIdToSummary.items()}
        return out

class v1GetTelemetryResponse(Printable):
    """Response to GetTelemetryRequest."""
    segmentKey: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        enabled: bool,
        segmentKey: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.enabled = enabled
        if not isinstance(segmentKey, Unset):
            self.segmentKey = segmentKey

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetTelemetryResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "enabled": obj["enabled"],
        }
        if "segmentKey" in obj:
            kwargs["segmentKey"] = obj["segmentKey"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "enabled": self.enabled,
        }
        if not omit_unset or "segmentKey" in vars(self):
            out["segmentKey"] = self.segmentKey
        return out

class v1GetTemplateResponse(Printable):
    """Response to GetTemplateRequest."""

    def __init__(
        self,
        *,
        template: "v1Template",
    ):
        self.template = template

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetTemplateResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "template": v1Template.from_json(obj["template"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "template": self.template.to_json(omit_unset),
        }
        return out

class v1GetTemplatesRequestSortBy(DetEnum):
    """Sorts templates by the given field.
    - SORT_BY_UNSPECIFIED: Returns templates in an unsorted list.
    - SORT_BY_NAME: Returns templates sorted by name.
    """
    UNSPECIFIED = "SORT_BY_UNSPECIFIED"
    NAME = "SORT_BY_NAME"

class v1GetTemplatesResponse(Printable):
    """Response to GetTemplatesRequest."""

    def __init__(
        self,
        *,
        pagination: "v1Pagination",
        templates: "typing.Sequence[v1Template]",
    ):
        self.pagination = pagination
        self.templates = templates

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetTemplatesResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "pagination": v1Pagination.from_json(obj["pagination"]),
            "templates": [v1Template.from_json(x) for x in obj["templates"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "pagination": self.pagination.to_json(omit_unset),
            "templates": [x.to_json(omit_unset) for x in self.templates],
        }
        return out

class v1GetTensorboardResponse(Printable):
    """Response to GetTensorboardRequest."""

    def __init__(
        self,
        *,
        config: "typing.Dict[str, typing.Any]",
        tensorboard: "v1Tensorboard",
    ):
        self.config = config
        self.tensorboard = tensorboard

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetTensorboardResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "config": obj["config"],
            "tensorboard": v1Tensorboard.from_json(obj["tensorboard"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "config": self.config,
            "tensorboard": self.tensorboard.to_json(omit_unset),
        }
        return out

class v1GetTensorboardsRequestSortBy(DetEnum):
    """Sorts tensorboards by the given field.
    - SORT_BY_UNSPECIFIED: Returns tensorboards in an unsorted list.
    - SORT_BY_ID: Returns tensorboards sorted by id.
    - SORT_BY_DESCRIPTION: Returns tensorboards sorted by description.
    - SORT_BY_START_TIME: Return tensorboards sorted by start time.
    - SORT_BY_WORKSPACE_ID: Return tensorboards sorted by workspace_id.
    """
    UNSPECIFIED = "SORT_BY_UNSPECIFIED"
    ID = "SORT_BY_ID"
    DESCRIPTION = "SORT_BY_DESCRIPTION"
    START_TIME = "SORT_BY_START_TIME"
    WORKSPACE_ID = "SORT_BY_WORKSPACE_ID"

class v1GetTensorboardsResponse(Printable):
    """Response to GetTensorboardsRequest."""
    pagination: "typing.Optional[v1Pagination]" = None

    def __init__(
        self,
        *,
        tensorboards: "typing.Sequence[v1Tensorboard]",
        pagination: "typing.Union[v1Pagination, None, Unset]" = _unset,
    ):
        self.tensorboards = tensorboards
        if not isinstance(pagination, Unset):
            self.pagination = pagination

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetTensorboardsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "tensorboards": [v1Tensorboard.from_json(x) for x in obj["tensorboards"]],
        }
        if "pagination" in obj:
            kwargs["pagination"] = v1Pagination.from_json(obj["pagination"]) if obj["pagination"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "tensorboards": [x.to_json(omit_unset) for x in self.tensorboards],
        }
        if not omit_unset or "pagination" in vars(self):
            out["pagination"] = None if self.pagination is None else self.pagination.to_json(omit_unset)
        return out

class v1GetTrainingMetricsResponse(Printable):
    """Response to GetTrainingMetricsRequest."""

    def __init__(
        self,
        *,
        metrics: "typing.Sequence[v1MetricsReport]",
    ):
        self.metrics = metrics

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetTrainingMetricsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "metrics": [v1MetricsReport.from_json(x) for x in obj["metrics"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "metrics": [x.to_json(omit_unset) for x in self.metrics],
        }
        return out

class v1GetTrialByExternalIDResponse(Printable):
    """Response to GetTrialByExternalIDRequest."""

    def __init__(
        self,
        *,
        trial: "trialv1Trial",
    ):
        self.trial = trial

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetTrialByExternalIDResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "trial": trialv1Trial.from_json(obj["trial"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "trial": self.trial.to_json(omit_unset),
        }
        return out

class v1GetTrialCheckpointsResponse(Printable):
    """Response to GetTrialCheckpointsRequest."""

    def __init__(
        self,
        *,
        checkpoints: "typing.Sequence[v1Checkpoint]",
        pagination: "v1Pagination",
    ):
        self.checkpoints = checkpoints
        self.pagination = pagination

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetTrialCheckpointsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "checkpoints": [v1Checkpoint.from_json(x) for x in obj["checkpoints"]],
            "pagination": v1Pagination.from_json(obj["pagination"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "checkpoints": [x.to_json(omit_unset) for x in self.checkpoints],
            "pagination": self.pagination.to_json(omit_unset),
        }
        return out

class v1GetTrialMetricsByCheckpointResponse(Printable):

    def __init__(
        self,
        *,
        metrics: "typing.Sequence[v1MetricsReport]",
    ):
        self.metrics = metrics

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetTrialMetricsByCheckpointResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "metrics": [v1MetricsReport.from_json(x) for x in obj["metrics"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "metrics": [x.to_json(omit_unset) for x in self.metrics],
        }
        return out

class v1GetTrialMetricsByModelVersionResponse(Printable):

    def __init__(
        self,
        *,
        metrics: "typing.Sequence[v1MetricsReport]",
    ):
        self.metrics = metrics

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetTrialMetricsByModelVersionResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "metrics": [v1MetricsReport.from_json(x) for x in obj["metrics"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "metrics": [x.to_json(omit_unset) for x in self.metrics],
        }
        return out

class v1GetTrialProfilerAvailableSeriesResponse(Printable):
    """Response to TrialProfilerAvailableSeriesRequest."""

    def __init__(
        self,
        *,
        labels: "typing.Sequence[v1TrialProfilerMetricLabels]",
    ):
        self.labels = labels

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetTrialProfilerAvailableSeriesResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "labels": [v1TrialProfilerMetricLabels.from_json(x) for x in obj["labels"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "labels": [x.to_json(omit_unset) for x in self.labels],
        }
        return out

class v1GetTrialProfilerMetricsResponse(Printable):

    def __init__(
        self,
        *,
        batch: "v1TrialProfilerMetricsBatch",
    ):
        self.batch = batch

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetTrialProfilerMetricsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "batch": v1TrialProfilerMetricsBatch.from_json(obj["batch"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "batch": self.batch.to_json(omit_unset),
        }
        return out

class v1GetTrialRemainingLogRetentionDaysResponse(Printable):
    """Response to GetTrialRemainingLogRetentionDaysRequest."""
    remainingDays: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        remainingDays: "typing.Union[int, None, Unset]" = _unset,
    ):
        if not isinstance(remainingDays, Unset):
            self.remainingDays = remainingDays

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetTrialRemainingLogRetentionDaysResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "remainingDays" in obj:
            kwargs["remainingDays"] = obj["remainingDays"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "remainingDays" in vars(self):
            out["remainingDays"] = self.remainingDays
        return out

class v1GetTrialResponse(Printable):
    """Response to GetTrialRequest."""

    def __init__(
        self,
        *,
        trial: "trialv1Trial",
    ):
        self.trial = trial

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetTrialResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "trial": trialv1Trial.from_json(obj["trial"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "trial": self.trial.to_json(omit_unset),
        }
        return out

class v1GetTrialWorkloadsResponse(Printable):
    """Response to GetTrialWorkloadsRequest."""

    def __init__(
        self,
        *,
        pagination: "v1Pagination",
        workloads: "typing.Sequence[v1WorkloadContainer]",
    ):
        self.pagination = pagination
        self.workloads = workloads

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetTrialWorkloadsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "pagination": v1Pagination.from_json(obj["pagination"]),
            "workloads": [v1WorkloadContainer.from_json(x) for x in obj["workloads"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "pagination": self.pagination.to_json(omit_unset),
            "workloads": [x.to_json(omit_unset) for x in self.workloads],
        }
        return out

class v1GetUserByUsernameResponse(Printable):
    """Response to GetUserByUsernameRequest."""

    def __init__(
        self,
        *,
        user: "v1User",
    ):
        self.user = user

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetUserByUsernameResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "user": v1User.from_json(obj["user"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "user": self.user.to_json(omit_unset),
        }
        return out

class v1GetUserResponse(Printable):
    """Response to GetUserRequest."""

    def __init__(
        self,
        *,
        user: "v1User",
    ):
        self.user = user

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetUserResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "user": v1User.from_json(obj["user"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "user": self.user.to_json(omit_unset),
        }
        return out

class v1GetUserSettingResponse(Printable):
    """Response to GetUserSettingRequest."""

    def __init__(
        self,
        *,
        settings: "typing.Sequence[v1UserWebSetting]",
    ):
        self.settings = settings

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetUserSettingResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "settings": [v1UserWebSetting.from_json(x) for x in obj["settings"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "settings": [x.to_json(omit_unset) for x in self.settings],
        }
        return out

class v1GetUsersRequestSortBy(DetEnum):
    """Sort users by the given field.
    - SORT_BY_UNSPECIFIED: Returns users in an unsorted list.
    - SORT_BY_DISPLAY_NAME: Returns users sorted by display name.
    - SORT_BY_USER_NAME: Returns users sorted by user name.
    - SORT_BY_ADMIN: Returns users sorted by if they are admin.
    - SORT_BY_ACTIVE: Returns users sorted by if they are active.
    - SORT_BY_MODIFIED_TIME: Returns users sorted by modified time.
    - SORT_BY_NAME: Returns users sorted by username unless display name exist.
    - SORT_BY_LAST_AUTH_TIME: Returns users sorted by last authenticated time.
    - SORT_BY_REMOTE: Returns users sorted by local or remote auth.
    """
    UNSPECIFIED = "SORT_BY_UNSPECIFIED"
    DISPLAY_NAME = "SORT_BY_DISPLAY_NAME"
    USER_NAME = "SORT_BY_USER_NAME"
    ADMIN = "SORT_BY_ADMIN"
    ACTIVE = "SORT_BY_ACTIVE"
    MODIFIED_TIME = "SORT_BY_MODIFIED_TIME"
    NAME = "SORT_BY_NAME"
    LAST_AUTH_TIME = "SORT_BY_LAST_AUTH_TIME"
    REMOTE = "SORT_BY_REMOTE"

class v1GetUsersResponse(Printable):
    """Response to GetUsersRequest."""
    pagination: "typing.Optional[v1Pagination]" = None
    users: "typing.Optional[typing.Sequence[v1User]]" = None

    def __init__(
        self,
        *,
        pagination: "typing.Union[v1Pagination, None, Unset]" = _unset,
        users: "typing.Union[typing.Sequence[v1User], None, Unset]" = _unset,
    ):
        if not isinstance(pagination, Unset):
            self.pagination = pagination
        if not isinstance(users, Unset):
            self.users = users

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetUsersResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "pagination" in obj:
            kwargs["pagination"] = v1Pagination.from_json(obj["pagination"]) if obj["pagination"] is not None else None
        if "users" in obj:
            kwargs["users"] = [v1User.from_json(x) for x in obj["users"]] if obj["users"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "pagination" in vars(self):
            out["pagination"] = None if self.pagination is None else self.pagination.to_json(omit_unset)
        if not omit_unset or "users" in vars(self):
            out["users"] = None if self.users is None else [x.to_json(omit_unset) for x in self.users]
        return out

class v1GetValidationMetricsResponse(Printable):
    """Response to GetTrainingMetricsRequest."""

    def __init__(
        self,
        *,
        metrics: "typing.Sequence[v1MetricsReport]",
    ):
        self.metrics = metrics

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetValidationMetricsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "metrics": [v1MetricsReport.from_json(x) for x in obj["metrics"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "metrics": [x.to_json(omit_unset) for x in self.metrics],
        }
        return out

class v1GetWebhooksResponse(Printable):
    """Response to GetWebhooksRequest."""

    def __init__(
        self,
        *,
        webhooks: "typing.Sequence[v1Webhook]",
    ):
        self.webhooks = webhooks

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetWebhooksResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "webhooks": [v1Webhook.from_json(x) for x in obj["webhooks"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "webhooks": [x.to_json(omit_unset) for x in self.webhooks],
        }
        return out

class v1GetWorkspaceConfigPoliciesResponse(Printable):
    """Response to GetWorkspaceConfigPoliciesRequest."""
    configPolicies: "typing.Optional[typing.Dict[str, typing.Any]]" = None

    def __init__(
        self,
        *,
        configPolicies: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
    ):
        if not isinstance(configPolicies, Unset):
            self.configPolicies = configPolicies

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetWorkspaceConfigPoliciesResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "configPolicies" in obj:
            kwargs["configPolicies"] = obj["configPolicies"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "configPolicies" in vars(self):
            out["configPolicies"] = self.configPolicies
        return out

class v1GetWorkspaceProjectsRequestSortBy(DetEnum):
    """Sort associated projects by the given field.
    - SORT_BY_UNSPECIFIED: Returns projects in an unsorted list.
    - SORT_BY_CREATION_TIME: Returns projects sorted by time that they were created.
    - SORT_BY_LAST_EXPERIMENT_START_TIME: Returns projects sorted by most recent start of an experiment.
    - SORT_BY_NAME: Returns projects sorted by name.
    - SORT_BY_DESCRIPTION: Returns projects sorted by description.
    - SORT_BY_ID: Returns projects sorted by ID.
    """
    UNSPECIFIED = "SORT_BY_UNSPECIFIED"
    CREATION_TIME = "SORT_BY_CREATION_TIME"
    LAST_EXPERIMENT_START_TIME = "SORT_BY_LAST_EXPERIMENT_START_TIME"
    NAME = "SORT_BY_NAME"
    DESCRIPTION = "SORT_BY_DESCRIPTION"
    ID = "SORT_BY_ID"

class v1GetWorkspaceProjectsResponse(Printable):
    """Response to GetWorkspaceProjectsRequest."""

    def __init__(
        self,
        *,
        pagination: "v1Pagination",
        projects: "typing.Sequence[v1Project]",
    ):
        self.pagination = pagination
        self.projects = projects

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetWorkspaceProjectsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "pagination": v1Pagination.from_json(obj["pagination"]),
            "projects": [v1Project.from_json(x) for x in obj["projects"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "pagination": self.pagination.to_json(omit_unset),
            "projects": [x.to_json(omit_unset) for x in self.projects],
        }
        return out

class v1GetWorkspaceResponse(Printable):
    """Response to GetWorkspaceRequest."""

    def __init__(
        self,
        *,
        workspace: "v1Workspace",
    ):
        self.workspace = workspace

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetWorkspaceResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "workspace": v1Workspace.from_json(obj["workspace"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "workspace": self.workspace.to_json(omit_unset),
        }
        return out

class v1GetWorkspacesRequestSortBy(DetEnum):
    """Sort workspaces by the given field.
    - SORT_BY_UNSPECIFIED: Returns workspaces in an unsorted list.
    - SORT_BY_ID: Returns workspaces sorted by id.
    - SORT_BY_NAME: Returns workspaces sorted by name.
    """
    UNSPECIFIED = "SORT_BY_UNSPECIFIED"
    ID = "SORT_BY_ID"
    NAME = "SORT_BY_NAME"

class v1GetWorkspacesResponse(Printable):
    """Response to GetWorkspacesRequest."""

    def __init__(
        self,
        *,
        pagination: "v1Pagination",
        workspaces: "typing.Sequence[v1Workspace]",
    ):
        self.pagination = pagination
        self.workspaces = workspaces

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetWorkspacesResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "pagination": v1Pagination.from_json(obj["pagination"]),
            "workspaces": [v1Workspace.from_json(x) for x in obj["workspaces"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "pagination": self.pagination.to_json(omit_unset),
            "workspaces": [x.to_json(omit_unset) for x in self.workspaces],
        }
        return out

class v1GetWorkspacesWithDefaultNamespaceBindingsResponse(Printable):
    """Response to GetUnboundWorkspacesRequest."""
    workspaceIds: "typing.Optional[typing.Sequence[int]]" = None

    def __init__(
        self,
        *,
        workspaceIds: "typing.Union[typing.Sequence[int], None, Unset]" = _unset,
    ):
        if not isinstance(workspaceIds, Unset):
            self.workspaceIds = workspaceIds

    @classmethod
    def from_json(cls, obj: Json) -> "v1GetWorkspacesWithDefaultNamespaceBindingsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "workspaceIds" in obj:
            kwargs["workspaceIds"] = obj["workspaceIds"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "workspaceIds" in vars(self):
            out["workspaceIds"] = self.workspaceIds
        return out

class v1Group(Printable):
    groupId: "typing.Optional[int]" = None
    name: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        groupId: "typing.Union[int, None, Unset]" = _unset,
        name: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(groupId, Unset):
            self.groupId = groupId
        if not isinstance(name, Unset):
            self.name = name

    @classmethod
    def from_json(cls, obj: Json) -> "v1Group":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "groupId" in obj:
            kwargs["groupId"] = obj["groupId"]
        if "name" in obj:
            kwargs["name"] = obj["name"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "groupId" in vars(self):
            out["groupId"] = self.groupId
        if not omit_unset or "name" in vars(self):
            out["name"] = self.name
        return out

class v1GroupDetails(Printable):
    """GroupDetails contains detailed information about a specific Group
    including which users belong to the group.
    """
    groupId: "typing.Optional[int]" = None
    name: "typing.Optional[str]" = None
    users: "typing.Optional[typing.Sequence[v1User]]" = None

    def __init__(
        self,
        *,
        groupId: "typing.Union[int, None, Unset]" = _unset,
        name: "typing.Union[str, None, Unset]" = _unset,
        users: "typing.Union[typing.Sequence[v1User], None, Unset]" = _unset,
    ):
        if not isinstance(groupId, Unset):
            self.groupId = groupId
        if not isinstance(name, Unset):
            self.name = name
        if not isinstance(users, Unset):
            self.users = users

    @classmethod
    def from_json(cls, obj: Json) -> "v1GroupDetails":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "groupId" in obj:
            kwargs["groupId"] = obj["groupId"]
        if "name" in obj:
            kwargs["name"] = obj["name"]
        if "users" in obj:
            kwargs["users"] = [v1User.from_json(x) for x in obj["users"]] if obj["users"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "groupId" in vars(self):
            out["groupId"] = self.groupId
        if not omit_unset or "name" in vars(self):
            out["name"] = self.name
        if not omit_unset or "users" in vars(self):
            out["users"] = None if self.users is None else [x.to_json(omit_unset) for x in self.users]
        return out

class v1GroupRoleAssignment(Printable):
    """GroupRoleAssignment contains information about the groups
    belonging to a role.
    """

    def __init__(
        self,
        *,
        groupId: int,
        roleAssignment: "v1RoleAssignment",
    ):
        self.groupId = groupId
        self.roleAssignment = roleAssignment

    @classmethod
    def from_json(cls, obj: Json) -> "v1GroupRoleAssignment":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "groupId": obj["groupId"],
            "roleAssignment": v1RoleAssignment.from_json(obj["roleAssignment"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "groupId": self.groupId,
            "roleAssignment": self.roleAssignment.to_json(omit_unset),
        }
        return out

class v1GroupSearchResult(Printable):
    """GroupSearchResult is the representation of groups as they're returned
    by the search endpoint.
    """

    def __init__(
        self,
        *,
        group: "v1Group",
        numMembers: int,
    ):
        self.group = group
        self.numMembers = numMembers

    @classmethod
    def from_json(cls, obj: Json) -> "v1GroupSearchResult":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "group": v1Group.from_json(obj["group"]),
            "numMembers": obj["numMembers"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "group": self.group.to_json(omit_unset),
            "numMembers": self.numMembers,
        }
        return out

class v1IdleNotebookRequest(Printable):
    """Kill the requested notebook if idle."""
    idle: "typing.Optional[bool]" = None
    notebookId: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        idle: "typing.Union[bool, None, Unset]" = _unset,
        notebookId: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(idle, Unset):
            self.idle = idle
        if not isinstance(notebookId, Unset):
            self.notebookId = notebookId

    @classmethod
    def from_json(cls, obj: Json) -> "v1IdleNotebookRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "idle" in obj:
            kwargs["idle"] = obj["idle"]
        if "notebookId" in obj:
            kwargs["notebookId"] = obj["notebookId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "idle" in vars(self):
            out["idle"] = self.idle
        if not omit_unset or "notebookId" in vars(self):
            out["notebookId"] = self.notebookId
        return out

class v1Int32FieldFilter(Printable):
    """Int32 filters."""
    gt: "typing.Optional[int]" = None
    gte: "typing.Optional[int]" = None
    incl: "typing.Optional[typing.Sequence[int]]" = None
    lt: "typing.Optional[int]" = None
    lte: "typing.Optional[int]" = None
    notIn: "typing.Optional[typing.Sequence[int]]" = None

    def __init__(
        self,
        *,
        gt: "typing.Union[int, None, Unset]" = _unset,
        gte: "typing.Union[int, None, Unset]" = _unset,
        incl: "typing.Union[typing.Sequence[int], None, Unset]" = _unset,
        lt: "typing.Union[int, None, Unset]" = _unset,
        lte: "typing.Union[int, None, Unset]" = _unset,
        notIn: "typing.Union[typing.Sequence[int], None, Unset]" = _unset,
    ):
        if not isinstance(gt, Unset):
            self.gt = gt
        if not isinstance(gte, Unset):
            self.gte = gte
        if not isinstance(incl, Unset):
            self.incl = incl
        if not isinstance(lt, Unset):
            self.lt = lt
        if not isinstance(lte, Unset):
            self.lte = lte
        if not isinstance(notIn, Unset):
            self.notIn = notIn

    @classmethod
    def from_json(cls, obj: Json) -> "v1Int32FieldFilter":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "gt" in obj:
            kwargs["gt"] = obj["gt"]
        if "gte" in obj:
            kwargs["gte"] = obj["gte"]
        if "incl" in obj:
            kwargs["incl"] = obj["incl"]
        if "lt" in obj:
            kwargs["lt"] = obj["lt"]
        if "lte" in obj:
            kwargs["lte"] = obj["lte"]
        if "notIn" in obj:
            kwargs["notIn"] = obj["notIn"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "gt" in vars(self):
            out["gt"] = self.gt
        if not omit_unset or "gte" in vars(self):
            out["gte"] = self.gte
        if not omit_unset or "incl" in vars(self):
            out["incl"] = self.incl
        if not omit_unset or "lt" in vars(self):
            out["lt"] = self.lt
        if not omit_unset or "lte" in vars(self):
            out["lte"] = self.lte
        if not omit_unset or "notIn" in vars(self):
            out["notIn"] = self.notIn
        return out

class v1Job(Printable):
    """Job represents a user submitted work that is not in a terminal
    state.
    """
    priority: "typing.Optional[int]" = None
    progress: "typing.Optional[float]" = None
    summary: "typing.Optional[v1JobSummary]" = None
    userId: "typing.Optional[int]" = None
    weight: "typing.Optional[float]" = None

    def __init__(
        self,
        *,
        allocatedSlots: int,
        entityId: str,
        isPreemptible: bool,
        jobId: str,
        name: str,
        requestedSlots: int,
        resourcePool: str,
        submissionTime: str,
        type: "jobv1Type",
        username: str,
        workspaceId: int,
        priority: "typing.Union[int, None, Unset]" = _unset,
        progress: "typing.Union[float, None, Unset]" = _unset,
        summary: "typing.Union[v1JobSummary, None, Unset]" = _unset,
        userId: "typing.Union[int, None, Unset]" = _unset,
        weight: "typing.Union[float, None, Unset]" = _unset,
    ):
        self.allocatedSlots = allocatedSlots
        self.entityId = entityId
        self.isPreemptible = isPreemptible
        self.jobId = jobId
        self.name = name
        self.requestedSlots = requestedSlots
        self.resourcePool = resourcePool
        self.submissionTime = submissionTime
        self.type = type
        self.username = username
        self.workspaceId = workspaceId
        if not isinstance(priority, Unset):
            self.priority = priority
        if not isinstance(progress, Unset):
            self.progress = progress
        if not isinstance(summary, Unset):
            self.summary = summary
        if not isinstance(userId, Unset):
            self.userId = userId
        if not isinstance(weight, Unset):
            self.weight = weight

    @classmethod
    def from_json(cls, obj: Json) -> "v1Job":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "allocatedSlots": obj["allocatedSlots"],
            "entityId": obj["entityId"],
            "isPreemptible": obj["isPreemptible"],
            "jobId": obj["jobId"],
            "name": obj["name"],
            "requestedSlots": obj["requestedSlots"],
            "resourcePool": obj["resourcePool"],
            "submissionTime": obj["submissionTime"],
            "type": jobv1Type(obj["type"]),
            "username": obj["username"],
            "workspaceId": obj["workspaceId"],
        }
        if "priority" in obj:
            kwargs["priority"] = obj["priority"]
        if "progress" in obj:
            kwargs["progress"] = float(obj["progress"]) if obj["progress"] is not None else None
        if "summary" in obj:
            kwargs["summary"] = v1JobSummary.from_json(obj["summary"]) if obj["summary"] is not None else None
        if "userId" in obj:
            kwargs["userId"] = obj["userId"]
        if "weight" in obj:
            kwargs["weight"] = float(obj["weight"]) if obj["weight"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "allocatedSlots": self.allocatedSlots,
            "entityId": self.entityId,
            "isPreemptible": self.isPreemptible,
            "jobId": self.jobId,
            "name": self.name,
            "requestedSlots": self.requestedSlots,
            "resourcePool": self.resourcePool,
            "submissionTime": self.submissionTime,
            "type": self.type.value,
            "username": self.username,
            "workspaceId": self.workspaceId,
        }
        if not omit_unset or "priority" in vars(self):
            out["priority"] = self.priority
        if not omit_unset or "progress" in vars(self):
            out["progress"] = None if self.progress is None else dump_float(self.progress)
        if not omit_unset or "summary" in vars(self):
            out["summary"] = None if self.summary is None else self.summary.to_json(omit_unset)
        if not omit_unset or "userId" in vars(self):
            out["userId"] = self.userId
        if not omit_unset or "weight" in vars(self):
            out["weight"] = None if self.weight is None else dump_float(self.weight)
        return out

class v1JobSummary(Printable):
    """Job summary."""

    def __init__(
        self,
        *,
        jobsAhead: int,
        state: "jobv1State",
    ):
        self.jobsAhead = jobsAhead
        self.state = state

    @classmethod
    def from_json(cls, obj: Json) -> "v1JobSummary":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "jobsAhead": obj["jobsAhead"],
            "state": jobv1State(obj["state"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "jobsAhead": self.jobsAhead,
            "state": self.state.value,
        }
        return out

class v1K8PriorityClass(Printable):
    priorityClass: "typing.Optional[str]" = None
    priorityValue: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        priorityClass: "typing.Union[str, None, Unset]" = _unset,
        priorityValue: "typing.Union[int, None, Unset]" = _unset,
    ):
        if not isinstance(priorityClass, Unset):
            self.priorityClass = priorityClass
        if not isinstance(priorityValue, Unset):
            self.priorityValue = priorityValue

    @classmethod
    def from_json(cls, obj: Json) -> "v1K8PriorityClass":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "priorityClass" in obj:
            kwargs["priorityClass"] = obj["priorityClass"]
        if "priorityValue" in obj:
            kwargs["priorityValue"] = obj["priorityValue"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "priorityClass" in vars(self):
            out["priorityClass"] = self.priorityClass
        if not omit_unset or "priorityValue" in vars(self):
            out["priorityValue"] = self.priorityValue
        return out

class v1KillCommandResponse(Printable):
    """Response to KillCommandRequest."""
    command: "typing.Optional[v1Command]" = None

    def __init__(
        self,
        *,
        command: "typing.Union[v1Command, None, Unset]" = _unset,
    ):
        if not isinstance(command, Unset):
            self.command = command

    @classmethod
    def from_json(cls, obj: Json) -> "v1KillCommandResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "command" in obj:
            kwargs["command"] = v1Command.from_json(obj["command"]) if obj["command"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "command" in vars(self):
            out["command"] = None if self.command is None else self.command.to_json(omit_unset)
        return out

class v1KillExperimentsRequest(Printable):
    """Kill multiple experiments."""
    filters: "typing.Optional[v1BulkExperimentFilters]" = None

    def __init__(
        self,
        *,
        experimentIds: "typing.Sequence[int]",
        projectId: int,
        filters: "typing.Union[v1BulkExperimentFilters, None, Unset]" = _unset,
    ):
        self.experimentIds = experimentIds
        self.projectId = projectId
        if not isinstance(filters, Unset):
            self.filters = filters

    @classmethod
    def from_json(cls, obj: Json) -> "v1KillExperimentsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "experimentIds": obj["experimentIds"],
            "projectId": obj["projectId"],
        }
        if "filters" in obj:
            kwargs["filters"] = v1BulkExperimentFilters.from_json(obj["filters"]) if obj["filters"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "experimentIds": self.experimentIds,
            "projectId": self.projectId,
        }
        if not omit_unset or "filters" in vars(self):
            out["filters"] = None if self.filters is None else self.filters.to_json(omit_unset)
        return out

class v1KillExperimentsResponse(Printable):
    """Response to KillExperimentsRequest."""

    def __init__(
        self,
        *,
        results: "typing.Sequence[v1ExperimentActionResult]",
    ):
        self.results = results

    @classmethod
    def from_json(cls, obj: Json) -> "v1KillExperimentsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "results": [v1ExperimentActionResult.from_json(x) for x in obj["results"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "results": [x.to_json(omit_unset) for x in self.results],
        }
        return out

class v1KillGenericTaskRequest(Printable):
    killFromRoot: "typing.Optional[bool]" = None

    def __init__(
        self,
        *,
        taskId: str,
        killFromRoot: "typing.Union[bool, None, Unset]" = _unset,
    ):
        self.taskId = taskId
        if not isinstance(killFromRoot, Unset):
            self.killFromRoot = killFromRoot

    @classmethod
    def from_json(cls, obj: Json) -> "v1KillGenericTaskRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "taskId": obj["taskId"],
        }
        if "killFromRoot" in obj:
            kwargs["killFromRoot"] = obj["killFromRoot"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "taskId": self.taskId,
        }
        if not omit_unset or "killFromRoot" in vars(self):
            out["killFromRoot"] = self.killFromRoot
        return out

class v1KillNotebookResponse(Printable):
    """Response to KillNotebookRequest."""
    notebook: "typing.Optional[v1Notebook]" = None

    def __init__(
        self,
        *,
        notebook: "typing.Union[v1Notebook, None, Unset]" = _unset,
    ):
        if not isinstance(notebook, Unset):
            self.notebook = notebook

    @classmethod
    def from_json(cls, obj: Json) -> "v1KillNotebookResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "notebook" in obj:
            kwargs["notebook"] = v1Notebook.from_json(obj["notebook"]) if obj["notebook"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "notebook" in vars(self):
            out["notebook"] = None if self.notebook is None else self.notebook.to_json(omit_unset)
        return out

class v1KillRunsRequest(Printable):
    """Kill runs."""
    filter: "typing.Optional[str]" = None
    projectId: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        runIds: "typing.Sequence[int]",
        filter: "typing.Union[str, None, Unset]" = _unset,
        projectId: "typing.Union[int, None, Unset]" = _unset,
    ):
        self.runIds = runIds
        if not isinstance(filter, Unset):
            self.filter = filter
        if not isinstance(projectId, Unset):
            self.projectId = projectId

    @classmethod
    def from_json(cls, obj: Json) -> "v1KillRunsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "runIds": obj["runIds"],
        }
        if "filter" in obj:
            kwargs["filter"] = obj["filter"]
        if "projectId" in obj:
            kwargs["projectId"] = obj["projectId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "runIds": self.runIds,
        }
        if not omit_unset or "filter" in vars(self):
            out["filter"] = self.filter
        if not omit_unset or "projectId" in vars(self):
            out["projectId"] = self.projectId
        return out

class v1KillRunsResponse(Printable):
    """Response to KillRunsResponse."""

    def __init__(
        self,
        *,
        results: "typing.Sequence[v1RunActionResult]",
    ):
        self.results = results

    @classmethod
    def from_json(cls, obj: Json) -> "v1KillRunsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "results": [v1RunActionResult.from_json(x) for x in obj["results"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "results": [x.to_json(omit_unset) for x in self.results],
        }
        return out

class v1KillShellResponse(Printable):
    """Response to KillShellRequest."""
    shell: "typing.Optional[v1Shell]" = None

    def __init__(
        self,
        *,
        shell: "typing.Union[v1Shell, None, Unset]" = _unset,
    ):
        if not isinstance(shell, Unset):
            self.shell = shell

    @classmethod
    def from_json(cls, obj: Json) -> "v1KillShellResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "shell" in obj:
            kwargs["shell"] = v1Shell.from_json(obj["shell"]) if obj["shell"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "shell" in vars(self):
            out["shell"] = None if self.shell is None else self.shell.to_json(omit_unset)
        return out

class v1KillTensorboardResponse(Printable):
    """Response to KillTensorboardRequest."""
    tensorboard: "typing.Optional[v1Tensorboard]" = None

    def __init__(
        self,
        *,
        tensorboard: "typing.Union[v1Tensorboard, None, Unset]" = _unset,
    ):
        if not isinstance(tensorboard, Unset):
            self.tensorboard = tensorboard

    @classmethod
    def from_json(cls, obj: Json) -> "v1KillTensorboardResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "tensorboard" in obj:
            kwargs["tensorboard"] = v1Tensorboard.from_json(obj["tensorboard"]) if obj["tensorboard"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "tensorboard" in vars(self):
            out["tensorboard"] = None if self.tensorboard is None else self.tensorboard.to_json(omit_unset)
        return out

class v1LaunchCommandRequest(Printable):
    """Request to launch a command."""
    config: "typing.Optional[typing.Dict[str, typing.Any]]" = None
    data: "typing.Optional[str]" = None
    files: "typing.Optional[typing.Sequence[v1File]]" = None
    templateName: "typing.Optional[str]" = None
    workspaceId: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        config: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
        data: "typing.Union[str, None, Unset]" = _unset,
        files: "typing.Union[typing.Sequence[v1File], None, Unset]" = _unset,
        templateName: "typing.Union[str, None, Unset]" = _unset,
        workspaceId: "typing.Union[int, None, Unset]" = _unset,
    ):
        if not isinstance(config, Unset):
            self.config = config
        if not isinstance(data, Unset):
            self.data = data
        if not isinstance(files, Unset):
            self.files = files
        if not isinstance(templateName, Unset):
            self.templateName = templateName
        if not isinstance(workspaceId, Unset):
            self.workspaceId = workspaceId

    @classmethod
    def from_json(cls, obj: Json) -> "v1LaunchCommandRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "config" in obj:
            kwargs["config"] = obj["config"]
        if "data" in obj:
            kwargs["data"] = obj["data"]
        if "files" in obj:
            kwargs["files"] = [v1File.from_json(x) for x in obj["files"]] if obj["files"] is not None else None
        if "templateName" in obj:
            kwargs["templateName"] = obj["templateName"]
        if "workspaceId" in obj:
            kwargs["workspaceId"] = obj["workspaceId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "config" in vars(self):
            out["config"] = self.config
        if not omit_unset or "data" in vars(self):
            out["data"] = self.data
        if not omit_unset or "files" in vars(self):
            out["files"] = None if self.files is None else [x.to_json(omit_unset) for x in self.files]
        if not omit_unset or "templateName" in vars(self):
            out["templateName"] = self.templateName
        if not omit_unset or "workspaceId" in vars(self):
            out["workspaceId"] = self.workspaceId
        return out

class v1LaunchCommandResponse(Printable):
    """Response to LaunchCommandRequest."""
    warnings: "typing.Optional[typing.Sequence[v1LaunchWarning]]" = None

    def __init__(
        self,
        *,
        command: "v1Command",
        config: "typing.Dict[str, typing.Any]",
        warnings: "typing.Union[typing.Sequence[v1LaunchWarning], None, Unset]" = _unset,
    ):
        self.command = command
        self.config = config
        if not isinstance(warnings, Unset):
            self.warnings = warnings

    @classmethod
    def from_json(cls, obj: Json) -> "v1LaunchCommandResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "command": v1Command.from_json(obj["command"]),
            "config": obj["config"],
        }
        if "warnings" in obj:
            kwargs["warnings"] = [v1LaunchWarning(x) for x in obj["warnings"]] if obj["warnings"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "command": self.command.to_json(omit_unset),
            "config": self.config,
        }
        if not omit_unset or "warnings" in vars(self):
            out["warnings"] = None if self.warnings is None else [x.value for x in self.warnings]
        return out

class v1LaunchNotebookRequest(Printable):
    """Request to launch a notebook."""
    config: "typing.Optional[typing.Dict[str, typing.Any]]" = None
    files: "typing.Optional[typing.Sequence[v1File]]" = None
    preview: "typing.Optional[bool]" = None
    templateName: "typing.Optional[str]" = None
    workspaceId: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        config: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
        files: "typing.Union[typing.Sequence[v1File], None, Unset]" = _unset,
        preview: "typing.Union[bool, None, Unset]" = _unset,
        templateName: "typing.Union[str, None, Unset]" = _unset,
        workspaceId: "typing.Union[int, None, Unset]" = _unset,
    ):
        if not isinstance(config, Unset):
            self.config = config
        if not isinstance(files, Unset):
            self.files = files
        if not isinstance(preview, Unset):
            self.preview = preview
        if not isinstance(templateName, Unset):
            self.templateName = templateName
        if not isinstance(workspaceId, Unset):
            self.workspaceId = workspaceId

    @classmethod
    def from_json(cls, obj: Json) -> "v1LaunchNotebookRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "config" in obj:
            kwargs["config"] = obj["config"]
        if "files" in obj:
            kwargs["files"] = [v1File.from_json(x) for x in obj["files"]] if obj["files"] is not None else None
        if "preview" in obj:
            kwargs["preview"] = obj["preview"]
        if "templateName" in obj:
            kwargs["templateName"] = obj["templateName"]
        if "workspaceId" in obj:
            kwargs["workspaceId"] = obj["workspaceId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "config" in vars(self):
            out["config"] = self.config
        if not omit_unset or "files" in vars(self):
            out["files"] = None if self.files is None else [x.to_json(omit_unset) for x in self.files]
        if not omit_unset or "preview" in vars(self):
            out["preview"] = self.preview
        if not omit_unset or "templateName" in vars(self):
            out["templateName"] = self.templateName
        if not omit_unset or "workspaceId" in vars(self):
            out["workspaceId"] = self.workspaceId
        return out

class v1LaunchNotebookResponse(Printable):
    """Response to LaunchNotebookRequest."""
    warnings: "typing.Optional[typing.Sequence[v1LaunchWarning]]" = None

    def __init__(
        self,
        *,
        config: "typing.Dict[str, typing.Any]",
        notebook: "v1Notebook",
        warnings: "typing.Union[typing.Sequence[v1LaunchWarning], None, Unset]" = _unset,
    ):
        self.config = config
        self.notebook = notebook
        if not isinstance(warnings, Unset):
            self.warnings = warnings

    @classmethod
    def from_json(cls, obj: Json) -> "v1LaunchNotebookResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "config": obj["config"],
            "notebook": v1Notebook.from_json(obj["notebook"]),
        }
        if "warnings" in obj:
            kwargs["warnings"] = [v1LaunchWarning(x) for x in obj["warnings"]] if obj["warnings"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "config": self.config,
            "notebook": self.notebook.to_json(omit_unset),
        }
        if not omit_unset or "warnings" in vars(self):
            out["warnings"] = None if self.warnings is None else [x.value for x in self.warnings]
        return out

class v1LaunchShellRequest(Printable):
    """Request to launch a shell."""
    config: "typing.Optional[typing.Dict[str, typing.Any]]" = None
    data: "typing.Optional[str]" = None
    files: "typing.Optional[typing.Sequence[v1File]]" = None
    templateName: "typing.Optional[str]" = None
    workspaceId: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        config: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
        data: "typing.Union[str, None, Unset]" = _unset,
        files: "typing.Union[typing.Sequence[v1File], None, Unset]" = _unset,
        templateName: "typing.Union[str, None, Unset]" = _unset,
        workspaceId: "typing.Union[int, None, Unset]" = _unset,
    ):
        if not isinstance(config, Unset):
            self.config = config
        if not isinstance(data, Unset):
            self.data = data
        if not isinstance(files, Unset):
            self.files = files
        if not isinstance(templateName, Unset):
            self.templateName = templateName
        if not isinstance(workspaceId, Unset):
            self.workspaceId = workspaceId

    @classmethod
    def from_json(cls, obj: Json) -> "v1LaunchShellRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "config" in obj:
            kwargs["config"] = obj["config"]
        if "data" in obj:
            kwargs["data"] = obj["data"]
        if "files" in obj:
            kwargs["files"] = [v1File.from_json(x) for x in obj["files"]] if obj["files"] is not None else None
        if "templateName" in obj:
            kwargs["templateName"] = obj["templateName"]
        if "workspaceId" in obj:
            kwargs["workspaceId"] = obj["workspaceId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "config" in vars(self):
            out["config"] = self.config
        if not omit_unset or "data" in vars(self):
            out["data"] = self.data
        if not omit_unset or "files" in vars(self):
            out["files"] = None if self.files is None else [x.to_json(omit_unset) for x in self.files]
        if not omit_unset or "templateName" in vars(self):
            out["templateName"] = self.templateName
        if not omit_unset or "workspaceId" in vars(self):
            out["workspaceId"] = self.workspaceId
        return out

class v1LaunchShellResponse(Printable):
    """Response to LaunchShellRequest."""
    warnings: "typing.Optional[typing.Sequence[v1LaunchWarning]]" = None

    def __init__(
        self,
        *,
        config: "typing.Dict[str, typing.Any]",
        shell: "v1Shell",
        warnings: "typing.Union[typing.Sequence[v1LaunchWarning], None, Unset]" = _unset,
    ):
        self.config = config
        self.shell = shell
        if not isinstance(warnings, Unset):
            self.warnings = warnings

    @classmethod
    def from_json(cls, obj: Json) -> "v1LaunchShellResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "config": obj["config"],
            "shell": v1Shell.from_json(obj["shell"]),
        }
        if "warnings" in obj:
            kwargs["warnings"] = [v1LaunchWarning(x) for x in obj["warnings"]] if obj["warnings"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "config": self.config,
            "shell": self.shell.to_json(omit_unset),
        }
        if not omit_unset or "warnings" in vars(self):
            out["warnings"] = None if self.warnings is None else [x.value for x in self.warnings]
        return out

class v1LaunchTensorboardRequest(Printable):
    """Request to launch a tensorboard."""
    config: "typing.Optional[typing.Dict[str, typing.Any]]" = None
    experimentIds: "typing.Optional[typing.Sequence[int]]" = None
    files: "typing.Optional[typing.Sequence[v1File]]" = None
    filters: "typing.Optional[v1BulkExperimentFilters]" = None
    templateName: "typing.Optional[str]" = None
    trialIds: "typing.Optional[typing.Sequence[int]]" = None
    workspaceId: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        config: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
        experimentIds: "typing.Union[typing.Sequence[int], None, Unset]" = _unset,
        files: "typing.Union[typing.Sequence[v1File], None, Unset]" = _unset,
        filters: "typing.Union[v1BulkExperimentFilters, None, Unset]" = _unset,
        templateName: "typing.Union[str, None, Unset]" = _unset,
        trialIds: "typing.Union[typing.Sequence[int], None, Unset]" = _unset,
        workspaceId: "typing.Union[int, None, Unset]" = _unset,
    ):
        if not isinstance(config, Unset):
            self.config = config
        if not isinstance(experimentIds, Unset):
            self.experimentIds = experimentIds
        if not isinstance(files, Unset):
            self.files = files
        if not isinstance(filters, Unset):
            self.filters = filters
        if not isinstance(templateName, Unset):
            self.templateName = templateName
        if not isinstance(trialIds, Unset):
            self.trialIds = trialIds
        if not isinstance(workspaceId, Unset):
            self.workspaceId = workspaceId

    @classmethod
    def from_json(cls, obj: Json) -> "v1LaunchTensorboardRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "config" in obj:
            kwargs["config"] = obj["config"]
        if "experimentIds" in obj:
            kwargs["experimentIds"] = obj["experimentIds"]
        if "files" in obj:
            kwargs["files"] = [v1File.from_json(x) for x in obj["files"]] if obj["files"] is not None else None
        if "filters" in obj:
            kwargs["filters"] = v1BulkExperimentFilters.from_json(obj["filters"]) if obj["filters"] is not None else None
        if "templateName" in obj:
            kwargs["templateName"] = obj["templateName"]
        if "trialIds" in obj:
            kwargs["trialIds"] = obj["trialIds"]
        if "workspaceId" in obj:
            kwargs["workspaceId"] = obj["workspaceId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "config" in vars(self):
            out["config"] = self.config
        if not omit_unset or "experimentIds" in vars(self):
            out["experimentIds"] = self.experimentIds
        if not omit_unset or "files" in vars(self):
            out["files"] = None if self.files is None else [x.to_json(omit_unset) for x in self.files]
        if not omit_unset or "filters" in vars(self):
            out["filters"] = None if self.filters is None else self.filters.to_json(omit_unset)
        if not omit_unset or "templateName" in vars(self):
            out["templateName"] = self.templateName
        if not omit_unset or "trialIds" in vars(self):
            out["trialIds"] = self.trialIds
        if not omit_unset or "workspaceId" in vars(self):
            out["workspaceId"] = self.workspaceId
        return out

class v1LaunchTensorboardResponse(Printable):
    """Response to LaunchTensorboardRequest."""
    warnings: "typing.Optional[typing.Sequence[v1LaunchWarning]]" = None

    def __init__(
        self,
        *,
        config: "typing.Dict[str, typing.Any]",
        tensorboard: "v1Tensorboard",
        warnings: "typing.Union[typing.Sequence[v1LaunchWarning], None, Unset]" = _unset,
    ):
        self.config = config
        self.tensorboard = tensorboard
        if not isinstance(warnings, Unset):
            self.warnings = warnings

    @classmethod
    def from_json(cls, obj: Json) -> "v1LaunchTensorboardResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "config": obj["config"],
            "tensorboard": v1Tensorboard.from_json(obj["tensorboard"]),
        }
        if "warnings" in obj:
            kwargs["warnings"] = [v1LaunchWarning(x) for x in obj["warnings"]] if obj["warnings"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "config": self.config,
            "tensorboard": self.tensorboard.to_json(omit_unset),
        }
        if not omit_unset or "warnings" in vars(self):
            out["warnings"] = None if self.warnings is None else [x.value for x in self.warnings]
        return out

class v1LaunchWarning(DetEnum):
    """Enum values for warnings when launching commands.
    - LAUNCH_WARNING_UNSPECIFIED: Default value
    - LAUNCH_WARNING_CURRENT_SLOTS_EXCEEDED: For a default webhook
    """
    UNSPECIFIED = "LAUNCH_WARNING_UNSPECIFIED"
    CURRENT_SLOTS_EXCEEDED = "LAUNCH_WARNING_CURRENT_SLOTS_EXCEEDED"

class v1LimitedJob(Printable):
    """LimitedJob is a Job with omitted fields."""
    priority: "typing.Optional[int]" = None
    progress: "typing.Optional[float]" = None
    summary: "typing.Optional[v1JobSummary]" = None
    weight: "typing.Optional[float]" = None

    def __init__(
        self,
        *,
        allocatedSlots: int,
        isPreemptible: bool,
        jobId: str,
        requestedSlots: int,
        resourcePool: str,
        type: "jobv1Type",
        workspaceId: int,
        priority: "typing.Union[int, None, Unset]" = _unset,
        progress: "typing.Union[float, None, Unset]" = _unset,
        summary: "typing.Union[v1JobSummary, None, Unset]" = _unset,
        weight: "typing.Union[float, None, Unset]" = _unset,
    ):
        self.allocatedSlots = allocatedSlots
        self.isPreemptible = isPreemptible
        self.jobId = jobId
        self.requestedSlots = requestedSlots
        self.resourcePool = resourcePool
        self.type = type
        self.workspaceId = workspaceId
        if not isinstance(priority, Unset):
            self.priority = priority
        if not isinstance(progress, Unset):
            self.progress = progress
        if not isinstance(summary, Unset):
            self.summary = summary
        if not isinstance(weight, Unset):
            self.weight = weight

    @classmethod
    def from_json(cls, obj: Json) -> "v1LimitedJob":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "allocatedSlots": obj["allocatedSlots"],
            "isPreemptible": obj["isPreemptible"],
            "jobId": obj["jobId"],
            "requestedSlots": obj["requestedSlots"],
            "resourcePool": obj["resourcePool"],
            "type": jobv1Type(obj["type"]),
            "workspaceId": obj["workspaceId"],
        }
        if "priority" in obj:
            kwargs["priority"] = obj["priority"]
        if "progress" in obj:
            kwargs["progress"] = float(obj["progress"]) if obj["progress"] is not None else None
        if "summary" in obj:
            kwargs["summary"] = v1JobSummary.from_json(obj["summary"]) if obj["summary"] is not None else None
        if "weight" in obj:
            kwargs["weight"] = float(obj["weight"]) if obj["weight"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "allocatedSlots": self.allocatedSlots,
            "isPreemptible": self.isPreemptible,
            "jobId": self.jobId,
            "requestedSlots": self.requestedSlots,
            "resourcePool": self.resourcePool,
            "type": self.type.value,
            "workspaceId": self.workspaceId,
        }
        if not omit_unset or "priority" in vars(self):
            out["priority"] = self.priority
        if not omit_unset or "progress" in vars(self):
            out["progress"] = None if self.progress is None else dump_float(self.progress)
        if not omit_unset or "summary" in vars(self):
            out["summary"] = None if self.summary is None else self.summary.to_json(omit_unset)
        if not omit_unset or "weight" in vars(self):
            out["weight"] = None if self.weight is None else dump_float(self.weight)
        return out

class v1ListRPsBoundToWorkspaceResponse(Printable):
    """Response to ListWorkspaceRPsRequest."""
    pagination: "typing.Optional[v1Pagination]" = None
    resourcePools: "typing.Optional[typing.Sequence[str]]" = None

    def __init__(
        self,
        *,
        pagination: "typing.Union[v1Pagination, None, Unset]" = _unset,
        resourcePools: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
    ):
        if not isinstance(pagination, Unset):
            self.pagination = pagination
        if not isinstance(resourcePools, Unset):
            self.resourcePools = resourcePools

    @classmethod
    def from_json(cls, obj: Json) -> "v1ListRPsBoundToWorkspaceResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "pagination" in obj:
            kwargs["pagination"] = v1Pagination.from_json(obj["pagination"]) if obj["pagination"] is not None else None
        if "resourcePools" in obj:
            kwargs["resourcePools"] = obj["resourcePools"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "pagination" in vars(self):
            out["pagination"] = None if self.pagination is None else self.pagination.to_json(omit_unset)
        if not omit_unset or "resourcePools" in vars(self):
            out["resourcePools"] = self.resourcePools
        return out

class v1ListRolesRequest(Printable):
    """ListRolesRequest is the body of the request for the call
    to search for a role.
    """
    offset: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        limit: int,
        offset: "typing.Union[int, None, Unset]" = _unset,
    ):
        self.limit = limit
        if not isinstance(offset, Unset):
            self.offset = offset

    @classmethod
    def from_json(cls, obj: Json) -> "v1ListRolesRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "limit": obj["limit"],
        }
        if "offset" in obj:
            kwargs["offset"] = obj["offset"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "limit": self.limit,
        }
        if not omit_unset or "offset" in vars(self):
            out["offset"] = self.offset
        return out

class v1ListRolesResponse(Printable):
    """ListRolesResponse is the body of the response for the call
    to search for a role.
    """

    def __init__(
        self,
        *,
        pagination: "v1Pagination",
        roles: "typing.Sequence[v1Role]",
    ):
        self.pagination = pagination
        self.roles = roles

    @classmethod
    def from_json(cls, obj: Json) -> "v1ListRolesResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "pagination": v1Pagination.from_json(obj["pagination"]),
            "roles": [v1Role.from_json(x) for x in obj["roles"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "pagination": self.pagination.to_json(omit_unset),
            "roles": [x.to_json(omit_unset) for x in self.roles],
        }
        return out

class v1ListWorkspaceNamespaceBindingsResponse(Printable):
    """Response for listing namespaces bound to a workspace."""

    def __init__(
        self,
        *,
        namespaceBindings: "typing.Dict[str, v1WorkspaceNamespaceBinding]",
    ):
        self.namespaceBindings = namespaceBindings

    @classmethod
    def from_json(cls, obj: Json) -> "v1ListWorkspaceNamespaceBindingsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "namespaceBindings": {k: v1WorkspaceNamespaceBinding.from_json(v) for k, v in obj["namespaceBindings"].items()},
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "namespaceBindings": {k: v.to_json(omit_unset) for k, v in self.namespaceBindings.items()},
        }
        return out

class v1ListWorkspacesBoundToRPResponse(Printable):
    """Response to ListWorkspacesBoundToRPRequest."""
    pagination: "typing.Optional[v1Pagination]" = None
    workspaceIds: "typing.Optional[typing.Sequence[int]]" = None

    def __init__(
        self,
        *,
        pagination: "typing.Union[v1Pagination, None, Unset]" = _unset,
        workspaceIds: "typing.Union[typing.Sequence[int], None, Unset]" = _unset,
    ):
        if not isinstance(pagination, Unset):
            self.pagination = pagination
        if not isinstance(workspaceIds, Unset):
            self.workspaceIds = workspaceIds

    @classmethod
    def from_json(cls, obj: Json) -> "v1ListWorkspacesBoundToRPResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "pagination" in obj:
            kwargs["pagination"] = v1Pagination.from_json(obj["pagination"]) if obj["pagination"] is not None else None
        if "workspaceIds" in obj:
            kwargs["workspaceIds"] = obj["workspaceIds"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "pagination" in vars(self):
            out["pagination"] = None if self.pagination is None else self.pagination.to_json(omit_unset)
        if not omit_unset or "workspaceIds" in vars(self):
            out["workspaceIds"] = self.workspaceIds
        return out

class v1LocationType(DetEnum):
    """LocationType indicates where a column comes from
    - LOCATION_TYPE_UNSPECIFIED: Location unknown
    - LOCATION_TYPE_EXPERIMENT: Column is located on the experiment
    - LOCATION_TYPE_HYPERPARAMETERS: Column is located in the hyperparameter config of the experiment
    - LOCATION_TYPE_VALIDATIONS: Column is located on the experiment's validation metrics
    - LOCATION_TYPE_TRAINING: Column is located on the experiment's training steps
    - LOCATION_TYPE_CUSTOM_METRIC: Column is located on the experiment's custom metric
    - LOCATION_TYPE_RUN: Column is located on the run
    - LOCATION_TYPE_RUN_HYPERPARAMETERS: Column is located in the hyperparameter of the run
    - LOCATION_TYPE_RUN_METADATA: Column is located on the run's arbitrary metadata
    """
    UNSPECIFIED = "LOCATION_TYPE_UNSPECIFIED"
    EXPERIMENT = "LOCATION_TYPE_EXPERIMENT"
    HYPERPARAMETERS = "LOCATION_TYPE_HYPERPARAMETERS"
    VALIDATIONS = "LOCATION_TYPE_VALIDATIONS"
    TRAINING = "LOCATION_TYPE_TRAINING"
    CUSTOM_METRIC = "LOCATION_TYPE_CUSTOM_METRIC"
    RUN = "LOCATION_TYPE_RUN"
    RUN_HYPERPARAMETERS = "LOCATION_TYPE_RUN_HYPERPARAMETERS"
    RUN_METADATA = "LOCATION_TYPE_RUN_METADATA"

class v1LogConfig(Printable):
    color: "typing.Optional[bool]" = None
    level: "typing.Optional[v1LogLevel]" = None

    def __init__(
        self,
        *,
        color: "typing.Union[bool, None, Unset]" = _unset,
        level: "typing.Union[v1LogLevel, None, Unset]" = _unset,
    ):
        if not isinstance(color, Unset):
            self.color = color
        if not isinstance(level, Unset):
            self.level = level

    @classmethod
    def from_json(cls, obj: Json) -> "v1LogConfig":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "color" in obj:
            kwargs["color"] = obj["color"]
        if "level" in obj:
            kwargs["level"] = v1LogLevel(obj["level"]) if obj["level"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "color" in vars(self):
            out["color"] = self.color
        if not omit_unset or "level" in vars(self):
            out["level"] = None if self.level is None else self.level.value
        return out

class v1LogEntry(Printable):
    """LogEntry is a log event."""

    def __init__(
        self,
        *,
        id: int,
        level: "v1LogLevel",
        message: str,
        timestamp: str,
    ):
        self.id = id
        self.level = level
        self.message = message
        self.timestamp = timestamp

    @classmethod
    def from_json(cls, obj: Json) -> "v1LogEntry":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "id": obj["id"],
            "level": v1LogLevel(obj["level"]),
            "message": obj["message"],
            "timestamp": obj["timestamp"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "id": self.id,
            "level": self.level.value,
            "message": self.message,
            "timestamp": self.timestamp,
        }
        return out

class v1LogLevel(DetEnum):
    """LogLevel specifies the level for a log.
    - LOG_LEVEL_UNSPECIFIED: Unspecified log level.
    - LOG_LEVEL_TRACE: A log level of TRACE.
    - LOG_LEVEL_DEBUG: A log level of DEBUG.
    - LOG_LEVEL_INFO: A log level of INFO.
    - LOG_LEVEL_WARNING: A log level of WARNING.
    - LOG_LEVEL_ERROR: A log level of ERROR.
    - LOG_LEVEL_CRITICAL: A log level of CRITICAL.
    """
    UNSPECIFIED = "LOG_LEVEL_UNSPECIFIED"
    TRACE = "LOG_LEVEL_TRACE"
    DEBUG = "LOG_LEVEL_DEBUG"
    INFO = "LOG_LEVEL_INFO"
    WARNING = "LOG_LEVEL_WARNING"
    ERROR = "LOG_LEVEL_ERROR"
    CRITICAL = "LOG_LEVEL_CRITICAL"

class v1LoginRequest(Printable):
    """Login the user."""
    isHashed: "typing.Optional[bool]" = None

    def __init__(
        self,
        *,
        password: str,
        username: str,
        isHashed: "typing.Union[bool, None, Unset]" = _unset,
    ):
        self.password = password
        self.username = username
        if not isinstance(isHashed, Unset):
            self.isHashed = isHashed

    @classmethod
    def from_json(cls, obj: Json) -> "v1LoginRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "password": obj["password"],
            "username": obj["username"],
        }
        if "isHashed" in obj:
            kwargs["isHashed"] = obj["isHashed"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "password": self.password,
            "username": self.username,
        }
        if not omit_unset or "isHashed" in vars(self):
            out["isHashed"] = self.isHashed
        return out

class v1LoginResponse(Printable):
    """Response to LoginRequest."""

    def __init__(
        self,
        *,
        token: str,
        user: "v1User",
    ):
        self.token = token
        self.user = user

    @classmethod
    def from_json(cls, obj: Json) -> "v1LoginResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "token": obj["token"],
            "user": v1User.from_json(obj["user"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "token": self.token,
            "user": self.user.to_json(omit_unset),
        }
        return out

class v1MarkAllocationResourcesDaemonRequest(Printable):
    """Mark some reservation as a daemon."""
    resourcesId: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        allocationId: str,
        resourcesId: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.allocationId = allocationId
        if not isinstance(resourcesId, Unset):
            self.resourcesId = resourcesId

    @classmethod
    def from_json(cls, obj: Json) -> "v1MarkAllocationResourcesDaemonRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "allocationId": obj["allocationId"],
        }
        if "resourcesId" in obj:
            kwargs["resourcesId"] = obj["resourcesId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "allocationId": self.allocationId,
        }
        if not omit_unset or "resourcesId" in vars(self):
            out["resourcesId"] = self.resourcesId
        return out

class v1MasterLogsResponse(Printable):
    """Response to MasterLogsRequest."""

    def __init__(
        self,
        *,
        logEntry: "v1LogEntry",
    ):
        self.logEntry = logEntry

    @classmethod
    def from_json(cls, obj: Json) -> "v1MasterLogsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "logEntry": v1LogEntry.from_json(obj["logEntry"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "logEntry": self.logEntry.to_json(omit_unset),
        }
        return out

class v1MetricBatchesResponse(Printable):
    """Response to MetricBatchesRequest."""
    batches: "typing.Optional[typing.Sequence[int]]" = None

    def __init__(
        self,
        *,
        batches: "typing.Union[typing.Sequence[int], None, Unset]" = _unset,
    ):
        if not isinstance(batches, Unset):
            self.batches = batches

    @classmethod
    def from_json(cls, obj: Json) -> "v1MetricBatchesResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "batches" in obj:
            kwargs["batches"] = obj["batches"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "batches" in vars(self):
            out["batches"] = self.batches
        return out

class v1MetricIdentifier(Printable):
    """MetricIdentifier packages metric name and group."""

    def __init__(
        self,
        *,
        group: str,
        name: str,
    ):
        self.group = group
        self.name = name

    @classmethod
    def from_json(cls, obj: Json) -> "v1MetricIdentifier":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "group": obj["group"],
            "name": obj["name"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "group": self.group,
            "name": self.name,
        }
        return out

class v1MetricType(DetEnum):
    """To distinguish the different categories of metrics.
    - METRIC_TYPE_UNSPECIFIED: Zero-value (not allowed).
    - METRIC_TYPE_TRAINING: For metrics emitted during training.
    - METRIC_TYPE_VALIDATION: For metrics emitted during validation.
    - METRIC_TYPE_PROFILING: For metrics emitted during profiling.
    """
    UNSPECIFIED = "METRIC_TYPE_UNSPECIFIED"
    TRAINING = "METRIC_TYPE_TRAINING"
    VALIDATION = "METRIC_TYPE_VALIDATION"
    PROFILING = "METRIC_TYPE_PROFILING"

class v1Metrics(Printable):
    batchMetrics: "typing.Optional[typing.Sequence[typing.Dict[str, typing.Any]]]" = None

    def __init__(
        self,
        *,
        avgMetrics: "typing.Dict[str, typing.Any]",
        batchMetrics: "typing.Union[typing.Sequence[typing.Dict[str, typing.Any]], None, Unset]" = _unset,
    ):
        self.avgMetrics = avgMetrics
        if not isinstance(batchMetrics, Unset):
            self.batchMetrics = batchMetrics

    @classmethod
    def from_json(cls, obj: Json) -> "v1Metrics":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "avgMetrics": obj["avgMetrics"],
        }
        if "batchMetrics" in obj:
            kwargs["batchMetrics"] = obj["batchMetrics"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "avgMetrics": self.avgMetrics,
        }
        if not omit_unset or "batchMetrics" in vars(self):
            out["batchMetrics"] = self.batchMetrics
        return out

class v1MetricsRange(Printable):
    """MetricsRange represents the range of a metrics. Range is a in the format of
    [min, max].
    """

    def __init__(
        self,
        *,
        max: float,
        metricsName: str,
        min: float,
    ):
        self.max = max
        self.metricsName = metricsName
        self.min = min

    @classmethod
    def from_json(cls, obj: Json) -> "v1MetricsRange":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "max": float(obj["max"]),
            "metricsName": obj["metricsName"],
            "min": float(obj["min"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "max": dump_float(self.max),
            "metricsName": self.metricsName,
            "min": dump_float(self.min),
        }
        return out

class v1MetricsReport(Printable):
    """Metrics report."""

    def __init__(
        self,
        *,
        archived: bool,
        endTime: str,
        group: str,
        id: int,
        metrics: "typing.Dict[str, typing.Any]",
        totalBatches: int,
        trialId: int,
        trialRunId: int,
    ):
        self.archived = archived
        self.endTime = endTime
        self.group = group
        self.id = id
        self.metrics = metrics
        self.totalBatches = totalBatches
        self.trialId = trialId
        self.trialRunId = trialRunId

    @classmethod
    def from_json(cls, obj: Json) -> "v1MetricsReport":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "archived": obj["archived"],
            "endTime": obj["endTime"],
            "group": obj["group"],
            "id": obj["id"],
            "metrics": obj["metrics"],
            "totalBatches": obj["totalBatches"],
            "trialId": obj["trialId"],
            "trialRunId": obj["trialRunId"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "archived": self.archived,
            "endTime": self.endTime,
            "group": self.group,
            "id": self.id,
            "metrics": self.metrics,
            "totalBatches": self.totalBatches,
            "trialId": self.trialId,
            "trialRunId": self.trialRunId,
        }
        return out

class v1MetricsWorkload(Printable):
    """MetricsWorkload is a workload generating metrics."""
    endTime: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        metrics: "v1Metrics",
        numInputs: int,
        totalBatches: int,
        endTime: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.metrics = metrics
        self.numInputs = numInputs
        self.totalBatches = totalBatches
        if not isinstance(endTime, Unset):
            self.endTime = endTime

    @classmethod
    def from_json(cls, obj: Json) -> "v1MetricsWorkload":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "metrics": v1Metrics.from_json(obj["metrics"]),
            "numInputs": obj["numInputs"],
            "totalBatches": obj["totalBatches"],
        }
        if "endTime" in obj:
            kwargs["endTime"] = obj["endTime"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "metrics": self.metrics.to_json(omit_unset),
            "numInputs": self.numInputs,
            "totalBatches": self.totalBatches,
        }
        if not omit_unset or "endTime" in vars(self):
            out["endTime"] = self.endTime
        return out

class v1Model(Printable):
    """Model is a named collection of model versions."""
    description: "typing.Optional[str]" = None
    labels: "typing.Optional[typing.Sequence[str]]" = None
    notes: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        archived: bool,
        creationTime: str,
        id: int,
        lastUpdatedTime: str,
        metadata: "typing.Dict[str, typing.Any]",
        name: str,
        numVersions: int,
        userId: int,
        username: str,
        workspaceId: int,
        description: "typing.Union[str, None, Unset]" = _unset,
        labels: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
        notes: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.archived = archived
        self.creationTime = creationTime
        self.id = id
        self.lastUpdatedTime = lastUpdatedTime
        self.metadata = metadata
        self.name = name
        self.numVersions = numVersions
        self.userId = userId
        self.username = username
        self.workspaceId = workspaceId
        if not isinstance(description, Unset):
            self.description = description
        if not isinstance(labels, Unset):
            self.labels = labels
        if not isinstance(notes, Unset):
            self.notes = notes

    @classmethod
    def from_json(cls, obj: Json) -> "v1Model":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "archived": obj["archived"],
            "creationTime": obj["creationTime"],
            "id": obj["id"],
            "lastUpdatedTime": obj["lastUpdatedTime"],
            "metadata": obj["metadata"],
            "name": obj["name"],
            "numVersions": obj["numVersions"],
            "userId": obj["userId"],
            "username": obj["username"],
            "workspaceId": obj["workspaceId"],
        }
        if "description" in obj:
            kwargs["description"] = obj["description"]
        if "labels" in obj:
            kwargs["labels"] = obj["labels"]
        if "notes" in obj:
            kwargs["notes"] = obj["notes"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "archived": self.archived,
            "creationTime": self.creationTime,
            "id": self.id,
            "lastUpdatedTime": self.lastUpdatedTime,
            "metadata": self.metadata,
            "name": self.name,
            "numVersions": self.numVersions,
            "userId": self.userId,
            "username": self.username,
            "workspaceId": self.workspaceId,
        }
        if not omit_unset or "description" in vars(self):
            out["description"] = self.description
        if not omit_unset or "labels" in vars(self):
            out["labels"] = self.labels
        if not omit_unset or "notes" in vars(self):
            out["notes"] = self.notes
        return out

class v1ModelVersion(Printable):
    """A version of a model containing a checkpoint. Users can label checkpoints as
    a version of a model and use the model name and version to locate a
    checkpoint.
    """
    comment: "typing.Optional[str]" = None
    labels: "typing.Optional[typing.Sequence[str]]" = None
    metadata: "typing.Optional[typing.Dict[str, typing.Any]]" = None
    name: "typing.Optional[str]" = None
    notes: "typing.Optional[str]" = None
    userId: "typing.Optional[int]" = None
    username: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        checkpoint: "v1Checkpoint",
        creationTime: str,
        id: int,
        lastUpdatedTime: str,
        model: "v1Model",
        version: int,
        comment: "typing.Union[str, None, Unset]" = _unset,
        labels: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
        metadata: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
        name: "typing.Union[str, None, Unset]" = _unset,
        notes: "typing.Union[str, None, Unset]" = _unset,
        userId: "typing.Union[int, None, Unset]" = _unset,
        username: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.checkpoint = checkpoint
        self.creationTime = creationTime
        self.id = id
        self.lastUpdatedTime = lastUpdatedTime
        self.model = model
        self.version = version
        if not isinstance(comment, Unset):
            self.comment = comment
        if not isinstance(labels, Unset):
            self.labels = labels
        if not isinstance(metadata, Unset):
            self.metadata = metadata
        if not isinstance(name, Unset):
            self.name = name
        if not isinstance(notes, Unset):
            self.notes = notes
        if not isinstance(userId, Unset):
            self.userId = userId
        if not isinstance(username, Unset):
            self.username = username

    @classmethod
    def from_json(cls, obj: Json) -> "v1ModelVersion":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "checkpoint": v1Checkpoint.from_json(obj["checkpoint"]),
            "creationTime": obj["creationTime"],
            "id": obj["id"],
            "lastUpdatedTime": obj["lastUpdatedTime"],
            "model": v1Model.from_json(obj["model"]),
            "version": obj["version"],
        }
        if "comment" in obj:
            kwargs["comment"] = obj["comment"]
        if "labels" in obj:
            kwargs["labels"] = obj["labels"]
        if "metadata" in obj:
            kwargs["metadata"] = obj["metadata"]
        if "name" in obj:
            kwargs["name"] = obj["name"]
        if "notes" in obj:
            kwargs["notes"] = obj["notes"]
        if "userId" in obj:
            kwargs["userId"] = obj["userId"]
        if "username" in obj:
            kwargs["username"] = obj["username"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "checkpoint": self.checkpoint.to_json(omit_unset),
            "creationTime": self.creationTime,
            "id": self.id,
            "lastUpdatedTime": self.lastUpdatedTime,
            "model": self.model.to_json(omit_unset),
            "version": self.version,
        }
        if not omit_unset or "comment" in vars(self):
            out["comment"] = self.comment
        if not omit_unset or "labels" in vars(self):
            out["labels"] = self.labels
        if not omit_unset or "metadata" in vars(self):
            out["metadata"] = self.metadata
        if not omit_unset or "name" in vars(self):
            out["name"] = self.name
        if not omit_unset or "notes" in vars(self):
            out["notes"] = self.notes
        if not omit_unset or "userId" in vars(self):
            out["userId"] = self.userId
        if not omit_unset or "username" in vars(self):
            out["username"] = self.username
        return out

class v1MoveExperimentRequest(Printable):
    """Request to move an experiment into a project."""

    def __init__(
        self,
        *,
        destinationProjectId: int,
        experimentId: int,
    ):
        self.destinationProjectId = destinationProjectId
        self.experimentId = experimentId

    @classmethod
    def from_json(cls, obj: Json) -> "v1MoveExperimentRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "destinationProjectId": obj["destinationProjectId"],
            "experimentId": obj["experimentId"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "destinationProjectId": self.destinationProjectId,
            "experimentId": self.experimentId,
        }
        return out

class v1MoveExperimentsRequest(Printable):
    """Request to move an experiment into a project."""
    filters: "typing.Optional[v1BulkExperimentFilters]" = None

    def __init__(
        self,
        *,
        destinationProjectId: int,
        experimentIds: "typing.Sequence[int]",
        projectId: int,
        filters: "typing.Union[v1BulkExperimentFilters, None, Unset]" = _unset,
    ):
        self.destinationProjectId = destinationProjectId
        self.experimentIds = experimentIds
        self.projectId = projectId
        if not isinstance(filters, Unset):
            self.filters = filters

    @classmethod
    def from_json(cls, obj: Json) -> "v1MoveExperimentsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "destinationProjectId": obj["destinationProjectId"],
            "experimentIds": obj["experimentIds"],
            "projectId": obj["projectId"],
        }
        if "filters" in obj:
            kwargs["filters"] = v1BulkExperimentFilters.from_json(obj["filters"]) if obj["filters"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "destinationProjectId": self.destinationProjectId,
            "experimentIds": self.experimentIds,
            "projectId": self.projectId,
        }
        if not omit_unset or "filters" in vars(self):
            out["filters"] = None if self.filters is None else self.filters.to_json(omit_unset)
        return out

class v1MoveExperimentsResponse(Printable):
    """Response to MoveExperimentsRequest."""

    def __init__(
        self,
        *,
        results: "typing.Sequence[v1ExperimentActionResult]",
    ):
        self.results = results

    @classmethod
    def from_json(cls, obj: Json) -> "v1MoveExperimentsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "results": [v1ExperimentActionResult.from_json(x) for x in obj["results"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "results": [x.to_json(omit_unset) for x in self.results],
        }
        return out

class v1MoveModelRequest(Printable):
    """Request to move a model to a workspace."""

    def __init__(
        self,
        *,
        destinationWorkspaceId: int,
        modelName: str,
    ):
        self.destinationWorkspaceId = destinationWorkspaceId
        self.modelName = modelName

    @classmethod
    def from_json(cls, obj: Json) -> "v1MoveModelRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "destinationWorkspaceId": obj["destinationWorkspaceId"],
            "modelName": obj["modelName"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "destinationWorkspaceId": self.destinationWorkspaceId,
            "modelName": self.modelName,
        }
        return out

class v1MoveProjectRequest(Printable):
    """Request to move a project into a workspace."""

    def __init__(
        self,
        *,
        destinationWorkspaceId: int,
        projectId: int,
    ):
        self.destinationWorkspaceId = destinationWorkspaceId
        self.projectId = projectId

    @classmethod
    def from_json(cls, obj: Json) -> "v1MoveProjectRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "destinationWorkspaceId": obj["destinationWorkspaceId"],
            "projectId": obj["projectId"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "destinationWorkspaceId": self.destinationWorkspaceId,
            "projectId": self.projectId,
        }
        return out

class v1MoveRunsRequest(Printable):
    """Request to move the run to a different project."""
    filter: "typing.Optional[str]" = None
    skipMultitrial: "typing.Optional[bool]" = None

    def __init__(
        self,
        *,
        destinationProjectId: int,
        runIds: "typing.Sequence[int]",
        sourceProjectId: int,
        filter: "typing.Union[str, None, Unset]" = _unset,
        skipMultitrial: "typing.Union[bool, None, Unset]" = _unset,
    ):
        self.destinationProjectId = destinationProjectId
        self.runIds = runIds
        self.sourceProjectId = sourceProjectId
        if not isinstance(filter, Unset):
            self.filter = filter
        if not isinstance(skipMultitrial, Unset):
            self.skipMultitrial = skipMultitrial

    @classmethod
    def from_json(cls, obj: Json) -> "v1MoveRunsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "destinationProjectId": obj["destinationProjectId"],
            "runIds": obj["runIds"],
            "sourceProjectId": obj["sourceProjectId"],
        }
        if "filter" in obj:
            kwargs["filter"] = obj["filter"]
        if "skipMultitrial" in obj:
            kwargs["skipMultitrial"] = obj["skipMultitrial"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "destinationProjectId": self.destinationProjectId,
            "runIds": self.runIds,
            "sourceProjectId": self.sourceProjectId,
        }
        if not omit_unset or "filter" in vars(self):
            out["filter"] = self.filter
        if not omit_unset or "skipMultitrial" in vars(self):
            out["skipMultitrial"] = self.skipMultitrial
        return out

class v1MoveRunsResponse(Printable):
    """Response to MoveRunsRequest."""

    def __init__(
        self,
        *,
        results: "typing.Sequence[v1RunActionResult]",
    ):
        self.results = results

    @classmethod
    def from_json(cls, obj: Json) -> "v1MoveRunsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "results": [v1RunActionResult.from_json(x) for x in obj["results"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "results": [x.to_json(omit_unset) for x in self.results],
        }
        return out

class v1Note(Printable):
    """Note is a user comment connected to a project."""

    def __init__(
        self,
        *,
        contents: str,
        name: str,
    ):
        self.contents = contents
        self.name = name

    @classmethod
    def from_json(cls, obj: Json) -> "v1Note":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "contents": obj["contents"],
            "name": obj["name"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "contents": self.contents,
            "name": self.name,
        }
        return out

class v1Notebook(Printable):
    """Notebook is a Jupyter notebook in a containerized environment."""
    container: "typing.Optional[v1Container]" = None
    displayName: "typing.Optional[str]" = None
    exitStatus: "typing.Optional[str]" = None
    serviceAddress: "typing.Optional[str]" = None
    userId: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        description: str,
        id: str,
        jobId: str,
        resourcePool: str,
        startTime: str,
        state: "taskv1State",
        username: str,
        workspaceId: int,
        container: "typing.Union[v1Container, None, Unset]" = _unset,
        displayName: "typing.Union[str, None, Unset]" = _unset,
        exitStatus: "typing.Union[str, None, Unset]" = _unset,
        serviceAddress: "typing.Union[str, None, Unset]" = _unset,
        userId: "typing.Union[int, None, Unset]" = _unset,
    ):
        self.description = description
        self.id = id
        self.jobId = jobId
        self.resourcePool = resourcePool
        self.startTime = startTime
        self.state = state
        self.username = username
        self.workspaceId = workspaceId
        if not isinstance(container, Unset):
            self.container = container
        if not isinstance(displayName, Unset):
            self.displayName = displayName
        if not isinstance(exitStatus, Unset):
            self.exitStatus = exitStatus
        if not isinstance(serviceAddress, Unset):
            self.serviceAddress = serviceAddress
        if not isinstance(userId, Unset):
            self.userId = userId

    @classmethod
    def from_json(cls, obj: Json) -> "v1Notebook":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "description": obj["description"],
            "id": obj["id"],
            "jobId": obj["jobId"],
            "resourcePool": obj["resourcePool"],
            "startTime": obj["startTime"],
            "state": taskv1State(obj["state"]),
            "username": obj["username"],
            "workspaceId": obj["workspaceId"],
        }
        if "container" in obj:
            kwargs["container"] = v1Container.from_json(obj["container"]) if obj["container"] is not None else None
        if "displayName" in obj:
            kwargs["displayName"] = obj["displayName"]
        if "exitStatus" in obj:
            kwargs["exitStatus"] = obj["exitStatus"]
        if "serviceAddress" in obj:
            kwargs["serviceAddress"] = obj["serviceAddress"]
        if "userId" in obj:
            kwargs["userId"] = obj["userId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "description": self.description,
            "id": self.id,
            "jobId": self.jobId,
            "resourcePool": self.resourcePool,
            "startTime": self.startTime,
            "state": self.state.value,
            "username": self.username,
            "workspaceId": self.workspaceId,
        }
        if not omit_unset or "container" in vars(self):
            out["container"] = None if self.container is None else self.container.to_json(omit_unset)
        if not omit_unset or "displayName" in vars(self):
            out["displayName"] = self.displayName
        if not omit_unset or "exitStatus" in vars(self):
            out["exitStatus"] = self.exitStatus
        if not omit_unset or "serviceAddress" in vars(self):
            out["serviceAddress"] = self.serviceAddress
        if not omit_unset or "userId" in vars(self):
            out["userId"] = self.userId
        return out

class v1NotifyContainerRunningRequest(Printable):
    """Arguments to a notify container running."""
    nodeName: "typing.Optional[str]" = None
    numPeers: "typing.Optional[int]" = None
    rank: "typing.Optional[int]" = None
    requestUuid: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        allocationId: str,
        data: "typing.Dict[str, typing.Any]",
        nodeName: "typing.Union[str, None, Unset]" = _unset,
        numPeers: "typing.Union[int, None, Unset]" = _unset,
        rank: "typing.Union[int, None, Unset]" = _unset,
        requestUuid: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.allocationId = allocationId
        self.data = data
        if not isinstance(nodeName, Unset):
            self.nodeName = nodeName
        if not isinstance(numPeers, Unset):
            self.numPeers = numPeers
        if not isinstance(rank, Unset):
            self.rank = rank
        if not isinstance(requestUuid, Unset):
            self.requestUuid = requestUuid

    @classmethod
    def from_json(cls, obj: Json) -> "v1NotifyContainerRunningRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "allocationId": obj["allocationId"],
            "data": obj["data"],
        }
        if "nodeName" in obj:
            kwargs["nodeName"] = obj["nodeName"]
        if "numPeers" in obj:
            kwargs["numPeers"] = obj["numPeers"]
        if "rank" in obj:
            kwargs["rank"] = obj["rank"]
        if "requestUuid" in obj:
            kwargs["requestUuid"] = obj["requestUuid"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "allocationId": self.allocationId,
            "data": self.data,
        }
        if not omit_unset or "nodeName" in vars(self):
            out["nodeName"] = self.nodeName
        if not omit_unset or "numPeers" in vars(self):
            out["numPeers"] = self.numPeers
        if not omit_unset or "rank" in vars(self):
            out["rank"] = self.rank
        if not omit_unset or "requestUuid" in vars(self):
            out["requestUuid"] = self.requestUuid
        return out

class v1NotifyContainerRunningResponse(Printable):

    def __init__(
        self,
        *,
        data: "typing.Sequence[typing.Dict[str, typing.Any]]",
    ):
        self.data = data

    @classmethod
    def from_json(cls, obj: Json) -> "v1NotifyContainerRunningResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "data": obj["data"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "data": self.data,
        }
        return out

class v1OrderBy(DetEnum):
    """Order records in either ascending or descending order.
    - ORDER_BY_UNSPECIFIED: Returns records in no specific order.
    - ORDER_BY_ASC: Returns records in ascending order.
    - ORDER_BY_DESC: Returns records in descending order.
    """
    UNSPECIFIED = "ORDER_BY_UNSPECIFIED"
    ASC = "ORDER_BY_ASC"
    DESC = "ORDER_BY_DESC"

class v1OverwriteRPWorkspaceBindingsRequest(Printable):
    """Overwrite and replace the workspaces bound to an RP request."""
    workspaceIds: "typing.Optional[typing.Sequence[int]]" = None
    workspaceNames: "typing.Optional[typing.Sequence[str]]" = None

    def __init__(
        self,
        *,
        resourcePoolName: str,
        workspaceIds: "typing.Union[typing.Sequence[int], None, Unset]" = _unset,
        workspaceNames: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
    ):
        self.resourcePoolName = resourcePoolName
        if not isinstance(workspaceIds, Unset):
            self.workspaceIds = workspaceIds
        if not isinstance(workspaceNames, Unset):
            self.workspaceNames = workspaceNames

    @classmethod
    def from_json(cls, obj: Json) -> "v1OverwriteRPWorkspaceBindingsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "resourcePoolName": obj["resourcePoolName"],
        }
        if "workspaceIds" in obj:
            kwargs["workspaceIds"] = obj["workspaceIds"]
        if "workspaceNames" in obj:
            kwargs["workspaceNames"] = obj["workspaceNames"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "resourcePoolName": self.resourcePoolName,
        }
        if not omit_unset or "workspaceIds" in vars(self):
            out["workspaceIds"] = self.workspaceIds
        if not omit_unset or "workspaceNames" in vars(self):
            out["workspaceNames"] = self.workspaceNames
        return out

class v1Pagination(Printable):
    """Pagination provides information about the offset, limit, and total number of
    records returned in the results.
    """
    endIndex: "typing.Optional[int]" = None
    limit: "typing.Optional[int]" = None
    offset: "typing.Optional[int]" = None
    startIndex: "typing.Optional[int]" = None
    total: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        endIndex: "typing.Union[int, None, Unset]" = _unset,
        limit: "typing.Union[int, None, Unset]" = _unset,
        offset: "typing.Union[int, None, Unset]" = _unset,
        startIndex: "typing.Union[int, None, Unset]" = _unset,
        total: "typing.Union[int, None, Unset]" = _unset,
    ):
        if not isinstance(endIndex, Unset):
            self.endIndex = endIndex
        if not isinstance(limit, Unset):
            self.limit = limit
        if not isinstance(offset, Unset):
            self.offset = offset
        if not isinstance(startIndex, Unset):
            self.startIndex = startIndex
        if not isinstance(total, Unset):
            self.total = total

    @classmethod
    def from_json(cls, obj: Json) -> "v1Pagination":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "endIndex" in obj:
            kwargs["endIndex"] = obj["endIndex"]
        if "limit" in obj:
            kwargs["limit"] = obj["limit"]
        if "offset" in obj:
            kwargs["offset"] = obj["offset"]
        if "startIndex" in obj:
            kwargs["startIndex"] = obj["startIndex"]
        if "total" in obj:
            kwargs["total"] = obj["total"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "endIndex" in vars(self):
            out["endIndex"] = self.endIndex
        if not omit_unset or "limit" in vars(self):
            out["limit"] = self.limit
        if not omit_unset or "offset" in vars(self):
            out["offset"] = self.offset
        if not omit_unset or "startIndex" in vars(self):
            out["startIndex"] = self.startIndex
        if not omit_unset or "total" in vars(self):
            out["total"] = self.total
        return out

class v1PatchAccessTokenRequest(Printable):
    """Patch user's access token info."""
    description: "typing.Optional[str]" = None
    setRevoked: "typing.Optional[bool]" = None

    def __init__(
        self,
        *,
        tokenId: int,
        description: "typing.Union[str, None, Unset]" = _unset,
        setRevoked: "typing.Union[bool, None, Unset]" = _unset,
    ):
        self.tokenId = tokenId
        if not isinstance(description, Unset):
            self.description = description
        if not isinstance(setRevoked, Unset):
            self.setRevoked = setRevoked

    @classmethod
    def from_json(cls, obj: Json) -> "v1PatchAccessTokenRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "tokenId": obj["tokenId"],
        }
        if "description" in obj:
            kwargs["description"] = obj["description"]
        if "setRevoked" in obj:
            kwargs["setRevoked"] = obj["setRevoked"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "tokenId": self.tokenId,
        }
        if not omit_unset or "description" in vars(self):
            out["description"] = self.description
        if not omit_unset or "setRevoked" in vars(self):
            out["setRevoked"] = self.setRevoked
        return out

class v1PatchAccessTokenResponse(Printable):
    """Response to PatchAccessTokenRequest."""
    tokenInfo: "typing.Optional[v1TokenInfo]" = None

    def __init__(
        self,
        *,
        tokenInfo: "typing.Union[v1TokenInfo, None, Unset]" = _unset,
    ):
        if not isinstance(tokenInfo, Unset):
            self.tokenInfo = tokenInfo

    @classmethod
    def from_json(cls, obj: Json) -> "v1PatchAccessTokenResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "tokenInfo" in obj:
            kwargs["tokenInfo"] = v1TokenInfo.from_json(obj["tokenInfo"]) if obj["tokenInfo"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "tokenInfo" in vars(self):
            out["tokenInfo"] = None if self.tokenInfo is None else self.tokenInfo.to_json(omit_unset)
        return out

class v1PatchCheckpoint(Printable):
    """Request to change checkpoint database information."""
    resources: "typing.Optional[PatchCheckpointOptionalResources]" = None

    def __init__(
        self,
        *,
        uuid: str,
        resources: "typing.Union[PatchCheckpointOptionalResources, None, Unset]" = _unset,
    ):
        self.uuid = uuid
        if not isinstance(resources, Unset):
            self.resources = resources

    @classmethod
    def from_json(cls, obj: Json) -> "v1PatchCheckpoint":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "uuid": obj["uuid"],
        }
        if "resources" in obj:
            kwargs["resources"] = PatchCheckpointOptionalResources.from_json(obj["resources"]) if obj["resources"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "uuid": self.uuid,
        }
        if not omit_unset or "resources" in vars(self):
            out["resources"] = None if self.resources is None else self.resources.to_json(omit_unset)
        return out

class v1PatchCheckpointsRequest(Printable):
    """Request to patch database info about a checkpoint."""

    def __init__(
        self,
        *,
        checkpoints: "typing.Sequence[v1PatchCheckpoint]",
    ):
        self.checkpoints = checkpoints

    @classmethod
    def from_json(cls, obj: Json) -> "v1PatchCheckpointsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "checkpoints": [v1PatchCheckpoint.from_json(x) for x in obj["checkpoints"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "checkpoints": [x.to_json(omit_unset) for x in self.checkpoints],
        }
        return out

class v1PatchExperiment(Printable):
    """PatchExperiment is a partial update to an experiment with only id required."""
    checkpointStorage: "typing.Optional[PatchExperimentPatchCheckpointStorage]" = None
    description: "typing.Optional[str]" = None
    labels: "typing.Optional[typing.Sequence[str]]" = None
    name: "typing.Optional[str]" = None
    notes: "typing.Optional[str]" = None
    resources: "typing.Optional[PatchExperimentPatchResources]" = None

    def __init__(
        self,
        *,
        id: int,
        checkpointStorage: "typing.Union[PatchExperimentPatchCheckpointStorage, None, Unset]" = _unset,
        description: "typing.Union[str, None, Unset]" = _unset,
        labels: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
        name: "typing.Union[str, None, Unset]" = _unset,
        notes: "typing.Union[str, None, Unset]" = _unset,
        resources: "typing.Union[PatchExperimentPatchResources, None, Unset]" = _unset,
    ):
        self.id = id
        if not isinstance(checkpointStorage, Unset):
            self.checkpointStorage = checkpointStorage
        if not isinstance(description, Unset):
            self.description = description
        if not isinstance(labels, Unset):
            self.labels = labels
        if not isinstance(name, Unset):
            self.name = name
        if not isinstance(notes, Unset):
            self.notes = notes
        if not isinstance(resources, Unset):
            self.resources = resources

    @classmethod
    def from_json(cls, obj: Json) -> "v1PatchExperiment":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "id": obj["id"],
        }
        if "checkpointStorage" in obj:
            kwargs["checkpointStorage"] = PatchExperimentPatchCheckpointStorage.from_json(obj["checkpointStorage"]) if obj["checkpointStorage"] is not None else None
        if "description" in obj:
            kwargs["description"] = obj["description"]
        if "labels" in obj:
            kwargs["labels"] = obj["labels"]
        if "name" in obj:
            kwargs["name"] = obj["name"]
        if "notes" in obj:
            kwargs["notes"] = obj["notes"]
        if "resources" in obj:
            kwargs["resources"] = PatchExperimentPatchResources.from_json(obj["resources"]) if obj["resources"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "id": self.id,
        }
        if not omit_unset or "checkpointStorage" in vars(self):
            out["checkpointStorage"] = None if self.checkpointStorage is None else self.checkpointStorage.to_json(omit_unset)
        if not omit_unset or "description" in vars(self):
            out["description"] = self.description
        if not omit_unset or "labels" in vars(self):
            out["labels"] = self.labels
        if not omit_unset or "name" in vars(self):
            out["name"] = self.name
        if not omit_unset or "notes" in vars(self):
            out["notes"] = self.notes
        if not omit_unset or "resources" in vars(self):
            out["resources"] = None if self.resources is None else self.resources.to_json(omit_unset)
        return out

class v1PatchExperimentResponse(Printable):
    """Response to PatchExperimentRequest."""
    experiment: "typing.Optional[v1Experiment]" = None

    def __init__(
        self,
        *,
        experiment: "typing.Union[v1Experiment, None, Unset]" = _unset,
    ):
        if not isinstance(experiment, Unset):
            self.experiment = experiment

    @classmethod
    def from_json(cls, obj: Json) -> "v1PatchExperimentResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "experiment" in obj:
            kwargs["experiment"] = v1Experiment.from_json(obj["experiment"]) if obj["experiment"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "experiment" in vars(self):
            out["experiment"] = None if self.experiment is None else self.experiment.to_json(omit_unset)
        return out

class v1PatchMasterConfigRequest(Printable):
    """Patch master config."""
    config: "typing.Optional[v1Config]" = None
    fieldMask: "typing.Optional[protobufFieldMask]" = None

    def __init__(
        self,
        *,
        config: "typing.Union[v1Config, None, Unset]" = _unset,
        fieldMask: "typing.Union[protobufFieldMask, None, Unset]" = _unset,
    ):
        if not isinstance(config, Unset):
            self.config = config
        if not isinstance(fieldMask, Unset):
            self.fieldMask = fieldMask

    @classmethod
    def from_json(cls, obj: Json) -> "v1PatchMasterConfigRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "config" in obj:
            kwargs["config"] = v1Config.from_json(obj["config"]) if obj["config"] is not None else None
        if "fieldMask" in obj:
            kwargs["fieldMask"] = protobufFieldMask.from_json(obj["fieldMask"]) if obj["fieldMask"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "config" in vars(self):
            out["config"] = None if self.config is None else self.config.to_json(omit_unset)
        if not omit_unset or "fieldMask" in vars(self):
            out["fieldMask"] = None if self.fieldMask is None else self.fieldMask.to_json(omit_unset)
        return out

class v1PatchModel(Printable):
    """PatchModel is a partial update to a model with only name required."""
    description: "typing.Optional[str]" = None
    labels: "typing.Optional[typing.Sequence[str]]" = None
    metadata: "typing.Optional[typing.Dict[str, typing.Any]]" = None
    name: "typing.Optional[str]" = None
    notes: "typing.Optional[str]" = None
    workspaceId: "typing.Optional[int]" = None
    workspaceName: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        description: "typing.Union[str, None, Unset]" = _unset,
        labels: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
        metadata: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
        name: "typing.Union[str, None, Unset]" = _unset,
        notes: "typing.Union[str, None, Unset]" = _unset,
        workspaceId: "typing.Union[int, None, Unset]" = _unset,
        workspaceName: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(description, Unset):
            self.description = description
        if not isinstance(labels, Unset):
            self.labels = labels
        if not isinstance(metadata, Unset):
            self.metadata = metadata
        if not isinstance(name, Unset):
            self.name = name
        if not isinstance(notes, Unset):
            self.notes = notes
        if not isinstance(workspaceId, Unset):
            self.workspaceId = workspaceId
        if not isinstance(workspaceName, Unset):
            self.workspaceName = workspaceName

    @classmethod
    def from_json(cls, obj: Json) -> "v1PatchModel":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "description" in obj:
            kwargs["description"] = obj["description"]
        if "labels" in obj:
            kwargs["labels"] = obj["labels"]
        if "metadata" in obj:
            kwargs["metadata"] = obj["metadata"]
        if "name" in obj:
            kwargs["name"] = obj["name"]
        if "notes" in obj:
            kwargs["notes"] = obj["notes"]
        if "workspaceId" in obj:
            kwargs["workspaceId"] = obj["workspaceId"]
        if "workspaceName" in obj:
            kwargs["workspaceName"] = obj["workspaceName"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "description" in vars(self):
            out["description"] = self.description
        if not omit_unset or "labels" in vars(self):
            out["labels"] = self.labels
        if not omit_unset or "metadata" in vars(self):
            out["metadata"] = self.metadata
        if not omit_unset or "name" in vars(self):
            out["name"] = self.name
        if not omit_unset or "notes" in vars(self):
            out["notes"] = self.notes
        if not omit_unset or "workspaceId" in vars(self):
            out["workspaceId"] = self.workspaceId
        if not omit_unset or "workspaceName" in vars(self):
            out["workspaceName"] = self.workspaceName
        return out

class v1PatchModelResponse(Printable):
    """Response to PatchModelRequest."""

    def __init__(
        self,
        *,
        model: "v1Model",
    ):
        self.model = model

    @classmethod
    def from_json(cls, obj: Json) -> "v1PatchModelResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "model": v1Model.from_json(obj["model"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "model": self.model.to_json(omit_unset),
        }
        return out

class v1PatchModelVersion(Printable):
    checkpoint: "typing.Optional[v1Checkpoint]" = None
    comment: "typing.Optional[str]" = None
    labels: "typing.Optional[typing.Sequence[str]]" = None
    metadata: "typing.Optional[typing.Dict[str, typing.Any]]" = None
    name: "typing.Optional[str]" = None
    notes: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        checkpoint: "typing.Union[v1Checkpoint, None, Unset]" = _unset,
        comment: "typing.Union[str, None, Unset]" = _unset,
        labels: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
        metadata: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
        name: "typing.Union[str, None, Unset]" = _unset,
        notes: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(checkpoint, Unset):
            self.checkpoint = checkpoint
        if not isinstance(comment, Unset):
            self.comment = comment
        if not isinstance(labels, Unset):
            self.labels = labels
        if not isinstance(metadata, Unset):
            self.metadata = metadata
        if not isinstance(name, Unset):
            self.name = name
        if not isinstance(notes, Unset):
            self.notes = notes

    @classmethod
    def from_json(cls, obj: Json) -> "v1PatchModelVersion":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "checkpoint" in obj:
            kwargs["checkpoint"] = v1Checkpoint.from_json(obj["checkpoint"]) if obj["checkpoint"] is not None else None
        if "comment" in obj:
            kwargs["comment"] = obj["comment"]
        if "labels" in obj:
            kwargs["labels"] = obj["labels"]
        if "metadata" in obj:
            kwargs["metadata"] = obj["metadata"]
        if "name" in obj:
            kwargs["name"] = obj["name"]
        if "notes" in obj:
            kwargs["notes"] = obj["notes"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "checkpoint" in vars(self):
            out["checkpoint"] = None if self.checkpoint is None else self.checkpoint.to_json(omit_unset)
        if not omit_unset or "comment" in vars(self):
            out["comment"] = self.comment
        if not omit_unset or "labels" in vars(self):
            out["labels"] = self.labels
        if not omit_unset or "metadata" in vars(self):
            out["metadata"] = self.metadata
        if not omit_unset or "name" in vars(self):
            out["name"] = self.name
        if not omit_unset or "notes" in vars(self):
            out["notes"] = self.notes
        return out

class v1PatchModelVersionResponse(Printable):
    """Response to PatchModelVersionRequest."""

    def __init__(
        self,
        *,
        modelVersion: "v1ModelVersion",
    ):
        self.modelVersion = modelVersion

    @classmethod
    def from_json(cls, obj: Json) -> "v1PatchModelVersionResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "modelVersion": v1ModelVersion.from_json(obj["modelVersion"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "modelVersion": self.modelVersion.to_json(omit_unset),
        }
        return out

class v1PatchProject(Printable):
    """PatchProject is a partial update to a project with all optional fields."""
    description: "typing.Optional[str]" = None
    key: "typing.Optional[str]" = None
    name: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        description: "typing.Union[str, None, Unset]" = _unset,
        key: "typing.Union[str, None, Unset]" = _unset,
        name: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(description, Unset):
            self.description = description
        if not isinstance(key, Unset):
            self.key = key
        if not isinstance(name, Unset):
            self.name = name

    @classmethod
    def from_json(cls, obj: Json) -> "v1PatchProject":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "description" in obj:
            kwargs["description"] = obj["description"]
        if "key" in obj:
            kwargs["key"] = obj["key"]
        if "name" in obj:
            kwargs["name"] = obj["name"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "description" in vars(self):
            out["description"] = self.description
        if not omit_unset or "key" in vars(self):
            out["key"] = self.key
        if not omit_unset or "name" in vars(self):
            out["name"] = self.name
        return out

class v1PatchProjectResponse(Printable):
    """Response to PatchProjectRequest."""

    def __init__(
        self,
        *,
        project: "v1Project",
    ):
        self.project = project

    @classmethod
    def from_json(cls, obj: Json) -> "v1PatchProjectResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "project": v1Project.from_json(obj["project"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "project": self.project.to_json(omit_unset),
        }
        return out

class v1PatchTemplateConfigResponse(Printable):
    """Response to PatchTemplateConfigRequest."""

    def __init__(
        self,
        *,
        template: "v1Template",
    ):
        self.template = template

    @classmethod
    def from_json(cls, obj: Json) -> "v1PatchTemplateConfigResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "template": v1Template.from_json(obj["template"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "template": self.template.to_json(omit_unset),
        }
        return out

class v1PatchTemplateNameRequest(Printable):

    def __init__(
        self,
        *,
        newName: str,
        oldName: str,
    ):
        self.newName = newName
        self.oldName = oldName

    @classmethod
    def from_json(cls, obj: Json) -> "v1PatchTemplateNameRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "newName": obj["newName"],
            "oldName": obj["oldName"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "newName": self.newName,
            "oldName": self.oldName,
        }
        return out

class v1PatchTemplateNameResponse(Printable):

    def __init__(
        self,
        *,
        template: "v1Template",
    ):
        self.template = template

    @classmethod
    def from_json(cls, obj: Json) -> "v1PatchTemplateNameResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "template": v1Template.from_json(obj["template"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "template": self.template.to_json(omit_unset),
        }
        return out

class v1PatchTrialRequest(Printable):
    """Patch a trial."""
    state: "typing.Optional[trialv1State]" = None

    def __init__(
        self,
        *,
        trialId: int,
        state: "typing.Union[trialv1State, None, Unset]" = _unset,
    ):
        self.trialId = trialId
        if not isinstance(state, Unset):
            self.state = state

    @classmethod
    def from_json(cls, obj: Json) -> "v1PatchTrialRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "trialId": obj["trialId"],
        }
        if "state" in obj:
            kwargs["state"] = trialv1State(obj["state"]) if obj["state"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "trialId": self.trialId,
        }
        if not omit_unset or "state" in vars(self):
            out["state"] = None if self.state is None else self.state.value
        return out

class v1PatchTrialResponse(Printable):
    """Response to PatchTrialRequest."""

    def __init__(
        self,
        *,
        trial: "trialv1Trial",
    ):
        self.trial = trial

    @classmethod
    def from_json(cls, obj: Json) -> "v1PatchTrialResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "trial": trialv1Trial.from_json(obj["trial"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "trial": self.trial.to_json(omit_unset),
        }
        return out

class v1PatchUser(Printable):
    """Request to edit fields for a user."""
    active: "typing.Optional[bool]" = None
    admin: "typing.Optional[bool]" = None
    agentUserGroup: "typing.Optional[v1AgentUserGroup]" = None
    displayName: "typing.Optional[str]" = None
    isHashed: "typing.Optional[bool]" = None
    password: "typing.Optional[str]" = None
    remote: "typing.Optional[bool]" = None
    username: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        active: "typing.Union[bool, None, Unset]" = _unset,
        admin: "typing.Union[bool, None, Unset]" = _unset,
        agentUserGroup: "typing.Union[v1AgentUserGroup, None, Unset]" = _unset,
        displayName: "typing.Union[str, None, Unset]" = _unset,
        isHashed: "typing.Union[bool, None, Unset]" = _unset,
        password: "typing.Union[str, None, Unset]" = _unset,
        remote: "typing.Union[bool, None, Unset]" = _unset,
        username: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(active, Unset):
            self.active = active
        if not isinstance(admin, Unset):
            self.admin = admin
        if not isinstance(agentUserGroup, Unset):
            self.agentUserGroup = agentUserGroup
        if not isinstance(displayName, Unset):
            self.displayName = displayName
        if not isinstance(isHashed, Unset):
            self.isHashed = isHashed
        if not isinstance(password, Unset):
            self.password = password
        if not isinstance(remote, Unset):
            self.remote = remote
        if not isinstance(username, Unset):
            self.username = username

    @classmethod
    def from_json(cls, obj: Json) -> "v1PatchUser":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "active" in obj:
            kwargs["active"] = obj["active"]
        if "admin" in obj:
            kwargs["admin"] = obj["admin"]
        if "agentUserGroup" in obj:
            kwargs["agentUserGroup"] = v1AgentUserGroup.from_json(obj["agentUserGroup"]) if obj["agentUserGroup"] is not None else None
        if "displayName" in obj:
            kwargs["displayName"] = obj["displayName"]
        if "isHashed" in obj:
            kwargs["isHashed"] = obj["isHashed"]
        if "password" in obj:
            kwargs["password"] = obj["password"]
        if "remote" in obj:
            kwargs["remote"] = obj["remote"]
        if "username" in obj:
            kwargs["username"] = obj["username"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "active" in vars(self):
            out["active"] = self.active
        if not omit_unset or "admin" in vars(self):
            out["admin"] = self.admin
        if not omit_unset or "agentUserGroup" in vars(self):
            out["agentUserGroup"] = None if self.agentUserGroup is None else self.agentUserGroup.to_json(omit_unset)
        if not omit_unset or "displayName" in vars(self):
            out["displayName"] = self.displayName
        if not omit_unset or "isHashed" in vars(self):
            out["isHashed"] = self.isHashed
        if not omit_unset or "password" in vars(self):
            out["password"] = self.password
        if not omit_unset or "remote" in vars(self):
            out["remote"] = self.remote
        if not omit_unset or "username" in vars(self):
            out["username"] = self.username
        return out

class v1PatchUserResponse(Printable):
    """Response to PatchUserRequest."""

    def __init__(
        self,
        *,
        user: "v1User",
    ):
        self.user = user

    @classmethod
    def from_json(cls, obj: Json) -> "v1PatchUserResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "user": v1User.from_json(obj["user"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "user": self.user.to_json(omit_unset),
        }
        return out

class v1PatchUsersRequest(Printable):
    """Update activation status for multiple users."""
    filters: "typing.Optional[v1UserFilters]" = None

    def __init__(
        self,
        *,
        activate: bool,
        userIds: "typing.Sequence[int]",
        filters: "typing.Union[v1UserFilters, None, Unset]" = _unset,
    ):
        self.activate = activate
        self.userIds = userIds
        if not isinstance(filters, Unset):
            self.filters = filters

    @classmethod
    def from_json(cls, obj: Json) -> "v1PatchUsersRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "activate": obj["activate"],
            "userIds": obj["userIds"],
        }
        if "filters" in obj:
            kwargs["filters"] = v1UserFilters.from_json(obj["filters"]) if obj["filters"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "activate": self.activate,
            "userIds": self.userIds,
        }
        if not omit_unset or "filters" in vars(self):
            out["filters"] = None if self.filters is None else self.filters.to_json(omit_unset)
        return out

class v1PatchUsersResponse(Printable):
    """Response to PatchUsersRequest."""

    def __init__(
        self,
        *,
        results: "typing.Sequence[v1UserActionResult]",
    ):
        self.results = results

    @classmethod
    def from_json(cls, obj: Json) -> "v1PatchUsersResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "results": [v1UserActionResult.from_json(x) for x in obj["results"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "results": [x.to_json(omit_unset) for x in self.results],
        }
        return out

class v1PatchWebhook(Printable):

    def __init__(
        self,
        *,
        url: str,
    ):
        self.url = url

    @classmethod
    def from_json(cls, obj: Json) -> "v1PatchWebhook":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "url": obj["url"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "url": self.url,
        }
        return out

class v1PatchWorkspace(Printable):
    """PatchWorkspace is a partial update to a workspace with all optional fields."""
    agentUserGroup: "typing.Optional[v1AgentUserGroup]" = None
    checkpointStorageConfig: "typing.Optional[typing.Dict[str, typing.Any]]" = None
    clusterNamespaceMeta: "typing.Optional[typing.Dict[str, v1WorkspaceNamespaceMeta]]" = None
    defaultAuxPool: "typing.Optional[str]" = None
    defaultAuxResourcePool: "typing.Optional[str]" = None
    defaultComputePool: "typing.Optional[str]" = None
    defaultComputeResourcePool: "typing.Optional[str]" = None
    name: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        agentUserGroup: "typing.Union[v1AgentUserGroup, None, Unset]" = _unset,
        checkpointStorageConfig: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
        clusterNamespaceMeta: "typing.Union[typing.Dict[str, v1WorkspaceNamespaceMeta], None, Unset]" = _unset,
        defaultAuxPool: "typing.Union[str, None, Unset]" = _unset,
        defaultAuxResourcePool: "typing.Union[str, None, Unset]" = _unset,
        defaultComputePool: "typing.Union[str, None, Unset]" = _unset,
        defaultComputeResourcePool: "typing.Union[str, None, Unset]" = _unset,
        name: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(agentUserGroup, Unset):
            self.agentUserGroup = agentUserGroup
        if not isinstance(checkpointStorageConfig, Unset):
            self.checkpointStorageConfig = checkpointStorageConfig
        if not isinstance(clusterNamespaceMeta, Unset):
            self.clusterNamespaceMeta = clusterNamespaceMeta
        if not isinstance(defaultAuxPool, Unset):
            self.defaultAuxPool = defaultAuxPool
        if not isinstance(defaultAuxResourcePool, Unset):
            self.defaultAuxResourcePool = defaultAuxResourcePool
        if not isinstance(defaultComputePool, Unset):
            self.defaultComputePool = defaultComputePool
        if not isinstance(defaultComputeResourcePool, Unset):
            self.defaultComputeResourcePool = defaultComputeResourcePool
        if not isinstance(name, Unset):
            self.name = name

    @classmethod
    def from_json(cls, obj: Json) -> "v1PatchWorkspace":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "agentUserGroup" in obj:
            kwargs["agentUserGroup"] = v1AgentUserGroup.from_json(obj["agentUserGroup"]) if obj["agentUserGroup"] is not None else None
        if "checkpointStorageConfig" in obj:
            kwargs["checkpointStorageConfig"] = obj["checkpointStorageConfig"]
        if "clusterNamespaceMeta" in obj:
            kwargs["clusterNamespaceMeta"] = {k: v1WorkspaceNamespaceMeta.from_json(v) for k, v in obj["clusterNamespaceMeta"].items()} if obj["clusterNamespaceMeta"] is not None else None
        if "defaultAuxPool" in obj:
            kwargs["defaultAuxPool"] = obj["defaultAuxPool"]
        if "defaultAuxResourcePool" in obj:
            kwargs["defaultAuxResourcePool"] = obj["defaultAuxResourcePool"]
        if "defaultComputePool" in obj:
            kwargs["defaultComputePool"] = obj["defaultComputePool"]
        if "defaultComputeResourcePool" in obj:
            kwargs["defaultComputeResourcePool"] = obj["defaultComputeResourcePool"]
        if "name" in obj:
            kwargs["name"] = obj["name"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "agentUserGroup" in vars(self):
            out["agentUserGroup"] = None if self.agentUserGroup is None else self.agentUserGroup.to_json(omit_unset)
        if not omit_unset or "checkpointStorageConfig" in vars(self):
            out["checkpointStorageConfig"] = self.checkpointStorageConfig
        if not omit_unset or "clusterNamespaceMeta" in vars(self):
            out["clusterNamespaceMeta"] = None if self.clusterNamespaceMeta is None else {k: v.to_json(omit_unset) for k, v in self.clusterNamespaceMeta.items()}
        if not omit_unset or "defaultAuxPool" in vars(self):
            out["defaultAuxPool"] = self.defaultAuxPool
        if not omit_unset or "defaultAuxResourcePool" in vars(self):
            out["defaultAuxResourcePool"] = self.defaultAuxResourcePool
        if not omit_unset or "defaultComputePool" in vars(self):
            out["defaultComputePool"] = self.defaultComputePool
        if not omit_unset or "defaultComputeResourcePool" in vars(self):
            out["defaultComputeResourcePool"] = self.defaultComputeResourcePool
        if not omit_unset or "name" in vars(self):
            out["name"] = self.name
        return out

class v1PatchWorkspaceResponse(Printable):
    """Response to PatchWorkspaceRequest."""
    namespaceBindings: "typing.Optional[typing.Dict[str, v1WorkspaceNamespaceBinding]]" = None

    def __init__(
        self,
        *,
        workspace: "v1Workspace",
        namespaceBindings: "typing.Union[typing.Dict[str, v1WorkspaceNamespaceBinding], None, Unset]" = _unset,
    ):
        self.workspace = workspace
        if not isinstance(namespaceBindings, Unset):
            self.namespaceBindings = namespaceBindings

    @classmethod
    def from_json(cls, obj: Json) -> "v1PatchWorkspaceResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "workspace": v1Workspace.from_json(obj["workspace"]),
        }
        if "namespaceBindings" in obj:
            kwargs["namespaceBindings"] = {k: v1WorkspaceNamespaceBinding.from_json(v) for k, v in obj["namespaceBindings"].items()} if obj["namespaceBindings"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "workspace": self.workspace.to_json(omit_unset),
        }
        if not omit_unset or "namespaceBindings" in vars(self):
            out["namespaceBindings"] = None if self.namespaceBindings is None else {k: v.to_json(omit_unset) for k, v in self.namespaceBindings.items()}
        return out

class v1PauseExperimentsRequest(Printable):
    """Pause multiple experiments."""
    filters: "typing.Optional[v1BulkExperimentFilters]" = None

    def __init__(
        self,
        *,
        experimentIds: "typing.Sequence[int]",
        projectId: int,
        filters: "typing.Union[v1BulkExperimentFilters, None, Unset]" = _unset,
    ):
        self.experimentIds = experimentIds
        self.projectId = projectId
        if not isinstance(filters, Unset):
            self.filters = filters

    @classmethod
    def from_json(cls, obj: Json) -> "v1PauseExperimentsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "experimentIds": obj["experimentIds"],
            "projectId": obj["projectId"],
        }
        if "filters" in obj:
            kwargs["filters"] = v1BulkExperimentFilters.from_json(obj["filters"]) if obj["filters"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "experimentIds": self.experimentIds,
            "projectId": self.projectId,
        }
        if not omit_unset or "filters" in vars(self):
            out["filters"] = None if self.filters is None else self.filters.to_json(omit_unset)
        return out

class v1PauseExperimentsResponse(Printable):
    """Response to PauseExperimentsRequest."""

    def __init__(
        self,
        *,
        results: "typing.Sequence[v1ExperimentActionResult]",
    ):
        self.results = results

    @classmethod
    def from_json(cls, obj: Json) -> "v1PauseExperimentsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "results": [v1ExperimentActionResult.from_json(x) for x in obj["results"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "results": [x.to_json(omit_unset) for x in self.results],
        }
        return out

class v1PauseRunsRequest(Printable):
    """Request to pause the experiment associated witha run."""
    filter: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        projectId: int,
        runIds: "typing.Sequence[int]",
        filter: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.projectId = projectId
        self.runIds = runIds
        if not isinstance(filter, Unset):
            self.filter = filter

    @classmethod
    def from_json(cls, obj: Json) -> "v1PauseRunsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "projectId": obj["projectId"],
            "runIds": obj["runIds"],
        }
        if "filter" in obj:
            kwargs["filter"] = obj["filter"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "projectId": self.projectId,
            "runIds": self.runIds,
        }
        if not omit_unset or "filter" in vars(self):
            out["filter"] = self.filter
        return out

class v1PauseRunsResponse(Printable):
    """Response to PauseRunsRequest."""

    def __init__(
        self,
        *,
        results: "typing.Sequence[v1RunActionResult]",
    ):
        self.results = results

    @classmethod
    def from_json(cls, obj: Json) -> "v1PauseRunsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "results": [v1RunActionResult.from_json(x) for x in obj["results"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "results": [x.to_json(omit_unset) for x in self.results],
        }
        return out

class v1Permission(Printable):
    name: "typing.Optional[str]" = None
    scopeTypeMask: "typing.Optional[v1ScopeTypeMask]" = None

    def __init__(
        self,
        *,
        id: "v1PermissionType",
        name: "typing.Union[str, None, Unset]" = _unset,
        scopeTypeMask: "typing.Union[v1ScopeTypeMask, None, Unset]" = _unset,
    ):
        self.id = id
        if not isinstance(name, Unset):
            self.name = name
        if not isinstance(scopeTypeMask, Unset):
            self.scopeTypeMask = scopeTypeMask

    @classmethod
    def from_json(cls, obj: Json) -> "v1Permission":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "id": v1PermissionType(obj["id"]),
        }
        if "name" in obj:
            kwargs["name"] = obj["name"]
        if "scopeTypeMask" in obj:
            kwargs["scopeTypeMask"] = v1ScopeTypeMask.from_json(obj["scopeTypeMask"]) if obj["scopeTypeMask"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "id": self.id.value,
        }
        if not omit_unset or "name" in vars(self):
            out["name"] = self.name
        if not omit_unset or "scopeTypeMask" in vars(self):
            out["scopeTypeMask"] = None if self.scopeTypeMask is None else self.scopeTypeMask.to_json(omit_unset)
        return out

class v1PermissionType(DetEnum):
    """List of permissions types.
    Value of the enum has 9xxxx for global only permissions.
    Permissions on the same object share the thousands place
    value like 2001 and 2002.
    - PERMISSION_TYPE_UNSPECIFIED: The permission type is unknown.
    - PERMISSION_TYPE_ADMINISTRATE_USER: Can create and update other users.
    Allows updating other users passwords making this
    permission give all other permissions effectively.
    - PERMISSION_TYPE_ADMINISTRATE_OAUTH: Ability to manage OAuth clients and settings.
    - PERMISSION_TYPE_CREATE_EXPERIMENT: Ability to create experiments.
    - PERMISSION_TYPE_VIEW_EXPERIMENT_ARTIFACTS: Ability to view experiment's model code, checkpoints, trials.
    - PERMISSION_TYPE_VIEW_EXPERIMENT_METADATA: Ability to view experiment's metadata such as experiment config, progress.
    - PERMISSION_TYPE_UPDATE_EXPERIMENT: Ability to update experiment and experiment's lifecycle.
    - PERMISSION_TYPE_UPDATE_EXPERIMENT_METADATA: Ability to update experiment's metadata.
    - PERMISSION_TYPE_DELETE_EXPERIMENT: Ability to delete experiment.
    - PERMISSION_TYPE_CREATE_NSC: Ability to create Notebooks, Shells, and Commands.
    - PERMISSION_TYPE_VIEW_NSC: Ability to view Notebooks, Shells, and Commands.
    - PERMISSION_TYPE_UPDATE_NSC: Ability to terminate Notebooks, Shells, and Commands.
    - PERMISSION_TYPE_UPDATE_GROUP: Ability to create, update, and add / remove users from groups.
    - PERMISSION_TYPE_CREATE_WORKSPACE: Ability to create workspaces.
    - PERMISSION_TYPE_VIEW_WORKSPACE: Ability to view workspace.
    - PERMISSION_TYPE_UPDATE_WORKSPACE: Ability to update workspace.
    - PERMISSION_TYPE_DELETE_WORKSPACE: Ability to delete workspace.
    - PERMISSION_TYPE_SET_WORKSPACE_AGENT_USER_GROUP: Ability to set workspace agent user group config.
    - PERMISSION_TYPE_SET_WORKSPACE_CHECKPOINT_STORAGE_CONFIG: Ability to set workspace checkpoint storage config.
    - PERMISSION_TYPE_SET_WORKSPACE_DEFAULT_RESOURCE_POOL: Ability to set workspace default resource pool.
    - PERMISSION_TYPE_CREATE_PROJECT: Ability to create projects.
    - PERMISSION_TYPE_VIEW_PROJECT: Ability to view projects.
    - PERMISSION_TYPE_UPDATE_PROJECT: Ability to update projects.
    - PERMISSION_TYPE_DELETE_PROJECT: Ability to delete projects.
    - PERMISSION_TYPE_ASSIGN_ROLES: Ability to assign roles to groups / users.
    If assigned at a workspace scope, can only assign roles to that workspace
    scope.
    - PERMISSION_TYPE_VIEW_MODEL_REGISTRY: Ability to view model registry.
    - PERMISSION_TYPE_EDIT_MODEL_REGISTRY: Ability to edit model registry.
    - PERMISSION_TYPE_CREATE_MODEL_REGISTRY: Ability to create model registry.
    - PERMISSION_TYPE_DELETE_MODEL_REGISTRY: Ability to delete model registry.
    - PERMISSION_TYPE_DELETE_MODEL_VERSION: Ability to delete model version.
    - PERMISSION_TYPE_DELETE_OTHER_USER_MODEL_REGISTRY: Ability to delete another user's model registry.
    - PERMISSION_TYPE_DELETE_OTHER_USER_MODEL_VERSION: Ability to delete another user's model version.
    - PERMISSION_TYPE_VIEW_MASTER_LOGS: Ability to view master logs.
    - PERMISSION_TYPE_VIEW_CLUSTER_USAGE: Ability to view detailed cluster usage info.
    - PERMISSION_TYPE_UPDATE_AGENTS: Ability to update agents.
    - PERMISSION_TYPE_VIEW_SENSITIVE_AGENT_INFO: Ability to view sensitive subset of agent info.
    - PERMISSION_TYPE_VIEW_MASTER_CONFIG: Ability to view master configs.
    - PERMISSION_TYPE_UPDATE_MASTER_CONFIG: Ability to update master configs.
    - PERMISSION_TYPE_VIEW_EXTERNAL_JOBS: Ability to view external jobs.
    - PERMISSION_TYPE_CONTROL_STRICT_JOB_QUEUE: Ability to control strict job queue.
    - PERMISSION_TYPE_VIEW_TEMPLATES: Ability to view templates.
    - PERMISSION_TYPE_UPDATE_TEMPLATES: Ability to update templates.
    - PERMISSION_TYPE_CREATE_TEMPLATES: Ability to create templates.
    - PERMISSION_TYPE_DELETE_TEMPLATES: Ability to delete templates.
    - PERMISSION_TYPE_UPDATE_ROLES: Ability to create and update role definitions.
    - PERMISSION_TYPE_EDIT_WEBHOOKS: Ability to create and delete webhooks.
    - PERMISSION_TYPE_VIEW_WEBHOOKS: Ability to view webhooks.
    - PERMISSION_TYPE_MODIFY_RP_WORKSPACE_BINDINGS: Ability to bind, unbind or overwrite resource pool workspace bindings.
    - PERMISSION_TYPE_SET_WORKSPACE_NAMESPACE_BINDINGS: Ability to bind, unbind, or overwrite namespace workspace bindings.
    - PERMISSION_TYPE_SET_RESOURCE_QUOTAS: Ability to set resource quotas on workspaces.
    - PERMISSION_TYPE_VIEW_RESOURCE_QUOTAS: Ability to view resource quotas on workspaces.
    - PERMISSION_TYPE_MODIFY_GLOBAL_CONFIG_POLICIES: Ability to modify global config policies.
    - PERMISSION_TYPE_MODIFY_WORKSPACE_CONFIG_POLICIES: Ability to modify workspace config policies.
    - PERMISSION_TYPE_VIEW_GLOBAL_CONFIG_POLICIES: Ability to view global config policies.
    - PERMISSION_TYPE_VIEW_WORKSPACE_CONFIG_POLICIES: Ability to view workspace config policies.
    - PERMISSION_TYPE_ADMINISTRATE_TOKEN: Ability to administrate other users' tokens.
    - PERMISSION_TYPE_UPDATE_TOKEN: Ability to update one's own token.
    - PERMISSION_TYPE_CREATE_TOKEN: Ability to create one's own token
    - PERMISSION_TYPE_CREATE_OTHER_TOKEN: Ability to create another user's token
    - PERMISSION_TYPE_VIEW_OTHER_TOKEN: Ability to view another user's token
    - PERMISSION_TYPE_VIEW_TOKEN: Ability to view one's own token
    """
    UNSPECIFIED = "PERMISSION_TYPE_UNSPECIFIED"
    ADMINISTRATE_USER = "PERMISSION_TYPE_ADMINISTRATE_USER"
    ADMINISTRATE_OAUTH = "PERMISSION_TYPE_ADMINISTRATE_OAUTH"
    CREATE_EXPERIMENT = "PERMISSION_TYPE_CREATE_EXPERIMENT"
    VIEW_EXPERIMENT_ARTIFACTS = "PERMISSION_TYPE_VIEW_EXPERIMENT_ARTIFACTS"
    VIEW_EXPERIMENT_METADATA = "PERMISSION_TYPE_VIEW_EXPERIMENT_METADATA"
    UPDATE_EXPERIMENT = "PERMISSION_TYPE_UPDATE_EXPERIMENT"
    UPDATE_EXPERIMENT_METADATA = "PERMISSION_TYPE_UPDATE_EXPERIMENT_METADATA"
    DELETE_EXPERIMENT = "PERMISSION_TYPE_DELETE_EXPERIMENT"
    CREATE_NSC = "PERMISSION_TYPE_CREATE_NSC"
    VIEW_NSC = "PERMISSION_TYPE_VIEW_NSC"
    UPDATE_NSC = "PERMISSION_TYPE_UPDATE_NSC"
    UPDATE_GROUP = "PERMISSION_TYPE_UPDATE_GROUP"
    CREATE_WORKSPACE = "PERMISSION_TYPE_CREATE_WORKSPACE"
    VIEW_WORKSPACE = "PERMISSION_TYPE_VIEW_WORKSPACE"
    UPDATE_WORKSPACE = "PERMISSION_TYPE_UPDATE_WORKSPACE"
    DELETE_WORKSPACE = "PERMISSION_TYPE_DELETE_WORKSPACE"
    SET_WORKSPACE_AGENT_USER_GROUP = "PERMISSION_TYPE_SET_WORKSPACE_AGENT_USER_GROUP"
    SET_WORKSPACE_CHECKPOINT_STORAGE_CONFIG = "PERMISSION_TYPE_SET_WORKSPACE_CHECKPOINT_STORAGE_CONFIG"
    SET_WORKSPACE_DEFAULT_RESOURCE_POOL = "PERMISSION_TYPE_SET_WORKSPACE_DEFAULT_RESOURCE_POOL"
    CREATE_PROJECT = "PERMISSION_TYPE_CREATE_PROJECT"
    VIEW_PROJECT = "PERMISSION_TYPE_VIEW_PROJECT"
    UPDATE_PROJECT = "PERMISSION_TYPE_UPDATE_PROJECT"
    DELETE_PROJECT = "PERMISSION_TYPE_DELETE_PROJECT"
    ASSIGN_ROLES = "PERMISSION_TYPE_ASSIGN_ROLES"
    VIEW_MODEL_REGISTRY = "PERMISSION_TYPE_VIEW_MODEL_REGISTRY"
    EDIT_MODEL_REGISTRY = "PERMISSION_TYPE_EDIT_MODEL_REGISTRY"
    CREATE_MODEL_REGISTRY = "PERMISSION_TYPE_CREATE_MODEL_REGISTRY"
    DELETE_MODEL_REGISTRY = "PERMISSION_TYPE_DELETE_MODEL_REGISTRY"
    DELETE_MODEL_VERSION = "PERMISSION_TYPE_DELETE_MODEL_VERSION"
    DELETE_OTHER_USER_MODEL_REGISTRY = "PERMISSION_TYPE_DELETE_OTHER_USER_MODEL_REGISTRY"
    DELETE_OTHER_USER_MODEL_VERSION = "PERMISSION_TYPE_DELETE_OTHER_USER_MODEL_VERSION"
    VIEW_MASTER_LOGS = "PERMISSION_TYPE_VIEW_MASTER_LOGS"
    VIEW_CLUSTER_USAGE = "PERMISSION_TYPE_VIEW_CLUSTER_USAGE"
    UPDATE_AGENTS = "PERMISSION_TYPE_UPDATE_AGENTS"
    VIEW_SENSITIVE_AGENT_INFO = "PERMISSION_TYPE_VIEW_SENSITIVE_AGENT_INFO"
    VIEW_MASTER_CONFIG = "PERMISSION_TYPE_VIEW_MASTER_CONFIG"
    UPDATE_MASTER_CONFIG = "PERMISSION_TYPE_UPDATE_MASTER_CONFIG"
    VIEW_EXTERNAL_JOBS = "PERMISSION_TYPE_VIEW_EXTERNAL_JOBS"
    CONTROL_STRICT_JOB_QUEUE = "PERMISSION_TYPE_CONTROL_STRICT_JOB_QUEUE"
    VIEW_TEMPLATES = "PERMISSION_TYPE_VIEW_TEMPLATES"
    UPDATE_TEMPLATES = "PERMISSION_TYPE_UPDATE_TEMPLATES"
    CREATE_TEMPLATES = "PERMISSION_TYPE_CREATE_TEMPLATES"
    DELETE_TEMPLATES = "PERMISSION_TYPE_DELETE_TEMPLATES"
    UPDATE_ROLES = "PERMISSION_TYPE_UPDATE_ROLES"
    EDIT_WEBHOOKS = "PERMISSION_TYPE_EDIT_WEBHOOKS"
    VIEW_WEBHOOKS = "PERMISSION_TYPE_VIEW_WEBHOOKS"
    MODIFY_RP_WORKSPACE_BINDINGS = "PERMISSION_TYPE_MODIFY_RP_WORKSPACE_BINDINGS"
    SET_WORKSPACE_NAMESPACE_BINDINGS = "PERMISSION_TYPE_SET_WORKSPACE_NAMESPACE_BINDINGS"
    SET_RESOURCE_QUOTAS = "PERMISSION_TYPE_SET_RESOURCE_QUOTAS"
    VIEW_RESOURCE_QUOTAS = "PERMISSION_TYPE_VIEW_RESOURCE_QUOTAS"
    MODIFY_GLOBAL_CONFIG_POLICIES = "PERMISSION_TYPE_MODIFY_GLOBAL_CONFIG_POLICIES"
    MODIFY_WORKSPACE_CONFIG_POLICIES = "PERMISSION_TYPE_MODIFY_WORKSPACE_CONFIG_POLICIES"
    VIEW_GLOBAL_CONFIG_POLICIES = "PERMISSION_TYPE_VIEW_GLOBAL_CONFIG_POLICIES"
    VIEW_WORKSPACE_CONFIG_POLICIES = "PERMISSION_TYPE_VIEW_WORKSPACE_CONFIG_POLICIES"
    ADMINISTRATE_TOKEN = "PERMISSION_TYPE_ADMINISTRATE_TOKEN"
    UPDATE_TOKEN = "PERMISSION_TYPE_UPDATE_TOKEN"
    CREATE_TOKEN = "PERMISSION_TYPE_CREATE_TOKEN"
    CREATE_OTHER_TOKEN = "PERMISSION_TYPE_CREATE_OTHER_TOKEN"
    VIEW_OTHER_TOKEN = "PERMISSION_TYPE_VIEW_OTHER_TOKEN"
    VIEW_TOKEN = "PERMISSION_TYPE_VIEW_TOKEN"

class v1PolymorphicFilter(Printable):
    doubleRange: "typing.Optional[v1DoubleFieldFilter]" = None
    integerRange: "typing.Optional[v1Int32FieldFilter]" = None
    name: "typing.Optional[str]" = None
    timeRange: "typing.Optional[v1TimestampFieldFilter]" = None

    def __init__(
        self,
        *,
        doubleRange: "typing.Union[v1DoubleFieldFilter, None, Unset]" = _unset,
        integerRange: "typing.Union[v1Int32FieldFilter, None, Unset]" = _unset,
        name: "typing.Union[str, None, Unset]" = _unset,
        timeRange: "typing.Union[v1TimestampFieldFilter, None, Unset]" = _unset,
    ):
        if not isinstance(doubleRange, Unset):
            self.doubleRange = doubleRange
        if not isinstance(integerRange, Unset):
            self.integerRange = integerRange
        if not isinstance(name, Unset):
            self.name = name
        if not isinstance(timeRange, Unset):
            self.timeRange = timeRange

    @classmethod
    def from_json(cls, obj: Json) -> "v1PolymorphicFilter":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "doubleRange" in obj:
            kwargs["doubleRange"] = v1DoubleFieldFilter.from_json(obj["doubleRange"]) if obj["doubleRange"] is not None else None
        if "integerRange" in obj:
            kwargs["integerRange"] = v1Int32FieldFilter.from_json(obj["integerRange"]) if obj["integerRange"] is not None else None
        if "name" in obj:
            kwargs["name"] = obj["name"]
        if "timeRange" in obj:
            kwargs["timeRange"] = v1TimestampFieldFilter.from_json(obj["timeRange"]) if obj["timeRange"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "doubleRange" in vars(self):
            out["doubleRange"] = None if self.doubleRange is None else self.doubleRange.to_json(omit_unset)
        if not omit_unset or "integerRange" in vars(self):
            out["integerRange"] = None if self.integerRange is None else self.integerRange.to_json(omit_unset)
        if not omit_unset or "name" in vars(self):
            out["name"] = self.name
        if not omit_unset or "timeRange" in vars(self):
            out["timeRange"] = None if self.timeRange is None else self.timeRange.to_json(omit_unset)
        return out

class v1PostAccessTokenRequest(Printable):
    """Create the requested user's accessToken."""
    description: "typing.Optional[str]" = None
    lifespan: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        userId: int,
        description: "typing.Union[str, None, Unset]" = _unset,
        lifespan: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.userId = userId
        if not isinstance(description, Unset):
            self.description = description
        if not isinstance(lifespan, Unset):
            self.lifespan = lifespan

    @classmethod
    def from_json(cls, obj: Json) -> "v1PostAccessTokenRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "userId": obj["userId"],
        }
        if "description" in obj:
            kwargs["description"] = obj["description"]
        if "lifespan" in obj:
            kwargs["lifespan"] = obj["lifespan"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "userId": self.userId,
        }
        if not omit_unset or "description" in vars(self):
            out["description"] = self.description
        if not omit_unset or "lifespan" in vars(self):
            out["lifespan"] = self.lifespan
        return out

class v1PostAccessTokenResponse(Printable):
    """Response to PostAccessTokenRequest."""
    token: "typing.Optional[str]" = None
    tokenId: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        token: "typing.Union[str, None, Unset]" = _unset,
        tokenId: "typing.Union[int, None, Unset]" = _unset,
    ):
        if not isinstance(token, Unset):
            self.token = token
        if not isinstance(tokenId, Unset):
            self.tokenId = tokenId

    @classmethod
    def from_json(cls, obj: Json) -> "v1PostAccessTokenResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "token" in obj:
            kwargs["token"] = obj["token"]
        if "tokenId" in obj:
            kwargs["tokenId"] = obj["tokenId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "token" in vars(self):
            out["token"] = self.token
        if not omit_unset or "tokenId" in vars(self):
            out["tokenId"] = self.tokenId
        return out

class v1PostAllocationAcceleratorDataRequest(Printable):
    """Set the accelerator data for some allocation."""

    def __init__(
        self,
        *,
        acceleratorData: "v1AcceleratorData",
        allocationId: str,
    ):
        self.acceleratorData = acceleratorData
        self.allocationId = allocationId

    @classmethod
    def from_json(cls, obj: Json) -> "v1PostAllocationAcceleratorDataRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "acceleratorData": v1AcceleratorData.from_json(obj["acceleratorData"]),
            "allocationId": obj["allocationId"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "acceleratorData": self.acceleratorData.to_json(omit_unset),
            "allocationId": self.allocationId,
        }
        return out

class v1PostAllocationProxyAddressRequest(Printable):
    """Set the proxy address for some allocation."""
    allocationId: "typing.Optional[str]" = None
    proxyAddress: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        allocationId: "typing.Union[str, None, Unset]" = _unset,
        proxyAddress: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(allocationId, Unset):
            self.allocationId = allocationId
        if not isinstance(proxyAddress, Unset):
            self.proxyAddress = proxyAddress

    @classmethod
    def from_json(cls, obj: Json) -> "v1PostAllocationProxyAddressRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "allocationId" in obj:
            kwargs["allocationId"] = obj["allocationId"]
        if "proxyAddress" in obj:
            kwargs["proxyAddress"] = obj["proxyAddress"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "allocationId" in vars(self):
            out["allocationId"] = self.allocationId
        if not omit_unset or "proxyAddress" in vars(self):
            out["proxyAddress"] = self.proxyAddress
        return out

class v1PostCheckpointMetadataRequest(Printable):
    """Request for updating a checkpoints metadata."""
    checkpoint: "typing.Optional[v1Checkpoint]" = None

    def __init__(
        self,
        *,
        checkpoint: "typing.Union[v1Checkpoint, None, Unset]" = _unset,
    ):
        if not isinstance(checkpoint, Unset):
            self.checkpoint = checkpoint

    @classmethod
    def from_json(cls, obj: Json) -> "v1PostCheckpointMetadataRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "checkpoint" in obj:
            kwargs["checkpoint"] = v1Checkpoint.from_json(obj["checkpoint"]) if obj["checkpoint"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "checkpoint" in vars(self):
            out["checkpoint"] = None if self.checkpoint is None else self.checkpoint.to_json(omit_unset)
        return out

class v1PostCheckpointMetadataResponse(Printable):
    """Response to PostCheckpointRequest."""
    checkpoint: "typing.Optional[v1Checkpoint]" = None

    def __init__(
        self,
        *,
        checkpoint: "typing.Union[v1Checkpoint, None, Unset]" = _unset,
    ):
        if not isinstance(checkpoint, Unset):
            self.checkpoint = checkpoint

    @classmethod
    def from_json(cls, obj: Json) -> "v1PostCheckpointMetadataResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "checkpoint" in obj:
            kwargs["checkpoint"] = v1Checkpoint.from_json(obj["checkpoint"]) if obj["checkpoint"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "checkpoint" in vars(self):
            out["checkpoint"] = None if self.checkpoint is None else self.checkpoint.to_json(omit_unset)
        return out

class v1PostModelRequest(Printable):
    """Request for creating a model in the registry."""
    description: "typing.Optional[str]" = None
    labels: "typing.Optional[typing.Sequence[str]]" = None
    metadata: "typing.Optional[typing.Dict[str, typing.Any]]" = None
    notes: "typing.Optional[str]" = None
    workspaceId: "typing.Optional[int]" = None
    workspaceName: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        name: str,
        description: "typing.Union[str, None, Unset]" = _unset,
        labels: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
        metadata: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
        notes: "typing.Union[str, None, Unset]" = _unset,
        workspaceId: "typing.Union[int, None, Unset]" = _unset,
        workspaceName: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.name = name
        if not isinstance(description, Unset):
            self.description = description
        if not isinstance(labels, Unset):
            self.labels = labels
        if not isinstance(metadata, Unset):
            self.metadata = metadata
        if not isinstance(notes, Unset):
            self.notes = notes
        if not isinstance(workspaceId, Unset):
            self.workspaceId = workspaceId
        if not isinstance(workspaceName, Unset):
            self.workspaceName = workspaceName

    @classmethod
    def from_json(cls, obj: Json) -> "v1PostModelRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "name": obj["name"],
        }
        if "description" in obj:
            kwargs["description"] = obj["description"]
        if "labels" in obj:
            kwargs["labels"] = obj["labels"]
        if "metadata" in obj:
            kwargs["metadata"] = obj["metadata"]
        if "notes" in obj:
            kwargs["notes"] = obj["notes"]
        if "workspaceId" in obj:
            kwargs["workspaceId"] = obj["workspaceId"]
        if "workspaceName" in obj:
            kwargs["workspaceName"] = obj["workspaceName"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "name": self.name,
        }
        if not omit_unset or "description" in vars(self):
            out["description"] = self.description
        if not omit_unset or "labels" in vars(self):
            out["labels"] = self.labels
        if not omit_unset or "metadata" in vars(self):
            out["metadata"] = self.metadata
        if not omit_unset or "notes" in vars(self):
            out["notes"] = self.notes
        if not omit_unset or "workspaceId" in vars(self):
            out["workspaceId"] = self.workspaceId
        if not omit_unset or "workspaceName" in vars(self):
            out["workspaceName"] = self.workspaceName
        return out

class v1PostModelResponse(Printable):
    """Response to PostModelRequest."""

    def __init__(
        self,
        *,
        model: "v1Model",
    ):
        self.model = model

    @classmethod
    def from_json(cls, obj: Json) -> "v1PostModelResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "model": v1Model.from_json(obj["model"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "model": self.model.to_json(omit_unset),
        }
        return out

class v1PostModelVersionRequest(Printable):
    """Request for creating a model version."""
    comment: "typing.Optional[str]" = None
    labels: "typing.Optional[typing.Sequence[str]]" = None
    metadata: "typing.Optional[typing.Dict[str, typing.Any]]" = None
    name: "typing.Optional[str]" = None
    notes: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        checkpointUuid: str,
        modelName: str,
        comment: "typing.Union[str, None, Unset]" = _unset,
        labels: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
        metadata: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
        name: "typing.Union[str, None, Unset]" = _unset,
        notes: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.checkpointUuid = checkpointUuid
        self.modelName = modelName
        if not isinstance(comment, Unset):
            self.comment = comment
        if not isinstance(labels, Unset):
            self.labels = labels
        if not isinstance(metadata, Unset):
            self.metadata = metadata
        if not isinstance(name, Unset):
            self.name = name
        if not isinstance(notes, Unset):
            self.notes = notes

    @classmethod
    def from_json(cls, obj: Json) -> "v1PostModelVersionRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "checkpointUuid": obj["checkpointUuid"],
            "modelName": obj["modelName"],
        }
        if "comment" in obj:
            kwargs["comment"] = obj["comment"]
        if "labels" in obj:
            kwargs["labels"] = obj["labels"]
        if "metadata" in obj:
            kwargs["metadata"] = obj["metadata"]
        if "name" in obj:
            kwargs["name"] = obj["name"]
        if "notes" in obj:
            kwargs["notes"] = obj["notes"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "checkpointUuid": self.checkpointUuid,
            "modelName": self.modelName,
        }
        if not omit_unset or "comment" in vars(self):
            out["comment"] = self.comment
        if not omit_unset or "labels" in vars(self):
            out["labels"] = self.labels
        if not omit_unset or "metadata" in vars(self):
            out["metadata"] = self.metadata
        if not omit_unset or "name" in vars(self):
            out["name"] = self.name
        if not omit_unset or "notes" in vars(self):
            out["notes"] = self.notes
        return out

class v1PostModelVersionResponse(Printable):
    """Response for PostModelVersionRequest."""

    def __init__(
        self,
        *,
        modelVersion: "v1ModelVersion",
    ):
        self.modelVersion = modelVersion

    @classmethod
    def from_json(cls, obj: Json) -> "v1PostModelVersionResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "modelVersion": v1ModelVersion.from_json(obj["modelVersion"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "modelVersion": self.modelVersion.to_json(omit_unset),
        }
        return out

class v1PostProjectRequest(Printable):
    """Request for creating a project."""
    description: "typing.Optional[str]" = None
    key: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        name: str,
        workspaceId: int,
        description: "typing.Union[str, None, Unset]" = _unset,
        key: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.name = name
        self.workspaceId = workspaceId
        if not isinstance(description, Unset):
            self.description = description
        if not isinstance(key, Unset):
            self.key = key

    @classmethod
    def from_json(cls, obj: Json) -> "v1PostProjectRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "name": obj["name"],
            "workspaceId": obj["workspaceId"],
        }
        if "description" in obj:
            kwargs["description"] = obj["description"]
        if "key" in obj:
            kwargs["key"] = obj["key"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "name": self.name,
            "workspaceId": self.workspaceId,
        }
        if not omit_unset or "description" in vars(self):
            out["description"] = self.description
        if not omit_unset or "key" in vars(self):
            out["key"] = self.key
        return out

class v1PostProjectResponse(Printable):
    """Response to PostProjectRequest."""

    def __init__(
        self,
        *,
        project: "v1Project",
    ):
        self.project = project

    @classmethod
    def from_json(cls, obj: Json) -> "v1PostProjectResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "project": v1Project.from_json(obj["project"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "project": self.project.to_json(omit_unset),
        }
        return out

class v1PostRunMetadataRequest(Printable):
    """Request to post metadata for a run."""
    runId: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        metadata: "typing.Dict[str, typing.Any]",
        runId: "typing.Union[int, None, Unset]" = _unset,
    ):
        self.metadata = metadata
        if not isinstance(runId, Unset):
            self.runId = runId

    @classmethod
    def from_json(cls, obj: Json) -> "v1PostRunMetadataRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "metadata": obj["metadata"],
        }
        if "runId" in obj:
            kwargs["runId"] = obj["runId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "metadata": self.metadata,
        }
        if not omit_unset or "runId" in vars(self):
            out["runId"] = self.runId
        return out

class v1PostRunMetadataResponse(Printable):
    """Response to post metadata for a run."""
    metadata: "typing.Optional[typing.Dict[str, typing.Any]]" = None

    def __init__(
        self,
        *,
        metadata: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
    ):
        if not isinstance(metadata, Unset):
            self.metadata = metadata

    @classmethod
    def from_json(cls, obj: Json) -> "v1PostRunMetadataResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "metadata" in obj:
            kwargs["metadata"] = obj["metadata"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "metadata" in vars(self):
            out["metadata"] = self.metadata
        return out

class v1PostTaskLogsRequest(Printable):
    """Request to PostTaskLogs."""

    def __init__(
        self,
        *,
        logs: "typing.Sequence[v1TaskLog]",
    ):
        self.logs = logs

    @classmethod
    def from_json(cls, obj: Json) -> "v1PostTaskLogsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "logs": [v1TaskLog.from_json(x) for x in obj["logs"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "logs": [x.to_json(omit_unset) for x in self.logs],
        }
        return out

class v1PostTemplateResponse(Printable):
    """Response to PostTemplateRequest."""

    def __init__(
        self,
        *,
        template: "v1Template",
    ):
        self.template = template

    @classmethod
    def from_json(cls, obj: Json) -> "v1PostTemplateResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "template": v1Template.from_json(obj["template"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "template": self.template.to_json(omit_unset),
        }
        return out

class v1PostTrialProfilerMetricsBatchRequest(Printable):
    """Create a batch of trial profiler metrics."""
    batches: "typing.Optional[typing.Sequence[v1TrialProfilerMetricsBatch]]" = None

    def __init__(
        self,
        *,
        batches: "typing.Union[typing.Sequence[v1TrialProfilerMetricsBatch], None, Unset]" = _unset,
    ):
        if not isinstance(batches, Unset):
            self.batches = batches

    @classmethod
    def from_json(cls, obj: Json) -> "v1PostTrialProfilerMetricsBatchRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "batches" in obj:
            kwargs["batches"] = [v1TrialProfilerMetricsBatch.from_json(x) for x in obj["batches"]] if obj["batches"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "batches" in vars(self):
            out["batches"] = None if self.batches is None else [x.to_json(omit_unset) for x in self.batches]
        return out

class v1PostUserActivityRequest(Printable):
    """Update user activity."""

    def __init__(
        self,
        *,
        activityType: "v1ActivityType",
        entityId: int,
        entityType: "v1EntityType",
    ):
        self.activityType = activityType
        self.entityId = entityId
        self.entityType = entityType

    @classmethod
    def from_json(cls, obj: Json) -> "v1PostUserActivityRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "activityType": v1ActivityType(obj["activityType"]),
            "entityId": obj["entityId"],
            "entityType": v1EntityType(obj["entityType"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "activityType": self.activityType.value,
            "entityId": self.entityId,
            "entityType": self.entityType.value,
        }
        return out

class v1PostUserRequest(Printable):
    """Create a new user."""
    isHashed: "typing.Optional[bool]" = None
    password: "typing.Optional[str]" = None
    user: "typing.Optional[v1User]" = None

    def __init__(
        self,
        *,
        isHashed: "typing.Union[bool, None, Unset]" = _unset,
        password: "typing.Union[str, None, Unset]" = _unset,
        user: "typing.Union[v1User, None, Unset]" = _unset,
    ):
        if not isinstance(isHashed, Unset):
            self.isHashed = isHashed
        if not isinstance(password, Unset):
            self.password = password
        if not isinstance(user, Unset):
            self.user = user

    @classmethod
    def from_json(cls, obj: Json) -> "v1PostUserRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "isHashed" in obj:
            kwargs["isHashed"] = obj["isHashed"]
        if "password" in obj:
            kwargs["password"] = obj["password"]
        if "user" in obj:
            kwargs["user"] = v1User.from_json(obj["user"]) if obj["user"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "isHashed" in vars(self):
            out["isHashed"] = self.isHashed
        if not omit_unset or "password" in vars(self):
            out["password"] = self.password
        if not omit_unset or "user" in vars(self):
            out["user"] = None if self.user is None else self.user.to_json(omit_unset)
        return out

class v1PostUserResponse(Printable):
    """Response to PostUserRequest."""
    user: "typing.Optional[v1User]" = None

    def __init__(
        self,
        *,
        user: "typing.Union[v1User, None, Unset]" = _unset,
    ):
        if not isinstance(user, Unset):
            self.user = user

    @classmethod
    def from_json(cls, obj: Json) -> "v1PostUserResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "user" in obj:
            kwargs["user"] = v1User.from_json(obj["user"]) if obj["user"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "user" in vars(self):
            out["user"] = None if self.user is None else self.user.to_json(omit_unset)
        return out

class v1PostUserSettingRequest(Printable):
    """Update user settings."""

    def __init__(
        self,
        *,
        settings: "typing.Sequence[v1UserWebSetting]",
    ):
        self.settings = settings

    @classmethod
    def from_json(cls, obj: Json) -> "v1PostUserSettingRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "settings": [v1UserWebSetting.from_json(x) for x in obj["settings"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "settings": [x.to_json(omit_unset) for x in self.settings],
        }
        return out

class v1PostWebhookEventDataRequest(Printable):
    """Request for triggering custom trigger."""
    trialId: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        data: "v1CustomWebhookEventData",
        experimentId: int,
        trialId: "typing.Union[int, None, Unset]" = _unset,
    ):
        self.data = data
        self.experimentId = experimentId
        if not isinstance(trialId, Unset):
            self.trialId = trialId

    @classmethod
    def from_json(cls, obj: Json) -> "v1PostWebhookEventDataRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "data": v1CustomWebhookEventData.from_json(obj["data"]),
            "experimentId": obj["experimentId"],
        }
        if "trialId" in obj:
            kwargs["trialId"] = obj["trialId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "data": self.data.to_json(omit_unset),
            "experimentId": self.experimentId,
        }
        if not omit_unset or "trialId" in vars(self):
            out["trialId"] = self.trialId
        return out

class v1PostWebhookResponse(Printable):
    """Response to PostWebhookRequest."""

    def __init__(
        self,
        *,
        webhook: "v1Webhook",
    ):
        self.webhook = webhook

    @classmethod
    def from_json(cls, obj: Json) -> "v1PostWebhookResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "webhook": v1Webhook.from_json(obj["webhook"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "webhook": self.webhook.to_json(omit_unset),
        }
        return out

class v1PostWorkspaceRequest(Printable):
    """Request for creating a workspace."""
    agentUserGroup: "typing.Optional[v1AgentUserGroup]" = None
    checkpointStorageConfig: "typing.Optional[typing.Dict[str, typing.Any]]" = None
    clusterNamespaceMeta: "typing.Optional[typing.Dict[str, v1WorkspaceNamespaceMeta]]" = None
    clusterQuotaPairs: "typing.Optional[typing.Dict[str, int]]" = None
    defaultAuxPool: "typing.Optional[str]" = None
    defaultComputePool: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        name: str,
        agentUserGroup: "typing.Union[v1AgentUserGroup, None, Unset]" = _unset,
        checkpointStorageConfig: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
        clusterNamespaceMeta: "typing.Union[typing.Dict[str, v1WorkspaceNamespaceMeta], None, Unset]" = _unset,
        clusterQuotaPairs: "typing.Union[typing.Dict[str, int], None, Unset]" = _unset,
        defaultAuxPool: "typing.Union[str, None, Unset]" = _unset,
        defaultComputePool: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.name = name
        if not isinstance(agentUserGroup, Unset):
            self.agentUserGroup = agentUserGroup
        if not isinstance(checkpointStorageConfig, Unset):
            self.checkpointStorageConfig = checkpointStorageConfig
        if not isinstance(clusterNamespaceMeta, Unset):
            self.clusterNamespaceMeta = clusterNamespaceMeta
        if not isinstance(clusterQuotaPairs, Unset):
            self.clusterQuotaPairs = clusterQuotaPairs
        if not isinstance(defaultAuxPool, Unset):
            self.defaultAuxPool = defaultAuxPool
        if not isinstance(defaultComputePool, Unset):
            self.defaultComputePool = defaultComputePool

    @classmethod
    def from_json(cls, obj: Json) -> "v1PostWorkspaceRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "name": obj["name"],
        }
        if "agentUserGroup" in obj:
            kwargs["agentUserGroup"] = v1AgentUserGroup.from_json(obj["agentUserGroup"]) if obj["agentUserGroup"] is not None else None
        if "checkpointStorageConfig" in obj:
            kwargs["checkpointStorageConfig"] = obj["checkpointStorageConfig"]
        if "clusterNamespaceMeta" in obj:
            kwargs["clusterNamespaceMeta"] = {k: v1WorkspaceNamespaceMeta.from_json(v) for k, v in obj["clusterNamespaceMeta"].items()} if obj["clusterNamespaceMeta"] is not None else None
        if "clusterQuotaPairs" in obj:
            kwargs["clusterQuotaPairs"] = obj["clusterQuotaPairs"]
        if "defaultAuxPool" in obj:
            kwargs["defaultAuxPool"] = obj["defaultAuxPool"]
        if "defaultComputePool" in obj:
            kwargs["defaultComputePool"] = obj["defaultComputePool"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "name": self.name,
        }
        if not omit_unset or "agentUserGroup" in vars(self):
            out["agentUserGroup"] = None if self.agentUserGroup is None else self.agentUserGroup.to_json(omit_unset)
        if not omit_unset or "checkpointStorageConfig" in vars(self):
            out["checkpointStorageConfig"] = self.checkpointStorageConfig
        if not omit_unset or "clusterNamespaceMeta" in vars(self):
            out["clusterNamespaceMeta"] = None if self.clusterNamespaceMeta is None else {k: v.to_json(omit_unset) for k, v in self.clusterNamespaceMeta.items()}
        if not omit_unset or "clusterQuotaPairs" in vars(self):
            out["clusterQuotaPairs"] = self.clusterQuotaPairs
        if not omit_unset or "defaultAuxPool" in vars(self):
            out["defaultAuxPool"] = self.defaultAuxPool
        if not omit_unset or "defaultComputePool" in vars(self):
            out["defaultComputePool"] = self.defaultComputePool
        return out

class v1PostWorkspaceResponse(Printable):
    """Response to PostWorkspaceRequest."""
    namespaceBindings: "typing.Optional[typing.Dict[str, v1WorkspaceNamespaceBinding]]" = None

    def __init__(
        self,
        *,
        workspace: "v1Workspace",
        namespaceBindings: "typing.Union[typing.Dict[str, v1WorkspaceNamespaceBinding], None, Unset]" = _unset,
    ):
        self.workspace = workspace
        if not isinstance(namespaceBindings, Unset):
            self.namespaceBindings = namespaceBindings

    @classmethod
    def from_json(cls, obj: Json) -> "v1PostWorkspaceResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "workspace": v1Workspace.from_json(obj["workspace"]),
        }
        if "namespaceBindings" in obj:
            kwargs["namespaceBindings"] = {k: v1WorkspaceNamespaceBinding.from_json(v) for k, v in obj["namespaceBindings"].items()} if obj["namespaceBindings"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "workspace": self.workspace.to_json(omit_unset),
        }
        if not omit_unset or "namespaceBindings" in vars(self):
            out["namespaceBindings"] = None if self.namespaceBindings is None else {k: v.to_json(omit_unset) for k, v in self.namespaceBindings.items()}
        return out

class v1PreviewHPSearchRequest(Printable):
    """Preview hyperparameter search."""
    config: "typing.Optional[typing.Dict[str, typing.Any]]" = None
    seed: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        config: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
        seed: "typing.Union[int, None, Unset]" = _unset,
    ):
        if not isinstance(config, Unset):
            self.config = config
        if not isinstance(seed, Unset):
            self.seed = seed

    @classmethod
    def from_json(cls, obj: Json) -> "v1PreviewHPSearchRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "config" in obj:
            kwargs["config"] = obj["config"]
        if "seed" in obj:
            kwargs["seed"] = obj["seed"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "config" in vars(self):
            out["config"] = self.config
        if not omit_unset or "seed" in vars(self):
            out["seed"] = self.seed
        return out

class v1PreviewHPSearchResponse(Printable):
    """Response to PreviewSearchRequest."""
    summary: "typing.Optional[v1SearchSummary]" = None

    def __init__(
        self,
        *,
        summary: "typing.Union[v1SearchSummary, None, Unset]" = _unset,
    ):
        if not isinstance(summary, Unset):
            self.summary = summary

    @classmethod
    def from_json(cls, obj: Json) -> "v1PreviewHPSearchResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "summary" in obj:
            kwargs["summary"] = v1SearchSummary.from_json(obj["summary"]) if obj["summary"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "summary" in vars(self):
            out["summary"] = None if self.summary is None else self.summary.to_json(omit_unset)
        return out

class v1Project(Printable):
    """Project is a named collection of experiments."""
    description: "typing.Optional[str]" = None
    lastExperimentStartedAt: "typing.Optional[str]" = None
    workspaceName: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        archived: bool,
        errorMessage: str,
        id: int,
        immutable: bool,
        key: str,
        name: str,
        notes: "typing.Sequence[v1Note]",
        numActiveExperiments: int,
        numExperiments: int,
        numRuns: int,
        state: "v1WorkspaceState",
        userId: int,
        username: str,
        workspaceId: int,
        description: "typing.Union[str, None, Unset]" = _unset,
        lastExperimentStartedAt: "typing.Union[str, None, Unset]" = _unset,
        workspaceName: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.archived = archived
        self.errorMessage = errorMessage
        self.id = id
        self.immutable = immutable
        self.key = key
        self.name = name
        self.notes = notes
        self.numActiveExperiments = numActiveExperiments
        self.numExperiments = numExperiments
        self.numRuns = numRuns
        self.state = state
        self.userId = userId
        self.username = username
        self.workspaceId = workspaceId
        if not isinstance(description, Unset):
            self.description = description
        if not isinstance(lastExperimentStartedAt, Unset):
            self.lastExperimentStartedAt = lastExperimentStartedAt
        if not isinstance(workspaceName, Unset):
            self.workspaceName = workspaceName

    @classmethod
    def from_json(cls, obj: Json) -> "v1Project":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "archived": obj["archived"],
            "errorMessage": obj["errorMessage"],
            "id": obj["id"],
            "immutable": obj["immutable"],
            "key": obj["key"],
            "name": obj["name"],
            "notes": [v1Note.from_json(x) for x in obj["notes"]],
            "numActiveExperiments": obj["numActiveExperiments"],
            "numExperiments": obj["numExperiments"],
            "numRuns": obj["numRuns"],
            "state": v1WorkspaceState(obj["state"]),
            "userId": obj["userId"],
            "username": obj["username"],
            "workspaceId": obj["workspaceId"],
        }
        if "description" in obj:
            kwargs["description"] = obj["description"]
        if "lastExperimentStartedAt" in obj:
            kwargs["lastExperimentStartedAt"] = obj["lastExperimentStartedAt"]
        if "workspaceName" in obj:
            kwargs["workspaceName"] = obj["workspaceName"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "archived": self.archived,
            "errorMessage": self.errorMessage,
            "id": self.id,
            "immutable": self.immutable,
            "key": self.key,
            "name": self.name,
            "notes": [x.to_json(omit_unset) for x in self.notes],
            "numActiveExperiments": self.numActiveExperiments,
            "numExperiments": self.numExperiments,
            "numRuns": self.numRuns,
            "state": self.state.value,
            "userId": self.userId,
            "username": self.username,
            "workspaceId": self.workspaceId,
        }
        if not omit_unset or "description" in vars(self):
            out["description"] = self.description
        if not omit_unset or "lastExperimentStartedAt" in vars(self):
            out["lastExperimentStartedAt"] = self.lastExperimentStartedAt
        if not omit_unset or "workspaceName" in vars(self):
            out["workspaceName"] = self.workspaceName
        return out

class v1ProjectColumn(Printable):
    """Project Column is a description of a column used on experiments in the
    project.
    """
    displayName: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        column: str,
        location: "v1LocationType",
        type: "v1ColumnType",
        displayName: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.column = column
        self.location = location
        self.type = type
        if not isinstance(displayName, Unset):
            self.displayName = displayName

    @classmethod
    def from_json(cls, obj: Json) -> "v1ProjectColumn":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "column": obj["column"],
            "location": v1LocationType(obj["location"]),
            "type": v1ColumnType(obj["type"]),
        }
        if "displayName" in obj:
            kwargs["displayName"] = obj["displayName"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "column": self.column,
            "location": self.location.value,
            "type": self.type.value,
        }
        if not omit_unset or "displayName" in vars(self):
            out["displayName"] = self.displayName
        return out

class v1ProxyPortConfig(Printable):
    """ProxyPortConfig configures a proxy the allocation should start."""
    port: "typing.Optional[int]" = None
    proxyTcp: "typing.Optional[bool]" = None
    serviceId: "typing.Optional[str]" = None
    unauthenticated: "typing.Optional[bool]" = None

    def __init__(
        self,
        *,
        port: "typing.Union[int, None, Unset]" = _unset,
        proxyTcp: "typing.Union[bool, None, Unset]" = _unset,
        serviceId: "typing.Union[str, None, Unset]" = _unset,
        unauthenticated: "typing.Union[bool, None, Unset]" = _unset,
    ):
        if not isinstance(port, Unset):
            self.port = port
        if not isinstance(proxyTcp, Unset):
            self.proxyTcp = proxyTcp
        if not isinstance(serviceId, Unset):
            self.serviceId = serviceId
        if not isinstance(unauthenticated, Unset):
            self.unauthenticated = unauthenticated

    @classmethod
    def from_json(cls, obj: Json) -> "v1ProxyPortConfig":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "port" in obj:
            kwargs["port"] = obj["port"]
        if "proxyTcp" in obj:
            kwargs["proxyTcp"] = obj["proxyTcp"]
        if "serviceId" in obj:
            kwargs["serviceId"] = obj["serviceId"]
        if "unauthenticated" in obj:
            kwargs["unauthenticated"] = obj["unauthenticated"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "port" in vars(self):
            out["port"] = self.port
        if not omit_unset or "proxyTcp" in vars(self):
            out["proxyTcp"] = self.proxyTcp
        if not omit_unset or "serviceId" in vars(self):
            out["serviceId"] = self.serviceId
        if not omit_unset or "unauthenticated" in vars(self):
            out["unauthenticated"] = self.unauthenticated
        return out

class v1PutExperimentLabelResponse(Printable):
    """Response to PutExperimentLabelRequest."""

    def __init__(
        self,
        *,
        labels: "typing.Sequence[str]",
    ):
        self.labels = labels

    @classmethod
    def from_json(cls, obj: Json) -> "v1PutExperimentLabelResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "labels": obj["labels"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "labels": self.labels,
        }
        return out

class v1PutExperimentResponse(Printable):
    """Response to PutExperimentRequest."""

    def __init__(
        self,
        *,
        config: "typing.Dict[str, typing.Any]",
        experiment: "v1Experiment",
    ):
        self.config = config
        self.experiment = experiment

    @classmethod
    def from_json(cls, obj: Json) -> "v1PutExperimentResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "config": obj["config"],
            "experiment": v1Experiment.from_json(obj["experiment"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "config": self.config,
            "experiment": self.experiment.to_json(omit_unset),
        }
        return out

class v1PutExperimentRetainLogsRequest(Printable):
    """Request for changing the log retention policy for the an experiment."""

    def __init__(
        self,
        *,
        experimentId: int,
        numDays: int,
    ):
        self.experimentId = experimentId
        self.numDays = numDays

    @classmethod
    def from_json(cls, obj: Json) -> "v1PutExperimentRetainLogsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "experimentId": obj["experimentId"],
            "numDays": obj["numDays"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "experimentId": self.experimentId,
            "numDays": self.numDays,
        }
        return out

class v1PutExperimentsRetainLogsRequest(Printable):
    """Request for changing the log retention policy for the an experiment."""
    filters: "typing.Optional[v1BulkExperimentFilters]" = None

    def __init__(
        self,
        *,
        experimentIds: "typing.Sequence[int]",
        numDays: int,
        projectId: int,
        filters: "typing.Union[v1BulkExperimentFilters, None, Unset]" = _unset,
    ):
        self.experimentIds = experimentIds
        self.numDays = numDays
        self.projectId = projectId
        if not isinstance(filters, Unset):
            self.filters = filters

    @classmethod
    def from_json(cls, obj: Json) -> "v1PutExperimentsRetainLogsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "experimentIds": obj["experimentIds"],
            "numDays": obj["numDays"],
            "projectId": obj["projectId"],
        }
        if "filters" in obj:
            kwargs["filters"] = v1BulkExperimentFilters.from_json(obj["filters"]) if obj["filters"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "experimentIds": self.experimentIds,
            "numDays": self.numDays,
            "projectId": self.projectId,
        }
        if not omit_unset or "filters" in vars(self):
            out["filters"] = None if self.filters is None else self.filters.to_json(omit_unset)
        return out

class v1PutExperimentsRetainLogsResponse(Printable):
    """Response to PutExperimentRetainLogsRequest."""

    def __init__(
        self,
        *,
        results: "typing.Sequence[v1ExperimentActionResult]",
    ):
        self.results = results

    @classmethod
    def from_json(cls, obj: Json) -> "v1PutExperimentsRetainLogsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "results": [v1ExperimentActionResult.from_json(x) for x in obj["results"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "results": [x.to_json(omit_unset) for x in self.results],
        }
        return out

class v1PutGlobalConfigPoliciesRequest(Printable):
    """PutGlobalConfigPoliciesRequest sets global config
    policies for the workload type.
    """

    def __init__(
        self,
        *,
        configPolicies: str,
        workloadType: str,
    ):
        self.configPolicies = configPolicies
        self.workloadType = workloadType

    @classmethod
    def from_json(cls, obj: Json) -> "v1PutGlobalConfigPoliciesRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "configPolicies": obj["configPolicies"],
            "workloadType": obj["workloadType"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "configPolicies": self.configPolicies,
            "workloadType": self.workloadType,
        }
        return out

class v1PutGlobalConfigPoliciesResponse(Printable):
    """Response to PutGlobalConfigPoliciesRequest."""
    configPolicies: "typing.Optional[typing.Dict[str, typing.Any]]" = None

    def __init__(
        self,
        *,
        configPolicies: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
    ):
        if not isinstance(configPolicies, Unset):
            self.configPolicies = configPolicies

    @classmethod
    def from_json(cls, obj: Json) -> "v1PutGlobalConfigPoliciesResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "configPolicies" in obj:
            kwargs["configPolicies"] = obj["configPolicies"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "configPolicies" in vars(self):
            out["configPolicies"] = self.configPolicies
        return out

class v1PutProjectNotesRequest(Printable):
    """Request for setting project notes."""

    def __init__(
        self,
        *,
        notes: "typing.Sequence[v1Note]",
        projectId: int,
    ):
        self.notes = notes
        self.projectId = projectId

    @classmethod
    def from_json(cls, obj: Json) -> "v1PutProjectNotesRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "notes": [v1Note.from_json(x) for x in obj["notes"]],
            "projectId": obj["projectId"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "notes": [x.to_json(omit_unset) for x in self.notes],
            "projectId": self.projectId,
        }
        return out

class v1PutProjectNotesResponse(Printable):
    """Response to PutProjectNotesRequest."""

    def __init__(
        self,
        *,
        notes: "typing.Sequence[v1Note]",
    ):
        self.notes = notes

    @classmethod
    def from_json(cls, obj: Json) -> "v1PutProjectNotesResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "notes": [v1Note.from_json(x) for x in obj["notes"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "notes": [x.to_json(omit_unset) for x in self.notes],
        }
        return out

class v1PutTemplateResponse(Printable):
    """Response to PutTemplateRequest."""
    template: "typing.Optional[v1Template]" = None

    def __init__(
        self,
        *,
        template: "typing.Union[v1Template, None, Unset]" = _unset,
    ):
        if not isinstance(template, Unset):
            self.template = template

    @classmethod
    def from_json(cls, obj: Json) -> "v1PutTemplateResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "template" in obj:
            kwargs["template"] = v1Template.from_json(obj["template"]) if obj["template"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "template" in vars(self):
            out["template"] = None if self.template is None else self.template.to_json(omit_unset)
        return out

class v1PutTrialRequest(Printable):
    """Put a trial."""
    createTrialRequest: "typing.Optional[v1CreateTrialRequest]" = None
    externalTrialId: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        createTrialRequest: "typing.Union[v1CreateTrialRequest, None, Unset]" = _unset,
        externalTrialId: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(createTrialRequest, Unset):
            self.createTrialRequest = createTrialRequest
        if not isinstance(externalTrialId, Unset):
            self.externalTrialId = externalTrialId

    @classmethod
    def from_json(cls, obj: Json) -> "v1PutTrialRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "createTrialRequest" in obj:
            kwargs["createTrialRequest"] = v1CreateTrialRequest.from_json(obj["createTrialRequest"]) if obj["createTrialRequest"] is not None else None
        if "externalTrialId" in obj:
            kwargs["externalTrialId"] = obj["externalTrialId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "createTrialRequest" in vars(self):
            out["createTrialRequest"] = None if self.createTrialRequest is None else self.createTrialRequest.to_json(omit_unset)
        if not omit_unset or "externalTrialId" in vars(self):
            out["externalTrialId"] = self.externalTrialId
        return out

class v1PutTrialResponse(Printable):
    """Response to PutTrialRequest."""

    def __init__(
        self,
        *,
        trial: "trialv1Trial",
    ):
        self.trial = trial

    @classmethod
    def from_json(cls, obj: Json) -> "v1PutTrialResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "trial": trialv1Trial.from_json(obj["trial"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "trial": self.trial.to_json(omit_unset),
        }
        return out

class v1PutTrialRetainLogsRequest(Printable):
    """Request for changing the log retention policy for the an experiment."""
    trialId: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        numDays: int,
        trialId: "typing.Union[int, None, Unset]" = _unset,
    ):
        self.numDays = numDays
        if not isinstance(trialId, Unset):
            self.trialId = trialId

    @classmethod
    def from_json(cls, obj: Json) -> "v1PutTrialRetainLogsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "numDays": obj["numDays"],
        }
        if "trialId" in obj:
            kwargs["trialId"] = obj["trialId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "numDays": self.numDays,
        }
        if not omit_unset or "trialId" in vars(self):
            out["trialId"] = self.trialId
        return out

class v1PutWorkspaceConfigPoliciesRequest(Printable):
    """PutWorkspaceConfigPoliciesRequest sets config
    policies for the workspace and workload type.
    """

    def __init__(
        self,
        *,
        configPolicies: str,
        workloadType: str,
        workspaceId: int,
    ):
        self.configPolicies = configPolicies
        self.workloadType = workloadType
        self.workspaceId = workspaceId

    @classmethod
    def from_json(cls, obj: Json) -> "v1PutWorkspaceConfigPoliciesRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "configPolicies": obj["configPolicies"],
            "workloadType": obj["workloadType"],
            "workspaceId": obj["workspaceId"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "configPolicies": self.configPolicies,
            "workloadType": self.workloadType,
            "workspaceId": self.workspaceId,
        }
        return out

class v1PutWorkspaceConfigPoliciesResponse(Printable):
    """Response to PutWorkspaceConfigPoliciesRequest."""
    configPolicies: "typing.Optional[typing.Dict[str, typing.Any]]" = None

    def __init__(
        self,
        *,
        configPolicies: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
    ):
        if not isinstance(configPolicies, Unset):
            self.configPolicies = configPolicies

    @classmethod
    def from_json(cls, obj: Json) -> "v1PutWorkspaceConfigPoliciesResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "configPolicies" in obj:
            kwargs["configPolicies"] = obj["configPolicies"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "configPolicies" in vars(self):
            out["configPolicies"] = self.configPolicies
        return out

class v1QueueControl(Printable):
    """Describes a message to control jobs in a queue."""
    aheadOf: "typing.Optional[str]" = None
    behindOf: "typing.Optional[str]" = None
    priority: "typing.Optional[int]" = None
    resourcePool: "typing.Optional[str]" = None
    weight: "typing.Optional[float]" = None

    def __init__(
        self,
        *,
        jobId: str,
        aheadOf: "typing.Union[str, None, Unset]" = _unset,
        behindOf: "typing.Union[str, None, Unset]" = _unset,
        priority: "typing.Union[int, None, Unset]" = _unset,
        resourcePool: "typing.Union[str, None, Unset]" = _unset,
        weight: "typing.Union[float, None, Unset]" = _unset,
    ):
        self.jobId = jobId
        if not isinstance(aheadOf, Unset):
            self.aheadOf = aheadOf
        if not isinstance(behindOf, Unset):
            self.behindOf = behindOf
        if not isinstance(priority, Unset):
            self.priority = priority
        if not isinstance(resourcePool, Unset):
            self.resourcePool = resourcePool
        if not isinstance(weight, Unset):
            self.weight = weight

    @classmethod
    def from_json(cls, obj: Json) -> "v1QueueControl":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "jobId": obj["jobId"],
        }
        if "aheadOf" in obj:
            kwargs["aheadOf"] = obj["aheadOf"]
        if "behindOf" in obj:
            kwargs["behindOf"] = obj["behindOf"]
        if "priority" in obj:
            kwargs["priority"] = obj["priority"]
        if "resourcePool" in obj:
            kwargs["resourcePool"] = obj["resourcePool"]
        if "weight" in obj:
            kwargs["weight"] = float(obj["weight"]) if obj["weight"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "jobId": self.jobId,
        }
        if not omit_unset or "aheadOf" in vars(self):
            out["aheadOf"] = self.aheadOf
        if not omit_unset or "behindOf" in vars(self):
            out["behindOf"] = self.behindOf
        if not omit_unset or "priority" in vars(self):
            out["priority"] = self.priority
        if not omit_unset or "resourcePool" in vars(self):
            out["resourcePool"] = self.resourcePool
        if not omit_unset or "weight" in vars(self):
            out["weight"] = None if self.weight is None else dump_float(self.weight)
        return out

class v1QueueStats(Printable):
    """Statistics for a queue."""

    def __init__(
        self,
        *,
        queuedCount: int,
        scheduledCount: int,
    ):
        self.queuedCount = queuedCount
        self.scheduledCount = scheduledCount

    @classmethod
    def from_json(cls, obj: Json) -> "v1QueueStats":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "queuedCount": obj["queuedCount"],
            "scheduledCount": obj["scheduledCount"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "queuedCount": self.queuedCount,
            "scheduledCount": self.scheduledCount,
        }
        return out

class v1RBACJob(Printable):
    """RBACJob is a job that can have either a limited or a full
    representation of a job.
    """
    full: "typing.Optional[v1Job]" = None
    limited: "typing.Optional[v1LimitedJob]" = None

    def __init__(
        self,
        *,
        full: "typing.Union[v1Job, None, Unset]" = _unset,
        limited: "typing.Union[v1LimitedJob, None, Unset]" = _unset,
    ):
        if not isinstance(full, Unset):
            self.full = full
        if not isinstance(limited, Unset):
            self.limited = limited

    @classmethod
    def from_json(cls, obj: Json) -> "v1RBACJob":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "full" in obj:
            kwargs["full"] = v1Job.from_json(obj["full"]) if obj["full"] is not None else None
        if "limited" in obj:
            kwargs["limited"] = v1LimitedJob.from_json(obj["limited"]) if obj["limited"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "full" in vars(self):
            out["full"] = None if self.full is None else self.full.to_json(omit_unset)
        if not omit_unset or "limited" in vars(self):
            out["limited"] = None if self.limited is None else self.limited.to_json(omit_unset)
        return out

class v1RPQueueStat(Printable):
    """Job stats for a resource pool."""
    aggregates: "typing.Optional[typing.Sequence[v1AggregateQueueStats]]" = None

    def __init__(
        self,
        *,
        resourcePool: str,
        stats: "v1QueueStats",
        aggregates: "typing.Union[typing.Sequence[v1AggregateQueueStats], None, Unset]" = _unset,
    ):
        self.resourcePool = resourcePool
        self.stats = stats
        if not isinstance(aggregates, Unset):
            self.aggregates = aggregates

    @classmethod
    def from_json(cls, obj: Json) -> "v1RPQueueStat":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "resourcePool": obj["resourcePool"],
            "stats": v1QueueStats.from_json(obj["stats"]),
        }
        if "aggregates" in obj:
            kwargs["aggregates"] = [v1AggregateQueueStats.from_json(x) for x in obj["aggregates"]] if obj["aggregates"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "resourcePool": self.resourcePool,
            "stats": self.stats.to_json(omit_unset),
        }
        if not omit_unset or "aggregates" in vars(self):
            out["aggregates"] = None if self.aggregates is None else [x.to_json(omit_unset) for x in self.aggregates]
        return out

class v1RemoveAssignmentsRequest(Printable):
    """RemoveAssignmentsRequest is the body of the request for the call
    to remove a user or group from a role.
    """
    groupRoleAssignments: "typing.Optional[typing.Sequence[v1GroupRoleAssignment]]" = None
    userRoleAssignments: "typing.Optional[typing.Sequence[v1UserRoleAssignment]]" = None

    def __init__(
        self,
        *,
        groupRoleAssignments: "typing.Union[typing.Sequence[v1GroupRoleAssignment], None, Unset]" = _unset,
        userRoleAssignments: "typing.Union[typing.Sequence[v1UserRoleAssignment], None, Unset]" = _unset,
    ):
        if not isinstance(groupRoleAssignments, Unset):
            self.groupRoleAssignments = groupRoleAssignments
        if not isinstance(userRoleAssignments, Unset):
            self.userRoleAssignments = userRoleAssignments

    @classmethod
    def from_json(cls, obj: Json) -> "v1RemoveAssignmentsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "groupRoleAssignments" in obj:
            kwargs["groupRoleAssignments"] = [v1GroupRoleAssignment.from_json(x) for x in obj["groupRoleAssignments"]] if obj["groupRoleAssignments"] is not None else None
        if "userRoleAssignments" in obj:
            kwargs["userRoleAssignments"] = [v1UserRoleAssignment.from_json(x) for x in obj["userRoleAssignments"]] if obj["userRoleAssignments"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "groupRoleAssignments" in vars(self):
            out["groupRoleAssignments"] = None if self.groupRoleAssignments is None else [x.to_json(omit_unset) for x in self.groupRoleAssignments]
        if not omit_unset or "userRoleAssignments" in vars(self):
            out["userRoleAssignments"] = None if self.userRoleAssignments is None else [x.to_json(omit_unset) for x in self.userRoleAssignments]
        return out

class v1RendezvousInfo(Printable):
    """The rendezvous info for the trial to rendezvous with sibling containers."""

    def __init__(
        self,
        *,
        addresses: "typing.Sequence[str]",
        rank: int,
        slots: "typing.Sequence[int]",
    ):
        self.addresses = addresses
        self.rank = rank
        self.slots = slots

    @classmethod
    def from_json(cls, obj: Json) -> "v1RendezvousInfo":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "addresses": obj["addresses"],
            "rank": obj["rank"],
            "slots": obj["slots"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "addresses": self.addresses,
            "rank": self.rank,
            "slots": self.slots,
        }
        return out

class v1ReportTrialMetricsRequest(Printable):
    """Persist the given metrics for the trial."""

    def __init__(
        self,
        *,
        group: str,
        metrics: "v1TrialMetrics",
    ):
        self.group = group
        self.metrics = metrics

    @classmethod
    def from_json(cls, obj: Json) -> "v1ReportTrialMetricsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "group": obj["group"],
            "metrics": v1TrialMetrics.from_json(obj["metrics"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "group": self.group,
            "metrics": self.metrics.to_json(omit_unset),
        }
        return out

class v1ReportTrialProgressRequest(Printable):
    """For bookkeeping, updates the progress of the trial as a percent torwards
    the training length requested of it by the searcher.
    """
    isRaw: "typing.Optional[bool]" = None

    def __init__(
        self,
        *,
        progress: float,
        trialId: int,
        isRaw: "typing.Union[bool, None, Unset]" = _unset,
    ):
        self.progress = progress
        self.trialId = trialId
        if not isinstance(isRaw, Unset):
            self.isRaw = isRaw

    @classmethod
    def from_json(cls, obj: Json) -> "v1ReportTrialProgressRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "progress": float(obj["progress"]),
            "trialId": obj["trialId"],
        }
        if "isRaw" in obj:
            kwargs["isRaw"] = obj["isRaw"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "progress": dump_float(self.progress),
            "trialId": self.trialId,
        }
        if not omit_unset or "isRaw" in vars(self):
            out["isRaw"] = self.isRaw
        return out

class v1ReportTrialSourceInfoRequest(Printable):

    def __init__(
        self,
        *,
        trialSourceInfo: "v1TrialSourceInfo",
    ):
        self.trialSourceInfo = trialSourceInfo

    @classmethod
    def from_json(cls, obj: Json) -> "v1ReportTrialSourceInfoRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "trialSourceInfo": v1TrialSourceInfo.from_json(obj["trialSourceInfo"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "trialSourceInfo": self.trialSourceInfo.to_json(omit_unset),
        }
        return out

class v1ReportTrialSourceInfoResponse(Printable):

    def __init__(
        self,
        *,
        checkpointUuid: str,
        trialId: int,
    ):
        self.checkpointUuid = checkpointUuid
        self.trialId = trialId

    @classmethod
    def from_json(cls, obj: Json) -> "v1ReportTrialSourceInfoResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "checkpointUuid": obj["checkpointUuid"],
            "trialId": obj["trialId"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "checkpointUuid": self.checkpointUuid,
            "trialId": self.trialId,
        }
        return out

class v1ResourceAllocationAggregatedEntry(Printable):
    """One instance of slots in the cluster being allocated to a task during a
    period (aggregated).
    """

    def __init__(
        self,
        *,
        byExperimentLabel: "typing.Dict[str, float]",
        byResourcePool: "typing.Dict[str, float]",
        byUsername: "typing.Dict[str, float]",
        period: "v1ResourceAllocationAggregationPeriod",
        periodStart: str,
        seconds: float,
    ):
        self.byExperimentLabel = byExperimentLabel
        self.byResourcePool = byResourcePool
        self.byUsername = byUsername
        self.period = period
        self.periodStart = periodStart
        self.seconds = seconds

    @classmethod
    def from_json(cls, obj: Json) -> "v1ResourceAllocationAggregatedEntry":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "byExperimentLabel": {k: float(v) for k, v in obj["byExperimentLabel"].items()},
            "byResourcePool": {k: float(v) for k, v in obj["byResourcePool"].items()},
            "byUsername": {k: float(v) for k, v in obj["byUsername"].items()},
            "period": v1ResourceAllocationAggregationPeriod(obj["period"]),
            "periodStart": obj["periodStart"],
            "seconds": float(obj["seconds"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "byExperimentLabel": {k: dump_float(v) for k, v in self.byExperimentLabel.items()},
            "byResourcePool": {k: dump_float(v) for k, v in self.byResourcePool.items()},
            "byUsername": {k: dump_float(v) for k, v in self.byUsername.items()},
            "period": self.period.value,
            "periodStart": self.periodStart,
            "seconds": dump_float(self.seconds),
        }
        return out

class v1ResourceAllocationAggregatedResponse(Printable):
    """Response to ResourceAllocationAggregatedRequest."""

    def __init__(
        self,
        *,
        resourceEntries: "typing.Sequence[v1ResourceAllocationAggregatedEntry]",
    ):
        self.resourceEntries = resourceEntries

    @classmethod
    def from_json(cls, obj: Json) -> "v1ResourceAllocationAggregatedResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "resourceEntries": [v1ResourceAllocationAggregatedEntry.from_json(x) for x in obj["resourceEntries"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "resourceEntries": [x.to_json(omit_unset) for x in self.resourceEntries],
        }
        return out

class v1ResourceAllocationAggregationPeriod(DetEnum):
    """The period over which to perform aggregation.
    - RESOURCE_ALLOCATION_AGGREGATION_PERIOD_UNSPECIFIED: Unspecified. This value will never actually be returned by the API, it is
    just an artifact of using protobuf.
    - RESOURCE_ALLOCATION_AGGREGATION_PERIOD_DAILY: Aggregation by day.
    - RESOURCE_ALLOCATION_AGGREGATION_PERIOD_MONTHLY: Aggregation by month.
    """
    UNSPECIFIED = "RESOURCE_ALLOCATION_AGGREGATION_PERIOD_UNSPECIFIED"
    DAILY = "RESOURCE_ALLOCATION_AGGREGATION_PERIOD_DAILY"
    MONTHLY = "RESOURCE_ALLOCATION_AGGREGATION_PERIOD_MONTHLY"

class v1ResourceAllocationRawEntry(Printable):
    """One instance of slots in the cluster being allocated to a task."""
    endTime: "typing.Optional[str]" = None
    experimentId: "typing.Optional[int]" = None
    kind: "typing.Optional[str]" = None
    labels: "typing.Optional[typing.Sequence[str]]" = None
    seconds: "typing.Optional[float]" = None
    slots: "typing.Optional[int]" = None
    startTime: "typing.Optional[str]" = None
    userId: "typing.Optional[int]" = None
    username: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        endTime: "typing.Union[str, None, Unset]" = _unset,
        experimentId: "typing.Union[int, None, Unset]" = _unset,
        kind: "typing.Union[str, None, Unset]" = _unset,
        labels: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
        seconds: "typing.Union[float, None, Unset]" = _unset,
        slots: "typing.Union[int, None, Unset]" = _unset,
        startTime: "typing.Union[str, None, Unset]" = _unset,
        userId: "typing.Union[int, None, Unset]" = _unset,
        username: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(endTime, Unset):
            self.endTime = endTime
        if not isinstance(experimentId, Unset):
            self.experimentId = experimentId
        if not isinstance(kind, Unset):
            self.kind = kind
        if not isinstance(labels, Unset):
            self.labels = labels
        if not isinstance(seconds, Unset):
            self.seconds = seconds
        if not isinstance(slots, Unset):
            self.slots = slots
        if not isinstance(startTime, Unset):
            self.startTime = startTime
        if not isinstance(userId, Unset):
            self.userId = userId
        if not isinstance(username, Unset):
            self.username = username

    @classmethod
    def from_json(cls, obj: Json) -> "v1ResourceAllocationRawEntry":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "endTime" in obj:
            kwargs["endTime"] = obj["endTime"]
        if "experimentId" in obj:
            kwargs["experimentId"] = obj["experimentId"]
        if "kind" in obj:
            kwargs["kind"] = obj["kind"]
        if "labels" in obj:
            kwargs["labels"] = obj["labels"]
        if "seconds" in obj:
            kwargs["seconds"] = float(obj["seconds"]) if obj["seconds"] is not None else None
        if "slots" in obj:
            kwargs["slots"] = obj["slots"]
        if "startTime" in obj:
            kwargs["startTime"] = obj["startTime"]
        if "userId" in obj:
            kwargs["userId"] = obj["userId"]
        if "username" in obj:
            kwargs["username"] = obj["username"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "endTime" in vars(self):
            out["endTime"] = self.endTime
        if not omit_unset or "experimentId" in vars(self):
            out["experimentId"] = self.experimentId
        if not omit_unset or "kind" in vars(self):
            out["kind"] = self.kind
        if not omit_unset or "labels" in vars(self):
            out["labels"] = self.labels
        if not omit_unset or "seconds" in vars(self):
            out["seconds"] = None if self.seconds is None else dump_float(self.seconds)
        if not omit_unset or "slots" in vars(self):
            out["slots"] = self.slots
        if not omit_unset or "startTime" in vars(self):
            out["startTime"] = self.startTime
        if not omit_unset or "userId" in vars(self):
            out["userId"] = self.userId
        if not omit_unset or "username" in vars(self):
            out["username"] = self.username
        return out

class v1ResourceAllocationRawResponse(Printable):
    """Response to ResourceAllocationRawRequest."""
    resourceEntries: "typing.Optional[typing.Sequence[v1ResourceAllocationRawEntry]]" = None

    def __init__(
        self,
        *,
        resourceEntries: "typing.Union[typing.Sequence[v1ResourceAllocationRawEntry], None, Unset]" = _unset,
    ):
        if not isinstance(resourceEntries, Unset):
            self.resourceEntries = resourceEntries

    @classmethod
    def from_json(cls, obj: Json) -> "v1ResourceAllocationRawResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "resourceEntries" in obj:
            kwargs["resourceEntries"] = [v1ResourceAllocationRawEntry.from_json(x) for x in obj["resourceEntries"]] if obj["resourceEntries"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "resourceEntries" in vars(self):
            out["resourceEntries"] = None if self.resourceEntries is None else [x.to_json(omit_unset) for x in self.resourceEntries]
        return out

class v1ResourcePool(Printable):
    """A Resource Pool is a pool of resources where containers are run."""
    accelerator: "typing.Optional[str]" = None
    slotsPerAgent: "typing.Optional[int]" = None
    stats: "typing.Optional[v1QueueStats]" = None

    def __init__(
        self,
        *,
        agentDockerImage: str,
        agentDockerNetwork: str,
        agentDockerRuntime: str,
        agentFluentImage: str,
        auxContainerCapacity: int,
        auxContainerCapacityPerAgent: int,
        auxContainersRunning: int,
        clusterName: str,
        containerStartupScript: str,
        defaultAuxPool: bool,
        defaultComputePool: bool,
        description: str,
        details: "v1ResourcePoolDetail",
        imageId: str,
        instanceType: str,
        location: str,
        masterCertName: str,
        masterUrl: str,
        maxAgentStartingPeriod: float,
        maxAgents: int,
        maxIdleAgentPeriod: float,
        minAgents: int,
        name: str,
        numAgents: int,
        preemptible: bool,
        resourceManagerMetadata: "typing.Dict[str, str]",
        schedulerFittingPolicy: "v1FittingPolicy",
        schedulerType: "v1SchedulerType",
        slotType: "devicev1Type",
        slotsAvailable: int,
        slotsUsed: int,
        startupScript: str,
        type: "v1ResourcePoolType",
        accelerator: "typing.Union[str, None, Unset]" = _unset,
        slotsPerAgent: "typing.Union[int, None, Unset]" = _unset,
        stats: "typing.Union[v1QueueStats, None, Unset]" = _unset,
    ):
        self.agentDockerImage = agentDockerImage
        self.agentDockerNetwork = agentDockerNetwork
        self.agentDockerRuntime = agentDockerRuntime
        self.agentFluentImage = agentFluentImage
        self.auxContainerCapacity = auxContainerCapacity
        self.auxContainerCapacityPerAgent = auxContainerCapacityPerAgent
        self.auxContainersRunning = auxContainersRunning
        self.clusterName = clusterName
        self.containerStartupScript = containerStartupScript
        self.defaultAuxPool = defaultAuxPool
        self.defaultComputePool = defaultComputePool
        self.description = description
        self.details = details
        self.imageId = imageId
        self.instanceType = instanceType
        self.location = location
        self.masterCertName = masterCertName
        self.masterUrl = masterUrl
        self.maxAgentStartingPeriod = maxAgentStartingPeriod
        self.maxAgents = maxAgents
        self.maxIdleAgentPeriod = maxIdleAgentPeriod
        self.minAgents = minAgents
        self.name = name
        self.numAgents = numAgents
        self.preemptible = preemptible
        self.resourceManagerMetadata = resourceManagerMetadata
        self.schedulerFittingPolicy = schedulerFittingPolicy
        self.schedulerType = schedulerType
        self.slotType = slotType
        self.slotsAvailable = slotsAvailable
        self.slotsUsed = slotsUsed
        self.startupScript = startupScript
        self.type = type
        if not isinstance(accelerator, Unset):
            self.accelerator = accelerator
        if not isinstance(slotsPerAgent, Unset):
            self.slotsPerAgent = slotsPerAgent
        if not isinstance(stats, Unset):
            self.stats = stats

    @classmethod
    def from_json(cls, obj: Json) -> "v1ResourcePool":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "agentDockerImage": obj["agentDockerImage"],
            "agentDockerNetwork": obj["agentDockerNetwork"],
            "agentDockerRuntime": obj["agentDockerRuntime"],
            "agentFluentImage": obj["agentFluentImage"],
            "auxContainerCapacity": obj["auxContainerCapacity"],
            "auxContainerCapacityPerAgent": obj["auxContainerCapacityPerAgent"],
            "auxContainersRunning": obj["auxContainersRunning"],
            "clusterName": obj["clusterName"],
            "containerStartupScript": obj["containerStartupScript"],
            "defaultAuxPool": obj["defaultAuxPool"],
            "defaultComputePool": obj["defaultComputePool"],
            "description": obj["description"],
            "details": v1ResourcePoolDetail.from_json(obj["details"]),
            "imageId": obj["imageId"],
            "instanceType": obj["instanceType"],
            "location": obj["location"],
            "masterCertName": obj["masterCertName"],
            "masterUrl": obj["masterUrl"],
            "maxAgentStartingPeriod": float(obj["maxAgentStartingPeriod"]),
            "maxAgents": obj["maxAgents"],
            "maxIdleAgentPeriod": float(obj["maxIdleAgentPeriod"]),
            "minAgents": obj["minAgents"],
            "name": obj["name"],
            "numAgents": obj["numAgents"],
            "preemptible": obj["preemptible"],
            "resourceManagerMetadata": obj["resourceManagerMetadata"],
            "schedulerFittingPolicy": v1FittingPolicy(obj["schedulerFittingPolicy"]),
            "schedulerType": v1SchedulerType(obj["schedulerType"]),
            "slotType": devicev1Type(obj["slotType"]),
            "slotsAvailable": obj["slotsAvailable"],
            "slotsUsed": obj["slotsUsed"],
            "startupScript": obj["startupScript"],
            "type": v1ResourcePoolType(obj["type"]),
        }
        if "accelerator" in obj:
            kwargs["accelerator"] = obj["accelerator"]
        if "slotsPerAgent" in obj:
            kwargs["slotsPerAgent"] = obj["slotsPerAgent"]
        if "stats" in obj:
            kwargs["stats"] = v1QueueStats.from_json(obj["stats"]) if obj["stats"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "agentDockerImage": self.agentDockerImage,
            "agentDockerNetwork": self.agentDockerNetwork,
            "agentDockerRuntime": self.agentDockerRuntime,
            "agentFluentImage": self.agentFluentImage,
            "auxContainerCapacity": self.auxContainerCapacity,
            "auxContainerCapacityPerAgent": self.auxContainerCapacityPerAgent,
            "auxContainersRunning": self.auxContainersRunning,
            "clusterName": self.clusterName,
            "containerStartupScript": self.containerStartupScript,
            "defaultAuxPool": self.defaultAuxPool,
            "defaultComputePool": self.defaultComputePool,
            "description": self.description,
            "details": self.details.to_json(omit_unset),
            "imageId": self.imageId,
            "instanceType": self.instanceType,
            "location": self.location,
            "masterCertName": self.masterCertName,
            "masterUrl": self.masterUrl,
            "maxAgentStartingPeriod": dump_float(self.maxAgentStartingPeriod),
            "maxAgents": self.maxAgents,
            "maxIdleAgentPeriod": dump_float(self.maxIdleAgentPeriod),
            "minAgents": self.minAgents,
            "name": self.name,
            "numAgents": self.numAgents,
            "preemptible": self.preemptible,
            "resourceManagerMetadata": self.resourceManagerMetadata,
            "schedulerFittingPolicy": self.schedulerFittingPolicy.value,
            "schedulerType": self.schedulerType.value,
            "slotType": self.slotType.value,
            "slotsAvailable": self.slotsAvailable,
            "slotsUsed": self.slotsUsed,
            "startupScript": self.startupScript,
            "type": self.type.value,
        }
        if not omit_unset or "accelerator" in vars(self):
            out["accelerator"] = self.accelerator
        if not omit_unset or "slotsPerAgent" in vars(self):
            out["slotsPerAgent"] = self.slotsPerAgent
        if not omit_unset or "stats" in vars(self):
            out["stats"] = None if self.stats is None else self.stats.to_json(omit_unset)
        return out

class v1ResourcePoolAwsDetail(Printable):
    customTags: "typing.Optional[typing.Sequence[v1AwsCustomTag]]" = None
    instanceType: "typing.Optional[str]" = None
    logGroup: "typing.Optional[str]" = None
    logStream: "typing.Optional[str]" = None
    spotMaxPrice: "typing.Optional[str]" = None
    subnetId: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        iamInstanceProfileArn: str,
        imageId: str,
        instanceName: str,
        publicIp: bool,
        region: str,
        rootVolumeSize: int,
        securityGroupId: str,
        spotEnabled: bool,
        sshKeyName: str,
        tagKey: str,
        tagValue: str,
        customTags: "typing.Union[typing.Sequence[v1AwsCustomTag], None, Unset]" = _unset,
        instanceType: "typing.Union[str, None, Unset]" = _unset,
        logGroup: "typing.Union[str, None, Unset]" = _unset,
        logStream: "typing.Union[str, None, Unset]" = _unset,
        spotMaxPrice: "typing.Union[str, None, Unset]" = _unset,
        subnetId: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.iamInstanceProfileArn = iamInstanceProfileArn
        self.imageId = imageId
        self.instanceName = instanceName
        self.publicIp = publicIp
        self.region = region
        self.rootVolumeSize = rootVolumeSize
        self.securityGroupId = securityGroupId
        self.spotEnabled = spotEnabled
        self.sshKeyName = sshKeyName
        self.tagKey = tagKey
        self.tagValue = tagValue
        if not isinstance(customTags, Unset):
            self.customTags = customTags
        if not isinstance(instanceType, Unset):
            self.instanceType = instanceType
        if not isinstance(logGroup, Unset):
            self.logGroup = logGroup
        if not isinstance(logStream, Unset):
            self.logStream = logStream
        if not isinstance(spotMaxPrice, Unset):
            self.spotMaxPrice = spotMaxPrice
        if not isinstance(subnetId, Unset):
            self.subnetId = subnetId

    @classmethod
    def from_json(cls, obj: Json) -> "v1ResourcePoolAwsDetail":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "iamInstanceProfileArn": obj["iamInstanceProfileArn"],
            "imageId": obj["imageId"],
            "instanceName": obj["instanceName"],
            "publicIp": obj["publicIp"],
            "region": obj["region"],
            "rootVolumeSize": obj["rootVolumeSize"],
            "securityGroupId": obj["securityGroupId"],
            "spotEnabled": obj["spotEnabled"],
            "sshKeyName": obj["sshKeyName"],
            "tagKey": obj["tagKey"],
            "tagValue": obj["tagValue"],
        }
        if "customTags" in obj:
            kwargs["customTags"] = [v1AwsCustomTag.from_json(x) for x in obj["customTags"]] if obj["customTags"] is not None else None
        if "instanceType" in obj:
            kwargs["instanceType"] = obj["instanceType"]
        if "logGroup" in obj:
            kwargs["logGroup"] = obj["logGroup"]
        if "logStream" in obj:
            kwargs["logStream"] = obj["logStream"]
        if "spotMaxPrice" in obj:
            kwargs["spotMaxPrice"] = obj["spotMaxPrice"]
        if "subnetId" in obj:
            kwargs["subnetId"] = obj["subnetId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "iamInstanceProfileArn": self.iamInstanceProfileArn,
            "imageId": self.imageId,
            "instanceName": self.instanceName,
            "publicIp": self.publicIp,
            "region": self.region,
            "rootVolumeSize": self.rootVolumeSize,
            "securityGroupId": self.securityGroupId,
            "spotEnabled": self.spotEnabled,
            "sshKeyName": self.sshKeyName,
            "tagKey": self.tagKey,
            "tagValue": self.tagValue,
        }
        if not omit_unset or "customTags" in vars(self):
            out["customTags"] = None if self.customTags is None else [x.to_json(omit_unset) for x in self.customTags]
        if not omit_unset or "instanceType" in vars(self):
            out["instanceType"] = self.instanceType
        if not omit_unset or "logGroup" in vars(self):
            out["logGroup"] = self.logGroup
        if not omit_unset or "logStream" in vars(self):
            out["logStream"] = self.logStream
        if not omit_unset or "spotMaxPrice" in vars(self):
            out["spotMaxPrice"] = self.spotMaxPrice
        if not omit_unset or "subnetId" in vars(self):
            out["subnetId"] = self.subnetId
        return out

class v1ResourcePoolDetail(Printable):
    aws: "typing.Optional[v1ResourcePoolAwsDetail]" = None
    gcp: "typing.Optional[v1ResourcePoolGcpDetail]" = None
    priorityScheduler: "typing.Optional[v1ResourcePoolPrioritySchedulerDetail]" = None

    def __init__(
        self,
        *,
        aws: "typing.Union[v1ResourcePoolAwsDetail, None, Unset]" = _unset,
        gcp: "typing.Union[v1ResourcePoolGcpDetail, None, Unset]" = _unset,
        priorityScheduler: "typing.Union[v1ResourcePoolPrioritySchedulerDetail, None, Unset]" = _unset,
    ):
        if not isinstance(aws, Unset):
            self.aws = aws
        if not isinstance(gcp, Unset):
            self.gcp = gcp
        if not isinstance(priorityScheduler, Unset):
            self.priorityScheduler = priorityScheduler

    @classmethod
    def from_json(cls, obj: Json) -> "v1ResourcePoolDetail":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "aws" in obj:
            kwargs["aws"] = v1ResourcePoolAwsDetail.from_json(obj["aws"]) if obj["aws"] is not None else None
        if "gcp" in obj:
            kwargs["gcp"] = v1ResourcePoolGcpDetail.from_json(obj["gcp"]) if obj["gcp"] is not None else None
        if "priorityScheduler" in obj:
            kwargs["priorityScheduler"] = v1ResourcePoolPrioritySchedulerDetail.from_json(obj["priorityScheduler"]) if obj["priorityScheduler"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "aws" in vars(self):
            out["aws"] = None if self.aws is None else self.aws.to_json(omit_unset)
        if not omit_unset or "gcp" in vars(self):
            out["gcp"] = None if self.gcp is None else self.gcp.to_json(omit_unset)
        if not omit_unset or "priorityScheduler" in vars(self):
            out["priorityScheduler"] = None if self.priorityScheduler is None else self.priorityScheduler.to_json(omit_unset)
        return out

class v1ResourcePoolGcpDetail(Printable):
    networkTags: "typing.Optional[typing.Sequence[str]]" = None
    subnetwork: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        bootDiskSize: int,
        bootDiskSourceImage: str,
        externalIp: bool,
        gpuNum: int,
        gpuType: str,
        labelKey: str,
        labelValue: str,
        machineType: str,
        namePrefix: str,
        network: str,
        operationTimeoutPeriod: float,
        preemptible: bool,
        project: str,
        serviceAccountEmail: str,
        serviceAccountScopes: "typing.Sequence[str]",
        zone: str,
        networkTags: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
        subnetwork: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.bootDiskSize = bootDiskSize
        self.bootDiskSourceImage = bootDiskSourceImage
        self.externalIp = externalIp
        self.gpuNum = gpuNum
        self.gpuType = gpuType
        self.labelKey = labelKey
        self.labelValue = labelValue
        self.machineType = machineType
        self.namePrefix = namePrefix
        self.network = network
        self.operationTimeoutPeriod = operationTimeoutPeriod
        self.preemptible = preemptible
        self.project = project
        self.serviceAccountEmail = serviceAccountEmail
        self.serviceAccountScopes = serviceAccountScopes
        self.zone = zone
        if not isinstance(networkTags, Unset):
            self.networkTags = networkTags
        if not isinstance(subnetwork, Unset):
            self.subnetwork = subnetwork

    @classmethod
    def from_json(cls, obj: Json) -> "v1ResourcePoolGcpDetail":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "bootDiskSize": obj["bootDiskSize"],
            "bootDiskSourceImage": obj["bootDiskSourceImage"],
            "externalIp": obj["externalIp"],
            "gpuNum": obj["gpuNum"],
            "gpuType": obj["gpuType"],
            "labelKey": obj["labelKey"],
            "labelValue": obj["labelValue"],
            "machineType": obj["machineType"],
            "namePrefix": obj["namePrefix"],
            "network": obj["network"],
            "operationTimeoutPeriod": float(obj["operationTimeoutPeriod"]),
            "preemptible": obj["preemptible"],
            "project": obj["project"],
            "serviceAccountEmail": obj["serviceAccountEmail"],
            "serviceAccountScopes": obj["serviceAccountScopes"],
            "zone": obj["zone"],
        }
        if "networkTags" in obj:
            kwargs["networkTags"] = obj["networkTags"]
        if "subnetwork" in obj:
            kwargs["subnetwork"] = obj["subnetwork"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "bootDiskSize": self.bootDiskSize,
            "bootDiskSourceImage": self.bootDiskSourceImage,
            "externalIp": self.externalIp,
            "gpuNum": self.gpuNum,
            "gpuType": self.gpuType,
            "labelKey": self.labelKey,
            "labelValue": self.labelValue,
            "machineType": self.machineType,
            "namePrefix": self.namePrefix,
            "network": self.network,
            "operationTimeoutPeriod": dump_float(self.operationTimeoutPeriod),
            "preemptible": self.preemptible,
            "project": self.project,
            "serviceAccountEmail": self.serviceAccountEmail,
            "serviceAccountScopes": self.serviceAccountScopes,
            "zone": self.zone,
        }
        if not omit_unset or "networkTags" in vars(self):
            out["networkTags"] = self.networkTags
        if not omit_unset or "subnetwork" in vars(self):
            out["subnetwork"] = self.subnetwork
        return out

class v1ResourcePoolPrioritySchedulerDetail(Printable):
    k8Priorities: "typing.Optional[typing.Sequence[v1K8PriorityClass]]" = None

    def __init__(
        self,
        *,
        defaultPriority: int,
        preemption: bool,
        k8Priorities: "typing.Union[typing.Sequence[v1K8PriorityClass], None, Unset]" = _unset,
    ):
        self.defaultPriority = defaultPriority
        self.preemption = preemption
        if not isinstance(k8Priorities, Unset):
            self.k8Priorities = k8Priorities

    @classmethod
    def from_json(cls, obj: Json) -> "v1ResourcePoolPrioritySchedulerDetail":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "defaultPriority": obj["defaultPriority"],
            "preemption": obj["preemption"],
        }
        if "k8Priorities" in obj:
            kwargs["k8Priorities"] = [v1K8PriorityClass.from_json(x) for x in obj["k8Priorities"]] if obj["k8Priorities"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "defaultPriority": self.defaultPriority,
            "preemption": self.preemption,
        }
        if not omit_unset or "k8Priorities" in vars(self):
            out["k8Priorities"] = None if self.k8Priorities is None else [x.to_json(omit_unset) for x in self.k8Priorities]
        return out

class v1ResourcePoolType(DetEnum):
    """The type of the ResourcePool.
    - RESOURCE_POOL_TYPE_UNSPECIFIED: Unspecified. This value will never actually be returned by the API, it is
    just an artifact of using protobuf.
    - RESOURCE_POOL_TYPE_AWS: An AWS resource pool.
    - RESOURCE_POOL_TYPE_GCP: A GCP resource pool.
    - RESOURCE_POOL_TYPE_STATIC: A static resource pool.
    - RESOURCE_POOL_TYPE_K8S: The kubernetes resource pool.
    """
    UNSPECIFIED = "RESOURCE_POOL_TYPE_UNSPECIFIED"
    AWS = "RESOURCE_POOL_TYPE_AWS"
    GCP = "RESOURCE_POOL_TYPE_GCP"
    STATIC = "RESOURCE_POOL_TYPE_STATIC"
    K8S = "RESOURCE_POOL_TYPE_K8S"

class v1ResourcesFailure(Printable):
    """ResourcesFailure contains information about restored resources' failure."""
    errMsg: "typing.Optional[str]" = None
    exitCode: "typing.Optional[int]" = None
    failureType: "typing.Optional[v1FailureType]" = None

    def __init__(
        self,
        *,
        errMsg: "typing.Union[str, None, Unset]" = _unset,
        exitCode: "typing.Union[int, None, Unset]" = _unset,
        failureType: "typing.Union[v1FailureType, None, Unset]" = _unset,
    ):
        if not isinstance(errMsg, Unset):
            self.errMsg = errMsg
        if not isinstance(exitCode, Unset):
            self.exitCode = exitCode
        if not isinstance(failureType, Unset):
            self.failureType = failureType

    @classmethod
    def from_json(cls, obj: Json) -> "v1ResourcesFailure":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "errMsg" in obj:
            kwargs["errMsg"] = obj["errMsg"]
        if "exitCode" in obj:
            kwargs["exitCode"] = obj["exitCode"]
        if "failureType" in obj:
            kwargs["failureType"] = v1FailureType(obj["failureType"]) if obj["failureType"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "errMsg" in vars(self):
            out["errMsg"] = self.errMsg
        if not omit_unset or "exitCode" in vars(self):
            out["exitCode"] = self.exitCode
        if not omit_unset or "failureType" in vars(self):
            out["failureType"] = None if self.failureType is None else self.failureType.value
        return out

class v1ResourcesStarted(Printable):
    """ResourcesStarted contains the information needed by tasks from container
    started.
    """
    addresses: "typing.Optional[typing.Sequence[v1Address]]" = None
    nativeResourcesId: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        addresses: "typing.Union[typing.Sequence[v1Address], None, Unset]" = _unset,
        nativeResourcesId: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(addresses, Unset):
            self.addresses = addresses
        if not isinstance(nativeResourcesId, Unset):
            self.nativeResourcesId = nativeResourcesId

    @classmethod
    def from_json(cls, obj: Json) -> "v1ResourcesStarted":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "addresses" in obj:
            kwargs["addresses"] = [v1Address.from_json(x) for x in obj["addresses"]] if obj["addresses"] is not None else None
        if "nativeResourcesId" in obj:
            kwargs["nativeResourcesId"] = obj["nativeResourcesId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "addresses" in vars(self):
            out["addresses"] = None if self.addresses is None else [x.to_json(omit_unset) for x in self.addresses]
        if not omit_unset or "nativeResourcesId" in vars(self):
            out["nativeResourcesId"] = self.nativeResourcesId
        return out

class v1ResourcesStopped(Printable):
    """ResourcesStopped contains the information needed by tasks from container
    stopped.
    """
    failure: "typing.Optional[v1ResourcesFailure]" = None

    def __init__(
        self,
        *,
        failure: "typing.Union[v1ResourcesFailure, None, Unset]" = _unset,
    ):
        if not isinstance(failure, Unset):
            self.failure = failure

    @classmethod
    def from_json(cls, obj: Json) -> "v1ResourcesStopped":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "failure" in obj:
            kwargs["failure"] = v1ResourcesFailure.from_json(obj["failure"]) if obj["failure"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "failure" in vars(self):
            out["failure"] = None if self.failure is None else self.failure.to_json(omit_unset)
        return out

class v1ResourcesSummary(Printable):
    """ResourcesSummary provides a summary of the resources comprising what we know
    at the time the allocation is granted, but for k8s it is granted before being
    scheduled so it isn't really much and `agent_devices` are missing for k8s.
    """
    agentDevices: "typing.Optional[typing.Dict[str, ResourcesSummaryDevices]]" = None
    allocationId: "typing.Optional[str]" = None
    containerId: "typing.Optional[str]" = None
    exited: "typing.Optional[v1ResourcesStopped]" = None
    resourcesId: "typing.Optional[str]" = None
    resourcesType: "typing.Optional[str]" = None
    started: "typing.Optional[v1ResourcesStarted]" = None

    def __init__(
        self,
        *,
        agentDevices: "typing.Union[typing.Dict[str, ResourcesSummaryDevices], None, Unset]" = _unset,
        allocationId: "typing.Union[str, None, Unset]" = _unset,
        containerId: "typing.Union[str, None, Unset]" = _unset,
        exited: "typing.Union[v1ResourcesStopped, None, Unset]" = _unset,
        resourcesId: "typing.Union[str, None, Unset]" = _unset,
        resourcesType: "typing.Union[str, None, Unset]" = _unset,
        started: "typing.Union[v1ResourcesStarted, None, Unset]" = _unset,
    ):
        if not isinstance(agentDevices, Unset):
            self.agentDevices = agentDevices
        if not isinstance(allocationId, Unset):
            self.allocationId = allocationId
        if not isinstance(containerId, Unset):
            self.containerId = containerId
        if not isinstance(exited, Unset):
            self.exited = exited
        if not isinstance(resourcesId, Unset):
            self.resourcesId = resourcesId
        if not isinstance(resourcesType, Unset):
            self.resourcesType = resourcesType
        if not isinstance(started, Unset):
            self.started = started

    @classmethod
    def from_json(cls, obj: Json) -> "v1ResourcesSummary":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "agentDevices" in obj:
            kwargs["agentDevices"] = {k: ResourcesSummaryDevices.from_json(v) for k, v in obj["agentDevices"].items()} if obj["agentDevices"] is not None else None
        if "allocationId" in obj:
            kwargs["allocationId"] = obj["allocationId"]
        if "containerId" in obj:
            kwargs["containerId"] = obj["containerId"]
        if "exited" in obj:
            kwargs["exited"] = v1ResourcesStopped.from_json(obj["exited"]) if obj["exited"] is not None else None
        if "resourcesId" in obj:
            kwargs["resourcesId"] = obj["resourcesId"]
        if "resourcesType" in obj:
            kwargs["resourcesType"] = obj["resourcesType"]
        if "started" in obj:
            kwargs["started"] = v1ResourcesStarted.from_json(obj["started"]) if obj["started"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "agentDevices" in vars(self):
            out["agentDevices"] = None if self.agentDevices is None else {k: v.to_json(omit_unset) for k, v in self.agentDevices.items()}
        if not omit_unset or "allocationId" in vars(self):
            out["allocationId"] = self.allocationId
        if not omit_unset or "containerId" in vars(self):
            out["containerId"] = self.containerId
        if not omit_unset or "exited" in vars(self):
            out["exited"] = None if self.exited is None else self.exited.to_json(omit_unset)
        if not omit_unset or "resourcesId" in vars(self):
            out["resourcesId"] = self.resourcesId
        if not omit_unset or "resourcesType" in vars(self):
            out["resourcesType"] = self.resourcesType
        if not omit_unset or "started" in vars(self):
            out["started"] = None if self.started is None else self.started.to_json(omit_unset)
        return out

class v1ResumeRunsRequest(Printable):
    """Request to unpause the experiment associated witha run."""
    filter: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        projectId: int,
        runIds: "typing.Sequence[int]",
        filter: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.projectId = projectId
        self.runIds = runIds
        if not isinstance(filter, Unset):
            self.filter = filter

    @classmethod
    def from_json(cls, obj: Json) -> "v1ResumeRunsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "projectId": obj["projectId"],
            "runIds": obj["runIds"],
        }
        if "filter" in obj:
            kwargs["filter"] = obj["filter"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "projectId": self.projectId,
            "runIds": self.runIds,
        }
        if not omit_unset or "filter" in vars(self):
            out["filter"] = self.filter
        return out

class v1ResumeRunsResponse(Printable):
    """Response to ResumeRunsRequest."""

    def __init__(
        self,
        *,
        results: "typing.Sequence[v1RunActionResult]",
    ):
        self.results = results

    @classmethod
    def from_json(cls, obj: Json) -> "v1ResumeRunsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "results": [v1RunActionResult.from_json(x) for x in obj["results"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "results": [x.to_json(omit_unset) for x in self.results],
        }
        return out

class v1Role(Printable):
    name: "typing.Optional[str]" = None
    permissions: "typing.Optional[typing.Sequence[v1Permission]]" = None
    scopeTypeMask: "typing.Optional[v1ScopeTypeMask]" = None

    def __init__(
        self,
        *,
        roleId: int,
        name: "typing.Union[str, None, Unset]" = _unset,
        permissions: "typing.Union[typing.Sequence[v1Permission], None, Unset]" = _unset,
        scopeTypeMask: "typing.Union[v1ScopeTypeMask, None, Unset]" = _unset,
    ):
        self.roleId = roleId
        if not isinstance(name, Unset):
            self.name = name
        if not isinstance(permissions, Unset):
            self.permissions = permissions
        if not isinstance(scopeTypeMask, Unset):
            self.scopeTypeMask = scopeTypeMask

    @classmethod
    def from_json(cls, obj: Json) -> "v1Role":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "roleId": obj["roleId"],
        }
        if "name" in obj:
            kwargs["name"] = obj["name"]
        if "permissions" in obj:
            kwargs["permissions"] = [v1Permission.from_json(x) for x in obj["permissions"]] if obj["permissions"] is not None else None
        if "scopeTypeMask" in obj:
            kwargs["scopeTypeMask"] = v1ScopeTypeMask.from_json(obj["scopeTypeMask"]) if obj["scopeTypeMask"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "roleId": self.roleId,
        }
        if not omit_unset or "name" in vars(self):
            out["name"] = self.name
        if not omit_unset or "permissions" in vars(self):
            out["permissions"] = None if self.permissions is None else [x.to_json(omit_unset) for x in self.permissions]
        if not omit_unset or "scopeTypeMask" in vars(self):
            out["scopeTypeMask"] = None if self.scopeTypeMask is None else self.scopeTypeMask.to_json(omit_unset)
        return out

class v1RoleAssignment(Printable):
    """RoleAssignment contains information about the scope
    of the role.
    """
    scopeCluster: "typing.Optional[bool]" = None
    scopeWorkspaceId: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        role: "v1Role",
        scopeCluster: "typing.Union[bool, None, Unset]" = _unset,
        scopeWorkspaceId: "typing.Union[int, None, Unset]" = _unset,
    ):
        self.role = role
        if not isinstance(scopeCluster, Unset):
            self.scopeCluster = scopeCluster
        if not isinstance(scopeWorkspaceId, Unset):
            self.scopeWorkspaceId = scopeWorkspaceId

    @classmethod
    def from_json(cls, obj: Json) -> "v1RoleAssignment":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "role": v1Role.from_json(obj["role"]),
        }
        if "scopeCluster" in obj:
            kwargs["scopeCluster"] = obj["scopeCluster"]
        if "scopeWorkspaceId" in obj:
            kwargs["scopeWorkspaceId"] = obj["scopeWorkspaceId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "role": self.role.to_json(omit_unset),
        }
        if not omit_unset or "scopeCluster" in vars(self):
            out["scopeCluster"] = self.scopeCluster
        if not omit_unset or "scopeWorkspaceId" in vars(self):
            out["scopeWorkspaceId"] = self.scopeWorkspaceId
        return out

class v1RoleAssignmentSummary(Printable):
    """RoleAssignmentSummary is used to describe permissions a user has."""
    scopeCluster: "typing.Optional[bool]" = None
    scopeWorkspaceIds: "typing.Optional[typing.Sequence[int]]" = None

    def __init__(
        self,
        *,
        roleId: int,
        scopeCluster: "typing.Union[bool, None, Unset]" = _unset,
        scopeWorkspaceIds: "typing.Union[typing.Sequence[int], None, Unset]" = _unset,
    ):
        self.roleId = roleId
        if not isinstance(scopeCluster, Unset):
            self.scopeCluster = scopeCluster
        if not isinstance(scopeWorkspaceIds, Unset):
            self.scopeWorkspaceIds = scopeWorkspaceIds

    @classmethod
    def from_json(cls, obj: Json) -> "v1RoleAssignmentSummary":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "roleId": obj["roleId"],
        }
        if "scopeCluster" in obj:
            kwargs["scopeCluster"] = obj["scopeCluster"]
        if "scopeWorkspaceIds" in obj:
            kwargs["scopeWorkspaceIds"] = obj["scopeWorkspaceIds"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "roleId": self.roleId,
        }
        if not omit_unset or "scopeCluster" in vars(self):
            out["scopeCluster"] = self.scopeCluster
        if not omit_unset or "scopeWorkspaceIds" in vars(self):
            out["scopeWorkspaceIds"] = self.scopeWorkspaceIds
        return out

class v1RoleWithAssignments(Printable):
    """RoleWithAssignments contains a detailed description of
    a role and the groups and users belonging to it.
    """
    groupRoleAssignments: "typing.Optional[typing.Sequence[v1GroupRoleAssignment]]" = None
    role: "typing.Optional[v1Role]" = None
    userRoleAssignments: "typing.Optional[typing.Sequence[v1UserRoleAssignment]]" = None

    def __init__(
        self,
        *,
        groupRoleAssignments: "typing.Union[typing.Sequence[v1GroupRoleAssignment], None, Unset]" = _unset,
        role: "typing.Union[v1Role, None, Unset]" = _unset,
        userRoleAssignments: "typing.Union[typing.Sequence[v1UserRoleAssignment], None, Unset]" = _unset,
    ):
        if not isinstance(groupRoleAssignments, Unset):
            self.groupRoleAssignments = groupRoleAssignments
        if not isinstance(role, Unset):
            self.role = role
        if not isinstance(userRoleAssignments, Unset):
            self.userRoleAssignments = userRoleAssignments

    @classmethod
    def from_json(cls, obj: Json) -> "v1RoleWithAssignments":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "groupRoleAssignments" in obj:
            kwargs["groupRoleAssignments"] = [v1GroupRoleAssignment.from_json(x) for x in obj["groupRoleAssignments"]] if obj["groupRoleAssignments"] is not None else None
        if "role" in obj:
            kwargs["role"] = v1Role.from_json(obj["role"]) if obj["role"] is not None else None
        if "userRoleAssignments" in obj:
            kwargs["userRoleAssignments"] = [v1UserRoleAssignment.from_json(x) for x in obj["userRoleAssignments"]] if obj["userRoleAssignments"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "groupRoleAssignments" in vars(self):
            out["groupRoleAssignments"] = None if self.groupRoleAssignments is None else [x.to_json(omit_unset) for x in self.groupRoleAssignments]
        if not omit_unset or "role" in vars(self):
            out["role"] = None if self.role is None else self.role.to_json(omit_unset)
        if not omit_unset or "userRoleAssignments" in vars(self):
            out["userRoleAssignments"] = None if self.userRoleAssignments is None else [x.to_json(omit_unset) for x in self.userRoleAssignments]
        return out

class v1RunActionResult(Printable):
    """Message for results of individual runs in a multi-run action."""

    def __init__(
        self,
        *,
        error: str,
        id: int,
    ):
        self.error = error
        self.id = id

    @classmethod
    def from_json(cls, obj: Json) -> "v1RunActionResult":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "error": obj["error"],
            "id": obj["id"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "error": self.error,
            "id": self.id,
        }
        return out

class v1RunPrepareForReportingRequest(Printable):
    """Request to prepare to start reporting to a run."""
    checkpointStorage: "typing.Optional[typing.Dict[str, typing.Any]]" = None

    def __init__(
        self,
        *,
        runId: int,
        checkpointStorage: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
    ):
        self.runId = runId
        if not isinstance(checkpointStorage, Unset):
            self.checkpointStorage = checkpointStorage

    @classmethod
    def from_json(cls, obj: Json) -> "v1RunPrepareForReportingRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "runId": obj["runId"],
        }
        if "checkpointStorage" in obj:
            kwargs["checkpointStorage"] = obj["checkpointStorage"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "runId": self.runId,
        }
        if not omit_unset or "checkpointStorage" in vars(self):
            out["checkpointStorage"] = self.checkpointStorage
        return out

class v1RunPrepareForReportingResponse(Printable):
    """Response to prepare to start reporting to a run."""
    storageId: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        storageId: "typing.Union[int, None, Unset]" = _unset,
    ):
        if not isinstance(storageId, Unset):
            self.storageId = storageId

    @classmethod
    def from_json(cls, obj: Json) -> "v1RunPrepareForReportingResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "storageId" in obj:
            kwargs["storageId"] = obj["storageId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "storageId" in vars(self):
            out["storageId"] = self.storageId
        return out

class v1SSOProvider(Printable):
    """Describe one SSO provider."""
    alwaysRedirect: "typing.Optional[bool]" = None

    def __init__(
        self,
        *,
        name: str,
        ssoUrl: str,
        type: str,
        alwaysRedirect: "typing.Union[bool, None, Unset]" = _unset,
    ):
        self.name = name
        self.ssoUrl = ssoUrl
        self.type = type
        if not isinstance(alwaysRedirect, Unset):
            self.alwaysRedirect = alwaysRedirect

    @classmethod
    def from_json(cls, obj: Json) -> "v1SSOProvider":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "name": obj["name"],
            "ssoUrl": obj["ssoUrl"],
            "type": obj["type"],
        }
        if "alwaysRedirect" in obj:
            kwargs["alwaysRedirect"] = obj["alwaysRedirect"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "name": self.name,
            "ssoUrl": self.ssoUrl,
            "type": self.type,
        }
        if not omit_unset or "alwaysRedirect" in vars(self):
            out["alwaysRedirect"] = self.alwaysRedirect
        return out

class v1SchedulerType(DetEnum):
    """The type of the Scheduler.
    - SCHEDULER_TYPE_UNSPECIFIED: Unspecified. This value will never actually be returned by the API, it is
    just an artifact of using protobuf.
    - SCHEDULER_TYPE_PRIORITY: The priority scheduler.
    - SCHEDULER_TYPE_FAIR_SHARE: The fair share scheduler.
    - SCHEDULER_TYPE_ROUND_ROBIN: The round robin scheduler
    - SCHEDULER_TYPE_KUBERNETES: The kubernetes scheduler.
    - SCHEDULER_TYPE_SLURM: A slurm placeholder. When running on slurm, all scheduling behavior is
    delegated.
    - SCHEDULER_TYPE_PBS: A PBS placeholder. When running on PBS, all scheduling behavior is
    delegated.
    """
    UNSPECIFIED = "SCHEDULER_TYPE_UNSPECIFIED"
    PRIORITY = "SCHEDULER_TYPE_PRIORITY"
    FAIR_SHARE = "SCHEDULER_TYPE_FAIR_SHARE"
    ROUND_ROBIN = "SCHEDULER_TYPE_ROUND_ROBIN"
    KUBERNETES = "SCHEDULER_TYPE_KUBERNETES"
    SLURM = "SCHEDULER_TYPE_SLURM"
    PBS = "SCHEDULER_TYPE_PBS"

class v1ScopeTypeMask(Printable):
    cluster: "typing.Optional[bool]" = None
    workspace: "typing.Optional[bool]" = None

    def __init__(
        self,
        *,
        cluster: "typing.Union[bool, None, Unset]" = _unset,
        workspace: "typing.Union[bool, None, Unset]" = _unset,
    ):
        if not isinstance(cluster, Unset):
            self.cluster = cluster
        if not isinstance(workspace, Unset):
            self.workspace = workspace

    @classmethod
    def from_json(cls, obj: Json) -> "v1ScopeTypeMask":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "cluster" in obj:
            kwargs["cluster"] = obj["cluster"]
        if "workspace" in obj:
            kwargs["workspace"] = obj["workspace"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "cluster" in vars(self):
            out["cluster"] = self.cluster
        if not omit_unset or "workspace" in vars(self):
            out["workspace"] = self.workspace
        return out

class v1SearchExperimentExperiment(Printable):
    bestTrial: "typing.Optional[trialv1Trial]" = None

    def __init__(
        self,
        *,
        experiment: "v1Experiment",
        bestTrial: "typing.Union[trialv1Trial, None, Unset]" = _unset,
    ):
        self.experiment = experiment
        if not isinstance(bestTrial, Unset):
            self.bestTrial = bestTrial

    @classmethod
    def from_json(cls, obj: Json) -> "v1SearchExperimentExperiment":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "experiment": v1Experiment.from_json(obj["experiment"]),
        }
        if "bestTrial" in obj:
            kwargs["bestTrial"] = trialv1Trial.from_json(obj["bestTrial"]) if obj["bestTrial"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "experiment": self.experiment.to_json(omit_unset),
        }
        if not omit_unset or "bestTrial" in vars(self):
            out["bestTrial"] = None if self.bestTrial is None else self.bestTrial.to_json(omit_unset)
        return out

class v1SearchExperimentsRequest(Printable):
    filter: "typing.Optional[str]" = None
    limit: "typing.Optional[int]" = None
    offset: "typing.Optional[int]" = None
    projectId: "typing.Optional[int]" = None
    sort: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        filter: "typing.Union[str, None, Unset]" = _unset,
        limit: "typing.Union[int, None, Unset]" = _unset,
        offset: "typing.Union[int, None, Unset]" = _unset,
        projectId: "typing.Union[int, None, Unset]" = _unset,
        sort: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(filter, Unset):
            self.filter = filter
        if not isinstance(limit, Unset):
            self.limit = limit
        if not isinstance(offset, Unset):
            self.offset = offset
        if not isinstance(projectId, Unset):
            self.projectId = projectId
        if not isinstance(sort, Unset):
            self.sort = sort

    @classmethod
    def from_json(cls, obj: Json) -> "v1SearchExperimentsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "filter" in obj:
            kwargs["filter"] = obj["filter"]
        if "limit" in obj:
            kwargs["limit"] = obj["limit"]
        if "offset" in obj:
            kwargs["offset"] = obj["offset"]
        if "projectId" in obj:
            kwargs["projectId"] = obj["projectId"]
        if "sort" in obj:
            kwargs["sort"] = obj["sort"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "filter" in vars(self):
            out["filter"] = self.filter
        if not omit_unset or "limit" in vars(self):
            out["limit"] = self.limit
        if not omit_unset or "offset" in vars(self):
            out["offset"] = self.offset
        if not omit_unset or "projectId" in vars(self):
            out["projectId"] = self.projectId
        if not omit_unset or "sort" in vars(self):
            out["sort"] = self.sort
        return out

class v1SearchExperimentsResponse(Printable):

    def __init__(
        self,
        *,
        experiments: "typing.Sequence[v1SearchExperimentExperiment]",
        pagination: "v1Pagination",
    ):
        self.experiments = experiments
        self.pagination = pagination

    @classmethod
    def from_json(cls, obj: Json) -> "v1SearchExperimentsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "experiments": [v1SearchExperimentExperiment.from_json(x) for x in obj["experiments"]],
            "pagination": v1Pagination.from_json(obj["pagination"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "experiments": [x.to_json(omit_unset) for x in self.experiments],
            "pagination": self.pagination.to_json(omit_unset),
        }
        return out

class v1SearchRolesAssignableToScopeRequest(Printable):
    offset: "typing.Optional[int]" = None
    workspaceId: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        limit: int,
        offset: "typing.Union[int, None, Unset]" = _unset,
        workspaceId: "typing.Union[int, None, Unset]" = _unset,
    ):
        self.limit = limit
        if not isinstance(offset, Unset):
            self.offset = offset
        if not isinstance(workspaceId, Unset):
            self.workspaceId = workspaceId

    @classmethod
    def from_json(cls, obj: Json) -> "v1SearchRolesAssignableToScopeRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "limit": obj["limit"],
        }
        if "offset" in obj:
            kwargs["offset"] = obj["offset"]
        if "workspaceId" in obj:
            kwargs["workspaceId"] = obj["workspaceId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "limit": self.limit,
        }
        if not omit_unset or "offset" in vars(self):
            out["offset"] = self.offset
        if not omit_unset or "workspaceId" in vars(self):
            out["workspaceId"] = self.workspaceId
        return out

class v1SearchRolesAssignableToScopeResponse(Printable):
    pagination: "typing.Optional[v1Pagination]" = None
    roles: "typing.Optional[typing.Sequence[v1Role]]" = None

    def __init__(
        self,
        *,
        pagination: "typing.Union[v1Pagination, None, Unset]" = _unset,
        roles: "typing.Union[typing.Sequence[v1Role], None, Unset]" = _unset,
    ):
        if not isinstance(pagination, Unset):
            self.pagination = pagination
        if not isinstance(roles, Unset):
            self.roles = roles

    @classmethod
    def from_json(cls, obj: Json) -> "v1SearchRolesAssignableToScopeResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "pagination" in obj:
            kwargs["pagination"] = v1Pagination.from_json(obj["pagination"]) if obj["pagination"] is not None else None
        if "roles" in obj:
            kwargs["roles"] = [v1Role.from_json(x) for x in obj["roles"]] if obj["roles"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "pagination" in vars(self):
            out["pagination"] = None if self.pagination is None else self.pagination.to_json(omit_unset)
        if not omit_unset or "roles" in vars(self):
            out["roles"] = None if self.roles is None else [x.to_json(omit_unset) for x in self.roles]
        return out

class v1SearchRunsRequest(Printable):
    """Get a list of runs."""
    filter: "typing.Optional[str]" = None
    limit: "typing.Optional[int]" = None
    offset: "typing.Optional[int]" = None
    projectId: "typing.Optional[int]" = None
    sort: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        filter: "typing.Union[str, None, Unset]" = _unset,
        limit: "typing.Union[int, None, Unset]" = _unset,
        offset: "typing.Union[int, None, Unset]" = _unset,
        projectId: "typing.Union[int, None, Unset]" = _unset,
        sort: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(filter, Unset):
            self.filter = filter
        if not isinstance(limit, Unset):
            self.limit = limit
        if not isinstance(offset, Unset):
            self.offset = offset
        if not isinstance(projectId, Unset):
            self.projectId = projectId
        if not isinstance(sort, Unset):
            self.sort = sort

    @classmethod
    def from_json(cls, obj: Json) -> "v1SearchRunsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "filter" in obj:
            kwargs["filter"] = obj["filter"]
        if "limit" in obj:
            kwargs["limit"] = obj["limit"]
        if "offset" in obj:
            kwargs["offset"] = obj["offset"]
        if "projectId" in obj:
            kwargs["projectId"] = obj["projectId"]
        if "sort" in obj:
            kwargs["sort"] = obj["sort"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "filter" in vars(self):
            out["filter"] = self.filter
        if not omit_unset or "limit" in vars(self):
            out["limit"] = self.limit
        if not omit_unset or "offset" in vars(self):
            out["offset"] = self.offset
        if not omit_unset or "projectId" in vars(self):
            out["projectId"] = self.projectId
        if not omit_unset or "sort" in vars(self):
            out["sort"] = self.sort
        return out

class v1SearchRunsResponse(Printable):
    """Response to SearchRunsResponse."""

    def __init__(
        self,
        *,
        pagination: "v1Pagination",
        runs: "typing.Sequence[v1FlatRun]",
    ):
        self.pagination = pagination
        self.runs = runs

    @classmethod
    def from_json(cls, obj: Json) -> "v1SearchRunsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "pagination": v1Pagination.from_json(obj["pagination"]),
            "runs": [v1FlatRun.from_json(x) for x in obj["runs"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "pagination": self.pagination.to_json(omit_unset),
            "runs": [x.to_json(omit_unset) for x in self.runs],
        }
        return out

class v1SearchSummary(Printable):
    """SearchSummary contains the estimated trials and training lengths that a
    search plans to execute.
    """
    trials: "typing.Optional[typing.Sequence[v1TrialSummary]]" = None

    def __init__(
        self,
        *,
        config: "typing.Dict[str, typing.Any]",
        trials: "typing.Union[typing.Sequence[v1TrialSummary], None, Unset]" = _unset,
    ):
        self.config = config
        if not isinstance(trials, Unset):
            self.trials = trials

    @classmethod
    def from_json(cls, obj: Json) -> "v1SearchSummary":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "config": obj["config"],
        }
        if "trials" in obj:
            kwargs["trials"] = [v1TrialSummary.from_json(x) for x in obj["trials"]] if obj["trials"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "config": self.config,
        }
        if not omit_unset or "trials" in vars(self):
            out["trials"] = None if self.trials is None else [x.to_json(omit_unset) for x in self.trials]
        return out

class v1SearchUnit(Printable):
    """SearchUnit describes a length unit used by some searchers to manage training."""
    name: "typing.Optional[str]" = None
    value: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        maxLength: bool,
        name: "typing.Union[str, None, Unset]" = _unset,
        value: "typing.Union[int, None, Unset]" = _unset,
    ):
        self.maxLength = maxLength
        if not isinstance(name, Unset):
            self.name = name
        if not isinstance(value, Unset):
            self.value = value

    @classmethod
    def from_json(cls, obj: Json) -> "v1SearchUnit":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "maxLength": obj["maxLength"],
        }
        if "name" in obj:
            kwargs["name"] = obj["name"]
        if "value" in obj:
            kwargs["value"] = obj["value"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "maxLength": self.maxLength,
        }
        if not omit_unset or "name" in vars(self):
            out["name"] = self.name
        if not omit_unset or "value" in vars(self):
            out["value"] = self.value
        return out

class v1SetClusterMessageRequest(Printable):
    """Set the cluster-wide message."""
    duration: "typing.Optional[str]" = None
    endTime: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        message: str,
        startTime: str,
        duration: "typing.Union[str, None, Unset]" = _unset,
        endTime: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.message = message
        self.startTime = startTime
        if not isinstance(duration, Unset):
            self.duration = duration
        if not isinstance(endTime, Unset):
            self.endTime = endTime

    @classmethod
    def from_json(cls, obj: Json) -> "v1SetClusterMessageRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "message": obj["message"],
            "startTime": obj["startTime"],
        }
        if "duration" in obj:
            kwargs["duration"] = obj["duration"]
        if "endTime" in obj:
            kwargs["endTime"] = obj["endTime"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "message": self.message,
            "startTime": self.startTime,
        }
        if not omit_unset or "duration" in vars(self):
            out["duration"] = self.duration
        if not omit_unset or "endTime" in vars(self):
            out["endTime"] = self.endTime
        return out

class v1SetCommandPriorityRequest(Printable):
    """Set the priority of the requested command."""
    commandId: "typing.Optional[str]" = None
    priority: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        commandId: "typing.Union[str, None, Unset]" = _unset,
        priority: "typing.Union[int, None, Unset]" = _unset,
    ):
        if not isinstance(commandId, Unset):
            self.commandId = commandId
        if not isinstance(priority, Unset):
            self.priority = priority

    @classmethod
    def from_json(cls, obj: Json) -> "v1SetCommandPriorityRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "commandId" in obj:
            kwargs["commandId"] = obj["commandId"]
        if "priority" in obj:
            kwargs["priority"] = obj["priority"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "commandId" in vars(self):
            out["commandId"] = self.commandId
        if not omit_unset or "priority" in vars(self):
            out["priority"] = self.priority
        return out

class v1SetCommandPriorityResponse(Printable):
    """Response to SetCommandPriorityRequest."""
    command: "typing.Optional[v1Command]" = None

    def __init__(
        self,
        *,
        command: "typing.Union[v1Command, None, Unset]" = _unset,
    ):
        if not isinstance(command, Unset):
            self.command = command

    @classmethod
    def from_json(cls, obj: Json) -> "v1SetCommandPriorityResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "command" in obj:
            kwargs["command"] = v1Command.from_json(obj["command"]) if obj["command"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "command" in vars(self):
            out["command"] = None if self.command is None else self.command.to_json(omit_unset)
        return out

class v1SetNotebookPriorityRequest(Printable):
    """Set the priority of the requested notebook."""
    notebookId: "typing.Optional[str]" = None
    priority: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        notebookId: "typing.Union[str, None, Unset]" = _unset,
        priority: "typing.Union[int, None, Unset]" = _unset,
    ):
        if not isinstance(notebookId, Unset):
            self.notebookId = notebookId
        if not isinstance(priority, Unset):
            self.priority = priority

    @classmethod
    def from_json(cls, obj: Json) -> "v1SetNotebookPriorityRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "notebookId" in obj:
            kwargs["notebookId"] = obj["notebookId"]
        if "priority" in obj:
            kwargs["priority"] = obj["priority"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "notebookId" in vars(self):
            out["notebookId"] = self.notebookId
        if not omit_unset or "priority" in vars(self):
            out["priority"] = self.priority
        return out

class v1SetNotebookPriorityResponse(Printable):
    """Response to SetNotebookPriorityRequest."""
    notebook: "typing.Optional[v1Notebook]" = None

    def __init__(
        self,
        *,
        notebook: "typing.Union[v1Notebook, None, Unset]" = _unset,
    ):
        if not isinstance(notebook, Unset):
            self.notebook = notebook

    @classmethod
    def from_json(cls, obj: Json) -> "v1SetNotebookPriorityResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "notebook" in obj:
            kwargs["notebook"] = v1Notebook.from_json(obj["notebook"]) if obj["notebook"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "notebook" in vars(self):
            out["notebook"] = None if self.notebook is None else self.notebook.to_json(omit_unset)
        return out

class v1SetResourceQuotasRequest(Printable):
    """Request to set a resource quota on a workspace (for a specific cluster)."""
    clusterQuotaPairs: "typing.Optional[typing.Dict[str, int]]" = None

    def __init__(
        self,
        *,
        id: int,
        clusterQuotaPairs: "typing.Union[typing.Dict[str, int], None, Unset]" = _unset,
    ):
        self.id = id
        if not isinstance(clusterQuotaPairs, Unset):
            self.clusterQuotaPairs = clusterQuotaPairs

    @classmethod
    def from_json(cls, obj: Json) -> "v1SetResourceQuotasRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "id": obj["id"],
        }
        if "clusterQuotaPairs" in obj:
            kwargs["clusterQuotaPairs"] = obj["clusterQuotaPairs"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "id": self.id,
        }
        if not omit_unset or "clusterQuotaPairs" in vars(self):
            out["clusterQuotaPairs"] = self.clusterQuotaPairs
        return out

class v1SetShellPriorityRequest(Printable):
    """Set the priority of the requested shell."""
    priority: "typing.Optional[int]" = None
    shellId: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        priority: "typing.Union[int, None, Unset]" = _unset,
        shellId: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(priority, Unset):
            self.priority = priority
        if not isinstance(shellId, Unset):
            self.shellId = shellId

    @classmethod
    def from_json(cls, obj: Json) -> "v1SetShellPriorityRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "priority" in obj:
            kwargs["priority"] = obj["priority"]
        if "shellId" in obj:
            kwargs["shellId"] = obj["shellId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "priority" in vars(self):
            out["priority"] = self.priority
        if not omit_unset or "shellId" in vars(self):
            out["shellId"] = self.shellId
        return out

class v1SetShellPriorityResponse(Printable):
    """Response to SetShellPriorityRequest."""
    shell: "typing.Optional[v1Shell]" = None

    def __init__(
        self,
        *,
        shell: "typing.Union[v1Shell, None, Unset]" = _unset,
    ):
        if not isinstance(shell, Unset):
            self.shell = shell

    @classmethod
    def from_json(cls, obj: Json) -> "v1SetShellPriorityResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "shell" in obj:
            kwargs["shell"] = v1Shell.from_json(obj["shell"]) if obj["shell"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "shell" in vars(self):
            out["shell"] = None if self.shell is None else self.shell.to_json(omit_unset)
        return out

class v1SetTensorboardPriorityRequest(Printable):
    """Set the priority of the requested TensorBoard."""
    priority: "typing.Optional[int]" = None
    tensorboardId: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        priority: "typing.Union[int, None, Unset]" = _unset,
        tensorboardId: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(priority, Unset):
            self.priority = priority
        if not isinstance(tensorboardId, Unset):
            self.tensorboardId = tensorboardId

    @classmethod
    def from_json(cls, obj: Json) -> "v1SetTensorboardPriorityRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "priority" in obj:
            kwargs["priority"] = obj["priority"]
        if "tensorboardId" in obj:
            kwargs["tensorboardId"] = obj["tensorboardId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "priority" in vars(self):
            out["priority"] = self.priority
        if not omit_unset or "tensorboardId" in vars(self):
            out["tensorboardId"] = self.tensorboardId
        return out

class v1SetTensorboardPriorityResponse(Printable):
    """Response to SetTensorboardPriorityRequest."""
    tensorboard: "typing.Optional[v1Tensorboard]" = None

    def __init__(
        self,
        *,
        tensorboard: "typing.Union[v1Tensorboard, None, Unset]" = _unset,
    ):
        if not isinstance(tensorboard, Unset):
            self.tensorboard = tensorboard

    @classmethod
    def from_json(cls, obj: Json) -> "v1SetTensorboardPriorityResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "tensorboard" in obj:
            kwargs["tensorboard"] = v1Tensorboard.from_json(obj["tensorboard"]) if obj["tensorboard"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "tensorboard" in vars(self):
            out["tensorboard"] = None if self.tensorboard is None else self.tensorboard.to_json(omit_unset)
        return out

class v1SetUserPasswordResponse(Printable):
    """Response to SetUserPasswordRequest."""
    user: "typing.Optional[v1User]" = None

    def __init__(
        self,
        *,
        user: "typing.Union[v1User, None, Unset]" = _unset,
    ):
        if not isinstance(user, Unset):
            self.user = user

    @classmethod
    def from_json(cls, obj: Json) -> "v1SetUserPasswordResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "user" in obj:
            kwargs["user"] = v1User.from_json(obj["user"]) if obj["user"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "user" in vars(self):
            out["user"] = None if self.user is None else self.user.to_json(omit_unset)
        return out

class v1SetWorkspaceNamespaceBindingsRequest(Printable):
    """Request for setting workspace-namespace bindings."""
    clusterNamespaceMeta: "typing.Optional[typing.Dict[str, v1WorkspaceNamespaceMeta]]" = None

    def __init__(
        self,
        *,
        workspaceId: int,
        clusterNamespaceMeta: "typing.Union[typing.Dict[str, v1WorkspaceNamespaceMeta], None, Unset]" = _unset,
    ):
        self.workspaceId = workspaceId
        if not isinstance(clusterNamespaceMeta, Unset):
            self.clusterNamespaceMeta = clusterNamespaceMeta

    @classmethod
    def from_json(cls, obj: Json) -> "v1SetWorkspaceNamespaceBindingsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "workspaceId": obj["workspaceId"],
        }
        if "clusterNamespaceMeta" in obj:
            kwargs["clusterNamespaceMeta"] = {k: v1WorkspaceNamespaceMeta.from_json(v) for k, v in obj["clusterNamespaceMeta"].items()} if obj["clusterNamespaceMeta"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "workspaceId": self.workspaceId,
        }
        if not omit_unset or "clusterNamespaceMeta" in vars(self):
            out["clusterNamespaceMeta"] = None if self.clusterNamespaceMeta is None else {k: v.to_json(omit_unset) for k, v in self.clusterNamespaceMeta.items()}
        return out

class v1SetWorkspaceNamespaceBindingsResponse(Printable):
    """Response for setting workspace-namespace bindings."""

    def __init__(
        self,
        *,
        namespaceBindings: "typing.Dict[str, v1WorkspaceNamespaceBinding]",
    ):
        self.namespaceBindings = namespaceBindings

    @classmethod
    def from_json(cls, obj: Json) -> "v1SetWorkspaceNamespaceBindingsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "namespaceBindings": {k: v1WorkspaceNamespaceBinding.from_json(v) for k, v in obj["namespaceBindings"].items()},
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "namespaceBindings": {k: v.to_json(omit_unset) for k, v in self.namespaceBindings.items()},
        }
        return out

class v1Shell(Printable):
    """Shell is an ssh server in a containerized environment."""
    addresses: "typing.Optional[typing.Sequence[typing.Dict[str, typing.Any]]]" = None
    agentUserGroup: "typing.Optional[typing.Dict[str, typing.Any]]" = None
    container: "typing.Optional[v1Container]" = None
    displayName: "typing.Optional[str]" = None
    exitStatus: "typing.Optional[str]" = None
    privateKey: "typing.Optional[str]" = None
    publicKey: "typing.Optional[str]" = None
    userId: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        description: str,
        id: str,
        jobId: str,
        resourcePool: str,
        startTime: str,
        state: "taskv1State",
        username: str,
        workspaceId: int,
        addresses: "typing.Union[typing.Sequence[typing.Dict[str, typing.Any]], None, Unset]" = _unset,
        agentUserGroup: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
        container: "typing.Union[v1Container, None, Unset]" = _unset,
        displayName: "typing.Union[str, None, Unset]" = _unset,
        exitStatus: "typing.Union[str, None, Unset]" = _unset,
        privateKey: "typing.Union[str, None, Unset]" = _unset,
        publicKey: "typing.Union[str, None, Unset]" = _unset,
        userId: "typing.Union[int, None, Unset]" = _unset,
    ):
        self.description = description
        self.id = id
        self.jobId = jobId
        self.resourcePool = resourcePool
        self.startTime = startTime
        self.state = state
        self.username = username
        self.workspaceId = workspaceId
        if not isinstance(addresses, Unset):
            self.addresses = addresses
        if not isinstance(agentUserGroup, Unset):
            self.agentUserGroup = agentUserGroup
        if not isinstance(container, Unset):
            self.container = container
        if not isinstance(displayName, Unset):
            self.displayName = displayName
        if not isinstance(exitStatus, Unset):
            self.exitStatus = exitStatus
        if not isinstance(privateKey, Unset):
            self.privateKey = privateKey
        if not isinstance(publicKey, Unset):
            self.publicKey = publicKey
        if not isinstance(userId, Unset):
            self.userId = userId

    @classmethod
    def from_json(cls, obj: Json) -> "v1Shell":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "description": obj["description"],
            "id": obj["id"],
            "jobId": obj["jobId"],
            "resourcePool": obj["resourcePool"],
            "startTime": obj["startTime"],
            "state": taskv1State(obj["state"]),
            "username": obj["username"],
            "workspaceId": obj["workspaceId"],
        }
        if "addresses" in obj:
            kwargs["addresses"] = obj["addresses"]
        if "agentUserGroup" in obj:
            kwargs["agentUserGroup"] = obj["agentUserGroup"]
        if "container" in obj:
            kwargs["container"] = v1Container.from_json(obj["container"]) if obj["container"] is not None else None
        if "displayName" in obj:
            kwargs["displayName"] = obj["displayName"]
        if "exitStatus" in obj:
            kwargs["exitStatus"] = obj["exitStatus"]
        if "privateKey" in obj:
            kwargs["privateKey"] = obj["privateKey"]
        if "publicKey" in obj:
            kwargs["publicKey"] = obj["publicKey"]
        if "userId" in obj:
            kwargs["userId"] = obj["userId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "description": self.description,
            "id": self.id,
            "jobId": self.jobId,
            "resourcePool": self.resourcePool,
            "startTime": self.startTime,
            "state": self.state.value,
            "username": self.username,
            "workspaceId": self.workspaceId,
        }
        if not omit_unset or "addresses" in vars(self):
            out["addresses"] = self.addresses
        if not omit_unset or "agentUserGroup" in vars(self):
            out["agentUserGroup"] = self.agentUserGroup
        if not omit_unset or "container" in vars(self):
            out["container"] = None if self.container is None else self.container.to_json(omit_unset)
        if not omit_unset or "displayName" in vars(self):
            out["displayName"] = self.displayName
        if not omit_unset or "exitStatus" in vars(self):
            out["exitStatus"] = self.exitStatus
        if not omit_unset or "privateKey" in vars(self):
            out["privateKey"] = self.privateKey
        if not omit_unset or "publicKey" in vars(self):
            out["publicKey"] = self.publicKey
        if not omit_unset or "userId" in vars(self):
            out["userId"] = self.userId
        return out

class v1Slot(Printable):
    """Slot wraps a single device on the agent."""
    container: "typing.Optional[v1Container]" = None
    device: "typing.Optional[v1Device]" = None
    draining: "typing.Optional[bool]" = None
    enabled: "typing.Optional[bool]" = None
    id: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        container: "typing.Union[v1Container, None, Unset]" = _unset,
        device: "typing.Union[v1Device, None, Unset]" = _unset,
        draining: "typing.Union[bool, None, Unset]" = _unset,
        enabled: "typing.Union[bool, None, Unset]" = _unset,
        id: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(container, Unset):
            self.container = container
        if not isinstance(device, Unset):
            self.device = device
        if not isinstance(draining, Unset):
            self.draining = draining
        if not isinstance(enabled, Unset):
            self.enabled = enabled
        if not isinstance(id, Unset):
            self.id = id

    @classmethod
    def from_json(cls, obj: Json) -> "v1Slot":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "container" in obj:
            kwargs["container"] = v1Container.from_json(obj["container"]) if obj["container"] is not None else None
        if "device" in obj:
            kwargs["device"] = v1Device.from_json(obj["device"]) if obj["device"] is not None else None
        if "draining" in obj:
            kwargs["draining"] = obj["draining"]
        if "enabled" in obj:
            kwargs["enabled"] = obj["enabled"]
        if "id" in obj:
            kwargs["id"] = obj["id"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "container" in vars(self):
            out["container"] = None if self.container is None else self.container.to_json(omit_unset)
        if not omit_unset or "device" in vars(self):
            out["device"] = None if self.device is None else self.device.to_json(omit_unset)
        if not omit_unset or "draining" in vars(self):
            out["draining"] = self.draining
        if not omit_unset or "enabled" in vars(self):
            out["enabled"] = self.enabled
        if not omit_unset or "id" in vars(self):
            out["id"] = self.id
        return out

class v1SlotStats(Printable):
    """SlotStats contains statistics about a set of slots."""

    def __init__(
        self,
        *,
        brandStats: "typing.Dict[str, v1DeviceStats]",
        typeStats: "typing.Dict[str, v1DeviceStats]",
    ):
        self.brandStats = brandStats
        self.typeStats = typeStats

    @classmethod
    def from_json(cls, obj: Json) -> "v1SlotStats":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "brandStats": {k: v1DeviceStats.from_json(v) for k, v in obj["brandStats"].items()},
            "typeStats": {k: v1DeviceStats.from_json(v) for k, v in obj["typeStats"].items()},
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "brandStats": {k: v.to_json(omit_unset) for k, v in self.brandStats.items()},
            "typeStats": {k: v.to_json(omit_unset) for k, v in self.typeStats.items()},
        }
        return out

class v1StartTrialRequest(Printable):
    """Start a trial."""
    resume: "typing.Optional[bool]" = None

    def __init__(
        self,
        *,
        trialId: int,
        resume: "typing.Union[bool, None, Unset]" = _unset,
    ):
        self.trialId = trialId
        if not isinstance(resume, Unset):
            self.resume = resume

    @classmethod
    def from_json(cls, obj: Json) -> "v1StartTrialRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "trialId": obj["trialId"],
        }
        if "resume" in obj:
            kwargs["resume"] = obj["resume"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "trialId": self.trialId,
        }
        if not omit_unset or "resume" in vars(self):
            out["resume"] = self.resume
        return out

class v1StartTrialResponse(Printable):
    """Response to StartTrialRequest."""
    latestCheckpoint: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        stepsCompleted: int,
        trialRunId: int,
        latestCheckpoint: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.stepsCompleted = stepsCompleted
        self.trialRunId = trialRunId
        if not isinstance(latestCheckpoint, Unset):
            self.latestCheckpoint = latestCheckpoint

    @classmethod
    def from_json(cls, obj: Json) -> "v1StartTrialResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "stepsCompleted": obj["stepsCompleted"],
            "trialRunId": obj["trialRunId"],
        }
        if "latestCheckpoint" in obj:
            kwargs["latestCheckpoint"] = obj["latestCheckpoint"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "stepsCompleted": self.stepsCompleted,
            "trialRunId": self.trialRunId,
        }
        if not omit_unset or "latestCheckpoint" in vars(self):
            out["latestCheckpoint"] = self.latestCheckpoint
        return out

class v1TableType(DetEnum):
    """Project Table type.
    - TABLE_TYPE_UNSPECIFIED: Unspecified table type.
    - TABLE_TYPE_EXPERIMENT: experiment table.
    - TABLE_TYPE_RUN: run table.
    """
    UNSPECIFIED = "TABLE_TYPE_UNSPECIFIED"
    EXPERIMENT = "TABLE_TYPE_EXPERIMENT"
    RUN = "TABLE_TYPE_RUN"

class v1Task(Printable):
    """Task is the model for a task in the database."""
    config: "typing.Optional[str]" = None
    endTime: "typing.Optional[str]" = None
    forkedFrom: "typing.Optional[str]" = None
    noPause: "typing.Optional[bool]" = None
    parentId: "typing.Optional[str]" = None
    taskState: "typing.Optional[v1GenericTaskState]" = None

    def __init__(
        self,
        *,
        allocations: "typing.Sequence[v1Allocation]",
        startTime: str,
        taskId: str,
        taskType: "v1TaskType",
        config: "typing.Union[str, None, Unset]" = _unset,
        endTime: "typing.Union[str, None, Unset]" = _unset,
        forkedFrom: "typing.Union[str, None, Unset]" = _unset,
        noPause: "typing.Union[bool, None, Unset]" = _unset,
        parentId: "typing.Union[str, None, Unset]" = _unset,
        taskState: "typing.Union[v1GenericTaskState, None, Unset]" = _unset,
    ):
        self.allocations = allocations
        self.startTime = startTime
        self.taskId = taskId
        self.taskType = taskType
        if not isinstance(config, Unset):
            self.config = config
        if not isinstance(endTime, Unset):
            self.endTime = endTime
        if not isinstance(forkedFrom, Unset):
            self.forkedFrom = forkedFrom
        if not isinstance(noPause, Unset):
            self.noPause = noPause
        if not isinstance(parentId, Unset):
            self.parentId = parentId
        if not isinstance(taskState, Unset):
            self.taskState = taskState

    @classmethod
    def from_json(cls, obj: Json) -> "v1Task":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "allocations": [v1Allocation.from_json(x) for x in obj["allocations"]],
            "startTime": obj["startTime"],
            "taskId": obj["taskId"],
            "taskType": v1TaskType(obj["taskType"]),
        }
        if "config" in obj:
            kwargs["config"] = obj["config"]
        if "endTime" in obj:
            kwargs["endTime"] = obj["endTime"]
        if "forkedFrom" in obj:
            kwargs["forkedFrom"] = obj["forkedFrom"]
        if "noPause" in obj:
            kwargs["noPause"] = obj["noPause"]
        if "parentId" in obj:
            kwargs["parentId"] = obj["parentId"]
        if "taskState" in obj:
            kwargs["taskState"] = v1GenericTaskState(obj["taskState"]) if obj["taskState"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "allocations": [x.to_json(omit_unset) for x in self.allocations],
            "startTime": self.startTime,
            "taskId": self.taskId,
            "taskType": self.taskType.value,
        }
        if not omit_unset or "config" in vars(self):
            out["config"] = self.config
        if not omit_unset or "endTime" in vars(self):
            out["endTime"] = self.endTime
        if not omit_unset or "forkedFrom" in vars(self):
            out["forkedFrom"] = self.forkedFrom
        if not omit_unset or "noPause" in vars(self):
            out["noPause"] = self.noPause
        if not omit_unset or "parentId" in vars(self):
            out["parentId"] = self.parentId
        if not omit_unset or "taskState" in vars(self):
            out["taskState"] = None if self.taskState is None else self.taskState.value
        return out

class v1TaskLog(Printable):
    agentId: "typing.Optional[str]" = None
    allocationId: "typing.Optional[str]" = None
    containerId: "typing.Optional[str]" = None
    id: "typing.Optional[int]" = None
    level: "typing.Optional[v1LogLevel]" = None
    rankId: "typing.Optional[int]" = None
    source: "typing.Optional[str]" = None
    stdtype: "typing.Optional[str]" = None
    timestamp: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        log: str,
        taskId: str,
        agentId: "typing.Union[str, None, Unset]" = _unset,
        allocationId: "typing.Union[str, None, Unset]" = _unset,
        containerId: "typing.Union[str, None, Unset]" = _unset,
        id: "typing.Union[int, None, Unset]" = _unset,
        level: "typing.Union[v1LogLevel, None, Unset]" = _unset,
        rankId: "typing.Union[int, None, Unset]" = _unset,
        source: "typing.Union[str, None, Unset]" = _unset,
        stdtype: "typing.Union[str, None, Unset]" = _unset,
        timestamp: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.log = log
        self.taskId = taskId
        if not isinstance(agentId, Unset):
            self.agentId = agentId
        if not isinstance(allocationId, Unset):
            self.allocationId = allocationId
        if not isinstance(containerId, Unset):
            self.containerId = containerId
        if not isinstance(id, Unset):
            self.id = id
        if not isinstance(level, Unset):
            self.level = level
        if not isinstance(rankId, Unset):
            self.rankId = rankId
        if not isinstance(source, Unset):
            self.source = source
        if not isinstance(stdtype, Unset):
            self.stdtype = stdtype
        if not isinstance(timestamp, Unset):
            self.timestamp = timestamp

    @classmethod
    def from_json(cls, obj: Json) -> "v1TaskLog":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "log": obj["log"],
            "taskId": obj["taskId"],
        }
        if "agentId" in obj:
            kwargs["agentId"] = obj["agentId"]
        if "allocationId" in obj:
            kwargs["allocationId"] = obj["allocationId"]
        if "containerId" in obj:
            kwargs["containerId"] = obj["containerId"]
        if "id" in obj:
            kwargs["id"] = obj["id"]
        if "level" in obj:
            kwargs["level"] = v1LogLevel(obj["level"]) if obj["level"] is not None else None
        if "rankId" in obj:
            kwargs["rankId"] = obj["rankId"]
        if "source" in obj:
            kwargs["source"] = obj["source"]
        if "stdtype" in obj:
            kwargs["stdtype"] = obj["stdtype"]
        if "timestamp" in obj:
            kwargs["timestamp"] = obj["timestamp"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "log": self.log,
            "taskId": self.taskId,
        }
        if not omit_unset or "agentId" in vars(self):
            out["agentId"] = self.agentId
        if not omit_unset or "allocationId" in vars(self):
            out["allocationId"] = self.allocationId
        if not omit_unset or "containerId" in vars(self):
            out["containerId"] = self.containerId
        if not omit_unset or "id" in vars(self):
            out["id"] = self.id
        if not omit_unset or "level" in vars(self):
            out["level"] = None if self.level is None else self.level.value
        if not omit_unset or "rankId" in vars(self):
            out["rankId"] = self.rankId
        if not omit_unset or "source" in vars(self):
            out["source"] = self.source
        if not omit_unset or "stdtype" in vars(self):
            out["stdtype"] = self.stdtype
        if not omit_unset or "timestamp" in vars(self):
            out["timestamp"] = self.timestamp
        return out

class v1TaskLogsFieldsResponse(Printable):
    """Response to TaskLogsFieldsRequest."""
    agentIds: "typing.Optional[typing.Sequence[str]]" = None
    allocationIds: "typing.Optional[typing.Sequence[str]]" = None
    containerIds: "typing.Optional[typing.Sequence[str]]" = None
    rankIds: "typing.Optional[typing.Sequence[int]]" = None
    sources: "typing.Optional[typing.Sequence[str]]" = None
    stdtypes: "typing.Optional[typing.Sequence[str]]" = None

    def __init__(
        self,
        *,
        agentIds: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
        allocationIds: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
        containerIds: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
        rankIds: "typing.Union[typing.Sequence[int], None, Unset]" = _unset,
        sources: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
        stdtypes: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
    ):
        if not isinstance(agentIds, Unset):
            self.agentIds = agentIds
        if not isinstance(allocationIds, Unset):
            self.allocationIds = allocationIds
        if not isinstance(containerIds, Unset):
            self.containerIds = containerIds
        if not isinstance(rankIds, Unset):
            self.rankIds = rankIds
        if not isinstance(sources, Unset):
            self.sources = sources
        if not isinstance(stdtypes, Unset):
            self.stdtypes = stdtypes

    @classmethod
    def from_json(cls, obj: Json) -> "v1TaskLogsFieldsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "agentIds" in obj:
            kwargs["agentIds"] = obj["agentIds"]
        if "allocationIds" in obj:
            kwargs["allocationIds"] = obj["allocationIds"]
        if "containerIds" in obj:
            kwargs["containerIds"] = obj["containerIds"]
        if "rankIds" in obj:
            kwargs["rankIds"] = obj["rankIds"]
        if "sources" in obj:
            kwargs["sources"] = obj["sources"]
        if "stdtypes" in obj:
            kwargs["stdtypes"] = obj["stdtypes"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "agentIds" in vars(self):
            out["agentIds"] = self.agentIds
        if not omit_unset or "allocationIds" in vars(self):
            out["allocationIds"] = self.allocationIds
        if not omit_unset or "containerIds" in vars(self):
            out["containerIds"] = self.containerIds
        if not omit_unset or "rankIds" in vars(self):
            out["rankIds"] = self.rankIds
        if not omit_unset or "sources" in vars(self):
            out["sources"] = self.sources
        if not omit_unset or "stdtypes" in vars(self):
            out["stdtypes"] = self.stdtypes
        return out

class v1TaskLogsResponse(Printable):
    """Response to TaskLogsRequest."""
    agentId: "typing.Optional[str]" = None
    allocationId: "typing.Optional[str]" = None
    containerId: "typing.Optional[str]" = None
    rankId: "typing.Optional[int]" = None
    source: "typing.Optional[str]" = None
    stdtype: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        id: str,
        level: "v1LogLevel",
        log: str,
        message: str,
        taskId: str,
        timestamp: str,
        agentId: "typing.Union[str, None, Unset]" = _unset,
        allocationId: "typing.Union[str, None, Unset]" = _unset,
        containerId: "typing.Union[str, None, Unset]" = _unset,
        rankId: "typing.Union[int, None, Unset]" = _unset,
        source: "typing.Union[str, None, Unset]" = _unset,
        stdtype: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.id = id
        self.level = level
        self.log = log
        self.message = message
        self.taskId = taskId
        self.timestamp = timestamp
        if not isinstance(agentId, Unset):
            self.agentId = agentId
        if not isinstance(allocationId, Unset):
            self.allocationId = allocationId
        if not isinstance(containerId, Unset):
            self.containerId = containerId
        if not isinstance(rankId, Unset):
            self.rankId = rankId
        if not isinstance(source, Unset):
            self.source = source
        if not isinstance(stdtype, Unset):
            self.stdtype = stdtype

    @classmethod
    def from_json(cls, obj: Json) -> "v1TaskLogsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "id": obj["id"],
            "level": v1LogLevel(obj["level"]),
            "log": obj["log"],
            "message": obj["message"],
            "taskId": obj["taskId"],
            "timestamp": obj["timestamp"],
        }
        if "agentId" in obj:
            kwargs["agentId"] = obj["agentId"]
        if "allocationId" in obj:
            kwargs["allocationId"] = obj["allocationId"]
        if "containerId" in obj:
            kwargs["containerId"] = obj["containerId"]
        if "rankId" in obj:
            kwargs["rankId"] = obj["rankId"]
        if "source" in obj:
            kwargs["source"] = obj["source"]
        if "stdtype" in obj:
            kwargs["stdtype"] = obj["stdtype"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "id": self.id,
            "level": self.level.value,
            "log": self.log,
            "message": self.message,
            "taskId": self.taskId,
            "timestamp": self.timestamp,
        }
        if not omit_unset or "agentId" in vars(self):
            out["agentId"] = self.agentId
        if not omit_unset or "allocationId" in vars(self):
            out["allocationId"] = self.allocationId
        if not omit_unset or "containerId" in vars(self):
            out["containerId"] = self.containerId
        if not omit_unset or "rankId" in vars(self):
            out["rankId"] = self.rankId
        if not omit_unset or "source" in vars(self):
            out["source"] = self.source
        if not omit_unset or "stdtype" in vars(self):
            out["stdtype"] = self.stdtype
        return out

class v1TaskType(DetEnum):
    """Type of the task
    - TASK_TYPE_UNSPECIFIED: The task type is unknown
    - TASK_TYPE_TRIAL: "TRIAL" task type for the enum public.task_type in Postgres.
    - TASK_TYPE_NOTEBOOK: "NOTEBOOK" task type for the enum public.task_type in Postgres.
    - TASK_TYPE_SHELL: "SHELL" task type for the enum public.task_type in Postgres.
    - TASK_TYPE_COMMAND: "COMMAND" task type for the enum public.task_type in Postgres.
    - TASK_TYPE_TENSORBOARD: "TENSORBOARD" task type for the enum public.task_type in Postgres.
    - TASK_TYPE_CHECKPOINT_GC: "CHECKPOINT_GC" task type for the enum public.task_type in Postgres.
    - TASK_TYPE_GENERIC: "GENERIC" task type for the enum public.task_type in Postgres.
    """
    UNSPECIFIED = "TASK_TYPE_UNSPECIFIED"
    TRIAL = "TASK_TYPE_TRIAL"
    NOTEBOOK = "TASK_TYPE_NOTEBOOK"
    SHELL = "TASK_TYPE_SHELL"
    COMMAND = "TASK_TYPE_COMMAND"
    TENSORBOARD = "TASK_TYPE_TENSORBOARD"
    CHECKPOINT_GC = "TASK_TYPE_CHECKPOINT_GC"
    GENERIC = "TASK_TYPE_GENERIC"

class v1Template(Printable):
    """Templates move settings that are shared by many experiments into a single
    YAML file.
    """

    def __init__(
        self,
        *,
        config: "typing.Dict[str, typing.Any]",
        name: str,
        workspaceId: int,
    ):
        self.config = config
        self.name = name
        self.workspaceId = workspaceId

    @classmethod
    def from_json(cls, obj: Json) -> "v1Template":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "config": obj["config"],
            "name": obj["name"],
            "workspaceId": obj["workspaceId"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "config": self.config,
            "name": self.name,
            "workspaceId": self.workspaceId,
        }
        return out

class v1Tensorboard(Printable):
    """Tensorboard is a tensorboard instance in a containerized environment."""
    container: "typing.Optional[v1Container]" = None
    displayName: "typing.Optional[str]" = None
    exitStatus: "typing.Optional[str]" = None
    experimentIds: "typing.Optional[typing.Sequence[int]]" = None
    serviceAddress: "typing.Optional[str]" = None
    trialIds: "typing.Optional[typing.Sequence[int]]" = None
    userId: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        description: str,
        id: str,
        jobId: str,
        resourcePool: str,
        startTime: str,
        state: "taskv1State",
        username: str,
        workspaceId: int,
        container: "typing.Union[v1Container, None, Unset]" = _unset,
        displayName: "typing.Union[str, None, Unset]" = _unset,
        exitStatus: "typing.Union[str, None, Unset]" = _unset,
        experimentIds: "typing.Union[typing.Sequence[int], None, Unset]" = _unset,
        serviceAddress: "typing.Union[str, None, Unset]" = _unset,
        trialIds: "typing.Union[typing.Sequence[int], None, Unset]" = _unset,
        userId: "typing.Union[int, None, Unset]" = _unset,
    ):
        self.description = description
        self.id = id
        self.jobId = jobId
        self.resourcePool = resourcePool
        self.startTime = startTime
        self.state = state
        self.username = username
        self.workspaceId = workspaceId
        if not isinstance(container, Unset):
            self.container = container
        if not isinstance(displayName, Unset):
            self.displayName = displayName
        if not isinstance(exitStatus, Unset):
            self.exitStatus = exitStatus
        if not isinstance(experimentIds, Unset):
            self.experimentIds = experimentIds
        if not isinstance(serviceAddress, Unset):
            self.serviceAddress = serviceAddress
        if not isinstance(trialIds, Unset):
            self.trialIds = trialIds
        if not isinstance(userId, Unset):
            self.userId = userId

    @classmethod
    def from_json(cls, obj: Json) -> "v1Tensorboard":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "description": obj["description"],
            "id": obj["id"],
            "jobId": obj["jobId"],
            "resourcePool": obj["resourcePool"],
            "startTime": obj["startTime"],
            "state": taskv1State(obj["state"]),
            "username": obj["username"],
            "workspaceId": obj["workspaceId"],
        }
        if "container" in obj:
            kwargs["container"] = v1Container.from_json(obj["container"]) if obj["container"] is not None else None
        if "displayName" in obj:
            kwargs["displayName"] = obj["displayName"]
        if "exitStatus" in obj:
            kwargs["exitStatus"] = obj["exitStatus"]
        if "experimentIds" in obj:
            kwargs["experimentIds"] = obj["experimentIds"]
        if "serviceAddress" in obj:
            kwargs["serviceAddress"] = obj["serviceAddress"]
        if "trialIds" in obj:
            kwargs["trialIds"] = obj["trialIds"]
        if "userId" in obj:
            kwargs["userId"] = obj["userId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "description": self.description,
            "id": self.id,
            "jobId": self.jobId,
            "resourcePool": self.resourcePool,
            "startTime": self.startTime,
            "state": self.state.value,
            "username": self.username,
            "workspaceId": self.workspaceId,
        }
        if not omit_unset or "container" in vars(self):
            out["container"] = None if self.container is None else self.container.to_json(omit_unset)
        if not omit_unset or "displayName" in vars(self):
            out["displayName"] = self.displayName
        if not omit_unset or "exitStatus" in vars(self):
            out["exitStatus"] = self.exitStatus
        if not omit_unset or "experimentIds" in vars(self):
            out["experimentIds"] = self.experimentIds
        if not omit_unset or "serviceAddress" in vars(self):
            out["serviceAddress"] = self.serviceAddress
        if not omit_unset or "trialIds" in vars(self):
            out["trialIds"] = self.trialIds
        if not omit_unset or "userId" in vars(self):
            out["userId"] = self.userId
        return out

class v1TestWebhookResponse(Printable):
    """Response to TestWebhookRequest."""

    def __init__(
        self,
        *,
        completed: bool,
    ):
        self.completed = completed

    @classmethod
    def from_json(cls, obj: Json) -> "v1TestWebhookResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "completed": obj["completed"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "completed": self.completed,
        }
        return out

class v1TimestampFieldFilter(Printable):
    """Timestamp filters."""
    gt: "typing.Optional[str]" = None
    gte: "typing.Optional[str]" = None
    lt: "typing.Optional[str]" = None
    lte: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        gt: "typing.Union[str, None, Unset]" = _unset,
        gte: "typing.Union[str, None, Unset]" = _unset,
        lt: "typing.Union[str, None, Unset]" = _unset,
        lte: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(gt, Unset):
            self.gt = gt
        if not isinstance(gte, Unset):
            self.gte = gte
        if not isinstance(lt, Unset):
            self.lt = lt
        if not isinstance(lte, Unset):
            self.lte = lte

    @classmethod
    def from_json(cls, obj: Json) -> "v1TimestampFieldFilter":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "gt" in obj:
            kwargs["gt"] = obj["gt"]
        if "gte" in obj:
            kwargs["gte"] = obj["gte"]
        if "lt" in obj:
            kwargs["lt"] = obj["lt"]
        if "lte" in obj:
            kwargs["lte"] = obj["lte"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "gt" in vars(self):
            out["gt"] = self.gt
        if not omit_unset or "gte" in vars(self):
            out["gte"] = self.gte
        if not omit_unset or "lt" in vars(self):
            out["lt"] = self.lt
        if not omit_unset or "lte" in vars(self):
            out["lte"] = self.lte
        return out

class v1TokenInfo(Printable):
    """TokenInfo represents a token entry in the database."""
    createdAt: "typing.Optional[str]" = None
    description: "typing.Optional[str]" = None
    expiry: "typing.Optional[str]" = None
    revoked: "typing.Optional[bool]" = None
    tokenType: "typing.Optional[v1TokenType]" = None

    def __init__(
        self,
        *,
        id: int,
        userId: int,
        createdAt: "typing.Union[str, None, Unset]" = _unset,
        description: "typing.Union[str, None, Unset]" = _unset,
        expiry: "typing.Union[str, None, Unset]" = _unset,
        revoked: "typing.Union[bool, None, Unset]" = _unset,
        tokenType: "typing.Union[v1TokenType, None, Unset]" = _unset,
    ):
        self.id = id
        self.userId = userId
        if not isinstance(createdAt, Unset):
            self.createdAt = createdAt
        if not isinstance(description, Unset):
            self.description = description
        if not isinstance(expiry, Unset):
            self.expiry = expiry
        if not isinstance(revoked, Unset):
            self.revoked = revoked
        if not isinstance(tokenType, Unset):
            self.tokenType = tokenType

    @classmethod
    def from_json(cls, obj: Json) -> "v1TokenInfo":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "id": obj["id"],
            "userId": obj["userId"],
        }
        if "createdAt" in obj:
            kwargs["createdAt"] = obj["createdAt"]
        if "description" in obj:
            kwargs["description"] = obj["description"]
        if "expiry" in obj:
            kwargs["expiry"] = obj["expiry"]
        if "revoked" in obj:
            kwargs["revoked"] = obj["revoked"]
        if "tokenType" in obj:
            kwargs["tokenType"] = v1TokenType(obj["tokenType"]) if obj["tokenType"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "id": self.id,
            "userId": self.userId,
        }
        if not omit_unset or "createdAt" in vars(self):
            out["createdAt"] = self.createdAt
        if not omit_unset or "description" in vars(self):
            out["description"] = self.description
        if not omit_unset or "expiry" in vars(self):
            out["expiry"] = self.expiry
        if not omit_unset or "revoked" in vars(self):
            out["revoked"] = self.revoked
        if not omit_unset or "tokenType" in vars(self):
            out["tokenType"] = None if self.tokenType is None else self.tokenType.value
        return out

class v1TokenType(DetEnum):
    """Token type.
    - TOKEN_TYPE_UNSPECIFIED: Default token type.
    - TOKEN_TYPE_USER_SESSION: User Session token.
    - TOKEN_TYPE_ACCESS_TOKEN: Access token.
    """
    UNSPECIFIED = "TOKEN_TYPE_UNSPECIFIED"
    USER_SESSION = "TOKEN_TYPE_USER_SESSION"
    ACCESS_TOKEN = "TOKEN_TYPE_ACCESS_TOKEN"

class v1TrialEarlyExit(Printable):
    """Signals to the experiment the trial early exited."""

    def __init__(
        self,
        *,
        reason: "v1TrialEarlyExitExitedReason",
    ):
        self.reason = reason

    @classmethod
    def from_json(cls, obj: Json) -> "v1TrialEarlyExit":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "reason": v1TrialEarlyExitExitedReason(obj["reason"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "reason": self.reason.value,
        }
        return out

class v1TrialEarlyExitExitedReason(DetEnum):
    """The reason for an early exit.
    - EXITED_REASON_UNSPECIFIED: Zero-value (not allowed).
    - EXITED_REASON_INVALID_HP: Indicates the trial exited due to an invalid hyperparameter.
    - EXITED_REASON_INIT_INVALID_HP: Indicates the trial exited due to an invalid hyperparameter
    in the trial init.
    """
    UNSPECIFIED = "EXITED_REASON_UNSPECIFIED"
    INVALID_HP = "EXITED_REASON_INVALID_HP"
    INIT_INVALID_HP = "EXITED_REASON_INIT_INVALID_HP"

class v1TrialLogsFieldsResponse(Printable):
    """Response to TrialLogFieldsRequest."""
    agentIds: "typing.Optional[typing.Sequence[str]]" = None
    containerIds: "typing.Optional[typing.Sequence[str]]" = None
    rankIds: "typing.Optional[typing.Sequence[int]]" = None
    sources: "typing.Optional[typing.Sequence[str]]" = None
    stdtypes: "typing.Optional[typing.Sequence[str]]" = None

    def __init__(
        self,
        *,
        agentIds: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
        containerIds: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
        rankIds: "typing.Union[typing.Sequence[int], None, Unset]" = _unset,
        sources: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
        stdtypes: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
    ):
        if not isinstance(agentIds, Unset):
            self.agentIds = agentIds
        if not isinstance(containerIds, Unset):
            self.containerIds = containerIds
        if not isinstance(rankIds, Unset):
            self.rankIds = rankIds
        if not isinstance(sources, Unset):
            self.sources = sources
        if not isinstance(stdtypes, Unset):
            self.stdtypes = stdtypes

    @classmethod
    def from_json(cls, obj: Json) -> "v1TrialLogsFieldsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "agentIds" in obj:
            kwargs["agentIds"] = obj["agentIds"]
        if "containerIds" in obj:
            kwargs["containerIds"] = obj["containerIds"]
        if "rankIds" in obj:
            kwargs["rankIds"] = obj["rankIds"]
        if "sources" in obj:
            kwargs["sources"] = obj["sources"]
        if "stdtypes" in obj:
            kwargs["stdtypes"] = obj["stdtypes"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "agentIds" in vars(self):
            out["agentIds"] = self.agentIds
        if not omit_unset or "containerIds" in vars(self):
            out["containerIds"] = self.containerIds
        if not omit_unset or "rankIds" in vars(self):
            out["rankIds"] = self.rankIds
        if not omit_unset or "sources" in vars(self):
            out["sources"] = self.sources
        if not omit_unset or "stdtypes" in vars(self):
            out["stdtypes"] = self.stdtypes
        return out

class v1TrialLogsResponse(Printable):
    """Response to TrialLogsRequest."""
    agentId: "typing.Optional[str]" = None
    containerId: "typing.Optional[str]" = None
    log: "typing.Optional[str]" = None
    rankId: "typing.Optional[int]" = None
    source: "typing.Optional[str]" = None
    stdtype: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        id: str,
        level: "v1LogLevel",
        message: str,
        timestamp: str,
        trialId: int,
        agentId: "typing.Union[str, None, Unset]" = _unset,
        containerId: "typing.Union[str, None, Unset]" = _unset,
        log: "typing.Union[str, None, Unset]" = _unset,
        rankId: "typing.Union[int, None, Unset]" = _unset,
        source: "typing.Union[str, None, Unset]" = _unset,
        stdtype: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.id = id
        self.level = level
        self.message = message
        self.timestamp = timestamp
        self.trialId = trialId
        if not isinstance(agentId, Unset):
            self.agentId = agentId
        if not isinstance(containerId, Unset):
            self.containerId = containerId
        if not isinstance(log, Unset):
            self.log = log
        if not isinstance(rankId, Unset):
            self.rankId = rankId
        if not isinstance(source, Unset):
            self.source = source
        if not isinstance(stdtype, Unset):
            self.stdtype = stdtype

    @classmethod
    def from_json(cls, obj: Json) -> "v1TrialLogsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "id": obj["id"],
            "level": v1LogLevel(obj["level"]),
            "message": obj["message"],
            "timestamp": obj["timestamp"],
            "trialId": obj["trialId"],
        }
        if "agentId" in obj:
            kwargs["agentId"] = obj["agentId"]
        if "containerId" in obj:
            kwargs["containerId"] = obj["containerId"]
        if "log" in obj:
            kwargs["log"] = obj["log"]
        if "rankId" in obj:
            kwargs["rankId"] = obj["rankId"]
        if "source" in obj:
            kwargs["source"] = obj["source"]
        if "stdtype" in obj:
            kwargs["stdtype"] = obj["stdtype"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "id": self.id,
            "level": self.level.value,
            "message": self.message,
            "timestamp": self.timestamp,
            "trialId": self.trialId,
        }
        if not omit_unset or "agentId" in vars(self):
            out["agentId"] = self.agentId
        if not omit_unset or "containerId" in vars(self):
            out["containerId"] = self.containerId
        if not omit_unset or "log" in vars(self):
            out["log"] = self.log
        if not omit_unset or "rankId" in vars(self):
            out["rankId"] = self.rankId
        if not omit_unset or "source" in vars(self):
            out["source"] = self.source
        if not omit_unset or "stdtype" in vars(self):
            out["stdtype"] = self.stdtype
        return out

class v1TrialMetrics(Printable):
    """Metrics from the trial some duration of training."""
    reportTime: "typing.Optional[str]" = None
    stepsCompleted: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        metrics: "v1Metrics",
        trialId: int,
        trialRunId: int,
        reportTime: "typing.Union[str, None, Unset]" = _unset,
        stepsCompleted: "typing.Union[int, None, Unset]" = _unset,
    ):
        self.metrics = metrics
        self.trialId = trialId
        self.trialRunId = trialRunId
        if not isinstance(reportTime, Unset):
            self.reportTime = reportTime
        if not isinstance(stepsCompleted, Unset):
            self.stepsCompleted = stepsCompleted

    @classmethod
    def from_json(cls, obj: Json) -> "v1TrialMetrics":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "metrics": v1Metrics.from_json(obj["metrics"]),
            "trialId": obj["trialId"],
            "trialRunId": obj["trialRunId"],
        }
        if "reportTime" in obj:
            kwargs["reportTime"] = obj["reportTime"]
        if "stepsCompleted" in obj:
            kwargs["stepsCompleted"] = obj["stepsCompleted"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "metrics": self.metrics.to_json(omit_unset),
            "trialId": self.trialId,
            "trialRunId": self.trialRunId,
        }
        if not omit_unset or "reportTime" in vars(self):
            out["reportTime"] = self.reportTime
        if not omit_unset or "stepsCompleted" in vars(self):
            out["stepsCompleted"] = self.stepsCompleted
        return out

class v1TrialProfilerMetricLabels(Printable):
    agentId: "typing.Optional[str]" = None
    gpuUuid: "typing.Optional[str]" = None
    metricType: "typing.Optional[TrialProfilerMetricLabelsProfilerMetricType]" = None

    def __init__(
        self,
        *,
        name: str,
        trialId: int,
        agentId: "typing.Union[str, None, Unset]" = _unset,
        gpuUuid: "typing.Union[str, None, Unset]" = _unset,
        metricType: "typing.Union[TrialProfilerMetricLabelsProfilerMetricType, None, Unset]" = _unset,
    ):
        self.name = name
        self.trialId = trialId
        if not isinstance(agentId, Unset):
            self.agentId = agentId
        if not isinstance(gpuUuid, Unset):
            self.gpuUuid = gpuUuid
        if not isinstance(metricType, Unset):
            self.metricType = metricType

    @classmethod
    def from_json(cls, obj: Json) -> "v1TrialProfilerMetricLabels":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "name": obj["name"],
            "trialId": obj["trialId"],
        }
        if "agentId" in obj:
            kwargs["agentId"] = obj["agentId"]
        if "gpuUuid" in obj:
            kwargs["gpuUuid"] = obj["gpuUuid"]
        if "metricType" in obj:
            kwargs["metricType"] = TrialProfilerMetricLabelsProfilerMetricType(obj["metricType"]) if obj["metricType"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "name": self.name,
            "trialId": self.trialId,
        }
        if not omit_unset or "agentId" in vars(self):
            out["agentId"] = self.agentId
        if not omit_unset or "gpuUuid" in vars(self):
            out["gpuUuid"] = self.gpuUuid
        if not omit_unset or "metricType" in vars(self):
            out["metricType"] = None if self.metricType is None else self.metricType.value
        return out

class v1TrialProfilerMetricsBatch(Printable):
    """TrialProfilerMetricsBatch is a batch of trial profiler metrics. A batch will
    contain metrics pertaining to a single series. The fields values, batches and
    timestamps will be equal length arrays with each index corresponding to a
    reading.
    """

    def __init__(
        self,
        *,
        batches: "typing.Sequence[int]",
        labels: "v1TrialProfilerMetricLabels",
        timestamps: "typing.Sequence[str]",
        values: "typing.Sequence[float]",
    ):
        self.batches = batches
        self.labels = labels
        self.timestamps = timestamps
        self.values = values

    @classmethod
    def from_json(cls, obj: Json) -> "v1TrialProfilerMetricsBatch":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "batches": obj["batches"],
            "labels": v1TrialProfilerMetricLabels.from_json(obj["labels"]),
            "timestamps": obj["timestamps"],
            "values": [float(x) for x in obj["values"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "batches": self.batches,
            "labels": self.labels.to_json(omit_unset),
            "timestamps": self.timestamps,
            "values": [dump_float(x) for x in self.values],
        }
        return out

class v1TrialRunnerMetadata(Printable):
    """The metadata pertaining to the current running task for a trial."""

    def __init__(
        self,
        *,
        state: str,
    ):
        self.state = state

    @classmethod
    def from_json(cls, obj: Json) -> "v1TrialRunnerMetadata":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "state": obj["state"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "state": self.state,
        }
        return out

class v1TrialSourceInfo(Printable):
    modelId: "typing.Optional[int]" = None
    modelVersion: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        checkpointUuid: str,
        trialId: int,
        trialSourceInfoType: "v1TrialSourceInfoType",
        modelId: "typing.Union[int, None, Unset]" = _unset,
        modelVersion: "typing.Union[int, None, Unset]" = _unset,
    ):
        self.checkpointUuid = checkpointUuid
        self.trialId = trialId
        self.trialSourceInfoType = trialSourceInfoType
        if not isinstance(modelId, Unset):
            self.modelId = modelId
        if not isinstance(modelVersion, Unset):
            self.modelVersion = modelVersion

    @classmethod
    def from_json(cls, obj: Json) -> "v1TrialSourceInfo":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "checkpointUuid": obj["checkpointUuid"],
            "trialId": obj["trialId"],
            "trialSourceInfoType": v1TrialSourceInfoType(obj["trialSourceInfoType"]),
        }
        if "modelId" in obj:
            kwargs["modelId"] = obj["modelId"]
        if "modelVersion" in obj:
            kwargs["modelVersion"] = obj["modelVersion"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "checkpointUuid": self.checkpointUuid,
            "trialId": self.trialId,
            "trialSourceInfoType": self.trialSourceInfoType.value,
        }
        if not omit_unset or "modelId" in vars(self):
            out["modelId"] = self.modelId
        if not omit_unset or "modelVersion" in vars(self):
            out["modelVersion"] = self.modelVersion
        return out

class v1TrialSourceInfoType(DetEnum):
    """TrialSourceInfoType is the type of the TrialSourceInfo, which serves as a
    link between a trial and a checkpoint or model version
    - TRIAL_SOURCE_INFO_TYPE_UNSPECIFIED: The type is unspecified
    - TRIAL_SOURCE_INFO_TYPE_INFERENCE: "Inference" Trial Source Info Type, used for batch inference
    - TRIAL_SOURCE_INFO_TYPE_FINE_TUNING: "Fine Tuning" Trial Source Info Type, used in model hub
    """
    UNSPECIFIED = "TRIAL_SOURCE_INFO_TYPE_UNSPECIFIED"
    INFERENCE = "TRIAL_SOURCE_INFO_TYPE_INFERENCE"
    FINE_TUNING = "TRIAL_SOURCE_INFO_TYPE_FINE_TUNING"

class v1TrialSummary(Printable):
    """TrialSummary describes the runs that are estimated to train for a certain
    length.
    """

    def __init__(
        self,
        *,
        count: int,
        unit: "v1SearchUnit",
    ):
        self.count = count
        self.unit = unit

    @classmethod
    def from_json(cls, obj: Json) -> "v1TrialSummary":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "count": obj["count"],
            "unit": v1SearchUnit.from_json(obj["unit"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "count": self.count,
            "unit": self.unit.to_json(omit_unset),
        }
        return out

class v1TrialsSampleResponse(Printable):

    def __init__(
        self,
        *,
        demotedTrials: "typing.Sequence[int]",
        promotedTrials: "typing.Sequence[int]",
        trials: "typing.Sequence[v1TrialsSampleResponseTrial]",
    ):
        self.demotedTrials = demotedTrials
        self.promotedTrials = promotedTrials
        self.trials = trials

    @classmethod
    def from_json(cls, obj: Json) -> "v1TrialsSampleResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "demotedTrials": obj["demotedTrials"],
            "promotedTrials": obj["promotedTrials"],
            "trials": [v1TrialsSampleResponseTrial.from_json(x) for x in obj["trials"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "demotedTrials": self.demotedTrials,
            "promotedTrials": self.promotedTrials,
            "trials": [x.to_json(omit_unset) for x in self.trials],
        }
        return out

class v1TrialsSampleResponseTrial(Printable):
    """Metadata and metrics stream from a trial."""

    def __init__(
        self,
        *,
        data: "typing.Sequence[v1DataPoint]",
        hparams: "typing.Dict[str, typing.Any]",
        trialId: int,
    ):
        self.data = data
        self.hparams = hparams
        self.trialId = trialId

    @classmethod
    def from_json(cls, obj: Json) -> "v1TrialsSampleResponseTrial":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "data": [v1DataPoint.from_json(x) for x in obj["data"]],
            "hparams": obj["hparams"],
            "trialId": obj["trialId"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "data": [x.to_json(omit_unset) for x in self.data],
            "hparams": self.hparams,
            "trialId": self.trialId,
        }
        return out

class v1TrialsSnapshotResponse(Printable):

    def __init__(
        self,
        *,
        trials: "typing.Sequence[v1TrialsSnapshotResponseTrial]",
    ):
        self.trials = trials

    @classmethod
    def from_json(cls, obj: Json) -> "v1TrialsSnapshotResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "trials": [v1TrialsSnapshotResponseTrial.from_json(x) for x in obj["trials"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "trials": [x.to_json(omit_unset) for x in self.trials],
        }
        return out

class v1TrialsSnapshotResponseTrial(Printable):
    """Metric value and metadata for a trial that has progress this far."""

    def __init__(
        self,
        *,
        batchesProcessed: int,
        hparams: "typing.Dict[str, typing.Any]",
        metric: float,
        trialId: int,
    ):
        self.batchesProcessed = batchesProcessed
        self.hparams = hparams
        self.metric = metric
        self.trialId = trialId

    @classmethod
    def from_json(cls, obj: Json) -> "v1TrialsSnapshotResponseTrial":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "batchesProcessed": obj["batchesProcessed"],
            "hparams": obj["hparams"],
            "metric": float(obj["metric"]),
            "trialId": obj["trialId"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "batchesProcessed": self.batchesProcessed,
            "hparams": self.hparams,
            "metric": dump_float(self.metric),
            "trialId": self.trialId,
        }
        return out

class v1Trigger(Printable):
    condition: "typing.Optional[typing.Dict[str, typing.Any]]" = None
    id: "typing.Optional[int]" = None
    triggerType: "typing.Optional[v1TriggerType]" = None
    webhookId: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        condition: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
        id: "typing.Union[int, None, Unset]" = _unset,
        triggerType: "typing.Union[v1TriggerType, None, Unset]" = _unset,
        webhookId: "typing.Union[int, None, Unset]" = _unset,
    ):
        if not isinstance(condition, Unset):
            self.condition = condition
        if not isinstance(id, Unset):
            self.id = id
        if not isinstance(triggerType, Unset):
            self.triggerType = triggerType
        if not isinstance(webhookId, Unset):
            self.webhookId = webhookId

    @classmethod
    def from_json(cls, obj: Json) -> "v1Trigger":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "condition" in obj:
            kwargs["condition"] = obj["condition"]
        if "id" in obj:
            kwargs["id"] = obj["id"]
        if "triggerType" in obj:
            kwargs["triggerType"] = v1TriggerType(obj["triggerType"]) if obj["triggerType"] is not None else None
        if "webhookId" in obj:
            kwargs["webhookId"] = obj["webhookId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "condition" in vars(self):
            out["condition"] = self.condition
        if not omit_unset or "id" in vars(self):
            out["id"] = self.id
        if not omit_unset or "triggerType" in vars(self):
            out["triggerType"] = None if self.triggerType is None else self.triggerType.value
        if not omit_unset or "webhookId" in vars(self):
            out["webhookId"] = self.webhookId
        return out

class v1TriggerType(DetEnum):
    """Enum values for expected trigger types.
    - TRIGGER_TYPE_UNSPECIFIED: Default value
    - TRIGGER_TYPE_EXPERIMENT_STATE_CHANGE: For an experiment changing state
    - TRIGGER_TYPE_METRIC_THRESHOLD_EXCEEDED: For metrics emitted during training.
    - TRIGGER_TYPE_TASK_LOG: For task logs.
    - TRIGGER_TYPE_CUSTOM: For custom alert.
    """
    UNSPECIFIED = "TRIGGER_TYPE_UNSPECIFIED"
    EXPERIMENT_STATE_CHANGE = "TRIGGER_TYPE_EXPERIMENT_STATE_CHANGE"
    METRIC_THRESHOLD_EXCEEDED = "TRIGGER_TYPE_METRIC_THRESHOLD_EXCEEDED"
    TASK_LOG = "TRIGGER_TYPE_TASK_LOG"
    CUSTOM = "TRIGGER_TYPE_CUSTOM"

class v1UnarchiveExperimentsRequest(Printable):
    """Unarchive multiple experiments."""
    filters: "typing.Optional[v1BulkExperimentFilters]" = None

    def __init__(
        self,
        *,
        experimentIds: "typing.Sequence[int]",
        projectId: int,
        filters: "typing.Union[v1BulkExperimentFilters, None, Unset]" = _unset,
    ):
        self.experimentIds = experimentIds
        self.projectId = projectId
        if not isinstance(filters, Unset):
            self.filters = filters

    @classmethod
    def from_json(cls, obj: Json) -> "v1UnarchiveExperimentsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "experimentIds": obj["experimentIds"],
            "projectId": obj["projectId"],
        }
        if "filters" in obj:
            kwargs["filters"] = v1BulkExperimentFilters.from_json(obj["filters"]) if obj["filters"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "experimentIds": self.experimentIds,
            "projectId": self.projectId,
        }
        if not omit_unset or "filters" in vars(self):
            out["filters"] = None if self.filters is None else self.filters.to_json(omit_unset)
        return out

class v1UnarchiveExperimentsResponse(Printable):
    """Response to UnarchiveExperimentsRequest."""

    def __init__(
        self,
        *,
        results: "typing.Sequence[v1ExperimentActionResult]",
    ):
        self.results = results

    @classmethod
    def from_json(cls, obj: Json) -> "v1UnarchiveExperimentsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "results": [v1ExperimentActionResult.from_json(x) for x in obj["results"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "results": [x.to_json(omit_unset) for x in self.results],
        }
        return out

class v1UnarchiveRunsRequest(Printable):
    filter: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        projectId: int,
        runIds: "typing.Sequence[int]",
        filter: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.projectId = projectId
        self.runIds = runIds
        if not isinstance(filter, Unset):
            self.filter = filter

    @classmethod
    def from_json(cls, obj: Json) -> "v1UnarchiveRunsRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "projectId": obj["projectId"],
            "runIds": obj["runIds"],
        }
        if "filter" in obj:
            kwargs["filter"] = obj["filter"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "projectId": self.projectId,
            "runIds": self.runIds,
        }
        if not omit_unset or "filter" in vars(self):
            out["filter"] = self.filter
        return out

class v1UnarchiveRunsResponse(Printable):
    """Response to UnarchiveRunsRequest."""

    def __init__(
        self,
        *,
        results: "typing.Sequence[v1RunActionResult]",
    ):
        self.results = results

    @classmethod
    def from_json(cls, obj: Json) -> "v1UnarchiveRunsResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "results": [v1RunActionResult.from_json(x) for x in obj["results"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "results": [x.to_json(omit_unset) for x in self.results],
        }
        return out

class v1UnbindRPFromWorkspaceRequest(Printable):
    """Unbind a resource pool to workspaces."""
    workspaceIds: "typing.Optional[typing.Sequence[int]]" = None
    workspaceNames: "typing.Optional[typing.Sequence[str]]" = None

    def __init__(
        self,
        *,
        resourcePoolName: str,
        workspaceIds: "typing.Union[typing.Sequence[int], None, Unset]" = _unset,
        workspaceNames: "typing.Union[typing.Sequence[str], None, Unset]" = _unset,
    ):
        self.resourcePoolName = resourcePoolName
        if not isinstance(workspaceIds, Unset):
            self.workspaceIds = workspaceIds
        if not isinstance(workspaceNames, Unset):
            self.workspaceNames = workspaceNames

    @classmethod
    def from_json(cls, obj: Json) -> "v1UnbindRPFromWorkspaceRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "resourcePoolName": obj["resourcePoolName"],
        }
        if "workspaceIds" in obj:
            kwargs["workspaceIds"] = obj["workspaceIds"]
        if "workspaceNames" in obj:
            kwargs["workspaceNames"] = obj["workspaceNames"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "resourcePoolName": self.resourcePoolName,
        }
        if not omit_unset or "workspaceIds" in vars(self):
            out["workspaceIds"] = self.workspaceIds
        if not omit_unset or "workspaceNames" in vars(self):
            out["workspaceNames"] = self.workspaceNames
        return out

class v1UpdateGroupRequest(Printable):
    """UpdateGroupRequest is the body of the request for the call
    to update a group and its members.
    """
    addUsers: "typing.Optional[typing.Sequence[int]]" = None
    name: "typing.Optional[str]" = None
    removeUsers: "typing.Optional[typing.Sequence[int]]" = None

    def __init__(
        self,
        *,
        groupId: int,
        addUsers: "typing.Union[typing.Sequence[int], None, Unset]" = _unset,
        name: "typing.Union[str, None, Unset]" = _unset,
        removeUsers: "typing.Union[typing.Sequence[int], None, Unset]" = _unset,
    ):
        self.groupId = groupId
        if not isinstance(addUsers, Unset):
            self.addUsers = addUsers
        if not isinstance(name, Unset):
            self.name = name
        if not isinstance(removeUsers, Unset):
            self.removeUsers = removeUsers

    @classmethod
    def from_json(cls, obj: Json) -> "v1UpdateGroupRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "groupId": obj["groupId"],
        }
        if "addUsers" in obj:
            kwargs["addUsers"] = obj["addUsers"]
        if "name" in obj:
            kwargs["name"] = obj["name"]
        if "removeUsers" in obj:
            kwargs["removeUsers"] = obj["removeUsers"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "groupId": self.groupId,
        }
        if not omit_unset or "addUsers" in vars(self):
            out["addUsers"] = self.addUsers
        if not omit_unset or "name" in vars(self):
            out["name"] = self.name
        if not omit_unset or "removeUsers" in vars(self):
            out["removeUsers"] = self.removeUsers
        return out

class v1UpdateGroupResponse(Printable):
    """UpdateGroupResponse is the body of the response for the call
    to update a group and its members.
    """

    def __init__(
        self,
        *,
        group: "v1GroupDetails",
    ):
        self.group = group

    @classmethod
    def from_json(cls, obj: Json) -> "v1UpdateGroupResponse":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "group": v1GroupDetails.from_json(obj["group"]),
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "group": self.group.to_json(omit_unset),
        }
        return out

class v1UpdateJobQueueRequest(Printable):
    """Request to update the job queue."""

    def __init__(
        self,
        *,
        updates: "typing.Sequence[v1QueueControl]",
    ):
        self.updates = updates

    @classmethod
    def from_json(cls, obj: Json) -> "v1UpdateJobQueueRequest":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "updates": [v1QueueControl.from_json(x) for x in obj["updates"]],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "updates": [x.to_json(omit_unset) for x in self.updates],
        }
        return out

class v1User(Printable):
    """User is an account in the determined cluster."""
    agentUserGroup: "typing.Optional[v1AgentUserGroup]" = None
    displayName: "typing.Optional[str]" = None
    id: "typing.Optional[int]" = None
    lastAuthAt: "typing.Optional[str]" = None
    modifiedAt: "typing.Optional[str]" = None
    remote: "typing.Optional[bool]" = None

    def __init__(
        self,
        *,
        active: bool,
        admin: bool,
        username: str,
        agentUserGroup: "typing.Union[v1AgentUserGroup, None, Unset]" = _unset,
        displayName: "typing.Union[str, None, Unset]" = _unset,
        id: "typing.Union[int, None, Unset]" = _unset,
        lastAuthAt: "typing.Union[str, None, Unset]" = _unset,
        modifiedAt: "typing.Union[str, None, Unset]" = _unset,
        remote: "typing.Union[bool, None, Unset]" = _unset,
    ):
        self.active = active
        self.admin = admin
        self.username = username
        if not isinstance(agentUserGroup, Unset):
            self.agentUserGroup = agentUserGroup
        if not isinstance(displayName, Unset):
            self.displayName = displayName
        if not isinstance(id, Unset):
            self.id = id
        if not isinstance(lastAuthAt, Unset):
            self.lastAuthAt = lastAuthAt
        if not isinstance(modifiedAt, Unset):
            self.modifiedAt = modifiedAt
        if not isinstance(remote, Unset):
            self.remote = remote

    @classmethod
    def from_json(cls, obj: Json) -> "v1User":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "active": obj["active"],
            "admin": obj["admin"],
            "username": obj["username"],
        }
        if "agentUserGroup" in obj:
            kwargs["agentUserGroup"] = v1AgentUserGroup.from_json(obj["agentUserGroup"]) if obj["agentUserGroup"] is not None else None
        if "displayName" in obj:
            kwargs["displayName"] = obj["displayName"]
        if "id" in obj:
            kwargs["id"] = obj["id"]
        if "lastAuthAt" in obj:
            kwargs["lastAuthAt"] = obj["lastAuthAt"]
        if "modifiedAt" in obj:
            kwargs["modifiedAt"] = obj["modifiedAt"]
        if "remote" in obj:
            kwargs["remote"] = obj["remote"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "active": self.active,
            "admin": self.admin,
            "username": self.username,
        }
        if not omit_unset or "agentUserGroup" in vars(self):
            out["agentUserGroup"] = None if self.agentUserGroup is None else self.agentUserGroup.to_json(omit_unset)
        if not omit_unset or "displayName" in vars(self):
            out["displayName"] = self.displayName
        if not omit_unset or "id" in vars(self):
            out["id"] = self.id
        if not omit_unset or "lastAuthAt" in vars(self):
            out["lastAuthAt"] = self.lastAuthAt
        if not omit_unset or "modifiedAt" in vars(self):
            out["modifiedAt"] = self.modifiedAt
        if not omit_unset or "remote" in vars(self):
            out["remote"] = self.remote
        return out

class v1UserActionResult(Printable):
    """Message for results of individual users in a multi-user action."""

    def __init__(
        self,
        *,
        error: str,
        id: int,
    ):
        self.error = error
        self.id = id

    @classmethod
    def from_json(cls, obj: Json) -> "v1UserActionResult":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "error": obj["error"],
            "id": obj["id"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "error": self.error,
            "id": self.id,
        }
        return out

class v1UserFilters(Printable):
    """Options to filter a subset of users."""
    admin: "typing.Optional[bool]" = None
    name: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        admin: "typing.Union[bool, None, Unset]" = _unset,
        name: "typing.Union[str, None, Unset]" = _unset,
    ):
        if not isinstance(admin, Unset):
            self.admin = admin
        if not isinstance(name, Unset):
            self.name = name

    @classmethod
    def from_json(cls, obj: Json) -> "v1UserFilters":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "admin" in obj:
            kwargs["admin"] = obj["admin"]
        if "name" in obj:
            kwargs["name"] = obj["name"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "admin" in vars(self):
            out["admin"] = self.admin
        if not omit_unset or "name" in vars(self):
            out["name"] = self.name
        return out

class v1UserRoleAssignment(Printable):
    """UserRoleAssignment contains information about the users
    belonging to a role.
    """

    def __init__(
        self,
        *,
        roleAssignment: "v1RoleAssignment",
        userId: int,
    ):
        self.roleAssignment = roleAssignment
        self.userId = userId

    @classmethod
    def from_json(cls, obj: Json) -> "v1UserRoleAssignment":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "roleAssignment": v1RoleAssignment.from_json(obj["roleAssignment"]),
            "userId": obj["userId"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "roleAssignment": self.roleAssignment.to_json(omit_unset),
            "userId": self.userId,
        }
        return out

class v1UserWebSetting(Printable):
    """UserWebSetting represents user web setting."""
    storagePath: "typing.Optional[str]" = None
    value: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        key: str,
        storagePath: "typing.Union[str, None, Unset]" = _unset,
        value: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.key = key
        if not isinstance(storagePath, Unset):
            self.storagePath = storagePath
        if not isinstance(value, Unset):
            self.value = value

    @classmethod
    def from_json(cls, obj: Json) -> "v1UserWebSetting":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "key": obj["key"],
        }
        if "storagePath" in obj:
            kwargs["storagePath"] = obj["storagePath"]
        if "value" in obj:
            kwargs["value"] = obj["value"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "key": self.key,
        }
        if not omit_unset or "storagePath" in vars(self):
            out["storagePath"] = self.storagePath
        if not omit_unset or "value" in vars(self):
            out["value"] = self.value
        return out

class v1ValidationHistoryEntry(Printable):
    """ValidationHistoryEntry is a single entry for a validation history for an
    experiment.
    """

    def __init__(
        self,
        *,
        endTime: str,
        searcherMetric: float,
        trialId: int,
    ):
        self.endTime = endTime
        self.searcherMetric = searcherMetric
        self.trialId = trialId

    @classmethod
    def from_json(cls, obj: Json) -> "v1ValidationHistoryEntry":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "endTime": obj["endTime"],
            "searcherMetric": float(obj["searcherMetric"]),
            "trialId": obj["trialId"],
        }
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "endTime": self.endTime,
            "searcherMetric": dump_float(self.searcherMetric),
            "trialId": self.trialId,
        }
        return out

class v1Webhook(Printable):
    id: "typing.Optional[int]" = None
    triggers: "typing.Optional[typing.Sequence[v1Trigger]]" = None
    workspaceId: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        mode: "v1WebhookMode",
        name: str,
        url: str,
        webhookType: "v1WebhookType",
        id: "typing.Union[int, None, Unset]" = _unset,
        triggers: "typing.Union[typing.Sequence[v1Trigger], None, Unset]" = _unset,
        workspaceId: "typing.Union[int, None, Unset]" = _unset,
    ):
        self.mode = mode
        self.name = name
        self.url = url
        self.webhookType = webhookType
        if not isinstance(id, Unset):
            self.id = id
        if not isinstance(triggers, Unset):
            self.triggers = triggers
        if not isinstance(workspaceId, Unset):
            self.workspaceId = workspaceId

    @classmethod
    def from_json(cls, obj: Json) -> "v1Webhook":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "mode": v1WebhookMode(obj["mode"]),
            "name": obj["name"],
            "url": obj["url"],
            "webhookType": v1WebhookType(obj["webhookType"]),
        }
        if "id" in obj:
            kwargs["id"] = obj["id"]
        if "triggers" in obj:
            kwargs["triggers"] = [v1Trigger.from_json(x) for x in obj["triggers"]] if obj["triggers"] is not None else None
        if "workspaceId" in obj:
            kwargs["workspaceId"] = obj["workspaceId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "mode": self.mode.value,
            "name": self.name,
            "url": self.url,
            "webhookType": self.webhookType.value,
        }
        if not omit_unset or "id" in vars(self):
            out["id"] = self.id
        if not omit_unset or "triggers" in vars(self):
            out["triggers"] = None if self.triggers is None else [x.to_json(omit_unset) for x in self.triggers]
        if not omit_unset or "workspaceId" in vars(self):
            out["workspaceId"] = self.workspaceId
        return out

class v1WebhookMode(DetEnum):
    """Enum values for webhook mode.
    - WEBHOOK_MODE_UNSPECIFIED: Default value
    - WEBHOOK_MODE_WORKSPACE: Webhook will be triggered by all experiment in the workspace
    - WEBHOOK_MODE_SPECIFIC: Webhook will only be triggered by experiment with matching configuration in
    the same workspace as the web hook
    """
    UNSPECIFIED = "WEBHOOK_MODE_UNSPECIFIED"
    WORKSPACE = "WEBHOOK_MODE_WORKSPACE"
    SPECIFIC = "WEBHOOK_MODE_SPECIFIC"

class v1WebhookType(DetEnum):
    """Enum values for expected webhook types.
    - WEBHOOK_TYPE_UNSPECIFIED: Default value
    - WEBHOOK_TYPE_DEFAULT: For a default webhook
    - WEBHOOK_TYPE_SLACK: For a slack webhook.
    """
    UNSPECIFIED = "WEBHOOK_TYPE_UNSPECIFIED"
    DEFAULT = "WEBHOOK_TYPE_DEFAULT"
    SLACK = "WEBHOOK_TYPE_SLACK"

class v1WorkloadContainer(Printable):
    """WorkloadContainer is a wrapper for Determined workloads to allow repeated
    oneof types.
    """
    checkpoint: "typing.Optional[v1CheckpointWorkload]" = None
    training: "typing.Optional[v1MetricsWorkload]" = None
    validation: "typing.Optional[v1MetricsWorkload]" = None

    def __init__(
        self,
        *,
        checkpoint: "typing.Union[v1CheckpointWorkload, None, Unset]" = _unset,
        training: "typing.Union[v1MetricsWorkload, None, Unset]" = _unset,
        validation: "typing.Union[v1MetricsWorkload, None, Unset]" = _unset,
    ):
        if not isinstance(checkpoint, Unset):
            self.checkpoint = checkpoint
        if not isinstance(training, Unset):
            self.training = training
        if not isinstance(validation, Unset):
            self.validation = validation

    @classmethod
    def from_json(cls, obj: Json) -> "v1WorkloadContainer":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "checkpoint" in obj:
            kwargs["checkpoint"] = v1CheckpointWorkload.from_json(obj["checkpoint"]) if obj["checkpoint"] is not None else None
        if "training" in obj:
            kwargs["training"] = v1MetricsWorkload.from_json(obj["training"]) if obj["training"] is not None else None
        if "validation" in obj:
            kwargs["validation"] = v1MetricsWorkload.from_json(obj["validation"]) if obj["validation"] is not None else None
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "checkpoint" in vars(self):
            out["checkpoint"] = None if self.checkpoint is None else self.checkpoint.to_json(omit_unset)
        if not omit_unset or "training" in vars(self):
            out["training"] = None if self.training is None else self.training.to_json(omit_unset)
        if not omit_unset or "validation" in vars(self):
            out["validation"] = None if self.validation is None else self.validation.to_json(omit_unset)
        return out

class v1Workspace(Printable):
    """Workspace is a named collection of projects."""
    agentUserGroup: "typing.Optional[v1AgentUserGroup]" = None
    autoCreatedNamespace: "typing.Optional[str]" = None
    checkpointStorageConfig: "typing.Optional[typing.Dict[str, typing.Any]]" = None
    defaultAuxPool: "typing.Optional[str]" = None
    defaultComputePool: "typing.Optional[str]" = None
    pinnedAt: "typing.Optional[str]" = None

    def __init__(
        self,
        *,
        archived: bool,
        errorMessage: str,
        id: int,
        immutable: bool,
        name: str,
        numExperiments: int,
        numProjects: int,
        pinned: bool,
        state: "v1WorkspaceState",
        userId: int,
        username: str,
        agentUserGroup: "typing.Union[v1AgentUserGroup, None, Unset]" = _unset,
        autoCreatedNamespace: "typing.Union[str, None, Unset]" = _unset,
        checkpointStorageConfig: "typing.Union[typing.Dict[str, typing.Any], None, Unset]" = _unset,
        defaultAuxPool: "typing.Union[str, None, Unset]" = _unset,
        defaultComputePool: "typing.Union[str, None, Unset]" = _unset,
        pinnedAt: "typing.Union[str, None, Unset]" = _unset,
    ):
        self.archived = archived
        self.errorMessage = errorMessage
        self.id = id
        self.immutable = immutable
        self.name = name
        self.numExperiments = numExperiments
        self.numProjects = numProjects
        self.pinned = pinned
        self.state = state
        self.userId = userId
        self.username = username
        if not isinstance(agentUserGroup, Unset):
            self.agentUserGroup = agentUserGroup
        if not isinstance(autoCreatedNamespace, Unset):
            self.autoCreatedNamespace = autoCreatedNamespace
        if not isinstance(checkpointStorageConfig, Unset):
            self.checkpointStorageConfig = checkpointStorageConfig
        if not isinstance(defaultAuxPool, Unset):
            self.defaultAuxPool = defaultAuxPool
        if not isinstance(defaultComputePool, Unset):
            self.defaultComputePool = defaultComputePool
        if not isinstance(pinnedAt, Unset):
            self.pinnedAt = pinnedAt

    @classmethod
    def from_json(cls, obj: Json) -> "v1Workspace":
        kwargs: "typing.Dict[str, typing.Any]" = {
            "archived": obj["archived"],
            "errorMessage": obj["errorMessage"],
            "id": obj["id"],
            "immutable": obj["immutable"],
            "name": obj["name"],
            "numExperiments": obj["numExperiments"],
            "numProjects": obj["numProjects"],
            "pinned": obj["pinned"],
            "state": v1WorkspaceState(obj["state"]),
            "userId": obj["userId"],
            "username": obj["username"],
        }
        if "agentUserGroup" in obj:
            kwargs["agentUserGroup"] = v1AgentUserGroup.from_json(obj["agentUserGroup"]) if obj["agentUserGroup"] is not None else None
        if "autoCreatedNamespace" in obj:
            kwargs["autoCreatedNamespace"] = obj["autoCreatedNamespace"]
        if "checkpointStorageConfig" in obj:
            kwargs["checkpointStorageConfig"] = obj["checkpointStorageConfig"]
        if "defaultAuxPool" in obj:
            kwargs["defaultAuxPool"] = obj["defaultAuxPool"]
        if "defaultComputePool" in obj:
            kwargs["defaultComputePool"] = obj["defaultComputePool"]
        if "pinnedAt" in obj:
            kwargs["pinnedAt"] = obj["pinnedAt"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
            "archived": self.archived,
            "errorMessage": self.errorMessage,
            "id": self.id,
            "immutable": self.immutable,
            "name": self.name,
            "numExperiments": self.numExperiments,
            "numProjects": self.numProjects,
            "pinned": self.pinned,
            "state": self.state.value,
            "userId": self.userId,
            "username": self.username,
        }
        if not omit_unset or "agentUserGroup" in vars(self):
            out["agentUserGroup"] = None if self.agentUserGroup is None else self.agentUserGroup.to_json(omit_unset)
        if not omit_unset or "autoCreatedNamespace" in vars(self):
            out["autoCreatedNamespace"] = self.autoCreatedNamespace
        if not omit_unset or "checkpointStorageConfig" in vars(self):
            out["checkpointStorageConfig"] = self.checkpointStorageConfig
        if not omit_unset or "defaultAuxPool" in vars(self):
            out["defaultAuxPool"] = self.defaultAuxPool
        if not omit_unset or "defaultComputePool" in vars(self):
            out["defaultComputePool"] = self.defaultComputePool
        if not omit_unset or "pinnedAt" in vars(self):
            out["pinnedAt"] = self.pinnedAt
        return out

class v1WorkspaceNamespaceBinding(Printable):
    """WorkspaceNamespace represents a workspace-namespace binding for a given
    workspace and cluster.
    """
    autoCreateNamespace: "typing.Optional[bool]" = None
    clusterName: "typing.Optional[str]" = None
    namespace: "typing.Optional[str]" = None
    workspaceId: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        autoCreateNamespace: "typing.Union[bool, None, Unset]" = _unset,
        clusterName: "typing.Union[str, None, Unset]" = _unset,
        namespace: "typing.Union[str, None, Unset]" = _unset,
        workspaceId: "typing.Union[int, None, Unset]" = _unset,
    ):
        if not isinstance(autoCreateNamespace, Unset):
            self.autoCreateNamespace = autoCreateNamespace
        if not isinstance(clusterName, Unset):
            self.clusterName = clusterName
        if not isinstance(namespace, Unset):
            self.namespace = namespace
        if not isinstance(workspaceId, Unset):
            self.workspaceId = workspaceId

    @classmethod
    def from_json(cls, obj: Json) -> "v1WorkspaceNamespaceBinding":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "autoCreateNamespace" in obj:
            kwargs["autoCreateNamespace"] = obj["autoCreateNamespace"]
        if "clusterName" in obj:
            kwargs["clusterName"] = obj["clusterName"]
        if "namespace" in obj:
            kwargs["namespace"] = obj["namespace"]
        if "workspaceId" in obj:
            kwargs["workspaceId"] = obj["workspaceId"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "autoCreateNamespace" in vars(self):
            out["autoCreateNamespace"] = self.autoCreateNamespace
        if not omit_unset or "clusterName" in vars(self):
            out["clusterName"] = self.clusterName
        if not omit_unset or "namespace" in vars(self):
            out["namespace"] = self.namespace
        if not omit_unset or "workspaceId" in vars(self):
            out["workspaceId"] = self.workspaceId
        return out

class v1WorkspaceNamespaceMeta(Printable):
    """WorkspaceNamespaceMeta is the metadata associated with a workspace-namespace
    binding.
    """
    autoCreateNamespace: "typing.Optional[bool]" = None
    autoCreateNamespaceAllClusters: "typing.Optional[bool]" = None
    clusterName: "typing.Optional[str]" = None
    namespace: "typing.Optional[str]" = None
    resourceQuota: "typing.Optional[int]" = None

    def __init__(
        self,
        *,
        autoCreateNamespace: "typing.Union[bool, None, Unset]" = _unset,
        autoCreateNamespaceAllClusters: "typing.Union[bool, None, Unset]" = _unset,
        clusterName: "typing.Union[str, None, Unset]" = _unset,
        namespace: "typing.Union[str, None, Unset]" = _unset,
        resourceQuota: "typing.Union[int, None, Unset]" = _unset,
    ):
        if not isinstance(autoCreateNamespace, Unset):
            self.autoCreateNamespace = autoCreateNamespace
        if not isinstance(autoCreateNamespaceAllClusters, Unset):
            self.autoCreateNamespaceAllClusters = autoCreateNamespaceAllClusters
        if not isinstance(clusterName, Unset):
            self.clusterName = clusterName
        if not isinstance(namespace, Unset):
            self.namespace = namespace
        if not isinstance(resourceQuota, Unset):
            self.resourceQuota = resourceQuota

    @classmethod
    def from_json(cls, obj: Json) -> "v1WorkspaceNamespaceMeta":
        kwargs: "typing.Dict[str, typing.Any]" = {
        }
        if "autoCreateNamespace" in obj:
            kwargs["autoCreateNamespace"] = obj["autoCreateNamespace"]
        if "autoCreateNamespaceAllClusters" in obj:
            kwargs["autoCreateNamespaceAllClusters"] = obj["autoCreateNamespaceAllClusters"]
        if "clusterName" in obj:
            kwargs["clusterName"] = obj["clusterName"]
        if "namespace" in obj:
            kwargs["namespace"] = obj["namespace"]
        if "resourceQuota" in obj:
            kwargs["resourceQuota"] = obj["resourceQuota"]
        return cls(**kwargs)

    def to_json(self, omit_unset: bool = False) -> typing.Dict[str, typing.Any]:
        out: "typing.Dict[str, typing.Any]" = {
        }
        if not omit_unset or "autoCreateNamespace" in vars(self):
            out["autoCreateNamespace"] = self.autoCreateNamespace
        if not omit_unset or "autoCreateNamespaceAllClusters" in vars(self):
            out["autoCreateNamespaceAllClusters"] = self.autoCreateNamespaceAllClusters
        if not omit_unset or "clusterName" in vars(self):
            out["clusterName"] = self.clusterName
        if not omit_unset or "namespace" in vars(self):
            out["namespace"] = self.namespace
        if not omit_unset or "resourceQuota" in vars(self):
            out["resourceQuota"] = self.resourceQuota
        return out

class v1WorkspaceState(DetEnum):
    """WorkspaceState is used to track progress during a deletion.
    - WORKSPACE_STATE_UNSPECIFIED: Object deletion is not in progress.
    - WORKSPACE_STATE_DELETING: The object is being deleted.
    - WORKSPACE_STATE_DELETE_FAILED: The object failed to delete.
    - WORKSPACE_STATE_DELETED: The object finished deleting.
    """
    UNSPECIFIED = "WORKSPACE_STATE_UNSPECIFIED"
    DELETING = "WORKSPACE_STATE_DELETING"
    DELETE_FAILED = "WORKSPACE_STATE_DELETE_FAILED"
    DELETED = "WORKSPACE_STATE_DELETED"

def post_AckAllocationPreemptionSignal(
    session: "api.BaseSession",
    *,
    allocationId: str,
    body: "v1AckAllocationPreemptionSignalRequest",
) -> None:
    """Acknowledge the receipt of a signal to stop the given allocation early.
    This is used indicate and exit 0 isn't final; specifically, it is used
    for HP search directed early stops and preemption signals (not necessarily
    just scheduler preemption).

    - allocationId: The allocation that is acknowledging the request.
    """
    _params = None
    if type(allocationId) == str:
        allocationId = parse.quote(allocationId)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/allocations/{allocationId}/signals/ack_preemption",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_AckAllocationPreemptionSignal", _resp)

def post_ActivateExperiment(
    session: "api.BaseSession",
    *,
    id: int,
) -> None:
    """Activate an experiment.

    - id: The experiment id.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/experiments/{id}/activate",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_ActivateExperiment", _resp)

def post_ActivateExperiments(
    session: "api.BaseSession",
    *,
    body: "v1ActivateExperimentsRequest",
    projectId: int,
) -> "v1ActivateExperimentsResponse":
    """Activate multiple experiments.

    - projectId: Project id that the experiments belong to.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/projects/{projectId}/experiments/activate",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1ActivateExperimentsResponse.from_json(_resp.json())
    raise APIHttpError("post_ActivateExperiments", _resp)

def post_AddProjectNote(
    session: "api.BaseSession",
    *,
    body: "v1Note",
    projectId: int,
) -> "v1AddProjectNoteResponse":
    """Add a note to a project.

    - body: The note to add.
    - projectId: The id of the project.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/projects/{projectId}/notes",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1AddProjectNoteResponse.from_json(_resp.json())
    raise APIHttpError("post_AddProjectNote", _resp)

def post_AllocationAllGather(
    session: "api.BaseSession",
    *,
    allocationId: str,
    body: "v1AllocationAllGatherRequest",
) -> "v1AllocationAllGatherResponse":
    """AllocationAllGather performs an all gather through the master. An
    allocation can only perform once all gather at a time.

    - allocationId: The ID of the allocation.
    """
    _params = None
    if type(allocationId) == str:
        allocationId = parse.quote(allocationId)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/allocations/{allocationId}/all_gather",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1AllocationAllGatherResponse.from_json(_resp.json())
    raise APIHttpError("post_AllocationAllGather", _resp)

def post_AllocationPendingPreemptionSignal(
    session: "api.BaseSession",
    *,
    allocationId: str,
    body: "v1AllocationPendingPreemptionSignalRequest",
) -> None:
    """Report the receipt of a signal to stop the given allocation early.
    This is used to communicate back from a SLURM job that it has been
    notified of a pending preememption. Upon a call to this API
    the RM should then trigger a checkpoint and immediate exit.

    - allocationId: The id of the allocation.
    """
    _params = None
    if type(allocationId) == str:
        allocationId = parse.quote(allocationId)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/allocations/{allocationId}/signals/pending_preemption",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_AllocationPendingPreemptionSignal", _resp)

def get_AllocationPreemptionSignal(
    session: "api.BaseSession",
    *,
    allocationId: str,
    timeoutSeconds: "typing.Optional[int]" = None,
) -> "v1AllocationPreemptionSignalResponse":
    """Long poll preemption signals for the given allocation. If the allocation
    has been preempted when called, it will return so immediately. Otherwise,
    the connection will be kept open until the timeout is reached or
    the allocation is preempted.

    - allocationId: The id of the allocation.
    - timeoutSeconds: The timeout in seconds.
    """
    _params = {
        "timeoutSeconds": timeoutSeconds,
    }
    if type(allocationId) == str:
        allocationId = parse.quote(allocationId)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/allocations/{allocationId}/signals/preemption",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1AllocationPreemptionSignalResponse.from_json(_resp.json())
    raise APIHttpError("get_AllocationPreemptionSignal", _resp)

def post_AllocationReady(
    session: "api.BaseSession",
    *,
    allocationId: str,
    body: "v1AllocationReadyRequest",
) -> None:
    """Set allocation to ready state.

    - allocationId: The id of the allocation.
    """
    _params = None
    if type(allocationId) == str:
        allocationId = parse.quote(allocationId)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/allocations/{allocationId}/ready",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_AllocationReady", _resp)

def get_AllocationRendezvousInfo(
    session: "api.BaseSession",
    *,
    allocationId: str,
    resourcesId: str,
) -> "v1AllocationRendezvousInfoResponse":
    """Gather an allocation's rendezvous info. Blocks until all trial containers
    connect to gather their rendezvous information and responds to them all at
    once.

    - allocationId: The id of the allocation.
    - resourcesId: The id of the clump of resources.
    """
    _params = None
    if type(allocationId) == str:
        allocationId = parse.quote(allocationId)
    if type(resourcesId) == str:
        resourcesId = parse.quote(resourcesId)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/allocations/{allocationId}/resources/{resourcesId}/rendezvous",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1AllocationRendezvousInfoResponse.from_json(_resp.json())
    raise APIHttpError("get_AllocationRendezvousInfo", _resp)

def post_AllocationWaiting(
    session: "api.BaseSession",
    *,
    allocationId: str,
    body: "v1AllocationWaitingRequest",
) -> None:
    """Set allocation to waiting state.

    - allocationId: The id of the allocation.
    """
    _params = None
    if type(allocationId) == str:
        allocationId = parse.quote(allocationId)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/allocations/{allocationId}/waiting",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_AllocationWaiting", _resp)

def post_ArchiveExperiment(
    session: "api.BaseSession",
    *,
    id: int,
) -> None:
    """Archive an experiment.

    - id: The experiment id.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/experiments/{id}/archive",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_ArchiveExperiment", _resp)

def post_ArchiveExperiments(
    session: "api.BaseSession",
    *,
    body: "v1ArchiveExperimentsRequest",
    projectId: int,
) -> "v1ArchiveExperimentsResponse":
    """Archive multiple experiments.

    - projectId: Project id that the experiments belong to.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/projects/{projectId}/experiments/archive",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1ArchiveExperimentsResponse.from_json(_resp.json())
    raise APIHttpError("post_ArchiveExperiments", _resp)

def post_ArchiveModel(
    session: "api.BaseSession",
    *,
    modelName: str,
) -> None:
    """Archive a model

    - modelName: The name of the model to archive.
    """
    _params = None
    if type(modelName) == str:
        modelName = parse.quote(modelName)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/models/{modelName}/archive",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_ArchiveModel", _resp)

def post_ArchiveProject(
    session: "api.BaseSession",
    *,
    id: int,
) -> None:
    """Archive a project.

    - id: The id of the project.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/projects/{id}/archive",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_ArchiveProject", _resp)

def post_ArchiveRuns(
    session: "api.BaseSession",
    *,
    body: "v1ArchiveRunsRequest",
) -> "v1ArchiveRunsResponse":
    """Archive runs."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/runs/archive",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1ArchiveRunsResponse.from_json(_resp.json())
    raise APIHttpError("post_ArchiveRuns", _resp)

def post_ArchiveWorkspace(
    session: "api.BaseSession",
    *,
    id: int,
) -> None:
    """Archive a workspace.

    - id: The id of the workspace.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/workspaces/{id}/archive",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_ArchiveWorkspace", _resp)

def patch_AssignMultipleGroups(
    session: "api.BaseSession",
    *,
    body: "v1AssignMultipleGroupsRequest",
) -> None:
    """Assign multiple users to multiple groups."""
    _params = None
    _resp = session._do_request(
        method="PATCH",
        path="/api/v1/users/assignments",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("patch_AssignMultipleGroups", _resp)

def post_AssignRoles(
    session: "api.BaseSession",
    *,
    body: "v1AssignRolesRequest",
) -> None:
    """AssignRoles adds a set of role assignments to the system."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/roles/add-assignments",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_AssignRoles", _resp)

def post_BindRPToWorkspace(
    session: "api.BaseSession",
    *,
    body: "v1BindRPToWorkspaceRequest",
    resourcePoolName: str,
) -> None:
    """Bind resource pool to workspace

    - resourcePoolName: The resource pool name.
    """
    _params = None
    if type(resourcePoolName) == str:
        resourcePoolName = parse.quote(resourcePoolName)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/resource-pools/{resourcePoolName}/workspace-bindings",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_BindRPToWorkspace", _resp)

def post_BulkAutoCreateWorkspaceNamespaceBindings(
    session: "api.BaseSession",
    *,
    body: "v1BulkAutoCreateWorkspaceNamespaceBindingsRequest",
) -> None:
    """Binds the given workpaces to new auto-created namespaces."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/namespace-bindings/bulk-auto-create",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_BulkAutoCreateWorkspaceNamespaceBindings", _resp)

def post_CancelExperiment(
    session: "api.BaseSession",
    *,
    id: int,
) -> None:
    """Cancel an experiment.

    - id: The experiment id.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/experiments/{id}/cancel",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_CancelExperiment", _resp)

def post_CancelExperiments(
    session: "api.BaseSession",
    *,
    body: "v1CancelExperimentsRequest",
    projectId: int,
) -> "v1CancelExperimentsResponse":
    """Cancel multiple experiments.

    - projectId: Project id that the experiments belong to.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/projects/{projectId}/experiments/cancel",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1CancelExperimentsResponse.from_json(_resp.json())
    raise APIHttpError("post_CancelExperiments", _resp)

def post_CheckpointsRemoveFiles(
    session: "api.BaseSession",
    *,
    body: "v1CheckpointsRemoveFilesRequest",
) -> None:
    """Remove files from checkpoints."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/checkpoints/rm",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_CheckpointsRemoveFiles", _resp)

def post_CleanupLogs(
    session: "api.BaseSession",
) -> "v1CleanupLogsResponse":
    """Cleanup task logs according to the retention policy."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/cleanup_logs",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1CleanupLogsResponse.from_json(_resp.json())
    raise APIHttpError("post_CleanupLogs", _resp)

def get_CompareTrials(
    session: "api.BaseSession",
    *,
    endBatches: "typing.Optional[int]" = None,
    group: "typing.Optional[str]" = None,
    maxDatapoints: "typing.Optional[int]" = None,
    metricIds: "typing.Optional[typing.Sequence[str]]" = None,
    metricNames: "typing.Optional[typing.Sequence[str]]" = None,
    metricType: "typing.Optional[v1MetricType]" = None,
    startBatches: "typing.Optional[int]" = None,
    timeSeriesFilter_doubleRange_gt: "typing.Optional[float]" = None,
    timeSeriesFilter_doubleRange_gte: "typing.Optional[float]" = None,
    timeSeriesFilter_doubleRange_lt: "typing.Optional[float]" = None,
    timeSeriesFilter_doubleRange_lte: "typing.Optional[float]" = None,
    timeSeriesFilter_integerRange_gt: "typing.Optional[int]" = None,
    timeSeriesFilter_integerRange_gte: "typing.Optional[int]" = None,
    timeSeriesFilter_integerRange_incl: "typing.Optional[typing.Sequence[int]]" = None,
    timeSeriesFilter_integerRange_lt: "typing.Optional[int]" = None,
    timeSeriesFilter_integerRange_lte: "typing.Optional[int]" = None,
    timeSeriesFilter_integerRange_notIn: "typing.Optional[typing.Sequence[int]]" = None,
    timeSeriesFilter_name: "typing.Optional[str]" = None,
    timeSeriesFilter_timeRange_gt: "typing.Optional[str]" = None,
    timeSeriesFilter_timeRange_gte: "typing.Optional[str]" = None,
    timeSeriesFilter_timeRange_lt: "typing.Optional[str]" = None,
    timeSeriesFilter_timeRange_lte: "typing.Optional[str]" = None,
    trialIds: "typing.Optional[typing.Sequence[int]]" = None,
) -> "v1CompareTrialsResponse":
    """Return a downsampled time series of metrics from multiple trials to compare
    them side-by-side.

    - endBatches: Sample from metrics before this batch number.
    - group: Metric group (training, validation, etc).
    - maxDatapoints: The maximum number of data points to return after downsampling.
    - metricIds: metric ids for the query. must be in the form group.metric_name.
    - metricNames: The names of selected metrics.
    - metricType: Metric group.

 - METRIC_TYPE_UNSPECIFIED: Zero-value (not allowed).
 - METRIC_TYPE_TRAINING: For metrics emitted during training.
 - METRIC_TYPE_VALIDATION: For metrics emitted during validation.
 - METRIC_TYPE_PROFILING: For metrics emitted during profiling.
    - startBatches: Sample from metrics after this batch number.
    - timeSeriesFilter_doubleRange_gt: Greater than.
    - timeSeriesFilter_doubleRange_gte: Greater than or equal.
    - timeSeriesFilter_doubleRange_lt: Less than.
    - timeSeriesFilter_doubleRange_lte: Less than or equal.
    - timeSeriesFilter_integerRange_gt: Greater than.
    - timeSeriesFilter_integerRange_gte: Greater than or equal.
    - timeSeriesFilter_integerRange_incl: In a set. `in` is a reserved word in python.
    - timeSeriesFilter_integerRange_lt: Less than.
    - timeSeriesFilter_integerRange_lte: Less than or equal.
    - timeSeriesFilter_integerRange_notIn: Not in a set.
    - timeSeriesFilter_name: metric or column name for the filter.
    - timeSeriesFilter_timeRange_gt: Greater than.
    - timeSeriesFilter_timeRange_gte: Greater than or equal.
    - timeSeriesFilter_timeRange_lt: Less than.
    - timeSeriesFilter_timeRange_lte: Less than or equal.
    - trialIds: The requested trial ids.
    """
    _params = {
        "endBatches": endBatches,
        "group": group,
        "maxDatapoints": maxDatapoints,
        "metricIds": metricIds,
        "metricNames": metricNames,
        "metricType": metricType.value if metricType is not None else None,
        "startBatches": startBatches,
        "timeSeriesFilter.doubleRange.gt": dump_float(timeSeriesFilter_doubleRange_gt) if timeSeriesFilter_doubleRange_gt is not None else None,
        "timeSeriesFilter.doubleRange.gte": dump_float(timeSeriesFilter_doubleRange_gte) if timeSeriesFilter_doubleRange_gte is not None else None,
        "timeSeriesFilter.doubleRange.lt": dump_float(timeSeriesFilter_doubleRange_lt) if timeSeriesFilter_doubleRange_lt is not None else None,
        "timeSeriesFilter.doubleRange.lte": dump_float(timeSeriesFilter_doubleRange_lte) if timeSeriesFilter_doubleRange_lte is not None else None,
        "timeSeriesFilter.integerRange.gt": timeSeriesFilter_integerRange_gt,
        "timeSeriesFilter.integerRange.gte": timeSeriesFilter_integerRange_gte,
        "timeSeriesFilter.integerRange.incl": timeSeriesFilter_integerRange_incl,
        "timeSeriesFilter.integerRange.lt": timeSeriesFilter_integerRange_lt,
        "timeSeriesFilter.integerRange.lte": timeSeriesFilter_integerRange_lte,
        "timeSeriesFilter.integerRange.notIn": timeSeriesFilter_integerRange_notIn,
        "timeSeriesFilter.name": timeSeriesFilter_name,
        "timeSeriesFilter.timeRange.gt": timeSeriesFilter_timeRange_gt,
        "timeSeriesFilter.timeRange.gte": timeSeriesFilter_timeRange_gte,
        "timeSeriesFilter.timeRange.lt": timeSeriesFilter_timeRange_lt,
        "timeSeriesFilter.timeRange.lte": timeSeriesFilter_timeRange_lte,
        "trialIds": trialIds,
    }
    _resp = session._do_request(
        method="GET",
        path="/api/v1/trials/time-series",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1CompareTrialsResponse.from_json(_resp.json())
    raise APIHttpError("get_CompareTrials", _resp)

def post_ContinueExperiment(
    session: "api.BaseSession",
    *,
    body: "v1ContinueExperimentRequest",
) -> "v1ContinueExperimentResponse":
    """Continues an experiment either to make the existing experiment train longer
    or to retry it.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/experiments/continue",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1ContinueExperimentResponse.from_json(_resp.json())
    raise APIHttpError("post_ContinueExperiment", _resp)

def post_CreateExperiment(
    session: "api.BaseSession",
    *,
    body: "v1CreateExperimentRequest",
) -> "v1CreateExperimentResponse":
    """Create an experiment."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/experiments",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1CreateExperimentResponse.from_json(_resp.json())
    raise APIHttpError("post_CreateExperiment", _resp)

def post_CreateGenericTask(
    session: "api.BaseSession",
    *,
    body: "v1CreateGenericTaskRequest",
) -> "v1CreateGenericTaskResponse":
    """Create an experiment."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/generic-tasks",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1CreateGenericTaskResponse.from_json(_resp.json())
    raise APIHttpError("post_CreateGenericTask", _resp)

def post_CreateGroup(
    session: "api.BaseSession",
    *,
    body: "v1CreateGroupRequest",
) -> "v1CreateGroupResponse":
    """Create a group with optional members on creation."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/groups",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1CreateGroupResponse.from_json(_resp.json())
    raise APIHttpError("post_CreateGroup", _resp)

def post_CreateTrial(
    session: "api.BaseSession",
    *,
    body: "v1CreateTrialRequest",
) -> "v1CreateTrialResponse":
    """Create unmanaged trial."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/trials",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1CreateTrialResponse.from_json(_resp.json())
    raise APIHttpError("post_CreateTrial", _resp)

def get_CurrentUser(
    session: "api.BaseSession",
) -> "v1CurrentUserResponse":
    """Get the current user."""
    _params = None
    _resp = session._do_request(
        method="GET",
        path="/api/v1/auth/user",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1CurrentUserResponse.from_json(_resp.json())
    raise APIHttpError("get_CurrentUser", _resp)

def delete_DeleteCheckpoints(
    session: "api.BaseSession",
    *,
    body: "v1DeleteCheckpointsRequest",
) -> None:
    """Delete Checkpoints."""
    _params = None
    _resp = session._do_request(
        method="DELETE",
        path="/api/v1/checkpoints",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("delete_DeleteCheckpoints", _resp)

def delete_DeleteClusterMessage(
    session: "api.BaseSession",
) -> None:
    """Clear the cluster-wide message shown to all users."""
    _params = None
    _resp = session._do_request(
        method="DELETE",
        path="/api/v1/master/cluster_message",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("delete_DeleteClusterMessage", _resp)

def delete_DeleteExperiment(
    session: "api.BaseSession",
    *,
    experimentId: int,
) -> None:
    """Delete the requested experiment.

    - experimentId: The ID of the experiment.
    """
    _params = None
    _resp = session._do_request(
        method="DELETE",
        path=f"/api/v1/experiments/{experimentId}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("delete_DeleteExperiment", _resp)

def delete_DeleteExperimentLabel(
    session: "api.BaseSession",
    *,
    experimentId: int,
    label: str,
) -> "v1DeleteExperimentLabelResponse":
    """Delete a label from the experiment.

    - experimentId: The ID of the experiment.
    - label: The label to delete.
    """
    _params = None
    if type(label) == str:
        label = parse.quote(label)
    _resp = session._do_request(
        method="DELETE",
        path=f"/api/v1/experiments/{experimentId}/labels/{label}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1DeleteExperimentLabelResponse.from_json(_resp.json())
    raise APIHttpError("delete_DeleteExperimentLabel", _resp)

def delete_DeleteExperiments(
    session: "api.BaseSession",
    *,
    body: "v1DeleteExperimentsRequest",
    projectId: int,
) -> "v1DeleteExperimentsResponse":
    """Delete multiple experiments.

    - projectId: Project id that the experiments belong to.
    """
    _params = None
    _resp = session._do_request(
        method="DELETE",
        path=f"/api/v1/projects/{projectId}/experiments/delete",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1DeleteExperimentsResponse.from_json(_resp.json())
    raise APIHttpError("delete_DeleteExperiments", _resp)

def delete_DeleteGlobalConfigPolicies(
    session: "api.BaseSession",
    *,
    workloadType: str,
) -> None:
    """Delete global task config policies.

    - workloadType: The workload type the config policies apply to: EXPERIMENT or NTSC.
    """
    _params = None
    if type(workloadType) == str:
        workloadType = parse.quote(workloadType)
    _resp = session._do_request(
        method="DELETE",
        path=f"/api/v1/config-policies/global/{workloadType}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("delete_DeleteGlobalConfigPolicies", _resp)

def delete_DeleteGroup(
    session: "api.BaseSession",
    *,
    groupId: int,
) -> None:
    """Remove a group.

    - groupId: The id of the group that should be deleted.
    """
    _params = None
    _resp = session._do_request(
        method="DELETE",
        path=f"/api/v1/groups/{groupId}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("delete_DeleteGroup", _resp)

def delete_DeleteModel(
    session: "api.BaseSession",
    *,
    modelName: str,
) -> None:
    """Delete a model

    - modelName: The name of the model to delete.
    """
    _params = None
    if type(modelName) == str:
        modelName = parse.quote(modelName)
    _resp = session._do_request(
        method="DELETE",
        path=f"/api/v1/models/{modelName}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("delete_DeleteModel", _resp)

def delete_DeleteModelVersion(
    session: "api.BaseSession",
    *,
    modelName: str,
    modelVersionNum: int,
) -> None:
    """Delete a model version

    - modelName: The name of the model associated with the model version.
    - modelVersionNum: Sequential model version number.
    """
    _params = None
    if type(modelName) == str:
        modelName = parse.quote(modelName)
    _resp = session._do_request(
        method="DELETE",
        path=f"/api/v1/models/{modelName}/versions/{modelVersionNum}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("delete_DeleteModelVersion", _resp)

def delete_DeleteProject(
    session: "api.BaseSession",
    *,
    id: int,
) -> "v1DeleteProjectResponse":
    """Delete a project.

    - id: The id of the project.
    """
    _params = None
    _resp = session._do_request(
        method="DELETE",
        path=f"/api/v1/projects/{id}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1DeleteProjectResponse.from_json(_resp.json())
    raise APIHttpError("delete_DeleteProject", _resp)

def post_DeleteRuns(
    session: "api.BaseSession",
    *,
    body: "v1DeleteRunsRequest",
) -> "v1DeleteRunsResponse":
    """Delete a list of runs."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/runs/delete",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1DeleteRunsResponse.from_json(_resp.json())
    raise APIHttpError("post_DeleteRuns", _resp)

def delete_DeleteTemplate(
    session: "api.BaseSession",
    *,
    templateName: str,
) -> None:
    """Delete a template.

    - templateName: The id of the template.
    """
    _params = None
    if type(templateName) == str:
        templateName = parse.quote(templateName)
    _resp = session._do_request(
        method="DELETE",
        path=f"/api/v1/templates/{templateName}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("delete_DeleteTemplate", _resp)

def delete_DeleteTensorboardFiles(
    session: "api.BaseSession",
    *,
    experimentId: int,
) -> None:
    """Delete tensorboard files.

    - experimentId: ID of experiment that the tensorboard files are linked to.
    """
    _params = None
    _resp = session._do_request(
        method="DELETE",
        path=f"/api/v1/experiments/{experimentId}/tensorboard-files",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("delete_DeleteTensorboardFiles", _resp)

def delete_DeleteWebhook(
    session: "api.BaseSession",
    *,
    id: int,
) -> None:
    """Delete a webhook.

    - id: The id of the webhook.
    """
    _params = None
    _resp = session._do_request(
        method="DELETE",
        path=f"/api/v1/webhooks/{id}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("delete_DeleteWebhook", _resp)

def delete_DeleteWorkspace(
    session: "api.BaseSession",
    *,
    id: int,
) -> "v1DeleteWorkspaceResponse":
    """Delete a workspace.

    - id: The id of the workspace.
    """
    _params = None
    _resp = session._do_request(
        method="DELETE",
        path=f"/api/v1/workspaces/{id}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1DeleteWorkspaceResponse.from_json(_resp.json())
    raise APIHttpError("delete_DeleteWorkspace", _resp)

def delete_DeleteWorkspaceConfigPolicies(
    session: "api.BaseSession",
    *,
    workloadType: str,
    workspaceId: int,
) -> None:
    """Delete workspace task config policies.

    - workloadType: The workload type the config policies apply to: EXPERIMENT or NTSC.
    - workspaceId: The workspace the config policies apply to. Use global API for
global config policies.
    """
    _params = None
    if type(workloadType) == str:
        workloadType = parse.quote(workloadType)
    _resp = session._do_request(
        method="DELETE",
        path=f"/api/v1/config-policies/workspaces/{workspaceId}/{workloadType}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("delete_DeleteWorkspaceConfigPolicies", _resp)

def delete_DeleteWorkspaceNamespaceBindings(
    session: "api.BaseSession",
    *,
    workspaceId: int,
    clusterNames: "typing.Optional[typing.Sequence[str]]" = None,
) -> None:
    """Deletes workpace namespace bindings.

    - workspaceId: The unique id of the workspace.
    - clusterNames: The names of the clusters to delete the bindings for.
    """
    _params = {
        "clusterNames": clusterNames,
    }
    _resp = session._do_request(
        method="DELETE",
        path=f"/api/v1/workspaces/{workspaceId}/namespace-bindings",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("delete_DeleteWorkspaceNamespaceBindings", _resp)

def post_DisableAgent(
    session: "api.BaseSession",
    *,
    agentId: str,
    body: "v1DisableAgentRequest",
) -> "v1DisableAgentResponse":
    """Disable the agent.

    - agentId: The id of the agent.
    """
    _params = None
    if type(agentId) == str:
        agentId = parse.quote(agentId)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/agents/{agentId}/disable",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1DisableAgentResponse.from_json(_resp.json())
    raise APIHttpError("post_DisableAgent", _resp)

def post_DisableSlot(
    session: "api.BaseSession",
    *,
    agentId: str,
    body: "v1DisableSlotRequest",
    slotId: str,
) -> "v1DisableSlotResponse":
    """Disable the slot.

    - agentId: The id of the agent.
    - slotId: The id of the slot.
    """
    _params = None
    if type(agentId) == str:
        agentId = parse.quote(agentId)
    if type(slotId) == str:
        slotId = parse.quote(slotId)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/agents/{agentId}/slots/{slotId}/disable",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1DisableSlotResponse.from_json(_resp.json())
    raise APIHttpError("post_DisableSlot", _resp)

def post_EnableAgent(
    session: "api.BaseSession",
    *,
    agentId: str,
) -> "v1EnableAgentResponse":
    """Enable the agent.

    - agentId: The id of the agent.
    """
    _params = None
    if type(agentId) == str:
        agentId = parse.quote(agentId)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/agents/{agentId}/enable",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1EnableAgentResponse.from_json(_resp.json())
    raise APIHttpError("post_EnableAgent", _resp)

def post_EnableSlot(
    session: "api.BaseSession",
    *,
    agentId: str,
    slotId: str,
) -> "v1EnableSlotResponse":
    """Enable the slot.

    - agentId: The id of the agent.
    - slotId: The id of the slot.
    """
    _params = None
    if type(agentId) == str:
        agentId = parse.quote(agentId)
    if type(slotId) == str:
        slotId = parse.quote(slotId)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/agents/{agentId}/slots/{slotId}/enable",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1EnableSlotResponse.from_json(_resp.json())
    raise APIHttpError("post_EnableSlot", _resp)

def get_ExpMetricNames(
    session: "api.BaseSession",
    *,
    ids: "typing.Sequence[int]",
    periodSeconds: "typing.Optional[int]" = None,
) -> "typing.Iterable[v1ExpMetricNamesResponse]":
    """Get the set of metric names recorded for a list of experiments.

    - ids: The ids for the experiments.
    - periodSeconds: Seconds to wait when polling for updates.
    """
    _params = {
        "ids": ids,
        "periodSeconds": periodSeconds,
    }
    _resp = session._do_request(
        method="GET",
        path="/api/v1/experiments/metrics-stream/metric-names",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=True,
    )
    if _resp.status_code == 200:
        try:
            for _line in _resp.iter_lines(chunk_size=1024 * 1024):
                _j = json.loads(_line)
                if "error" in _j:
                    raise APIHttpStreamError(
                        "get_ExpMetricNames",
                        runtimeStreamError.from_json(_j["error"])
                )
                yield v1ExpMetricNamesResponse.from_json(_j["result"])
        except requests.exceptions.ChunkedEncodingError:
            raise APIHttpStreamError("get_ExpMetricNames", runtimeStreamError(message="ChunkedEncodingError"))
        return
    raise APIHttpError("get_ExpMetricNames", _resp)

def get_GetAccessTokens(
    session: "api.BaseSession",
    *,
    limit: "typing.Optional[int]" = None,
    offset: "typing.Optional[int]" = None,
    orderBy: "typing.Optional[v1OrderBy]" = None,
    showInactive: "typing.Optional[bool]" = None,
    sortBy: "typing.Optional[v1GetAccessTokensRequestSortBy]" = None,
    tokenIds: "typing.Optional[typing.Sequence[int]]" = None,
    username: "typing.Optional[str]" = None,
) -> "v1GetAccessTokensResponse":
    """Get a list of all access token records.

    - limit: Limit the number of projects. A value of 0 denotes no limit.
    - offset: Skip the number of projects before returning results. Negative values
denote number of projects to skip from the end before returning results.
    - orderBy: Order token info in either ascending or descending order.

 - ORDER_BY_UNSPECIFIED: Returns records in no specific order.
 - ORDER_BY_ASC: Returns records in ascending order.
 - ORDER_BY_DESC: Returns records in descending order.
    - showInactive: Filter by active status.
    - sortBy: Sort token info by the given field.

 - SORT_BY_UNSPECIFIED: Returns token info in an unsorted list.
 - SORT_BY_USER_ID: Returns token info sorted by user id.
 - SORT_BY_EXPIRY: Returns token info sorted by expiry.
 - SORT_BY_CREATED_AT: Returns token info sorted by created at.
 - SORT_BY_TOKEN_TYPE: Returns token info sorted by token type.
 - SORT_BY_REVOKED: Returns token info sorted by if it is revoked.
 - SORT_BY_DESCRIPTION: Returns token info sorted by description of token.
    - tokenIds: Filter on token_ids.
    - username: Filter by username.
    """
    _params = {
        "limit": limit,
        "offset": offset,
        "orderBy": orderBy.value if orderBy is not None else None,
        "showInactive": str(showInactive).lower() if showInactive is not None else None,
        "sortBy": sortBy.value if sortBy is not None else None,
        "tokenIds": tokenIds,
        "username": username,
    }
    _resp = session._do_request(
        method="GET",
        path="/api/v1/tokens",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetAccessTokensResponse.from_json(_resp.json())
    raise APIHttpError("get_GetAccessTokens", _resp)

def get_GetActiveTasksCount(
    session: "api.BaseSession",
) -> "v1GetActiveTasksCountResponse":
    """Get a count of active tasks."""
    _params = None
    _resp = session._do_request(
        method="GET",
        path="/api/v1/tasks/count",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetActiveTasksCountResponse.from_json(_resp.json())
    raise APIHttpError("get_GetActiveTasksCount", _resp)

def get_GetAgent(
    session: "api.BaseSession",
    *,
    agentId: str,
) -> "v1GetAgentResponse":
    """Get the requested agent.

    - agentId: The id of the agent.
    """
    _params = None
    if type(agentId) == str:
        agentId = parse.quote(agentId)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/agents/{agentId}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetAgentResponse.from_json(_resp.json())
    raise APIHttpError("get_GetAgent", _resp)

def get_GetAgents(
    session: "api.BaseSession",
    *,
    excludeContainers: "typing.Optional[bool]" = None,
    excludeSlots: "typing.Optional[bool]" = None,
    limit: "typing.Optional[int]" = None,
    offset: "typing.Optional[int]" = None,
    orderBy: "typing.Optional[v1OrderBy]" = None,
    sortBy: "typing.Optional[v1GetAgentsRequestSortBy]" = None,
) -> "v1GetAgentsResponse":
    """Get a set of agents from the cluster.

    - excludeContainers: exclude containers.
    - excludeSlots: exclude slots.
    - limit: Limit the number of agents. A value of 0 denotes no limit.
    - offset: Skip the number of agents before returning results. Negative values
denote number of agents to skip from the end before returning results.
    - orderBy: Order agents in either ascending or descending order.

 - ORDER_BY_UNSPECIFIED: Returns records in no specific order.
 - ORDER_BY_ASC: Returns records in ascending order.
 - ORDER_BY_DESC: Returns records in descending order.
    - sortBy: Sort agents by the given field.

 - SORT_BY_UNSPECIFIED: Returns agents in an unsorted list.
 - SORT_BY_ID: Returns agents sorted by id.
 - SORT_BY_TIME: Returns agents sorted by time.
    """
    _params = {
        "excludeContainers": str(excludeContainers).lower() if excludeContainers is not None else None,
        "excludeSlots": str(excludeSlots).lower() if excludeSlots is not None else None,
        "limit": limit,
        "offset": offset,
        "orderBy": orderBy.value if orderBy is not None else None,
        "sortBy": sortBy.value if sortBy is not None else None,
    }
    _resp = session._do_request(
        method="GET",
        path="/api/v1/agents",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetAgentsResponse.from_json(_resp.json())
    raise APIHttpError("get_GetAgents", _resp)

def get_GetAllocation(
    session: "api.BaseSession",
    *,
    allocationId: str,
) -> "v1GetAllocationResponse":
    """Get details about an Allocation.

    - allocationId: The id of the allocation.
    """
    _params = None
    if type(allocationId) == str:
        allocationId = parse.quote(allocationId)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/allocations/{allocationId}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetAllocationResponse.from_json(_resp.json())
    raise APIHttpError("get_GetAllocation", _resp)

def get_GetBestSearcherValidationMetric(
    session: "api.BaseSession",
    *,
    experimentId: int,
) -> "v1GetBestSearcherValidationMetricResponse":
    """Get the best searcher validation for an experiment by the given metric.

    - experimentId: The ID of the experiment.
    """
    _params = None
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/experiments/{experimentId}/searcher/best_searcher_validation_metric",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetBestSearcherValidationMetricResponse.from_json(_resp.json())
    raise APIHttpError("get_GetBestSearcherValidationMetric", _resp)

def get_GetCheckpoint(
    session: "api.BaseSession",
    *,
    checkpointUuid: str,
) -> "v1GetCheckpointResponse":
    """Get the requested checkpoint.

    - checkpointUuid: The uuid for the requested checkpoint.
    """
    _params = None
    if type(checkpointUuid) == str:
        checkpointUuid = parse.quote(checkpointUuid)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/checkpoints/{checkpointUuid}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetCheckpointResponse.from_json(_resp.json())
    raise APIHttpError("get_GetCheckpoint", _resp)

def get_GetClusterMessage(
    session: "api.BaseSession",
) -> "v1GetClusterMessageResponse":
    """Get the currently configured cluster-wide message."""
    _params = None
    _resp = session._do_request(
        method="GET",
        path="/api/v1/master/cluster_message",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetClusterMessageResponse.from_json(_resp.json())
    raise APIHttpError("get_GetClusterMessage", _resp)

def get_GetCommand(
    session: "api.BaseSession",
    *,
    commandId: str,
) -> "v1GetCommandResponse":
    """Get the requested command.

    - commandId: The id of the command.
    """
    _params = None
    if type(commandId) == str:
        commandId = parse.quote(commandId)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/commands/{commandId}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetCommandResponse.from_json(_resp.json())
    raise APIHttpError("get_GetCommand", _resp)

def get_GetCommands(
    session: "api.BaseSession",
    *,
    limit: "typing.Optional[int]" = None,
    offset: "typing.Optional[int]" = None,
    orderBy: "typing.Optional[v1OrderBy]" = None,
    sortBy: "typing.Optional[v1GetTensorboardsRequestSortBy]" = None,
    userIds: "typing.Optional[typing.Sequence[int]]" = None,
    users: "typing.Optional[typing.Sequence[str]]" = None,
    workspaceId: "typing.Optional[int]" = None,
) -> "v1GetCommandsResponse":
    """Get a list of commands.

    - limit: Limit the number of commands. A value of 0 denotes no limit.
    - offset: Skip the number of commands before returning results. Negative values
denote number of commands to skip from the end before returning results.
    - orderBy: Order commands in either ascending or descending order.

 - ORDER_BY_UNSPECIFIED: Returns records in no specific order.
 - ORDER_BY_ASC: Returns records in ascending order.
 - ORDER_BY_DESC: Returns records in descending order.
    - sortBy: Sort commands by the given field.

 - SORT_BY_UNSPECIFIED: Returns commands in an unsorted list.
 - SORT_BY_ID: Returns commands sorted by id.
 - SORT_BY_DESCRIPTION: Returns commands sorted by description.
 - SORT_BY_START_TIME: Return commands sorted by start time.
 - SORT_BY_WORKSPACE_ID: Return commands sorted by workspace_id.
    - userIds: Limit commands to those that are owned by users with the specified userIds.
    - users: Limit commands to those that are owned by users with the specified
usernames.
    - workspaceId: Limit commands to those within a specific workspace, or 0 for all
accessible workspaces.
    """
    _params = {
        "limit": limit,
        "offset": offset,
        "orderBy": orderBy.value if orderBy is not None else None,
        "sortBy": sortBy.value if sortBy is not None else None,
        "userIds": userIds,
        "users": users,
        "workspaceId": workspaceId,
    }
    _resp = session._do_request(
        method="GET",
        path="/api/v1/commands",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetCommandsResponse.from_json(_resp.json())
    raise APIHttpError("get_GetCommands", _resp)

def get_GetExperiment(
    session: "api.BaseSession",
    *,
    experimentId: int,
) -> "v1GetExperimentResponse":
    """Get the requested experiment.

    - experimentId: The id of the experiment.
    """
    _params = None
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/experiments/{experimentId}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetExperimentResponse.from_json(_resp.json())
    raise APIHttpError("get_GetExperiment", _resp)

def get_GetExperimentCheckpoints(
    session: "api.BaseSession",
    *,
    id: int,
    limit: "typing.Optional[int]" = None,
    offset: "typing.Optional[int]" = None,
    orderBy: "typing.Optional[v1OrderBy]" = None,
    sortByAttr: "typing.Optional[checkpointv1SortBy]" = None,
    sortByMetric: "typing.Optional[str]" = None,
    states: "typing.Optional[typing.Sequence[checkpointv1State]]" = None,
) -> "v1GetExperimentCheckpointsResponse":
    """Get a list of checkpoints for an experiment.

    - id: The experiment id.
    - limit: Limit the number of checkpoints. A value of 0 denotes no limit.
    - offset: Skip the number of checkpoints before returning results. Negative values
denote number of checkpoints to skip from the end before returning results.
    - orderBy: Order checkpoints in either ascending or descending order.

 - ORDER_BY_UNSPECIFIED: Returns records in no specific order.
 - ORDER_BY_ASC: Returns records in ascending order.
 - ORDER_BY_DESC: Returns records in descending order.
    - sortByAttr: Sort by preset checkpoint attribute.

 - SORT_BY_UNSPECIFIED: Returns checkpoints in an unsorted list.
 - SORT_BY_UUID: Returns checkpoints sorted by UUID.
 - SORT_BY_TRIAL_ID: Returns checkpoints sorted by trial id.
 - SORT_BY_BATCH_NUMBER: Returns checkpoints sorted by batch number.
 - SORT_BY_END_TIME: Returns checkpoints sorted by end time.
 - SORT_BY_STATE: Returns checkpoints sorted by state.
 - SORT_BY_SEARCHER_METRIC: Returns checkpoints sorted by the experiment's `searcher.metric`
configuration setting.
    - sortByMetric: Sort by custom validation metric name.
    - states: Limit the checkpoints to those that match the states.

 - STATE_UNSPECIFIED: The state of the checkpoint is unknown.
 - STATE_ACTIVE: The checkpoint is in an active state.
 - STATE_COMPLETED: The checkpoint is persisted to checkpoint storage.
 - STATE_ERROR: The checkpoint errored.
 - STATE_DELETED: The checkpoint has been deleted.
 - STATE_PARTIALLY_DELETED: The checkpoint has been partially deleted.
    """
    _params = {
        "limit": limit,
        "offset": offset,
        "orderBy": orderBy.value if orderBy is not None else None,
        "sortByAttr": sortByAttr.value if sortByAttr is not None else None,
        "sortByMetric": sortByMetric,
        "states": [x.value for x in states] if states is not None else None,
    }
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/experiments/{id}/checkpoints",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetExperimentCheckpointsResponse.from_json(_resp.json())
    raise APIHttpError("get_GetExperimentCheckpoints", _resp)

def get_GetExperimentLabels(
    session: "api.BaseSession",
    *,
    projectId: "typing.Optional[int]" = None,
) -> "v1GetExperimentLabelsResponse":
    """Get a list of unique experiment labels (sorted by popularity).

    - projectId: Filter experiments by project.
    """
    _params = {
        "projectId": projectId,
    }
    _resp = session._do_request(
        method="GET",
        path="/api/v1/experiment/labels",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetExperimentLabelsResponse.from_json(_resp.json())
    raise APIHttpError("get_GetExperimentLabels", _resp)

def get_GetExperimentTrials(
    session: "api.BaseSession",
    *,
    experimentId: int,
    limit: "typing.Optional[int]" = None,
    offset: "typing.Optional[int]" = None,
    orderBy: "typing.Optional[v1OrderBy]" = None,
    sortBy: "typing.Optional[v1GetExperimentTrialsRequestSortBy]" = None,
    states: "typing.Optional[typing.Sequence[experimentv1State]]" = None,
) -> "v1GetExperimentTrialsResponse":
    """Get the list of trials for an experiment.

    - experimentId: Limit trials to those that are owned by the specified experiments.
    - limit: Limit the number of trials. A value of 0 denotes no limit.
    - offset: Skip the number of trials before returning results. Negative values
denote number of trials to skip from the end before returning results.
    - orderBy: Order trials in either ascending or descending order.

 - ORDER_BY_UNSPECIFIED: Returns records in no specific order.
 - ORDER_BY_ASC: Returns records in ascending order.
 - ORDER_BY_DESC: Returns records in descending order.
    - sortBy: Sort trials by the given field.

 - SORT_BY_UNSPECIFIED: Returns trials in an unsorted list.
 - SORT_BY_ID: Returns trials sorted by id.
 - SORT_BY_START_TIME: Return trials sorted by start time.
 - SORT_BY_END_TIME: Return trials sorted by end time. Trials without end times are
returned after trials that are.
 - SORT_BY_STATE: Return trials sorted by state.
 - SORT_BY_BEST_VALIDATION_METRIC: Return the trials sorted by the best metric so far, where the metric is
specified by `searcher.metric` in the experiment configuration.
 - SORT_BY_LATEST_VALIDATION_METRIC: Return the trials sorted by the latest metric so far, where the metric is
specified by `searcher.metric` in the experiment configuration.
 - SORT_BY_BATCHES_PROCESSED: Return the trials sorted by the number of batches completed.
 - SORT_BY_DURATION: Return the trials sorted by the total duration.
 - SORT_BY_RESTARTS: Return the trials sorted by the number of restarts.
 - SORT_BY_CHECKPOINT_SIZE: Return the trials sorted by checkpoint size.
 - SORT_BY_LOG_RETENTION_DAYS: Return the trials sorted by number of log retention days.
    - states: Limit trials to those that match the provided state.

 - STATE_UNSPECIFIED: The state of the experiment is unknown.
 - STATE_ACTIVE: The experiment is in an active state.
 - STATE_PAUSED: The experiment is in a paused state
 - STATE_STOPPING_COMPLETED: The experiment is completed and is shutting down.
 - STATE_STOPPING_CANCELED: The experiment is canceled and is shutting down.
 - STATE_STOPPING_ERROR: The experiment is errored and is shutting down.
 - STATE_COMPLETED: The experiment is completed and is shut down.
 - STATE_CANCELED: The experiment is canceled and is shut down.
 - STATE_ERROR: The experiment is errored and is shut down.
 - STATE_DELETED: The experiment has been deleted.
 - STATE_DELETING: The experiment is deleting.
 - STATE_DELETE_FAILED: The experiment failed to delete.
 - STATE_STOPPING_KILLED: The experiment is killed and is shutting down.
 - STATE_QUEUED: The experiment is queued (waiting to be run, or job state is still queued).
Queued is a substate of the Active state.
 - STATE_PULLING: The experiment is pulling the image. Pulling is a substate of the Active
state.
 - STATE_STARTING: The experiment is preparing the environment after finishing pulling the
image. Starting is a substate of the Active state.
 - STATE_RUNNING: The experiment has an allocation actively running.
Running is a substate of the Active state.
    """
    _params = {
        "limit": limit,
        "offset": offset,
        "orderBy": orderBy.value if orderBy is not None else None,
        "sortBy": sortBy.value if sortBy is not None else None,
        "states": [x.value for x in states] if states is not None else None,
    }
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/experiments/{experimentId}/trials",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetExperimentTrialsResponse.from_json(_resp.json())
    raise APIHttpError("get_GetExperimentTrials", _resp)

def get_GetExperimentValidationHistory(
    session: "api.BaseSession",
    *,
    experimentId: int,
) -> "v1GetExperimentValidationHistoryResponse":
    """Get the validation history for an experiment.

    - experimentId: The id of the experiment.
    """
    _params = None
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/experiments/{experimentId}/validation-history",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetExperimentValidationHistoryResponse.from_json(_resp.json())
    raise APIHttpError("get_GetExperimentValidationHistory", _resp)

def get_GetExperiments(
    session: "api.BaseSession",
    *,
    archived: "typing.Optional[bool]" = None,
    description: "typing.Optional[str]" = None,
    experimentIdFilter_gt: "typing.Optional[int]" = None,
    experimentIdFilter_gte: "typing.Optional[int]" = None,
    experimentIdFilter_incl: "typing.Optional[typing.Sequence[int]]" = None,
    experimentIdFilter_lt: "typing.Optional[int]" = None,
    experimentIdFilter_lte: "typing.Optional[int]" = None,
    experimentIdFilter_notIn: "typing.Optional[typing.Sequence[int]]" = None,
    labels: "typing.Optional[typing.Sequence[str]]" = None,
    limit: "typing.Optional[int]" = None,
    name: "typing.Optional[str]" = None,
    offset: "typing.Optional[int]" = None,
    orderBy: "typing.Optional[v1OrderBy]" = None,
    projectId: "typing.Optional[int]" = None,
    showTrialData: "typing.Optional[bool]" = None,
    sortBy: "typing.Optional[v1GetExperimentsRequestSortBy]" = None,
    states: "typing.Optional[typing.Sequence[experimentv1State]]" = None,
    userIds: "typing.Optional[typing.Sequence[int]]" = None,
    users: "typing.Optional[typing.Sequence[str]]" = None,
) -> "v1GetExperimentsResponse":
    """Get a list of experiments.

    - archived: Limit experiments to those that are archived.
    - description: Limit experiments to those that match the description.
    - experimentIdFilter_gt: Greater than.
    - experimentIdFilter_gte: Greater than or equal.
    - experimentIdFilter_incl: In a set. `in` is a reserved word in python.
    - experimentIdFilter_lt: Less than.
    - experimentIdFilter_lte: Less than or equal.
    - experimentIdFilter_notIn: Not in a set.
    - labels: Limit experiments to those that match the provided labels.
    - limit: Limit the number of experiments.
0 or Unspecified - returns a default of 100.
-1               - returns everything.
-2               - returns pagination info but no experiments.
    - name: Limit experiments to those that match the name.
    - offset: Skip the number of experiments before returning results. Negative values
denote number of experiments to skip from the end before returning results.
    - orderBy: Order experiments in either ascending or descending order.

 - ORDER_BY_UNSPECIFIED: Returns records in no specific order.
 - ORDER_BY_ASC: Returns records in ascending order.
 - ORDER_BY_DESC: Returns records in descending order.
    - projectId: Limit experiments to those within a specified project, or 0 for all
projects.
    - showTrialData: whether to surface trial specific data from the best trial.
    - sortBy: Sort experiments by the given field.

 - SORT_BY_UNSPECIFIED: Returns experiments in an unsorted list.
 - SORT_BY_ID: Returns experiments sorted by id.
 - SORT_BY_DESCRIPTION: Returns experiments sorted by description.
 - SORT_BY_START_TIME: Return experiments sorted by start time.
 - SORT_BY_END_TIME: Return experiments sorted by end time. Experiments without end_time are
returned after the ones with end_time.
 - SORT_BY_STATE: Return experiments sorted by state.
 - SORT_BY_NUM_TRIALS: Return experiments sorted by number of trials.
 - SORT_BY_PROGRESS: Return experiments sorted by progress.
 - SORT_BY_USER: Return experiments sorted by user.
 - SORT_BY_NAME: Returns experiments sorted by name.
 - SORT_BY_FORKED_FROM: Returns experiments sorted by originating model.
 - SORT_BY_RESOURCE_POOL: Returns experiments sorted by resource pool.
 - SORT_BY_PROJECT_ID: Returns experiments sorted by project.
 - SORT_BY_CHECKPOINT_SIZE: Returns experiments sorted by checkpoint size.
 - SORT_BY_CHECKPOINT_COUNT: Returns experiments sorted by checkpoint count.
 - SORT_BY_SEARCHER_METRIC_VAL: Returns experiments sorted by searcher metric value..
    - states: Limit experiments to those that match the provided state.

 - STATE_UNSPECIFIED: The state of the experiment is unknown.
 - STATE_ACTIVE: The experiment is in an active state.
 - STATE_PAUSED: The experiment is in a paused state
 - STATE_STOPPING_COMPLETED: The experiment is completed and is shutting down.
 - STATE_STOPPING_CANCELED: The experiment is canceled and is shutting down.
 - STATE_STOPPING_ERROR: The experiment is errored and is shutting down.
 - STATE_COMPLETED: The experiment is completed and is shut down.
 - STATE_CANCELED: The experiment is canceled and is shut down.
 - STATE_ERROR: The experiment is errored and is shut down.
 - STATE_DELETED: The experiment has been deleted.
 - STATE_DELETING: The experiment is deleting.
 - STATE_DELETE_FAILED: The experiment failed to delete.
 - STATE_STOPPING_KILLED: The experiment is killed and is shutting down.
 - STATE_QUEUED: The experiment is queued (waiting to be run, or job state is still queued).
Queued is a substate of the Active state.
 - STATE_PULLING: The experiment is pulling the image. Pulling is a substate of the Active
state.
 - STATE_STARTING: The experiment is preparing the environment after finishing pulling the
image. Starting is a substate of the Active state.
 - STATE_RUNNING: The experiment has an allocation actively running.
Running is a substate of the Active state.
    - userIds: Limit experiments to those that are owned by users with the specified
userIds.
    - users: Limit experiments to those that are owned by users with the specified
usernames.
    """
    _params = {
        "archived": str(archived).lower() if archived is not None else None,
        "description": description,
        "experimentIdFilter.gt": experimentIdFilter_gt,
        "experimentIdFilter.gte": experimentIdFilter_gte,
        "experimentIdFilter.incl": experimentIdFilter_incl,
        "experimentIdFilter.lt": experimentIdFilter_lt,
        "experimentIdFilter.lte": experimentIdFilter_lte,
        "experimentIdFilter.notIn": experimentIdFilter_notIn,
        "labels": labels,
        "limit": limit,
        "name": name,
        "offset": offset,
        "orderBy": orderBy.value if orderBy is not None else None,
        "projectId": projectId,
        "showTrialData": str(showTrialData).lower() if showTrialData is not None else None,
        "sortBy": sortBy.value if sortBy is not None else None,
        "states": [x.value for x in states] if states is not None else None,
        "userIds": userIds,
        "users": users,
    }
    _resp = session._do_request(
        method="GET",
        path="/api/v1/experiments",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetExperimentsResponse.from_json(_resp.json())
    raise APIHttpError("get_GetExperiments", _resp)

def get_GetGenericTaskConfig(
    session: "api.BaseSession",
    *,
    taskId: str,
) -> "v1GetGenericTaskConfigResponse":
    """Get task config

    - taskId: The id of the task.
    """
    _params = None
    if type(taskId) == str:
        taskId = parse.quote(taskId)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/tasks/{taskId}/config",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetGenericTaskConfigResponse.from_json(_resp.json())
    raise APIHttpError("get_GetGenericTaskConfig", _resp)

def get_GetGlobalConfigPolicies(
    session: "api.BaseSession",
    *,
    workloadType: str,
) -> "v1GetGlobalConfigPoliciesResponse":
    """Get global task config policies.

    - workloadType: The workload type the config policies apply to: EXPERIMENT or NTSC.
    """
    _params = None
    if type(workloadType) == str:
        workloadType = parse.quote(workloadType)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/config-policies/global/{workloadType}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetGlobalConfigPoliciesResponse.from_json(_resp.json())
    raise APIHttpError("get_GetGlobalConfigPolicies", _resp)

def get_GetGroup(
    session: "api.BaseSession",
    *,
    groupId: int,
) -> "v1GetGroupResponse":
    """Get a group by id.

    - groupId: The id of the group to return.
    """
    _params = None
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/groups/{groupId}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetGroupResponse.from_json(_resp.json())
    raise APIHttpError("get_GetGroup", _resp)

def post_GetGroups(
    session: "api.BaseSession",
    *,
    body: "v1GetGroupsRequest",
) -> "v1GetGroupsResponse":
    """Search for groups with optional filters."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/groups/search",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetGroupsResponse.from_json(_resp.json())
    raise APIHttpError("post_GetGroups", _resp)

def get_GetGroupsAndUsersAssignedToWorkspace(
    session: "api.BaseSession",
    *,
    workspaceId: int,
    name: "typing.Optional[str]" = None,
) -> "v1GetGroupsAndUsersAssignedToWorkspaceResponse":
    """Get groups and users assigned to a given workspace with what roles are
    assigned.

    - workspaceId: ID of workspace getting groups and users.
    - name: Name of groups and users to search by. Name filters by group name for
groups. Name filters by display name then username if display name is null
for users.
    """
    _params = {
        "name": name,
    }
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/roles/workspace/{workspaceId}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetGroupsAndUsersAssignedToWorkspaceResponse.from_json(_resp.json())
    raise APIHttpError("get_GetGroupsAndUsersAssignedToWorkspace", _resp)

def get_GetJobQueueStats(
    session: "api.BaseSession",
    *,
    resourcePools: "typing.Optional[typing.Sequence[str]]" = None,
) -> "v1GetJobQueueStatsResponse":
    """Get job queue stats for a resource pool.

    - resourcePools: Filter the results based on a set of resource pools.
    """
    _params = {
        "resourcePools": resourcePools,
    }
    _resp = session._do_request(
        method="GET",
        path="/api/v1/job-queues/stats",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetJobQueueStatsResponse.from_json(_resp.json())
    raise APIHttpError("get_GetJobQueueStats", _resp)

def get_GetJobs(
    session: "api.BaseSession",
    *,
    limit: "typing.Optional[int]" = None,
    offset: "typing.Optional[int]" = None,
    orderBy: "typing.Optional[v1OrderBy]" = None,
    resourcePool: "typing.Optional[str]" = None,
    states: "typing.Optional[typing.Sequence[jobv1State]]" = None,
) -> "v1GetJobsResponse":
    """Get a list of jobs in queue.

    - limit: Pagination limit.
    - offset: Pagination offset.
    - orderBy: Order results in either ascending or descending order by the number of
jobs ahead.

 - ORDER_BY_UNSPECIFIED: Returns records in no specific order.
 - ORDER_BY_ASC: Returns records in ascending order.
 - ORDER_BY_DESC: Returns records in descending order.
    - resourcePool: The target resource-pool for agent resource manager.
    - states: Filter to jobs with states among those given.

 - STATE_UNSPECIFIED: Unspecified state.
 - STATE_QUEUED: Job is queued and waiting to be schedlued.
 - STATE_SCHEDULED: Job is scheduled.
 - STATE_SCHEDULED_BACKFILLED: Job is scheduled as a backfill.
    """
    _params = {
        "limit": limit,
        "offset": offset,
        "orderBy": orderBy.value if orderBy is not None else None,
        "resourcePool": resourcePool,
        "states": [x.value for x in states] if states is not None else None,
    }
    _resp = session._do_request(
        method="GET",
        path="/api/v1/job-queues",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetJobsResponse.from_json(_resp.json())
    raise APIHttpError("get_GetJobs", _resp)

def get_GetJobsV2(
    session: "api.BaseSession",
    *,
    limit: "typing.Optional[int]" = None,
    offset: "typing.Optional[int]" = None,
    orderBy: "typing.Optional[v1OrderBy]" = None,
    resourcePool: "typing.Optional[str]" = None,
    states: "typing.Optional[typing.Sequence[jobv1State]]" = None,
) -> "v1GetJobsV2Response":
    """Get a list of jobs in queue.

    - limit: Pagination limit.
    - offset: Pagination offset.
    - orderBy: Order results in either ascending or descending order by the number of
jobs ahead.

 - ORDER_BY_UNSPECIFIED: Returns records in no specific order.
 - ORDER_BY_ASC: Returns records in ascending order.
 - ORDER_BY_DESC: Returns records in descending order.
    - resourcePool: The target resource-pool for agent resource manager.
    - states: Filter to jobs with states among those given.

 - STATE_UNSPECIFIED: Unspecified state.
 - STATE_QUEUED: Job is queued and waiting to be schedlued.
 - STATE_SCHEDULED: Job is scheduled.
 - STATE_SCHEDULED_BACKFILLED: Job is scheduled as a backfill.
    """
    _params = {
        "limit": limit,
        "offset": offset,
        "orderBy": orderBy.value if orderBy is not None else None,
        "resourcePool": resourcePool,
        "states": [x.value for x in states] if states is not None else None,
    }
    _resp = session._do_request(
        method="GET",
        path="/api/v1/job-queues-v2",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetJobsV2Response.from_json(_resp.json())
    raise APIHttpError("get_GetJobsV2", _resp)

def get_GetKubernetesResourceManagers(
    session: "api.BaseSession",
) -> "v1GetKubernetesResourceManagersResponse":
    """Get a list of all Kubernetes cluster names."""
    _params = None
    _resp = session._do_request(
        method="GET",
        path="/api/v1/k8s-resource-managers",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetKubernetesResourceManagersResponse.from_json(_resp.json())
    raise APIHttpError("get_GetKubernetesResourceManagers", _resp)

def get_GetKubernetesResourceQuotas(
    session: "api.BaseSession",
    *,
    id: int,
) -> "v1GetKubernetesResourceQuotasResponse":
    """Get Kubernetes Resource Quotas for a workspace by the cluster name.

    - id: The unique id of the workspace.
    """
    _params = None
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/workspaces/{id}/get-k8s-resource-quotas",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetKubernetesResourceQuotasResponse.from_json(_resp.json())
    raise APIHttpError("get_GetKubernetesResourceQuotas", _resp)

def get_GetMaster(
    session: "api.BaseSession",
) -> "v1GetMasterResponse":
    """Get master information."""
    _params = None
    _resp = session._do_request(
        method="GET",
        path="/api/v1/master",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetMasterResponse.from_json(_resp.json())
    raise APIHttpError("get_GetMaster", _resp)

def get_GetMasterConfig(
    session: "api.BaseSession",
) -> "v1GetMasterConfigResponse":
    """Get master config."""
    _params = None
    _resp = session._do_request(
        method="GET",
        path="/api/v1/master/config",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetMasterConfigResponse.from_json(_resp.json())
    raise APIHttpError("get_GetMasterConfig", _resp)

def get_GetMe(
    session: "api.BaseSession",
) -> "v1GetMeResponse":
    """Get the current user."""
    _params = None
    _resp = session._do_request(
        method="GET",
        path="/api/v1/me",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetMeResponse.from_json(_resp.json())
    raise APIHttpError("get_GetMe", _resp)

def get_GetMetadataValues(
    session: "api.BaseSession",
    *,
    key: str,
    projectId: int,
) -> "v1GetMetadataValuesResponse":
    """Retrieve run metadata values for a given string typed key within
    a given project.

    - key: Metadata key
    - projectId: Project id
    """
    _params = None
    if type(key) == str:
        key = parse.quote(key)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/projects/{projectId}/metadata/{key}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetMetadataValuesResponse.from_json(_resp.json())
    raise APIHttpError("get_GetMetadataValues", _resp)

def get_GetMetrics(
    session: "api.BaseSession",
    *,
    group: str,
    trialIds: "typing.Sequence[int]",
) -> "typing.Iterable[v1GetMetricsResponse]":
    """Stream one or more trial's metrics.

    - group: The group of metrics to get eg 'training', 'validation', etc.
    - trialIds: Trial IDs to get metrics for.
    """
    _params = {
        "group": group,
        "trialIds": trialIds,
    }
    _resp = session._do_request(
        method="GET",
        path="/api/v1/trials/metrics/trial_metrics",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=True,
    )
    if _resp.status_code == 200:
        try:
            for _line in _resp.iter_lines(chunk_size=1024 * 1024):
                _j = json.loads(_line)
                if "error" in _j:
                    raise APIHttpStreamError(
                        "get_GetMetrics",
                        runtimeStreamError.from_json(_j["error"])
                )
                yield v1GetMetricsResponse.from_json(_j["result"])
        except requests.exceptions.ChunkedEncodingError:
            raise APIHttpStreamError("get_GetMetrics", runtimeStreamError(message="ChunkedEncodingError"))
        return
    raise APIHttpError("get_GetMetrics", _resp)

def get_GetModel(
    session: "api.BaseSession",
    *,
    modelName: str,
) -> "v1GetModelResponse":
    """Get the requested model.

    - modelName: The name of the model.
    """
    _params = None
    if type(modelName) == str:
        modelName = parse.quote(modelName)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/models/{modelName}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetModelResponse.from_json(_resp.json())
    raise APIHttpError("get_GetModel", _resp)

def get_GetModelDef(
    session: "api.BaseSession",
    *,
    experimentId: int,
) -> "v1GetModelDefResponse":
    """Get the model definition of an experiment.

    - experimentId: The id of the experiment.
    """
    _params = None
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/experiments/{experimentId}/model_def",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetModelDefResponse.from_json(_resp.json())
    raise APIHttpError("get_GetModelDef", _resp)

def post_GetModelDefFile(
    session: "api.BaseSession",
    *,
    body: "v1GetModelDefFileRequest",
    experimentId: int,
) -> "v1GetModelDefFileResponse":
    """Get one file content of model definition of an experiment.

    - experimentId: The id of the experiment.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/experiments/{experimentId}/file",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetModelDefFileResponse.from_json(_resp.json())
    raise APIHttpError("post_GetModelDefFile", _resp)

def get_GetModelDefTree(
    session: "api.BaseSession",
    *,
    experimentId: int,
) -> "v1GetModelDefTreeResponse":
    """Get the model definition file tree of an experiment.

    - experimentId: The id of the experiment.
    """
    _params = None
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/experiments/{experimentId}/file_tree",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetModelDefTreeResponse.from_json(_resp.json())
    raise APIHttpError("get_GetModelDefTree", _resp)

def get_GetModelLabels(
    session: "api.BaseSession",
    *,
    workspaceId: "typing.Optional[int]" = None,
) -> "v1GetModelLabelsResponse":
    """Get a list of unique model labels (sorted by popularity).

    - workspaceId: Optional workspace ID to limit query for model tags.
    """
    _params = {
        "workspaceId": workspaceId,
    }
    _resp = session._do_request(
        method="GET",
        path="/api/v1/model/labels",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetModelLabelsResponse.from_json(_resp.json())
    raise APIHttpError("get_GetModelLabels", _resp)

def get_GetModelVersion(
    session: "api.BaseSession",
    *,
    modelName: str,
    modelVersionNum: int,
) -> "v1GetModelVersionResponse":
    """Get the requested model version.

    - modelName: The name of the model.
    - modelVersionNum: Sequential model version number.
    """
    _params = None
    if type(modelName) == str:
        modelName = parse.quote(modelName)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/models/{modelName}/versions/{modelVersionNum}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetModelVersionResponse.from_json(_resp.json())
    raise APIHttpError("get_GetModelVersion", _resp)

def get_GetModelVersions(
    session: "api.BaseSession",
    *,
    modelName: str,
    limit: "typing.Optional[int]" = None,
    offset: "typing.Optional[int]" = None,
    orderBy: "typing.Optional[v1OrderBy]" = None,
    sortBy: "typing.Optional[v1GetModelVersionsRequestSortBy]" = None,
) -> "v1GetModelVersionsResponse":
    """Get a list of versions for the requested model.

    - modelName: The name of the model.
    - limit: Limit the number of model versions. A value of 0 denotes no limit.
    - offset: Skip the number of model versions before returning results. Negative values
denote number of models to skip from the end before returning results.
    - orderBy: Order model versions in either ascending or descending order.

 - ORDER_BY_UNSPECIFIED: Returns records in no specific order.
 - ORDER_BY_ASC: Returns records in ascending order.
 - ORDER_BY_DESC: Returns records in descending order.
    - sortBy: Sort the model versions by the given field.

 - SORT_BY_UNSPECIFIED: Returns model versions in an unsorted list.
 - SORT_BY_VERSION: Returns model versions sorted by version number.
 - SORT_BY_CREATION_TIME: Returns model versions sorted by creation_time.
    """
    _params = {
        "limit": limit,
        "offset": offset,
        "orderBy": orderBy.value if orderBy is not None else None,
        "sortBy": sortBy.value if sortBy is not None else None,
    }
    if type(modelName) == str:
        modelName = parse.quote(modelName)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/models/{modelName}/versions",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetModelVersionsResponse.from_json(_resp.json())
    raise APIHttpError("get_GetModelVersions", _resp)

def get_GetModels(
    session: "api.BaseSession",
    *,
    archived: "typing.Optional[bool]" = None,
    description: "typing.Optional[str]" = None,
    id: "typing.Optional[int]" = None,
    labels: "typing.Optional[typing.Sequence[str]]" = None,
    limit: "typing.Optional[int]" = None,
    name: "typing.Optional[str]" = None,
    offset: "typing.Optional[int]" = None,
    orderBy: "typing.Optional[v1OrderBy]" = None,
    sortBy: "typing.Optional[v1GetModelsRequestSortBy]" = None,
    userIds: "typing.Optional[typing.Sequence[int]]" = None,
    users: "typing.Optional[typing.Sequence[str]]" = None,
    workspaceIds: "typing.Optional[typing.Sequence[int]]" = None,
    workspaceNames: "typing.Optional[typing.Sequence[str]]" = None,
) -> "v1GetModelsResponse":
    """Get a list of models.

    - archived: Limit to unarchived models only.
    - description: Limit the models to those matching or partially-matching the description.
    - id: Limit the models to this model id.
    - labels: Limit the models to those with the following labels.
    - limit: Limit the number of models. A value of 0 denotes no limit.
    - name: Limit the models to those matching or partially-matching the name.
    - offset: Skip the number of models before returning results. Negative values
denote number of models to skip from the end before returning results.
    - orderBy: Order models in either ascending or descending order.

 - ORDER_BY_UNSPECIFIED: Returns records in no specific order.
 - ORDER_BY_ASC: Returns records in ascending order.
 - ORDER_BY_DESC: Returns records in descending order.
    - sortBy: Sort the models by the given field.

 - SORT_BY_UNSPECIFIED: Returns models in an unsorted list.
 - SORT_BY_NAME: Returns models sorted by name.
 - SORT_BY_DESCRIPTION: Returns models sorted by description.
 - SORT_BY_CREATION_TIME: Returns models sorted by creation time.
 - SORT_BY_LAST_UPDATED_TIME: Returns models sorted by last updated time.
 - SORT_BY_NUM_VERSIONS: Returns models sorted by number of version.
 - SORT_BY_WORKSPACE: Returns models sorted by workspace name.
    - userIds: Limit the models to those made by the users with the following userIds.
    - users: Limit the models to those made by the users with the following usernames.
    - workspaceIds: Limit models to those that belong to the following workspace ids.
    - workspaceNames: Limit models to those that belong to the following workspace names.
    """
    _params = {
        "archived": str(archived).lower() if archived is not None else None,
        "description": description,
        "id": id,
        "labels": labels,
        "limit": limit,
        "name": name,
        "offset": offset,
        "orderBy": orderBy.value if orderBy is not None else None,
        "sortBy": sortBy.value if sortBy is not None else None,
        "userIds": userIds,
        "users": users,
        "workspaceIds": workspaceIds,
        "workspaceNames": workspaceNames,
    }
    _resp = session._do_request(
        method="GET",
        path="/api/v1/models",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetModelsResponse.from_json(_resp.json())
    raise APIHttpError("get_GetModels", _resp)

def get_GetNotebook(
    session: "api.BaseSession",
    *,
    notebookId: str,
) -> "v1GetNotebookResponse":
    """Get the requested notebook.

    - notebookId: The id of the notebook.
    """
    _params = None
    if type(notebookId) == str:
        notebookId = parse.quote(notebookId)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/notebooks/{notebookId}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetNotebookResponse.from_json(_resp.json())
    raise APIHttpError("get_GetNotebook", _resp)

def get_GetNotebooks(
    session: "api.BaseSession",
    *,
    limit: "typing.Optional[int]" = None,
    offset: "typing.Optional[int]" = None,
    orderBy: "typing.Optional[v1OrderBy]" = None,
    sortBy: "typing.Optional[v1GetTensorboardsRequestSortBy]" = None,
    userIds: "typing.Optional[typing.Sequence[int]]" = None,
    users: "typing.Optional[typing.Sequence[str]]" = None,
    workspaceId: "typing.Optional[int]" = None,
) -> "v1GetNotebooksResponse":
    """Get a list of notebooks.

    - limit: Limit the number of notebooks. A value of 0 denotes no limit.
    - offset: Skip the number of notebooks before returning results. Negative values
denote number of notebooks to skip from the end before returning results.
    - orderBy: Order notebooks in either ascending or descending order.

 - ORDER_BY_UNSPECIFIED: Returns records in no specific order.
 - ORDER_BY_ASC: Returns records in ascending order.
 - ORDER_BY_DESC: Returns records in descending order.
    - sortBy: Sort notebooks by the given field.

 - SORT_BY_UNSPECIFIED: Returns notebooks in an unsorted list.
 - SORT_BY_ID: Returns notebooks sorted by id.
 - SORT_BY_DESCRIPTION: Returns notebooks sorted by description.
 - SORT_BY_START_TIME: Return notebooks sorted by start time.
 - SORT_BY_WORKSPACE_ID: Return notebooks sorted by workspace_id
    - userIds: Limit notebooks to those that are owned by users with the specified
userIds.
    - users: Limit notebooks to those that are owned by users with the specified
usernames.
    - workspaceId: Limit to those within a specified workspace, or 0 for all
accessible workspaces.
    """
    _params = {
        "limit": limit,
        "offset": offset,
        "orderBy": orderBy.value if orderBy is not None else None,
        "sortBy": sortBy.value if sortBy is not None else None,
        "userIds": userIds,
        "users": users,
        "workspaceId": workspaceId,
    }
    _resp = session._do_request(
        method="GET",
        path="/api/v1/notebooks",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetNotebooksResponse.from_json(_resp.json())
    raise APIHttpError("get_GetNotebooks", _resp)

def get_GetPermissionsSummary(
    session: "api.BaseSession",
) -> "v1GetPermissionsSummaryResponse":
    """List all permissions for the logged in user in all scopes."""
    _params = None
    _resp = session._do_request(
        method="GET",
        path="/api/v1/permissions/summary",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetPermissionsSummaryResponse.from_json(_resp.json())
    raise APIHttpError("get_GetPermissionsSummary", _resp)

def get_GetProject(
    session: "api.BaseSession",
    *,
    id: int,
) -> "v1GetProjectResponse":
    """Get the requested project.

    - id: The id of the project.
    """
    _params = None
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/projects/{id}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetProjectResponse.from_json(_resp.json())
    raise APIHttpError("get_GetProject", _resp)

def get_GetProjectByKey(
    session: "api.BaseSession",
    *,
    key: str,
) -> "v1GetProjectByKeyResponse":
    """Get the request project by key.

    - key: The key of the project.
    """
    _params = None
    if type(key) == str:
        key = parse.quote(key)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/projects/key/{key}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetProjectByKeyResponse.from_json(_resp.json())
    raise APIHttpError("get_GetProjectByKey", _resp)

def get_GetProjectColumns(
    session: "api.BaseSession",
    *,
    id: int,
    tableType: "typing.Optional[v1TableType]" = None,
) -> "v1GetProjectColumnsResponse":
    """Get a list of columns for experiment list table.

    - id: The id of the project.
    - tableType: type of table for project columns.

 - TABLE_TYPE_UNSPECIFIED: Unspecified table type.
 - TABLE_TYPE_EXPERIMENT: experiment table.
 - TABLE_TYPE_RUN: run table.
    """
    _params = {
        "tableType": tableType.value if tableType is not None else None,
    }
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/projects/{id}/columns",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetProjectColumnsResponse.from_json(_resp.json())
    raise APIHttpError("get_GetProjectColumns", _resp)

def get_GetProjectNumericMetricsRange(
    session: "api.BaseSession",
    *,
    id: int,
) -> "v1GetProjectNumericMetricsRangeResponse":
    """Get metrics range for a project.

    - id: The id of the project.
    """
    _params = None
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/projects/{id}/experiments/metric-ranges",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetProjectNumericMetricsRangeResponse.from_json(_resp.json())
    raise APIHttpError("get_GetProjectNumericMetricsRange", _resp)

def get_GetProjectsByUserActivity(
    session: "api.BaseSession",
    *,
    limit: "typing.Optional[int]" = None,
) -> "v1GetProjectsByUserActivityResponse":
    """Get projects by user activity

    - limit: Limit number of project entries.
    """
    _params = {
        "limit": limit,
    }
    _resp = session._do_request(
        method="GET",
        path="/api/v1/user/projects/activity",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetProjectsByUserActivityResponse.from_json(_resp.json())
    raise APIHttpError("get_GetProjectsByUserActivity", _resp)

def get_GetResourcePools(
    session: "api.BaseSession",
    *,
    limit: "typing.Optional[int]" = None,
    offset: "typing.Optional[int]" = None,
    unbound: "typing.Optional[bool]" = None,
) -> "v1GetResourcePoolsResponse":
    """Get a list of all resource pools from the cluster.

    - limit: Limit the number of resource pools. A value of 0 denotes no limit.
    - offset: Skip the number of resource pools before returning results. Negative values
denote number of resource pools to skip from the end before returning
results.
    - unbound: Indicate whether or not to return unbound pools only.
    """
    _params = {
        "limit": limit,
        "offset": offset,
        "unbound": str(unbound).lower() if unbound is not None else None,
    }
    _resp = session._do_request(
        method="GET",
        path="/api/v1/resource-pools",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetResourcePoolsResponse.from_json(_resp.json())
    raise APIHttpError("get_GetResourcePools", _resp)

def get_GetRolesAssignedToGroup(
    session: "api.BaseSession",
    *,
    groupId: int,
) -> "v1GetRolesAssignedToGroupResponse":
    """Get the roles which are assigned to a group.

    - groupId: The id of the group to search for role assignments for
    """
    _params = None
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/roles/search/by-group/{groupId}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetRolesAssignedToGroupResponse.from_json(_resp.json())
    raise APIHttpError("get_GetRolesAssignedToGroup", _resp)

def get_GetRolesAssignedToUser(
    session: "api.BaseSession",
    *,
    userId: int,
) -> "v1GetRolesAssignedToUserResponse":
    """Get the roles which are assigned to a user.

    - userId: The id of the user to search for role assignments for
    """
    _params = None
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/roles/search/by-user/{userId}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetRolesAssignedToUserResponse.from_json(_resp.json())
    raise APIHttpError("get_GetRolesAssignedToUser", _resp)

def post_GetRolesByID(
    session: "api.BaseSession",
    *,
    body: "v1GetRolesByIDRequest",
) -> "v1GetRolesByIDResponse":
    """Get a set of roles with the corresponding IDs."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/roles/search/by-ids",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetRolesByIDResponse.from_json(_resp.json())
    raise APIHttpError("post_GetRolesByID", _resp)

def get_GetRunMetadata(
    session: "api.BaseSession",
    *,
    runId: int,
) -> "v1GetRunMetadataResponse":
    """Get run metadata.

    - runId: The ID of the run to get metadata for.
    """
    _params = None
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/runs/{runId}/metadata",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetRunMetadataResponse.from_json(_resp.json())
    raise APIHttpError("get_GetRunMetadata", _resp)

def get_GetShell(
    session: "api.BaseSession",
    *,
    shellId: str,
) -> "v1GetShellResponse":
    """Get the requested shell.

    - shellId: The id of the shell.
    """
    _params = None
    if type(shellId) == str:
        shellId = parse.quote(shellId)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/shells/{shellId}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetShellResponse.from_json(_resp.json())
    raise APIHttpError("get_GetShell", _resp)

def get_GetShells(
    session: "api.BaseSession",
    *,
    limit: "typing.Optional[int]" = None,
    offset: "typing.Optional[int]" = None,
    orderBy: "typing.Optional[v1OrderBy]" = None,
    sortBy: "typing.Optional[v1GetTensorboardsRequestSortBy]" = None,
    userIds: "typing.Optional[typing.Sequence[int]]" = None,
    users: "typing.Optional[typing.Sequence[str]]" = None,
    workspaceId: "typing.Optional[int]" = None,
) -> "v1GetShellsResponse":
    """Get a list of shells.

    - limit: Limit the number of shells. A value of 0 denotes no limit.
    - offset: Skip the number of shells before returning results. Negative values
denote number of shells to skip from the end before returning results.
    - orderBy: Order shells in either ascending or descending order.

 - ORDER_BY_UNSPECIFIED: Returns records in no specific order.
 - ORDER_BY_ASC: Returns records in ascending order.
 - ORDER_BY_DESC: Returns records in descending order.
    - sortBy: Sort shells by the given field.

 - SORT_BY_UNSPECIFIED: Returns shells in an unsorted list.
 - SORT_BY_ID: Returns shells sorted by id.
 - SORT_BY_DESCRIPTION: Returns shells sorted by description.
 - SORT_BY_START_TIME: Return shells sorted by start time.
 - SORT_BY_WORKSPACE_ID: Return shells sorted by workspace_id.
    - userIds: Limit shells to those that are owned by users with the specified userIds.
    - users: Limit shells to those that are owned by users with the specified usernames.
    - workspaceId: Limit to those within a specified workspace, or 0 for all
accessible workspaces.
    """
    _params = {
        "limit": limit,
        "offset": offset,
        "orderBy": orderBy.value if orderBy is not None else None,
        "sortBy": sortBy.value if sortBy is not None else None,
        "userIds": userIds,
        "users": users,
        "workspaceId": workspaceId,
    }
    _resp = session._do_request(
        method="GET",
        path="/api/v1/shells",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetShellsResponse.from_json(_resp.json())
    raise APIHttpError("get_GetShells", _resp)

def get_GetSlot(
    session: "api.BaseSession",
    *,
    agentId: str,
    slotId: str,
) -> "v1GetSlotResponse":
    """Get the requested slot for an agent.

    - agentId: The id of the agent.
    - slotId: The id of the slot.
    """
    _params = None
    if type(agentId) == str:
        agentId = parse.quote(agentId)
    if type(slotId) == str:
        slotId = parse.quote(slotId)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/agents/{agentId}/slots/{slotId}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetSlotResponse.from_json(_resp.json())
    raise APIHttpError("get_GetSlot", _resp)

def get_GetSlots(
    session: "api.BaseSession",
    *,
    agentId: str,
) -> "v1GetSlotsResponse":
    """Get all the slots for an agent.

    - agentId: The id of the agent.
    """
    _params = None
    if type(agentId) == str:
        agentId = parse.quote(agentId)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/agents/{agentId}/slots",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetSlotsResponse.from_json(_resp.json())
    raise APIHttpError("get_GetSlots", _resp)

def get_GetTask(
    session: "api.BaseSession",
    *,
    taskId: str,
) -> "v1GetTaskResponse":
    """Check the status of a requested task.

    - taskId: The requested task id.
    """
    _params = None
    if type(taskId) == str:
        taskId = parse.quote(taskId)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/tasks/{taskId}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetTaskResponse.from_json(_resp.json())
    raise APIHttpError("get_GetTask", _resp)

def get_GetTaskAcceleratorData(
    session: "api.BaseSession",
    *,
    taskId: str,
) -> "v1GetTaskAcceleratorDataResponse":
    """GetTaskAcceleratorData gets the accelerator data for each allocation
    associated with a task.

    - taskId: The id of the task.
    """
    _params = None
    if type(taskId) == str:
        taskId = parse.quote(taskId)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/tasks/{taskId}/acceleratorData",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetTaskAcceleratorDataResponse.from_json(_resp.json())
    raise APIHttpError("get_GetTaskAcceleratorData", _resp)

def get_GetTaskContextDirectory(
    session: "api.BaseSession",
    *,
    taskId: str,
) -> "v1GetTaskContextDirectoryResponse":
    """Get the model definition of a task.

    - taskId: The id of the experiment.
    """
    _params = None
    if type(taskId) == str:
        taskId = parse.quote(taskId)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/tasks/{taskId}/context_directory",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetTaskContextDirectoryResponse.from_json(_resp.json())
    raise APIHttpError("get_GetTaskContextDirectory", _resp)

def get_GetTasks(
    session: "api.BaseSession",
) -> "v1GetTasksResponse":
    """Get all tasks."""
    _params = None
    _resp = session._do_request(
        method="GET",
        path="/api/v1/tasks",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetTasksResponse.from_json(_resp.json())
    raise APIHttpError("get_GetTasks", _resp)

def get_GetTelemetry(
    session: "api.BaseSession",
) -> "v1GetTelemetryResponse":
    """Get telemetry information."""
    _params = None
    _resp = session._do_request(
        method="GET",
        path="/api/v1/master/telemetry",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetTelemetryResponse.from_json(_resp.json())
    raise APIHttpError("get_GetTelemetry", _resp)

def get_GetTemplate(
    session: "api.BaseSession",
    *,
    templateName: str,
) -> "v1GetTemplateResponse":
    """Get the requested template.

    - templateName: The id of the template.
    """
    _params = None
    if type(templateName) == str:
        templateName = parse.quote(templateName)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/templates/{templateName}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetTemplateResponse.from_json(_resp.json())
    raise APIHttpError("get_GetTemplate", _resp)

def get_GetTemplates(
    session: "api.BaseSession",
    *,
    limit: "typing.Optional[int]" = None,
    name: "typing.Optional[str]" = None,
    offset: "typing.Optional[int]" = None,
    orderBy: "typing.Optional[v1OrderBy]" = None,
    sortBy: "typing.Optional[v1GetTemplatesRequestSortBy]" = None,
    workspaceIds: "typing.Optional[typing.Sequence[int]]" = None,
) -> "v1GetTemplatesResponse":
    """Get a list of templates.

    - limit: Limit the number of templates. A value of 0 denotes no limit.
    - name: Limit templates to those that match the name.
    - offset: Skip the number of templates before returning results. Negative values
denote number of templates to skip from the end before returning results.
    - orderBy: Order templates in either ascending or descending order.

 - ORDER_BY_UNSPECIFIED: Returns records in no specific order.
 - ORDER_BY_ASC: Returns records in ascending order.
 - ORDER_BY_DESC: Returns records in descending order.
    - sortBy: Sort templates by the given field.

 - SORT_BY_UNSPECIFIED: Returns templates in an unsorted list.
 - SORT_BY_NAME: Returns templates sorted by name.
    - workspaceIds: Limit templates to those that match the workspace id.
    """
    _params = {
        "limit": limit,
        "name": name,
        "offset": offset,
        "orderBy": orderBy.value if orderBy is not None else None,
        "sortBy": sortBy.value if sortBy is not None else None,
        "workspaceIds": workspaceIds,
    }
    _resp = session._do_request(
        method="GET",
        path="/api/v1/templates",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetTemplatesResponse.from_json(_resp.json())
    raise APIHttpError("get_GetTemplates", _resp)

def get_GetTensorboard(
    session: "api.BaseSession",
    *,
    tensorboardId: str,
) -> "v1GetTensorboardResponse":
    """Get the requested tensorboard.

    - tensorboardId: The id of the tensorboard.
    """
    _params = None
    if type(tensorboardId) == str:
        tensorboardId = parse.quote(tensorboardId)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/tensorboards/{tensorboardId}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetTensorboardResponse.from_json(_resp.json())
    raise APIHttpError("get_GetTensorboard", _resp)

def get_GetTensorboards(
    session: "api.BaseSession",
    *,
    limit: "typing.Optional[int]" = None,
    offset: "typing.Optional[int]" = None,
    orderBy: "typing.Optional[v1OrderBy]" = None,
    sortBy: "typing.Optional[v1GetTensorboardsRequestSortBy]" = None,
    userIds: "typing.Optional[typing.Sequence[int]]" = None,
    users: "typing.Optional[typing.Sequence[str]]" = None,
    workspaceId: "typing.Optional[int]" = None,
) -> "v1GetTensorboardsResponse":
    """Get a list of tensorboards.

    - limit: Limit the number of tensorboards. A value of 0 denotes no limit.
    - offset: Skip the number of tensorboards before returning results. Negative values
denote number of tensorboards to skip from the end before returning
results.
    - orderBy: Order tensorboards in either ascending or descending order.

 - ORDER_BY_UNSPECIFIED: Returns records in no specific order.
 - ORDER_BY_ASC: Returns records in ascending order.
 - ORDER_BY_DESC: Returns records in descending order.
    - sortBy: Sort tensorboards by the given field.

 - SORT_BY_UNSPECIFIED: Returns tensorboards in an unsorted list.
 - SORT_BY_ID: Returns tensorboards sorted by id.
 - SORT_BY_DESCRIPTION: Returns tensorboards sorted by description.
 - SORT_BY_START_TIME: Return tensorboards sorted by start time.
 - SORT_BY_WORKSPACE_ID: Return tensorboards sorted by workspace_id.
    - userIds: Limit tensorboards to those that are owned by users with the specified
userIds.
    - users: Limit tensorboards to those that are owned by users with the specified
usernames.
    - workspaceId: Limit tensorboards to those that are in a specific workspace, or 0 for
all accessible workspaces.
    """
    _params = {
        "limit": limit,
        "offset": offset,
        "orderBy": orderBy.value if orderBy is not None else None,
        "sortBy": sortBy.value if sortBy is not None else None,
        "userIds": userIds,
        "users": users,
        "workspaceId": workspaceId,
    }
    _resp = session._do_request(
        method="GET",
        path="/api/v1/tensorboards",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetTensorboardsResponse.from_json(_resp.json())
    raise APIHttpError("get_GetTensorboards", _resp)

def get_GetTrainingMetrics(
    session: "api.BaseSession",
    *,
    trialIds: "typing.Optional[typing.Sequence[int]]" = None,
) -> "typing.Iterable[v1GetTrainingMetricsResponse]":
    """Stream one or more trial's training metrics.

    - trialIds: Trial IDs to get metrics for.
    """
    _params = {
        "trialIds": trialIds,
    }
    _resp = session._do_request(
        method="GET",
        path="/api/v1/trials/metrics/training_metrics",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=True,
    )
    if _resp.status_code == 200:
        try:
            for _line in _resp.iter_lines(chunk_size=1024 * 1024):
                _j = json.loads(_line)
                if "error" in _j:
                    raise APIHttpStreamError(
                        "get_GetTrainingMetrics",
                        runtimeStreamError.from_json(_j["error"])
                )
                yield v1GetTrainingMetricsResponse.from_json(_j["result"])
        except requests.exceptions.ChunkedEncodingError:
            raise APIHttpStreamError("get_GetTrainingMetrics", runtimeStreamError(message="ChunkedEncodingError"))
        return
    raise APIHttpError("get_GetTrainingMetrics", _resp)

def get_GetTrial(
    session: "api.BaseSession",
    *,
    trialId: int,
) -> "v1GetTrialResponse":
    """Get a single trial.

    - trialId: The requested trial's id.
    """
    _params = None
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/trials/{trialId}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetTrialResponse.from_json(_resp.json())
    raise APIHttpError("get_GetTrial", _resp)

def get_GetTrialByExternalID(
    session: "api.BaseSession",
    *,
    externalExperimentId: str,
    externalTrialId: str,
) -> "v1GetTrialByExternalIDResponse":
    """Get a single trial by external id.

    - externalExperimentId: External experiment id.
    - externalTrialId: External trial id.
    """
    _params = None
    if type(externalExperimentId) == str:
        externalExperimentId = parse.quote(externalExperimentId)
    if type(externalTrialId) == str:
        externalTrialId = parse.quote(externalTrialId)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/trials/by-external-id/{externalExperimentId}/{externalTrialId}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetTrialByExternalIDResponse.from_json(_resp.json())
    raise APIHttpError("get_GetTrialByExternalID", _resp)

def get_GetTrialCheckpoints(
    session: "api.BaseSession",
    *,
    id: int,
    limit: "typing.Optional[int]" = None,
    offset: "typing.Optional[int]" = None,
    orderBy: "typing.Optional[v1OrderBy]" = None,
    sortByAttr: "typing.Optional[checkpointv1SortBy]" = None,
    sortByMetric: "typing.Optional[str]" = None,
    states: "typing.Optional[typing.Sequence[checkpointv1State]]" = None,
) -> "v1GetTrialCheckpointsResponse":
    """Get a list of checkpoints for a trial.

    - id: The trial id.
    - limit: Limit the number of checkpoints. A value of 0 denotes no limit.
    - offset: Skip the number of checkpoints before returning results. Negative values
denote number of checkpoints to skip from the end before returning results.
    - orderBy: Order checkpoints in either ascending or descending order.

 - ORDER_BY_UNSPECIFIED: Returns records in no specific order.
 - ORDER_BY_ASC: Returns records in ascending order.
 - ORDER_BY_DESC: Returns records in descending order.
    - sortByAttr: Sort by preset checkpoint attribute.

 - SORT_BY_UNSPECIFIED: Returns checkpoints in an unsorted list.
 - SORT_BY_UUID: Returns checkpoints sorted by UUID.
 - SORT_BY_TRIAL_ID: Returns checkpoints sorted by trial id.
 - SORT_BY_BATCH_NUMBER: Returns checkpoints sorted by batch number.
 - SORT_BY_END_TIME: Returns checkpoints sorted by end time.
 - SORT_BY_STATE: Returns checkpoints sorted by state.
 - SORT_BY_SEARCHER_METRIC: Returns checkpoints sorted by the experiment's `searcher.metric`
configuration setting.
    - sortByMetric: Sort by custom validation metric name.
    - states: Limit the checkpoints to those that match the states.

 - STATE_UNSPECIFIED: The state of the checkpoint is unknown.
 - STATE_ACTIVE: The checkpoint is in an active state.
 - STATE_COMPLETED: The checkpoint is persisted to checkpoint storage.
 - STATE_ERROR: The checkpoint errored.
 - STATE_DELETED: The checkpoint has been deleted.
 - STATE_PARTIALLY_DELETED: The checkpoint has been partially deleted.
    """
    _params = {
        "limit": limit,
        "offset": offset,
        "orderBy": orderBy.value if orderBy is not None else None,
        "sortByAttr": sortByAttr.value if sortByAttr is not None else None,
        "sortByMetric": sortByMetric,
        "states": [x.value for x in states] if states is not None else None,
    }
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/trials/{id}/checkpoints",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetTrialCheckpointsResponse.from_json(_resp.json())
    raise APIHttpError("get_GetTrialCheckpoints", _resp)

def get_GetTrialMetricsByCheckpoint(
    session: "api.BaseSession",
    *,
    checkpointUuid: str,
    metricGroup: "typing.Optional[str]" = None,
    trialSourceInfoType: "typing.Optional[v1TrialSourceInfoType]" = None,
) -> "v1GetTrialMetricsByCheckpointResponse":
    """Gets the metrics for all trials associated with this checkpoint

    - checkpointUuid: UUID of the checkpoint.
    - metricGroup: Metric Group string ("training", "validation", or anything else) (nil means
all groups).
    - trialSourceInfoType: Type of the TrialSourceInfo.

 - TRIAL_SOURCE_INFO_TYPE_UNSPECIFIED: The type is unspecified
 - TRIAL_SOURCE_INFO_TYPE_INFERENCE: "Inference" Trial Source Info Type, used for batch inference
 - TRIAL_SOURCE_INFO_TYPE_FINE_TUNING: "Fine Tuning" Trial Source Info Type, used in model hub
    """
    _params = {
        "metricGroup": metricGroup,
        "trialSourceInfoType": trialSourceInfoType.value if trialSourceInfoType is not None else None,
    }
    if type(checkpointUuid) == str:
        checkpointUuid = parse.quote(checkpointUuid)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/checkpoints/{checkpointUuid}/metrics",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetTrialMetricsByCheckpointResponse.from_json(_resp.json())
    raise APIHttpError("get_GetTrialMetricsByCheckpoint", _resp)

def get_GetTrialMetricsByModelVersion(
    session: "api.BaseSession",
    *,
    modelName: str,
    modelVersionNum: int,
    metricGroup: "typing.Optional[str]" = None,
    trialSourceInfoType: "typing.Optional[v1TrialSourceInfoType]" = None,
) -> "v1GetTrialMetricsByModelVersionResponse":
    """Gets the metrics for all trials associated with this model version

    - modelName: The name of the model associated with the model version.
    - modelVersionNum: Sequential model version number.
    - metricGroup: Metric Group string ("training", "validation", or anything else) (nil means
all groups).
    - trialSourceInfoType: Type of the TrialSourceInfo.

 - TRIAL_SOURCE_INFO_TYPE_UNSPECIFIED: The type is unspecified
 - TRIAL_SOURCE_INFO_TYPE_INFERENCE: "Inference" Trial Source Info Type, used for batch inference
 - TRIAL_SOURCE_INFO_TYPE_FINE_TUNING: "Fine Tuning" Trial Source Info Type, used in model hub
    """
    _params = {
        "metricGroup": metricGroup,
        "trialSourceInfoType": trialSourceInfoType.value if trialSourceInfoType is not None else None,
    }
    if type(modelName) == str:
        modelName = parse.quote(modelName)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/models/{modelName}/versions/{modelVersionNum}/metrics",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetTrialMetricsByModelVersionResponse.from_json(_resp.json())
    raise APIHttpError("get_GetTrialMetricsByModelVersion", _resp)

def get_GetTrialProfilerAvailableSeries(
    session: "api.BaseSession",
    *,
    trialId: int,
    follow: "typing.Optional[bool]" = None,
) -> "typing.Iterable[v1GetTrialProfilerAvailableSeriesResponse]":
    """Stream the available series in a trial's profiler metrics.

    - trialId: The requested trial's id.
    - follow: Continue streaming labels until the trial stops. Defaults to False.
    """
    _params = {
        "follow": str(follow).lower() if follow is not None else None,
    }
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/trials/{trialId}/profiler/available_series",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=True,
    )
    if _resp.status_code == 200:
        try:
            for _line in _resp.iter_lines(chunk_size=1024 * 1024):
                _j = json.loads(_line)
                if "error" in _j:
                    raise APIHttpStreamError(
                        "get_GetTrialProfilerAvailableSeries",
                        runtimeStreamError.from_json(_j["error"])
                )
                yield v1GetTrialProfilerAvailableSeriesResponse.from_json(_j["result"])
        except requests.exceptions.ChunkedEncodingError:
            raise APIHttpStreamError("get_GetTrialProfilerAvailableSeries", runtimeStreamError(message="ChunkedEncodingError"))
        return
    raise APIHttpError("get_GetTrialProfilerAvailableSeries", _resp)

def get_GetTrialProfilerMetrics(
    session: "api.BaseSession",
    *,
    labels_trialId: int,
    follow: "typing.Optional[bool]" = None,
    labels_agentId: "typing.Optional[str]" = None,
    labels_gpuUuid: "typing.Optional[str]" = None,
    labels_metricType: "typing.Optional[TrialProfilerMetricLabelsProfilerMetricType]" = None,
    labels_name: "typing.Optional[str]" = None,
) -> "typing.Iterable[v1GetTrialProfilerMetricsResponse]":
    """Stream trial profiler metrics.

    - labels_trialId: The ID of the trial.
    - follow: Continue streaming metrics until the trial stops. Defaults to False.
    - labels_agentId: The agent ID associated with the metric.
    - labels_gpuUuid: The GPU UUID associated with the metric.
    - labels_metricType: The type of the metric.

 - PROFILER_METRIC_TYPE_UNSPECIFIED: Zero-value (not allowed).
 - PROFILER_METRIC_TYPE_SYSTEM: For systems metrics, like GPU utilization or memory.
 - PROFILER_METRIC_TYPE_TIMING: For timing metrics, like how long a backwards pass or getting a batch
from the dataloader took.
 - PROFILER_METRIC_TYPE_MISC: For other miscellaneous metrics.
    - labels_name: The name of the metric.
    """
    _params = {
        "follow": str(follow).lower() if follow is not None else None,
        "labels.agentId": labels_agentId,
        "labels.gpuUuid": labels_gpuUuid,
        "labels.metricType": labels_metricType.value if labels_metricType is not None else None,
        "labels.name": labels_name,
    }
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/trials/{labels_trialId}/profiler/metrics",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=True,
    )
    if _resp.status_code == 200:
        try:
            for _line in _resp.iter_lines(chunk_size=1024 * 1024):
                _j = json.loads(_line)
                if "error" in _j:
                    raise APIHttpStreamError(
                        "get_GetTrialProfilerMetrics",
                        runtimeStreamError.from_json(_j["error"])
                )
                yield v1GetTrialProfilerMetricsResponse.from_json(_j["result"])
        except requests.exceptions.ChunkedEncodingError:
            raise APIHttpStreamError("get_GetTrialProfilerMetrics", runtimeStreamError(message="ChunkedEncodingError"))
        return
    raise APIHttpError("get_GetTrialProfilerMetrics", _resp)

def get_GetTrialRemainingLogRetentionDays(
    session: "api.BaseSession",
    *,
    id: int,
) -> "v1GetTrialRemainingLogRetentionDaysResponse":
    """Get the list of trials for an experiment.

    - id: The trial id.
    """
    _params = None
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/trials/{id}/remaining_log_retention_days",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetTrialRemainingLogRetentionDaysResponse.from_json(_resp.json())
    raise APIHttpError("get_GetTrialRemainingLogRetentionDays", _resp)

def get_GetTrialWorkloads(
    session: "api.BaseSession",
    *,
    trialId: int,
    filter: "typing.Optional[GetTrialWorkloadsRequestFilterOption]" = None,
    group: "typing.Optional[str]" = None,
    includeBatchMetrics: "typing.Optional[bool]" = None,
    limit: "typing.Optional[int]" = None,
    metricType: "typing.Optional[v1MetricType]" = None,
    offset: "typing.Optional[int]" = None,
    orderBy: "typing.Optional[v1OrderBy]" = None,
    removeDeletedCheckpoints: "typing.Optional[bool]" = None,
    sortKey: "typing.Optional[str]" = None,
) -> "v1GetTrialWorkloadsResponse":
    """Get the list of workloads for a trial.

    - trialId: Limit workloads to those that are owned by the specified trial.
    - filter: Filter workloads with validation and/or checkpoint information.

 - FILTER_OPTION_UNSPECIFIED: Any workload.
 - FILTER_OPTION_CHECKPOINT: Only workloads with an associated checkpoint.
 - FILTER_OPTION_VALIDATION: Only validation workloads.
 - FILTER_OPTION_CHECKPOINT_OR_VALIDATION: Only validation workloads or ones with an associated checkpoint.
    - group: Metric group (training, validation, etc).
    - includeBatchMetrics: Include per-batch metrics.
    - limit: Limit the number of workloads. A value of 0 denotes no limit.
    - metricType: When sorting workloads by sort_key, specify training or validation form of
a metric.

 - METRIC_TYPE_UNSPECIFIED: Zero-value (not allowed).
 - METRIC_TYPE_TRAINING: For metrics emitted during training.
 - METRIC_TYPE_VALIDATION: For metrics emitted during validation.
 - METRIC_TYPE_PROFILING: For metrics emitted during profiling.
    - offset: Skip the number of workloads before returning results. Negative values
denote number of workloads to skip from the end before returning results.
    - orderBy: Order workloads in either ascending or descending order.

 - ORDER_BY_UNSPECIFIED: Returns records in no specific order.
 - ORDER_BY_ASC: Returns records in ascending order.
 - ORDER_BY_DESC: Returns records in descending order.
    - removeDeletedCheckpoints: Remove deleted checkpoints.
    - sortKey: Sort workloads by batches, a training metric, or a validation metric.
    """
    _params = {
        "filter": filter.value if filter is not None else None,
        "group": group,
        "includeBatchMetrics": str(includeBatchMetrics).lower() if includeBatchMetrics is not None else None,
        "limit": limit,
        "metricType": metricType.value if metricType is not None else None,
        "offset": offset,
        "orderBy": orderBy.value if orderBy is not None else None,
        "removeDeletedCheckpoints": str(removeDeletedCheckpoints).lower() if removeDeletedCheckpoints is not None else None,
        "sortKey": sortKey,
    }
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/trials/{trialId}/workloads",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetTrialWorkloadsResponse.from_json(_resp.json())
    raise APIHttpError("get_GetTrialWorkloads", _resp)

def get_GetUser(
    session: "api.BaseSession",
    *,
    userId: int,
) -> "v1GetUserResponse":
    """Get the requested user.

    - userId: The id of the user.
    """
    _params = None
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/users/{userId}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetUserResponse.from_json(_resp.json())
    raise APIHttpError("get_GetUser", _resp)

def get_GetUserByUsername(
    session: "api.BaseSession",
    *,
    username: str,
) -> "v1GetUserByUsernameResponse":
    """Get the requested user with username.

    - username: The string of the username.
    """
    _params = None
    if type(username) == str:
        username = parse.quote(username)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/users/{username}/by-username",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetUserByUsernameResponse.from_json(_resp.json())
    raise APIHttpError("get_GetUserByUsername", _resp)

def get_GetUserSetting(
    session: "api.BaseSession",
) -> "v1GetUserSettingResponse":
    """Get a user's settings for website"""
    _params = None
    _resp = session._do_request(
        method="GET",
        path="/api/v1/users/setting",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetUserSettingResponse.from_json(_resp.json())
    raise APIHttpError("get_GetUserSetting", _resp)

def get_GetUsers(
    session: "api.BaseSession",
    *,
    active: "typing.Optional[bool]" = None,
    admin: "typing.Optional[bool]" = None,
    limit: "typing.Optional[int]" = None,
    name: "typing.Optional[str]" = None,
    offset: "typing.Optional[int]" = None,
    orderBy: "typing.Optional[v1OrderBy]" = None,
    roleIdAssignedDirectlyToUser: "typing.Optional[typing.Sequence[int]]" = None,
    sortBy: "typing.Optional[v1GetUsersRequestSortBy]" = None,
) -> "v1GetUsersResponse":
    """Get a list of users.

    - active: Filter by status.
    - admin: Filter by roles.
    - limit: Limit the number of projects. A value of 0 denotes no limit.
    - name: Filter by username or display name.
    - offset: Skip the number of projects before returning results. Negative values
denote number of projects to skip from the end before returning results.
    - orderBy: Order users in either ascending or descending order.

 - ORDER_BY_UNSPECIFIED: Returns records in no specific order.
 - ORDER_BY_ASC: Returns records in ascending order.
 - ORDER_BY_DESC: Returns records in descending order.
    - roleIdAssignedDirectlyToUser: Filter by roles id assigned directly to user for EE.
    - sortBy: Sort users by the given field.

 - SORT_BY_UNSPECIFIED: Returns users in an unsorted list.
 - SORT_BY_DISPLAY_NAME: Returns users sorted by display name.
 - SORT_BY_USER_NAME: Returns users sorted by user name.
 - SORT_BY_ADMIN: Returns users sorted by if they are admin.
 - SORT_BY_ACTIVE: Returns users sorted by if they are active.
 - SORT_BY_MODIFIED_TIME: Returns users sorted by modified time.
 - SORT_BY_NAME: Returns users sorted by username unless display name exist.
 - SORT_BY_LAST_AUTH_TIME: Returns users sorted by last authenticated time.
 - SORT_BY_REMOTE: Returns users sorted by local or remote auth.
    """
    _params = {
        "active": str(active).lower() if active is not None else None,
        "admin": str(admin).lower() if admin is not None else None,
        "limit": limit,
        "name": name,
        "offset": offset,
        "orderBy": orderBy.value if orderBy is not None else None,
        "roleIdAssignedDirectlyToUser": roleIdAssignedDirectlyToUser,
        "sortBy": sortBy.value if sortBy is not None else None,
    }
    _resp = session._do_request(
        method="GET",
        path="/api/v1/users",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetUsersResponse.from_json(_resp.json())
    raise APIHttpError("get_GetUsers", _resp)

def get_GetValidationMetrics(
    session: "api.BaseSession",
    *,
    trialIds: "typing.Optional[typing.Sequence[int]]" = None,
) -> "typing.Iterable[v1GetValidationMetricsResponse]":
    """Stream one or more trial's validation metrics.

    - trialIds: Trial IDs to get metrics for.
    """
    _params = {
        "trialIds": trialIds,
    }
    _resp = session._do_request(
        method="GET",
        path="/api/v1/trials/metrics/validation_metrics",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=True,
    )
    if _resp.status_code == 200:
        try:
            for _line in _resp.iter_lines(chunk_size=1024 * 1024):
                _j = json.loads(_line)
                if "error" in _j:
                    raise APIHttpStreamError(
                        "get_GetValidationMetrics",
                        runtimeStreamError.from_json(_j["error"])
                )
                yield v1GetValidationMetricsResponse.from_json(_j["result"])
        except requests.exceptions.ChunkedEncodingError:
            raise APIHttpStreamError("get_GetValidationMetrics", runtimeStreamError(message="ChunkedEncodingError"))
        return
    raise APIHttpError("get_GetValidationMetrics", _resp)

def get_GetWebhooks(
    session: "api.BaseSession",
) -> "v1GetWebhooksResponse":
    """Get a list of webhooks."""
    _params = None
    _resp = session._do_request(
        method="GET",
        path="/api/v1/webhooks",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetWebhooksResponse.from_json(_resp.json())
    raise APIHttpError("get_GetWebhooks", _resp)

def get_GetWorkspace(
    session: "api.BaseSession",
    *,
    id: int,
) -> "v1GetWorkspaceResponse":
    """Get the requested workspace.

    - id: The id of the workspace.
    """
    _params = None
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/workspaces/{id}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetWorkspaceResponse.from_json(_resp.json())
    raise APIHttpError("get_GetWorkspace", _resp)

def get_GetWorkspaceConfigPolicies(
    session: "api.BaseSession",
    *,
    workloadType: str,
    workspaceId: int,
) -> "v1GetWorkspaceConfigPoliciesResponse":
    """Get workspace task config policies.

    - workloadType: The workload type the config policies apply to: EXPERIMENT or NTSC.
    - workspaceId: The workspace the config policies apply to. Use global API for
global config policies.
    """
    _params = None
    if type(workloadType) == str:
        workloadType = parse.quote(workloadType)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/config-policies/workspaces/{workspaceId}/{workloadType}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetWorkspaceConfigPoliciesResponse.from_json(_resp.json())
    raise APIHttpError("get_GetWorkspaceConfigPolicies", _resp)

def get_GetWorkspaceProjects(
    session: "api.BaseSession",
    *,
    id: int,
    archived: "typing.Optional[bool]" = None,
    limit: "typing.Optional[int]" = None,
    name: "typing.Optional[str]" = None,
    offset: "typing.Optional[int]" = None,
    orderBy: "typing.Optional[v1OrderBy]" = None,
    sortBy: "typing.Optional[v1GetWorkspaceProjectsRequestSortBy]" = None,
    userIds: "typing.Optional[typing.Sequence[int]]" = None,
    users: "typing.Optional[typing.Sequence[str]]" = None,
) -> "v1GetWorkspaceProjectsResponse":
    """Get projects associated with a workspace.

    - id: The id of the workspace.
When id is set to 0, return all projects across the all workspaces.
    - archived: Limit the projects to those with an archived status.
    - limit: Limit the number of projects. A value of 0 denotes no limit.
    - name: Limit the projects to those matching the name.
    - offset: Skip the number of projects before returning results. Negative values
denote number of projects to skip from the end before returning results.
    - orderBy: Order projects in either ascending or descending order.

 - ORDER_BY_UNSPECIFIED: Returns records in no specific order.
 - ORDER_BY_ASC: Returns records in ascending order.
 - ORDER_BY_DESC: Returns records in descending order.
    - sortBy: Sort the projects by the given field.

 - SORT_BY_UNSPECIFIED: Returns projects in an unsorted list.
 - SORT_BY_CREATION_TIME: Returns projects sorted by time that they were created.
 - SORT_BY_LAST_EXPERIMENT_START_TIME: Returns projects sorted by most recent start of an experiment.
 - SORT_BY_NAME: Returns projects sorted by name.
 - SORT_BY_DESCRIPTION: Returns projects sorted by description.
 - SORT_BY_ID: Returns projects sorted by ID.
    - userIds: Limit the projects to those from particular users, by userIds.
    - users: Limit the projects to those from particular users, by usernames.
    """
    _params = {
        "archived": str(archived).lower() if archived is not None else None,
        "limit": limit,
        "name": name,
        "offset": offset,
        "orderBy": orderBy.value if orderBy is not None else None,
        "sortBy": sortBy.value if sortBy is not None else None,
        "userIds": userIds,
        "users": users,
    }
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/workspaces/{id}/projects",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetWorkspaceProjectsResponse.from_json(_resp.json())
    raise APIHttpError("get_GetWorkspaceProjects", _resp)

def get_GetWorkspaces(
    session: "api.BaseSession",
    *,
    archived: "typing.Optional[bool]" = None,
    limit: "typing.Optional[int]" = None,
    name: "typing.Optional[str]" = None,
    nameCaseSensitive: "typing.Optional[str]" = None,
    offset: "typing.Optional[int]" = None,
    orderBy: "typing.Optional[v1OrderBy]" = None,
    pinned: "typing.Optional[bool]" = None,
    sortBy: "typing.Optional[v1GetWorkspacesRequestSortBy]" = None,
    userIds: "typing.Optional[typing.Sequence[int]]" = None,
    users: "typing.Optional[typing.Sequence[str]]" = None,
) -> "v1GetWorkspacesResponse":
    """Get a list of workspaces.

    - archived: Limit the workspaces to those with an archived status.
    - limit: Limit the number of workspaces. A value of 0 denotes no limit.
    - name: Limit the workspaces to those matching the name (case insensitive).
    - nameCaseSensitive: Limit the workspaces to those matching the name (case sensitive).
    - offset: Skip the number of workspaces before returning results. Negative values
denote number of workspaces to skip from the end before returning results.
    - orderBy: Order workspaces in either ascending or descending order.

 - ORDER_BY_UNSPECIFIED: Returns records in no specific order.
 - ORDER_BY_ASC: Returns records in ascending order.
 - ORDER_BY_DESC: Returns records in descending order.
    - pinned: Limit the workspaces to those with pinned status by the current user.
    - sortBy: Sort the workspaces by the given field.

 - SORT_BY_UNSPECIFIED: Returns workspaces in an unsorted list.
 - SORT_BY_ID: Returns workspaces sorted by id.
 - SORT_BY_NAME: Returns workspaces sorted by name.
    - userIds: Limit the workspaces to those from particular users, by userIds.
    - users: Limit the workspaces to those from particular users, by usernames.
    """
    _params = {
        "archived": str(archived).lower() if archived is not None else None,
        "limit": limit,
        "name": name,
        "nameCaseSensitive": nameCaseSensitive,
        "offset": offset,
        "orderBy": orderBy.value if orderBy is not None else None,
        "pinned": str(pinned).lower() if pinned is not None else None,
        "sortBy": sortBy.value if sortBy is not None else None,
        "userIds": userIds,
        "users": users,
    }
    _resp = session._do_request(
        method="GET",
        path="/api/v1/workspaces",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetWorkspacesResponse.from_json(_resp.json())
    raise APIHttpError("get_GetWorkspaces", _resp)

def get_GetWorkspacesWithDefaultNamespaceBindings(
    session: "api.BaseSession",
) -> "v1GetWorkspacesWithDefaultNamespaceBindingsResponse":
    """Gets the ids of all workspaces that are bound to the default namespace for
    atleast one cluster.
    """
    _params = None
    _resp = session._do_request(
        method="GET",
        path="/api/v1/namespace-bindings/workspace-ids-with-default-bindings",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1GetWorkspacesWithDefaultNamespaceBindingsResponse.from_json(_resp.json())
    raise APIHttpError("get_GetWorkspacesWithDefaultNamespaceBindings", _resp)

def put_IdleNotebook(
    session: "api.BaseSession",
    *,
    body: "v1IdleNotebookRequest",
    notebookId: str,
) -> None:
    """Send notebook idle data to master

    - notebookId: The id of the notebook.
    """
    _params = None
    if type(notebookId) == str:
        notebookId = parse.quote(notebookId)
    _resp = session._do_request(
        method="PUT",
        path=f"/api/v1/notebooks/{notebookId}/report_idle",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("put_IdleNotebook", _resp)

def post_KillCommand(
    session: "api.BaseSession",
    *,
    commandId: str,
) -> "v1KillCommandResponse":
    """Kill the requested command.

    - commandId: The id of the command.
    """
    _params = None
    if type(commandId) == str:
        commandId = parse.quote(commandId)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/commands/{commandId}/kill",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1KillCommandResponse.from_json(_resp.json())
    raise APIHttpError("post_KillCommand", _resp)

def post_KillExperiment(
    session: "api.BaseSession",
    *,
    id: int,
) -> None:
    """Kill an experiment.

    - id: The experiment id.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/experiments/{id}/kill",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_KillExperiment", _resp)

def post_KillExperiments(
    session: "api.BaseSession",
    *,
    body: "v1KillExperimentsRequest",
    projectId: int,
) -> "v1KillExperimentsResponse":
    """Kill multiple experiments.

    - projectId: Project id that the experiments belong to.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/projects/{projectId}/experiments/kill",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1KillExperimentsResponse.from_json(_resp.json())
    raise APIHttpError("post_KillExperiments", _resp)

def post_KillGenericTask(
    session: "api.BaseSession",
    *,
    body: "v1KillGenericTaskRequest",
    taskId: str,
) -> None:
    """Kill generic task

    - taskId: The id of the task.
    """
    _params = None
    if type(taskId) == str:
        taskId = parse.quote(taskId)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/tasks/{taskId}/kill",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_KillGenericTask", _resp)

def post_KillNotebook(
    session: "api.BaseSession",
    *,
    notebookId: str,
) -> "v1KillNotebookResponse":
    """Kill the requested notebook.

    - notebookId: The id of the notebook.
    """
    _params = None
    if type(notebookId) == str:
        notebookId = parse.quote(notebookId)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/notebooks/{notebookId}/kill",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1KillNotebookResponse.from_json(_resp.json())
    raise APIHttpError("post_KillNotebook", _resp)

def post_KillRuns(
    session: "api.BaseSession",
    *,
    body: "v1KillRunsRequest",
) -> "v1KillRunsResponse":
    """Kill runs."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/runs/kill",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1KillRunsResponse.from_json(_resp.json())
    raise APIHttpError("post_KillRuns", _resp)

def post_KillShell(
    session: "api.BaseSession",
    *,
    shellId: str,
) -> "v1KillShellResponse":
    """Kill the requested shell.

    - shellId: The id of the shell.
    """
    _params = None
    if type(shellId) == str:
        shellId = parse.quote(shellId)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/shells/{shellId}/kill",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1KillShellResponse.from_json(_resp.json())
    raise APIHttpError("post_KillShell", _resp)

def post_KillTensorboard(
    session: "api.BaseSession",
    *,
    tensorboardId: str,
) -> "v1KillTensorboardResponse":
    """Kill the requested tensorboard.

    - tensorboardId: The id of the tensorboard.
    """
    _params = None
    if type(tensorboardId) == str:
        tensorboardId = parse.quote(tensorboardId)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/tensorboards/{tensorboardId}/kill",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1KillTensorboardResponse.from_json(_resp.json())
    raise APIHttpError("post_KillTensorboard", _resp)

def post_KillTrial(
    session: "api.BaseSession",
    *,
    id: int,
) -> None:
    """Kill a trial.

    - id: The trial id
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/trials/{id}/kill",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_KillTrial", _resp)

def post_LaunchCommand(
    session: "api.BaseSession",
    *,
    body: "v1LaunchCommandRequest",
) -> "v1LaunchCommandResponse":
    """Launch a command."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/commands",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1LaunchCommandResponse.from_json(_resp.json())
    raise APIHttpError("post_LaunchCommand", _resp)

def post_LaunchNotebook(
    session: "api.BaseSession",
    *,
    body: "v1LaunchNotebookRequest",
) -> "v1LaunchNotebookResponse":
    """Launch a notebook."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/notebooks",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1LaunchNotebookResponse.from_json(_resp.json())
    raise APIHttpError("post_LaunchNotebook", _resp)

def post_LaunchShell(
    session: "api.BaseSession",
    *,
    body: "v1LaunchShellRequest",
) -> "v1LaunchShellResponse":
    """Launch a shell."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/shells",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1LaunchShellResponse.from_json(_resp.json())
    raise APIHttpError("post_LaunchShell", _resp)

def post_LaunchTensorboard(
    session: "api.BaseSession",
    *,
    body: "v1LaunchTensorboardRequest",
) -> "v1LaunchTensorboardResponse":
    """Launch a tensorboard."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/tensorboards",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1LaunchTensorboardResponse.from_json(_resp.json())
    raise APIHttpError("post_LaunchTensorboard", _resp)

def get_ListRPsBoundToWorkspace(
    session: "api.BaseSession",
    *,
    workspaceId: int,
    limit: "typing.Optional[int]" = None,
    offset: "typing.Optional[int]" = None,
) -> "v1ListRPsBoundToWorkspaceResponse":
    """List all resource pools, bound and unbound, available to a specific
    workspace

    - workspaceId: Workspace ID.
    - limit: The maximum number of results to return.
    - offset: The offset to use with pagination.
    """
    _params = {
        "limit": limit,
        "offset": offset,
    }
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/workspaces/{workspaceId}/available-resource-pools",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1ListRPsBoundToWorkspaceResponse.from_json(_resp.json())
    raise APIHttpError("get_ListRPsBoundToWorkspace", _resp)

def post_ListRoles(
    session: "api.BaseSession",
    *,
    body: "v1ListRolesRequest",
) -> "v1ListRolesResponse":
    """ListRoles returns roles and groups/users granted that role."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/roles/search",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1ListRolesResponse.from_json(_resp.json())
    raise APIHttpError("post_ListRoles", _resp)

def get_ListWorkspaceNamespaceBindings(
    session: "api.BaseSession",
    *,
    id: int,
) -> "v1ListWorkspaceNamespaceBindingsResponse":
    """List namespaces bound to a workspace.

    - id: The unique id of the workspace.
    """
    _params = None
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/workspaces/{id}/list-namespace-bindings",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1ListWorkspaceNamespaceBindingsResponse.from_json(_resp.json())
    raise APIHttpError("get_ListWorkspaceNamespaceBindings", _resp)

def get_ListWorkspacesBoundToRP(
    session: "api.BaseSession",
    *,
    resourcePoolName: str,
    limit: "typing.Optional[int]" = None,
    offset: "typing.Optional[int]" = None,
) -> "v1ListWorkspacesBoundToRPResponse":
    """List all workspaces bound to a specific resource pool

    - resourcePoolName: Resource pool name.
    - limit: The maximum number of results to return.
    - offset: The offset to use with pagination.
    """
    _params = {
        "limit": limit,
        "offset": offset,
    }
    if type(resourcePoolName) == str:
        resourcePoolName = parse.quote(resourcePoolName)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/resource-pools/{resourcePoolName}/workspace-bindings",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1ListWorkspacesBoundToRPResponse.from_json(_resp.json())
    raise APIHttpError("get_ListWorkspacesBoundToRP", _resp)

def post_Login(
    session: "api.BaseSession",
    *,
    body: "v1LoginRequest",
) -> "v1LoginResponse":
    """Login the user."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/auth/login",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1LoginResponse.from_json(_resp.json())
    raise APIHttpError("post_Login", _resp)

def post_Logout(
    session: "api.BaseSession",
) -> None:
    """Logout the user."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/auth/logout",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_Logout", _resp)

def post_MarkAllocationResourcesDaemon(
    session: "api.BaseSession",
    *,
    allocationId: str,
    body: "v1MarkAllocationResourcesDaemonRequest",
    resourcesId: str,
) -> None:
    """Mark the given reservation (container, pod, etc) within an allocation as
    a daemon reservation. In the exit of a successful exit, Determined will
    wait for all resources to exit - unless they are marked as daemon
    resources, in which case Determined will clean them up regardless of
    exit status after all non-daemon resources have exited.

    - allocationId: The id of the allocation.
    - resourcesId: The id of the clump of resources to mark as daemon.
    """
    _params = None
    if type(allocationId) == str:
        allocationId = parse.quote(allocationId)
    if type(resourcesId) == str:
        resourcesId = parse.quote(resourcesId)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/allocations/{allocationId}/resources/{resourcesId}/daemon",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_MarkAllocationResourcesDaemon", _resp)

def get_MasterLogs(
    session: "api.BaseSession",
    *,
    follow: "typing.Optional[bool]" = None,
    limit: "typing.Optional[int]" = None,
    offset: "typing.Optional[int]" = None,
) -> "typing.Iterable[v1MasterLogsResponse]":
    """Stream master logs.

    - follow: Continue following logs until the master stops or the limit is reached.
    - limit: Limit the number of master logs. A value of 0 denotes no limit.
    - offset: Skip the number of master logs before returning results. Negative values
denote number of master logs to skip from the end before returning results.
    """
    _params = {
        "follow": str(follow).lower() if follow is not None else None,
        "limit": limit,
        "offset": offset,
    }
    _resp = session._do_request(
        method="GET",
        path="/api/v1/master/logs",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=True,
    )
    if _resp.status_code == 200:
        try:
            for _line in _resp.iter_lines(chunk_size=1024 * 1024):
                _j = json.loads(_line)
                if "error" in _j:
                    raise APIHttpStreamError(
                        "get_MasterLogs",
                        runtimeStreamError.from_json(_j["error"])
                )
                yield v1MasterLogsResponse.from_json(_j["result"])
        except requests.exceptions.ChunkedEncodingError:
            raise APIHttpStreamError("get_MasterLogs", runtimeStreamError(message="ChunkedEncodingError"))
        return
    raise APIHttpError("get_MasterLogs", _resp)

def get_MetricBatches(
    session: "api.BaseSession",
    *,
    experimentId: int,
    metricName: str,
    group: "typing.Optional[str]" = None,
    metricType: "typing.Optional[v1MetricType]" = None,
    periodSeconds: "typing.Optional[int]" = None,
) -> "typing.Iterable[v1MetricBatchesResponse]":
    """Get the milestones (in batches processed) at which a metric is recorded by
    an experiment.

    - experimentId: The id of the experiment.
    - metricName: A metric name.
    - group: Metric group (training, validation, etc).
    - metricType: The type of metric.

 - METRIC_TYPE_UNSPECIFIED: Zero-value (not allowed).
 - METRIC_TYPE_TRAINING: For metrics emitted during training.
 - METRIC_TYPE_VALIDATION: For metrics emitted during validation.
 - METRIC_TYPE_PROFILING: For metrics emitted during profiling.
    - periodSeconds: Seconds to wait when polling for updates.
    """
    _params = {
        "group": group,
        "metricName": metricName,
        "metricType": metricType.value if metricType is not None else None,
        "periodSeconds": periodSeconds,
    }
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/experiments/{experimentId}/metrics-stream/batches",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=True,
    )
    if _resp.status_code == 200:
        try:
            for _line in _resp.iter_lines(chunk_size=1024 * 1024):
                _j = json.loads(_line)
                if "error" in _j:
                    raise APIHttpStreamError(
                        "get_MetricBatches",
                        runtimeStreamError.from_json(_j["error"])
                )
                yield v1MetricBatchesResponse.from_json(_j["result"])
        except requests.exceptions.ChunkedEncodingError:
            raise APIHttpStreamError("get_MetricBatches", runtimeStreamError(message="ChunkedEncodingError"))
        return
    raise APIHttpError("get_MetricBatches", _resp)

def post_MoveExperiment(
    session: "api.BaseSession",
    *,
    body: "v1MoveExperimentRequest",
    experimentId: int,
) -> None:
    """Move an experiment into a project.

    - experimentId: The id of the experiment being moved.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/experiments/{experimentId}/move",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_MoveExperiment", _resp)

def post_MoveExperiments(
    session: "api.BaseSession",
    *,
    body: "v1MoveExperimentsRequest",
    projectId: int,
) -> "v1MoveExperimentsResponse":
    """Move multiple experiments into a project.

    - projectId: Project id that the experiments belong to.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/projects/{projectId}/experiments/move",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1MoveExperimentsResponse.from_json(_resp.json())
    raise APIHttpError("post_MoveExperiments", _resp)

def post_MoveModel(
    session: "api.BaseSession",
    *,
    body: "v1MoveModelRequest",
    modelName: str,
) -> None:
    """Move a model into a workspace

    - modelName: The target model name.
    """
    _params = None
    if type(modelName) == str:
        modelName = parse.quote(modelName)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/models/{modelName}/move",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_MoveModel", _resp)

def post_MoveProject(
    session: "api.BaseSession",
    *,
    body: "v1MoveProjectRequest",
    projectId: int,
) -> None:
    """Move a project into a workspace.

    - projectId: The id of the project being moved.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/projects/{projectId}/move",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_MoveProject", _resp)

def post_MoveRuns(
    session: "api.BaseSession",
    *,
    body: "v1MoveRunsRequest",
) -> "v1MoveRunsResponse":
    """Move runs."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/runs/move",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1MoveRunsResponse.from_json(_resp.json())
    raise APIHttpError("post_MoveRuns", _resp)

def post_NotifyContainerRunning(
    session: "api.BaseSession",
    *,
    allocationId: str,
    body: "v1NotifyContainerRunningRequest",
) -> "v1NotifyContainerRunningResponse":
    """NotifyContainterRunning is used to notify the master that the container
    is running.  On HPC, the launcher will report a state of "Running" as
    soon as Slurm starts the job, but the container may be in the process
    of getting pulled down from the Internet, so the experiment is not
    really considered to be in a "Running" state until all the containers
    that are part of the experiment are running and not being pulled.

    - allocationId: The ID of the allocation.
    """
    _params = None
    if type(allocationId) == str:
        allocationId = parse.quote(allocationId)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/allocations/{allocationId}/notify_container_running",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1NotifyContainerRunningResponse.from_json(_resp.json())
    raise APIHttpError("post_NotifyContainerRunning", _resp)

def put_OverwriteRPWorkspaceBindings(
    session: "api.BaseSession",
    *,
    body: "v1OverwriteRPWorkspaceBindingsRequest",
    resourcePoolName: str,
) -> None:
    """Overwrite resource pool - workspace bindings

    - resourcePoolName: The resource pool name.
    """
    _params = None
    if type(resourcePoolName) == str:
        resourcePoolName = parse.quote(resourcePoolName)
    _resp = session._do_request(
        method="PUT",
        path=f"/api/v1/resource-pools/{resourcePoolName}/workspace-bindings",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("put_OverwriteRPWorkspaceBindings", _resp)

def patch_PatchAccessToken(
    session: "api.BaseSession",
    *,
    body: "v1PatchAccessTokenRequest",
    tokenId: int,
) -> "v1PatchAccessTokenResponse":
    """Patch an access token's mutable fields.

    - tokenId: The id of the token.
    """
    _params = None
    _resp = session._do_request(
        method="PATCH",
        path=f"/api/v1/tokens/{tokenId}",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PatchAccessTokenResponse.from_json(_resp.json())
    raise APIHttpError("patch_PatchAccessToken", _resp)

def patch_PatchCheckpoints(
    session: "api.BaseSession",
    *,
    body: "v1PatchCheckpointsRequest",
) -> None:
    """Update checkpoints. Won't modify checkpoint files."""
    _params = None
    _resp = session._do_request(
        method="PATCH",
        path="/api/v1/checkpoints",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("patch_PatchCheckpoints", _resp)

def patch_PatchExperiment(
    session: "api.BaseSession",
    *,
    body: "v1PatchExperiment",
    experiment_id: int,
) -> "v1PatchExperimentResponse":
    """Patch an experiment's fields.

    - body: Patched experiment attributes.
    - experiment_id: The id of the experiment.
    """
    _params = None
    _resp = session._do_request(
        method="PATCH",
        path=f"/api/v1/experiments/{experiment_id}",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PatchExperimentResponse.from_json(_resp.json())
    raise APIHttpError("patch_PatchExperiment", _resp)

def patch_PatchMasterConfig(
    session: "api.BaseSession",
    *,
    body: "v1PatchMasterConfigRequest",
) -> None:
    """Patch master config."""
    _params = None
    _resp = session._do_request(
        method="PATCH",
        path="/api/v1/master/config",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("patch_PatchMasterConfig", _resp)

def patch_PatchModel(
    session: "api.BaseSession",
    *,
    body: "v1PatchModel",
    modelName: str,
) -> "v1PatchModelResponse":
    """Patch a model's fields.

    - body: The model desired model fields and values.
    - modelName: The name of the model being updated.
    """
    _params = None
    if type(modelName) == str:
        modelName = parse.quote(modelName)
    _resp = session._do_request(
        method="PATCH",
        path=f"/api/v1/models/{modelName}",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PatchModelResponse.from_json(_resp.json())
    raise APIHttpError("patch_PatchModel", _resp)

def patch_PatchModelVersion(
    session: "api.BaseSession",
    *,
    body: "v1PatchModelVersion",
    modelName: str,
    modelVersionNum: int,
) -> "v1PatchModelVersionResponse":
    """Patch a model version's fields.

    - body: Patch payload.
    - modelName: The name of the model being updated.
    - modelVersionNum: The model version number being updated.
    """
    _params = None
    if type(modelName) == str:
        modelName = parse.quote(modelName)
    _resp = session._do_request(
        method="PATCH",
        path=f"/api/v1/models/{modelName}/versions/{modelVersionNum}",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PatchModelVersionResponse.from_json(_resp.json())
    raise APIHttpError("patch_PatchModelVersion", _resp)

def patch_PatchProject(
    session: "api.BaseSession",
    *,
    body: "v1PatchProject",
    id: int,
) -> "v1PatchProjectResponse":
    """Update a project.

    - body: The desired project fields and values to update.
    - id: The id of the project.
    """
    _params = None
    _resp = session._do_request(
        method="PATCH",
        path=f"/api/v1/projects/{id}",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PatchProjectResponse.from_json(_resp.json())
    raise APIHttpError("patch_PatchProject", _resp)

def patch_PatchTemplateConfig(
    session: "api.BaseSession",
    *,
    body: "typing.Dict[str, typing.Any]",
    templateName: str,
) -> "v1PatchTemplateConfigResponse":
    """Patch template config.

    - body: The template value.
    - templateName: The name of the template.
    """
    _params = None
    if type(templateName) == str:
        templateName = parse.quote(templateName)
    _resp = session._do_request(
        method="PATCH",
        path=f"/api/v1/templates/{templateName}",
        params=_params,
        json=body,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PatchTemplateConfigResponse.from_json(_resp.json())
    raise APIHttpError("patch_PatchTemplateConfig", _resp)

def patch_PatchTemplateName(
    session: "api.BaseSession",
    *,
    body: "v1PatchTemplateNameRequest",
) -> "v1PatchTemplateNameResponse":
    """Patch template name."""
    _params = None
    _resp = session._do_request(
        method="PATCH",
        path="/api/v1/template/rename",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PatchTemplateNameResponse.from_json(_resp.json())
    raise APIHttpError("patch_PatchTemplateName", _resp)

def patch_PatchTrial(
    session: "api.BaseSession",
    *,
    body: "v1PatchTrialRequest",
    trialId: int,
) -> "v1PatchTrialResponse":
    """Patch (an unmanaged) trial.

    - trialId: Trial id.
    """
    _params = None
    _resp = session._do_request(
        method="PATCH",
        path=f"/api/v1/trials/{trialId}",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PatchTrialResponse.from_json(_resp.json())
    raise APIHttpError("patch_PatchTrial", _resp)

def patch_PatchUser(
    session: "api.BaseSession",
    *,
    body: "v1PatchUser",
    userId: int,
) -> "v1PatchUserResponse":
    """Patch a user's fields.

    - body: The updated user.
    - userId: The id of the user.
    """
    _params = None
    _resp = session._do_request(
        method="PATCH",
        path=f"/api/v1/users/{userId}",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PatchUserResponse.from_json(_resp.json())
    raise APIHttpError("patch_PatchUser", _resp)

def patch_PatchUsers(
    session: "api.BaseSession",
    *,
    body: "v1PatchUsersRequest",
) -> "v1PatchUsersResponse":
    """Patch multiple users' activation status."""
    _params = None
    _resp = session._do_request(
        method="PATCH",
        path="/api/v1/users",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PatchUsersResponse.from_json(_resp.json())
    raise APIHttpError("patch_PatchUsers", _resp)

def patch_PatchWebhook(
    session: "api.BaseSession",
    *,
    body: "v1PatchWebhook",
    id: int,
) -> None:
    """Update a webhook.

    - body: The desired webhook fields and values to update.
    - id: The id of the webhook.
    """
    _params = None
    _resp = session._do_request(
        method="PATCH",
        path=f"/api/v1/webhooks/{id}",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("patch_PatchWebhook", _resp)

def patch_PatchWorkspace(
    session: "api.BaseSession",
    *,
    body: "v1PatchWorkspace",
    id: int,
) -> "v1PatchWorkspaceResponse":
    """Update a workspace.

    - body: The desired workspace fields and values to update.
    - id: The id of the workspace.
    """
    _params = None
    _resp = session._do_request(
        method="PATCH",
        path=f"/api/v1/workspaces/{id}",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PatchWorkspaceResponse.from_json(_resp.json())
    raise APIHttpError("patch_PatchWorkspace", _resp)

def post_PauseExperiment(
    session: "api.BaseSession",
    *,
    id: int,
) -> None:
    """Pause an experiment.

    - id: The experiment id.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/experiments/{id}/pause",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_PauseExperiment", _resp)

def post_PauseExperiments(
    session: "api.BaseSession",
    *,
    body: "v1PauseExperimentsRequest",
    projectId: int,
) -> "v1PauseExperimentsResponse":
    """Pause multiple experiments.

    - projectId: Project id that the experiments belong to.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/projects/{projectId}/experiments/pause",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PauseExperimentsResponse.from_json(_resp.json())
    raise APIHttpError("post_PauseExperiments", _resp)

def post_PauseGenericTask(
    session: "api.BaseSession",
    *,
    taskId: str,
) -> None:
    """Pause generic task

    - taskId: The id of the task.
    """
    _params = None
    if type(taskId) == str:
        taskId = parse.quote(taskId)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/tasks/{taskId}/pause",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_PauseGenericTask", _resp)

def post_PauseRuns(
    session: "api.BaseSession",
    *,
    body: "v1PauseRunsRequest",
) -> "v1PauseRunsResponse":
    """Pause experiment associated with provided runs."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/runs/pause",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PauseRunsResponse.from_json(_resp.json())
    raise APIHttpError("post_PauseRuns", _resp)

def post_PinWorkspace(
    session: "api.BaseSession",
    *,
    id: int,
) -> None:
    """Pin a workspace.

    - id: The id of the workspace.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/workspaces/{id}/pin",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_PinWorkspace", _resp)

def post_PostAccessToken(
    session: "api.BaseSession",
    *,
    body: "v1PostAccessTokenRequest",
) -> "v1PostAccessTokenResponse":
    """Create and get a user's access token"""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/tokens",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PostAccessTokenResponse.from_json(_resp.json())
    raise APIHttpError("post_PostAccessToken", _resp)

def post_PostAllocationAcceleratorData(
    session: "api.BaseSession",
    *,
    allocationId: str,
    body: "v1PostAllocationAcceleratorDataRequest",
) -> None:
    """PostAllocationAcceleratorData sets the accelerator for a given allocation.

    - allocationId: The id of the allocation.
    """
    _params = None
    if type(allocationId) == str:
        allocationId = parse.quote(allocationId)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/allocations/{allocationId}/acceleratorData",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_PostAllocationAcceleratorData", _resp)

def post_PostAllocationProxyAddress(
    session: "api.BaseSession",
    *,
    allocationId: str,
    body: "v1PostAllocationProxyAddressRequest",
) -> None:
    """PostAllocationProxyAddress sets the proxy address to use when proxying to
    services provided by an allocation. Upon receipt, the master will also
    register any proxies specified by the task.

    - allocationId: The id of the allocation.
    """
    _params = None
    if type(allocationId) == str:
        allocationId = parse.quote(allocationId)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/allocations/{allocationId}/proxy_address",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_PostAllocationProxyAddress", _resp)

def post_PostCheckpointMetadata(
    session: "api.BaseSession",
    *,
    body: "v1PostCheckpointMetadataRequest",
    checkpoint_uuid: str,
) -> "v1PostCheckpointMetadataResponse":
    """Update checkpoint metadata.

    - checkpoint_uuid: UUID of the checkpoint.
    """
    _params = None
    if type(checkpoint_uuid) == str:
        checkpoint_uuid = parse.quote(checkpoint_uuid)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/checkpoints/{checkpoint_uuid}/metadata",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PostCheckpointMetadataResponse.from_json(_resp.json())
    raise APIHttpError("post_PostCheckpointMetadata", _resp)

def post_PostModel(
    session: "api.BaseSession",
    *,
    body: "v1PostModelRequest",
) -> "v1PostModelResponse":
    """Create a model in the registry."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/models",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PostModelResponse.from_json(_resp.json())
    raise APIHttpError("post_PostModel", _resp)

def post_PostModelVersion(
    session: "api.BaseSession",
    *,
    body: "v1PostModelVersionRequest",
    modelName: str,
) -> "v1PostModelVersionResponse":
    """Create a model version.

    - modelName: The name of the model to add this version to.
    """
    _params = None
    if type(modelName) == str:
        modelName = parse.quote(modelName)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/models/{modelName}/versions",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PostModelVersionResponse.from_json(_resp.json())
    raise APIHttpError("post_PostModelVersion", _resp)

def post_PostProject(
    session: "api.BaseSession",
    *,
    body: "v1PostProjectRequest",
    workspaceId: int,
) -> "v1PostProjectResponse":
    """Create a project.

    - workspaceId: Id of the associated workspace.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/workspaces/{workspaceId}/projects",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PostProjectResponse.from_json(_resp.json())
    raise APIHttpError("post_PostProject", _resp)

def post_PostRunMetadata(
    session: "api.BaseSession",
    *,
    body: "v1PostRunMetadataRequest",
    runId: int,
) -> "v1PostRunMetadataResponse":
    """Update run metadata.

    - runId: The ID of the run to post metadata for.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/runs/{runId}/metadata",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PostRunMetadataResponse.from_json(_resp.json())
    raise APIHttpError("post_PostRunMetadata", _resp)

def post_PostTaskLogs(
    session: "api.BaseSession",
    *,
    body: "v1PostTaskLogsRequest",
) -> None:
    """Persist the given task logs."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/task/logs",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_PostTaskLogs", _resp)

def post_PostTemplate(
    session: "api.BaseSession",
    *,
    body: "v1Template",
    template_name: str,
) -> "v1PostTemplateResponse":
    """Post a new template.

    - body: The template to put.
    - template_name: The name of the template.
    """
    _params = None
    if type(template_name) == str:
        template_name = parse.quote(template_name)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/templates/{template_name}",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PostTemplateResponse.from_json(_resp.json())
    raise APIHttpError("post_PostTemplate", _resp)

def post_PostTrialProfilerMetricsBatch(
    session: "api.BaseSession",
    *,
    body: "v1PostTrialProfilerMetricsBatchRequest",
) -> None:
    """Persist the given TrialProfilerMetricsBatch. The trial ID is in the labels."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/trials/profiler/metrics",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_PostTrialProfilerMetricsBatch", _resp)

def post_PostTrialRunnerMetadata(
    session: "api.BaseSession",
    *,
    body: "v1TrialRunnerMetadata",
    trialId: int,
) -> None:
    """For bookkeeping, update trial runner metadata (currently just state).

    - body: The state for the trial runner.
    - trialId: The id of the trial.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/trials/{trialId}/runner/metadata",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_PostTrialRunnerMetadata", _resp)

def post_PostUser(
    session: "api.BaseSession",
    *,
    body: "v1PostUserRequest",
) -> "v1PostUserResponse":
    """Create a new user."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/users",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PostUserResponse.from_json(_resp.json())
    raise APIHttpError("post_PostUser", _resp)

def post_PostUserActivity(
    session: "api.BaseSession",
    *,
    body: "v1PostUserActivityRequest",
) -> None:
    """Patch a user's activity"""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/users/activity",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_PostUserActivity", _resp)

def post_PostUserSetting(
    session: "api.BaseSession",
    *,
    body: "v1PostUserSettingRequest",
) -> None:
    """Post a user's settings for website"""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/users/setting",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_PostUserSetting", _resp)

def post_PostWebhook(
    session: "api.BaseSession",
    *,
    body: "v1Webhook",
) -> "v1PostWebhookResponse":
    """Create a webhook.
    TODO(???): Simplify req/response structs?

    - body: The webhook to store.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/webhooks",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PostWebhookResponse.from_json(_resp.json())
    raise APIHttpError("post_PostWebhook", _resp)

def post_PostWebhookEventData(
    session: "api.BaseSession",
    *,
    body: "v1PostWebhookEventDataRequest",
) -> None:
    """Trigger custom trigger of webhooks."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/webhooks/custom",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_PostWebhookEventData", _resp)

def post_PostWorkspace(
    session: "api.BaseSession",
    *,
    body: "v1PostWorkspaceRequest",
) -> "v1PostWorkspaceResponse":
    """Create a workspace."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/workspaces",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PostWorkspaceResponse.from_json(_resp.json())
    raise APIHttpError("post_PostWorkspace", _resp)

def post_PreviewHPSearch(
    session: "api.BaseSession",
    *,
    body: "v1PreviewHPSearchRequest",
) -> "v1PreviewHPSearchResponse":
    """Preview hyperparameter search."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/preview-hp-search",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PreviewHPSearchResponse.from_json(_resp.json())
    raise APIHttpError("post_PreviewHPSearch", _resp)

def put_PutExperiment(
    session: "api.BaseSession",
    *,
    body: "v1CreateExperimentRequest",
    externalExperimentId: str,
) -> "v1PutExperimentResponse":
    """Put an experiment by external id.

    - body: CreateExperimentRequest payload.
    - externalExperimentId: External experiment id.
    """
    _params = None
    if type(externalExperimentId) == str:
        externalExperimentId = parse.quote(externalExperimentId)
    _resp = session._do_request(
        method="PUT",
        path=f"/api/v1/experiments/by-external-id/{externalExperimentId}",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PutExperimentResponse.from_json(_resp.json())
    raise APIHttpError("put_PutExperiment", _resp)

def put_PutExperimentLabel(
    session: "api.BaseSession",
    *,
    experimentId: int,
    label: str,
) -> "v1PutExperimentLabelResponse":
    """Put a new label on the experiment.

    - experimentId: The ID of the experiment.
    - label: The label to add.
    """
    _params = None
    if type(label) == str:
        label = parse.quote(label)
    _resp = session._do_request(
        method="PUT",
        path=f"/api/v1/experiments/{experimentId}/labels/{label}",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PutExperimentLabelResponse.from_json(_resp.json())
    raise APIHttpError("put_PutExperimentLabel", _resp)

def put_PutExperimentRetainLogs(
    session: "api.BaseSession",
    *,
    body: "v1PutExperimentRetainLogsRequest",
    experimentId: int,
) -> None:
    """Retain logs for an experiment.

    - experimentId: The ID of the experiment.
    """
    _params = None
    _resp = session._do_request(
        method="PUT",
        path=f"/api/v1/experiments/{experimentId}/retain_logs",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("put_PutExperimentRetainLogs", _resp)

def put_PutExperimentsRetainLogs(
    session: "api.BaseSession",
    *,
    body: "v1PutExperimentsRetainLogsRequest",
    projectId: int,
) -> "v1PutExperimentsRetainLogsResponse":
    """Retain logs for an experiment.

    - projectId: Project id that the experiments belong to.
    """
    _params = None
    _resp = session._do_request(
        method="PUT",
        path=f"/api/v1/projects/{projectId}/experiments/retain_logs",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PutExperimentsRetainLogsResponse.from_json(_resp.json())
    raise APIHttpError("put_PutExperimentsRetainLogs", _resp)

def put_PutGlobalConfigPolicies(
    session: "api.BaseSession",
    *,
    body: "v1PutGlobalConfigPoliciesRequest",
    workloadType: str,
) -> "v1PutGlobalConfigPoliciesResponse":
    """Add or update global task config policies.

    - workloadType: The workload type the config policies apply to: EXPERIMENT or NTSC.
    """
    _params = None
    if type(workloadType) == str:
        workloadType = parse.quote(workloadType)
    _resp = session._do_request(
        method="PUT",
        path=f"/api/v1/config-policies/global/{workloadType}",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PutGlobalConfigPoliciesResponse.from_json(_resp.json())
    raise APIHttpError("put_PutGlobalConfigPolicies", _resp)

def put_PutProjectNotes(
    session: "api.BaseSession",
    *,
    body: "v1PutProjectNotesRequest",
    projectId: int,
) -> "v1PutProjectNotesResponse":
    """Set project notes.

    - projectId: The id of the project.
    """
    _params = None
    _resp = session._do_request(
        method="PUT",
        path=f"/api/v1/projects/{projectId}/notes",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PutProjectNotesResponse.from_json(_resp.json())
    raise APIHttpError("put_PutProjectNotes", _resp)

def put_PutTemplate(
    session: "api.BaseSession",
    *,
    body: "v1Template",
    template_name: str,
) -> "v1PutTemplateResponse":
    """Update or create (upsert) the requested template.

    - body: The template to put.
    - template_name: The name of the template.
    """
    _params = None
    if type(template_name) == str:
        template_name = parse.quote(template_name)
    _resp = session._do_request(
        method="PUT",
        path=f"/api/v1/templates/{template_name}",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PutTemplateResponse.from_json(_resp.json())
    raise APIHttpError("put_PutTemplate", _resp)

def put_PutTrial(
    session: "api.BaseSession",
    *,
    body: "v1PutTrialRequest",
) -> "v1PutTrialResponse":
    """Put a trial."""
    _params = None
    _resp = session._do_request(
        method="PUT",
        path="/api/v1/trials",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PutTrialResponse.from_json(_resp.json())
    raise APIHttpError("put_PutTrial", _resp)

def put_PutTrialRetainLogs(
    session: "api.BaseSession",
    *,
    body: "v1PutTrialRetainLogsRequest",
    trialId: int,
) -> None:
    """Retain logs for a Trial.

    - trialId: The ID of the trial.
    """
    _params = None
    _resp = session._do_request(
        method="PUT",
        path=f"/api/v1/trials/{trialId}/retain_logs",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("put_PutTrialRetainLogs", _resp)

def put_PutWorkspaceConfigPolicies(
    session: "api.BaseSession",
    *,
    body: "v1PutWorkspaceConfigPoliciesRequest",
    workloadType: str,
    workspaceId: int,
) -> "v1PutWorkspaceConfigPoliciesResponse":
    """Add or update workspace task config policies.

    - workloadType: The workload type the config policies apply to: EXPERIMENT or NTSC.
    - workspaceId: The workspace the config policies apply to. Use global API for
global config policies.
    """
    _params = None
    if type(workloadType) == str:
        workloadType = parse.quote(workloadType)
    _resp = session._do_request(
        method="PUT",
        path=f"/api/v1/config-policies/workspaces/{workspaceId}/{workloadType}",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1PutWorkspaceConfigPoliciesResponse.from_json(_resp.json())
    raise APIHttpError("put_PutWorkspaceConfigPolicies", _resp)

def post_RemoveAssignments(
    session: "api.BaseSession",
    *,
    body: "v1RemoveAssignmentsRequest",
) -> None:
    """RemoveAssignments removes a set of role assignments from the system."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/roles/remove-assignments",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_RemoveAssignments", _resp)

def post_ReportCheckpoint(
    session: "api.BaseSession",
    *,
    body: "v1Checkpoint",
) -> None:
    """Record a checkpoint.

    - body: The training metrics to persist.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/checkpoints",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_ReportCheckpoint", _resp)

def post_ReportTrialMetrics(
    session: "api.BaseSession",
    *,
    body: "v1ReportTrialMetricsRequest",
    metrics_trialId: int,
) -> None:
    """Record metrics for specified trial.

    - metrics_trialId: The trial associated with these metrics.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/trials/{metrics_trialId}/metrics",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_ReportTrialMetrics", _resp)

def post_ReportTrialProgress(
    session: "api.BaseSession",
    *,
    body: "v1ReportTrialProgressRequest",
    trialId: int,
) -> None:
    """For bookkeeping, updates the progress towards to current requested searcher
    training length.

    - trialId: The id of the trial.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/trials/{trialId}/progress",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_ReportTrialProgress", _resp)

def post_ReportTrialSearcherEarlyExit(
    session: "api.BaseSession",
    *,
    body: "v1TrialEarlyExit",
    trialId: int,
) -> None:
    """Reports to the searcher that the trial has completed the current
    requested amount of training with the given searcher validation
    metric.

    - body: The exit reason.
    - trialId: The id of the trial.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/trials/{trialId}/early_exit",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_ReportTrialSearcherEarlyExit", _resp)

def post_ReportTrialSourceInfo(
    session: "api.BaseSession",
    *,
    body: "v1ReportTrialSourceInfoRequest",
) -> "v1ReportTrialSourceInfoResponse":
    """Reports a TrialSourceInfo entry for tracking inference or fine-tuning runs"""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/trial-source-info",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1ReportTrialSourceInfoResponse.from_json(_resp.json())
    raise APIHttpError("post_ReportTrialSourceInfo", _resp)

def post_ReportTrialTrainingMetrics(
    session: "api.BaseSession",
    *,
    body: "v1TrialMetrics",
    trainingMetrics_trialId: int,
) -> None:
    """Record training metrics for specified training.

    - body: The training metrics to persist.
    - trainingMetrics_trialId: The trial associated with these metrics.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/trials/{trainingMetrics_trialId}/training_metrics",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_ReportTrialTrainingMetrics", _resp)

def post_ReportTrialValidationMetrics(
    session: "api.BaseSession",
    *,
    body: "v1TrialMetrics",
    validationMetrics_trialId: int,
) -> None:
    """Record validation metrics.

    - body: The training metrics to persist.
    - validationMetrics_trialId: The trial associated with these metrics.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/trials/{validationMetrics_trialId}/validation_metrics",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_ReportTrialValidationMetrics", _resp)

def post_ResetUserSetting(
    session: "api.BaseSession",
) -> None:
    """Reset a user's settings for website"""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/users/setting/reset",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_ResetUserSetting", _resp)

def get_ResourceAllocationAggregated(
    session: "api.BaseSession",
    *,
    endDate: str,
    period: "v1ResourceAllocationAggregationPeriod",
    startDate: str,
) -> "v1ResourceAllocationAggregatedResponse":
    """Get an aggregated view of resource allocation during the given time period.

    - endDate: The last day to consider (the exact time is midnight UTC at the end of the
day).
    - period: The period over which to perform aggregation.

 - RESOURCE_ALLOCATION_AGGREGATION_PERIOD_UNSPECIFIED: Unspecified. This value will never actually be returned by the API, it is
just an artifact of using protobuf.
 - RESOURCE_ALLOCATION_AGGREGATION_PERIOD_DAILY: Aggregation by day.
 - RESOURCE_ALLOCATION_AGGREGATION_PERIOD_MONTHLY: Aggregation by month.
    - startDate: The first day to consider (the exact time is midnight UTC at the beginning
of the day).
    """
    _params = {
        "endDate": endDate,
        "period": period.value,
        "startDate": startDate,
    }
    _resp = session._do_request(
        method="GET",
        path="/api/v1/resources/allocation/aggregated",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1ResourceAllocationAggregatedResponse.from_json(_resp.json())
    raise APIHttpError("get_ResourceAllocationAggregated", _resp)

def get_ResourceAllocationRaw(
    session: "api.BaseSession",
    *,
    timestampAfter: str,
    timestampBefore: str,
) -> "v1ResourceAllocationRawResponse":
    """Get a detailed view of resource allocation during the given time period.

    - timestampAfter: The start of the period to consider.
    - timestampBefore: The end of the period to consider.
    """
    _params = {
        "timestampAfter": timestampAfter,
        "timestampBefore": timestampBefore,
    }
    _resp = session._do_request(
        method="GET",
        path="/api/v1/resources/allocation/raw",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1ResourceAllocationRawResponse.from_json(_resp.json())
    raise APIHttpError("get_ResourceAllocationRaw", _resp)

def post_ResumeRuns(
    session: "api.BaseSession",
    *,
    body: "v1ResumeRunsRequest",
) -> "v1ResumeRunsResponse":
    """Unpause experiment associated with provided runs."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/runs/resume",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1ResumeRunsResponse.from_json(_resp.json())
    raise APIHttpError("post_ResumeRuns", _resp)

def post_RunPrepareForReporting(
    session: "api.BaseSession",
    *,
    body: "v1RunPrepareForReportingRequest",
) -> "v1RunPrepareForReportingResponse":
    """Start syncing and prepare to be able to report to a run.
    This should be called once per task that will report to the run.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/runs/start",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1RunPrepareForReportingResponse.from_json(_resp.json())
    raise APIHttpError("post_RunPrepareForReporting", _resp)

def post_SearchExperiments(
    session: "api.BaseSession",
    *,
    body: "v1SearchExperimentsRequest",
) -> "v1SearchExperimentsResponse":
    """Get experiments with grouping and search syntax"""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/experiments-search",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1SearchExperimentsResponse.from_json(_resp.json())
    raise APIHttpError("post_SearchExperiments", _resp)

def post_SearchRolesAssignableToScope(
    session: "api.BaseSession",
    *,
    body: "v1SearchRolesAssignableToScopeRequest",
) -> "v1SearchRolesAssignableToScopeResponse":
    """Search for roles assignable to a given scope."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/roles/search/by-assignability",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1SearchRolesAssignableToScopeResponse.from_json(_resp.json())
    raise APIHttpError("post_SearchRolesAssignableToScope", _resp)

def post_SearchRuns(
    session: "api.BaseSession",
    *,
    body: "v1SearchRunsRequest",
) -> "v1SearchRunsResponse":
    """Get a list of runs."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/runs",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1SearchRunsResponse.from_json(_resp.json())
    raise APIHttpError("post_SearchRuns", _resp)

def put_SetClusterMessage(
    session: "api.BaseSession",
    *,
    body: "v1SetClusterMessageRequest",
) -> None:
    """Set the cluster-wide message shown to users. Only one can be set at at
    time, so any existing message will be disabled.
    """
    _params = None
    _resp = session._do_request(
        method="PUT",
        path="/api/v1/master/cluster_message",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("put_SetClusterMessage", _resp)

def post_SetCommandPriority(
    session: "api.BaseSession",
    *,
    body: "v1SetCommandPriorityRequest",
    commandId: str,
) -> "v1SetCommandPriorityResponse":
    """Set the priority of the requested command.

    - commandId: The id of the command.
    """
    _params = None
    if type(commandId) == str:
        commandId = parse.quote(commandId)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/commands/{commandId}/set_priority",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1SetCommandPriorityResponse.from_json(_resp.json())
    raise APIHttpError("post_SetCommandPriority", _resp)

def post_SetNotebookPriority(
    session: "api.BaseSession",
    *,
    body: "v1SetNotebookPriorityRequest",
    notebookId: str,
) -> "v1SetNotebookPriorityResponse":
    """Set the priority of the requested notebook.

    - notebookId: The id of the notebook.
    """
    _params = None
    if type(notebookId) == str:
        notebookId = parse.quote(notebookId)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/notebooks/{notebookId}/set_priority",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1SetNotebookPriorityResponse.from_json(_resp.json())
    raise APIHttpError("post_SetNotebookPriority", _resp)

def post_SetResourceQuotas(
    session: "api.BaseSession",
    *,
    body: "v1SetResourceQuotasRequest",
    id: int,
) -> None:
    """Set a resource quota for a workspace (within a specific cluster).

    - id: The id of the workspace.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/workspaces/{id}/set-resource-quota",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_SetResourceQuotas", _resp)

def post_SetShellPriority(
    session: "api.BaseSession",
    *,
    body: "v1SetShellPriorityRequest",
    shellId: str,
) -> "v1SetShellPriorityResponse":
    """Set the priority of the requested shell.

    - shellId: The id of the shell.
    """
    _params = None
    if type(shellId) == str:
        shellId = parse.quote(shellId)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/shells/{shellId}/set_priority",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1SetShellPriorityResponse.from_json(_resp.json())
    raise APIHttpError("post_SetShellPriority", _resp)

def post_SetTensorboardPriority(
    session: "api.BaseSession",
    *,
    body: "v1SetTensorboardPriorityRequest",
    tensorboardId: str,
) -> "v1SetTensorboardPriorityResponse":
    """Set the priority of the requested TensorBoard.

    - tensorboardId: The id of the TensorBoard.
    """
    _params = None
    if type(tensorboardId) == str:
        tensorboardId = parse.quote(tensorboardId)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/tensorboards/{tensorboardId}/set_priority",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1SetTensorboardPriorityResponse.from_json(_resp.json())
    raise APIHttpError("post_SetTensorboardPriority", _resp)

def post_SetUserPassword(
    session: "api.BaseSession",
    *,
    body: str,
    userId: int,
) -> "v1SetUserPasswordResponse":
    """Set the requested user's password.

    - body: The password of the user.
    - userId: The id of the user.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/users/{userId}/password",
        params=_params,
        json=body,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1SetUserPasswordResponse.from_json(_resp.json())
    raise APIHttpError("post_SetUserPassword", _resp)

def post_SetWorkspaceNamespaceBindings(
    session: "api.BaseSession",
    *,
    body: "v1SetWorkspaceNamespaceBindingsRequest",
    workspaceId: int,
) -> "v1SetWorkspaceNamespaceBindingsResponse":
    """Bind a namespace to a workspace.

    - workspaceId: The unique id of the workspace.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/workspaces/{workspaceId}/namespace-bindings",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1SetWorkspaceNamespaceBindingsResponse.from_json(_resp.json())
    raise APIHttpError("post_SetWorkspaceNamespaceBindings", _resp)

def post_StartTrial(
    session: "api.BaseSession",
    *,
    body: "v1StartTrialRequest",
    trialId: int,
) -> "v1StartTrialResponse":
    """Start (an unmanaged) trial.

    - trialId: Trial id.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/trials/{trialId}/start",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1StartTrialResponse.from_json(_resp.json())
    raise APIHttpError("post_StartTrial", _resp)

def get_TaskLogs(
    session: "api.BaseSession",
    *,
    taskId: str,
    agentIds: "typing.Optional[typing.Sequence[str]]" = None,
    allocationIds: "typing.Optional[typing.Sequence[str]]" = None,
    containerIds: "typing.Optional[typing.Sequence[str]]" = None,
    enableRegex: "typing.Optional[bool]" = None,
    follow: "typing.Optional[bool]" = None,
    levels: "typing.Optional[typing.Sequence[v1LogLevel]]" = None,
    limit: "typing.Optional[int]" = None,
    orderBy: "typing.Optional[v1OrderBy]" = None,
    rankIds: "typing.Optional[typing.Sequence[int]]" = None,
    searchText: "typing.Optional[str]" = None,
    sources: "typing.Optional[typing.Sequence[str]]" = None,
    stdtypes: "typing.Optional[typing.Sequence[str]]" = None,
    timestampAfter: "typing.Optional[str]" = None,
    timestampBefore: "typing.Optional[str]" = None,
) -> "typing.Iterable[v1TaskLogsResponse]":
    """Stream task logs.

    - taskId: The id of the task.
    - agentIds: Limit the trial logs to a subset of agents.
    - allocationIds: Limit the task logs to particular allocations.
    - containerIds: Limit the trial logs to a subset of containers.
    - enableRegex: Search text is regex. Default to false.
    - follow: Continue following logs until the trial stops.
    - levels: Limit the trial logs to a subset of agents.

 - LOG_LEVEL_UNSPECIFIED: Unspecified log level.
 - LOG_LEVEL_TRACE: A log level of TRACE.
 - LOG_LEVEL_DEBUG: A log level of DEBUG.
 - LOG_LEVEL_INFO: A log level of INFO.
 - LOG_LEVEL_WARNING: A log level of WARNING.
 - LOG_LEVEL_ERROR: A log level of ERROR.
 - LOG_LEVEL_CRITICAL: A log level of CRITICAL.
    - limit: Limit the number of trial logs. A value of 0 denotes no limit.
    - orderBy: Order logs in either ascending or descending order by timestamp.

 - ORDER_BY_UNSPECIFIED: Returns records in no specific order.
 - ORDER_BY_ASC: Returns records in ascending order.
 - ORDER_BY_DESC: Returns records in descending order.
    - rankIds: Limit the trial logs to a subset of ranks.
    - searchText: Search the logs by whether the text contains a substring.
    - sources: Limit the trial logs to a subset of sources.
    - stdtypes: Limit the trial logs to a subset of output streams.
    - timestampAfter: Limit the trial logs to ones with a timestamp after a given time.
    - timestampBefore: Limit the trial logs to ones with a timestamp before a given time.
    """
    _params = {
        "agentIds": agentIds,
        "allocationIds": allocationIds,
        "containerIds": containerIds,
        "enableRegex": str(enableRegex).lower() if enableRegex is not None else None,
        "follow": str(follow).lower() if follow is not None else None,
        "levels": [x.value for x in levels] if levels is not None else None,
        "limit": limit,
        "orderBy": orderBy.value if orderBy is not None else None,
        "rankIds": rankIds,
        "searchText": searchText,
        "sources": sources,
        "stdtypes": stdtypes,
        "timestampAfter": timestampAfter,
        "timestampBefore": timestampBefore,
    }
    if type(taskId) == str:
        taskId = parse.quote(taskId)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/tasks/{taskId}/logs",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=True,
    )
    if _resp.status_code == 200:
        try:
            for _line in _resp.iter_lines(chunk_size=1024 * 1024):
                _j = json.loads(_line)
                if "error" in _j:
                    raise APIHttpStreamError(
                        "get_TaskLogs",
                        runtimeStreamError.from_json(_j["error"])
                )
                yield v1TaskLogsResponse.from_json(_j["result"])
        except requests.exceptions.ChunkedEncodingError:
            raise APIHttpStreamError("get_TaskLogs", runtimeStreamError(message="ChunkedEncodingError"))
        return
    raise APIHttpError("get_TaskLogs", _resp)

def get_TaskLogsFields(
    session: "api.BaseSession",
    *,
    taskId: str,
    follow: "typing.Optional[bool]" = None,
) -> "typing.Iterable[v1TaskLogsFieldsResponse]":
    """Stream task log fields.

    - taskId: The ID of the task.
    - follow: Continue following fields until the task stops.
    """
    _params = {
        "follow": str(follow).lower() if follow is not None else None,
    }
    if type(taskId) == str:
        taskId = parse.quote(taskId)
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/tasks/{taskId}/logs/fields",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=True,
    )
    if _resp.status_code == 200:
        try:
            for _line in _resp.iter_lines(chunk_size=1024 * 1024):
                _j = json.loads(_line)
                if "error" in _j:
                    raise APIHttpStreamError(
                        "get_TaskLogsFields",
                        runtimeStreamError.from_json(_j["error"])
                )
                yield v1TaskLogsFieldsResponse.from_json(_j["result"])
        except requests.exceptions.ChunkedEncodingError:
            raise APIHttpStreamError("get_TaskLogsFields", runtimeStreamError(message="ChunkedEncodingError"))
        return
    raise APIHttpError("get_TaskLogsFields", _resp)

def post_TestWebhook(
    session: "api.BaseSession",
    *,
    id: int,
) -> "v1TestWebhookResponse":
    """Test a webhook.

    - id: The id of the webhook.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/webhooks/{id}/test",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1TestWebhookResponse.from_json(_resp.json())
    raise APIHttpError("post_TestWebhook", _resp)

def get_TrialLogs(
    session: "api.BaseSession",
    *,
    trialId: int,
    agentIds: "typing.Optional[typing.Sequence[str]]" = None,
    containerIds: "typing.Optional[typing.Sequence[str]]" = None,
    enableRegex: "typing.Optional[bool]" = None,
    follow: "typing.Optional[bool]" = None,
    levels: "typing.Optional[typing.Sequence[v1LogLevel]]" = None,
    limit: "typing.Optional[int]" = None,
    orderBy: "typing.Optional[v1OrderBy]" = None,
    rankIds: "typing.Optional[typing.Sequence[int]]" = None,
    searchText: "typing.Optional[str]" = None,
    sources: "typing.Optional[typing.Sequence[str]]" = None,
    stdtypes: "typing.Optional[typing.Sequence[str]]" = None,
    timestampAfter: "typing.Optional[str]" = None,
    timestampBefore: "typing.Optional[str]" = None,
) -> "typing.Iterable[v1TrialLogsResponse]":
    """Stream trial logs.

    - trialId: The id of the trial.
    - agentIds: Limit the trial logs to a subset of agents.
    - containerIds: Limit the trial logs to a subset of containers.
    - enableRegex: Search text is regex. Default to false.
    - follow: Continue following logs until the trial stops.
    - levels: Limit the trial logs to a subset of agents.

 - LOG_LEVEL_UNSPECIFIED: Unspecified log level.
 - LOG_LEVEL_TRACE: A log level of TRACE.
 - LOG_LEVEL_DEBUG: A log level of DEBUG.
 - LOG_LEVEL_INFO: A log level of INFO.
 - LOG_LEVEL_WARNING: A log level of WARNING.
 - LOG_LEVEL_ERROR: A log level of ERROR.
 - LOG_LEVEL_CRITICAL: A log level of CRITICAL.
    - limit: Limit the number of trial logs. A value of 0 denotes no limit.
    - orderBy: Order logs in either ascending or descending order by timestamp.

 - ORDER_BY_UNSPECIFIED: Returns records in no specific order.
 - ORDER_BY_ASC: Returns records in ascending order.
 - ORDER_BY_DESC: Returns records in descending order.
    - rankIds: Limit the trial logs to a subset of ranks.
    - searchText: Search the logs by whether the text contains a substring.
    - sources: Limit the trial logs to a subset of sources.
    - stdtypes: Limit the trial logs to a subset of output streams.
    - timestampAfter: Limit the trial logs to ones with a timestamp after a given time.
    - timestampBefore: Limit the trial logs to ones with a timestamp before a given time.
    """
    _params = {
        "agentIds": agentIds,
        "containerIds": containerIds,
        "enableRegex": str(enableRegex).lower() if enableRegex is not None else None,
        "follow": str(follow).lower() if follow is not None else None,
        "levels": [x.value for x in levels] if levels is not None else None,
        "limit": limit,
        "orderBy": orderBy.value if orderBy is not None else None,
        "rankIds": rankIds,
        "searchText": searchText,
        "sources": sources,
        "stdtypes": stdtypes,
        "timestampAfter": timestampAfter,
        "timestampBefore": timestampBefore,
    }
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/trials/{trialId}/logs",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=True,
    )
    if _resp.status_code == 200:
        try:
            for _line in _resp.iter_lines(chunk_size=1024 * 1024):
                _j = json.loads(_line)
                if "error" in _j:
                    raise APIHttpStreamError(
                        "get_TrialLogs",
                        runtimeStreamError.from_json(_j["error"])
                )
                yield v1TrialLogsResponse.from_json(_j["result"])
        except requests.exceptions.ChunkedEncodingError:
            raise APIHttpStreamError("get_TrialLogs", runtimeStreamError(message="ChunkedEncodingError"))
        return
    raise APIHttpError("get_TrialLogs", _resp)

def get_TrialLogsFields(
    session: "api.BaseSession",
    *,
    trialId: int,
    follow: "typing.Optional[bool]" = None,
) -> "typing.Iterable[v1TrialLogsFieldsResponse]":
    """Stream trial log fields.

    - trialId: The ID of the trial.
    - follow: Continue following fields until the trial stops.
    """
    _params = {
        "follow": str(follow).lower() if follow is not None else None,
    }
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/trials/{trialId}/logs/fields",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=True,
    )
    if _resp.status_code == 200:
        try:
            for _line in _resp.iter_lines(chunk_size=1024 * 1024):
                _j = json.loads(_line)
                if "error" in _j:
                    raise APIHttpStreamError(
                        "get_TrialLogsFields",
                        runtimeStreamError.from_json(_j["error"])
                )
                yield v1TrialLogsFieldsResponse.from_json(_j["result"])
        except requests.exceptions.ChunkedEncodingError:
            raise APIHttpStreamError("get_TrialLogsFields", runtimeStreamError(message="ChunkedEncodingError"))
        return
    raise APIHttpError("get_TrialLogsFields", _resp)

def get_TrialsSample(
    session: "api.BaseSession",
    *,
    experimentId: int,
    metricName: str,
    endBatches: "typing.Optional[int]" = None,
    group: "typing.Optional[str]" = None,
    maxDatapoints: "typing.Optional[int]" = None,
    maxTrials: "typing.Optional[int]" = None,
    metricType: "typing.Optional[v1MetricType]" = None,
    periodSeconds: "typing.Optional[int]" = None,
    startBatches: "typing.Optional[int]" = None,
) -> "typing.Iterable[v1TrialsSampleResponse]":
    """Get a sample of the metrics over time for a sample of the trials.

    - experimentId: The id of the experiment.
    - metricName: A metric name.
    - endBatches: Ending of window (inclusive) to fetch data for.
    - group: Metric group (training, validation, etc).
    - maxDatapoints: Maximum number of initial / historical data points.
    - maxTrials: Maximum number of trials to fetch data for.
    - metricType: The type of metric.

 - METRIC_TYPE_UNSPECIFIED: Zero-value (not allowed).
 - METRIC_TYPE_TRAINING: For metrics emitted during training.
 - METRIC_TYPE_VALIDATION: For metrics emitted during validation.
 - METRIC_TYPE_PROFILING: For metrics emitted during profiling.
    - periodSeconds: Seconds to wait when polling for updates.
    - startBatches: Beginning of window (inclusive) to fetch data for.
    """
    _params = {
        "endBatches": endBatches,
        "group": group,
        "maxDatapoints": maxDatapoints,
        "maxTrials": maxTrials,
        "metricName": metricName,
        "metricType": metricType.value if metricType is not None else None,
        "periodSeconds": periodSeconds,
        "startBatches": startBatches,
    }
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/experiments/{experimentId}/metrics-stream/trials-sample",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=True,
    )
    if _resp.status_code == 200:
        try:
            for _line in _resp.iter_lines(chunk_size=1024 * 1024):
                _j = json.loads(_line)
                if "error" in _j:
                    raise APIHttpStreamError(
                        "get_TrialsSample",
                        runtimeStreamError.from_json(_j["error"])
                )
                yield v1TrialsSampleResponse.from_json(_j["result"])
        except requests.exceptions.ChunkedEncodingError:
            raise APIHttpStreamError("get_TrialsSample", runtimeStreamError(message="ChunkedEncodingError"))
        return
    raise APIHttpError("get_TrialsSample", _resp)

def get_TrialsSnapshot(
    session: "api.BaseSession",
    *,
    batchesProcessed: int,
    experimentId: int,
    metricName: str,
    batchesMargin: "typing.Optional[int]" = None,
    group: "typing.Optional[str]" = None,
    metricType: "typing.Optional[v1MetricType]" = None,
    periodSeconds: "typing.Optional[int]" = None,
) -> "typing.Iterable[v1TrialsSnapshotResponse]":
    """Get a snapshot of a metric across all trials at a certain point of
    progress.

    - batchesProcessed: The point of progress at which to query metrics.
    - experimentId: The id of the experiment.
    - metricName: A metric name.
    - batchesMargin: A range either side of batches_processed to include near-misses.
    - group: Metric group (training, validation, etc).
    - metricType: The type of metric.

 - METRIC_TYPE_UNSPECIFIED: Zero-value (not allowed).
 - METRIC_TYPE_TRAINING: For metrics emitted during training.
 - METRIC_TYPE_VALIDATION: For metrics emitted during validation.
 - METRIC_TYPE_PROFILING: For metrics emitted during profiling.
    - periodSeconds: Seconds to wait when polling for updates.
    """
    _params = {
        "batchesMargin": batchesMargin,
        "batchesProcessed": batchesProcessed,
        "group": group,
        "metricName": metricName,
        "metricType": metricType.value if metricType is not None else None,
        "periodSeconds": periodSeconds,
    }
    _resp = session._do_request(
        method="GET",
        path=f"/api/v1/experiments/{experimentId}/metrics-stream/trials-snapshot",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=True,
    )
    if _resp.status_code == 200:
        try:
            for _line in _resp.iter_lines(chunk_size=1024 * 1024):
                _j = json.loads(_line)
                if "error" in _j:
                    raise APIHttpStreamError(
                        "get_TrialsSnapshot",
                        runtimeStreamError.from_json(_j["error"])
                )
                yield v1TrialsSnapshotResponse.from_json(_j["result"])
        except requests.exceptions.ChunkedEncodingError:
            raise APIHttpStreamError("get_TrialsSnapshot", runtimeStreamError(message="ChunkedEncodingError"))
        return
    raise APIHttpError("get_TrialsSnapshot", _resp)

def post_UnarchiveExperiment(
    session: "api.BaseSession",
    *,
    id: int,
) -> None:
    """Unarchive an experiment.

    - id: The experiment id.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/experiments/{id}/unarchive",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_UnarchiveExperiment", _resp)

def post_UnarchiveExperiments(
    session: "api.BaseSession",
    *,
    body: "v1UnarchiveExperimentsRequest",
    projectId: int,
) -> "v1UnarchiveExperimentsResponse":
    """Unarchive multiple experiments.

    - projectId: Project id that the experiments belong to.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/projects/{projectId}/experiments/unarchive",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1UnarchiveExperimentsResponse.from_json(_resp.json())
    raise APIHttpError("post_UnarchiveExperiments", _resp)

def post_UnarchiveModel(
    session: "api.BaseSession",
    *,
    modelName: str,
) -> None:
    """Unarchive a model

    - modelName: The name of the model to un-archive.
    """
    _params = None
    if type(modelName) == str:
        modelName = parse.quote(modelName)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/models/{modelName}/unarchive",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_UnarchiveModel", _resp)

def post_UnarchiveProject(
    session: "api.BaseSession",
    *,
    id: int,
) -> None:
    """Unarchive a project.

    - id: The id of the project.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/projects/{id}/unarchive",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_UnarchiveProject", _resp)

def post_UnarchiveRuns(
    session: "api.BaseSession",
    *,
    body: "v1UnarchiveRunsRequest",
) -> "v1UnarchiveRunsResponse":
    """Unarchive runs."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/runs/unarchive",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1UnarchiveRunsResponse.from_json(_resp.json())
    raise APIHttpError("post_UnarchiveRuns", _resp)

def post_UnarchiveWorkspace(
    session: "api.BaseSession",
    *,
    id: int,
) -> None:
    """Unarchive a workspace.

    - id: The id of the workspace.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/workspaces/{id}/unarchive",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_UnarchiveWorkspace", _resp)

def delete_UnbindRPFromWorkspace(
    session: "api.BaseSession",
    *,
    body: "v1UnbindRPFromWorkspaceRequest",
    resourcePoolName: str,
) -> None:
    """Unbind resource pool to workspace

    - resourcePoolName: The resource pool name.
    """
    _params = None
    if type(resourcePoolName) == str:
        resourcePoolName = parse.quote(resourcePoolName)
    _resp = session._do_request(
        method="DELETE",
        path=f"/api/v1/resource-pools/{resourcePoolName}/workspace-bindings",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("delete_UnbindRPFromWorkspace", _resp)

def post_UnpauseGenericTask(
    session: "api.BaseSession",
    *,
    taskId: str,
) -> None:
    """Unpause generic task

    - taskId: The id of the task.
    """
    _params = None
    if type(taskId) == str:
        taskId = parse.quote(taskId)
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/tasks/{taskId}/unpause",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_UnpauseGenericTask", _resp)

def post_UnpinWorkspace(
    session: "api.BaseSession",
    *,
    id: int,
) -> None:
    """Unpin a workspace.

    - id: The id of the workspace.
    """
    _params = None
    _resp = session._do_request(
        method="POST",
        path=f"/api/v1/workspaces/{id}/unpin",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_UnpinWorkspace", _resp)

def put_UpdateGroup(
    session: "api.BaseSession",
    *,
    body: "v1UpdateGroupRequest",
    groupId: int,
) -> "v1UpdateGroupResponse":
    """Update group info.

    - groupId: The id of the group
    """
    _params = None
    _resp = session._do_request(
        method="PUT",
        path=f"/api/v1/groups/{groupId}",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return v1UpdateGroupResponse.from_json(_resp.json())
    raise APIHttpError("put_UpdateGroup", _resp)

def post_UpdateJobQueue(
    session: "api.BaseSession",
    *,
    body: "v1UpdateJobQueueRequest",
) -> None:
    """Control the job queues."""
    _params = None
    _resp = session._do_request(
        method="POST",
        path="/api/v1/job-queues",
        params=_params,
        json=body.to_json(True),
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return
    raise APIHttpError("post_UpdateJobQueue", _resp)

def get_health(
    session: "api.BaseSession",
) -> "HealthCheck":
    """Get health of Determined and the dependencies."""
    _params = None
    _resp = session._do_request(
        method="GET",
        path="/health",
        params=_params,
        json=None,
        data=None,
        headers=None,
        timeout=None,
        stream=False,
    )
    if _resp.status_code == 200:
        return HealthCheck.from_json(_resp.json())
    if _resp.status_code == 503:
        return HealthCheck.from_json(_resp.json())
    raise APIHttpError("get_health", _resp)

# Paginated is a union type of objects whose .pagination
# attribute is a v1Pagination-type object.
Paginated = typing.Union[
    v1GetAccessTokensResponse,
    v1GetAgentsResponse,
    v1GetCommandsResponse,
    v1GetExperimentCheckpointsResponse,
    v1GetExperimentTrialsResponse,
    v1GetExperimentsResponse,
    v1GetGroupsResponse,
    v1GetJobsResponse,
    v1GetJobsV2Response,
    v1GetModelVersionsResponse,
    v1GetModelsResponse,
    v1GetNotebooksResponse,
    v1GetResourcePoolsResponse,
    v1GetShellsResponse,
    v1GetTemplatesResponse,
    v1GetTensorboardsResponse,
    v1GetTrialCheckpointsResponse,
    v1GetTrialWorkloadsResponse,
    v1GetUsersResponse,
    v1GetWorkspaceProjectsResponse,
    v1GetWorkspacesResponse,
    v1ListRPsBoundToWorkspaceResponse,
    v1ListRolesResponse,
    v1ListWorkspacesBoundToRPResponse,
    v1SearchExperimentsResponse,
    v1SearchRolesAssignableToScopeResponse,
    v1SearchRunsResponse,
]
