from importlib import metadata

from determined._experiment_config import ExperimentConfig
from determined._info import RendezvousInfo, TrialInfo, ResourcesInfo, ClusterInfo, get_cluster_info
from determined._import import import_from_path
from determined import core
from determined._env_context import EnvContext
from determined._trial_context import TrialContext
from determined._trial import LegacyTrial
from determined._trial_controller import (
    _DistributedBackend,
    TrialController,
)
from determined._execution import (
    _catch_sys_exit,
    _make_test_experiment_config,
    _make_local_execution_env,
    _get_gpus,
    _make_local_execution_exp_config,
    _local_execution_manager,
    _load_trial_for_checkpoint_export,
    InvalidHP,
)
from determined import errors
from determined import util

try:
    # Attempt to get the version from the package metadata. This should
    # exist if using a built distribution (i.e. for most users), which
    # includes pip editable installations.
    __version__ = metadata.version(__name__)
except metadata.PackageNotFoundError:
    __version__ = "2!0.0.0+unknown"

# LOG_FORMAT is the standard format for use with the logging module, which is required for the
# WebUI's log viewer to filter logs by log level.
#
# Dev note: if this format is changed, the ship_logs.py log parsing must be updated as well.
LOG_FORMAT = "%(levelname)s: [%(process)s] %(name)s: %(message)s"
