/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.sample.extensions.processors;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.api.FileProcessListener;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.RuleSet;
import io.gitlab.arturbosch.detekt.api.SetupContext;
import io.gitlab.arturbosch.detekt.sample.extensions.processors.QualifiedNameProcessorKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lio/gitlab/arturbosch/detekt/sample/extensions/processors/QualifiedNameProcessor;", "Lio/gitlab/arturbosch/detekt/api/FileProcessListener;", "()V", "id", "", "getId", "()Ljava/lang/String;", "onFinish", "", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "result", "Lio/gitlab/arturbosch/detekt/api/Detektion;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "onProcess", "file", "ClassNameVisitor", "detekt-sample-extensions"})
@SourceDebugExtension(value={"SMAP\nQualifiedNameProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QualifiedNameProcessor.kt\nio/gitlab/arturbosch/detekt/sample/extensions/processors/QualifiedNameProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,42:1\n1620#2,3:43\n1603#2,9:46\n1855#2:55\n1856#2:57\n1612#2:58\n1446#2,5:59\n1#3:56\n*S KotlinDebug\n*F\n+ 1 QualifiedNameProcessor.kt\nio/gitlab/arturbosch/detekt/sample/extensions/processors/QualifiedNameProcessor\n*L\n20#1:43,3\n26#1:46,9\n26#1:55\n26#1:57\n26#1:58\n27#1:59,5\n26#1:56\n*E\n"})
public final class QualifiedNameProcessor
implements FileProcessListener {
    @NotNull
    private final String id;

    public QualifiedNameProcessor() {
        this.id = "QualifiedNameProcessor";
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    /*
     * WARNING - void declaration
     */
    public void onProcess(@NotNull KtFile file, @NotNull BindingContext bindingContext) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        String string = file.getPackageFqName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String packageName = string;
        ClassNameVisitor nameVisitor = new ClassNameVisitor();
        file.accept((PsiElementVisitor)nameVisitor);
        Iterable iterable = nameVisitor.getNames();
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            String string2 = (String)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(packageName + '.' + (String)it);
        }
        HashSet fqNames = (HashSet)destination$iv;
        file.putUserData(QualifiedNameProcessorKt.getFqNamesKey(), (Object)fqNames);
    }

    /*
     * WARNING - void declaration
     */
    public void onFinish(@NotNull List<? extends KtFile> files, @NotNull Detektion result, @NotNull BindingContext bindingContext) {
        void $this$flatMapTo$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Iterable iterable = files;
        boolean $i$f$mapNotNull = false;
        void var7_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Set it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KtFile it = (KtFile)element$iv$iv;
            boolean bl2 = false;
            if ((Set)it.getUserData(QualifiedNameProcessorKt.getFqNamesKey()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Set it = (Set)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Iterable list$iv = it;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        HashSet fqNames = (HashSet)destination$iv;
        result.putUserData(QualifiedNameProcessorKt.getFqNamesKey(), (Object)fqNames);
    }

    public int getPriority() {
        return FileProcessListener.DefaultImpls.getPriority((FileProcessListener)this);
    }

    public void init(@NotNull Config config) {
        FileProcessListener.DefaultImpls.init((FileProcessListener)this, (Config)config);
    }

    public void init(@NotNull SetupContext context) {
        FileProcessListener.DefaultImpls.init((FileProcessListener)this, (SetupContext)context);
    }

    public void onProcessComplete(@NotNull KtFile file, @NotNull Map<RuleSet.Id, ? extends List<? extends Finding>> findings, @NotNull BindingContext bindingContext) {
        FileProcessListener.DefaultImpls.onProcessComplete((FileProcessListener)this, (KtFile)file, findings, (BindingContext)bindingContext);
    }

    public void onStart(@NotNull List<? extends KtFile> files, @NotNull BindingContext bindingContext) {
        FileProcessListener.DefaultImpls.onStart((FileProcessListener)this, files, (BindingContext)bindingContext);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lio/gitlab/arturbosch/detekt/sample/extensions/processors/QualifiedNameProcessor$ClassNameVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "()V", "names", "", "", "getNames", "()Ljava/util/Set;", "visitClassOrObject", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "detekt-sample-extensions"})
    public static final class ClassNameVisitor
    extends DetektVisitor {
        @NotNull
        private final Set<String> names = new LinkedHashSet();

        @NotNull
        public final Set<String> getNames() {
            return this.names;
        }

        public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
            Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
            String string = classOrObject.getNameAsSafeName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            this.names.add(string);
        }
    }
}

