/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.sample.extensions.processors;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.api.FileProcessListener;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.RuleSet;
import io.gitlab.arturbosch.detekt.api.SetupContext;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lio/gitlab/arturbosch/detekt/sample/extensions/processors/NumberOfLoopsProcessor;", "Lio/gitlab/arturbosch/detekt/api/FileProcessListener;", "()V", "id", "", "getId", "()Ljava/lang/String;", "onProcess", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "Companion", "LoopVisitor", "detekt-sample-extensions"})
public final class NumberOfLoopsProcessor
implements FileProcessListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private static final Key<Integer> numberOfLoopsKey = new Key("number of loops");

    public NumberOfLoopsProcessor() {
        this.id = "NumberOfLoopsProcessor";
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public void onProcess(@NotNull KtFile file, @NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        LoopVisitor visitor = new LoopVisitor();
        file.accept((PsiElementVisitor)visitor);
        file.putUserData(numberOfLoopsKey, (Object)visitor.getNumberOfLoops$detekt_sample_extensions());
    }

    public int getPriority() {
        return FileProcessListener.DefaultImpls.getPriority((FileProcessListener)this);
    }

    public void init(@NotNull Config config) {
        FileProcessListener.DefaultImpls.init((FileProcessListener)this, (Config)config);
    }

    public void init(@NotNull SetupContext context) {
        FileProcessListener.DefaultImpls.init((FileProcessListener)this, (SetupContext)context);
    }

    public void onFinish(@NotNull List<? extends KtFile> files, @NotNull Detektion result, @NotNull BindingContext bindingContext) {
        FileProcessListener.DefaultImpls.onFinish((FileProcessListener)this, files, (Detektion)result, (BindingContext)bindingContext);
    }

    public void onProcessComplete(@NotNull KtFile file, @NotNull Map<RuleSet.Id, ? extends List<? extends Finding>> findings, @NotNull BindingContext bindingContext) {
        FileProcessListener.DefaultImpls.onProcessComplete((FileProcessListener)this, (KtFile)file, findings, (BindingContext)bindingContext);
    }

    public void onStart(@NotNull List<? extends KtFile> files, @NotNull BindingContext bindingContext) {
        FileProcessListener.DefaultImpls.onStart((FileProcessListener)this, files, (BindingContext)bindingContext);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/gitlab/arturbosch/detekt/sample/extensions/processors/NumberOfLoopsProcessor$Companion;", "", "()V", "numberOfLoopsKey", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/Key;", "", "getNumberOfLoopsKey", "()Lorg/jetbrains/kotlin/com/intellij/openapi/util/Key;", "detekt-sample-extensions"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Integer> getNumberOfLoopsKey() {
            return numberOfLoopsKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lio/gitlab/arturbosch/detekt/sample/extensions/processors/NumberOfLoopsProcessor$LoopVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "()V", "numberOfLoops", "", "getNumberOfLoops$detekt_sample_extensions", "()I", "setNumberOfLoops$detekt_sample_extensions", "(I)V", "visitLoopExpression", "", "loopExpression", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "detekt-sample-extensions"})
    public static final class LoopVisitor
    extends DetektVisitor {
        private int numberOfLoops;

        public final int getNumberOfLoops$detekt_sample_extensions() {
            return this.numberOfLoops;
        }

        public final void setNumberOfLoops$detekt_sample_extensions(int n) {
            this.numberOfLoops = n;
        }

        public void visitLoopExpression(@NotNull KtLoopExpression loopExpression) {
            Intrinsics.checkNotNullParameter((Object)loopExpression, (String)"loopExpression");
            super.visitLoopExpression(loopExpression);
            int n = this.numberOfLoops;
            this.numberOfLoops = n + 1;
        }
    }
}

