{
 * This Source Code Form is subject to the terms of the Mozilla Public License,
 * v. 2.0. If a copy of the MPL was not distributed with this file, You can
 * obtain one at https://mozilla.org/MPL/2.0/
 *
 * Copyright (C) 2005-2024, Peter Johnson (gravatar.com/delphidabbler).
 *
 * CodeSnip application project file.
}


program CodeSnip;

{$Include CompilerChecks.inc}

{$ALIGN 8}
{$APPTYPE GUI}
{$BOOLEVAL ON}
{$DESCRIPTION 'Code Snippets Database Manager and Viewer'}
{$EXTENDEDSYNTAX ON}
{$HINTS ON}
{$IOCHECKS ON}
{$LONGSTRINGS ON}
{$MINSTACKSIZE $00004000}
{$MAXSTACKSIZE $00100000}
{$OVERFLOWCHECKS OFF}
{$RANGECHECKS OFF}
{$TYPEDADDRESS OFF}
{$WARNINGS ON}
{$WRITEABLECONST OFF}


uses
  Forms,
  Windows,
  LVEx in '3rdParty\LVEx.pas',
  PJMD5 in '3rdParty\PJMD5.pas',
  PJShellFolders in '3rdParty\PJShellFolders.pas',
  PJStreamWrapper in '3rdParty\PJStreamWrapper.pas',
  PJSysInfo in '3rdParty\PJSysInfo.pas',
  PJVersionInfo in '3rdParty\PJVersionInfo.pas',
  PJWdwState in '3rdParty\PJWdwState.pas',
  IntfExternalObj in 'AutoGen\IntfExternalObj.pas',
  ActiveText.UHTMLRenderer in 'ActiveText.UHTMLRenderer.pas',
  ActiveText.UMain in 'ActiveText.UMain.pas',
  ActiveText.URTFRenderer in 'ActiveText.URTFRenderer.pas',
  ActiveText.UTextRenderer in 'ActiveText.UTextRenderer.pas',
  ActiveText.UValidator in 'ActiveText.UValidator.pas',
  Browser.IntfDocHostUI in 'Browser.IntfDocHostUI.pas',
  Browser.UControlHelper in 'Browser.UControlHelper.pas',
  Browser.UController in 'Browser.UController.pas',
  Browser.UHighlighter in 'Browser.UHighlighter.pas',
  Browser.UHTMLEvents in 'Browser.UHTMLEvents.pas',
  Browser.UIOMgr in 'Browser.UIOMgr.pas',
  Browser.UNulUIHandler in 'Browser.UNulUIHandler.pas',
  Browser.UUIMgr in 'Browser.UUIMgr.pas',
  Compilers.UBDS in 'Compilers.UBDS.pas',
  Compilers.UBorland in 'Compilers.UBorland.pas',
  Compilers.UCompilerBase in 'Compilers.UCompilerBase.pas',
  Compilers.UCompilers in 'Compilers.UCompilers.pas',
  Compilers.UDelphi in 'Compilers.UDelphi.pas',
  Compilers.UFreePascal in 'Compilers.UFreePascal.pas',
  Compilers.UGlobals in 'Compilers.UGlobals.pas',
  Compilers.URunner in 'Compilers.URunner.pas',
  Compilers.USearchDirs in 'Compilers.USearchDirs.pas',
  DB.UCategory in 'DB.UCategory.pas',
  DB.UDatabaseIO in 'DB.UDatabaseIO.pas',
  DB.UMain in 'DB.UMain.pas',
  DB.UMetaData in 'DB.UMetaData.pas',
  DB.USnippet in 'DB.USnippet.pas',
  DB.USnippetKind in 'DB.USnippetKind.pas',
  DBIO.UFileIOIntf in 'DBIO.UFileIOIntf.pas',
  DBIO.UIniDataReader in 'DBIO.UIniDataReader.pas',
  DBIO.UNulDataReader in 'DBIO.UNulDataReader.pas',
  DBIO.UXMLDataIO in 'DBIO.UXMLDataIO.pas',
  Favourites.UManager in 'Favourites.UManager.pas',
  Favourites.UFavourites in 'Favourites.UFavourites.pas',
  Favourites.UPersist in 'Favourites.UPersist.pas',
  FirstRun.FmV4ConfigDlg in 'FirstRun.FmV4ConfigDlg.pas' {V4ConfigDlg},
  FirstRun.FmWhatsNew in 'FirstRun.FmWhatsNew.pas' {WhatsNewDlg},
  FirstRun.FmWhatsNew.FrHTML in 'FirstRun.FmWhatsNew.FrHTML.pas' {WhatsNewHTMLFrame: TFrame},
  FirstRun.UConfigFile in 'FirstRun.UConfigFile.pas',
  FirstRun.UDatabase in 'FirstRun.UDatabase.pas',
  FirstRun.UIniFile in 'FirstRun.UIniFile.pas',
  FirstRun.UInstallInfo in 'FirstRun.UInstallInfo.pas',
  FirstRun.UMain in 'FirstRun.UMain.pas',
  FmAboutDlg in 'FmAboutDlg.pas' {AboutDlg},
  FmActiveTextPreviewDlg in 'FmActiveTextPreviewDlg.pas' {ActiveTextPreviewDlg},
  FmAddCategoryDlg in 'FmAddCategoryDlg.pas' {AddCategoryDlg},
  FmBase in 'FmBase.pas' {BaseForm},
  FmBugReportBaseDlg in 'FmBugReportBaseDlg.pas' {BugReportBaseDlg},
  FmCategoryEditDlg in 'FmCategoryEditDlg.pas' {CategoryEditDlg},
  FmCodeExportDlg in 'FmCodeExportDlg.pas' {CodeExportDlg},
  FmCodeImportDlg in 'FmCodeImportDlg.pas' {CodeImportDlg},
  FmCompErrorDlg in 'FmCompErrorDlg.pas' {CompErrorDlg},
  FmCompilersDlg in 'FmCompilersDlg.pas' {CompilersDlg},
  FmCompilersDlg.FrBase in 'FmCompilersDlg.FrBase.pas' {CompilersDlgBaseFrame: TFrame},
  FmCompilersDlg.FrCompiler in 'FmCompilersDlg.FrCompiler.pas' {CompilersDlgCompilerFrame: TFrame},
  FmCompilersDlg.FrLog in 'FmCompilersDlg.FrLog.pas' {CompilersDlgLogFrame: TFrame},
  FmCompilersDlg.FrNamespaces in 'FmCompilersDlg.FrNamespaces.pas' {CompilersDlgNamespacesFrame: TFrame},
  FmCompilersDlg.FrSearchDirs in 'FmCompilersDlg.FrSearchDirs.pas' {CompilersDlgSearchDirsFrame: TFrame},
  FmCompilersDlg.FrSwitches in 'FmCompilersDlg.FrSwitches.pas' {CompilersDlgSwitchesFrame: TFrame},
  FmCompilersDlg.UBannerMgr in 'FmCompilersDlg.UBannerMgr.pas',
  FmCompilersDlg.UCompilerListMgr in 'FmCompilersDlg.UCompilerListMgr.pas',
  FmDBUpdateDlg in 'FmDBUpdateDlg.pas' {DBUpdateDlg},
  FmDeleteCategoryDlg in 'FmDeleteCategoryDlg.pas' {DeleteCategoryDlg},
  FmDependenciesDlg in 'FmDependenciesDlg.pas' {DependenciesDlg},
  FmDuplicateSnippetDlg in 'FmDuplicateSnippetDlg.pas' {DuplicateSnippetDlg},
  FmEasterEgg in 'FmEasterEgg.pas' {EasterEggForm},
  FmFavouritesDlg in 'FmFavouritesDlg.pas' {FavouritesDlg},
  FmFindCompilerDlg in 'FmFindCompilerDlg.pas' {FindCompilerDlg},
  FmFindTextDlg in 'FmFindTextDlg.pas' {FindTextDlg},
  FmFindXRefsDlg in 'FmFindXRefsDlg.pas' {FindXRefsDlg},
  FmGenericDlg in 'FmGenericDlg.pas' {GenericDlg},
  FmGenericModalDlg in 'FmGenericModalDlg.pas' {GenericModalDlg},
  FmGenericNonModalDlg in 'FmGenericNonModalDlg.pas' {GenericNonModalDlg},
  FmGenericOKDlg in 'FmGenericOKDlg.pas' {GenericOKDlg},
  FmGenericViewDlg in 'FmGenericViewDlg.pas' {GenericViewDlg},
  FmHelpAware in 'FmHelpAware.pas' {HelpAwareForm},
  FmMain in 'FmMain.pas' {MainForm},
  FmNewHiliterNameDlg in 'FmNewHiliterNameDlg.pas' {NewHiliterNameDlg},
  FmPreferencesDlg in 'FmPreferencesDlg.pas' {PreferencesDlg},
  FmPreviewDlg in 'FmPreviewDlg.pas' {PreviewDlg},
  FmPrintDlg in 'FmPrintDlg.pas' {PrintDlg},
  FmRenameCategoryDlg in 'FmRenameCategoryDlg.pas' {RenameCategoryDlg},
  FmSelectionSearchDlg in 'FmSelectionSearchDlg.pas' {SelectionSearchDlg},
  FmSnippetsEditorDlg in 'FmSnippetsEditorDlg.pas' {SnippetsEditorDlg},
  FmSnippetsEditorDlg.FrActiveTextEditor in 'FmSnippetsEditorDlg.FrActiveTextEditor.pas' {SnippetsActiveTextEdFrame: TFrame},
  FmSplash in 'FmSplash.pas' {SplashForm},
  FmSWAGImportDlg in 'FmSWAGImportDlg.pas' {SWAGImportDlg},
  FmTestCompileDlg in 'FmTestCompileDlg.pas' {TestCompileDlg},
  FmTrappedBugReportDlg in 'FmTrappedBugReportDlg.pas' {TrappedBugReportDlg},
  FmUserBugReportDlg in 'FmUserBugReportDlg.pas' {UserBugReportDlg},
  FmUserDataPathDlg in 'FmUserDataPathDlg.pas' {UserDataPathDlg},
  FrProgress in 'FrProgress.pas' {ProgressFrame: TFrame},
  FmUserHiliterMgrDlg in 'FmUserHiliterMgrDlg.pas' {UserHiliterMgrDlg},
  FmWaitDlg in 'FmWaitDlg.pas' {WaitDlg},
  FmWizardDlg in 'FmWizardDlg.pas' {WizardDlg},
  FrBrowserBase in 'FrBrowserBase.pas' {BrowserBaseFrame: TFrame},
  FrCategoryDescEdit in 'FrCategoryDescEdit.pas' {CategoryDescEditFrame: TFrame},
  FrCategoryList in 'FrCategoryList.pas' {CategoryListFrame: TFrame},
  FrCodeGenPrefs in 'FrCodeGenPrefs.pas' {CodeGenPrefsFrame: TFrame},
  FrDetail in 'FrDetail.pas' {DetailFrame: TFrame},
  FrDetailView in 'FrDetailView.pas' {DetailViewFrame: TFrame},
  FrDisplayPrefs in 'FrDisplayPrefs.pas' {DisplayPrefsFrame: TFrame},
  FrEasterEgg in 'FrEasterEgg.pas' {EasterEggFrame: TFrame},
  FrFixedHTMLDlg in 'FrFixedHTMLDlg.pas' {FixedHTMLDlgFrame: TFrame},
  FrGeneralPrefs in 'FrGeneralPrefs.pas' {GeneralPrefsFrame: TFrame},
  FrHiliterPrefs in 'FrHiliterPrefs.pas' {HiliterPrefsFrame: TFrame},
  FrHTMLDlg in 'FrHTMLDlg.pas' {HTMLDlgFrame: TFrame},
  FrHTMLPreview in 'FrHTMLPreview.pas' {HTMLPreviewFrame: TFrame},
  FrHTMLTpltDlg in 'FrHTMLTpltDlg.pas' {HTMLTpltDlgFrame: TFrame},
  FrMemoPreview in 'FrMemoPreview.pas' {MemoPreviewFrame: TFrame},
  FrOverview in 'FrOverview.pas' {OverviewFrame: TFrame},
  FrPrefsBase in 'FrPrefsBase.pas' {PrefsBaseFrame: TFrame},
  FrPrintingPrefs in 'FrPrintingPrefs.pas' {PrintingPrefsFrame: TFrame},
  FrRTFPreview in 'FrRTFPreview.pas' {RTFPreviewFrame: TFrame},
  FrRTFShowCase in 'FrRTFShowCase.pas' {RTFShowCaseFrame: TFrame},
  FrCheckedTV in 'FrCheckedTV.pas' {CheckedTVFrame: TFrame},
  FrSelectSnippetsBase in 'FrSelectSnippetsBase.pas' {SelectSnippetsBaseFrame: TFrame},
  FrSelectSnippets in 'FrSelectSnippets.pas' {SelectSnippetsFrame: TFrame},
  FrSelectUserSnippets in 'FrSelectUserSnippets.pas' {SelectUserSnippetsFrame: TFrame},
  FrSnippetLayoutPrefs in 'FrSnippetLayoutPrefs.pas' {SnippetLayoutPrefsFrame: TFrame},
  FrSourcePrefs in 'FrSourcePrefs.pas' {SourcePrefsFrame: TFrame},
  FrTextPreview in 'FrTextPreview.pas' {TextPreviewFrame: TFrame},
  FrTitled in 'FrTitled.pas' {TitledFrame: TFrame},
  Hiliter.UAttrs in 'Hiliter.UAttrs.pas',
  Hiliter.UCSS in 'Hiliter.UCSS.pas',
  Hiliter.UFileHiliter in 'Hiliter.UFileHiliter.pas',
  Hiliter.UGlobals in 'Hiliter.UGlobals.pas',
  Hiliter.UHiliters in 'Hiliter.UHiliters.pas',
  Hiliter.UPasLexer in 'Hiliter.UPasLexer.pas',
  Hiliter.UPasParser in 'Hiliter.UPasParser.pas',
  Hiliter.UPersist in 'Hiliter.UPersist.pas',
  IntfAligner in 'IntfAligner.pas',
  IntfCommon in 'IntfCommon.pas',
  IntfFrameMgrs in 'IntfFrameMgrs.pas',
  IntfNotifier in 'IntfNotifier.pas',
  IntfPreview in 'IntfPreview.pas',
  SWAG.UCommon in 'SWAG.UCommon.pas',
  SWAG.UImporter in 'SWAG.UImporter.pas',
  SWAG.UReader in 'SWAG.UReader.pas',
  SWAG.UPacketCache in 'SWAG.UPacketCache.pas',
  SWAG.UVersion in 'SWAG.UVersion.pas',
  SWAG.UXMLProcessor in 'SWAG.UXMLProcessor.pas',
  UActionFactory in 'UActionFactory.pas',
  UAnchors in 'UAnchors.pas',
  UAppInfo in 'UAppInfo.pas',
  UBaseObjects in 'UBaseObjects.pas',
  UBox in 'UBox.pas',
  UBrowseForFolderDlg in 'UBrowseForFolderDlg.pas',
  UBrowseProtocol in 'UBrowseProtocol.pas',
  UCategoryAction in 'UCategoryAction.pas',
  UCategoryListAdapter in 'UCategoryListAdapter.pas',
  ClassHelpers.UControls in 'ClassHelpers.UControls.pas',
  UClipboardHelper in 'UClipboardHelper.pas',
  UCodeImportExport in 'UCodeImportExport.pas',
  UCodeImportMgr in 'UCodeImportMgr.pas',
  UCodeShareMgr in 'UCodeShareMgr.pas',
  UColorBoxEx in 'UColorBoxEx.pas',
  UColorDialogEx in 'UColorDialogEx.pas',
  UColours in 'UColours.pas',
  UCommandBars in 'UCommandBars.pas',
  UCommonDlg in 'UCommonDlg.pas',
  UComparers in 'UComparers.pas',
  UCompileMgr in 'UCompileMgr.pas',
  UCompileResultsLBMgr in 'UCompileResultsLBMgr.pas',
  UCompResHTML in 'UCompResHTML.pas',
  UConsoleApp in 'UConsoleApp.pas',
  UConsts in 'UConsts.pas',
  UContainers in 'UContainers.pas',
  UControlStateMgr in 'UControlStateMgr.pas',
  UCopyInfoMgr in 'UCopyInfoMgr.pas',
  UCopySourceMgr in 'UCopySourceMgr.pas',
  UCopyViewMgr in 'UCopyViewMgr.pas',
  UCSSBuilder in 'UCSSBuilder.pas',
  UCSSUtils in 'UCSSUtils.pas',
  UCtrlArranger in 'UCtrlArranger.pas',
  UDataBackupMgr in 'UDataBackupMgr.pas',
  UDatabaseLoader in 'UDatabaseLoader.pas',
  UDatabaseLoaderUI in 'UDatabaseLoaderUI.pas',
  UDataStreamIO in 'UDataStreamIO.pas',
  UDBUpdateMgr in 'UDBUpdateMgr.pas',
  UDetailPageHTML in 'UDetailPageHTML.pas',
  UDetailPageLoader in 'UDetailPageLoader.pas',
  UDetailTabAction in 'UDetailTabAction.pas',
  UDialogMgr in 'UDialogMgr.pas',
  UDirectoryCopier in 'UDirectoryCopier.pas',
  UDispatchList in 'UDispatchList.pas',
  UDlgHelper in 'UDlgHelper.pas',
  UDOSDateTime in 'UDOSDateTime.pas',
  UDropDownButtons in 'UDropDownButtons.pas',
  UEditSnippetAction in 'UEditSnippetAction.pas',
  UEmailHelper in 'UEmailHelper.pas',
  UEncodings in 'UEncodings.pas',
  UExceptions in 'UExceptions.pas',
  UExeFileType in 'UExeFileType.pas',
  UFileProtocol in 'UFileProtocol.pas',
  UFileUpdater in 'UFileUpdater.pas',
  UFolderBackup in 'UFolderBackup.pas',
  UFontHelper in 'UFontHelper.pas',
  UFormAligner in 'UFormAligner.pas',
  UGIFImageList in 'UGIFImageList.pas',
  UGraphicUtils in 'UGraphicUtils.pas',
  UGroups in 'UGroups.pas',
  UHelpMgr in 'UHelpMgr.pas',
  UHelpProtocol in 'UHelpProtocol.pas',
  UHexUtils in 'UHexUtils.pas',
  UHiddenRichEdit in 'UHiddenRichEdit.pas',
  UHiddenWindow in 'UHiddenWindow.pas',
  UHistory in 'UHistory.pas',
  UHistoryMenus in 'UHistoryMenus.pas',
  UHTMLBuilder in 'UHTMLBuilder.pas',
  UHTMLDOMHelper in 'UHTMLDOMHelper.pas',
  UHTMLHelp in 'UHTMLHelp.pas',
  UHTMLHelpMgr in 'UHTMLHelpMgr.pas',
  UHTMLTemplate in 'UHTMLTemplate.pas',
  UHTMLUtils in 'UHTMLUtils.pas',
  UHTTPProtocol in 'UHTTPProtocol.pas',
  UImageTags in 'UImageTags.pas',
  UIniDataLoader in 'UIniDataLoader.pas',
  UInitialLetter in 'UInitialLetter.pas',
  UIOUtils in 'UIOUtils.pas',
  UIStringList in 'UIStringList.pas',
  UJavaScriptUtils in 'UJavaScriptUtils.pas',
  UKeysHelper in 'UKeysHelper.pas',
  ULEDImageList in 'ULEDImageList.pas',
  ULinkAction in 'ULinkAction.pas',
  ULocales in 'ULocales.pas',
  UMainDBFileReader in 'UMainDBFileReader.pas',
  UMainDisplayMgr in 'UMainDisplayMgr.pas',
  UMarquee in 'UMarquee.pas',
  UMeasurement in 'UMeasurement.pas',
  UMemoCaretPosDisplayMgr in 'UMemoCaretPosDisplayMgr.pas',
  UMemoHelper in 'UMemoHelper.pas',
  UMemoProgBarMgr in 'UMemoProgBarMgr.pas',
  UMenus in 'UMenus.pas',
  UMessageBox in 'UMessageBox.pas',
  UMessageWindow in 'UMessageWindow.pas',
  UMultiCastEvents in 'UMultiCastEvents.pas',
  UNotifier in 'UNotifier.pas',
  UNulDropTarget in 'UNulDropTarget.pas',
  UNulFormAligner in 'UNulFormAligner.pas',
  UOleClientSite in 'UOleClientSite.pas',
  UOpenDialogHelper in 'UOpenDialogHelper.pas',
  UOpenDialogEx in 'UOpenDialogEx.pas',
  UOverviewTreeBuilder in 'UOverviewTreeBuilder.pas',
  UOverviewTreeState in 'UOverviewTreeState.pas',
  UPageSetupDialogEx in 'UPageSetupDialogEx.pas',
  UPageSetupDlgMgr in 'UPageSetupDlgMgr.pas',
  UPipe in 'UPipe.pas',
  UPreferences in 'UPreferences.pas',
  UPrintDocuments in 'UPrintDocuments.pas',
  UPrintEngine in 'UPrintEngine.pas',
  UPrintInfo in 'UPrintInfo.pas',
  UPrintMgr in 'UPrintMgr.pas',
  UProtocols in 'UProtocols.pas',
  UQuery in 'UQuery.pas',
  UREMLDataIO in 'UREMLDataIO.pas',
  UReservedCategories in 'UReservedCategories.pas',
  UResourceUtils in 'UResourceUtils.pas',
  URTFBuilder in 'URTFBuilder.pas',
  URTFCategoryDoc in 'URTFCategoryDoc.pas',
  URTFSnippetDoc in 'URTFSnippetDoc.pas',
  URTFStyles in 'URTFStyles.pas',
  URTFUtils in 'URTFUtils.pas',
  USaveDialogEx in 'USaveDialogEx.pas',
  USaveSnippetMgr in 'USaveSnippetMgr.pas',
  USaveSourceDlg in 'USaveSourceDlg.pas',
  USaveSourceMgr in 'USaveSourceMgr.pas',
  USaveUnitMgr in 'USaveUnitMgr.pas',
  USearch in 'USearch.pas',
  USelectionIOMgr in 'USelectionIOMgr.pas',
  USettings in 'USettings.pas',
  UShowCaseCtrl in 'UShowCaseCtrl.pas',
  USimpleDispatch in 'USimpleDispatch.pas',
  USingleton in 'USingleton.pas',
  USnipKindListAdapter in 'USnipKindListAdapter.pas',
  USnippetAction in 'USnippetAction.pas',
  USnippetDoc in 'USnippetDoc.pas',
  USnippetExtraHelper in 'USnippetExtraHelper.pas',
  USnippetHTML in 'USnippetHTML.pas',
  USnippetIDListIOHandler in 'USnippetIDListIOHandler.pas',
  USnippetIDs in 'USnippetIDs.pas',
  USnippetPageHTML in 'USnippetPageHTML.pas',
  USnippetPageStructure in 'USnippetPageStructure.pas',
  USnippetsChkListMgr in 'USnippetsChkListMgr.pas',
  USnippetSourceGen in 'USnippetSourceGen.pas',
  USnippetsTVDraw in 'USnippetsTVDraw.pas',
  USnippetValidator in 'USnippetValidator.pas',
  USourceFileInfo in 'USourceFileInfo.pas',
  USourceGen in 'USourceGen.pas',
  UStartUp in 'UStartUp.pas',
  UStatusBarMgr in 'UStatusBarMgr.pas',
  UStringReader in 'UStringReader.pas',
  UStructs in 'UStructs.pas',
  UStrUtils in 'UStrUtils.pas',
  USystemInfo in 'USystemInfo.pas',
  UTaggedTextLexer in 'UTaggedTextLexer.pas',
  UTestCompile in 'UTestCompile.pas',
  UTestCompileUI in 'UTestCompileUI.pas',
  UTestUnit in 'UTestUnit.pas',
  UTestUnitDlgMgr in 'UTestUnitDlgMgr.pas',
  UTextSnippetDoc in 'UTextSnippetDoc.pas',
  UThemesEx in 'UThemesEx.pas',
  UToolButtonEx in 'UToolButtonEx.pas',
  UTVCheckBoxes in 'UTVCheckBoxes.pas',
  UUIWidgetImages in 'UUIWidgetImages.pas',
  UUniqueID in 'UUniqueID.pas',
  UUnitAnalyser in 'UUnitAnalyser.pas',
  UUnitsChkListMgr in 'UUnitsChkListMgr.pas',
  UURIEncode in 'UURIEncode.pas',
  UUrl in 'UUrl.pas',
  UUrlMonEx in 'UUrlMonEx.pas',
  UUserDBBackup in 'UUserDBBackup.pas',
  UUserDBMgr in 'UUserDBMgr.pas',
  UUserDBMove in 'UUserDBMove.pas',
  UUtils in 'UUtils.pas',
  UVersionInfo in 'UVersionInfo.pas',
  UView in 'UView.pas',
  UViewItemAction in 'UViewItemAction.pas',
  UViewItemTreeNode in 'UViewItemTreeNode.pas',
  UWaitForThreadUI in 'UWaitForThreadUI.pas',
  UWarnings in 'UWarnings.pas',
  UWBCommandBars in 'UWBCommandBars.pas',
  UWBExternal in 'UWBExternal.pas',
  UWBPopupMenus in 'UWBPopupMenus.pas',
  UWindowSettings in 'UWindowSettings.pas',
  UXMLDocConsts in 'UXMLDocConsts.pas',
  UXMLDocHelper in 'UXMLDocHelper.pas',
  UXMLDocumentEx in 'UXMLDocumentEx.pas',
  FmDeleteUserDBDlg in 'FmDeleteUserDBDlg.pas' {DeleteUserDBDlg},
  Compilers.UAutoDetect in 'Compilers.UAutoDetect.pas',
  Compilers.USettings in 'Compilers.USettings.pas',
  FmRegisterCompilersDlg in 'FmRegisterCompilersDlg.pas' {RegisterCompilersDlg},
  ClassHelpers.UGraphics in 'ClassHelpers.UGraphics.pas',
  ClassHelpers.UActions in 'ClassHelpers.UActions.pas';

// Include resources
{$Resource ExternalObj.tlb}       // Type library file
{$Resource HTML.res}              // HTML resources
{$IFNDEF PORTABLE}
{$Resource VCodeSnip.res}         // Version information resource (normal)
{$ELSE}
{$Resource VCodeSnipPortable.res} // Version information resource (portable)
{$ENDIF}
{$Resource Resources.res}         // All other resources.

begin
  ReportMemoryLeaksOnShutdown := DebugHook <> 0;
  Application.Initialize;
  Application.MainFormOnTaskBar := True;
  if not TStartUp.Execute then
  begin
    Application.Terminate;
    Exit;
  end;
  SplashForm := TSplashForm.Create(Application);
  SplashForm.Show;
  Application.ModalPopupMode := pmAuto;
  Application.ProcessMessages;
  Application.CreateForm(TMainForm, MainForm);
  Application.Run;
end.

