/*
 * CloudBeaver - Cloud Database Manager
 * Copyright (C) 2020-2024 DBeaver Corp and others
 *
 * Licensed under the Apache License, Version 2.0.
 * you may not use this file except in compliance with the License.
 */
import { importLazyComponent } from '@cloudbeaver/core-blocks';
import { Bootstrap, injectable } from '@cloudbeaver/core-di';

import { UserProfileFormService } from '../UserProfileFormService.js';
import { getUserProfileFormInfoPart } from './getUserProfileFormInfoPart.js';

const UserProfileFormInfo = importLazyComponent(() => import('./UserProfileFormInfo.js').then(m => m.UserProfileFormInfo));

@injectable()
export class UserProfileFormInfoPartBootstrap extends Bootstrap {
  constructor(private readonly userProfileFormService: UserProfileFormService) {
    super();
  }

  override register(): void {
    this.userProfileFormService.parts.add({
      key: 'info',
      name: 'plugin_user_profile_info',
      order: 1,
      panel: () => UserProfileFormInfo,
      stateGetter: props => () => getUserProfileFormInfoPart(props.formState),
    });
  }
}
