/*
 * CloudBeaver - Cloud Database Manager
 * Copyright (C) 2020-2024 DBeaver Corp and others
 *
 * Licensed under the Apache License, Version 2.0.
 * you may not use this file except in compliance with the License.
 */
export default [
  ['authentication_administration_user_connections_user_add', 'User Creation'],
  ['authentication_administration_user_connections_user_new', 'New user'],
  ['authentication_administration_user_connections_access_load_fail', "User's granted connections loading failed"],
  ['authentication_administration_user_connections_access_connections_load_fail', 'Connections loading failed'],
  ['authentication_administration_user_connections_access', 'Connections Access'],
  ['authentication_administration_user_connections_access_granted_by', 'Granted by'],
  ['authentication_administration_user_connections_access_granted_team', 'Team:'],
  ['authentication_administration_user_connections_access_granted_directly', 'Directly'],
  ['authentication_administration_user_connections_access_granted_unmanaged', 'Unmanaged'],
  ['authentication_administration_user_connections_empty', 'No available connections'],
  ['authentication_administration_user_origin_empty', 'No available details'],
  ['authentication_administration_user_info', 'Info'],
  ['authentication_administration_user_local', 'Local user'],
  ['authentication_administration_user_auth_method', 'Auth Method'],
  ['authentication_administration_user_auth_methods', 'Auth Methods'],
  ['authentication_administration_user_auth_methods_empty', 'No available auth methods'],
  ['authentication_administration_user_auth_method_no_details', 'No details available'],
  ['authentication_administration_item', 'Users and Teams'],
  ['authentication_administration_item_users', 'Users'],
  ['authentication_administration_item_metaParameters', 'Meta Parameters'],
  ['authentication_administration_tools_add_tooltip', 'Create new user'],
  ['authentication_administration_tools_refresh_tooltip', 'Refresh user list'],
  ['authentication_administration_tools_delete_tooltip', 'Delete selected users'],
  ['authentication_administration_tools_refresh_success', 'User list was refreshed'],
  ['authentication_administration_tools_refresh_fail', 'Users update failed'],
  ['authentication_administration_user_delete_fail', 'Error deleting user'],
  ['authentication_administration_user_update_failed', 'Error saving user'],
  ['authentication_administration_user_updated', 'User updated'],
  ['authentication_administration_user_created', 'User was created successfully'],
  ['authentication_administration_user_create_failed', 'Error creating new user'],
  ['authentication_administration_users_delete_confirmation', "You're going to delete these users: "],
  ['authentication_administration_users_filters_search_placeholder', 'Search for the user name...'],
  ['authentication_administration_users_filters_status_enabled', 'ENABLED'],
  ['authentication_administration_users_filters_status_disabled', 'DISABLED'],
  ['authentication_administration_users_filters_status_all', 'ALL'],
  ['authentication_administration_users_empty', 'There are no users'],
  ['authentication_administration_users_delete_user', 'Delete user'],
  ['authentication_administration_users_delete_user_fail', 'Failed to delete user'],
  ['authentication_administration_users_delete_user_success', 'User deleted'],
  ['authentication_administration_users_disable_user_fail', 'Failed to disable user'],
  ['authentication_administration_users_disable_user_success', 'User disabled'],
  [
    'authentication_administration_users_delete_user_confirmation_input_description',
    'Please type in the username of the account to confirm its deletion.',
  ],
  ['authentication_administration_users_delete_user_confirmation_input_placeholder', 'Type username here...'],
  [
    'authentication_administration_users_delete_user_disable_info',
    'Are you sure you want to delete "{arg:username}"? If you just want to prevent access temporarily, you can choose to disable the account instead.',
  ],
  [
    'authentication_administration_users_delete_user_info',
    'Deleting this account will permanently remove all associated user data from the system. Please confirm you want to proceed with deletion of "{arg:username}" user.',
  ],

  ['authentication_administration_user_delete_credentials_error', 'Failed to remove user credentials'],
  ['authentication_administration_user_delete_credentials_success', 'User credentials were removed'],
  [
    'authentication_administration_user_delete_credentials_confirmation_message',
    'Are you sure you want to delete "{arg:originName}" auth method from "{arg:userId}"?',
  ],

  ['administration_configuration_wizard_configuration_admin', 'Administrator Credentials'],
  ['administration_configuration_wizard_configuration_admin_name', 'Login'],
  ['administration_configuration_wizard_configuration_admin_password', 'Password'],
  ['administration_configuration_wizard_configuration_anonymous_access', 'Allow anonymous access'],
  ['administration_configuration_wizard_configuration_anonymous_access_description', 'Allows to work with CloudBeaver without user authentication'],
  ['administration_configuration_wizard_configuration_authentication_group', 'Authentication settings'],
  ['administration_configuration_wizard_configuration_services_group', 'Services'],
  ['administration_configuration_wizard_configuration_services', 'Services'],
  ['administration_configuration_wizard_configuration_authentication', 'Enable users authentication'],
  [
    'administration_configuration_wizard_configuration_authentication_description',
    'Allows users to authenticate. Otherwise only anonymous access is enabled',
  ],

  ['administration_identity_providers_tab_title', 'Identity Providers'],
  ['administration_identity_providers_provider', 'Provider'],
  ['administration_identity_providers_provider_id', 'ID'],
  ['administration_identity_providers_provider_configuration_name', 'Configuration name'],
  ['administration_identity_providers_provider_configuration_disabled', 'Disabled'],
  ['administration_identity_providers_provider_configuration_description', 'Description'],
  ['administration_identity_providers_provider_configuration_icon_url', 'Icon URL'],
  ['administration_identity_providers_provider_configuration_parameters', 'Parameters'],
  ['administration_identity_providers_provider_configuration_links', 'Links'],
  ['administration_identity_providers_provider_configuration_links_metadata', 'Download metadata file'],
  ['administration_identity_providers_wizard_description', 'Add identity providers'],
  ['administration_identity_providers_configuration_add', 'Configuration creation'],
  ['administration_identity_providers_choose_provider_placeholder', 'Select provider...'],
  ['administration_identity_providers_choose_provider_placeholder_empty', 'No available providers'],
  ['administration_identity_providers_add_tooltip', 'Add new configuration'],
  ['administration_identity_providers_refresh_tooltip', 'Refresh configuration list'],
  ['administration_identity_providers_delete_tooltip', 'Delete selected configurations'],
  ['administration_identity_providers_delete_confirmation', "You're going to delete these configurations: "],
  ['administration_identity_providers_provider_save_error', 'Save configuration error'],
  ['administration_identity_providers_provider_create_error', 'Create configuration error'],
  ['administration_identity_providers_configuration_list_update_success', 'Configuration list was refreshed'],
  ['administration_identity_providers_configuration_list_update_fail', 'Configuration list refresh failed'],
  ['administration_identity_providers_service_link', 'Edit configurations'],

  ['administration_teams_tab_title', 'Teams'],
  ['administration_teams_tab_description', 'Team management'],
  ['administration_teams_team_creation', 'Team Creation'],
  ['administration_teams_team_id', 'Team ID'],
  ['administration_teams_team_name', 'Team name'],
  ['administration_teams_team_description', 'Description'],
  ['administration_teams_team_permissions', 'Permissions'],
  ['administration_teams_team_create_error', 'Create team error'],
  ['administration_teams_team_save_error', 'Save team error'],
  ['administration_teams_team_list_update_success', 'Team list was refreshed'],
  ['administration_teams_team_list_update_fail', 'Team list refresh failed'],
  ['administration_teams_team_info_created', 'Team created'],
  ['administration_teams_team_info_updated', 'Team updated'],
  ['administration_teams_team_info_id_invalid', "Field '{alias:administration_teams_team_id}' can't be empty"],
  ['administration_teams_team_info_exists', "A team with ID '{arg:teamId}' already exists"],
  ['administration_teams_add_tooltip', 'Add new team'],
  ['administration_teams_refresh_tooltip', 'Refresh team list'],
  ['administration_teams_delete_tooltip', 'Delete selected teams'],
  ['administration_teams_delete_confirmation', "You're going to delete these teams: "],
  ['administration_teams_delete_confirmation_users_note', 'Note that users will lose their team affiliation and all associated permissions'],

  ['administration_teams_team_granted_users_tab_title', 'Users'],
  ['administration_teams_team_granted_users_search_placeholder', 'Search for user ID...'],
  ['administration_teams_team_granted_users_user_id', 'User ID'],
  ['administration_teams_team_granted_users_user_name', 'User name'],
  ['administration_teams_team_granted_users_empty', 'No available users'],
  ['administration_teams_team_granted_users_permission_denied', "You can't edit your own permissions"],

  ['administration_teams_team_granted_connections_tab_title', 'Connections'],
  ['administration_teams_team_granted_connections_search_placeholder', 'Search for connection name...'],
  ['administration_teams_team_granted_connections_empty', 'No available connections'],

  ['plugin_authentication_administration_user_team_default_readonly_tooltip', "Default team. Can't be revoked"],
  ['plugin_authentication_administration_team_default_users_tooltip', 'Default team. Contains all users'],
  ['plugin_authentication_administration_team_user_team_role_supervisor', 'Supervisor'],
  ['plugin_authentication_administration_team_user_team_role_supervisor_description', 'Supervisors can view their team’s executed queries'],

  ['plugin_authentication_administration_team_form_edit_label', 'Team editing form'],
  ['plugin_authentication_administration_user_form_edit_label', 'User editing form'],
];
