/*
 * CloudBeaver - Cloud Database Manager
 * Copyright (C) 2020-2024 DBeaver Corp and others
 *
 * Licensed under the Apache License, Version 2.0.
 * you may not use this file except in compliance with the License.
 */
export default [
  ['administration_server_configuration_save_confirmation_title', 'Server settings update'],
  ['administration_server_configuration_save_confirmation_message', 'You are about to change critical settings. Are you sure?'],

  ['administration_configuration_wizard_welcome', 'Welcome'],
  ['administration_configuration_wizard_welcome_step_description', 'Welcome to {alias:product_full_name}'],
  ['administration_configuration_wizard_welcome_title', 'Welcome to {alias:product_full_name}, cloud database management system!'],
  [
    'administration_configuration_wizard_welcome_message',
    'The easy configuration wizard will guide you through several simple steps to set up the server. You will need to set server information and administrator credentials. You can set up additional server parameters once the easy configuration is completed.',
  ],
  [
    'administration_configuration_wizard_welcome_note',
    'Note: you will be able to change these configuration parameters later on the administration panel.',
  ],

  ['administration_configuration_wizard_configuration', 'Server Configuration'],
  ['administration_configuration_wizard_configuration_step_description', 'Main server configuration'],
  ['administration_configuration_wizard_configuration_title', 'You can configure the main server parameters here.'],
  ['administration_configuration_wizard_configuration_save_error', 'Failed to save server configuration'],
  [
    'administration_configuration_wizard_configuration_message',
    'You will be able to add additional services after the server configuration.\n\rAdministrator is a super user who can configure server, set databases connections, manage other users and much more. Please, remember the entered password. It is not possible to recover administrator password automatically.',
  ],

  ['administration_configuration_tools_save_tooltip', 'Save configuration'],
  ['administration_configuration_tools_cancel_tooltip', 'Reset changes'],

  ['administration_configuration_wizard_configuration_server_info', 'Server Information'],
  ['administration_configuration_wizard_configuration_server_name', 'Server Name'],
  ['administration_configuration_wizard_configuration_server_url', 'Server URL'],
  ['administration_configuration_wizard_configuration_server_url_description', 'Global access server url'],
  ['administration_configuration_wizard_configuration_server_info_unsaved_title', 'Unsaved settings'],
  ['administration_configuration_wizard_configuration_server_info_unsaved_message', 'Settings can be saved on Server configuration page'],
  ['administration_configuration_wizard_configuration_server_info_unsaved_navigate', 'Open'],
  ['administration_configuration_wizard_configuration_server_session_lifetime', 'Session lifetime, min'],
  [
    'administration_configuration_wizard_configuration_server_session_lifetime_description',
    'Here you may specify the number of minutes that you wish the session to be allowed to remain idle before it expires',
  ],

  ['administration_configuration_wizard_configuration_plugins', 'Configuration'],
  ['administration_configuration_wizard_configuration_custom_connections', 'Enable private connections'],
  ['administration_configuration_wizard_configuration_custom_connections_description', 'Allows users to create private connections'],
  ['administration_configuration_wizard_configuration_navigation_tree_view', 'Navigator simple view'],
  [
    'administration_configuration_wizard_configuration_navigation_tree_view_description',
    "By default, all user's new connections will contain only basic information in navigation tree",
  ],

  ['administration_configuration_wizard_configuration_security', 'Security'],
  ['administration_configuration_wizard_configuration_security_admin_credentials', 'Save credentials'],
  [
    'administration_configuration_wizard_configuration_security_admin_credentials_description',
    'Allow to save credentials for pre-configured database',
  ],
  ['administration_configuration_wizard_configuration_security_public_credentials', 'Save users credentials'],
  ['administration_configuration_wizard_configuration_security_public_credentials_description', 'Allow to save credentials for non-admin users'],

  ['administration_configuration_wizard_configuration_navigator', 'Navigator'],
  ['administration_configuration_wizard_configuration_navigator_hide_folders', 'Hide Folders'],
  ['administration_configuration_wizard_configuration_navigator_hide_schemas', 'Hide Schemas'],
  ['administration_configuration_wizard_configuration_navigator_hide_virtual_model', 'Hide Virtual Model'],
  ['administration_configuration_wizard_configuration_navigator_merge_entities', 'Merge Entities'],
  ['administration_configuration_wizard_configuration_navigator_show_only_entities', 'Only Entities'],
  ['administration_configuration_wizard_configuration_navigator_show_system_objects', 'System Objects'],
  ['administration_configuration_wizard_configuration_navigator_show_utility_objects', 'Utility Objects'],

  ['administration_configuration_wizard_step_validation_message', 'Failed to proceed to the next step'],

  ['administration_configuration_wizard_finish', 'Confirmation'],
  ['administration_configuration_wizard_finish_step_description', 'Confirmation'],
  ['administration_configuration_wizard_finish_title', 'That is almost it.'],
  [
    'administration_configuration_wizard_finish_message',
    'Press the Finish button to complete the server configuration. You can return to the previous pages if you want to change or add something.\nWhen the configuration is completed all entered settings will be applied for your server. You will be redirected to the main page to start working.\nYou can always login to the system as administrator to change the server settings.',
  ],

  ['administration_disabled_drivers_title', 'Disabled drivers'],
  ['administration_disabled_drivers_search_placeholder', 'Search for the driver...'],
];
