/*
 * CloudBeaver - Cloud Database Manager
 * Copyright (C) 2020-2024 DBeaver Corp and others
 *
 * Licensed under the Apache License, Version 2.0.
 * you may not use this file except in compliance with the License.
 */
import { describe, expect, it } from '@jest/globals';
import { waitFor } from '@testing-library/react';

import { createApp, renderInApp } from '@cloudbeaver/tests-runner';

import { TextPlaceholder } from './TextPlaceholder.js';

const app = createApp();

describe('TextPlaceholder Component', () => {
  it('renders children correctly', async () => {
    const { getByText } = renderInApp(<TextPlaceholder>Hello World</TextPlaceholder>, app);
    const text = await waitFor(() => getByText('Hello World'));
    expect(text).toBeInTheDocument();
  });

  it('applies custom className', () => {
    const { container } = renderInApp(<TextPlaceholder className="custom-class">Hello World</TextPlaceholder>, app);
    expect(container.getElementsByClassName('custom-class')).toHaveLength(1);
  });
});
