CREATE TABLE {table_prefix}CB_OBJECT_PERMISSIONS
(
    OBJECT_ID   VARCHAR(128) NOT NULL,
    OBJECT_TYPE VARCHAR(128) NOT NULL,
    SUBJECT_ID  VARCHAR(128) NOT NULL,

    PERMISSION  VARCHAR(32)  NOT NULL,

    GRANT_TIME  TIMESTAMP    NOT NULL,
    GRANTED_BY  VARCHAR(128) NOT NULL,

    PRIMARY KEY (SUBJECT_ID, OBJECT_TYPE, OBJECT_ID, PERMISSION),
    FOREIGN KEY (SUBJECT_ID) REFERENCES {table_prefix}CB_AUTH_SUBJECT (SUBJECT_ID) ON DELETE CASCADE
);

INSERT INTO {table_prefix}CB_OBJECT_PERMISSIONS (OBJECT_ID, OBJECT_TYPE, SUBJECT_ID, PERMISSION, GRANTED_BY, GRANT_TIME)
SELECT DA.DATASOURCE_ID, 'datasource', DA.SUBJECT_ID, 'access', DA.GRANTED_BY, DA.GRANT_TIME
FROM {table_prefix}CB_DATASOURCE_ACCESS DA;

DROP TABLE {table_prefix}CB_DATASOURCE_ACCESS;