CREATE TABLE {table_prefix}CB_AUTH_ATTEMPT
(
    AUTH_ID           VARCHAR(128) NOT NULL,
    AUTH_STATUS       VARCHAR(32)  NOT NULL,
    AUTH_ERROR        TEXT,
    APP_SESSION_ID    VARCHAR(64)  NOT NULL,
    SESSION_ID        VARCHAR(64),
    SESSION_TYPE      VARCHAR(64)  NOT NULL,
    APP_SESSION_STATE TEXT         NOT NULL,

    CREATE_TIME       TIMESTAMP    DEFAULT CURRENT_TIMESTAMP NOT NULL,

    PRIMARY KEY (AUTH_ID),
    FOREIGN KEY (SESSION_ID) REFERENCES {table_prefix}CB_SESSION (SESSION_ID) ON DELETE CASCADE
);

CREATE TABLE {table_prefix}CB_AUTH_ATTEMPT_INFO
(
    AUTH_ID                        VARCHAR(128) NOT NULL,
    AUTH_PROVIDER_ID               VARCHAR(128) NOT NULL,
    AUTH_PROVIDER_CONFIGURATION_ID VARCHAR(128),
    AUTH_STATE                     TEXT         NOT NULL,

    CREATE_TIME                    TIMESTAMP    DEFAULT CURRENT_TIMESTAMP NOT NULL,

    PRIMARY KEY (AUTH_ID, AUTH_PROVIDER_ID),
    FOREIGN KEY (AUTH_ID) REFERENCES {table_prefix}CB_AUTH_ATTEMPT (AUTH_ID) ON DELETE CASCADE
);