/*
 * DBeaver - Universal Database Manager
 * Copyright (C) 2010-2024 DBeaver Corp and others
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.cloudbeaver.server.websockets;

import io.cloudbeaver.model.session.BaseWebSession;
import io.cloudbeaver.model.session.WebHeadlessSession;
import org.eclipse.jetty.websocket.api.Callback;
import org.jkiss.code.NotNull;

public class WebSocketPingPongCallback implements Callback {
    @NotNull
    private final BaseWebSession webSession;

    public WebSocketPingPongCallback(@NotNull BaseWebSession webSession) {
        this.webSession = webSession;
    }

    @Override
    public void succeed() {
        if (webSession instanceof WebHeadlessSession) {
            webSession.touchSession();
        }
    }
}
